/*
 * Gearcoleco - ColecoVision Emulator
 * Copyright (C) 2021  Ignacio Sanchez

 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * any later version.

 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.

 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see http://www.gnu.org/licenses/
 *
 */

#ifndef GUI_H
#define	GUI_H

#include "imgui/imgui.h"
#include "config.h"

#ifdef GUI_IMPORT
    #define EXTERN
#else
    #define EXTERN extern
#endif

enum gui_ShortCutEvent
{
    gui_ShortcutOpenROM = 0,
    gui_ShortcutReset,
    gui_ShortcutPause,
    gui_ShortcutFFWD,
    gui_ShortcutSaveState,
    gui_ShortcutLoadState,
    gui_ShortcutScreenshot,
    gui_ShortcutDebugStep,
    gui_ShortcutDebugContinue,
    gui_ShortcutDebugNextFrame,
    gui_ShortcutDebugBreakpoint,
    gui_ShortcutDebugRuntocursor,
    gui_ShortcutDebugGoBack,
    gui_ShortcutDebugCopy,
    gui_ShortcutDebugPaste,
    gui_ShortcutShowMainMenu
};

struct gui_HotkeyMapping
{
    int shortcut;
    int config_index;
    bool allow_repeat;
};

#define GUI_HOTKEY_MAP_COUNT 14

const gui_HotkeyMapping gui_hotkey_map[GUI_HOTKEY_MAP_COUNT] = {
    {gui_ShortcutOpenROM, config_HotkeyIndex_OpenROM, false},
    {gui_ShortcutReset, config_HotkeyIndex_Reset, false},
    {gui_ShortcutPause, config_HotkeyIndex_Pause, false},
    {gui_ShortcutFFWD, config_HotkeyIndex_FFWD, false},
    {gui_ShortcutSaveState, config_HotkeyIndex_SaveState, false},
    {gui_ShortcutLoadState, config_HotkeyIndex_LoadState, false},
    {gui_ShortcutScreenshot, config_HotkeyIndex_Screenshot, false},
    {gui_ShortcutShowMainMenu, config_HotkeyIndex_ShowMainMenu, false},
    {gui_ShortcutDebugStep, config_HotkeyIndex_DebugStep, true},
    {gui_ShortcutDebugContinue, config_HotkeyIndex_DebugContinue, true},
    {gui_ShortcutDebugNextFrame, config_HotkeyIndex_DebugNextFrame, true},
    {gui_ShortcutDebugRuntocursor, config_HotkeyIndex_DebugRunToCursor, false},
    {gui_ShortcutDebugBreakpoint, config_HotkeyIndex_DebugBreakpoint, false},
    {gui_ShortcutDebugGoBack, config_HotkeyIndex_DebugGoBack, false},
};

EXTERN bool gui_in_use;
EXTERN bool gui_main_window_hovered;
EXTERN bool gui_main_menu_hovered;
EXTERN ImFont* gui_default_font;
EXTERN ImFont* gui_roboto_font;
EXTERN config_Hotkey* gui_configured_hotkey;

EXTERN bool gui_init(void);
EXTERN void gui_destroy(void);
EXTERN void gui_render(void);
EXTERN void gui_shortcut(gui_ShortCutEvent event);
EXTERN void gui_load_rom(const char* path);
EXTERN void gui_set_status_message(const char* message, u32 milliseconds);

#undef GUI_IMPORT
#undef EXTERN
#endif	/* GUI_H */
