; MXO-R210.ASM -- TRS-80 MODEL II OVERLAY FILE FOR MEX10.  05/25/84
;
; YOU WILL WANT TO LOOK THIS FILE OVER CAREFULLY. THERE ARE A NUMBER OF
; OPTIONS THAT YOU CAN USE TO CONFIGURE THE PROGRAM TO SUIT YOUR TASTE.
; THIS FILE ADAPTS THE TRS-80 MODEL II/12/16.
; COMPUTERS TO MEX10.				     
;
;
; EDIT THIS FILE FOR YOUR PREFERENCES THEN FOLLOW THE "TO USE:" EXAMPLE
; SHOWN BELOW.
;
; USE THE "SET" COMMAND TO CHANGE THE BAUDRATE WHEN DESIRED.  IT STARTS
; OUT AT THE BAUD RATE THAT WAS LAST SET BY CP/M OR THIS PROGRAM.
;
;
;	TO USE: FIRST EDIT THIS FILE FILLING IN ANSWERS FOR YOUR OWN
;		EQUIPMENT.  THEN ASSEMBLE WITH ASM.COM OR EQUIVALENT
;		ASSEMBLER.  THEN USE MLOAD TO OVERLAY THE THE RESULTS
;		OF THIS PROGRAM TO THE ORIGINAL .COM FILE.
;
; =   =   =   =   =   =   =   =   =   =   =   =   =   =   =   =   =   =
; 05/25/84 - MEXIFIED THE OVERLAY.		- BIFF BUEFFEL
; 11/11/83 - RENAMED TO M7R2-1.ASM, NO CHANGES	- IRV HOFF
; 09/18/83 - MODIFIED M712XE.ASM FOR 
;	     TRS-80 MODEL II AND PICKLES
;	     & TROUT CP/M (SHOULD ALSO 
;	     WORK ON MODS 12 AND 16)		- JOSEPH KATZ
; 03/20/84 - MODIFIED OVERLAY TO WORK WITH ANY CP/M
;	     AVAILABLE FOR MODS 2/12/16 	- LARRY WINKLER
;
; 10/17/84 - MODIFIED OVERLAY SO THAT THE 'DTR' WOULD STAY ON
;						   BOB WILLIAMS
; =   =   =   =   =   =   =   =   =   =   =   =   =   =   =   =   =   =
;
BELL:		EQU	07H		;BELL
CR:		EQU	0DH		;CARRIAGE RETURN
ESC:		EQU	1BH		;ESCAPE
LF:		EQU	0AH		;LINEFEED
;
YES:		EQU	0FFH
NO:		EQU	0
;
; MEX service processor stuff
;
MEX	EQU	0D00H		;address of the service processor
INMDM	EQU	255		;get char from port to A, CY=no more in 100 ms
TIMER	EQU	254		;delay 100ms * reg B
TMDINP	EQU	253		;B=# secs to wait for char, cy=no char
CHEKCC	EQU	252		;check for ^C from KBD, Z=present
SNDRDY	EQU	251		;test for modem-send ready
RCVRDY	EQU	250		;test for modem-receive ready
SNDCHR	EQU	249		;send a character to the modem (after sndrdy)
RCVCHR	EQU	248		;recv a char from modem (after rcvrdy)
LOOKUP	EQU	247		;table search: see CMDTBL comments for info
PARSFN	EQU	246		;parse filename from input stream
BDPARS	EQU	245		;parse baud-rate from input stream
SBLANK	EQU	244		;scan input stream to next non-blank
EVALA	EQU	243		;evaluate numeric from input stream
LKAHED	EQU	242		;get nxt char w/o removing from input
GNC	EQU	241		;get char from input, cy=1 if none
ILP	EQU	240		;inline print
DECOUT	EQU	239		;decimal output
PRBAUD	EQU	238		;print baud rate
;
PRINT	EQU	9		;MEX/BDOS print-string function call

;
PORT:		EQU	0F4H		;TRS-80 II SERIAL OUTPUT PORT A
MODCTL1:	EQU	PORT+2		;MODEM CONTROL PORT
MODDATP:	EQU	PORT		;MODEM DATA PORT
MODCTL2:	EQU	PORT+2		;MODEM STATUS PORT
MODRCVB:	EQU	01H		;BIT TO TEST FOR RECEIVE
MODRCVR:	EQU	01H		;VALUE WHEN RECEIVE READY
MODSNDB:	EQU	04H		;BIT TO TEST FOR SEND
MODSNDR:	EQU	04H		;VALUE WHEN SEND READY		
;
;
		ORG	100H
;
;
; CHANGE THE CLOCK SPEED TO SUIT YOUR SYSTEM
;
		DS	3	;(FOR  "JMP   START" INSTRUCTION)
;
		DB	NO	;YES=PMMI S-100 MODEM			103H
		DB	NO	;YES=HAYES SMARTMODEM, NO=NON-PMMI	104H
TOUCHPULSE:	DB	'T'	;T=TOUCH, P=PULSE (SMARTMODEM-ONLY)	105H
CLOCK:		DB	40	;CLOCK SPEED IN MHZ X10, 25.5 MHZ MAX.	106H
				;20=2 MHH, 37=3.68 MHZ, 40=4 MHZ, ETC.
MSPEED: 	DB	1	;0=110 1=300 2=450 3=600 4=710 5=1200	107H
				;6=2400 7=4800 8=9600 9=19200 DEFAULT
BYTDLY: 	DB	0	;0=0 DELAY  1=10MS  5=50 MS - 9=90 MS	108H
				;DEFAULT TIME TO SEND CHARACTER IN TER-
				;MINAL MODE FILE TRANSFER FOR SLOW BBS.
CRDLY:		DB	0	;0=0 DELAY 1=100 MS 5=500 MS - 9=900 MS 109H
				;DEFAULT TIME FOR EXTRA WAIT AFTER CRLF
				;IN TERMINAL MODE FILE TRANSFER
NOOFCOL:	DB	5	;NUMBER OF DIR COLUMNS SHOWN		10AH
SETUPTST:	DB	YES	;YES=USER-ADDED SETUP ROUTINE		10BH
SCRNTEST:	DB	YES	;CURSOR CONTROL ROUTINE 		10CH
ACKNAK: 	DB	YES	;YES=RESEND A RECORD AFTER ANY NON-ACK	10DH
				;NO=RESEND A RECORD AFTER A VALID NAK
BAKUPBYTE:	DB	YES	;YES=CHANGE ANY FILE SAME NAME TO .BAK	10EH
CRCDFLT:	DB	YES	;YES=DEFAULT TO CRC CHECKING		10FH
TOGGLECRC:	DB	YES	;YES=ALLOW TOGGLING OF CRC TO CHECKSUM	110H
CONVBKSP:	DB	NO	;YES=CONVERT BACKSPACE TO RUB		111H
TOGGLEBK:	DB	YES	;YES=ALLOW TOGGLING OF BKSP TO RUB	112H
ADDLF:		DB	NO	;NO=NO LF AFTER CR TO SEND FILE IN	113H
				;TERMINAL MODE (ADDED BY REMOTE ECHO)
TOGGLELF:	DB	YES	;YES=ALLOW TOGGLING OF LF AFTER CR	114H
TRANLOGON:	DB	NO     ;YES=ALLOW TRANSMISSION OF LOGON        115H
				;WRITE LOGON SEQUENCE AT LOCATION LOGON
SAVCCP: 	DB	YES	;YES=DO NOT OVERWRITE CCP		116H
LOCONEXTCHR:	DB	NO	;YES=LOCAL COMMAND IF EXTCHR PRECEDES	117H
				;NO=EXTERNAL COMMAND IF EXTCHR PRECEDES
TOGGLELOC:	DB	YES	;YES=ALLOW TOGGLING OF LOCONEXTCHR	118H
LSTTST: 	DB	YES	;YES=PRINTER AVAILABLE ON PRINTER PORT	119H
XOFFTST:	DB	NO	;YES=CHECK FOR XOFF FROM REMOTE WHILE	11AH
				;SENDING A FILE IN TERMINAL MODE
XONWAIT:	DB	NO	;YES=WAIT FOR XON AFTER CR WHILE	11BH
				;SENDING A FILE IN TERMINAL MODE
TOGXOFF:	DB	YES	;YES=ALLOW TOGGLING OF XOFF CHECKING	11CH
IGNORCTL:	DB	YES	;YES=CTL-CHARS ABOVE ^M NOT DISPLAYED	11DH
EXTRA1: 	DB	0	;FOR FUTURE EXPANSION			11EH
EXTRA2: 	DB	0	;FOR FUTURE EXPANSION			11FH
BRKCHR: 	DB	'@'-40H ;^@ = SEND A 300 MS. BREAK TONE 	120H
NOCONNCT:	DB	'N'-40H ;^N = DISCONNECT FROM THE PHONE LINE	121H
LOGCHR: 	DB	'L'-40H ;^L = SEND LOGON			122H
LSTCHR: 	DB	'P'-40H ;^P = TOGGLE PRINTER			123H
UNSAVE: 	DB	'R'-40H ;^R = CLOSE INPUT TEXT BUFFER		124H
TRANCHR:	DB	'T'-40H ;^T = TRANSMIT FILE TO REMOTE		125H
SAVECHR:	DB	'Y'-40H ;^Y = OPEN INPUT TEXT BUFFER		126H
EXTCHR: 	DB	'^'-40H ;^^ = SEND NEXT CHARACTER		127H
;
;
		DS	2		;				128H
IN$MODCTL1:	MVI	A,10H		;CHANNEL 0, RESET INTERRUPTS	12AH
		OUT	MODCTL1
		IN	MODCTL1 	;GET THE STATUS BITS
		RET
		DS	3
;
OUT$MODDATP:	OUT	MODDATP ! RET	;OUT MODEM DATA PORT		134H
		DS	7
IN$MODDATP:	IN	MODDATP ! RET	;IN MODEM DATA PORT		13EH
		DS	7
ANI$MODRCVB:	ANI	MODRCVB ! RET	;BIT TO TEST FOR RECEIVE READY	148H
CPI$MODRCVR:	CPI	MODRCVR ! RET	;VALUE OF RECEIVE BIT WHEN RDY	14BH
ANI$MODSNDB:	ANI	MODSNDB ! RET	;BIT TO TEST FOR SEND READY	14EH
CPI$MODSNDR:	CPI	MODSNDR ! RET	;VALUE OF SEND BIT WHEN READY	151H
		DS	6		;				154H
OUT$MODCTL1:	OUT	MODCTL1 ! RET	;OUT MODEM CONTROL PORT 	15AH
OUT$MODCTL2:	OUT	MODCTL2 ! RET	;OUT MODEM STATUS PORT		15DH
;
;
		DS	2		;NOT USED BY MEX		160H
		DS	6		;				162H
JMP$GOODBYE:	JMP	GOODBYE 	;				168H
JMP$INITMOD:	JMP	INITMOD 	;GO TO USER WRITTEN ROUTINE	16BH
JMP$NEWBAUD	JMP	NEWBAUD 	;CHANGE BAUDRATE		16EH
		RET  !	NOP  !	NOP	;(BY-PASSES PMMI ROUTINE)	171H
		RET  !	NOP  !	NOP	;(BY-PASSES PMMI ROUTINE)	174H
JMP$SETUPR:	JMP	SETUPR		;				177H
		DS	3		;				17AH
JMP$SYSVER:	JMP	SYSVER		;				17DH
JMP$BREAK:	JMP	SENDBRK 	;				180H
;
;
; DO NOT CHANGE THE FOLLOWING SIX LINES.
;
JMP$ILPRT:	DS	3		;				183H
JMP$INBUF	DS	3		;				186H
JMP$INLNCOMP:	DS	3		;				189H
JMP$INMODEM	DS	3		;				18CH
JMP$NXTSCRN:	DS	3		;				18FH
JMP$TIMER:	DS	3		;				192H
;
;
; CLEAR SEQUENCES -- CLREOS IS CLEAR TO END OF SCREEN, CLRSCRN IS CLEAR
; ENTIRE SCREEN.  
;
;
CLREOS: 	LXI	D,EOSMSG
		MVI	C,PRINT
		CALL	MEX
		RET			
;
CLRSCRN:	LXI	D,CLSMSG
		MVI	C,PRINT
		CALL	MEX
		RET			
;
SYSVER: 	MVI	C,ILP	       ;			       1A7H
		CALL	MEX
		DB	'TRS-80 VERSION (FOR SERIAL PORT A)',CR,LF
		DB	CR,LF,0
		RET
;
;
; THIS ROUTINE ALLOWS A 300 MS. BREAK TONE TO BE SENT TO RESET SOME
; TIME-SHAR COMPUTERS.
;
SENDBRK:  MVI	A,5
	  OUT	MODCTL1
	  MVI	A,0F8H		;SEND A BREAK TONE
	  JMP	GOODBYE1
;.....
;
;
; THIS ROUTINE SENDS A 300 MS. BREAK TONE AND SETS DTR LOW FOR THE SAME
; LENGTH OF TIME TO DISCONNECT SOME MODEMS SUCH AS THE BELL 212A, ETC.	
;
GOODBYE:  MVI	A,5
	  OUT	MODCTL1 	;SEND TO THE STATUS PORT
	  MVI	A,68H		;TURN OFF DTR
;
GOODBYE1: OUT	MODCTL1
	  MVI	B,3		;WAIT FOR 300 MS.
	  MVI	C,TIMER
	  CALL	MEX
	  MVI	A,5
	  OUT	MODCTL1
	  MVI	A,0E8H		;RESTORE TO NORMAL, 8 BITS, DTR ON, ETC.
	  OUT	MODCTL1
	  RET
;.....
;
;	
; TRS-80 II INITIALIZATION -- SETS CTC TIMER F0H FOR SEND AND RECEIVE
; BAUDRATE.
;
;
INITMOD1: MVI	A,1		;DEFAULT TRANSFER TIME TO 300 BAUD
	  STA	MSPEED
	  CPI	6
	  JNC	G2400
	  MVI	A,07H		;USED IF <2400 BAUD
	  JMP	DOIT
G2400:	  MVI	A,47H		;IF >= 2400 BAUD
DOIT:	  OUT	0F0H		;SEND TO 'CTC' TIMER
	  OUT	0F1H
;
INITMOD2: MVI	A,34H		;INITIALIZE TO 300 BAUD
	  OUT	0F0H
	  OUT	0F1H
;.....
INITMOD:  MVI	A,18H		;THROW OUT OF MODE
	  OUT	MODCTL1
	  MVI	A,04H		;SELECT REGISTER
	  OUT	MODCTL1
	  MVI	A,44H		;SET ASCII PARAMETERS
	  OUT	MODCTL1
	  MVI	A,01H
	  OUT	MODCTL1
	  MVI	A,00H
	  OUT	MODCTL1
	  MVI	A,03H		;SELECT REG.
	  OUT	MODCTL1
	  MVI	A,0C1H		;ENABLE RECEIVE
	  OUT	MODCTL1
	  MVI	A,05H		;SELECT REG.
	  OUT	MODCTL1
;	  MVI	A,068H		;COMMENTED OUT BY BOB WILLIAMS
;				 NEXT LINE ADDED WAS DROPPING 'DTR'
	  MVI	A,0E8H		;ENABLE SEND, 'DTR', 'RTS'
	  OUT	MODCTL1
	  RET
;
;
; SETUP ROUTINE TO ALLOW CHANGING MODEM SPEED WITH THE SET COMMAND.
;
;
SETUPR:   MVI	C,SBLANK	;Any arguments?
	  CALL	MEX
	  JC	TELL		;If not, go display baud
	  LXI	D,CMDTBL
	  MVI	C,LOOKUP
	  CALL	MEX		;Parse argument
	  PUSH	H		;Save any parsed argument addrs on stack
	  RNC			;If we have one, return to it
	  POP	H		;Oops, input not found in table
	  MVI	C,ILP
	  CALL	MEX		;Tell user input not valid
	  DB	CR,LF,'Only 300 or 1200 allowed on SET command',CR,LF,0
	  RET
;
CMDTBL:   DB	'30','0'+80H
	  DW	OK300
	  DB	'120','0'+80H
	  DW	OK1200
	  DB	0
;
TELL:	  MVI	C,ILP
	  CALL	MEX		;Print current baud rate
	  DB	CR,LF,'Baud rate is now: ',0
	  LDA	MSPEED
	  MVI	C,PRBAUD
	  CALL	MEX
	  RET
;
;
OK110:	  MVI	A,0
	  LHLD	BD110
	  JMP	LOADBD
;
OK300:	  MVI	A,1
	  LHLD	BD300
	  JMP	LOADBD
;
OK600:	  MVI	A,3
	  LHLD	BD600
	  JMP	LOADBD
;
OK1200:   MVI	A,5
	  LHLD	BD1200
	  JMP	LOADBD
;
OK2400:   MVI	A,6
	  LHLD	BD2400
	  JMP	LOADBD
;
OK4800:   MVI	A,7
	  LHLD	BD4800
	  JMP	LOADBD
;
OK9600:   MVI	A,8
	  LHLD	BD9600
;
LOADBD:   STA	INITMOD1+1	;CHANGE TIME-TO-SEND TO MATCH BAUDRATE
	  MOV	A,L		;GET BAUDRATE BYTE
	  STA	INITMOD2+1	;SEND TO 'CTC' TIMER FOR NEW BAUDRATE
	  JMP	INITMOD1	;REINITIALIZE TO NEW BAUDRATE, THEN DONE
;
;
NEWBAUD:  CPI	1
	  JZ	OK300
	  CPI	5
	  JZ	OK1200
	  RET
;
;
; TABLE OF BAUDRATE PARAMETERS
;
BD110:	  DW	008EH ; THESE USE THE 07H COMMAND FIRST TO CTC
BD300:	  DW	0034H
BD600:	  DW	001AH	
BD1200:   DW	000DH
;--------------------------------------------------------------------
BD2400:   DW	0034H ; THESE USE THE 47H COMMAND FIRST TO CTC
BD4800:   DW	001AH
BD9600:   DW	000DH
;
BAUDBUF:  DB	10,0
	  DS	10
;
EOSMSG:   DB	0CH,0,0,0,'$'			
CLSMSG:   DB	0CH,0,0,0,'$'		;1AH IF NOT P&T
;
; NOTE:  MUST TERMINATE PRIOR TO 0B00H (WITH SMARTMODEM)
;				 0D00H (WITHOUT SMARTMODEM)
;
	  END
;
	;1AH IF NOT P&T
;
; NOTE:  MUST TERMINATE PRIOR TO 0B00H (WITH SMARTMODEM)
;				 0D00H (WITHOUT SMA