;####################################################
;
;	DUMBA3.ASM	27-JUL-83  20:30  	
;
;RUDIMENTARY MODEM PRG FOR APPLE/// SOFTCARD/// (Z80)
;SENDS INP FROM CONS TO EXTERN MODEM & RETURNS ECHOED
;CHARS VIA RDR TO CONSOLE; IF NO CHARS IN RS232 INPUT
;BUFFER, CHECKS CONSOLE FOR INPUT;IF NO CONSOLE INPUT,
;CHECKS RDR:, THENCE TO CONSOLE ETC.
;IF CONSOLE INPUT = CTRLZ, TERMINATES PRG.
;N.B. : DRIVER.SOS MUST CONTAIN .RS232 DRIVER.
;SET SOFTCARD/// CONFIG  SO THAT PUN:=PU1:=.RS232.
;RDR:=RD1:=.RS232. IF YOU ARE USING BUILT IN SERIAL
;PORT FOR BOTH OUTPUT TO PRINTER VIA LST: AND
;FOR .RS232, LST: MUST BE SET = .NULL, THAT IS,
;NOT CONFIGURED = .PRINTER.
;###########################P.J. FILLINGHAM##########
;
;	ASCII CHARS
CR	EQU	0DH
LF	EQU	0AH
CTRLZ	EQU	1AH
;
;	CP/M BDOS FUNCS
DIOF	EQU	6
WPUNF	EQU	4
RRDRF	EQU	3
WCONF	EQU	2
RCONF	EQU	1
;
;	CP/M ADDRESSES
RBOOT	EQU	0
BDOS	EQU	5
TPA	EQU	100H
;
	ORG	TPA
START:	LXI	SP,STAK		;SET UP USER'S STACK
START0:	CALL	CCRLF		; START A NEW LINE
	LXI	H,SIGNON	; WITH HEADER
	CALL	COMSG
	MVI	E,0FFH		;TELL DIR I/O TO CHECK CONSOLE
START1:	CALL	CKDIO		;CHK STATUS/GET CHAR FROM CONSOLE
	CALL	RDRST		;CHECK RDR: (.RS232) BUFFER
	CPI	0		;IF EMPTY
	JZ	NOCHAR		;FORGET RDR BUFFER
	CALL	RDRIN		;IF CHAR, GET IT
	MOV	E,A		;PUT CHAR IN E FOR OUPUT TO CONS
	JMP	START1		;DO IT VIA DIRECT I/O
NOCHAR:	MVI	E,0FFH		;TELL DIR I/O TO LOOK FOR CONS CHAR
	JMP	START1		;DO IT
;
RDRST:		;DEVICE STATUS CALL TO SOS .RS232 BUFFER
;
CALL65	EQU	0DF80H		;6502 SUBROUTINE CALLER
XBYTE	EQU	0E5C4H		;ADDRESS OF X-BYTE (=00H)
DEVMGR	EQU	1986H		;ADDR OF DEVICE MANAGER
DINFDT	EQU	16E0H		;=DFE0H (Z80);START OF 32 BYTES
				;OF RET'D DATA
	LXI	H,0DFA0H	;Z80 ADDR OF SOS DEVMGR COMMAND
	MVI	M,02H		; 2 = DEV CALL # FOR STATUS
	INX	H
	MVI	M,02H		;STUFF UNIT # FROM DFB4 INTO DFA1
	INX	H
	MVI	M,03H		;.RS232 SOS STAT CODE 3 INTO DFA2
	INX	H
	MVI	M,0E0H		;LSB OF SOS ADDR OF RETURNED DATA
	INX	H
	MVI	M,016H		;MSB OF SOS ADDR OF RET DATA
	LXI	H,XBYTE		;SOS MEMORY BANK ADDRESS
	MVI	M,00H		;$00 IS SOS MEM BANK OF DFE0
	LXI	H,DEVMGR	;SOS DEV MGR ENTRY POINT
	CALL	CALL65		;6502 SUBR CALLER
	LDA	0DFE6H		;NO. OF CHARS RDR BUFFER => (DFE6)
	RET
;
;	OUTPUT CHAR FROM CONSOLE TO PUN: (THUS TO MODEM)
;
PUNOUT:	PUSH	B		;SAVE REGISTERS
	PUSH	D
	PUSH	H
	MVI	C,WPUNF		;OUTPUT CHARS TO PUN:
	MOV	E,A
	CALL 	BDOS
	POP	H		;RESTORE REGS
	POP	D
	POP	B
	RET
;
;GET A CHAR FROM RDR:
;
RDRIN:	PUSH	B		;SAVE YE OLDE REGS
	PUSH	D
	PUSH	H
	MVI	C,RRDRF		;GET CHAR FROM RDR:
	CALL	BDOS
	ANI	7FH		;MASK TO 7 BITS
	POP	H		;RESTORE REGS
	POP	D
	POP	B
	RET
;
;	OUTPUT CHAR IN REG A TO CONSOLE
;
CONOUT:	PUSH	B		;SAVE REGS
	PUSH	D
	PUSH	H
	MVI	C,DIOF		;SELECT CONS DIR I/O FUNC
	MOV	E,A		;CHAR TO E
	CALL	BDOS
	POP	H		;RESTORE REGS
	POP	D
	POP	B
	RET
;
;	CHK STATUS / GET CHAR FROM CONS
CKDIO:	PUSH	B		;SAVE REGS
	PUSH	D
	PUSH	H
	MVI	C,DIOF		;DIOF = 06H = DIRECT I/O FUNCTION
	CALL	BDOS
	CPI	0		;IF ZERO, NO CHAR FROM CONSOLE
	JZ	NOCHCN		;THEN GET OUT
	ANI	7FH		;MASK TO 7 BITS
	CPI	CTRLZ		;WAS IT CTRLZ ?
	JZ	RBOOT		;YES, WARM BOOT. NO, RET AND
	CALL	PUNOUT		;OUTPUT TO MODEM VIA PUN:
NOCHCN:	POP	H		;ANYHOW, RESTORE REGS
	POP	D
	POP	B
	RET
;
;	MESSAGE POINTED TO BY HL OUT TO CONSOLE
COMSG:	MOV	A,M		;GET A CHAR
	ORA	A
	RZ			;RETURN ON ZERO
	CALL	CONOUT		;ELSE DISLAY CHAR
	INX	H		;POINT TO NEXT CHAR
	JMP	COMSG
;
;	SIGN-ON MESSAGE
SIGNON:	DB	'MODEM PROGRAM: TO EXIT TYPE CTRLZ',CR,LF,LF,0
;
;	CR LF TO CONSOLE
CCRLF:	MVI	A,CR
	CALL	CONOUT
	MVI	A,LF
	JMP	CONOUT
;
;	SET UP STACK SPACE
	DS	64		;40H LOCATIONS
STAK:	DB	0		;TOP OF STACK
;
	END		;END PRG DUMBA3.ASM
