	NAME FPRINT
;FORMATTED PRINT ROUTINE
;RUSS BAKKE
;03-06-83
;
	ORG 100H	;NORMAL START
START	LD SP,0D100H
	LD DE,MSG1	;BANNER
	CALL MSG
	LD HL,DISST
	LD (FILEN),HL	;INIT
	LD IX,FLAGS
	LD (IX),0
	LD (IX+1),0
	LD HL,DBUFF	;SEE IF OPTIONS PASSED
	LD A,(HL)		;# OF CHARS
	CP 0
	JR Z,CONT3	;NO OPTIONS PASSED
CONT1	INC HL		;SEARCH FOR / & #
	LD A,(HL)
	CP '/'
	JR Z,CONT2	;FOUND IT
	CP '#'
	JR Z,CONT2A	;FOUND IT
	CP 0		;NULL?
	JR NZ,CONT1	;NO, CONTINUE
	JR CONT3
;
CONT2	INC HL		;ADJUST FOR /
	CALL SETFLG
	LD A,(HL)	;AT NULL?
	CP 0
	JR Z,CONT3	;YES, QUIT
	BIT 7,(IX+1)	;COUNT SET?
	JR Z,CONT1	;NO, CONTINUE
	JR CONT3	;YES
;
;CONT2A-# FOUND
CONT2A	INC HL
	CALL GETCNT
	LD A,(HL)	;AT NULL?
	CP 0
	JR Z,CONT3	;YES, QUIT
	BIT 7,(IX)	;OPTIONS SET?
	JR Z,CONT1	;NO, CONTINUE
;
;SEE IF AN FCB WAS PASSED
CONT3	LD HL,DBUFF
	LD A,(HL)	;LENGTH OF COMD LINE
	OR A		;SET FLAGS
	CALL Z,GETFN
	CALL GETFL	;LOAD FILE
	BIT 7,(IX)
	JR NZ,CONT4	;OPTIONS ALREADY SET
CONT3A	LD DE,MSG3	;OPTIONS?
	CALL MSG
	LD DE,DBUFF
	LD A,7FH	;BUFFER LENGTH
	LD (DE),A
	LD C,10		;GET LINE
	CALL DOS
	CALL LF
	LD HL,DBUFF+2
	CALL SETFLG
	BIT 7,(IX)	;SUCCESSFUL?
	JR Z,CONT3A	;NO, TRY AGAIN
CONT4	BIT 7,(IX+1)
	JR NZ,CONT5	;SET
CONT4A	LD DE,MSG3A
	CALL MSG
	LD DE,DBUFF
	LD A,7FH	;BUFFER LENGTH
	LD (DE),A
	LD C,10		;GET LINE
	CALL DOS
	CALL LF	;ECHO LF
	LD HL,DBUFF+2
	CALL GETCNT
	BIT 7,(IX+1)	;SUCCESSFUL?
	JR Z,CONT4A	;NO, TRY AGAIN
;
CONT5	LD A,(COUNT)
	LD C,A
CONT5A	PUSH BC		;SAVE COUNT
	BIT 1,(IX)
	JR Z,MORE2
	LD E,9 ;HT
	CALL PRNTR
MORE2	LD HL,DISST
	CALL PRINT
	CALL FORM
	POP BC
	DEC C
	JP Z,0	;RET TO OS
	BIT 3,(IX)	;BOTTOM OF PAGE PROMPT?
	JR Z,MORE3	;NO
	PUSH BC
	LD DE,MSG8
	JR MORE4
;
MORE3	BIT 4,(IX)	;END OF TEXT PROMPT?
	JR Z,CONT5A	;NO
	PUSH BC
	LD DE,MSG9
MORE4	CALL MSG
	LD C,1	;GET CHAR
	CALL DOS
	CALL CRLF
	POP BC
	JR CONT5A
;
GETFN	LD DE,MSG2	;"FILE NAME"
	CALL MSG
	LD DE,DBUFF
	LD A,7FH	;BUFFER LENGTH
	LD (DE),A
	LD C,10		;GET LINE
	CALL DOS
	CALL LF
	LD HL,DBUFF+2
	LD DE,FCB
	LD C,86H	;FORMAT FCB REQ
	CALL DOS
	RET
;
GETFL	LD C,15		;OPEN
	LD DE,FCB
	CALL DOS
	CP -1		;RETS -1 IF NOT FOUND
	JR Z,NOTFND
;NOW READ FILE
READ1	LD DE,FCB
	LD C,20		;READ BLOCK
	CALL DOS
	PUSH AF
	LD DE,(FILEN)
	LD HL,DBUFF
	LD BC,80H	;#BYTES READ
	LDIR		;COPY
	LD BC,80H
	LD HL,(FILEN)
	ADD HL,BC	;ADJUST FILEN
	LD (FILEN),HL
	POP AF		;RECOVER ERROR CODE
	OR A		;SET FLAGS
	JR Z,READ1	;OK, READ NEXT
	CP 1		;EOF?
	JR NZ,DSKERR	;NO, ERROR
	LD C,16		;CLOSE
	LD DE,FCB
	CALL DOS
	CP -1
	JR Z,DSKERR
;NOW FIND END OF DATA
	LD HL,DISST
	LD B,1AH	;EOF
	LD DE,(FILEN)
MARK1	LD A,(HL)
	CP B
	JR Z,MARK2
	CALL H1ED
	JR NZ,MARK1
;HIT FILEN BEFORE EOF
	LD A,0DH	;NOW FIND LAST CHAR
MARK1A	CP (HL)
	JR NZ,MARK1B
	DEC HL
	JR MARK1A
MARK1B	INC HL
	LD (HL),1AH	;MARK EOF
;HAVE EOF
MARK2	INC HL
	LD (FILEN),HL	;SAVE IT
	RET
;
DSKERR	LD DE,MSG6
DSKER1	CALL MSG
	RST 0		;RET TO OS
;
NOTFND	LD DE,MSG5
	JR DSKER1
;
;GETCNT-GET # OF COPIES (DEFAULT 1)
;FIRST, GET # OF CHARS
;(MAY END WITH SPACE OR B=0)
GETCNT	LD C,0
GETC1	LD A,(HL)
	CP ' '
	JR Z,GETC2	;DONE
	CP 0
	JR Z,GETC2	;DONE
	INC C
	INC HL
	JR GETC1
;NOW DECODE CHARS
GETC2	LD A,C
	CP 0		;0 CHARS?
	JR Z,DEFLT	;YES, DEFAULT
	PUSH HL		;HL NOW POINTS TO SPACE
	CALL DIGIT
	LD E,A
	DEC C
	JR Z,DONE
	CALL DIGIT
	CP 0
	JR Z,MORE
	LD B,A
	LD A,E
SUM	ADD A,10
	DJNZ SUM
	LD E,A
MORE	DEC C
	JR Z,DONE
	CALL DIGIT
	CP 0
	JR Z,DONE
	CP 2
	JP C,NOVAL
	LD B,A
	LD A,E
SUM1	ADD A,100
	DJNZ SUM1
	LD E,A
DONE	POP HL
DONE1	LD A,E
	LD (COUNT),A
	SET 7,(IX+1)	;SET DONE FLAG
	RET
;
DEFLT	LD E,1
	JR DONE1
;
;NOVAL--A NON-VALID DECIMAL CHAR WAS ENTERRED
NOVAL	LD DE,MSG4
	CALL MSG
	POP HL
	RET
;
DIGIT	DEC HL
	LD A,(HL)
	SUB 30H		;CONVERT TO BIN
	JR C,NOVAL
	CP 9
	JR NC,NOVAL
	RET
;
;SETFLG--DECODES OPTION STRING AT HL, SETS FLAGS
SETFLG	LD (IX),80H
	LD (IX+3),5	;DEFAULT TO LST:
	LD A,(HL)
	CP ' '		;NO CHARS?
	RET Z
	CP 0
	RET Z
;
SETFL1	LD A,(HL)
	CP ' '
	RET Z
	CP 0
	RET Z
	CP 'B'
	JR Z,SETB
	CP 'D'
	JR Z,SETD
	CP 'E'
	JR Z,SETE
	CP 'M'
	JR Z,SETM
	CP 'P'
	JR Z,SETP
	CP 'U'
	JR Z,SETU
	LD (IX),0	;CLEAR "SET" FLAG
	LD DE,MSG7	;ERROR
	CALL MSG
;
SETFL2	INC HL
	JR SETFL1
;
SETB	SET 3,(IX)
	JR SETFL2
;
SETD	SET 0,(IX)
	JR SETFL2
;
SETE	SET 4,(IX)
	JR SETFL2
;
SETM	SET 1,(IX)
	JR SETFL2
;
SETP	SET 5,(IX)
	LD (IX+3),4	;SELECT PUN:
	JR SETFL2
;
SETU	SET 2,(IX)
	JR SETFL2
;
;PRINT SUB
;ENTER WITH START IN HL
;USES A,B,E
PRINT	LD (IX+2),0	;INIT LINE COUNT
PRINT0	LD A,(HL)
	CP 26		;EOF?
	RET Z		;YES
	LD E,A
	BIT 2,(IX)
	JR Z,PROK
	LD A,E
	CP 'a'
	JR C,PROK
	CP 'z'+1
	JR NC,PROK
	XOR 20H		;CONVERT TO UPPER CASE
	LD E,A
PROK	PUSH HL
	CALL PRNTR
	LD A,E		;RECOVER CHAR
	CP 0CH	;FF?
	JR Z,PRIN0A
	CP 0DH	;C/R?
	JR NZ,PRIN1
	INC (IX+2)	;LINE COUNTER
	BIT 0,(IX)	;DOUBLE SP?
	JR Z,PRIN0Z	;NO
	CALL PRNTR
	INC (IX+2)
;IF COUNT>=58, CHECK FOR PAGE PROMPT
PRIN0Z	LD A,(IX+2)
	CP 58-1
	JR C,PRIN0B
PRIN0A	BIT 3,(IX)
	JR Z,PRIN0B

	LD DE,MSG8
	CALL MSG
	LD C,1	;GET CHAR
	CALL DOS
	CALL CRLF
	LD (IX+2),0	;RESET COUNTER
PRIN0B	BIT 1,(IX)	;MARGIN?
	JR Z,PRIN1
	LD E,9 ;HT
	CALL PRNTR
PRIN1	POP HL
	INC HL
	JR PRINT
;
MSG	LD C,9
	JP DOS
;
;H1ED--INC HL, CMP TO DE, RETS C IF >
H1ED	INC HL
	LD A,D
	SUB H
	RET NZ
	LD A,E
	SUB L
	RET
;
CRLF	LD C,2
	LD E,0DH	;C/R
	CALL DOS
;
LF	LD C,2
	LD E,0AH	;LF
	JP DOS
;
FORM	LD E,0CH	;FORM FEED
PRNTR	LD C,(IX+3)	;SEND CHAR IN E TO SELECTED DEVICE
	JP DOS
;
;
MSG1	DEFM 'FORMATTED PRINT ROUTINE V1.3'
	DEFW 0A0DH
	DEFM '$'	;EOM
;
MSG2	DEFM 'File name? $'
;
MSG3	DEFM 'Options? [B(ottom of page prompt,'
	DEFW 0A0DH
	DEFM 'D(ouble spaced, E(nd of text prompt,'
	DEFW 0A0DH
	DEFM 'left M(argin, P(unch device,'
	DEFW 0A0DH
	DEFM 'U(pper case only]? $'
;
MSG3A	DEFW 0A0DH
	DEFM 'HOW MANY COPIES? (MAX 255) $'
;
MSG4	DEFM 'INVALID DECIMAL NUMBER'
	DEFW 0A0DH
	DEFM '$'
;
MSG5	DEFM 'FILE NOT FOUND'
	DEFW 0A0DH
	DEFM '$'
;
MSG6	DEFM 'DISK ERROR'
	DEFW 0A0DH
	DEFM '$'
;
MSG7	DEFM 'INVALID OPTION'
	DEFW 0A0DH
	DEFM '$'
;
MSG8	DEFM 'INSERT NEXT SHEET AND PRESS ANY KEY $'
;
MSG9	DEFM 'VERIFY PAPER ALIGNMENT AND PRESS ANY KEY $'
;
;
FLAGS	DEFS 4
;FIRST BYTE:
;BIT 0=DOUBLE SP, 1=MARGIN, 2=UPPER CASE ONLY
;BIT 3=BOTTOM OF PAGE PROMPT, 4=END OF TEXT PROMPT,
;BIT 5=PUNCH DEVICE, 7=SET
;SECOND BYTE: BIT 7=COUNT SET
;THIRD BYTE: LINE COUNT
;FOURTH BYTE:  DEVICE SELECTION (4=PUN:, 5=LST:)
;
COUNT	DEFS 1
FILEN	DEFS 2
DISST	DEFS 1		;DUMMY
DBUFF	EQU 80H
FCB	EQU 5CH		;FILE CONTROL BLOCK
DOS	EQU 5		;DOS CALL
	END
