
;
;  TO RUN THE ONE SECOND INTERRUPT A LINK IS NEEDED
;  ON THE SYSTEM SUPPORT BOARD.
;  	BACKGROUND:-
;	WHEN THE FOLLOWING STATES ARE PRESENTED TO THE
;	'OKI CLOCK CHIP',
;	 HOLD='0'
;	 READ='1'
;	 CS='1'
;	 A0-A3='1'
;	THEN D0	= 1024HZ (50% DUTY)
;	     D1 = 1HZ	122.1 USEC
;	     D2 = 1/60 HZ   "
;	     D3 = 1/3600 HZ  "
;
;	THE 1 SEC PULSE IS CONNECTED TO J7 PIN 7.
;	FOR AN INTERRUPT 1.


************************************************
*						*
*  ROUTINE FOR INITIALISING MASTER AND SLAVE	*
*	8259A'S ON THE SYSTEM SUPPORT 1		*
*						*
************************************************


; THIS PROGRAM IS SET TO I/O ADDRESS BASE 50H
;  (COMPUPRO STANDARD), FOR DIFFERENT ADDRESSES
;  CHANGE "BASE" IN EQUATES.


	MACLIB	MACRO

INTJMP	EQU	200H	;START OF INTERRUPT JUMPS
SINTJMP	EQU	INTJMP+20H


BASE	EQU	50H	;STARTING ADDR OF BOARD
MPRT0	EQU	BASE	;LOWER MASTER PORT A0=0
MPRT1	EQU	BASE+1	;UPPER MASTER PORT (A0=1)
SPRT0	EQU	BASE+2	;LOWER SLAVE PORT (A0=0)
SPRT1	EQU	BASE+3	;UPPER SLAVE PORT (A0=1)
CLKCMD	EQU	BASE+10	;CLOCK COMMAND PORT
CLKDAT	EQU	BASE+11	;CLOCK DATA PORT
SURTD	EQU	BASE+12	;SS UART DATA PORT
SURTS	EQU	BASE+13	;SS UART STATUS PORT
SURTM	EQU	BASE+14	;UART MODE PORT
SURTC	EQU	BASE+15	;UART COMMAND PORT

CLKDATA	EQU	BASE+11	;CLOCK DATA PORT



	ORG	100H

; THIS ROUTINE INITIALISES THE MASTER 8259A

INIT:
	DI		;DISABLE INTERRUPTS
	MVI	A,(INTJMP AND 0E0H) OR 00011101B	;ICW1
	OUT	MPRT0	;SEND IT
	MVI	A,HIGH INTJMP	;UPPER BYTE OF ADDR INTERVAL
	OUT	MPRT1	;SEND IT
	MVI	A,10000000B	;IR7 HAS A SLAVE
	OUT	MPRT1	;SEND IT
	MVI	A,00010000B	;ICW4
	OUT	MPRT1	;SEND IT
	MVI	A,0FFH	;CLEAR ALL MASK BITS (OCW1)
	OUT	MPRT1	;SEND IT
	MVI	A,10100000B	;ROTATE ON NON-SPEC EOI
	OUT	MPRT0	;SEND IT
	MVI	A,00001000B	;OCW3
	OUT	MPRT0	;SEND IT


;  THIS ROUTINE INITIALISES THE SLAVE 8259A


	MVI	A,(SINTJMP AND 0E0H) OR 00011101B	;ICW1
	OUT	SPRT0	;SEND IT
	MVI	A,HIGH SINTJMP	;UPPER BYTE OF ADDR INTERVAL
	OUT	SPRT1	;SEND IT
	MVI	A,07H	;IR7 HAS A SLAVE
	OUT	SPRT1	;SEND IT
	MVI	A,00010000B	;ICW4
	OUT	SPRT1	;SEND IT
	MVI	A,0FFH	;CLEAR ALL MASK BITS (OCW1)
	OUT	SPRT1	;SEND IT
	MVI	A,10100000B	;ROTATE ON NON-SPEC EOI
	OUT	SPRT0	;SEND IT
	MVI	A,00001000B	;OCW3
	OUT	SPRT0	;SEND IT


;	SET UP OKI RTC FOR 1 SEC INTERRUPT
;	  SET A0 - A3 = 1 (ADDRESS 15)
;	  SET READ    = 1
;	  SET WRITE   = 0
;	  SET HOLD    = 0
;	 BY OUTPUTING 1FH TO CLKCMD PORT


	MVI	A,1FH	;SET FOR TIME INTERRUPTS
	OUT	CLKCMD	;AND OUTPUT

;	ENABLE INT15 ONLY

	MVI	A,07DH	;ENABLE INT15 ONLY
	OUT	MPRT1
	MVI	A,07FH
	OUT	SPRT1
	EI		;ENABLE
LOOP	JMP	LOOP	;LOOP FOREVER


************************************************
*  STANDARD CONFIGURATION OF INTERRUPTS	*
*   ON THE SYSTEM SUPPORT 1 BOARD		*
*						*
************************************************


;  MASTER CONTROLLER :-
; INTERRUPT		NO. SOURCE	OPTION
;	IRQ0		VI0		RINT
;	IRQ1		VI1		TINT
;	IRQ2		VI2		TIMER0
;	IRQ3		VI3		TIMER1
;	IRQ4		VI4		TIMER2
;	IRQ5		VI5		SVRQ(9511)
;	IRQ6		VI6		END(9511)
;	IRQ7		VI7		INT(SLAVE)


;  SLAVE CONTROLLER
; INTERRUPT	STANDARD SOURCE		OPTION
;	IRQ0		VI7
;	IRQ1		TIMER0
;	IRQ2		TIMER1
;	IRQ3		TIMER2
;	IRQ4		SVRQ(9511)
;	IRQ5		END(9511)
;	IRQ6		TINT
;	IRQ7		RINT

;FOR THE INTERFACER 2 BOARD THE STANDARD INTERRUPTS
;

;	VI0		INT J0 (PARALLEL CH 0)
;	VI1		INT J2 (PARALLEL CH 1)
;	VI2		INT J3 (PARALLEL (CH 2)
;	VI3		N.C.
;	VI4		TMRI (TIMER INTERRUPT)
;	VI5		N.C.
;	VI6		TXINT
;	VI7		RXINT


;	DISK 1 INTERRUPT OPTIONS
;	  THE INTERRUPT ON THE DISK CONTROLLER
;	  CAN BE STRAPPED TO VI0 TO VI7
;	  NORMALLY VI0 (THE HIGHEST PRIORITY 
;	  WOULD BE USED.


	ORG	INTJMP

************************************************
*						*
*	INTERRUPT JUMP BLOCK			*
*						*
************************************************

INT0	JMP	INT0
	NOP

;	1 SEC INTERRUPT FROM RTC

INT1	DI		;DISABLE INTERRUPTS
	JMP	ONESEC	;EXEC ONE SECOND INTERRUPT
INT2	JMP	INT2
	NOP
INT3	JMP	INT3
	NOP
INT4	JMP	INT4
	NOP
INT5	JMP	INT5
	NOP
INT6	JMP	INT6
	NOP
INT7	JMP	INT7
	NOP
INT8	JMP	INT8
	NOP


;	TIMER 0 INTERRUPT

INT9	JMP	INT9
	NOP

;	TIMER 1 INTERRUPT

INT10	JMP	INT10
	NOP

;	TIMER 2 INTERRUPT

INT11	JMP	INT11
	NOP

;	APU (9511) SVRQ INTERRUPT

INT12	JMP	INT12
	NOP

;	APU (9511) END INTERRUPT

INT13	JMP	INT13
	NOP

;	SYSTEM SUPPORT TINT INTERRUPT

INT14:
	DI
	JMP	STINT	;UART TX INTERRUPT

;	SYSTEM SUPPORT RINT INTERRUPT

INT15:
	DI
	JMP	SRINT


;	ONESEC INTERRUPT ROUTINE

ONESEC:
	SAVE		;SAVE B,D,AND H
	PUSH	PSW	;AND PSW
	PRINT	<'ONE SECOND INTERRUPT ',CR,LF>
	MVI	A,61H	;SET SEOI
	OUT	MPRT0	;AND SEND
	POP	PSW	;RESTORE PSW
	RESTORE		;RESTORE B,D,AND H
	EI		;ENABLE INTERRUPTS
	RET



************************************************
*						*
*	SYSTEM SUPPORT 1 UART I/P		*
*	INTERRUPT ROUTINE			*
*						*
************************************************

;	THIS ROUTINE CHECKS THE UART FOR DATA
;	READY, PRINT AN ERROR MESSAGE IF NOT
;	AVAILABLE. THEN TESTS TO SEE IF THE BUFFER
;	IS FULL, AGAIN OUTPUTS AN ERROR MESSAGE IF
;	FULL, AND THEN BUMPS THE COUNT,AND POINTER
;	BEFORE SENDING THE SEOI'S AND RESTORING THE
;	REGISTERS, ENABLING INTERRUPTS.

SSDAV	EQU	00000001B	;SYSTEM SUPPORT DATA AVAIL

SRINT:
	SAVE		;PUSH B,D,H
	PUSH	PSW	;AND PSW
	IN	SURTS	;GET STATUS FROM UART
	ANI	SSDAV	;MASK DATA AVAIL.
	JZ	RINTE	;EXIT IF NOT READY
	IN	SURTD	;GET THE DATA
	ANI	7FH	;MASK PARITY
	MOV	C,A	;SAVE CHAR
	LDA	SIBUFC	;GET COUNT IN BUFFER
	CPI	SIBUFL	;AND SEE IF FULL
	JZ	SIFUL	;BRIF FULL
	LHLD	SIBUFP	;GET POINTER
	MOV	M,C	;AND STORE
	INX	H	;AND INDEX
	SHLD	SIBUFP	;AND SAVE
	INR	A	;THEN INDEX NO OF CHAR
	STA	SIBUFC	;AND SAVE
SRINTEX:

;	SEND SPECIFIC END OF INTERRUPT TO
;	BOTH MASTER AND SLAVE CONTROLLERS.

	MVI	A,67H	;LOAD SEOI FOR MASTER
	OUT	MPRT0	;SEND IT
	MVI	A,67H	;LOAD SEOI FOR SLAVE
	OUT	SPRT0	;AND SEND IT


	POP	PSW	;RESTORE ALL REGISTERS
	RESTORE
	EI		;ENABLE INTERRUPTS
	RET

RINTE:
	PRINT	<'SS UART INPUT ERROR',CR,LF>
	CALL	SERROR	;RESET USART ERRORS
	JMP	SRINTEX	;AND EXIT

SIFUL:
	PRINT	<'SS UART INPUT BUFFER FULL',CR,LF>
	JMP	SRINTEX	;AND EXIT


;
;	THIS ROUTINE PERFORMS THE INITIALISATION
;	REQUIRED BY THE SYSTEM SUPPORT USART.
;
STINIT:
	MVI	A,11101110B	;ASYNC,8BITS,EV,2STOP
	OUT	SURTM	;SET UP MODE REG. 1
	MVI	A,01111110B	;9600 BAUD
	OUT	SURTM	;SET UP MODE REG. 2
	MVI	A,00100111B	;TX ON,DTR LOW,REC ON,
			;NO BREAK,NO RESET,RTS LOW
	OUT	SURTC	;SET UP COMMAND PORT
	RET



;	SERROR - ROUTINE TO RESET ERROR FLAGS
;		ON THE SYSTEM SOPPORT UART.
;

SERROR:
	MVI	A,00010000B	;RESET UART
	OUT	SURTC	;TO COMMAND REG.
	MVI	A,00100111B	;RESUME
	OUT	SURTC
	RET



************************************************
*						*
*	SYSTEM SUPPORT 1 UART O/P		*
*	INTERRUPT ROUTINE			*
*						*
************************************************


STINT:
	SAVE	;PUSH B,D,H
	PUSH	PSW





















SIBUFC	DB	0H	;SS UART CHAR COUNT
SIBUFP	DW	$+2	;SS UART BUFFER POINTER
SIBUF	DS	125	;SI BUFFER
SIBUFL	EQU	$-SIBUF	;LENGTH OF SIBUFFER



	END
