PROGRAM ACCTPOI;
TYPE
	MAILING = RECORD
		NAD:ARRAY[1..124] OF CHAR;
		ACCT_NUMBER:ARRAY[1..4] OF CHAR;
		END;

	XXPOINTERS = RECORD
		START:INTEGER;
		FINISH:INTEGER;
		END;

	ENTRY = RECORD
		ACCT_NO:INTEGER;
		DATE:ARRAY[1..6] OF CHAR;
                INVOICE_NUMBER:ARRAY[1..10] OF CHAR;
                PURCHASE_ORDER_NUMBER:ARRAY[1..10] OF CHAR;
		AMOUNT:REAL;
		END;

FO = FILE OF XXPOINTERS;
FN = FILE OF ENTRY;
FI  = FILE OF MAILING;

$STRING14 = STRING 14;
XR = ARRAY[1..3] OF CHAR;
$STRING0 = STRING 0;
$STRING255 = STRING 255;
$STRING80 = STRING 80;


VAR
FNAD:FI;
FIN:FN;  
FOUT:FO;

NAME:MAILING;
POINTERS:XXPOINTERS;
INFORMATION:ENTRY;

N,I,NUMBER,COUNTER,RECORD_NUMBER,NUMBER_OF_RECORDS,NUMBER_ACCOUNTS:INTEGER;
LAST_RECORD_NUMBER:INTEGER;

FILENAM,LOCFILE,INVFILE:$STRING14;
{$C-}
{$M-}
{$F-}

PROCEDURE SETLENGTH(VAR X:$STRING0;Y:INTEGER);EXTERNAL;
FUNCTION LENGTH(X:$STRING255):INTEGER;EXTERNAL;

PROCEDURE CLEAR_SCREEN;
BEGIN
WRITE(CHR(27),'*',CHR(0),CHR(0),CHR(0),CHR(0));
END;


PROCEDURE ENTER_FILE_NAME;
VAR
ERROR:BOOLEAN;

BEGIN
REPEAT
ERROR:=FALSE;
CLEAR_SCREEN;
WRITELN;
WRITE('ENTER THE NAME AND ADDRESS FILE AS: DRIVE:NAME.EXTENSION  ');
READ(FILENAM);
RESET(FILENAM,FNAD);

IF EOF(FNAD) THEN
BEGIN
WRITELN;
WRITELN('FILE NOT FOUND. PLEASE RE-ENTER');
ERROR:=TRUE;
END;

UNTIL ERROR = FALSE;
END; {OF PROCEDURE}

PROCEDURE NO_ACCOUNTS (FNAME:$STRING14);
BEGIN
RESET(FNAME,FNAD);
WITH NAME DO
BEGIN
READ(FNAD:1,NAME);
NUMBER_ACCOUNTS:=(((ORD(ACCT_NUMBER[1])-48)*1000)+
                  ((ORD(ACCT_NUMBER[2])-48)*100)+
                  ((ORD(ACCT_NUMBER[3])-48)*10)+
                  (ORD(ACCT_NUMBER[4])-48));

WRITELN('NUMBER OF ACCOUNTS IN NAD FILE ',NUMBER_ACCTS);

END;

END; {OF PROCEDURE}



{************ PROCEDURE TO DETERMINE NUMBER OF RECORDS****}

PROCEDURE NUMBER_RECORDS (FNAM:$STRING14);
BEGIN
RESET(FNAM,FIN);
WITH INFORMATION DO
BEGIN

READ(FIN:1,INFORMATION);
NUMBER_OF_RECORDS:=(((ORD(PURCHASE_ORDER_NUMBER[1])-48)*1000)+
	((ORD(PURCHASE_ORDER_NUMBER[2])-48)*100)+
	((ORD(PURCHASE_ORDER_NUMBER[3])-48)*10)+
	(ORD(PURCHASE_ORDER_NUMBER[4])-48));
END; {OF WITH}
WRITELN(' NUMBER OF RECORDS IN THE ACCOUNT FILE ',FNAM,' : ',
		NUMBER_OF_RECORDS); 
END; {OF PROCEDURE}



FUNCTION MAKE_FILE_NAMES(XFILNAME:$STRING14;EXT:XR):$STRING14;
VAR
FILENAME:$STRING14;
L:INTEGER;


BEGIN
I:=1;
SETLENGTH(FILENAME,0);
WHILE XFILNAME[I] <> '.' DO
	BEGIN
	APPEND(FILENAME,XFILNAME[I]);
	I:=I+1;
	END;

APPEND(FILENAME,'.');
FOR N:=1 TO 3 DO
BEGIN
APPEND(FILENAME,EXT[N]);
END;

IF (I+4) < 14 THEN
BEGIN
I:=I+4;
WHILE I < 15 DO
BEGIN
APPEND(FILENAME,' ');
I:=I+1;
END;
END;
WRITELN('FILENAME IS ',FILENAME);
MAKE_FILE_NAMES:=FILENAME;

END; {OF FUNCTION}


PROCEDURE XPOINTERS (FNAME:$STRING14);
VAR
I:INTEGER;
MATCH:BOOLEAN;

BEGIN
LAST_RECORD_NUMBER:=2;
RECORD_NUMBER:=2;
NUMBER:=2;
REWRITE(LOCFILE,FOUT);
RESET(FNAME,FIN);

REPEAT
WITH INFORMATION DO
BEGIN

REPEAT
READ(FIN:RECORD_NUMBER,INFORMATION);
IF ACCT_NO = NUMBER THEN
	BEGIN
	MATCH:=TRUE;
	RECORD_NUMBER:=RECORD_NUMBER+1;
	END;
	
IF ACCT_NO <> NUMBER THEN MATCH:=FALSE;
UNTIL (MATCH = FALSE) OR (RECORD_NUMBER > NUMBER_OF_RECORDS);

END; {OF INFORMATION}

WITH POINTERS DO
BEGIN
START:=LAST_RECORD_NUMBER;
FINISH:=RECORD_NUMBER;
IF FINISH < START THEN FINISH:=START;
COUNTER:=NUMBER;
WRITE(FOUT:COUNTER,POINTERS);
LAST_RECORD_NUMBER:=RECORD_NUMBER;
WRITELN('ACCOUNT # ',NUMBER:4,' START= ',START:3,'  FINISH= ',
        FINISH:3,'  # RECS WITH THIS ACCT # ',(FINISH-START):3);
END;

NUMBER:=NUMBER+1;

UNTIL NUMBER > NUMBER_ACCOUNTS

END; {OF PROCEDURE}


BEGIN    {OF MAIN}
ENTER_FILE_NAME;
NO_ACCOUNTS(FILENAM);
LOCFILE:=MAKE_FILE_NAMES(FILENAM,'LOC');
INVFILE:=MAKE_FILE_NAMES(FILENAM,'INV');
NUMBER_RECORDS(INVFILE);
XPOINTERS(INVFILE);
END.