;	TTCBIOS.ASM
;
;
;
;      Original coding by:  Thinker Toys
;			    Richmond, CA
;
;
;       Patching to minimize size to fit ok for cp/m 2.2
;	by: Jack Burge
;	    518A Fifth Street
;	    East Northport, LI NY   11731
;
;           (516) 261-7219
;
;	Patching to automatically determine `START` equate value
;       inserted by:
;			Henry B. Rothberg
;			1 Laticrete Park North
;			Bethany,  CT 06525
;	1/12/82                    
;
;			From excellent coding done by:
;
;			TKI (The Kendall Institute)
;				
;				Bruce Kendall
;				334-A  Camille Court
;				Mountain View,  CA  94040
;
;
;	To use this and ttboot.asm see TTSDDJ.HLP
;
;	To use, change the values at MSIZE & DELTA for
;	your system size, then change the I/O routines
;	below to match your system requirements.
;
;*************************************************************
;                                                          ***
MSIZE	EQU	56	; Insert system size in KB here    ***
;                                                          ***
;*************************************************************
;
DELTA	EQU	0000H	; Offset from standard CP/M
;
;*************************************************************
;
BIAS	EQU	(MSIZE-20)*1024-DELTA	; Offset from 20K CP/M system
;
CCP	EQU	3400H+BIAS		; Base of CP/M
;
OFFSET  EQU	980H-CCP		; Offset used to read in ttcbios.hex
;					  with ddt.com during configuration

;
;	TITLE 'CBIOS DRIVERS FOR E000H'
;CBIOS DRIVERS FOR CP/M
;
CPM	EQU	CCP 		; For ALL cp/m 2.2 systems
;
ENTRY	EQU	CPM+806H
CDISK	EQU	4
ORIGIN	EQU	0E000H 		; For prom at E000H
INPUT	EQU	ORIGIN+3
OUTPUT	EQU	ORIGIN+6
TKZERO	EQU	ORIGIN+9H
TSEEK	EQU	ORIGIN+0CH
SECTOR	EQU	ORIGIN+0FH
DMA	EQU	ORIGIN+12H
DISKR	EQU	ORIGIN+15H
DISKW	EQU	ORIGIN+18H
STACK	EQU	ORIGIN+26EH
DRIVE	EQU	ORIGIN+273H
DMAADR	EQU	ORIGIN+274H
TRACK	EQU	ORIGIN+277H
STATUS	EQU	ORIGIN+302H
DELAY	EQU	ORIGIN+1F3H
SCON	EQU	ORIGIN+270H
IOBYTE	EQU	3H
INTIOBY	EQU	0
RDYMSK	EQU	80H
WPTCT	EQU	1
;
;
	ORG	CPM+1600H
;
NSECTS	EQU	($-CPM)/128
;
START	JMP	BOOT	
WBOOTE	JMP	WBOOT
	JMP	CONST
	JMP	CHRIN
CPOUT	JMP	CONOUT
	JMP	LIST
	JMP	PUNCH
	JMP	READER
	JMP	HOME
	JMP	SELDISK
	JMP	SETTRK
	JMP	SETSEC
	JMP	DMA
	JMP	READ
	JMP	WRITE
      	JMP	LISTST
	JMP	SECTRAN
;	DISK PARAMETER HEADER FOR DISK 00
DPBASE	DW	TRANS,0000H
	DW	0000H,0000H
	DW	DIRBF,DPBLK
	DW	CHK00,ALL00
;	DISK PARAMETER HEADER FOR DISK 01
	DW	TRANS,0000H
	DW	0000H,0000H
	DW	DIRBF,DPBLK
	DW	CHK01,ALL01
;	DISK PARAMETER HEADER FOR DISK 02
	DW	TRANS,0000H
	DW	0000H,0000H
	DW	DIRBF,DPBLK
	DW	CHK02,ALL02
;	DISK PARAMETER HEADER FOR DISK 03
	DW	TRANS,0000H
	DW	0000H,0000H
	DW	DIRBF,DPBLK
	DW	CHK03,ALL03
;	SECTOR TRANSLATE VECTOR
TRANS	DB	1,7,13,19
	DB	25,5,11,17
	DB	23,3,9,15
	DB	21,2,8,14
	DB	20,26,6,12
	DB	18,24,4,10
	DB	16,22
;
DPBLK	DW	26
	DB	3
	DB	7
	DB	0
	DW	242
	DW	63
	DB	192
	DB	0
	DW	16
	DW	2
;
;
;
BOOT	LXI	SP,STACK
	CALL	TINIT
	CALL 	QINIT
	LXI	H,PROMPT
	CALL	MESSG
	XRA	A
	STA	CDISK
GOCPM	LXI	H,80H
	SHLD	DMAADR
	MVI	A,0C3H
	STA	0
	LXI	H,START+3
	SHLD	1
	STA	5
	LXI	H,ENTRY
	SHLD	6
	LDA	CDISK
	MOV	C,A
	JMP	CPM
;
TINIT	MVI	A,INTIOBY
	STA	IOBYTE
	LXI	H,0
	RET
;
WBOOT	LXI	SP,STACK
	LXI	B,0080H
	CALL	DMA
	MVI	A,88H 
	STA	DRIVE
	CALL	ORIGIN+2AH
	LXI	H,GOCPM
	SHLD	0092H
	MVI	A,2DH
	STA	00CFH
	MVI	A,(CPM+1600H)/100H
	STA	00FAH
	JMP	0080H
;
HOME	CALL	SELDSK
	CALL	TKZERO
	RET
;
;
LISTST	IN	04
	ANI	40H
	MVI	A,0
	RZ
	CMA
	RET
;
;
CONST	IN	000
	ANI	40H
	MVI	A,00
	RZ
	CMA
	RET
;
;
STATUS5	DB	00
SETTRK	PUSH	B
	CALL	SELDSK
	POP	B
	JMP	TSEEK
;
;
CONIN	LXI	H,CITBLE
CONIN1	LDA	IOBYTE
	RAL
SELDEV	ANI	6H
	MVI	D,0
	MOV	E,A
	DAD	D
	MOV	A,M
	INX	H
	MOV	H,M
	MOV	L,A
	PCHL
;
CONOUT	IN 	00H
	ANI	80H
	JZ	CONOUT
	MOV	A,C
	OUT	01H
	RET
;
;
;
READER	JMP	CONIN
;
;
PUNCH	JMP  	CONOUT
;
LIST	IN 	04H
	ANI	80H
	JZ	LIST
	MOV	A,C
	OUT	05H
	RET
;
;
CITBLE	DW	CITTY
	DW	CICRT
	DW	READER
	DW	CIUC1
COTBLE	DW	COTTY
	DW	COCRT
	DW	LIST
	DW	COUC1
LTBLE	DW	LITTY
	DW	COCRT
	DW	LITTY
	DW	COUL1
PTBLE	DW	COTTY
	DW	COPTP
	DW	COUP1
	DW	COUP2
RTBLE	DW	CITTY
	DW	CIPTR
	DW	CIUR1
	DW	CIUR2
COTTY	EQU	$	
COCRT	EQU	$
COUC1	EQU	$
COLPT	EQU	$
COUL1	EQU	$
COPTP	EQU	$
COUP1	EQU	$
COUP2	EQU	$
;
CHROUT	JMP	CONOUT
;
CITTY	EQU	$
CICRT	EQU	$
CIPTR	EQU	$
CIUC1	EQU	$
CIUR1	EQU	$
CIUR2	EQU	$
	LXI	H,STATUS5
	MOV	A,M
	ORA	A
	JZ 	CHRIN
	MVI	M,0
	RET
;
CHRIN	IN	00
	ANI	40H
	JZ	CHRIN
	IN	01
	ANI	07FH
	RET
;
;
SELDISK	MOV	A,C
	STA	NEWDRV+1
	MOV	L,A
	MVI	H,0
	DAD	H
	DAD	H
	DAD	H
	DAD	H
	LXI	D,DPBASE
	DAD	D
	RET
;
SELDSK	LXI	H,CDISKA
NEWDRV	MVI	A,0
	CMP	M
	MOV	M,A
	RZ
	MOV	C,A
;
SELDSK1	LDA	DRIVE
	PUSH	PSW
	ANI	0F7H
	LXI	H,DTABLE
	PUSH	H
SLOOP	CMP	M
	JZ	FOUND
	INX	H
	INX	H
	JMP	SLOOP
FOUND	INX	H
	LDA	TRACK
	MOV	M,A
	POP	H
	MOV	A,C
	ADD	A
	ADD	L
	MOV	L,A
	JNC	HISOK
	INR	H
HISOK	POP	PSW
	ANI	8
	ORA	M
	STA	STATUS
	STA	DRIVE
	INX	H
	MOV	A,M
	STA	TRACK
	XRA	A
	LXI	D,STATUS
	CALL	DELAY
	LDA	CDISKA
	MOV	L,A
	MVI	H,0
	DAD	H
	DAD	H
	DAD	H
	DAD	H
	LXI	D,DPBASE
	DAD	D
	RET
;
DTABLE	DB	80H
	DB	0
	DB	1
	DB	0
	DB	20H
	DB	0
	DB	2
	DB	0
CDISKA	DB	0
;
SETSEC	MOV	A,C
	STA	SECTORA+1
	RET
;
SECTORA	MVI	C,0
	JMP	SECTOR
;
READ	CALL	SELDSK
	CALL	SECTORA
	MVI	C,10
READ1	PUSH	B
	CALL	DISKR
	POP	B
	ANA	A
	RZ
	DCR	C
	JNZ	READ1
READY	CMA
	RET
;
WRITE	CALL	SELDSK
	CALL	SECTORA
	MVI	C,10
DSKW	PUSH	B
	CALL	DISKW
	POP	B
	ANA	A
	RZ
	DCR	C
	JNZ	DSKW
PROTCT	LDA	STATUS
	ANI	WPTCT
	JZ	READY
	LXI	H,PTCTMSG
MESSG	MOV	A,M
	ANA	A
	RZ
	PUSH	H
	MOV	C,A
	CALL	CHROUT
	POP	H
	INX	H
	JMP	MESSG
;
;
QINIT:	RET
;	MVI	A,0CEH
;	OUT	03
;	OUT	05
;	MVI	A,25H
;	OUT	03
;	OUT	05
;	RET
;
LITTY:	IN	05H
	ANI	01
	JZ	LITTY
	MOV	A,C
	OUT	04H
	RET
;
;
SECTRAN	XCHG
	DAD	B
	MOV	L,M
	MVI	H,0
	RET
;
PROMPT	DS	0
	DB	1AH,0DH,0AH
	DB	0DH,0AH
	DB	'20K CP/M 2.2, '
	DB	'Version '
	DB	'1.1 as of 1/11/82'
	DB	0DH,0AH
	DB	0
PTCTMSG	DB	0DH,0AH
	DB	'PROTECT'
	DB	0DH,0AH
	DB	0
;
DIRBF	DS	128
ALL00	DS	31
ALL01	DS	31
ALL02	DS	31
ALL03	DS	31
CHK00	DS	16
CHK01	DS	16
CHK02	DS	16
CHK03	DS	16
;
;
	END
