	TITLE	'MDBS CALL INTERFACE TYPE 03 PROGRAM'
;PROGRAM
;		MDBS CALL INTERFACE TYPE 03 PROGRAM
;PROGRAMMER
;		ROBERT M. WHITE
;DATE WRITTEN
;		AUGUST 27, 1980
;(C)COPYRIGHT	1980,H & W COMPUTER SYSTEMS, INC.
;PURPOSE
;		THIS ROUTINE INTERFACES FOR ALL MDBS CALLS THAT
;		LOOK LIKE THE FOLLOWING IN PLI:
;			CALL XXX(PARM1,PARM2,RTNCODE);
;		WHERE PARM1 GOES INTO THE DE PARAMETER AND PARM2
;		GOES INTO THE HL PARAMETER.
;REMARKS
;		THIS MODULE CONTAINS SEVERAL ENTRY POINTS
;		WHICH CORRESPOND THE TO THE MDBS FUNCTION
;		NAME BEING CALLED.

;		DO INITIALIZATION.
	NAME	'MDBS02'
MDBS02:	CSEG

;		AMS - ADD MEMBER TO SET
AMS:	DS	0
	PUBLIC	AMS
	MVI	A,01		;GET FUNCTION CODE.
	JMP	MAIN		;PROCESS CALL.

;		CMT - CHECK CURRENT MEMBER TYPE.
CMT:	DS	0
	PUBLIC	CMT
	MVI	A,04		;GET FUNCTION CODE.
	JMP	MAIN		;PROCESS CALL.

;		COT - CHECK CURRENT OWNER TYPE.
COT:	DS	0
	PUBLIC	COT
	MVI	A,05		;GET FUNCTION CODE.
	JMP	MAIN		;PROCESS CALL.

;		SMM - SET CURRENT MEMBER BASED ON CURRENT MEMBER
SMM:	DS	0
	PUBLIC	SMM
	MVI	A,52		;GET FUNCTION CODE.
	JMP	MAIN		;PROCESS CALL.

;		SMO - SET CURRENT MEMBER BASED ON CURRENT OWNER
SMO:	DS	0
	PUBLIC	SMO
	MVI	A,53		;GET FUNCTION CODE.
	JMP	MAIN		;PROCESS CALL.

;		SMR - SET CURRENT MEMBER BASED ON CURRENT RECORD.
SMR:	DS	0
	PUBLIC	SMR
	MVI	A,54		;GET FUNCTION CODE.
	JMP	MAIN		;PROCESS CALL.

;		SOM - SET CURRENT OWNER BASED ON CURRENT MEMBER
SOM:	DS	0
	PUBLIC	SOM
	MVI	A,56		;GET FUNCTION CODE.
	JMP	MAIN		;PROCESS CALL.

;		SOO - SET CURRENT OWNER BASED ON CURRENT OWNER.
SOO:	DS	0
	PUBLIC	SOO
	MVI	A,57		;GET FUNCTION CODE.
	JMP	MAIN		;PROCESS CALL.

;		SOR - SET CURRENT OWNER BASED ON CURRENT RECORD.
SOR:	DS	0
	PUBLIC	SOR
	MVI	A,58		;GET FUNCTION CODE.
	JMP	MAIN		;PROCESS CALL.

;		SCO - SET CURRENT OF RUN UNIT BASED ON OWNER
SCO:	DS	0
	PUBLIC	SCO
	MVI	A,45		;GET FUNCTION CODE.
	JMP	MAIN		;PROCESS CALL.

;		SCR - SET CURRENT OF RUN UNIT BASED ON CURRENT RECORD.
SCR:	DS	0
	PUBLIC	SCR
	MVI	A,46		;GET FUNCTION CODE.
	JMP	MAIN		;PROCESS CALL.

;		SAVE THE FUNCTION CODE.
MAIN:
	STA	FUNC

;		MOVE INPUT PARMS INTO OUTPUT PARM LIST.
	MOV	E,M		;GET FIRST PARM.
	INX	H
	MOV	D,M
	INX	H
	XCHG			;SAVE IT.
	SHLD	PRM3
	XCHG
	MOV	E,M		;GET SECOND PARM.
	INX	H
	MOV	D,M
	INX	H
	XCHG			;SAVE IT.
	SHLD	PRM4
	XCHG
	MOV	E,M		;GET RETURN CODE.
	INX	H
	MOV	D,M
	INX	H
	XCHG			;SAVE IT.
	SHLD	PRM5

;		CALL THE MDBS CALL INTERFACE.
	LXI	H,PRMLST	;POINT TO PARAMETER LIST.
	JMP	MDBSCL		;GO PERFORM THE FUNCTION.
	EXTRN	MDBSCL
	PAGE
;****************************************************************
;*			PROGRAM CONSTANTS			*
;****************************************************************

;		INPUT PARM.
	DSEG
PRMLST:				;PL/1 PARAMETER LIST
PRM1:	DW	FUNC			;FUNCTION CODE
PRM2:	DW	NULCL8			;BC PARM
PRM3:	DW	0			;DE PARM
PRM4:	DW	0			;HL PARM
PRM5:	DW	0			;RETURN CODE
PRM6:	DW	NULPTR			;BLOCK PTR
PRM7:	DW	NULB15			;BLOCK LENGTH
FUNC:	DB	0
NULCL8:	DB	'        '
NULPTR:	DW	0
NULB15:	DW	0
	END
