C GETOBJ--	FIND OBJ DESCRIBED BY ADJ, NAME PAIR
C
C COPYRIGHT 1980, INFOCOM COMPUTERS AND COMMUNICATIONS, CAMBRIDGE MA. 02142
C ALL RIGHTS RESERVED, COMMERCIAL USAGE STRICTLY PROHIBITED
C WRITTEN BY R. M. SUPNIK
C
C DECLARATIONS
C
C THIS ROUTINE DETAILS ON BIT 3 OF PRSFLG
C
	INTEGER FUNCTION GETOBJ(OIDX,AIDX,SPCOBJ)
	IMPLICIT INTEGER(A-Z)
	LOGICAL THISIT,GHERE,LIT,CHOMP,DFLAG
C
	COMMON /OBJFLG/ VABIT,VRBIT,VTBIT,VCBIT,VEBIT,VFBIT,VPMASK
C
C GAME STATE
C
	LOGICAL TELFLG
	COMMON /PLAY/ WINNER,HERE,TELFLG
C
C MISCELLANEOUS VARIABLES
C
	COMMON /STAR/ MBASE,STRBIT
	COMMON /DEBUG/ DBGFLG,PRSFLG
C
C OBJECTS
C
	COMMON /OBJCTS/ OLNT,ODESC1(220),ODESC2(220),ODESCO(220),
	1	OACTIO(220),OFLAG1(220),OFLAG2(220),OFVAL(220),
	2	OTVAL(220),OSIZE(220),OCAPAC(220),OROOM(220),
	3	OADV(220),OCAN(220),OREAD(220)
C
	COMMON /OFLAGS/ VISIBT,READBT,TAKEBT,DOORBT,TRANBT,FOODBT,
	1	NDSCBT,DRNKBT,CONTBT,LITEBT,VICTBT,BURNBT,FLAMBT,
	2	TOOLBT,TURNBT,ONBT
	COMMON /OFLAGS/ FINDBT,SLEPBT,SCRDBT,TIEBT,CLMBBT,ACTRBT,
	1	WEAPBT,FITEBT,VILLBT,STAGBT,TRYBT,NOCHBT,OPENBT,
	2	TCHBT,VEHBT,SCHBT
C
C ADVENTURERS
C
	COMMON /ADVS/ ALNT,AROOM(4),ASCORE(4),AVEHIC(4),
	1	AOBJ(4),AACTIO(4),ASTREN(4),AFLAG(4)
C
C VOCABULARIES
C
	COMMON /OBJVOC/ OVOC(1050)
C GETOBJ, PAGE 2
C
D	DFLAG=(PRSFLG.AND."10).NE.0
	CHOMP=.FALSE.
	AV=AVEHIC(WINNER)
	OBJ=0					!ASSUME DARK.
	IF(.NOT.LIT(HERE)) GO TO 200		!LIT?
C
	OBJ=SCHLST(OIDX,AIDX,HERE,0,0,SPCOBJ)	!SEARCH ROOM.
D	IF(DFLAG) TYPE 10,OBJ
D10	FORMAT(' SCHLST- ROOM SCH ',I6)
	IF(OBJ) 1000,200,100			!TEST RESULT.
100	IF((AV.EQ.0).OR.(AV.EQ.OBJ).OR.
	1	((OFLAG2(OBJ).AND.FINDBT).NE.0)) GO TO 200
	IF(OCAN(OBJ).EQ.AV) GO TO 200		!TEST IF REACHABLE.
	CHOMP=.TRUE.				!PROBABLY NOT.
C
200	IF(AV.EQ.0) GO TO 400			!IN VEHICLE?
	NOBJ=SCHLST(OIDX,AIDX,0,AV,0,SPCOBJ)	!SEARCH VEHICLE.
D	IF(DFLAG) TYPE 20,NOBJ
D20	FORMAT(' SCHLST- VEH SCH  ',I6)
	IF(NOBJ) 1100,400,300			!TEST RESULT.
300	CHOMP=.FALSE.				!REACHABLE.
	IF(OBJ.EQ.NOBJ) GO TO 400		!SAME AS BEFORE?
	IF(OBJ.NE.0) NOBJ=-NOBJ			!AMB RESULT?
	OBJ=NOBJ
C
400	NOBJ=SCHLST(OIDX,AIDX,0,0,WINNER,SPCOBJ)	!SEARCH ADVENTURER.
D	IF(DFLAG) TYPE 30,NOBJ
D30	FORMAT(' SCHLST- ADV SCH  ',I6)
	IF(NOBJ) 1100,600,500			!TEST RESULT
500	IF(OBJ.NE.0) NOBJ=-NOBJ			!AMB RESULT?
1100	OBJ=NOBJ				!RETURN NEW OBJECT.
600	IF(CHOMP) OBJ=-10000			!UNREACHABLE.
1000	GETOBJ=OBJ
C
	IF(GETOBJ.NE.0) GO TO 1500		!GOT SOMETHING?
	DO 1200 I=STRBIT+1,OLNT			!NO, SEARCH GLOBALS.
	  IF(.NOT.THISIT(OIDX,AIDX,I,SPCOBJ)) GO TO 1200
	  IF(.NOT.GHERE(I,HERE)) GO TO 1200	!CAN IT BE HERE?
	  IF(GETOBJ.NE.0) GETOBJ=-I		!AMB MATCH?
	  IF(GETOBJ.EQ.0) GETOBJ=I
1200	CONTINUE
C
1500	CONTINUE				!END OF SEARCH.
D	IF(DFLAG) TYPE 40,GETOBJ
D40	FORMAT(' SCHLST- RESULT   ',I6)
	RETURN
	END
C SCHLST--	SEARCH FOR OBJECT
C
C DECLARATIONS
C
	INTEGER FUNCTION SCHLST(OIDX,AIDX,RM,CN,AD,SPCOBJ)
	IMPLICIT INTEGER(A-Z)
	LOGICAL THISIT,QHERE,NOTRAN,NOVIS
C
	COMMON /STAR/ MBASE,STRBIT
C
C OBJECTS
C
	COMMON /OBJCTS/ OLNT,ODESC1(220),ODESC2(220),ODESCO(220),
	1	OACTIO(220),OFLAG1(220),OFLAG2(220),OFVAL(220),
	2	OTVAL(220),OSIZE(220),OCAPAC(220),OROOM(220),
	3	OADV(220),OCAN(220),OREAD(220)
C
	COMMON /OFLAGS/ VISIBT,READBT,TAKEBT,DOORBT,TRANBT,FOODBT,
	1	NDSCBT,DRNKBT,CONTBT,LITEBT,VICTBT,BURNBT,FLAMBT,
	2	TOOLBT,TURNBT,ONBT
	COMMON /OFLAGS/ FINDBT,SLEPBT,SCRDBT,TIEBT,CLMBBT,ACTRBT,
	1	WEAPBT,FITEBT,VILLBT,STAGBT,TRYBT,NOCHBT,OPENBT,
	2	TCHBT,VEHBT,SCHBT
C
C FUNCTIONS AND DATA
C
	NOTRAN(O)=((OFLAG1(O).AND.TRANBT).EQ.0).AND.
	1	((OFLAG2(O).AND.OPENBT).EQ.0)
	NOVIS(O)=((OFLAG1(O).AND.VISIBT).EQ.0)
C
	SCHLST=0					!NO RESULT.
	DO 1000 I=1,OLNT			!SEARCH OBJECTS.
	  IF(NOVIS(I).OR.
	1	(((RM.EQ.0).OR.(.NOT.QHERE(I,RM))).AND.
	2	 ((CN.EQ.0).OR.(OCAN(I).NE.CN)).AND.
	3	 ((AD.EQ.0).OR.(OADV(I).NE.AD)))) GO TO 1000
	  IF(.NOT.THISIT(OIDX,AIDX,I,SPCOBJ)) GO TO 200
	  IF(SCHLST.NE.0) GO TO 2000		!GOT ONE ALREADY?
	  SCHLST=I					!NO.
C
C IF OPEN OR TRANSPARENT, SEARCH THE OBJECT ITSELF.
C
200	  IF(NOTRAN(I)) GO TO 1000
C
C SEARCH IS CONDUCTED IN REVERSE.  ALL OBJECTS ARE CHECKED TO
C SEE IF THEY ARE AT SOME LEVEL OF CONTAINMENT INSIDE OBJECT 'I'.
C IF THEY ARE AT LEVEL 1, OR IF ALL LINKS IN THE CONTAINMENT
C CHAIN ARE OPEN, VISIBLE, AND HAVE SEARCHME SET, THEY CAN QUALIFY
C AS A POTENTIAL MATCH.
C
	  DO 500 J=1,OLNT			!SEARCH OBJECTS.
	    IF(NOVIS(J).OR. (.NOT.THISIT(OIDX,AIDX,J,SPCOBJ)))
	1	GO TO 500			!VISIBLE & MATCH?
	    X=OCAN(J)				!GET CONTAINER.
300	    IF(X.EQ.I) GO TO 400		!INSIDE TARGET?
	    IF(X.EQ.0) GO TO 500		!INSIDE ANYTHING?
	    IF(NOVIS(X).OR.NOTRAN(X).OR.
	1	((OFLAG2(X).AND.SCHBT).EQ.0)) GO TO 500
	    X=OCAN(X)				!GO ANOTHER LEVEL.
	    GO TO 300
C
400	    IF(SCHLST.NE.0) GO TO 2000		!ALREADY GOT ONE?
	    SCHLST=J				!NO.
500	  CONTINUE
C
1000	CONTINUE
	RETURN
C
2000	SCHLST=-SCHLST				!AMB RETURN.
	RETURN
C
	END
C THISIT--	VALIDATE OBJECT VS DESCRIPTION
C
C DECLARATIONS
C
	LOGICAL FUNCTION THISIT(OIDX,AIDX,OBJ,SPCOBJ)
	IMPLICIT INTEGER(A-Z)
	LOGICAL NOTEST
C
C VOCABULARIES
C
	COMMON /OBJVOC/ OVOC(1050)
	COMMON /ADJVOC/ AVOC(450)
C
C FUNCTIONS AND DATA
C
	NOTEST(O)=(O.LE.0).OR.(O.GE.R50MIN)
	DATA R50MIN/1RA/
C
	THISIT=.FALSE.				!ASSUME NO MATCH.
	IF((SPCOBJ.NE.0).AND.(OBJ.EQ.SPCOBJ)) GO TO 500
C
C CHECK FOR OBJECT NAMES
C
	I=OIDX+1
100	I=I+1
	IF(NOTEST(OVOC(I))) RETURN		!IF DONE, LOSE.
	IF(OVOC(I).NE.OBJ) GO TO 100		!IF FAIL, CONT.
C
	IF(AIDX.EQ.0) GO TO 500			!ANY ADJ?
	I=AIDX+1
200	I=I+1
	IF(NOTEST(AVOC(I))) RETURN		!IF DONE, LOSE.
	IF(AVOC(I).NE.OBJ) GO TO 200		!IF FAIL, CONT.
C
500	THISIT=.TRUE.
	RETURN
	END
