C NOBJS-	NEW OBJECTS PROCESSOR
C	OBJECTS IN THIS MODULE CANNOT CALL RMINFO, JIGSUP,
C	MAJOR VERBS, OR OTHER NON-RESIDENT SUBROUTINES
C
C COPYRIGHT 1980, INFOCOM COMPUTERS AND COMMUNICATIONS, CAMBRIDGE MA. 02142
C ALL RIGHTS RESERVED, COMMERCIAL USAGE STRICTLY PROHIBITED
C WRITTEN BY R. M. SUPNIK
C
C DECLARATIONS
C
	LOGICAL FUNCTION NOBJS(RI,ARG)
	IMPLICIT INTEGER (A-Z)
	LOGICAL QOPEN,MOVETO,F
	LOGICAL QHERE,OPNCLS,MIRPAN
C
C PARSER OUTPUT
C
	LOGICAL PRSWON
	COMMON /PRSVEC/ PRSA,PRSI,PRSO,PRSWON,PRSCON
C
C GAME STATE
C
	LOGICAL TELFLG
	COMMON /PLAY/ WINNER,HERE,TELFLG
	COMMON /STATE/ MOVES,DEATHS,RWSCOR,MXSCOR,MXLOAD,
	1	LTSHFT,BLOC,MUNGRM,HS,EGSCOR,EGMXSC
C
C SCREEN OF LIGHT
C
	COMMON /SCREEN/ FROMDR,SCOLRM,SCOLAC
	COMMON /SCREEN/ SCOLDR(8),SCOLWL(12)
C
C PUZZLE ROOM
C
	COMMON /PUZZLE/ CPDR(16),CPWL(8),CPVEC(64)
C
C MISCELLANEOUS VARIABLES
C
	COMMON /HYPER/ HFACTR
C
C ROOMS
C
	COMMON /ROOMS/ RLNT,RDESC2,RDESC1(200),REXIT(200),
	1	RACTIO(200),RVAL(200),RFLAG(200)
	INTEGER RRAND(200)
	EQUIVALENCE (RVAL,RRAND)
C
	COMMON /RFLAG/ RSEEN,RLIGHT,RLAND,RWATER,RAIR,
	1	RSACRD,RFILL,RMUNG,RBUCK,RHOUSE,RNWALL,REND
C
	COMMON /RINDEX/ WHOUS,LROOM,CELLA
	COMMON /RINDEX/ MTROL,MAZE1	
	COMMON /RINDEX/ MGRAT,MAZ15	
	COMMON /RINDEX/ FORE1,FORE3,CLEAR,RESER
	COMMON /RINDEX/ STREA,EGYPT,ECHOR
	COMMON /RINDEX/ TSHAF	
	COMMON /RINDEX/ BSHAF,MMACH,DOME,MTORC
	COMMON /RINDEX/ CAROU	
	COMMON /RINDEX/ RIDDL,LLD2,TEMP1,TEMP2,MAINT
	COMMON /RINDEX/ BLROO,TREAS,RIVR1,RIVR2,RIVR3,MCYCL
	COMMON /RINDEX/ RIVR4,RIVR5,FCHMP,FALLS,MBARR
	COMMON /RINDEX/ MRAIN,POG,VLBOT,VAIR1,VAIR2,VAIR3,VAIR4
	COMMON /RINDEX/ LEDG2,LEDG3,LEDG4,MSAFE,CAGER
	COMMON /RINDEX/ CAGED,TWELL,BWELL,ALICE,ALISM,ALITR
	COMMON /RINDEX/ MTREE,BKENT,BKVW,BKTWI,BKVAU,BKBOX
	COMMON /RINDEX/ CRYPT,TSTRS,MRANT,MREYE
	COMMON /RINDEX/ MRA,MRB,MRC,MRG,MRD,FDOOR
	COMMON /RINDEX/ MRAE,MRCE,MRCW,MRGE,MRGW,MRDW,INMIR
	COMMON /RINDEX/ SCORR,NCORR,PARAP,CELL,PCELL,NCELL
	COMMON /RINDEX/ CPANT,CPOUT,CPUZZ
C
C OBJECTS
C
	COMMON /OBJCTS/ OLNT,ODESC1(220),ODESC2(220),ODESCO(220),
	1	OACTIO(220),OFLAG1(220),OFLAG2(220),OFVAL(220),
	2	OTVAL(220),OSIZE(220),OCAPAC(220),OROOM(220),
	3	OADV(220),OCAN(220),OREAD(220)
C
	COMMON /OFLAGS/ VISIBT,READBT,TAKEBT,DOORBT,TRANBT,FOODBT,
	1	NDSCBT,DRNKBT,CONTBT,LITEBT,VICTBT,BURNBT,FLAMBT,
	2	TOOLBT,TURNBT,ONBT
	COMMON /OFLAGS/ FINDBT,SLEPBT,SCRDBT,TIEBT,CLMBBT,ACTRBT,
	1	WEAPBT,FITEBT,VILLBT,STAGBT,TRYBT,NOCHBT,OPENBT,
	2	TCHBT,VEHBT,SCHBT
C
	COMMON /OINDEX/ GARLI,FOOD,GUNK,COAL,MACHI,DIAMO,TCASE,BOTTL
	COMMON /OINDEX/ WATER,ROPE,KNIFE,SWORD,LAMP,BLAMP,RUG
	COMMON /OINDEX/	LEAVE,TROLL,AXE
	COMMON /OINDEX/ RKNIF,KEYS,ICE,BAR
	COMMON /OINDEX/ COFFI,TORCH,TBASK,FBASK,IRBOX
	COMMON /OINDEX/ GHOST,TRUNK,BELL,BOOK,CANDL
	COMMON /OINDEX/ MATCH,TUBE,PUTTY,WRENC,SCREW,CYCLO,CHALI
	COMMON /OINDEX/ THIEF,STILL,WINDO,GRATE,DOOR
	COMMON /OINDEX/ HPOLE,LEAK,RBUTT,RAILI
	COMMON /OINDEX/ POT,STATU,IBOAT,DBOAT,PUMP,RBOAT
	COMMON /OINDEX/ STICK,BUOY,SHOVE,BALLO,RECEP,GUANO
	COMMON /OINDEX/ BROPE,HOOK1,HOOK2,SAFE,SSLOT,BRICK,FUSE
	COMMON /OINDEX/ GNOME,BLABE,DBALL,TOMB
	COMMON /OINDEX/ LCASE,CAGE,RCAGE,SPHER,SQBUT
	COMMON /OINDEX/ FLASK,POOL,SAFFR,BUCKE,ECAKE,ORICE,RDICE,BLICE
	COMMON /OINDEX/ ROBOT,FTREE,BILLS,PORTR,SCOL,ZGNOM
	COMMON /OINDEX/ EGG,BEGG,BAUBL,CANAR,BCANA
	COMMON /OINDEX/ YLWAL,RDWAL,PINDR,RBEAM
	COMMON /OINDEX/ ODOOR,QDOOR,CDOOR,NUM1,NUM8
	COMMON /OINDEX/ WARNI,CSLIT,GCARD,STLDR
	COMMON /OINDEX/ HANDS,WALL,LUNGS,SAILO,AVIAT,TEETH
	COMMON /OINDEX/ ITOBJ,EVERY,VALUA,OPLAY,WNORT,GWATE,MASTER
C
C CLOCK INTERRUPTS
C
	LOGICAL*1 CFLAG
	COMMON /CEVENT/ CLNT,CTICK(25),CACTIO(25),CFLAG(25)
C
	COMMON /CINDEX/ CEVCUR,CEVMNT,CEVLNT,CEVMAT,CEVCND,
	1	CEVBAL,CEVBRN,CEVFUS,CEVLED,CEVSAF,CEVVLG,
	2	CEVGNO,CEVBUC,CEVSPH,CEVEGH,
	3	CEVFOR,CEVSCL,CEVZGI,CEVZGO,CEVSTE,
	5	CEVMRS,CEVPIN,CEVINQ,CEVFOL

C
C VILLAINS AND DEMONS
C
	LOGICAL THFFLG,SWDACT,THFACT
	COMMON /HACK/ THFPOS,THFFLG,THFACT,SWDACT,SWDSTA
C
C ADVENTURERS
C
	COMMON /ADVS/ ALNT,AROOM(4),ASCORE(4),AVEHIC(4),
	1	AOBJ(4),AACTIO(4),ASTREN(4),AFLAG(4)
C
	COMMON /AINDEX/ PLAYER,AROBOT,AMASTR
C
C VERBS
C
	COMMON /VINDEX/ CINTW,DEADXW,FRSTQW,INXW,OUTXW
	COMMON /VINDEX/ WALKIW,FIGHTW,FOOW
	COMMON /VINDEX/ MELTW,READW,INFLAW,DEFLAW,ALARMW,EXORCW
	COMMON /VINDEX/ PLUGW,KICKW,WAVEW,RAISEW,LOWERW,RUBW
	COMMON /VINDEX/ PUSHW,UNTIEW,TIEW,TIEUPW,TURNW,BREATW
	COMMON /VINDEX/ KNOCKW,LOOKW,EXAMIW,SHAKEW,MOVEW,TRNONW,TRNOFW
	COMMON /VINDEX/ OPENW,CLOSEW,FINDW,WAITW,SPINW,BOARDW,UNBOAW,TAKEW
	COMMON /VINDEX/ INVENW,FILLW,EATW,DRINKW,BURNW
	COMMON /VINDEX/ MUNGW,KILLW,ATTACW,SWINGW
	COMMON /VINDEX/ WALKW,TELLW,PUTW,DROPW,GIVEW,POURW,THROWW
	COMMON /VINDEX/ DIGW,LEAPW,STAYW,FOLLOW
	COMMON /VINDEX/ HELLOW,LOOKIW,LOOKUW,PUMPW,WINDW
	COMMON /VINDEX/ CLMBW,CLMBUW,CLMBDW,TRNTOW
C
C FLAGS
C
	LOGICAL*1 TROLLF,CAGESF,BUCKTF,CAROFF,CAROZF,LWTIDF
	LOGICAL*1 DOMEF,GLACRF,ECHOF,RIDDLF,LLDF,CYCLOF
	LOGICAL*1 MAGICF,LITLDF,SAFEF,GNOMEF,GNODRF,MIRRMF
	LOGICAL*1 EGYPTF,ONPOLF,BLABF,BRIEFF,SUPERF,BUOYF
	LOGICAL*1 GRUNLF,GATEF,RAINBF,CAGETF,EMPTHF,DEFLAF
	LOGICAL*1 GLACMF,FROBZF,ENDGMF,BADLKF,THFENF,SINGSF
	LOGICAL*1 MRPSHF,MROPNF,WDOPNF,MR1F,MR2F,INQSTF
	LOGICAL*1 FOLLWF,SPELLF,CPOUTF,CPUSHF
	COMMON /FINDEX/ TROLLF,CAGESF,BUCKTF,CAROFF,CAROZF,LWTIDF,
	1	DOMEF,GLACRF,ECHOF,RIDDLF,LLDF,CYCLOF,
	2	MAGICF,LITLDF,SAFEF,GNOMEF,GNODRF,MIRRMF,
	3	EGYPTF,ONPOLF,BLABF,BRIEFF,SUPERF,BUOYF,
	4	GRUNLF,GATEF,RAINBF,CAGETF,EMPTHF,DEFLAF,
	5	GLACMF,FROBZF,ENDGMF,BADLKF,THFENF,SINGSF,
	6	MRPSHF,MROPNF,WDOPNF,MR1F,MR2F,INQSTF,
	7	FOLLWF,SPELLF,CPOUTF,CPUSHF
	COMMON /FINDEX/ BTIEF,BINFF
	COMMON /FINDEX/ RVMNT,RVCLR,RVCYC,RVSND,RVGUA
	COMMON /FINDEX/ ORRUG,ORCAND,ORMTCH,ORLAMP
	COMMON /FINDEX/ MDIR,MLOC,POLEUF
	COMMON /FINDEX/ QUESNO,NQATT,CORRCT
	COMMON /FINDEX/ LCELL,PNUMB,ACELL,DCELL,CPHERE
C
C FUNCTIONS AND DATA
C
	QOPEN(R)=(OFLAG2(R).AND.OPENBT).NE.0
C NOBJS, PAGE 2
C
	IF(PRSO.NE.0) ODO2=ODESC2(PRSO)
	IF(PRSI.NE.0) ODI2=ODESC2(PRSI)
	AV=AVEHIC(WINNER)
	NOBJS=.TRUE.
C
	GO TO (1000,2000,3000,4000,5000,6000,7000,8000,9000,
	1 10000,11000,12000,13000,14000,15000,16000,17000,
	2 18000,19000,20000,21000),
	3	(RI-31)
	CALL BUG(6,RI)
C
C RETURN HERE TO DECLARE FALSE RESULT
C
10	NOBJS=.FALSE.
	RETURN
C
C O32--	BILLS
C
1000	IF(PRSA.NE.EATW) GO TO 1100		!EAT?
	CALL RSPEAK(639)			!JOKE.
	RETURN
C
1100	IF(PRSA.EQ.BURNW) CALL RSPEAK(640)	!BURN?  JOKE.
	GO TO 10				!LET IT BE HANDLED.
C NOBJS, PAGE 3
C
C O33--	SCREEN OF LIGHT
C
2000	TARGET=SCOL				!TARGET IS SCOL.
2100	IF(PRSO.NE.TARGET) GO TO 2400		!PRSO EQ TARGET?
	IF((PRSA.NE.PUSHW).AND.(PRSA.NE.MOVEW).AND.
	1	(PRSA.NE.TAKEW).AND.(PRSA.NE.RUBW)) GO TO 2200
	CALL RSPEAK(673)			!HAND PASSES THRU.
	RETURN
C
2200	IF((PRSA.NE.KILLW).AND.(PRSA.NE.ATTACW).AND.
	1	(PRSA.NE.MUNGW)) GO TO 2400	!AGGRESSIVE?
	CALL RSPSUB(674,ODI2)			!PASSES THRU.
	RETURN
C
2400	IF((PRSA.NE.THROWW).OR.(PRSI.NE.TARGET)) GO TO 10
	IF(HERE.EQ.BKBOX) GO TO 2600		!THRU SCOL?
	CALL NEWSTA(PRSO,0,BKBOX,0,0)		!NO, THRU WALL.
	CALL RSPSUB(675,ODO2)			!ENDS UP IN BOX ROOM.
	CTICK(CEVSCL)=0				!CANCEL ALARM.
	SCOLRM=0				!RESET SCOL ROOM.
	RETURN
C
2600	IF(SCOLRM.EQ.0) GO TO 2900		!TRIED TO GO THRU?
	CALL NEWSTA(PRSO,0,SCOLRM,0,0)		!SUCCESS.
	CALL RSPSUB(676,ODO2)			!ENDS UP SOMEWHERE.
	CTICK(CEVSCL)=0			!CANCEL ALARM.
	SCOLRM=0				!RESET SCOL ROOM.
	RETURN
C
2900	CALL RSPEAK(213)			!CANT DO IT.
	RETURN
C NOBJS, PAGE 4
C
C O34--	GNOME OF ZURICH
C
3000	IF((PRSA.NE.GIVEW).AND.(PRSA.NE.THROWW)) GO TO 3200
	IF(OTVAL(PRSO).NE.0) GO TO 3100		!THROW A TREASURE?
	CALL NEWSTA(PRSO,641,0,0,0)		!NO, GO POP.
	RETURN
C
3100	CALL NEWSTA(PRSO,0,0,0,0)		!YES, BYE BYE TREASURE.
	CALL RSPSUB(642,ODO2)
	CALL NEWSTA(ZGNOM,0,0,0,0)		!BYE BYE GNOME.
	CTICK(CEVZGO)=0				!CANCEL EXIT.
	F=MOVETO(BKENT,WINNER)			!NOW IN BANK ENTRANCE.
	RETURN
C
3200	IF((PRSA.NE.ATTACW).AND.(PRSA.NE.KILLW).AND.
	1	(PRSA.NE.MUNGW)) GO TO 3300	!AGGRESSIVE?
	CALL NEWSTA(ZGNOM,643,0,0,0)		!VANISH GNOME.
	CTICK(CEVZGO)=0				!CANCEL EXIT.
	RETURN
C
3300	CALL RSPEAK(644)			!GNOME IS IMPATIENT.
	RETURN
C
C O35--	EGG
C
4000	IF((PRSA.NE.OPENW).OR.(PRSO.NE.EGG)) GO TO 4500
	IF(.NOT.QOPEN(EGG)) GO TO 4100		!OPEN ALREADY?
	CALL RSPEAK(649)			!YES.
	RETURN
C
4100	IF(PRSI.NE.0) GO TO 4200		!WITH SOMETHING?
	CALL RSPEAK(650)			!NO, CANT.
	RETURN
C
4200	IF(PRSI.NE.HANDS) GO TO 4300		!WITH HANDS?
	CALL RSPEAK(651)			!NOT RECOMMENDED.
	RETURN
C
4300	I=652					!MUNG MESSAGE.
	IF(((OFLAG1(PRSI).AND.TOOLBT).NE.0).OR.
	1	((OFLAG2(PRSI).AND.WEAPBT).NE.0)) GO TO 4600
	I=653					!NOVELTY 1.
	IF((OFLAG2(PRSO).AND.FITEBT).NE.0) I=654 !NOVELTY 2.
	OFLAG2(PRSO)=OFLAG2(PRSO).OR.FITEBT
	CALL RSPSUB(I,ODI2)
	RETURN
C
4500	IF((PRSA.NE.OPENW).AND.(PRSA.NE.MUNGW)) GO TO 4800
	I=655					!YOU BLEW IT.
4600	CALL NEWSTA(BEGG,I,OROOM(EGG),OCAN(EGG),OADV(EGG))
	CALL NEWSTA(EGG,0,0,0,0)		!VANISH EGG.
	OTVAL(BEGG)=2				!BAD EGG HAS VALUE.
	IF(OCAN(CANAR).NE.EGG) GO TO 4700	!WAS CANARY INSIDE?
	CALL RSPEAK(ODESCO(BCANA))		!YES, DESCRIBE RESULT.
	OTVAL(BCANA)=1
	RETURN
C
4700	CALL NEWSTA(BCANA,0,0,0,0)		!NO, VANISH IT.
	RETURN
C
4800	IF((PRSA.NE.DROPW).OR.(HERE.NE.MTREE)) GO TO 10
	CALL NEWSTA(BEGG,658,FORE3,0,0)	!DROPPED EGG.
	CALL NEWSTA(EGG,0,0,0,0)
	OTVAL(BEGG)=2
	IF(OCAN(CANAR).NE.EGG) GO TO 4700
	OTVAL(BCANA)=1			!BAD CANARY.
	RETURN
C NOBJS, PAGE 5
C
C O36--	CANARIES, GOOD AND BAD
C
5000	IF(PRSA.NE.WINDW) GO TO 10		!WIND EM UP?
	IF(PRSO.EQ.CANAR) GO TO 5100		!RIGHT ONE?
	CALL RSPEAK(645)			!NO, BAD NEWS.
	RETURN
C
5100	IF(.NOT.SINGSF.AND.((HERE.EQ.MTREE).OR.
	1	((HERE.GE.FORE1).AND.(HERE.LT.CLEAR))))
	2	GO TO 5200			!FIRST SONG IN FOR?
	CALL RSPEAK(646)			!NO, MEDIOCRE NEWS.
	RETURN
C
5200	SINGSF=.TRUE.				!SANG SONG.
	I=HERE
	IF(I.EQ.MTREE) I=FORE3			!PLACE BAUBLE.
	CALL NEWSTA(BAUBL,647,I,0,0)
	RETURN
C
C O37--	WHITE CLIFFS
C
6000	IF((PRSA.NE.CLMBW).AND.(PRSA.NE.CLMBUW).AND.
	1	(PRSA.NE.CLMBDW)) GO TO 10	!CLIMB?
	CALL RSPEAK(648)			!OH YEAH?
	RETURN
C
C O38--	WALL 
C
7000	IF((IABS(HERE-MLOC).NE.1).OR.(MRHERE(HERE).NE.0).OR.
	1	(PRSA.NE.PUSHW)) GO TO 7100
	CALL RSPEAK(860)			!PUSHED MIRROR WALL.
	RETURN
C
7100	IF((RFLAG(HERE).AND.RNWALL).EQ.0) GO TO 10
	CALL RSPEAK(662)			!NO WALL.
	RETURN
C NOBJS, PAGE 6
C
C O39--	SONG BIRD GLOBAL
C
8000	IF(PRSA.NE.FINDW) GO TO 8100		!FIND?
	CALL RSPEAK(666)
	RETURN
C
8100	IF(PRSA.NE.EXAMIW) GO TO 10		!EXAMINE?
	CALL RSPEAK(667)
	RETURN
C
C O40--	PUZZLE/SCOL WALLS
C
9000	IF(HERE.NE.CPUZZ) GO TO 9500		!PUZZLE WALLS?
	IF(PRSA.NE.PUSHW) GO TO 10		!PUSH?
	DO 9100 I=1,8,2				!LOCATE WALL.
	  IF(PRSO.EQ.CPWL(I)) GO TO 9200
9100	CONTINUE
	CALL BUG(80,PRSO)			!WHAT?
C
9200	J=CPWL(I+1)				!GET DIRECTIONAL OFFSET.
	NXT=CPHERE+J				!GET NEXT STATE.
	WL=CPVEC(NXT)				!GET C(NEXT STATE).
	GO TO (9300,9300,9300,9250,9350),(WL+4)	!PROCESS.
C
9250	CALL RSPEAK(876)			!CLEAR CORRIDOR.
	RETURN
C
9300	IF(CPVEC(NXT+J).EQ.0) GO TO 9400	!MOVABLE, ROOM TO MOVE?
9350	CALL RSPEAK(877)			!IMMOVABLE, NO ROOM.
	RETURN
C
9400	I=878					!ASSUME FIRST PUSH.
	IF(CPUSHF) I=879			!NOT?
	CPUSHF=.TRUE.
	CPVEC(NXT+J)=WL				!MOVE WALL.
	CPVEC(NXT)=0				!VACATE NEXT STATE.
	CALL CPGOTO(NXT)			!ONWARD.
	CALL CPINFO(I,NXT)			!DESCRIBE.
	CALL PRINCR(.TRUE.,HERE)		!PRINT ROOMS CONTENTS.
	RFLAG(HERE)=RFLAG(HERE).OR.RSEEN
	RETURN
C
9500	IF(HERE.NE.SCOLAC) GO TO 9700		!IN SCOL ACTIVE ROOM?
	DO 9600 I=1,12,3
	  TARGET=SCOLWL(I+1)			!ASSUME TARGET.
	  IF(SCOLWL(I).EQ.HERE) GO TO 2100	!TREAT IF FOUND.
9600	CONTINUE
C
9700	IF(HERE.NE.BKBOX) GO TO 10		!IN BOX ROOM?
	TARGET=WNORT
	GO TO 2100
C NOBJS, PAGE 7
C
C O41--	SHORT POLE
C
10000	IF(PRSA.NE.RAISEW) GO TO 10100		!LIFT?
	I=749					!ASSUME UP.
	IF(POLEUF.EQ.2) I=750			!ALREADY UP?
	CALL RSPEAK(I)
	POLEUF=2				!POLE IS RAISED.
	RETURN
C
10100	IF((PRSA.NE.LOWERW).AND.(PRSA.NE.PUSHW)) GO TO 10
	IF(POLEUF.NE.0) GO TO 10200		!ALREADY LOWERED?
	CALL RSPEAK(751)			!CANT DO IT.
	RETURN
C
10200	IF(MOD(MDIR,180).NE.0) GO TO 10300	!MIRROR N-S?
	POLEUF=0				!YES, LOWER INTO
	CALL RSPEAK(752)			!CHANNEL.
	RETURN
C
10300	IF((MDIR.NE.270).OR.(MLOC.NE.MRB)) GO TO 10400
	POLEUF=0				!LOWER INTO HOLE.
	CALL RSPEAK(753)
	RETURN
C
10400	CALL RSPEAK(753+POLEUF)			!POLEUF = 1 OR 2.
	POLEUF=1				!NOW ON FLOOR.
	RETURN
C
C O42--	MIRROR SWITCH
C
11000	IF(PRSA.NE.PUSHW) GO TO 10		!PUSH?
	IF(MRPSHF) GO TO 11300			!ALREADY PUSHED?
	CALL RSPEAK(756)			!BUTTON GOES IN.
	DO 11100 I=1,OLNT			!BLOCKED?
	  IF(QHERE(I,MREYE).AND.(I.NE.RBEAM)) GO TO 11200
11100	CONTINUE
	CALL RSPEAK(757)			!NOTHING IN BEAM.
	RETURN
C
11200	CFLAG(CEVMRS)=.TRUE.			!MIRROR OPENS.
	CTICK(CEVMRS)=7
	MRPSHF=.TRUE.
	MROPNF=.TRUE.
	RETURN
C
11300	CALL RSPEAK(758)			!MIRROR ALREADYOPEN.
	RETURN
C NOBJS, PAGE 8
C
C O43--	BEAM FUNCTION
C
12000	IF((PRSA.NE.TAKEW).OR.(PRSO.NE.RBEAM)) GO TO 12100
	CALL RSPEAK(759)			!TAKE BEAM, JOKE.
	RETURN
C
12100	I=PRSO					!ASSUME BLK WITH DIROBJ.
	IF((PRSA.EQ.PUTW).AND.(PRSI.EQ.RBEAM)) GO TO 12200
	IF((PRSA.NE.MUNGW).OR.(PRSO.NE.RBEAM).OR.
	1	(PRSI.EQ.0)) GO TO 10		!BREAK BEAM WITH X?
	I=PRSI
12200	IF(OADV(I).NE.WINNER) GO TO 12300	!CARRYING?
	CALL NEWSTA(I,0,HERE,0,0)		!DROP OBJ.
	CALL RSPSUB(760,ODESC2(I))
	RETURN
C
12300	J=761					!ASSUME NOT IN ROOM.
	IF(QHERE(J,HERE)) I=762			!IN ROOM?
	CALL RSPSUB(J,ODESC2(I))		!DESCRIBE.
	RETURN
C
C O44--	BRONZE DOOR
C
13000	IF((HERE.EQ.NCELL).OR.((LCELL.EQ.4).AND.
	1	((HERE.EQ.CELL).OR.(HERE.EQ.SCORR))))
	2	GO TO 13100
	CALL RSPEAK(763)			!DOOR NOT THERE.
	RETURN
C
13100	IF(.NOT.OPNCLS(ODOOR,764,765)) GO TO 10	!OPEN/CLOSE?
	IF((HERE.EQ.NCELL).AND.QOPEN(ODOOR))
	1	CALL RSPEAK(766)		!DESCR VIEW.
	RETURN
C
C O45--	QUIZ DOOR
C
14000	IF((PRSA.NE.OPENW).AND.(PRSA.NE.CLOSEW)) GO TO 14100
	CALL RSPEAK(767)			!DOOR WONT MOVE.
	RETURN
C
14100	IF(PRSA.NE.KNOCKW) GO TO 10		!KNOCK?
	IF(INQSTF) GO TO 14200		!TRIED IT ALREADY?
	INQSTF=.TRUE.				!START INQUISITION.
	CFLAG(CEVINQ)=.TRUE.
	CTICK(CEVINQ)=2
	QUESNO=RND(8)				!SELECT QUESTION.
	NQATT=0
	CORRCT=0
	CALL RSPEAK(768)			!ANNOUNCE RULES.
	CALL RSPEAK(769)
	CALL RSPEAK(770+QUESNO)			!ASK QUESTION.
	RETURN
C
14200	CALL RSPEAK(798)			!NO REPLY.
	RETURN
C
C O46--	LOCKED DOOR
C
15000	IF(PRSA.NE.OPENW) GO TO 10		!OPEN?
	CALL RSPEAK(778)			!CANT.
	RETURN
C
C O47--	CELL DOOR
C
16000	NOBJS=OPNCLS(CDOOR,779,780)		!OPEN/CLOSE?
	RETURN
C NOBJS, PAGE 9
C
C O48--	DIALBUTTON
C
17000	IF(PRSA.NE.PUSHW) GO TO 10		!PUSH?
	CALL RSPEAK(809)			!CLICK.
	IF(QOPEN(CDOOR)) CALL RSPEAK(810)	!CLOSE CELL DOOR.
C
	DO 17100 I=1,OLNT			!RELOCATE OLD TO HYPER.
	  IF((OROOM(I).EQ.CELL).AND.((OFLAG1(I).AND.DOORBT).EQ.0))
	1	CALL NEWSTA(I,0,LCELL*HFACTR,0,0)
	  IF(OROOM(I).EQ.(PNUMB*HFACTR))
	1	CALL NEWSTA(I,0,CELL,0,0)	!MOVE IN NEW HYPER.
17100	CONTINUE
C
	OFLAG2(ODOOR)=OFLAG2(ODOOR).AND. .NOT.OPENBT
	OFLAG2(CDOOR)=OFLAG2(CDOOR).AND. .NOT.OPENBT
	OFLAG1(ODOOR)=OFLAG1(ODOOR).AND. .NOT.VISIBT
	IF(PNUMB.EQ.4) OFLAG1(ODOOR)=OFLAG1(ODOOR).OR.VISIBT
C
	IF(AROOM(PLAYER).NE.CELL) GO TO 17400	!PLAYER IN CELL?
	IF(LCELL.NE.4) GO TO 17200		!IN RIGHT CELL?
	OFLAG1(ODOOR)=OFLAG1(ODOOR).OR. VISIBT
	F=MOVETO(NCELL,PLAYER)			!YES, MOVETO NCELL.
	GO TO 17400
17200	F=MOVETO(PCELL,PLAYER)			!NO, MOVETO PCELL.
C
17400	LCELL=PNUMB
	RETURN
C NOBJS, PAGE 10
C
C O49--	DIAL INDICATOR
C
18000	IF(PRSA.NE.SPINW) GO TO 18100		!SPIN?
	PNUMB=RND(8)+1				!WHEE!
	CALL RSPSUB(797,712+PNUMB)
	RETURN
C
18100	IF((PRSA.NE.MOVEW).AND.(PRSA.NE.PUTW).AND.
	1	(PRSA.NE.TRNTOW)) GO TO 10
	IF(PRSI.NE.0) GO TO 18200		!TURN DIAL TO X?
	CALL RSPEAK(806)			!MUST SPECIFY.
	RETURN
C
18200	IF((PRSI.GE.NUM1).AND.(PRSI.LE.NUM8)) GO TO 18300
	CALL RSPEAK(807)			!MUST BE DIGIT.
	RETURN
C
18300	PNUMB=PRSI-NUM1+1			!SET UP NEW.
	CALL RSPSUB(808,712+PNUMB)
	RETURN
C
C O50--	GLOBAL MIRROR
C
19000	NOBJS=MIRPAN(832,.FALSE.)
	RETURN
C
C O51--	GLOBAL PANEL
C
20000	IF(HERE.NE.FDOOR) GO TO 20100		!AT FRONT DOOR?
	IF((PRSA.NE.OPENW).AND.(PRSA.NE.CLOSEW)) GO TO 10
	CALL RSPEAK(843)			!PANEL IN DOOR, NOGO.
	RETURN
C
20100	NOBJS=MIRPAN(838,.TRUE.)
	RETURN
C
C O52--	PUZZLE ROOM SLIT
C
21000	IF((PRSA.NE.PUTW).OR.(PRSI.NE.CSLIT)) GO TO 10
	IF(PRSO.NE.GCARD) GO TO 21100		!PUT CARD IN SLIT?
	CALL NEWSTA(PRSO,863,0,0,0)		!KILL CARD.
	CPOUTF=.TRUE.				!OPEN DOOR.
	OFLAG1(STLDR)=OFLAG1(STLDR).AND..NOT.VISIBT	!VANISH DOOR.
	RETURN
C
21100	IF(((OFLAG1(PRSO).AND.VICTBT).EQ.0).AND.
	1  ((OFLAG2(PRSO).AND.VILLBT).EQ.0)) GO TO 21200
	CALL RSPEAK(RND(5)+552)			!JOKE FOR VILL, VICT.
	RETURN
C
21200	CALL NEWSTA(PRSO,0,0,0,0)		!KILL OBJECT.
	CALL RSPSUB(864,ODO2)			!DESCRIBE.
	RETURN
C
	END
C MIRPAN--	PROCESSOR FOR GLOBAL MIRROR/PANEL
C
C DECLARATIONS
C
	LOGICAL FUNCTION MIRPAN(ST,PNF)
	IMPLICIT INTEGER(A-Z)
	LOGICAL PNF
C
C GAME STATE
C
	LOGICAL TELFLG
	COMMON /PLAY/ WINNER,HERE,TELFLG
C
C PARSER OUTPUT
C
	LOGICAL PRSWON
	COMMON /PRSVEC/ PRSA,PRSI,PRSO,PRSWON,PRSCON
C
C VERBS
C
	COMMON /VINDEX/ CINTW,DEADXW,FRSTQW,INXW,OUTXW
	COMMON /VINDEX/ WALKIW,FIGHTW,FOOW
	COMMON /VINDEX/ MELTW,READW,INFLAW,DEFLAW,ALARMW,EXORCW
	COMMON /VINDEX/ PLUGW,KICKW,WAVEW,RAISEW,LOWERW,RUBW
	COMMON /VINDEX/ PUSHW,UNTIEW,TIEW,TIEUPW,TURNW,BREATW
	COMMON /VINDEX/ KNOCKW,LOOKW,EXAMIW,SHAKEW,MOVEW,TRNONW,TRNOFW
	COMMON /VINDEX/ OPENW,CLOSEW,FINDW,WAITW,SPINW,BOARDW,UNBOAW,TAKEW
	COMMON /VINDEX/ INVENW,FILLW,EATW,DRINKW,BURNW
	COMMON /VINDEX/ MUNGW,KILLW,ATTACW,SWINGW
	COMMON /VINDEX/ WALKW,TELLW,PUTW,DROPW,GIVEW,POURW,THROWW
	COMMON /VINDEX/ DIGW,LEAPW,STAYW,FOLLOW
	COMMON /VINDEX/ HELLOW,LOOKIW,LOOKUW,PUMPW,WINDW
	COMMON /VINDEX/ CLMBW,CLMBUW,CLMBDW,TRNTOW
C
C FLAGS
C
	LOGICAL*1 TROLLF,CAGESF,BUCKTF,CAROFF,CAROZF,LWTIDF
	LOGICAL*1 DOMEF,GLACRF,ECHOF,RIDDLF,LLDF,CYCLOF
	LOGICAL*1 MAGICF,LITLDF,SAFEF,GNOMEF,GNODRF,MIRRMF
	LOGICAL*1 EGYPTF,ONPOLF,BLABF,BRIEFF,SUPERF,BUOYF
	LOGICAL*1 GRUNLF,GATEF,RAINBF,CAGETF,EMPTHF,DEFLAF
	LOGICAL*1 GLACMF,FROBZF,ENDGMF,BADLKF,THFENF,SINGSF
	LOGICAL*1 MRPSHF,MROPNF,WDOPNF,MR1F,MR2F,INQSTF
	LOGICAL*1 FOLLWF,SPELLF,CPOUTF,CPUSHF
	COMMON /FINDEX/ TROLLF,CAGESF,BUCKTF,CAROFF,CAROZF,LWTIDF,
	1	DOMEF,GLACRF,ECHOF,RIDDLF,LLDF,CYCLOF,
	2	MAGICF,LITLDF,SAFEF,GNOMEF,GNODRF,MIRRMF,
	3	EGYPTF,ONPOLF,BLABF,BRIEFF,SUPERF,BUOYF,
	4	GRUNLF,GATEF,RAINBF,CAGETF,EMPTHF,DEFLAF,
	5	GLACMF,FROBZF,ENDGMF,BADLKF,THFENF,SINGSF,
	6	MRPSHF,MROPNF,WDOPNF,MR1F,MR2F,INQSTF,
	7	FOLLWF,SPELLF,CPOUTF,CPUSHF
	COMMON /FINDEX/ BTIEF,BINFF
	COMMON /FINDEX/ RVMNT,RVCLR,RVCYC,RVSND,RVGUA
	COMMON /FINDEX/ ORRUG,ORCAND,ORMTCH,ORLAMP
	COMMON /FINDEX/ MDIR,MLOC,POLEUF
	COMMON /FINDEX/ QUESNO,NQATT,CORRCT
	COMMON /FINDEX/ LCELL,PNUMB,ACELL,DCELL,CPHERE
C MIRPAN, PAGE 2
C
	MIRPAN=.TRUE.
	NUM=MRHERE(HERE)			!GET MIRROR NUM.
	IF(NUM.NE.0) GO TO 100			!ANY HERE?
	CALL RSPEAK(ST)				!NO, LOSE.
	RETURN
C
100	MRBF=0					!ASSUME MIRROR OK.
	IF(((NUM.EQ.1).AND..NOT.MR1F).OR.
	1  ((NUM.EQ.2).AND..NOT.MR2F)) MRBF=1
	IF((PRSA.NE.MOVEW).AND.(PRSA.NE.OPENW)) GO TO 200
	CALL RSPEAK(ST+1)			!CANT OPEN OR MOVE.
	RETURN
C
200	IF(PNF.OR.((PRSA.NE.LOOKIW).AND.(PRSA.NE.EXAMIW).AND.
	1	(PRSA.NE.LOOKW))) GO TO 300
	CALL RSPEAK(844+MRBF)			!LOOK IN MIRROR.
	RETURN
C
300	IF(PRSA.NE.MUNGW) GO TO 400		!BREAK?
	CALL RSPEAK(ST+2+MRBF)			!DO IT.
	IF((NUM.EQ.1).AND..NOT.PNF) MR1F=.FALSE.
	IF((NUM.EQ.2).AND..NOT.PNF) MR2F=.FALSE.
	RETURN
C
400	IF(PNF.OR.(MRBF.EQ.0)) GO TO 500	!BROKEN MIRROR?
	CALL RSPEAK(846)
	RETURN
C
500	IF(PRSA.NE.PUSHW) GO TO 600		!PUSH?
	CALL RSPEAK(ST+3+NUM)
	RETURN
C
600	MIRPAN=.FALSE.			!CANT HANDLE IT.
	RETURN
C
	END
