;****************************************************************
;	PROM BASED QUME LINE PRINTER CHARACTER PRINT ROUTINE
;****************************************************************
;
;	THIS ROUTINE IS PUT IN PROM AT 0FA00H BECAUSE THERE
;	WAS NO ROOM FOR IT IN THE BIOS AREA IN TRACK 1 OF
;	A SYSTEM DISK.
;
;	MICHAEL J. KARAS
;	MICRO RESOURCES
;	2468 HANSEN CT.
;	SIMI VALLEY, CA 93065
;	(805) 527-7922
;
;****************************************************************
;
; WRITE A CHARACTER TO QUME PRINTER DEVICE.
;
;
;
;
;SET PARAMETERS FOR ASSEMBLY
;
LENHGT	EQU	132		;PRINTER LINE LENGTH
QUME1	EQU	31H		;FIRST DATA PORT
QUME2	EQU	QUME1+2		;SECOND DATA PORT
;
;
;SET TO BASE OF PROM
;
	ORG	0FA00H
;
;
LIST:
	MOV	A,C	;GET CHAR PASSED FROM BDOS
	PUSH	H
	PUSH	D
	PUSH	PSW
	CPI	20H	;IS CHAR A SPACE
	LDA	LPTPOS	;GET CHAR POS
	JM	CONTCH	;IF IT'S A CONTROL CHAR, GO
	JZ	QSPACE	;IF IT'S A SPACE, GO DO IT
	CALL	QMOVE	;IT'S PRINTABLE, MOVE CARRIAGE
	POP	PSW	;GET CHAR BACK
	PUSH	PSW
	ADD	A	;SHIFT CHAR LEFT ONE BIT
	CMA		;ADJUST FOR ACTIVE LOW DATA
	OUT	QUME1	;SEND TO LATCH
	CALL	WAIT
	MVI	A,0DFH	;SET CHAR STROBE
	OUT	QUME2
	ORI	20H
	OUT	QUME2	;RESET CHAR STROBE
	LDA	LPTPOS	;GET CURR CHAR POS
	LXI	H,LPTLEN	;GET ADDR OF LENHGT
	CMP	M	;END OF CARRIAGE?
	JNZ	ENDQME	;NO, RETURN
QELN:	MVI	C,0DH	;YES, DO CR
	CALL	LIST	;PRINT IT (SORT OF)
	JMP	QLF	;DO LF
;
CONTCH:	POP	PSW	;GET CHAR
	PUSH	PSW
	CPI	09H	;IS IT A TAB?
	CZ	QTAB	;YES, GO
	CPI	0DH	;IS IT A CR?
	JZ	QCR	;YES, GO
	CPI	0AH	;IS IT A LF?
	JZ	QLF	;YES, GO
	CPI	0CH	;IS IT A FF?
	JZ	QFF	;YES, GO
ENDQME:	POP	PSW	;ELSE CLEAR STACK
	POP	D
	POP	H
	RET		;RETURN TO BDOS
;
QSPACE:	INR	A	;INC CHAR POS
	LXI	H,LPTLEN	;CHK FOR END OF LINE
	CMP	M
	JZ	QELN	;IF SO,DO CRLF
	STA	LPTPOS	;ELSE STORE NEW POS
	LXI	D,000CH	;GET CHAR INCREMENT
	LHLD	QMOV	;GET MOVE VALUE
	DAD	D	;ADD CHAR INC TO MOVE VAL
	SHLD	QMOV	;STORE NEW MOVE VALUE
	JMP	ENDQME
;
QMOVE:	INR	A	;INC CHAR POS
	STA	LPTPOS	;STORE IT
	LXI	D,000CH	;GET CHAR INCREMENT
	LHLD	QMOV	;GET CURRENT MOVE DISTANCE
	DAD	D	;ADD INC TO MOVE
	XCHG
	LHLD	QPOS	;GET CURR QUME POS
	DAD	D	;ADD THIS MOVE TO POSITION
	SHLD	QPOS	;SAVE IT
QBAK:	CALL	WAIT	;WAIT FOR BUFFER READY
	MOV	A,E	;OUTPUT MOVE COMMAND
	CMA
	OUT	QUME1
	MOV	A,D
	CMA
	OUT	QUME2
	XRI	40H	;SET CARRIAGE STROBE BIT
	OUT	QUME2
	ORI	40H	;RESET CAR. STROBE BIT
	OUT	QUME2
	LXI	H,0000
	SHLD	QMOV	;ZERO MOVE COUNTER
	RET
;
QCR:	;QUME CARRIAGE RETURN
	LHLD	QPOS
	MOV	A,H
	ORI	08H
	MOV	H,A
	XCHG
	CALL	QBAK
	SHLD	QPOS
	MOV	A,H
	STA	LPTPOS
	JMP	ENDQME
;
QLF:	;QUME LINEFEED
	LXI	H,0010H
	CALL	WAIT
	MOV	A,L
	CMA
	OUT	QUME1
	MOV	A,H
	CMA
	OUT	QUME2
	XRI	80H
	OUT	QUME2
	ORI	80H
	OUT	QUME2
	JMP	ENDQME
;
QFF:	;QUME FORMFEED
	CALL	WAIT
	MVI	A,0DAH
	OUT	37H
	MVI	A,0FAH
	OUT	37H
	JMP	ENDQME
;
QTAB:	;QUME TAB
	MVI	C,20H
	CALL	LIST
	LDA	LPTPOS
	ANI	07H
	JNZ	QTAB
	RET
;
WAIT:	;WAIT FOR QUME BUFFER READY
	IN	35H
	XRI	80H
	ANI	90H
	JZ	WAIT
	RET
;
;
;SETUP BUFFER AREA FOR PLACEMENT OF PRINTER PARAMETERS
;IN TOP OF RAM
;
	ORG	0BFF0H
;
LPTPOS:	DB	00	;CURRENT PRINT POS
LPTLEN:	DB	LENHGT	;CURRENT LINE LENGTH
QMOV:	DW	00	;CARRIAGE MOVE INCREMENT
QPOS:	DW	00	;CURRENT CARRIAGE COUNT
;
;	END
