;
;		TERMINAL TEST PROGRAM
;		BY RODERICK W. HART
;		DEC. 1,1980
;
TPORT	EQU	0C0H	;MODEM UART CONTROL/STATUS PORT
DPORT	EQU	TPORT+1	;MODEM DATA PORT
P0TBMT	EQU	1	;XMIT BUFF EMPTY
P0DAV	EQU	2	;DATA AVAILABLE
VDM	EQU	0F800H	;VDM-1 DRIVER
STACK	EQU	080H	;DMA ADDRESS
CR	EQU	0DH	;ASCII CARRIAGE RETURN
LF	EQU	0AH	;ASCII LINE FEED
BEL	EQU	07H	;ASCII BELL
;
;
	ORG	100H
;
START	LXI	SP,STACK	;LOAD STACK POINTER
;
TEST	MVI	A,CR	;LOAD A WITH CARRIAGE RETURN
	CALL	TTYOUT	;PRINT CARRIAGE RETURN
	MVI	A,LF	;LOAD A WITH LINE FEED
	CALL	TTYOUT	;PRINT LINE FEED
	MVI	A,BEL	;LOAD A WITH BELL
	CALL	TTYOUT	;RING BELL
	MVI	A,0A0H	;THE FIRST CHARACTER TO SEND
;
NXTCHR	CPI	0E0H	;LAST CHARACTER TO BE PRINTED
	JZ	CHECK	;CHECK FOR STOP COMMAND
	CALL	TTYOUT	;PRINT CHARACTER
	INR	A	;INCREMENT THE CHAR VALUE
	JMP	NXTCHR
;
CHECK	IN	TPORT	;GET MODEM STATUS
	ANI	P0DAV	;DATA AVAILABLE?
	JZ	TEST	;RETURN IF NOT INTERRUPTED
	IN	DPORT	;CLEAR DATA PORT
	JMP	0	;STOP TEST
;
TTYOUT	MOV	B,A	;SAVE THE CHARACTER IN B
TTYO	IN	TPORT	;GET STATUS
	ANI	P0TBMT	;CHECK XMIT BUFFER
	JZ	TTYO	;LOOP WHILE WAITING FOR TRANSMITTER
	CALL	VDM	;OUTPUT TO CONSOLE
	MOV	A,B	;GET CHARACTER
	OUT	DPORT	;SENT IT TO MODEM
	RET
;
	END
