;
;			 CHAT.ASM ver 1.3
;			(revised 12/14/80)
;
;    An interactive program to allow a remote user to "chat" with
;      the local system operator.
;
;               Originally by RODERICK W. HART
;
;THIS PROGRAM IS TO BE USED BY A LOCAL OPERATOR TO CONDUCT TWO WAY
;COMMUNICATIONS WITH A REMOTE CALLER.  OPERATOR ACKNOWLEDGES "CHAT"
;REQUEST BY PRESSING THE SPECIAL CODE KEY DESIGNATED AT "AC" BELOW.
;
;WHEN IN HE CHAT MODE, LINES ARE AUTOMATICALLY LIMITED TO 63
;CHARACTERS. CLF IS INSERTED AUTOMATICALLY ON THE FIRST SPACE
;TYPED AFTER THE 57TH CHARACTER.
;
;12/14/80 Modified to use direct calls to CBIOS I/O to make
;	  compatible with CP/M 1.4, 2.x, and MP/M.  (KBP)
;
;12/09/80 Rewritten to optimize code, correct stack problems,
;	  add backspace routine, reduce number of bells,
;	  add user selectable operator acknowledge code, 
;	  eliminate unnecessary subroutines, add additional
;	  comments and add BASE equate for ALTCPM.
;	    By Keith Petersen W8SDZ, and Dave Hardy
;
BASE	EQU	0	;SET TO 4200H FOR ALTCPM, 0 FOR REGULAR CP/M
;
ACK	EQU	1BH	;OPERATOR ACKNOWLEDGE CODE
;
ALERT	EQU	6	;NUMBER OF ALERT ATTEMPTS
;
FASTCLK	EQU	0	;SET TO 1 FOR 4 MHZ, 0 FOR 2 MHZ SYSTEM CLOCK
;
BEL	EQU	07H	;BELL
CR	EQU	0DH	;CARRIAGE RETURN
LF	EQU	0AH	;LINE FEED
CONTC	EQU	03H	;CHAT-MODE EXIT CHARACTER
BAKSP	EQU	08H	;BACKSPACE
;
BDOS	EQU	BASE+5	;BDOS CALL ADDRESS
PRINT	EQU	9	;PRINT STRING FUNCTION
;
	ORG	BASE+100H
;
START	LXI	SP,STACK ;SET NEW STACK POINTER
;
;Initialize jumps to CBIOS for direct I/O
	LHLD	BASE+1	 ;GET POINTER TO CBIOS
	LXI	D,3	 ;READY FOR ADD
	DAD	D	 ;HL = CONSTAT VECTOR
	SHLD	CSTAT+1	 ;MODIFY JUMP
	DAD	D	 ;HL = CONIN VECTOR
	SHLD	CONIN+1	 ;MODIFY JUMP
	DAD	D	 ;HL = CONOUT VECTOR
	SHLD	CONOUT+1 ;MODIFY JUMP
;
;Print signon message
	CALL	ILPRT	;PRINT:
	DB	CR,LF,'REMOTE CONVERSATION UTILITY ver 1.3',CR,LF
	DB	'Program aborts automatically in 30 seconds.'
	DB	CR,LF,CR,LF,'Alerting OPERATOR . ',0
;
;Attempt to alert operator
;
START1	CALL	ILPRT	;PRINT BELL, PERIOD, SPACE
	DB	BEL,'. ',0
	CALL	DELAY	;WAIT 5 SECONDS
	LDA	CNT	;GET ATTEMPT COUNTER
	DCR	A	;DONE WITH ALERT ATTEMPTS?
	STA	CNT	;SAVE NEW COUNT
	JN	START1	;NOT DONE WITH ATTEMPTS, DO MRE
	CALL	ILPRT	;PRINT:
	DB	CR,LF,CR,LF,'orry, no OPERATR available-',CR,LF
	DB	'Please leave your request on MINICBBS',CR,LF,0
	JMP	BASE+0	;EXIT TO CP/M WARM BOOT
;
	IF	FASTCLK	;4 MHZ SYSTEM CLOCK
DELAY	MVI	A,11	;NUMBER OF 1 SECOND DELAYS +1 * 2
	ENDIF
;
	IF	NOT FASTCLK
DELAY	MVI	A,6	;NUMBER OF 1 SECOND DELAYS + 1
	ENDIF
;
DELAY1	LXI	H,0
	LXI	D,1	;LOOP DELAY VALUE
;
WAIT	DAD	D	;WAIT BETWEEN BELL RINGS
	JNC	WAIT
	DCR	A	;DONE?
	JNZ	DELAY1	;NO, LOOP
;
	CALL	CSTAT	;GET CONSOLE STATUS
	ORA	A	;CHARACTER WAITING?
	RZ		;NO, RETURN
	CALL	CONIN	;GET CHARACTER
	CPI	ACK	;WAS IT THE RIGHT ANSWER?
	RNZ		;NO? THEN TRY AGAIN
;
	POP	PSW	;FIX STACK
	CALL	ILPRT	;PRINT:
	DB	CR,LF,CR,LF,'OPERATOR is ON-LINE. Please go ahead:'
	DB	CR,LF,CR,LF,0
;
;CONVERSATION ROUTINE - uses direct CBIOS I/O to
;prevent control characters from being echoed.
;
CONT	CALL	CONIN	;GET CONSOLE INPUT WITH NO ECHO
	CPI	CONTC	;CONTROL-C ?
	JZ	BASE+0	;YES, WARM-BOOT AND RETURN TO CP/M
	CPI	CR	;CARRIAGE RETURN?
	JZ	CRLF	;YES SEND CRLF
	CPI	BAKSP	;BACKSPACE?
	JZ	BACKIT	;YES DO BACKSPACE SPACE BACKSPACE
	CPI	' '	;SPACE OR ABOVE?
	JC	CONT	;IT'S A CTL CHARACTER, CONTINUE LOOPING
	PUSH	PSW	;SAVE CHARACTER ON STACK
	MOV	C,A	;CHARACTER TO C FOR CBIOS
	CALL	CONOUT	;SEND CHARACTER TO CONSOLE
	POP	B	;GET CHARACTER TO B FROM STACK
	LDA	LCNT	;GET CHARACTER COUNT
	INR	A	;INCREMENT CUNTER
	STA	LCNT	;PUT COUNTER BACK
	CPI	63	;AT END OF L	NE LIMIT?
	JZ	CRLF	;YES, GIVE AUTO CRLF
	CPI	58	;NEAR END OF LINE LIMIT?
	JC	CONT	;NO, CONTINUE LOOPING
	MOV	A,B	;GET CHARACTER
	CPI	' '	;SPACE?
	JNZ	CONT	;NO, CONTINUE LOOPING
;
CRLF	CALL	ILPRT	;PRINT:
	DB	CR,LF,0
	XRA	A	;ZERO CHARACTER COUNTER
	STA	LCNT
	JMP	CONT	;CONTINUE LOOPING
;
BACKIT	LDA	LCNT	;GET CHARACTER COUNT
	DCR	A	;SUBTRACT ONE BECAUSE OF BACKSPACE
	JM	CONT	;DONT GO PAST ZERO
	STA	LCNT	;SAVE NEW COUNT
	CALL	ILPRT	;PRINT
	DB	BAKSP,' ',BAKSP,0
	JMP	CONT	;CONTINUE LOOPING
;
;INLINE PRINT ROUTINE
;
ILPRT	XTHL		;SAVE HL, GET MSG
;
ILPLP	MOV	C,M	;GET CHAR
	PUSH	H
	CALL	CONOUT	;OUTPUT IT
	POP	H
	INX	H	;POINT TO NEXT
	MOV	A,M	;TEST
	ORA	A	;..FOR END
	JNZ	ILPLP
	XTHL		;RESTORE HL, RET ADDR
	RET		;RET PAST MSG
;
CSTAT	JMP	$-$	;MODIFIED AT INIT
;
CONIN	JMP	$-$	;MODIFIED AT INIT
;
CONOUT	JMP	$-$	;MODIFIED AT INIT
;
CNT	DB	ALERT	;ALERT COUNTER
LCNT	DB	0	;LINE POSITION COUNTER
	DS	60	;ROOM FOR STACK
STACK	EQU	$
;
	END
