;
;	VERSAFLOPPY II DISK FORMATTER
;
;	Formats a New Disk with IBM Soft-Sectored Format.
;
;	R. W. Hart - July 1980
;
;	XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX
;	XX  CAUTION!!! - This Program Will Destroy the XX
;	XX  Contents of a Disk Unless it is Write-     XX
;	XX  Protected.  When Calling the Program by    XX
;	XX  Mistake, any Response other than RETURN to XX
;	XX  the Question "When Ready, Respond with     XX
;	XX  RETURN.." Will Abort the Program Without   XX
;	XX  Writing to the Disk.		       XX
;	XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX
;
	.PABS
	.LOC	0100H
;
;	DEFINITIONS
;
SRAM	=	0000H		;Start of RAM
BDOS	=	0005H		;Operating System Entry
UNIT	=	SRAM+42H	;Unit Byte
SCTR	=	SRAM+43H	;Sector Pointer
TRK	=	SRAM+44H	;Track Pointer
BIOS	=	0F000H		;Versafloppy BIOS Address
HME	=	BIOS+18H	;Home Entry to BIOS
FMATE	=	BIOS+33H	;Format Entry to BIOS
NTRKS	=	BIOS+40H	;Contains # of Disk TRACKS
CR	=	0DH		;Carriage-Return
LF	=	0AH		;Line-Feed
VT	=	0BH		;Clear SCREEN
FILLER	=	0000H
;
;
	LHLD	UNIT
	SHLD	SAVUNIT
FORMAT:	MVI	C,9
	LXI	D,GMSG
	CALL	BDOS		;Output Greeting
DRIVE:	MVI	C,9
	LXI	D,MSG5
	CALL	BDOS
	MVI	C,1
	CALL	BDOS
	ANI	0FH
	CPI	04H
	JNC	DRIVE
	STA	UNIT
SIZE:	MVI	C,9
	LXI	D,MSG1
	CALL	BDOS
	MVI	C,1
	CALL	BDOS
	ANI	0FH
	CPI	02H
	JNC	SIZE
	CPI	00H
	JZ	RESET7
	JMP	SET7
DEN:	MVI	C,9
	LXI	D,MSG2
	CALL	BDOS
	MVI	C,1
	CALL	BDOS
	ANI	0FH
	CPI	02H
	JNC	DEN
	CPI	00H
	JZ	RESET6
	JMP	SET6
DSIZE:	MVI	C,9
	LXI	D,MSG3
	CALL	BDOS
	MVI	C,1
	CALL	BDOS
	ANI	0FH
	CPI	02H
	JNC	DSIZE
	CPI	00H
	JZ	RESET5
	JMP	SET5
DSIDE:	MVI	C,9
	LXI	D,MSG4
	CALL	BDOS
	MVI	C,1
	CALL	BDOS
	ANI	0FH
	CPI	02H
	JNC	DSIDE
	CPI	00H
	JZ	RESET4
	JMP	SET4
GO:	MVI	C,9
	LXI	D,MMSG
	CALL	BDOS
	MVI	C,1
	CALL	BDOS
	CPI	CR
	RNZ
	XRA	A
	STA	TRK
	INR	A
	STA	SCTR
	CALL	HME
FORMT1:	CALL	FMATE		;Format this Track
	JNZ	ERROR
	LDA	TRK
	INR	A
	STA	TRK
	MOV	B,A
	LDA	NTRKS
	CMP	B
	JNZ	FORMT1
	MVI	C,9
	LXI	D,MSG6
	CALL	BDOS
	MVI	C,1
	CALL	BDOS
	CPI	'Y'
	JZ	GO
	MVI	C,9
	LXI	D,FMSG
	CALL	BDOS
	PUSH	H
	LHLD	SAVUNIT
	SHLD	UNIT
	POP	H
	JMP	00H
;
RESET7:	PUSH	H
	LXI	H,UNIT
	RES	7,M
	POP	H
	JMP	DEN
RESET6:	PUSH	H
	LXI	H,UNIT
	RES	6,M
	POP	H
	JMP	DSIZE
RESET5:	PUSH	H
	LXI	H,UNIT
	RES	5,M
	POP	H
	JMP	DSIDE
RESET4:	PUSH	H
	LXI	H,UNIT
	RES	4,M
	POP	H
	JMP	GO
SET7:	PUSH	H
	LXI	H,UNIT
	SET	7,M
	POP	H
	JMP	DEN
SET6:	PUSH	H
	LXI	H,UNIT
	SET	6,M
	POP	H
	JMP	DSIZE
SET5:	PUSH	H
	LXI	H,UNIT
	SET	5,M
	POP	H
	JMP	DSIDE
SET4:	PUSH	H
	LXI	H,UNIT
	SET	4,M
	POP	H
	JMP	GO
;
ERROR:	MVI	C,9
	LXI	D,EMSG
	CALL	BDOS
	PUSH	H
	LHLD	SAVUNIT
	SHLD	UNIT
	POP	H
	JMP	00H
;
MSG1:	.BYTE	VT,LF,CR
	.ASCII	' SECTOR SIZE'
	.BYTE	LF,CR
	.ASCII	' -----------'
	.BYTE	LF,CR,LF,CR
	.ASCII	'128 BYTES = 0 '
	.BYTE	LF,CR
	.ASCII	'256 BYTES = 1'
	.BYTE	LF,CR,'$'
MSG2:	.BYTE	VT,LF,CR
	.ASCII	' DENSITY'
	.BYTE	LF,CR
	.ASCII	' -------'
	.BYTE	LF,CR,LF,CR
	.ASCII	'SINGLE = 0 '
	.BYTE	LF,CR
	.ASCII	'DOUBLE = 1'
	.BYTE	LF,CR,'$'
MSG3:	.BYTE	VT,LF,CR
	.ASCII	'DRIVE SIZE '
	.BYTE	LF,CR
	.ASCII	'----------'
	.BYTE	LF,CR,LF,CR
	.ASCII	' FULL = 0'
	.BYTE	LF,CR
	.ASCII	' MINI = 1'
	.BYTE	LF,CR,'$'
MSG4:	.BYTE	VT,LF,CR
	.ASCII	'   # OF SIDES'
	.BYTE	LF,CR
	.ASCII	'   ----------'
	.BYTE	LF,CR,LF,CR
	.ASCII	'SINGLE SIDED = 0'
	.BYTE	LF,CR
	.ASCII	'DOUBLE SIDED = 1'
	.BYTE	LF,CR,'$'
MSG5:	.BYTE	LF,CR
	.ASCII	'   DRIVE'
	.BYTE	LF,CR
	.ASCII	'   -----'
	.BYTE	LF,CR,LF,CR
	.ASCII	'DRIVE A = 0'
	.BYTE	LF,CR
	.ASCII	'DRIVE B = 1'
	.BYTE	LF,CR
	.ASCII	'DRIVE C = 2'
	.BYTE	LF,CR
	.ASCII	'DRIVE D = 3'
	.BYTE	LF,CR,'$'
MSG6:	.BYTE	VT,LF,CR
	.ASCII	'Do You Wish To Format Another Disk ?'
	.BYTE	LF,CR,'$'
GMSG:	.BYTE	VT,LF,CR
	.ASCII	'WA3MEZ VERSAFLOPPY II DISK FORMATER - '
	.ASCII	'VERSION 1.00'
	.BYTE	LF,CR,LF,CR,'$'
MMSG:	.BYTE	VT,LF,CR
	.ASCII	'Mount Disk to be Formatted...'
	.BYTE	LF,CR,LF,CR
	.ASCII	'When Ready, Respond With RETURN...'
	.BYTE	LF,CR,'$'
;
EMSG:	.BYTE	VT,LF,CR
	.ASCII	'*** DISK WRITE ERROR - PROGRAM ABORTED ***'
	.BYTE	LF,CR,LF,CR,'$'
;
FMSG:	.BYTE	VT,LF,CR
	.ASCII	'*** FORMATTING COMPLETE - REMOVE DISK ***'
	.BYTE	LF,CR,LF,CR,'$'
;
;
	
SAVUNIT: .WORD	FILLER
;
	.END
