;		XEK->CPM
;
; THIS PROGRAM WILL CHANGE SOURCE PROGRAMS WRITTEN BY SP1,
; ALS-8, XEK, AND PDS ASSEMBLERS TO TEXT ACCEPTABLE TO CP/M
; ASSEMBLERS AND EDITORS.
;
; TO USE THE PROGRAM, FIRST THE SP1 FILE MUST BE SAVED ON THE
; CP/M DISK.  LOAD THE SOURCE FILE INTO RAM AT 100H, BOOT IN
; CP/M AND TYPE:
;	SAVE XX NAME.EXT
;
; NEXT RUN THE CHANGE PROGRAM BY TYPING THE COMMAND LINE:
;	A>CHANGE B:NAME.EXT NAME2.EXT
;
; WHERE NAME.EXT IS THE SP1 FILE NAME AND
;       NAME2.EXT IS THE CP/M FILE NAME
;
; REF. DDJ VOL. 41, PG 37
;
; WRITTEN BY MARK M. ZEIGER
;
;************************************************************
;
	ORG	100H
BDOS	EQU	0005H
SOURCE	EQU	5CH
PRTBUF	EQU	9
OPEN	EQU	15
CLOSE	EQU	16
MAKE	EQU	22
READFIL	EQU	20
WRTFILE	EQU	21
SETDMA	EQU	26
DELETE	EQU	19
RESET	EQU	13
BL	EQU	' '
;
;
	LXI	H,0
	DAD	SP
	SHLD	STKSAVE
	LXI	SP,NEWSTK
;
	CALL	GETNAMES
	CALL	OPENFILE
	CALL	READREC
	CALL	MOVEREC
	CALL	WRITEREC
	CALL	CLOSEFILE
;
	LHLD	STKSAVE
	SPHL
	RET
;
;
TAB	DB	5
EOLCNT	DB	0
DEST	DB	0,'           ',0,0	;ELEVEN BLANKS
	DB	0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
INBUF	DS	80H
OUTBUF	DS	128
	DS	40H
NEWSTK	EQU	$-1
STKSAVE	DS	2
;
;
MSG1	DB	'SOURCE FILE NOT ON DISK',0DH,0AH,'$'
MSG2	DB	'READ PAST END OF FILE',0DH,0AH,'$'
MSG3	DB	'NO MORE DIRECTORY SPACE',0DH,0AH,'$'
MSG4	DB	'DISK FULL',0DH,0AH,'$'
MSG5	DB	'ERROR IN EXTENDING FILE',0DH,0AH,'$'
MSG6	DB	'NO SOURCE FILE INDICATED',0DH,0AH,'$'
MSG7	DB	'NO DESTINATION FILE INDICATED',0DH,0AH,'$'
;
GETNAMES
	LDA	SOURCE+1
	CPI	BL
	JZ	ERROR6
	LDA	SOURCE+17
;
	CPI	BL
	JZ	ERROR7
	LXI	H,SOURCE+16
	LXI	D,DEST
	MVI	B,12
MOVNAME	MOV	A,M
	STAX	D
	INX	H
	INX	D
	DCR	B
	JNZ	MOVNAME
	LXI	H,SOURCE+12
	MVI	A,0
	MVI	B,24
ZEROS	MOV	M,A
	INX	H
	DCR	B
	JNZ	ZEROS
	RET
OPENFILE
	MVI	C,OPEN
	LXI	D,SOURCE
	CALL	BDOS
	CPI	0FFH
	JZ	ERROR1
	MVI	C,DELETE
	LXI	D,DEST
	CALL	BDOS
	MVI	C,MAKE
	LXI	D,DEST
	CALL	BDOS
	CPI	0FFH
	JZ	ERROR3
	MVI	C,OPEN
	LXI	D,DEST
	CALL	BDOS
	RET
;
READREC
	PUSH	PSW
	PUSH	B
	PUSH	D
	PUSH	H
	MVI	C,SETDMA
	LXI	D,INBUF
	CALL	BDOS
	MVI	C,READFIL
	LXI	D,SOURCE
	CALL	BDOS
	CPI	1
	JZ	ERROR2
	POP	H
	POP	D
	POP	B
	POP	PSW
	LXI	H,INBUF
	MVI	B,128
	RET
;
MOVEREC
	MVI	B,128
	MVI	C,128
	LXI	H,INBUF
	LXI	D,OUTBUF
NEWLINE	MOV	A,M
	CPI	1
	JZ	EOFMARK
	MVI	A,0
	STA	TAB
	MOV	A,M
	SUI	6
	STA	EOLCNT
	MOV	A,B
	SUI	6
	MOV	B,A
	INX	H
	INX	H
	INX	H
	INX	H
	INX	H
	INX	H
	CM	READREC
	CZ	READREC
	CM	RESTORENEG
OLDLINE	LDA	TAB
	CPI	0
	MOV	A,M
	JNZ	NOTAB
	CPI	3BH
	JNZ	ASTK
	STA	TAB
	JMP	NOTAB
ASTK	CPI	'*'
	JNZ	BLANK
	STA	TAB
	JMP	NOTAB
BLANK	CPI	' '
	JNZ	NOTAB
	MVI	A,9
	STA	TAB
NOTAB	STAX	D
	INX	H
	INX	D
	DCR	B
	CZ	READREC
	DCR	C
	CZ	WRITEREC
	LDA	EOLCNT
	DCR	A
	STA	EOLCNT
	JNZ	OLDLINE
	MVI	A,0AH
	STAX	D
	INX	D
	DCR	C
	CZ	WRITEREC
	JMP	NEWLINE
EOFMARK	MVI	A,0AH
	STAX	D
	INX	D
	DCR	C
	CZ	WRITEREC
	MVI	A,1AH
	STAX	D
	RET
;
RESTORENEG
	CMA
	ADI	1
	PUSH	PSW
	PUSH	D
	MOV	D,A
	MOV	A,B
	SUB	D
	MOV	B,A
	POP	D
	POP	PSW
	ADD	L
	MOV	L,A
	RET
;
WRITEREC
	PUSH	PSW
	PUSH	B
	PUSH	D
	PUSH	H
	MVI	C,SETDMA
	LXI	D,OUTBUF
	CALL	BDOS
	MVI	C,WRTFILE
	LXI	D,DEST
	CALL	BDOS
	CPI	0FFH
	JZ	ERROR3
	CPI	2
	JZ	ERROR4
	CPI	1
	JZ	ERROR5
	POP	H
	POP	D
	POP	B
	POP	PSW
	MVI	C,128
	LXI	D,OUTBUF
	RET
;
ERROR1	LXI	D,MSG1
	CALL	MESG
ERROR2	LXI	D,MSG2
	CALL	MESG
ERROR3	LXI	D,MSG3
	CALL	MESG
ERROR4	LXI	D,MSG4
	CALL	MESG
ERROR5	LXI	D,MSG5
	CALL	MESG
ERROR6	LXI	D,MSG6
	CALL	MESG
ERROR7	LXI	D,MSG7
	CALL	MESG
;
CLOSEFILE
	MVI	C,CLOSE
	LXI	D,DEST
	CALL	BDOS
	MVI	C,RESET
	CALL	BDOS
	RET
;
MESG	MVI	C,PRTBUF
	CALL	BDOS
	MVI	C,RESET
	CALL	BDOS
	LHLD	STKSAVE
	SPHL
	RET
;
;
	END
