;	FIXSEL.ASM	10/20/86
;
;	BY: MARTY L. WILLIAMS
;	    VALLEY VIEW APTS
;	    B8 A15
;	    WATERVLIET, NY  12189
;	    (518)786-1157
;
;	PROBLEM:
;	-WHEN A SELECT ERROR OCCURS, CP/M WILL
;	 NOT RETURN YOU TO THE DRIVE YOU WERE ON.
;
;	SOLUTION:
;	-SAVE THE CURRENT DRIVE PRIOR TO SELECTING
;	 THE NEXT DRIVE. IF A SELECT ERROR OCCURS,
;	 RETURN TO THE CCP WITH THE LAST GOOD
;	 DISK SELECTED.
;
;	NOTES:
;	-SOME BYTES ARE ROBBED FROM THE CCP INPUT
;	 BUFFER. I DON'T THINK THIS SHOULD BE MUCH
;	 OF A PROBLEM. I'VE NEVER HAD TO USE ALL
;	 THOSE BYTES.
;	-YOU ARE RETURNED TO USER 0.
;	-WRITTEN FOR A KAYPRO 4/83.
;
;	IMPLEMENTATION: (63K SYSTEM)
;	A0>MOVCPM 63 *
;	A0>SAVE 34 CPM63.COM
;	A0>ASM SELFIX.AAZ
;	A0>DDT CPM63.COM
;	-ISELFIX.HEX
;	-R2980
;	G0 (OR ^C)
;	A0>SAVE 34 CPM63.COM
;	A0>SYSGEN CPM63.COM
;
;	PUT YOUR STARTING LOCATIONS HERE
;
CCP	EQU	0E000H		;CCP START  63K SYSTEM
BDOS	EQU	0E800H		;BDOS START 63K SYSTEM
;
ERRMSG	EQU	BDOS + 00E5H	;ERR MSG OUTPUT
CURDSK	EQU	BDOS + 0342H	;BDOS CURRENT DISK
SELDSK	EQU	BDOS + 0C45H	;BDOS ORGINAL SELECT
				; DISK ADDRESS
;
	ORG	CCP  + 06H	;START OF CCP COMMAND BUFFER
	DB	67H		;SHORTEN THE COMMAND BUFFER
				; THIS GIVES YOU A BUFFER
				; OF 102 DECIMAL BYTES.
				; THIS SHOULD BE PLENTY.
;
	ORG	CCP  + 70H	;START OF COMMAND BUFFER
				; THAT HAS BEEN TURNED INTO
				; A PATCH AREA
SAVCUR:	LDA	CURDSK		;GET CURRENT DISK PRIOR TO
				; SELECTING A NEW DISK
	STA	LSTDSK		;SAVE IT AS THE LAST GOOD DISK
	JMP	SELDSK		;ORIGINAL BDOS SELECT DISK FUNC
;
;	INSTEAD OF JUMPING TO REBOOT WHEN A SELECT ERROR
;	OCCURS (ORIGINAL CODE), JUMP TO ROUTINE BELOW
;
SELERR:	CALL	ERRMSG		;OUTPUT SELECT ERROR MESSAGE
	LDA	LSTDSK		;GET LAST DISK SELECTED
				; PRIOR TO SELECT ERROR
	MOV	C,A		;PUT IN 'C' FOR CCP TO USE
	JMP	CCP  + 03H	;JUMP TO CCP
;
LSTDSK:	DB	00H		;STORAGE FOR LAST DISK
;
	ORG	BDOS + 63H	;BDOS COMMAND VECTOR TABLE
	DW	SAVCUR		;NEW COMMAND VECTOR FOR
				; SELECT DISK
	ORG	BDOS + 0A8H
	JMP	SELERR		;JUMP TO NEW TAIL END SELECT
				; ERROR PROCESSING
	END

