R60
                      Z-System Corner

               The Trenton Computer Festival

                          Jay Sage


Announcements

   The announcements for this time are about some exciting
price reductions. A small band of programmers has long
enjoyed the help of the wonderful DSD (Dynamic Screen
Debugger) in getting the bugs out of our code. The $130
price tag, however, was a deterrent to many. I recently
located and spoke with the author, John Otken, and suggested
that there would be a great advantage in reducing the price.
More people would get to take advantage of his superb
program, and he would actually make more money because of
the increased sales. He agreed to my suggested price of $50!

   I hope that many more of you will take advantage of this
opportunity. DSD is not only a powerful aid in debugging
problems with code; it is also a wonderful way to learn
about how programs work. The full-screen display allows one
to see everything that is happening during program
execution. One sees a section of disassembled source code,
the contents of the CPU registers, the contents of the
stack, and two blocks of memory. In all cases, symbolic as
well as numeric data can be seen, and all user entries can
make use of defined symbols.

   There have been two price reductions of interest to
owners of SB180 computers. XBIOS has been reduced from $75
to $50, as a reflection of the fact that it is no longer
actively supported. We have also acquired the remaining
stock of the excellent Electronic Technical Services
ETSIO180+ board. Its low power CMOS design includes a
battery-backed real-time clock, two high speed (115.2 kbps)
serial ports, 24 bits of parallel I/O, and an SCSI interface
for hard disk drives. It is fully supported by XBIOS (which
is required to run the board). I use the ETSIO180+ on my own
computer and have been very satisfied with it. The original
price was $280; we will sell the remaining stock (currently
about six boards) for just $100 each (or $145 including
XBIOS).


The Trenton Fiascos

   The main contents of my column for this month were
originally intended for publication in the printed
proceedings for this year's Trenton Computer Festival.
Although _our_ session there was again a great success
(because of the speakers), the organization of TCF has
deteriorated alarmingly over the past few years.

   When I originally sent in my speaker form for TCF, I
checked the box indicating that I would contribute a written
piece. Shortly before the deadline, when they had not
received my submission, I was called by Sol Libes, who runs
the conference, asking if I was going to write something. I
told him that I was still interested if there was time. He
said that it could be accepted if I got it in by the end of
the next weekend. We agreed that I would upload it to the
board run by the Amateur Computer Group of New Jersey. Once
it was there, I was to call Sol.

   I worked extremely hard for a couple of days, staying up
until 3 am to get it finished and uploaded to the ACGNJ
board. As instructed, I placed a voice call to Sol. He was
not there, so I left a message on his answering machine.
When he did not call back, I called several more times,
leaving messages each time. Finally he returned my call, and
we agreed that he would call me again if there was any
problem with the file I had left for him. I never heard
anything further.

   You can imagine my dismay when I learned during the
festival that my article had not been included. I still have
no idea why, as no one has had the courtesy to contact me.
Was its omission deliberate? I'm inclined to think it was
administrative incompetence, since most other aspects of the
conference organization were also handled poorly.

   On my speaker registration form I had checked boxes
indicating the equipment that I wanted them to supply in our
meeting room. My speaker confirmation form indicated that
the information had been recorded, but I telephoned the
program coordinator the day before I drove down just to be
absolutely sure. Do you think the equipment was there? No.
And do you think that anyone at TCF knew what to do about
it? No. We had to struggle through a couple of talks before,
almost by accident, we stumbled upon the people who had the
equipment (no one had told them we needed it).

   I had hoped that the following material would be read by
an audience that might include many people with CP/M
computers who did not know that magazines like TCJ and
advances like Z-System existed. So that my effort on this
composition was not totally wasted, I am presenting it here.


                     CP/M Is Not Dead!

   I'm sure you all know the famous Mark Twain anecdote.
Somehow the newspapers picked up a story that he had died. 
At his next public appearance he delighted in relating that
his reported death was, as he put it, "greatly exaggerated." 
The rumored death of CP/M, the granddaddy of microcomputer
operating systems, is similarly exaggerated!

   Unfortunately, the erroneous impression about CP/M is
much harder to correct. Were it simply the result of false
reports in the media, one could bring the truth to the
media's attention and have them publish a correction.
Regrettably, the belief that CP/M is dead arises via a 
mechanism that cannot be used to correct the view.

   I will try here to give you some impression of the
vitality that continues to flourish in the CP/M world,
particularly in connection with the development of the Z
System, a highly advanced successor operating system to
CP/M. While maintaining total compatibility with CP/M and
its software base, the Z-System brings concepts and features
that are as advanced as can be found on any computer
anywhere. Nothing can give a 4-MHz Z80 with 64 kilobytes of
memory the raw computing horsepower of a 33-MHz 80386
microprocessor with several megabytes of memory, but the Z-
System can give an old CP/M computer a surprisingly powerful
user interface and can turn it into a fun, educational, and
productive machine.

   At the end of this article, I have listed three magazines
with strong CP/M support. By subscribing to them you will be
able to learn about sources for public-domain programs and
the names and addresses of vendors who actively support
8-bit software and hardware products. You are also welcome
to call me.


Why Do People Think CP/M Is Dead?
=================================

   The community did not learn of the death of CP/M, as with
Mark Twain, by reading a report; they inferred it from
personal experience. The mainline computer magazines, such
as Byte, gradually carried less and less news about CP/M
until eventually they carried none. Why did they stop? 
Basically because the volume of interest shifted naturally
enough to MS-DOS and the newer hardware. There was no longer
much activity in CP/M hardware development or sales, and
almost all mainline software houses stopped developing new
CP/M programs. Soon most of them stopped even offering their
old CP/M programs for sale. Some, like Borland, have even
gone so far as to deny that CP/M products they once offered
were _ever_ offered by their company! (I swear I remember a
Borland Turbo Modula 2, but many people tell me that when
they contact Borland they are _assured_ that Borland _never_
offered that product.)

   This situation notwithstanding, a very high level of CP/M
activity did continue, but not in the spotlight. There were
smaller, specialty magazines that continued to focus on
hobbyist computing, and there were also smaller software
vendors who continued to support CP/M with great 
enthusiasm. For veteran CP/M users there was some chance of
their learning about these alternate sources of support
before the mainline sources shut the door on CP/M, but even
many of the veterans lost touch.

   For new owners of CP/M computers -- and though it might
surprise you, there are many -- the situation is worse. 
Typically, they have inherited a retired CP/M computer from
a family member, friend, user group, or even a stranger. 
When they try to contact the sources for CP/M information
and support listed in their old documentation, they find
them to be either out of business totally or at least out of
the CP/M business. And these days the sales representatives
at the software houses have often never even heard of CP/M! 
No wonder these new CP/M computer owners conclude that CP/M
is dead.


The Real Story
==============

   It is natural that the major focus of interest in
computers will continually shift toward the latest, most
advanced, and most widely sold hardware. Nevertheless, a
tremendous level of activity still exists in the CP/M world,
most of it centered on the further development of the Z-
System.

   Why would someone still be interested in CP/M? The
special spirit that persists in the CP/M world is one
important factor. As in the Unix world, there is a very
strong sense of community and sharing. This includes a well
established tradition of public-domain software, that is,
programs written specifically for the benefit of the general
community and shared totally with that community. By
contrast, the MS-DOS world has what they misleadingly call
"shareware." These programs are distributed for free, but
users are told that they must send money to the author if
they continue to use them.

   A second attraction in the CP/M world is the intellectual
challenges and rewards it offers. The relative simplicity of
the Z80 microprocessor and the CP/M operating system allow
easy entry to new programmers. Although extremely rare in
the DOS world, it is nearly universal in the CP/M world that
programs are published with source code. This has several
far-reaching consequences. In terms of quality, it means
that the development of a program is not limited to the
conceptual and coding ability of a single author. Others in
the community can take that source code, make improvements
to the program, and return the results to the community.
Many of the most important CP/M programs have a very long
history of development involving many authors.

   Reading source code is also an indispensable vehicle for
learning about how a computer system works. New programmers
can quickly learn coding techniques and apply them to new
applications. Amazingly, source code is available not only
for the numerous utility programs but also for at least 
some versions of all parts of the operating system as well.

   The seminal event in the survival of CP/M took place
almost exactly a decade ago. Richard Conn, eager to make his
own contribution to a community that he felt had helped him
so much, spearheaded a group effort to write replacement
code for the Console Command Processor (CCP) portion of the
CP/M operating system. The result, named ZCPR for Z80
Command Processor Replacement, was released to the public in
February, 1982.

   Not much later, I discovered this much improved command
processor and installed it on my CP/M computer. Then I did
something even more significant: I looked at the source
code. To my amazement, I discovered that the operating
system, that "holy of holies," is nothing more than a 
computer program, rather like any other, and that I, albeit
untrained in systems programming, could not only understand
it but experiment with changing it! Discoveries like this
from reading source code continue to inspire new CP/M
hobbyist programmers, and computer bulletin boards and user
group meetings continue to be scenes of intense discussion.


The Features of Z-System
========================

   The ZCPR command processor has gone through several
stages of evolution, and the same approach has now been
applied as well to the Basic Disk Operating System (BDOS)
component of the CP/M operating system. The combined result
is now referred to as the Z-System, and it represents a 
remarkable point in the development of microcomputer
operating systems. It has many, many features inspired by
minicomputer and mainframe operating systems and some not
available even on those powerful machines. When I use my DOS
386 machine at work, there are many Z-System features that I
sorely miss, and I am constantly amazed at their absence
from an operating system whose code is bigger than the
entire memory address space on a CP/M machine!

   For the most part, the original Digital Research CP/M
accomplished in admirable fashion the essential functions it
was required to perform: to run a few resident commands and
to load external commands from disk. However, it devoted
little attention to the user interface and did not provide
many services to make the operator's life easy. To be fair,
of course, CP/M was born in the days when 16K of memory cost
about $500 (in 1970s dollars, no less) and occupied an
entire S-100 card, roughly the size of the motherboard of a
modern DOS machine.

   The central goal of the Z-System since the beginning has
been to make it easier and more convenient to operate the
computer. My own ideal has been to have the computer perform
all tasks that it can handle on its own and to leave to the
user only those tasks that a computer cannot figure out by
itself. In other words, the computer should take care of all
the routine matters; the human operator should handle only
the thinking. I will now run through a short summary of Z
System features and try to indicate how they make the
operator's life easier.

User Area Access

   CP/M introduced the concept of disk "user" areas, which
allowed the operating system to group files into separate
logical directories. Unfortunately, CP/M provided no
practical way to access files across user areas, which made
them almost useless.

   Z-System makes it very easy and convenient to organize
your files. Where CP/M allowed only a drive prefix in file
specifications (e.g., B:TEXT.DOC), Z-System allows drive
and/or user number prefixes (e.g., A3:WORK.WS) so that files
in other user areas as well as other drives can be
referenced directly. In addition, Z-System allows meaningful
names (similar to DOS subdirectory names) to be assigned to
drive/user areas (so we might have LETTERS:JOE.WS). This
provides an interface that is far more suitable to the way
people think and remember.

Terminal Independence and the Environment

   While some would argue that the DOS hardware and software
standards established by IBM's market dominance have
resulted in an enforced mediocrity, there is no doubt that
having a single environment in which to operate makes life
much easier for applications programmers. Programs for DOS
generally work right out of the box on any IBM-compatible
computer. Configuration is required only for fine-tuning.

   CP/M, on the other hand, was designed to allow programs
to run on an extremely wide variety of hardware. In those
days, "personal" computer took on a different meaning --
each person designed and built his own hardware. CP/M could
be made to work with all of them, but elaborate 
configuration procedures were generally required, especially
to match programs to the particular terminal used. To this
day, we still have to deal with this hardware diversity.

   What CP/M could have provided, but didn't, was a means
for conveying to application programs information about the
operating environment. Z- System has several modules that
afford such communication. An area called the environment
descriptor (ENV) contains information about the system 
configuration. Another system area called the message buffer
(MSG) stores information that one program can leave for use
by another program that runs later.

   Part of the ENV is a section called the TCAP or Terminal
CAPability descriptor (if you know Unix, you will recognize
this). When the appropriate TCAP has been loaded, a Z-System
program will automatically use the right video control codes
for that terminal.

Command Processing Enhancements

   Under CP/M, you had to specify where the COM file to be
run was located (otherwise the current drive was assumed). 
This is a perfect example of something that a computer can
easily be smart enough to do for you, and Z-System does. As
with modern versions of DOS (which took many years to catch
on to this Z-System feature), you specify a list of
directory areas that the operating system will scan for a
requested COM file. Unlike DOS, Z-System does not insist
that the current directory be first in the path; it can
appear wherever you want it to, or not at all.

   With Z-System one is also no longer limited to issuing
commands one at a time (DOS has been even slower to catch on
to this). A single line of command input can contain a whole
sequence of commands. As a result, you do not have to
interrupt your thinking to wait for one command to finish 
before you can specify the second and subsequent steps in a
process. You can work out a strategy for what you want to
accomplish and issue all the commands at once, before you
forget or get confused.

   Many oft-repeated computational tasks involve sequences
of commands (e.g., editing, spell-checking, printing). In
such cases, the Z-System alias facility (similar in some
ways to CP/M's submit or DOS's batch operations but far more
flexible -- more akin to Unix scripts) can be used to define
a new command name, which, when invoked, performs the entire 
sequence. This saves the user a lot of typing but more
importantly eliminates the need to remember exactly what the
sequence is. Basically, you solve the problem once and put
the solution into an alias script. From then on, the
computer is smart enough to take care of the complex 
details for you.

Conditional Command Execution

   There is only so much one can accomplish on a computer
(or in life) without making decisions. Have you ever seen a
programming language with no ability to perform tests and
act in different ways depending on the results? Flow control
(IF/ELSE/ENDIF) is unique to the Z-System command 
processor. Other operating systems that offer flow control
at all limit it to operation inside a batch or script
language. A special set of Z-System commands can test a wide
range of conditions, and the tests can be nested to a depth
of eight levels.

Command Processor Shells

   If you do not want to deal with the operating system at
the command level or if you want to have a command processor
with extended features, the Z-System shell facility allows
you to install substitute user interfaces of your own choice
at will. They can even be nested within each other.

   Shells come in two common varieties: menu shells and
history shells. The menu interfaces allow the user to pick
tasks with single keystrokes and have the shell program
generate the complex sequences of commands required to
perform those tasks. The menu system shields the user from 
complexity, saves typing, and greatly reduces the chance of
error.

   History shells are enhanced command processors that
remember your commands and allow you to recall and edit
previous command lines. I wish the Apollo Domain
minicomputer system I use at work (not to mention my DOS 
computer) had a history shell as nice as Z-System's LSH. It
works like a wordprocessor on the command history, allowing
searching and extensive editing.

What If You Make a Mistake

   This is one of the other areas in which most operating
systems behave in an abominably primitive manner. When you
issue a command that cannot be performed, they just issue an
error message and then dump you back to square one. Often
you are not even told what sort of error occurred (consider
DOS's wonderfully helpful "bad command" message).

   The Z-System behaves in a civilized manner under these
circumstances. When an error occurs, the command processor
turns the bad command line over to a user-specified error
handler. The most sophisticated error handlers allow the
operator to edit the command and thus recover easily from
typing mistakes.

   The system environment even contains an error type, which
the error handler can use to give you more specific
information about what went wrong. It may be the familiar
error of a COM file that could not be found, but there are
many other possible causes for the difficulty. A file that 
you specified as an argument might not have been found
(e.g., "TYPE FILENAM" when you meant "TYPE FILENAME"), or
you may have specified an ambiguous file name to a program
that cannot accept one (e.g., "TYPE *.DOC").

System Security

   Like minicomputer and mainframe operating systems, the Z
System is a secure operating system. This means that it has
mechanisms for limiting what any particular user can do or
get access to. Commands that perform dangerous operations
(such as erasing, copying, or renaming files) can be 
disabled when ordinary users are operating the system but
enabled when a privileged user is at work. Areas of your
disk can be restricted from access for storage of
confidential or other sensitive information. These security
features come in very handy in the implementation of a
remote access system or bulletin board.

Summary

   To sum it up, the goal of the Z-System is to provide an
operating environment that can be tailored extensively to
user preferences and that can be made to handle on its own
and automatically as many computational details as it can,
leaving the user free to concentrate solely on those 
aspects of computer operation that require human
intelligence.


Z-System, The State of the CP/M Art
===================================

   Now that you've seen the remarkable features of the Z
System, you might be curious about how it can be installed
on your CP/M computer. In this regard, the most spectacular
step in the evolution of Z-System took place about three
years ago. At that time some major programming breakthroughs 
made it possible to configure and install the Z-System as if
it were an application program running on the CP/M computer. 
Before that, you really had to be a rather skilled assembly
language programmer to get Z-System running.

   The new Z-System comes in two flavors: NZCOM for
computers that use version 2.2 of CP/M and Z3PLUS for
computers running CP/M-Plus. Joe Wright, Bridger Mitchell,
and I were the main developers.

   NZCOM and Z3PLUS embody, I believe, some of the most
exciting and remarkable developments in the history of
microcomputer operating systems. With all the microcomputers
I have had experience with, the operating system has been a
static entity. You boot up the computer, and there you have
the operating system, fixed and immutable. Few computers
offer more than one operating system. With those that do,
changing the operating system usually requires rebooting and
starting over. And never do you, the user, get to define the
characteristics of the operating system. You just take what
the manufacturer decides to give you.

   With NZCOM and Z3PLUS the operating system becomes a
flexible tool just like an application program. You can
change operating system configurations at any time, even
right in the middle of a multiple command line sequence. You
can do it manually, or alias scripts can do it 
automatically in response to conditions in the system!

   You can change the whole operating system or just a part
of it. Would you like a different command processor? No
problem. With a simple command, NZCOM or Z3PLUS will load
another one. No assembly or configuration is required. If
you want to experiment with a new disk operating system
(BDOS), NZCOM can load a new one in a jiffy. This makes for
a whole new world of flexibility and adaptability, learning
and experimentation.

   Do you need more memory to run a big application program? 
Fine. While that application is running, just load a small
operating system without some of the bells and whistles. 
Then, after that task is finished, go back to the big system
with named directories, lots of resident commands, or
special input/output facilities (such as keyboard redefiners
or redirection of screen or printer output to disk). Until
you try NZCOM or Z3PLUS, it is hard to imagine how easy it
is to do these things.


Sources of Support
==================

   Here are three magazines that provide significant CP/M
support. By reading them you will learn about sources for
public-domain software (both by modem and on disk) and about
vendors who sell CP/M commercial software (a vendor listing,
CPMSRC.LST, posted on bulletin boards runs to 15 printed
pages).

   The major, professional publication with strong coverage
of Z-System and CP/M is "The Computer Journal." Its six
issues per year have a broad hobbyist focus, with articles
on several operating systems, programming languages,
embedded controllers, hardware projects, and many other
topics.

		The Computer Journal ($18/yr)
		P.O. Box 12
		S. Plainfield, NJ 07080-0012
		voice: 908-755-6186
		modem (Z-Node #32): 908-754-9067
		on GEnie as $TCJ

Two other, more informal magazines of interest to the 8-bit
community are:

		The Z-Letter ($15/yr)
		Lambda Software Publishing
		720 S. Second Street
		San Jose, CA 95112
		voice: 408-293-5176

		Eight Bits and Change ($15/yr)
		Small Computer Support
		24 East Cedar Street
		Newington, CT 06111
		voice: 203-666-3139
		modem (Z-Node #12): 203-665-1100.
                                              