;***********************************************************************
;        MICROCOSM I/O MAP DISPLAY PROGRAM VERSION 1.1  (C) 1979
;***********************************************************************
	ORG	00100H
;
;
;
TRUE	EQU	0FFFFH		;DEFINE TRUE
FALSE	EQU	NOT TRUE	;DEFINE FALSE
TARBEL	EQU	FALSE		;DEFINE TARBELL DISK CONTROLLER

BDOS	EQU	5	;BDOS ENTRY
CHRF	EQU	2	;CP/M PRINT CHARACTER FUNCTION
PRNF	EQU	9	;CP/M PRINT CHARCTER STRING FUNCTION
CR	EQU	00DH	;CARRIAGE-RETURN CHARACTER
LF	EQU	00AH	;LINE-FEED CHARACTER
;
;
;
MAP:	LXI	H,0	;SET-UP STACK
	DAD	SP	;ENTRY STACK POINTER FROM CP/M CCP
	SHLD	OLDSP	;SAVE IT
	LXI	SP,STACK	;SET STACK TO LOCAL STACK AREA
	CALL	CRLF	;KEEP IT NEAT
	MVI	C,PRNF	;OUTPUT "PORT LOCATION"
	LXI	D,PRTMSG
	CALL	BDOS
	MVI	B,1	;"ITEMS TO A LINE" COUNTER
	MVI	L,0	;POINT TO PORT 00
	JMP	PRINT
PORT:	IN	000H	;GET IT
	MOV	C,A	;SAVE IN C REG.
	CPI	0FFH	;INACTIVE PORT?
	JZ	INACT	;PRINT ".", IF INACTIVE
	CALL	HEXO1	;PRINT PORT CONTENT
	JMP	NEXT	;TRY NEXT PORT
INACT:	MVI	A,' '	;OUTPUT A SPACE CHARACTER
	CALL	PCHAR
	MVI	A,'.'	;OUTPUT A "." CHARACTER
	CALL	PCHAR
NEXT:	INR	L	;BUMP FOR NEXT PORT
	JZ	QUIT	;CONTINUE UNTIL LAST PORT
PRINT:	DCR	B	;COUNT ITEMS TO A LINE
	JNZ	NLINE	;SKIP IF NOT A NEW LINE
	MVI	B,16	;16 ITEMS TO A LINE
	CALL	CRLF
	CALL	HEXO	;OUTPUT NEXT PORT ADDRESS
NLINE:	MVI	A,' '	;OUTPUT A SPACE CHARACTER
	CALL	PCHAR
	MOV	A,L	;GET PORT NUMBER

	IF TARBEL
	CPI	0FCH	;TARBELL DISK "WAIT" PORT?
	JZ	INACT	;SKIP IF SO
	ENDIF

	STA	PORT+1	;MODIFY PORT NUMBER
	JMP	PORT	;DO NEXT PORT
QUIT:	CALL	CRLF	;KEEP IT NEAT FOR RETURN TO CP/M
	LHLD	OLDSP	;GET OLD STACK POINTER
	SPHL		;RESTORE IT
	RET		;STACK POINTER CONTAINS CCP'S STACK LOCATION
;
;
;
HEXO:	MOV	C,L	;GET PORT ADDRESS
HEXO1:	MOV	A,C	;GET BYTE TO BE CONVERTED
	RAR ! RAR ! RAR ! RAR	;ROTATE UPPER NIBBLE
	CALL	HEXO2	;OUTPUT UPPER NIBBLE
	MOV	A,C
HEXO2:	ANI	00FH	;MASK UPPER NIBBLE
	CPI	10	;TEST IF >10
	JC	HEXO3	;SKIP IF <10
	ADI	7	;ADJUST ASCII
HEXO3:	ADI	030H	;ADD ASCII BIAS
PCHAR:	PUSH H ! PUSH D ! PUSH B ! PUSH PSW
	MVI	C,CHRF	;DO CP/M PRINT CHARACTER FUNCTION
	MOV	E,A	;CHARACTER TO E REG.
	CALL	BDOS	;LET CP/M DO THE WORK
	POP PSW ! POP B ! POP D ! POP H
	RET
;
;
;
CRLF:	MVI	A,CR	;PRINT "CARRIAGE-RETURN"
	CALL	PCHAR
	MVI	A,LF	;PRINT "LINE-FEED"
	CALL	PCHAR
	RET
;
;
;
PRTMSG	DB	'   00 01 02 03 04 05 06 07 08 09 0A 0B 0C 0D 0E 0F$'
;
;
;
OLDSP	DS	2	;ENTRY STACK POINTER VALUE FROM CP/M CCP
	DS	16	;RESERVE 8 LEVEL STACK
STACK	EQU	$
;
;
;
	END
LF