	TITLE	'POOR MANS NETWORK ** COLUMBIA M64 OVERLAY'
;
; Last updated 15 Apr 87   v1.0   Jim Lill
;
NETBIOS	 EQU	2000H
OFFSET	 EQU	0F00H		;DISPL TO DRIVERS
;
TRUE	 EQU	0FFH
FALSE	 EQU	0
CR	 EQU	13
;
	 ORG	107H
;
; MODEM COMMANDS (NOT USED IN THIS VERSION)
;
MATTNCDS DB	'A','T',0,0,0,0,0,0,0,0	;ATTENTION
MINTRCDS DB	'+','+','+',0,0,0,0,0,0,0 ;INTERRUPT
MDIALCDS DB	'D',0,0,0,0,0,0,0,0,0	;DIAL A NO
MHANGCDS DB	'H','0',0,0,0,0,0,0,0,0	;HANG UP LINE
MINITCDS DB	'E0',CR		;INITIALIZATION
	 DB	'F1',CR		;(40 BYTES TOTAL)
 	 DB	'Q0',CR
 	 DB	'V1',CR
 	 DB 	'X1',CR
 	 DB	'S0=0',CR
 	 DB	'S7=15',CR
	 DB	0,0,0,0,0,0,0,0,0,0,0,0,0,0
;
BAUDRATE EQU	$		;BAUD RATE TABLE
 	 DW	40H		;300
	 DW	60H		;600
	 DW	70H		;1200
	 DW	0		;1800
	 DW	78H		;2400
	 DW	0		;3600
	 DW	7CH		;4800
	 DW	0		;7200
	 DW	7EH		;9600 
	 DW	7FH		;19200
	 DW	0		;38400
;
ERRMARK	 DB	'!'		;ERROR MARKER
COMPUTER DB	'    Columbia M64 "Shoebox"    ',CR
;                .........1.........2.........3  30 bytes
	 PAGE
	 ORG	NETBIOS+31BH
;
SCRNSIZE DB	24		;LINES ON SCREEN
SCRNWID	 DB	80		;WIDTH OF SCREEN
; 
CLRLINE	 DB	1,14,0,0,0,0,0,0,0,0	;CLEAR TO EOL
DIRCURSR DB	2,27,'=',0,0,0,0,0,0,0	;DIRECT CURSOR ADDR
MIDCURSR DB	0,0,0,0,0,0,0,0,0,0	;MIDDLE STRING
ENDCURSR DB	0,0,0,0,0,0,0,0,0,0	;ENDING STRING
VOFFSET	 DB	32		;CURSOR ADDR OFFSET
CURSRTYP DB	0		;0=Y,X; 1=X,Y
ASCCURSR DB	0		;ASCII CURSOR ADDR
VDELAY	 DB	0		;CURS ADDR DELAY
REVVIDEO DB	1,1,0,0,0,0,0,0,0,0	;REVERSE VIDEO
NORVIDEO DB	1,2,0,0,0,0,0,0,0,0	;NORMAL VIDEO
SAVECPOS DB	0,0,0,0,0,0,0,0,0,0	;SAVE CURSR POSN
RSTRCPOS DB	0,0,0,0,0,0,0,0,0,0	;RESTORE CURSR POSN
MSGLINE	 DB	0	;WHERE TO PUT MESSAGE
;

	 ORG	NETBIOS+61CH
;
SYSTEMID DB	3	;THIS SYSTEM ID	
FASTCLK	 DB	TRUE	;4MHZ OR BETTER
MSGKEY	 DB	1CH,0,0,0 ;MSG KEY SEQUENCE
RELOC	 DW	0	;WHERE TO PUT NETBIOS	
	 DS	8	;reserved
;
PORTSTAT EQU	59H	;PORT 1 STATUS
MPORT	 EQU	58H	;PORT 1 DATA
PORTCTL	 EQU	59H	;PORT 1 CONTROL
PORTBAUD EQU	80H	;PORT 1 BAUD RATE
;
; USART CONTROL BYTES
;
USART1	 DB	80H		;GET USART'S ATTN
USART2	 DB	40H		;SOFTWARE RESET
FINALBIT DB 	37H		;ENABLE XMIT
FIXED	 DB	02H		;USART CONSTANT BITS
;
PARITY	 DB	0		;PARITY
CHARBITS DB	0CH		;BITS/CHAR = 8
STOPBITS DB	0C0H		;STOP BITS = 2
RATEBAUD DW	7FH		;DEFAULT BAUD RATE 
;
	TITLE 'COLUMBIA DRIVERS'

	ORG	NETBIOS+OFFSET
;
DRIVERS	 EQU	$		;VECTOR TABLE
ANYEXT   JMP 	DR$ANYEXT
INEXT    JMP 	DR$INEXT
EXTRDY   JMP 	DR$EXTRDY
OUTEXT   JMP 	DR$OUTEXT
RESETEXT JMP 	DR$RESETEXT
ACTIVITY RET	! NOP ! NOP
PRTRBUSY RET	! NOP ! NOP
;
; COLUMBIA I/O ROUTINES
;
;
; CHECK IF BYTE AT MODEM
; Z set if byte available.
; May use registers A, B, C.
;
DR$ANYEXT IN 	PORTSTAT	;PORT STATUS
	XRI 	2		;MAKE LOW TRUE
	ANI 	2		;DATA AVAIL?
	RET
;
; GET BYTE FROM MODEM
; May use registers A, B, C.
;
DR$INEXT IN 	MPORT		;DATA PORT 
	 RET
;
; CHECK IF MODEM PORT READY TO XMIT
; Z set if so.
; May use registers A, B, C.
;
DR$EXTRDY IN 	PORTSTAT	;STATUS PORT
 	 XRI 	1
 	 ANI 	1		;TBE?
 	 RET
;
; SEND BYTE TO MODEM
; May use registers A, B, C.
;
DR$OUTEXT OUT	MPORT
	 RET
;
;
; INITIALIZE USART, ENABLE XMIT
;
DR$RESETEXT:
	LDA	USART1
	OUT     PORTCTL		;GET USART'S ATTN
	OUT	PORTCTL
	OUT	PORTCTL
;
	LDA 	USART2 		;SOFTWARE RESET
	OUT	PORTCTL
;
 	LDA 	PARITY 		;PARITY
 	MOV 	B,A 		;INTO B
 	LDA 	CHARBITS 	;NUM DATA BITS
 	ORA 	B 		;COMBINE THEM
 	MOV 	B,A 		;SAVE IN B
 	LDA 	STOPBITS 	;NUM STOP BITS
 	ORA 	B 		;COMBINE THEM
 	MOV 	B,A 		;SAVE IN B
 	LDA 	FIXED 		;CONSTANT BITS
 	ORA 	B		;COMBINE THEM
 	OUT	PORTCTL 	;SEND MODE INSTR
;
	LDA	FINALBIT
	OUT	PORTCTL		;ENABLE XMIT
;
;	LDA 	RATEBAUD
;	OUT	PORTBAUD
	RET
;
	END
