;**********************************************************
; WILL work with North Star Hard Disk
;							  *
;		    NEWFORM  VERSION 1.4		  *
;			 12/02/82			  *
;		       R. L. Plouffe 			  *
;							  *
;	A patch overlay file for adding alternate	  *
;	disk formats to North Star CP/M vers 1.1.0	  *
;							  *
MSIZE	EQU	32		;MEMORY SIZE THIS VERS	  *
				;CHANGE TO YOUR SIZE HERE *
OVERLAY	EQU	OVERLAY		;COMPUTED SYSGEN OVERLAY  *
;							  *
;**********************************************************
;
; Vers 1.4 Changed location of F35 and F40 labels so that
; North Star Hard Disk will work properly. Must now use
; NEWCPY and NEWFMT versions (copier and formatter) that
; sign on and say 'as of Dec 2, 1982' or later.
;
; Vers 1.3 Fixed address in image of call argument to INIT
; routine. Marked @1.3
;
; Vers 1.2 Added conditional assembly for selection of one
; or both of the alternate formats.  Stuffed code so that
; the support code for hard disk users is left intact ex-
; cept for the last 80H of USER area which is overwritten
; by the directory buffer if the OCTAL equ is set true.
; That code is not used after boot anyhow and the dirbuf is
; not written until after boot. So, it doesn't hurt anything.
; If the alternate OCTAL format is selected, the 'ILLEGAL
; ACCESS' message in the bios is changed to 'NO'. (Done to 
; make some code space available for ALTOCTL rtne.)   rlp
; 
; Vers 1.1  Fixed bug that prevented proper reading of a 
; Quad disk formatted for 80 tracks when mounted in an
; Octal drive and accessing files above 70 tracks.  Changes
; are marked by ;@1.1			rlp
;
;	*****This patch file was previously called
;	ALTFORM, ALTFRM, or ALTFOR with various version
;	numbers.  Those versions did not achieve the
;	complete degree of compatibility between all
;	of the disk formats supported by N* and this
;	patch.  This version DOES, so it is renamed
;	to NEWFORM and version number reset to 1.0.
;	PLEASE throw away previously named versions
;	and start over again with this one.
;
;	THIS VERSION ALSO NOW SUPPORTS AN ADDITIONAL
;	FORMAT FOR QUAD DRIVES THAT GIVES 40 TRACKS
;	PER SIDE AND IS COMPATIBLE WITH NORTH STAR
;	FORMAT FOR 35 TRACKS/SIDE. FORMAT BYTE IS D0H.
;
;	PATCH THIS INTO THE DISTRIBUTION VERSION
;	OF NORTH STAR CP/M VERSION 1.1.0 TO PROVIDE
;	AN ALTERNATE FORMAT WITH 2KB BLOCKS VS 4KB
;	FOR 96 TPI DRIVES.  YOUR FORMATTER MUST BE
;	MODIFIED TO PROVIDE A FORMAT BYTE = 0D2H.
;	SEE NEWFRMAT.COM FOR A FORMATTER THAT WILL
;	DO THIS. ALSO SEE NEWCOPY.COM FOR A COPY
;	PROGRAM THAT TOLERATES THE D0/D2H FORMAT BYTES.
;	MUST USE GENSYS41 TO WRITE TO YOUR SYSTEM TRACKS.
;
;	BY DISTRIBUTION VERSION, I MEAN WITH A USER
;	AREA **EXACTLY** AS GENERATED BY CPMGEN. OTHERWISE
;	YOU ARE ON YOUR OWN FOR FINDING A PLACE IN YOUR
;	CBIOS FOR THE 'NEWFORM' ROUTINES AND A SPACE OF
;	80H BYTES (CAN BE UNITIALIZED RAM) FOR REDIRECTING
;	THE DIRECTORY BUFFER IF 'OCTAL' IS SET TRUE.
;
;	CALL ME FOR A SOURCE OF NEWFRMT.COM, NEWCOPY.COM
;	AND GENSYS41.COM     703-524-2549 (it's a computer)
;
;	Thanks to Sigi Kluger and Frank Wancho for their help
;	in debugging this code.			RLP
;
;**********************************************************
;
;		EQUATES
;
FALSE	EQU	0
TRUE	EQU	NOT FALSE
;
OCTAL	EQU	TRUE		;Want alternate octal format
				;for 2kb directory blocks?
QUAD	EQU	TRUE		;Want alternate quad format
				;for 80 tracks?
;
;***********************************************************
;If you have a Hard Disk system, you will have to adjust the
;addresses of the CCP, BIOS and BDOS for a given MSIZE, and
;in any case you will have to adjust these components if
;you split the system around the disk controller PROM.
;
BIOS	EQU	(MSIZE*1024)-0D00H	;BASE OF BIOS
CCP	EQU	BIOS-1600H
BDOS	EQU	CCP+800H
OVERLAY	EQU	2B00H-BIOS	;COMPUTED OVERLAY
USER	EQU	BIOS+700H	;USER PATCH AREA
	;
BUF	EQU	USER+200H
JRZ	EQU	28H
JRNZ	EQU	20H		;z80 relative jumps
JR	EQU	18H
DPB3	EQU	BIOS+50EH	;Quad
DPB4	EQU	BIOS+51EH	;N-drive (Octal)
SEKTRK	EQU	BIOS+0CAEH
TINUIT	EQU	BIOS+5ACH
WRTDPH	EQU	BIOS+444H	;routine in bios to
				;write the Disk Parm Header
;
;**********************************************************
;This overlays the jump table at the base of the BIOS so
;that the code space used for jumps at the base of the
;USER area is free (24 bytes) for our use. Addresses must
;point to your routines if different from distribution
;version.
;
	IF	QUAD
	ORG	BIOS	
	DS	3		;boot
	DS	3		;wboot
	JMP	BIOS+74DH	;const
	JMP	BIOS+71EH	;conin
	DS	3		;consout
	JMP	BIOS+763H	;prtser
	JMP	BIOS+756H	;punch
	JMP	BIOS+71EH	;reader
	DS	3		;home
	DS	3		;seldsk
	DS	3		;settrk
	DS	3		;setsec
	DS	3		;setdma
	DS	3		;read
	DS	3		;write
	JMP	BIOS+78AH	;listst
;
	ORG	BIOS+54BH
	DW	BIOS+756H	;address of CONOUT
	ORG	CCP-100H+56H	;arg of call to INIT @1.3
	DW	BIOS+78CH	;address of INIT routine
;
;**********************************************************
;Routine to patch and unpatch the Bios
;
	ORG	USER
STOREM:
	STA	BIOS+105H
	INR	A
	STA	BIOS+10BH
	STA	BIOS+668H
	STA	BIOS+68EH
	RAL			;@1.1
	ADI	3FH		;@1.1
	STA	BIOS+66DH	;@1.1
	RET
	DB	0,0,0,0		;do not expand - 24 bytes here
	ENDIF	;QUAD
;
;**********************************************************
;Alternate Disk Parameter Block for 96 tpi drives.  This
;version of NEWFORM now permits support of the original
;North Star format for N-drives as well as this one.
;
	ORG	BIOS+32AH
	IF	OCTAL
	;Double	density, double sided (2.x)
	;Format byte = D2H
	;Double track (96/in.)
	;
N5	EQU	160	;number of tracks
SPT5	EQU	40	;CPM sectors per track
DRM5	EQU	127	;directory size-1
BLS5	EQU	2	;block size (kbytes)
SYSTRK5	EQU	2	;reserved tracks
	;
DSM5	EQU	-1+(((N5-SYSTRK5)*SPT5)/(8*BLS5))
;
	DB	8*BLS5
	;
DPB5:
	DW	SPT5	;SPT-sectors/track
	DB	04	;BSH-block shift factor
	DB	8*BLS5-1;BLM-block mask
	DB	BLS5-1-BLS5/2
			;EXM-null mask
	DW	DSM5	;DSM-disk size-1
	DW	DRM5	;DRM-directory max
	DB	192	;AL0-allocation 0
	DB	0	;AL1-allocation 1
	DW	(DRM5+1)/4
			;CKS-check size
	DW	SYSTRK5	;OFF-track offset
	ENDIF	;OCTAL
;
;**********************************************************
;Alternate Disk Parameter Block for QUAD (48tpi) drives. This
;version of NEWFORM now permits support of the original
;North Star format for Quad drives as well as this one.
;
	IF	QUAD
	;Double	density, double sided (2.x)
	;Format byte = D0H
	;
N6	EQU	80	;number of tracks
SPT6	EQU	40	;CPM sectors per track
DRM6	EQU	63	;directory size-1
BLS6	EQU	2	;block size (kbytes)
SYSTRK6	EQU	2	;reserved tracks
	;
DSM6	EQU	-1+(((N6-SYSTRK6)*SPT6)/(8*BLS6))
;
	DB	8*BLS6
	;
DPB6:
	DW	SPT6	;SPT-sectors/track
	DB	04	;BSH-block shift factor
	DB	8*BLS6-1;BLM-block mask
	DB	BLS6-1	;EXM-null mask
	DW	DSM6	;DSM-disk size-1
	DW	DRM6	;DRM-directory max
	DB	128	;AL0-allocation 0
	DB	0	;AL1-allocation 1
	DW	(DRM6+1)/4
			;CKS-check size
	DW	SYSTRK6	;OFF-track offset
	ENDIF	;QUAD
;
	IF	OCTAL
ILLEGAL:
	DB	'NO',80H
			;do not expand - 35 bytes here
;
;**********************************************************
;These routines are in-line with the bios SELDSK routine
;and permit the alternate formats above if your formatter
;is modified to place a 0D2H at the format byte location
;and formats 160 tracks for 96 tpi drives; and, a 0D0H
;format byte with formatting of 80 tracks for Quad drives.
;
	ORG	BIOS+6A9H
ALTOCTL:
	MOV	A,B	;get the format byte
	LXI	D,DPB4-1
	ANI	20H	;see which format
DB	JRNZ,	GODPH1-$-1
	LXI	D,DPB5-1
GODPH1:	JMP	WRTDPH	;go write the Disk Parm Header
	DB	0	;do not expand - 15 bytes here
	ENDIF	;OCTAL
;
	IF	QUAD
	ORG	USER+115H
ALTQUAD:
	MOV	A,B	;get the format byte
	ANI	40H	;see if double sided
DB	JRZ,	GODPH2-$-1
	MOV	A,B	;get the format byte again
	ANI	20H	;see which format
DB	JRNZ,	GODPH2-$-1
	LXI	D,DPB6-1;point to Disk Parm Block for this
			;format.
GODPH2:	JMP	WRTDPH	;go write the Disk Parameter Header
;
;**********************************************************
;Routine to test for 80 track format and to patch or unpatch
;depending on 80/70 tracks.
;
CKQUAD80:
	LDA	F35
	CALL	STOREM
	LDA	BDOS+0DC6H ;get the disk size byte for
			   ;current disk access
	CPI	DSM6
DB	JRNZ,	COMRDWR-$-1
	LDA	F40
	CALL	STOREM
COMRDWR
	LHLD	SEKTRK
	JMP	TINUIT
	DB	0,0	   ;do not expand - 43 bytes here
	ENDIF	;QUAD
;
;**********************************************************	
;These patches provide for moving the directory buffer so
;that the necessary scratch space for the disk allocation
;vectors (ALV's) is there. The ALV space is now 39H for
;each drive instead of 19H as in original N* release.  The
;Directory buffer has been moved to the last 80H of the 
;USER patch area since the support code contained therein
;is expendable after you have booted your system.
;The Disk Parameter Headers which get written by the BIOS 
;are moved down by 80H to provide for the expanded ALV space.
;ALV SPACE IS THUSLY EXPANDED **ONLY** IF YOU SELECT THE
;ALTERNATE OCTAL FORMAT TO BE TRUE.
;
	IF	OCTAL
	ORG	BIOS+460H
	DW	DIRBUF
	ORG	BIOS+46CH
	DW	003DH
	ORG	BIOS+481H
	DW	DPBASE0-6AH
	ORG	BIOS+484H
	DW	006AH

DPBASE0	EQU	BUF+200H
DIRBUF	EQU	USER+180H
;
	ORG	BIOS+441H
	JMP	ALTOCTL	;puts the ALTOCTL routine in-line
			;with the SELDSK routine in bios.
	ENDIF	;OCTAL
;
	IF	QUAD
;patches for quad drives to give 40 tracks per side
	ORG	BIOS+437H
	DW	ALTQUAD	;to check for alt Quad format
;
	ORG	BIOS+43EH
	DW	ALTQUAD
;
	ORG	BIOS+5A9H
	JMP	CKQUAD80
	ENDIF	;QUAD
;
	ORG	BIOS+6E5H
;These 2 bytes are used in the alternate Quad formatting scheme
;and are manipulated by the formatter, NEWFRMAT.COM.  So don't
;change or delete these bytes or their location.
F35:	DB	22H
F40:	DB	27H
;
	IF	OCTAL
	ORG	BIOS+693H
	DW	ILLEGAL
	ENDIF	;OCTAL
;
;**********************************************************
;
	END
