; SMDMPAT.ASM
;
; XMODEMxx PATCH FILE FOR SMARTMODEM
;
; 11/17/83 - Renamed to XMSM-1.ASM	- Irv Hoff
; 02/11/83 - Edited			- Sigi Kluger
;
MODCTLP: EQU	3		;PMMI VALUES (BASE PORT ADDRESS)
MODSNDB: EQU	1		;BIT TO TEST FOR SEND
MODSNDR: EQU	1		;VALUE WHEN READY
MODRCVB: EQU	2		;BIT TO TEST FOR RECEIVE
MODRCVR: EQU	2		;VALUE WHEN READY
MODDCDB: EQU	1		;CARRIER DETECT BIT
MODDCDA: EQU	1		;VALUE WHEN ACTIVE
MODDATP: EQU	MODCTLP-1	;DATA IN PORT
MODDATO: EQU	MODCTLP-1	;DATA OUT PORT
BAUDRP:	 EQU	5		;BAUD RATE OUTPUT/MODEM STATUS
;
BASE:	 EQU	100H		;start of TPA
;
;-------------------------------------------------------------------
;
; Jump table: The jump table must be in exactly the same sequence
; as the one in XMODEM. Note the ORG of 103H - This jump table has
; no jump to BEGIN.
;
;
	 ORG	BASE+3	;start after JMP BEGIN
;
;
CONOUT:	 JMP	0E209H	;CRT out vector (MUST BE JMP 0 IF NOT IMPLEM.)
PMINIT:	 JMP	MINIT	;initialize whatever has to be (or do RET)
PUNINIT: JMP	UNINIT	;undo whatever MINIT did (or RET)
PSENDR:	 JMP	SENDR	;send data byte on stack (POP PSW / OUT)
PCAROK:	 JMP	CAROK	;test for carrier. RET Z=ok, NZ=no carrier
PMDIN:	 JMP	MDIN	;receive data byte
PGETCHR: JMP	GETCHR	;IN from modem data only
PRCVRDY: JMP	RCVRDY	;check receive ready RET Z=ready
PSNDRDY: JMP	SNDRDY	;check send ready RET Z=ready
PSPEED:	 JMP	SPEED	;get speed factor in ACC
PSPARE1: JMP	SPARE	;3 jumps for custom routines
PSPARE2: JMP	SPARE
PSPARE3: JMP	SPARE
;
;-----------------------------------------------------------------------
;
SPARE:				;for later use
MINIT:				;no initialization required
UNINIT:	RET			;not initialized, so no un-initialize.
;.....
;
;
; SNDRDY - check if ready to send
;
SNDRDY:	IN	MODCTLP		;get status byte
	ANI	MODSNDB		;mask off bit to be tested
	XRI	MODSNDR		;set status flag
	RET
;.....
;
;
; SENDR - send character
;
SENDR:	POP	PSW		;get character from stack
	OUT	MODDATO		;send character
	RET
;.....
;
;
; RCVRDY - check receive ready
;   RET with Z = character available.
;   RET error code in A
;
RCVRDY:	IN	MODCTLP
	ANI	MODRCVB		;isolate ready bit
	CPI	MODRCVR		;test it
	MVI	A,0
	RET
;.....
;
;
; MDIN - receive a character (GETCHR is identical)
;
GETCHR:
MDIN:	IN	MODDATP		;get character
	RET			;return it
;.....
;
;
; SPEED - This routine returns the speed code.
;   0=110, 1=300, 2=450, 3=600, 4=710, 5=1200
;   Load your speed byte from low memory, or
;   simply MVI A,n and RET for default speed only
;
SPEED:	IN	BAUDRP
	ANI	2
	MVI	A,1
	RZ
	MVI	A,5
	RET
;.....
;
;
; CAROK - check for presence of carrier.
;   RET with Z = carrier on
;
CAROK:	IN	BAUDRP		;get status
	ANI	MODDCDB		;get cd bit
	CPI	MODDCDA		;test bit
	RET
;.....
 