;
;TITLE 'SENDOUT UTILITY V.8 FOR CP/M AND MODEM AS OF 1/19/83 AAJ'
;
;THIS ROUTINE WRITTEN BY AL JEWER AND RELEASED IN PUBLIC
;DOMAIN 4/8/81. 
; 
; THIS PROGRAM AND DOCUMENTATION COPYRIGHT 1981, 1982, 1983 
; BY AL JEWER. THIS SOFTWARE MUST NOT BE SOLD.
;
;THIS CP/M TRANSIENT COMMAND IS INVOKED IN THIS MANNER:
;
;A>SENDOUT XMODEM S FILENAME.TYP
;
;IN THIS EXAMPLE, THE STRING "XMODEM S FILENAME.TYP"
;WILL BE SENT OUT THE MODEM PORT TO A REMOTE SYSTEM.
;THIS IS FOR USE IN:
;
;		1) TRANSFERRING MULTIPLE PROGRAMS TO & FROM
;			REMOTE USING A SUBMIT FILE
;
;		2) SENDING COMMANDS WITHOUT HAVING TO
;			ENTER & EXIT THE "MODEM" PROGRAM
;
;THE STRING CAN BE UP TO 127 CHARACTERS LONG, AND IS 
;ECHOED TO THE LOCAL CONSOLE AS IT IS SENT.
;
;  DEFAULT MODE OF OPERATION
;
;THE PROGRAM WILL WAIT FOR A ">" CHARACTER BEFORE IT
;SENDS THE LINE, TO ALLOW THE REMOTE TO BE READY FOR
;THE COMMAND LINE. AS THE LINE IS SENT, THE PROGRAM 
;WILL CHECK THE CHARACTERS ECHOED BACK TO ASSURE THAT
;THE COMMAND LINE HAS BEEN TRANSMITTED PROPERLY.
;IF AN ERROR IS DETECTED, THE PROGRAM WILL SEND OUT
;A ^U FOLLOWED BY A CARRIAGE RETURN, THEN RETRY 
;SENDING THE LINE, UNTIL A PROPER TRANSMISSION IS MADE.
;
;  SPECIAL MODE OF OPERATION (FOR NON-CP/M SYSTEMS)
;
; TO ALLOW USE WITH OTHER SYSTEMS, PROVISION HAS BEEN 
; MADE TO CHANGE THE PROMPT CHARACTER IN THE COMMAND 
; LINE, USING AN ASTRISK TO INDICATE THIS MODE.
; THE COMMAND THEN TAKES THE FORM:
;
; SENDOUT *?COMMAND LINE
;
; THIS COMMAND LINE WILL CAUSE THE SENDOUT PROGRAM TO 
; WAIT FOR A '?' CHARACTER INSTEAD OF THE MORE USUAL '>'.
; ALSO, IN THE CASE WHERE A TRANSMISSION ERROR OCCURS,
; THE PROGRAM WILL SEND ASCII 'DELETE' CHARACTERS (07FH)
; TO CANCEL THE INPUT LINE. THIS IS USED INSTEAD OF THE 
; ^U USUALLY USED IN CP/M.
;
; OR,
;
; SENDOUT *^JCOMMAND LINE
;
; THIS MODE WORKS THE SAME AS ABOVE, EXCEPT IN THIS CASE,
; THE 'TRIGGER' CHARACTER WILL BE A CONTROL-J (LINE FEED).
; NOTE THAT YOU MUST TYPE THE UP-ARROW CHARACTER TO 
; INDICATE THAT THE ASCII CHARACTER FOLLOWING IS ACTUALLY
; A CONTROL CHARACTER. THIS ALLOWS USING ANY ASCII CHARACTER
; AS THE TRIGGER CHARACTER (EXCEPT, OF COURSE, FOR '^').
;
;UPDATES: (IN REVERSE ORDER TO MINIMIZE READING TIME)
;
;19-JAN-83 MODIFIED BY AL JEWER TO ALLOW USE WITH NON-CP/M
;          SYSTEMS BY ALLOWING USER-SPECIFIED 'TRIGGER'
;          CHARACTER. CHANGED APPLE MODS TO GENERAL 
;          PURPOSE MEMORY-MAPPED I/O ROUTINES. ELIMINATED
;          MULTIPLE NAMES FOR PORTS AND MASK BITS.
;
; 5-OCT-82 ADDED EQUATES TO ALLOW USE WITH AN INTEL
;          I8251 USART SERIAL PORT.
;				DAVE MABRY
;
;15-JAN-81 MODIFIED BY JOHN LIMPERT TO ADD MEMORY
;	   MAPPED I/O FOR THE APPLE ][ WITH A D.C.
;	   HAYES MICROMODEM IN SLOT #2. SET APPLE
;	   TRUE FOR THIS CONFIGURATION.
;
;10-DEC-81 MODIFIED BY AL JEWER TO REMOVE REFERENCE TO
;	   LOCAL CONSOLE PORT (FUNCTION NOW PERFORMED 
;	   BY BIOS CALLS)
;	   ALSO ADDED RETRY COUNTER TO GIVE UP IF PHONE
;	   LINE GETS TOO HORRIBLE.
;
;23-NOV-81 MODIFIED BY JOHN LABOVITZ. ADDED SOME
;	   SIGNON MESSAGES, AND ABILITY TO ABORT
;	   BY A ^C.
;
;15-AUG-81 MODIFIED BY HOWARD BOOKER TO INCLUDE
;	   CONDITIONAL EQUATES FOR THE DC HAYES
;	   80-103A MODEM CARD.
;
;10-APR-81 REWRITTEN BY AL JEWER TO CHECK ECHOED
;	   STRING FOR VALID TRANSFER.
;
;08-APR-81 MODIFIED BY TOM JORGENSON FOR SUPPORT
;	   OF OTHER MODEM/PORT TYPES (ESP. H89)
;
;ANY QUESTIONS OR COMMENTS:
;
;	AL JEWER
;	PO BOX 123
;	WHITEWATER, WI. 53190
;
;	(414) 563-9932 (F4 RCPM SYSTEM)
;
;BASE DEFINITION, CHANGE THIS TO 4200H IF ALTERNATE CP/M
;(RELOCATED) VERSION SUCH AS HEATH/LIFEBOAT OR TRS-80
;
BASE	EQU	0	;BASE OF MEMORY SEGMENT
;
;THESE SHOULD BE O.K. AS IS
;
CBOOT	EQU	BASE	;JUMP HERE TO COLD BOOT CP/M
BDOS	EQU	BASE+5	;BDOS FUNCTION CALL ADDRESS
BUFFER	EQU	BASE+80H ;INPUT LINE BUFFER
CONOUT	EQU	2	;CP/M CONSOLE OUTPUT FROM E
PLINE	EQU	9	;CP/M PRINT STRING AT (DE)
CSTAT	EQU	11	;CP/M CONSOLE STATUS
CONIN	EQU	1	;CP/M CONSOLE INPUT
CR	EQU	0DH	;ASCII CHARACTERS
LF	EQU	0AH
CTLU	EQU	'U'-40H ;CONTROL-U
CTLC	EQU	'C'-40H ;CONTROL-C
DELETE	EQU	07FH	;ASCII DELETE CHARACTER (RUBOUT)
;
; IF YOU REQUIRE DEFAULTS FOR OTHER THAN CP/M SYSTEMS, CHANGE THE 
; EQUATES BELOW TO MATCH YOUR SYSTEM REQUIREMENTS.
;
CANCEL	EQU	CTLU	;THIS CHARACTER CANCELS INPUT LINE
;
DEFAULT	EQU	'>'	;DEFAULT TRIGGER CHARACTER (SYSTEM PROMPT)
;
SPECIAL	EQU	'*'	;THIS CHARACTER, WHEN USED AS THE 1ST 
;			;CHARACTER OF THE CP/M COMMAND LINE TAIL,
;			;INDICATES A REQUEST FOR THE NON-CP/M MODE.
;			;(SEE DOCUMENTATION ABOVE)
;
FALSE	EQU	0
TRUE	EQU	NOT FALSE
;
PMAPIO	SET	TRUE	;*** DO NOT CHANGE THIS STATEMENT ***
			;THIS FLAG SETS PORT MAPPED OR MEMORY 
			;MAPPED I/O ROUTINES. IT IS ACTUALLY
			;SET UP IN EQUATES BELOW.
			;IF YOU ADD EQUATES FOR A DIFFERENT MODEM 
			;TYPE WHICH USES MEMORY MAPPED I/O, ADD
			;A 'PMAP SET FALSE' STATEMENT TO YOUR 
			;EQUATE BLOCK (EX: APPLE EQUATES)
;
FASTCLK EQU	TRUE 	;TRUE IF 4MHZ OR GREATER
;
RETRYS	EQU	32	;RETRY THIS MANY TIMES BEFORE GIVING UP
;
;CHOOSE YOUR MODEM/PORT TYPE HERE:
;
APPLE	EQU	FALSE	;TRUE, IF APPLE WITH MMII
H89	EQU	FALSE	;TRUE, IF H89
PMMI	EQU	TRUE 	;TRUE, IF PMMI
DCH	EQU	FALSE	;TRUE, IF DCH
INTEL	EQU	FALSE	;TRUE, IF INTEL MDS-225 OR EQUIVALENT
;
	IF	PMMI
;
;CHANGE THE FOLLOWING IF YOUR PMMI IS NOT AT THE 
;STANDARD BASE ADDRESS OF 0C0H.
;
TPORT	EQU	0C0H	;THIS IS STATUS PORT
DPORT	EQU	TPORT+1 ;DATA I/O PORT
POTBMT	EQU	1	;XMIT BUFFER EMPTY FLAG
PODAV	EQU	2	;DATA AVAILABLE FLAG
;
	ENDIF		;PMMI
;
	IF	H89
;
;SHOULD USE THESE AS LONG AS YOU CONFORM
;TO STD PORT ADDRESS (330Q)
;
TPORT	EQU	335Q	;STATUS PORT (8250 UART)
DPORT	EQU	330Q	;DATA PORT
POTBMT	EQU	040Q	;THRE BIT (TX BUFFER EMPTY)
PODAV	EQU	001Q	;DATA AVAILABLE FLAG
;
	ENDIF		;H89
;
	IF DCH
;
;STANDARD DC HAYES MODEL 80-103A PORTS
;
TPORT	EQU	81H	;STATUS PORT (TR1602 UART)
DPORT	EQU	80H	;DATA PORT
POTBMT	EQU	02H	;THRE BIT (TX BUFFER EMPTY)
PODAV	EQU	01H	;DATA AVAILABLE FLAG
;
	ENDIF		;DCH
;
	IF APPLE
;
PMAPIO	SET	FALSE	;APPLE USES MEMORY MAPPED I/O
;
;APPLE ][ WITH MICROMODEM IN SLOT #2
;
TPORT 	EQU	0E0A6H	;ACIA CSR
DPORT 	EQU	0E0A7H	;ACIA DATA BUFFER
POTBMT	EQU	02H	;TRANSMIT REGISTER EMPTY BIT
PODAV 	EQU	01H	;RECEIVER DATA AVAILABLE BIT
;
	ENDIF		;APPLE
;
;
	IF	INTEL
;
TPORT	EQU	0F7H	; STATUS PORT (I8251 USART)
DPORT	EQU	0F6H	; DATA PORT
POTBMT	EQU	1	; TRANSMITTER READY
PODAV	EQU	2	; RECIEVER READY (IE CHAR AVAILABLE)
;
	ENDIF		;INTEL MDS-225
;
ORG	BASE+100H	;START OF TPA
;
START:	JMP 	START1	;AROUND COPYRIGHT NOTICE
	DB	'Copyright 1981, 1982, 1983 Al Jewer'
START1:	LXI 	H,0	;GET THE SYSTEM STACK POINTER 
	DAD	SP	;TO THE HL
	SHLD	OLDSTK	;STORE FOR EXIT
	LXI	SP,STACK ;SET SAFE STACK
	CALL	ILPRT	;SAY HELLO TO THE FOLKS
	DB	'SENDOUT V. 8.0  --  Type ^C to ABORT',CR,LF,0
	MVI	A,RETRYS ;SET RETRY COUNTER 
	STA	TRYNUM	;TO ITS INITIAL VALUE
	LHLD	1	;GET WARM BOOT ADDRESS
	LXI	D,4	;PLUS 1 TABLE POSITION & 1 JMP
	DAD	D	;GIVES CONSTAT VECTOR AT (HL)
	MOV	E,M	;LO BYTE OF CONSTAT
	INX	H	;POINT TO HI BYTE
	MOV	D,M	;CONSTAT VECTOR NOW IN DE
	XCHG		;CONSTAT VECTOR NOW IN HL
	SHLD	CST+1	;INIT THE CONSTAT CALL
	LXI	H,2	;DISTANCE TO NEXT VECTOR
	DAD	D	;THIS IS CONIN VECTOR AT (HL)
	MOV	E,M	;LO BYTE OF CONIN
	INX	H	;POINT TO HI BYTE
	MOV	D,M	;CONIN VECTOR NOW IN DE
	XCHG		;CONIN VECTOR NOW IN HL
	SHLD	CIN+1	;INIT THE CONIN CALL
	LXI	H,BUFFER ;POINT TO COMMAND LINE BUFFER
	MOV	A,M	;GET THE CHARACTER COUNT
	ORA	A	;ZERO LENGTH?
	JZ	ERROR	;RETURN IF SO
	DCR	A	;LENGTH OF 1? (THIS WOULD BE SPACE ONLY)
	JZ	ERROR	;IGNORE THIS TOO
	INR	A	;RESTORE VALUE
	INR	A	;ADD 1 FOR FINAL CR
	INX	H	;SKIP THE LEADING SPACE
	SHLD	STRING	;STORE DEFAULT STRING ADDRESS
	STA	SLEN	;AND DEFAULT STRING LENGTH
	MOV	B,A	;STRING LENGTH IN B
	INX	H	;SKIP THE SPACE
	MOV 	A,M	;GET THE 1ST CHARACTER ON THE LINE
	CPI 	SPECIAL	;IS IT ALTERNATE PROMPT REQUEST?
	JNZ	NOSPCL	;JUMP IF EVERYTHING IS NORMAL
	DCR	B	;SOAK UP TRIGGER CHARACTER & NEW PROMPT.
	DCR 	B	;
	INX	H	;POINT TO NEW TRIGGER CHARACTER
	MOV 	A,M	;GET IT
	CPI