.TH PCPRINT 1C LOCAL 
.SH NAME
pcprint \- print on local PC printer
.SH SYNOPSIS
pcprint file [file ...]
.SH DESCRIPTION
.I pcprint
allows you to print data from the UNIX system on a printer which is
connected to your terminal or PC.  The terminal must be a DEC VT102,
VT200 series, or VT300 series, or compatible, or your PC must be running
software that emulates one of these terminals, and the emulation must
include the "transparent print" feature.  For example, MS-Kermit 2.31 or 
later may be used on the IBM PC or PS/2 with pcprint.

The pcprint command may be used to print either text or binary files on
your printer.  To do this, pcprint overrides the normal even parity issued by
the UNIX terminal driver.

While pcprint is active, text sent to your screen is redirected to the local
printer by the terminal or PC's internal mechanisms.  These are triggered
when the special escape sequence "ESC [ 5 i" is received, and are deactivated
when when "ESC [ 4 i" is received.  These sequences are sent by pcprint.
.RE
.SH INVOCATION OPTIONS
.TP
.B pcprint
lets you type from the keyboard directly to your printer.  End with Ctrl-D.
.TP
.B pcprint file
prints the UNIX file on your printer.  "file" may be a single file,
a list of files, or a wildcard file specification.  If more than one file
is specified, they are not separated on the printout (but see below).
.TP
.B pcprint < file
prints the UNIX file on your printer.  If more than one file is specified,
only the first one is printed.
.TP
.B command | pcprint
The standard output of any UNIX command may be piped to pcprint.
.PP
The pcprint command may be used with the MM mail program to print mail
messages on your local printer from within MM.  To do this, issue the
MM command "set print-filter pcprint".  Subsequent MM "print" commands
will go to your local printer.

The pcprint program may also be used with the UNIX "pr" command to produce
paginated listings.  For example:

  pr -f *.c | pcprint

will print all your C programs with page headings containing the date and
time, filename, and page number, with formfeeds inserted between each page.
You can include "pr" in your MM print-filter too:

  set print-filter pr -f -h "E-Mail Message" | pcprint

The pcprint program can be safely interrupted by typing Control-C.  If you
interrupt it this way, it will restore your terminal to normal (non-printing).

.SH SEE ALSO
mm(l), pr(1)
.sp 1.0v
Christine Gianone et al, "MS-DOS Kermit User's Guide", Columbia 
University, December 1988. 
.SH AUTHORS
Christine Gianone and Frank da Cruz, Columbia University, March 1989.
.SH BUGS
No known problems on the SUN computers.  VAX computers running Ultrix may
not be able to respond to flow control commands from the terminal or PC,
and therefore data may be lost during printing.

If you run pcprint from a terminal or PC that does not have a printer
attached, or with a printer that is not turned on, the terminal or PC may
become stuck waiting for the printer to become ready.
