;
;	UHAYES2.ASM ver 2.1 as of 7/13/80
;	   by Keith Petersen, W8SDZ
;
;This is the user area for BSTAM version 4.3 for use with
;a D.C. HAYES modem.
;
;	IF YOU WISH TO USE OTHER REGISTERS SUCH AS HL,BC,DE
;	(NOT INCLUDING  SP  REGISTER)
;	BE SURE TO PUSH BSTAM'S REGISTERS ON TO STACK AND POP
;	THEM BACK OFF BEFORE RETURNING TO BSTAM.
;	THERE IS AMPLE ROOM TO PUSH ALL REGISTERS ONTO BSTAM'S
;	STACK, PLUS ROOM FOR 10 LEVELS OF CALL'S.
;
;	THERE ARE 300 BYTES OF USER SPACE AVAILABLE TO YOU.
;
;	THE JUMP'S CODED AT THE BEGINNING OF THIS PROGRAM
;	CANNOT BE MOVED IN ANY WAY.
;
;	DEFINE PORTS
;
TPM	EQU	82H	;MODE CONTROL PORT
TPS	EQU	81H	;UART STATUS PORT
TP	EQU	80H	;DATA IN/OUT PORT
;
;	CONDITIONAL ASSEMBLY SWITCH
;
FASTCLK	EQU	0	;0 = 2 MHZ, 1 = 4 MHZ SYSTEM CLOCK
;
;	DEFINE ASCII CHARACTERS USED
;
CR	EQU	0DH	;CARRIAGE RETURN
LF	EQU	0AH	;LINE FEED
;
BEGIN	ORG	103H
;
INITIL	JMP	INITIU	;UART/USART INITIALIZATION ENTRY POINT
INSPORT	JMP	INSPRU	;STATUS PORT READ ENTRY POINT
ERRSET	JMP	ERRSTU	;UART/USART ERROR RESET ENTRY POINT
INPORT	JMP	INPRTU	;READ DATA PORT ENTRY POINT
OUTPORT	JMP	OUTPRU	;WRITE DATA PORT ENTRY POINT
;
;
INITIU	EQU	$
;	THIS IS THE UART/USART INITIALIZATION ROUTINE.
;	TO BE COMPATIBLE WITH MOST BSTAM USERS USE FOLLOWING
;	INITIALIZATION GUIDE LINES:
;		1. USE 1 STOP BITS	(OPTIONAL - 2)
;		2. USE 8 DATA BITS	(MUST)
;		3. USE 1 START BIT	(MUST)
;		4. USE 16X FOR CLOCK RATE 	(MUST)
;		5. USE ASYNCHRONOUS MODE ONLY	(MUST)
;
;
	CALL	SIGNON 
	RET		;RETURN TO BSTAM
;
;
INSPRU	EQU	$
;	THIS IS THE STATUS READ PORT ROUTINE.
;	WHEN EXITING THIS ROUTINE BSTAM EXPECTS IN REGISTER A
;	THE FOLLOWING BITS TO BE SET IF NEEDED:
;		1. 20 BIT SET IF FRAMING ERROR
;		2. 10 BIT SET IF OVERRUN ERROR
;		3. 08 BIT SET IF PARITY  ERROR
;		4. 04 BIT SET IF TRANSMITTER EMPTY
;			IF YOUR UART/USART DOES NOT HAVE TRANSMITTER
;			EMPTY FEATURE, THEN ALLWAYS SET THIS BIT ON.
;		5. 02 BIT SET IF RECEIVER READY
;		6. 01 BIT SET IF TRANSMITTER READY
;		7. DO NOT SET THE 80 BIT OR 40 BIT
;
;
;
;BEFORE WE DO THE UART STATUS CHECK WE WILL CHECK TO
;SEE IF CARRIER IS LOST.
;
INSPRU:	PUSH	B	;SAVE REGISTERS USED
	PUSH	D
;
	IF	NOT FASTCLK ;FOR 2MHZ SYSTEM CLOCK
	MVI	B,15	;WAIT UP TO 15 SECONDS
	ENDIF
;
	IF	FASTCLK	;FOR 4MHZ SYSTEM CLOCK
	MVI	B,30	;WAIT UP TO 15 SECONDS
	ENDIF
;
;1 SECOND TIME DELAY ROUTINE. ENTER WITH DESIRED
;NUMBER OF SECONDS IN B REGISTER.
;
ONESEC:	LXI	D,50000 ;VALUE FOR TIME DELAY
;
TLOOP:	IN	TPS	;GET MODEM CHIP STATUS
	ANI	40H	;GET CTS (CARRIER DETECT) BIT
	JNZ	CARROK	;CARRIER NOT LOST, EXIT AND RETURN
	DCR	E	;DECREMENT TIME DELAY VALUE
	JNZ	TLOOP	;NOT DONE, DO ANOTHER LOOP
	DCR	D	;DECREMENT TIME DELAY VALUE
	JNZ	TLOOP	;NOT DONE, DO ANOTHER LOOP
	DCR	B	;DECREMENT NUMBER OF SECONDS
	JNZ	ONESEC	;NOT DONE, DO ANOTHER ONE SEC DELAY
;
;IF WE GET TO HERE, WE HAVE LOST CARRIER FOR 15 SECONDS
;
	POP	D	;RESTORE REGS
	POP	B
	XRA	A
	OUT	TPM	;CAUSE MODEM TO HANG UP
	LXI	D,LSTMSG ;POINT TO MESSAGE
	MVI	C,9
	CALL	5	;PRINT IT
	JMP	0	;EXIT TO CP/M WARM BOOT
;
LSTMSG:	DB	CR,LF,'    ++CARRIER LOST++'
	DB	CR,LF,'The modem is now DISCONNECTED'
	DB	CR,LF,'$'
;
;CARRIER IS NOT LOST
;
CARROK:	POP	D	;RESTORE DE REGS
	POP	B
;
;	NOW GET UART STATUS FOR BSTAM.
;IN THIS CASE WE DISCARD ALL ERROR TEST BITS BECAUSE
;THE D.C. HAYES MODEM HAS NO WAY TO RESET THE ERROR FLAGS
;ONCE THEY ARE UP, CAUSING A CONTINUOUS DISPLAY OF ERROR
;MESSAGES IN BSTAM.
;
	IN	TPS	;GET STATUS (RDA=01H, TBE=02H)
	RAL		;MOVE LEFT ONE
	ANI	6	;ISOLATE RDA AND TBE BITS
	ORI	1	;AND IN BOGUS TBE BIT FOR BSTAM
	RET		;RETURN TO BSTAM
;
;
;
ERRSTU	EQU	$
;
;	THIS IS THE ERROR RESET FOR UART/USART ROUTINE.
;	YOUR UART/USART MAY NOT NEED TO BE RESET IF FRAMING,
;	OVERRUN, OR PARITY ERROR IS FOUND. IF THIS IS YOUR
;	CASE, JUST DO A RETURN.
;
;
	RET		;RETURN TO BSTAM
;
;
;
INPRTU	EQU	$
;
;	THIS IS THE READ DATA PORT ROUTINE.
;	BEFORE THIS ROUTINE IS ENTERED THE 02 BIT OF
;	STATUS READ ROUTINE MUST HAVE BEEN SET.
;	DO NOT CLEAR THE 80 BIT FROM THE DATA INPUT PORT.
;	RETURN WITH REGISTER A LOADED WITH INPUT DATA.
;
;
	IN	TP	;GET DATA FROM PORT
	RET		;RETURN TO BSTAM
;
;
OUTPRU	EQU	$
;
;	THIS IS THE WRITE DATA PORT ROUTINE.
;	BEFORE THIS ROUTINE IS ENTERED THE 04 BIT AND 01 BIT
;	OF STATUS READ MUST BE SET.
;	DO NOT CLEAR THE 80 BIT FROM THE DATA OUTPUT PORT.
;	REGISTER A CONTAINS THE OUTPUT DATA.
;
;
	OUT	TP	;SEND DATA TO REMOTE CPU
	RET		;RETURN TO BSTAM

MESSGE: DB	CR,LF,CR,LF
	DB	'D.C. Hayes modem ver 2.1 - no initialization done,'
	DB	CR,LF,'tests for loss of carrier.'
	DB	CR,LF,'$'
;
SIGNON: PUSH	B
	PUSH	D
	PUSH	H
	LXI	D,MESSGE
	MVI	C,9
	CALL	5
	POP	H
	POP	D
	POP	B
	RET
;
	END	BEGIN
