#include <coleco.h>
#include <getput1.h>

/* from music.s */
extern const void africa_music[];
/* from sound.s */
extern const void snd_table[];

byte toggle_motor = 0;

void main(void)
{
    /* Set sound table */
    set_snd_table(snd_table);
    
    /* Screen Mode 2 - Text mode */
    screen_mode_2_text();
    
    /* Use BIOS ASCII charset */
    load_ascii();
    
    /* Set color to White, Backgrond invisible */
    fill_vram(0x2000,0xf0,2048);
    
    /* Copy pattern to 2nd and 3rd charset */
    duplicate_pattern();
    
    /* Screen Off */
    screen_off();
    
    /* Print information */
    print_at(1,1,"AFRICA BY TOTO - MUSICBOX 2018");
    print_at(1,2,"COMPOSED BY DANIEL BIENVENU");
    print_at(1,4,"APRIL 2018 - MAY 2018");	
    print_at(1,7,"IT'S NOT A CONVERSION,");
    print_at(1,8,"NOR A MIDI OR A MUSIC TRACKER,");
    print_at(1,9,"THIS IS DAYS OF CODING");
    print_at(1,10,"NOTE BY NOTE BY EAR.");
    print_at(4,15,"PRESS FIRE TO PLAY MUSIC");
	/* Stop music */
    stop_music();
    /* Screen ON */
    screen_on();
    /* Enable NMI function */    
    enable_nmi();
    /* Do nothing more... */
infinite_loop:	
	delay(2);
	if ((joypad_1 & FIRE1)!=0)
	{
		/* play music africa */
		play_music(africa_music);
		delay(14);
	}
    goto infinite_loop;
}

void nmi(void)
{
    /* Update Music */
    update_music();
}
