/*
 * pic18f46j50.h - device specific declarations
 *
 * This file is part of the GNU PIC library for SDCC,
 * originally devised by Vangelis Rokas <vrokas AT otenet.gr>
 *
 * It has been automatically generated by inc2h-pic16.pl,
 * (c) 2007 by Raphael Neider <rneider AT web.de>
 */

#ifndef __PIC18F46J50_H__
#define __PIC18F46J50_H__ 1

#define __CONFIG1L      0xFFF8
#define __CONFIG1H      0xFFF9
#define __CONFIG2L      0xFFFA
#define __CONFIG2H      0xFFFB
#define __CONFIG3L      0xFFFC
#define __CONFIG3H      0xFFFD
#define __CONFIG4L      0xFFFE
#define __CONFIG4H      0xFFFF

#define	_DEVID1             	0x3FFFFE
#define	_DEVID2             	0x3FFFFF

extern __sfr __at (0xEC6) RPOR0;

extern __sfr __at (0xEC7) RPOR1;

extern __sfr __at (0xEC8) RPOR2;

extern __sfr __at (0xEC9) RPOR3;

extern __sfr __at (0xECA) RPOR4;

extern __sfr __at (0xECB) RPOR5;

extern __sfr __at (0xECC) RPOR6;

extern __sfr __at (0xECD) RPOR7;

extern __sfr __at (0xECE) RPOR8;

extern __sfr __at (0xECF) RPOR9;

extern __sfr __at (0xED0) RPOR10;

extern __sfr __at (0xED1) RPOR11;

extern __sfr __at (0xED2) RPOR12;

extern __sfr __at (0xED3) RPOR13;

extern __sfr __at (0xED7) RPOR17;

extern __sfr __at (0xED8) RPOR18;

extern __sfr __at (0xED9) RPOR19;

extern __sfr __at (0xEDA) RPOR20;

extern __sfr __at (0xEDB) RPOR21;

extern __sfr __at (0xEDC) RPOR22;

extern __sfr __at (0xEDD) RPOR23;

extern __sfr __at (0xEDE) RPOR24;

extern __sfr __at (0xEE7) RPINR1;

extern __sfr __at (0xEE8) RPINR2;

extern __sfr __at (0xEE9) RPINR3;

extern __sfr __at (0xEEA) RPINR4;

extern __sfr __at (0xEEC) RPINR6;

extern __sfr __at (0xEED) RPINR7;

extern __sfr __at (0xEEE) RPINR8;

extern __sfr __at (0xEF2) RPINR12;

extern __sfr __at (0xEF3) RPINR13;

extern __sfr __at (0xEF6) RPINR16;

extern __sfr __at (0xEF7) RPINR17;

extern __sfr __at (0xEFB) RPINR21;

extern __sfr __at (0xEFC) RPINR22;

extern __sfr __at (0xEFD) RPINR23;

extern __sfr __at (0xEFE) RPINR24;

extern __sfr __at (0xEFF) PPSCON;
typedef union {
	struct {
		unsigned IOLOCK    	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
	};
} __PPSCONbits_t;
extern volatile __PPSCONbits_t __at (0xEFF) PPSCONbits;

extern __sfr __at (0xF26) UEP0;
typedef union {
	struct {
		unsigned EPSTALL   	: 1;
		unsigned EPINEN    	: 1;
		unsigned EPOUTEN   	: 1;
		unsigned EPCONDIS  	: 1;
		unsigned EPHSHK    	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
	};
} __UEP0bits_t;
extern volatile __UEP0bits_t __at (0xF26) UEP0bits;

extern __sfr __at (0xF27) UEP1;
typedef union {
	struct {
		unsigned EPSTALL   	: 1;
		unsigned EPINEN    	: 1;
		unsigned EPOUTEN   	: 1;
		unsigned EPCONDIS  	: 1;
		unsigned EPHSHK    	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
	};
} __UEP1bits_t;
extern volatile __UEP1bits_t __at (0xF27) UEP1bits;

extern __sfr __at (0xF28) UEP2;
typedef union {
	struct {
		unsigned EPSTALL   	: 1;
		unsigned EPINEN    	: 1;
		unsigned EPOUTEN   	: 1;
		unsigned EPCONDIS  	: 1;
		unsigned EPHSHK    	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
	};
} __UEP2bits_t;
extern volatile __UEP2bits_t __at (0xF28) UEP2bits;

extern __sfr __at (0xF29) UEP3;
typedef union {
	struct {
		unsigned EPSTALL   	: 1;
		unsigned EPINEN    	: 1;
		unsigned EPOUTEN   	: 1;
		unsigned EPCONDIS  	: 1;
		unsigned EPHSHK    	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
	};
} __UEP3bits_t;
extern volatile __UEP3bits_t __at (0xF29) UEP3bits;

extern __sfr __at (0xF2A) UEP4;
typedef union {
	struct {
		unsigned EPSTALL   	: 1;
		unsigned EPINEN    	: 1;
		unsigned EPOUTEN   	: 1;
		unsigned EPCONDIS  	: 1;
		unsigned EPHSHK    	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
	};
} __UEP4bits_t;
extern volatile __UEP4bits_t __at (0xF2A) UEP4bits;

extern __sfr __at (0xF2B) UEP5;
typedef union {
	struct {
		unsigned EPSTALL   	: 1;
		unsigned EPINEN    	: 1;
		unsigned EPOUTEN   	: 1;
		unsigned EPCONDIS  	: 1;
		unsigned EPHSHK    	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
	};
} __UEP5bits_t;
extern volatile __UEP5bits_t __at (0xF2B) UEP5bits;

extern __sfr __at (0xF2C) UEP6;
typedef union {
	struct {
		unsigned EPSTALL   	: 1;
		unsigned EPINEN    	: 1;
		unsigned EPOUTEN   	: 1;
		unsigned EPCONDIS  	: 1;
		unsigned EPHSHK    	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
	};
} __UEP6bits_t;
extern volatile __UEP6bits_t __at (0xF2C) UEP6bits;

extern __sfr __at (0xF2D) UEP7;
typedef union {
	struct {
		unsigned EPSTALL   	: 1;
		unsigned EPINEN    	: 1;
		unsigned EPOUTEN   	: 1;
		unsigned EPCONDIS  	: 1;
		unsigned EPHSHK    	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
	};
} __UEP7bits_t;
extern volatile __UEP7bits_t __at (0xF2D) UEP7bits;

extern __sfr __at (0xF2E) UEP8;
typedef union {
	struct {
		unsigned EPSTALL   	: 1;
		unsigned EPINEN    	: 1;
		unsigned EPOUTEN   	: 1;
		unsigned EPCONDIS  	: 1;
		unsigned EPHSHK    	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
	};
} __UEP8bits_t;
extern volatile __UEP8bits_t __at (0xF2E) UEP8bits;

extern __sfr __at (0xF2F) UEP9;
typedef union {
	struct {
		unsigned EPSTALL   	: 1;
		unsigned EPINEN    	: 1;
		unsigned EPOUTEN   	: 1;
		unsigned EPCONDIS  	: 1;
		unsigned EPHSHK    	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
	};
} __UEP9bits_t;
extern volatile __UEP9bits_t __at (0xF2F) UEP9bits;

extern __sfr __at (0xF30) UEP10;
typedef union {
	struct {
		unsigned EPSTALL   	: 1;
		unsigned EPINEN    	: 1;
		unsigned EPOUTEN   	: 1;
		unsigned EPCONDIS  	: 1;
		unsigned EPHSHK    	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
	};
} __UEP10bits_t;
extern volatile __UEP10bits_t __at (0xF30) UEP10bits;

extern __sfr __at (0xF31) UEP11;
typedef union {
	struct {
		unsigned EPSTALL   	: 1;
		unsigned EPINEN    	: 1;
		unsigned EPOUTEN   	: 1;
		unsigned EPCONDIS  	: 1;
		unsigned EPHSHK    	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
	};
} __UEP11bits_t;
extern volatile __UEP11bits_t __at (0xF31) UEP11bits;

extern __sfr __at (0xF32) UEP12;
typedef union {
	struct {
		unsigned EPSTALL   	: 1;
		unsigned EPINEN    	: 1;
		unsigned EPOUTEN   	: 1;
		unsigned EPCONDIS  	: 1;
		unsigned EPHSHK    	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
	};
} __UEP12bits_t;
extern volatile __UEP12bits_t __at (0xF32) UEP12bits;

extern __sfr __at (0xF33) UEP13;
typedef union {
	struct {
		unsigned EPSTALL   	: 1;
		unsigned EPINEN    	: 1;
		unsigned EPOUTEN   	: 1;
		unsigned EPCONDIS  	: 1;
		unsigned EPHSHK    	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
	};
} __UEP13bits_t;
extern volatile __UEP13bits_t __at (0xF33) UEP13bits;

extern __sfr __at (0xF34) UEP14;
typedef union {
	struct {
		unsigned EPSTALL   	: 1;
		unsigned EPINEN    	: 1;
		unsigned EPOUTEN   	: 1;
		unsigned EPCONDIS  	: 1;
		unsigned EPHSHK    	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
	};
} __UEP14bits_t;
extern volatile __UEP14bits_t __at (0xF34) UEP14bits;

extern __sfr __at (0xF35) UEP15;
typedef union {
	struct {
		unsigned EPSTALL   	: 1;
		unsigned EPINEN    	: 1;
		unsigned EPOUTEN   	: 1;
		unsigned EPCONDIS  	: 1;
		unsigned EPHSHK    	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
	};
} __UEP15bits_t;
extern volatile __UEP15bits_t __at (0xF35) UEP15bits;

extern __sfr __at (0xF36) UIE;
typedef union {
	struct {
		unsigned URSTIE    	: 1;
		unsigned UERRIE    	: 1;
		unsigned ACTVIE    	: 1;
		unsigned TRNIE     	: 1;
		unsigned IDLEIE    	: 1;
		unsigned STALLIE   	: 1;
		unsigned SOFIE     	: 1;
		unsigned           	: 1;
	};
} __UIEbits_t;
extern volatile __UIEbits_t __at (0xF36) UIEbits;

extern __sfr __at (0xF37) UEIE;
typedef union {
	struct {
		unsigned PIDEE     	: 1;
		unsigned CRC5EE    	: 1;
		unsigned CRC16EE   	: 1;
		unsigned DFN8EE    	: 1;
		unsigned BTOEE     	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned BTSEE     	: 1;
	};
} __UEIEbits_t;
extern volatile __UEIEbits_t __at (0xF37) UEIEbits;

extern __sfr __at (0xF38) UADDR;
typedef union {
	struct {
		unsigned ADDR0     	: 1;
		unsigned ADDR1     	: 1;
		unsigned ADDR2     	: 1;
		unsigned ADDR3     	: 1;
		unsigned ADDR4     	: 1;
		unsigned ADDR5     	: 1;
		unsigned ADDR6     	: 1;
		unsigned           	: 1;
	};
} __UADDRbits_t;
extern volatile __UADDRbits_t __at (0xF38) UADDRbits;

extern __sfr __at (0xF39) UCFG;
typedef union {
	struct {
		unsigned PPB0      	: 1;
		unsigned PPB1      	: 1;
		unsigned FSEN      	: 1;
		unsigned UTRDIS    	: 1;
		unsigned UPUEN     	: 1;
		unsigned           	: 1;
		unsigned UOEMON    	: 1;
		unsigned UTEYE     	: 1;
	};
} __UCFGbits_t;
extern volatile __UCFGbits_t __at (0xF39) UCFGbits;

extern __sfr __at (0xF3C) PADCFG1;
typedef union {
	struct {
		unsigned PMPTTL    	: 1;
		unsigned RTSECSEL0 	: 1;
		unsigned RTSECSEL1 	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
	};
} __PADCFG1bits_t;
extern volatile __PADCFG1bits_t __at (0xF3C) PADCFG1bits;

extern __sfr __at (0xF3D) REFOCON;
typedef union {
	struct {
		unsigned RODIV0    	: 1;
		unsigned RODIV1    	: 1;
		unsigned RODIV2    	: 1;
		unsigned RODIV3    	: 1;
		unsigned ROSEL     	: 1;
		unsigned ROSSLP    	: 1;
		unsigned           	: 1;
		unsigned ROON      	: 1;
	};
} __REFOCONbits_t;
extern volatile __REFOCONbits_t __at (0xF3D) REFOCONbits;

extern __sfr __at (0xF3E) RTCCAL;
typedef union {
	struct {
		unsigned CAL0      	: 1;
		unsigned CAL1      	: 1;
		unsigned CAL2      	: 1;
		unsigned CAL3      	: 1;
		unsigned CAL4      	: 1;
		unsigned CAL5      	: 1;
		unsigned CAL6      	: 1;
		unsigned CAL7      	: 1;
	};
} __RTCCALbits_t;
extern volatile __RTCCALbits_t __at (0xF3E) RTCCALbits;

extern __sfr __at (0xF3F) RTCCFG;
typedef union {
	struct {
		unsigned RTCPTR0   	: 1;
		unsigned RTCPTR1   	: 1;
		unsigned RTCOE     	: 1;
		unsigned HALFSEC   	: 1;
		unsigned RTCSYNC   	: 1;
		unsigned RTCWREN   	: 1;
		unsigned           	: 1;
		unsigned RTCEN     	: 1;
	};
} __RTCCFGbits_t;
extern volatile __RTCCFGbits_t __at (0xF3F) RTCCFGbits;

extern __sfr __at (0xF40) ODCON3;
typedef union {
	struct {
		unsigned SPI1OD    	: 1;
		unsigned SPI2OD    	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
	};
} __ODCON3bits_t;
extern volatile __ODCON3bits_t __at (0xF40) ODCON3bits;

extern __sfr __at (0xF41) ODCON2;
typedef union {
	struct {
		unsigned U1OD      	: 1;
		unsigned U2OD      	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
	};
} __ODCON2bits_t;
extern volatile __ODCON2bits_t __at (0xF41) ODCON2bits;

extern __sfr __at (0xF42) ODCON1;
typedef union {
	struct {
		unsigned ECCP1OD   	: 1;
		unsigned ECCP2OD   	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
	};
} __ODCON1bits_t;
extern volatile __ODCON1bits_t __at (0xF42) ODCON1bits;

extern __sfr __at (0xF48) ANCON0;
typedef union {
	struct {
		unsigned PCFG0     	: 1;
		unsigned PCFG1     	: 1;
		unsigned PCFG2     	: 1;
		unsigned PCFG3     	: 1;
		unsigned PCFG4     	: 1;
		unsigned PCFG5     	: 1;
		unsigned PCFG6     	: 1;
		unsigned PCFG7     	: 1;
	};
} __ANCON0bits_t;
extern volatile __ANCON0bits_t __at (0xF48) ANCON0bits;

extern __sfr __at (0xF49) ANCON1;
typedef union {
	struct {
		unsigned PCFG8     	: 1;
		unsigned PCFG9     	: 1;
		unsigned PCFG10    	: 1;
		unsigned PCFG11    	: 1;
		unsigned PCFG12    	: 1;
		unsigned           	: 1;
		unsigned VBG2EN    	: 1;
		unsigned VBGEN     	: 1;
	};
} __ANCON1bits_t;
extern volatile __ANCON1bits_t __at (0xF49) ANCON1bits;

extern __sfr __at (0xF4A) DSWAKEL;
typedef union {
	struct {
		unsigned DSPOR     	: 1;
		unsigned           	: 1;
		unsigned DSMCLR    	: 1;
		unsigned DSRTC     	: 1;
		unsigned DSWDT     	: 1;
		unsigned DSULP     	: 1;
		unsigned           	: 1;
		unsigned DSFLT     	: 1;
	};
} __DSWAKELbits_t;
extern volatile __DSWAKELbits_t __at (0xF4A) DSWAKELbits;

extern __sfr __at (0xF4B) DSWAKEH;
typedef union {
	struct {
		unsigned DSINT0    	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
	};
} __DSWAKEHbits_t;
extern volatile __DSWAKEHbits_t __at (0xF4B) DSWAKEHbits;

extern __sfr __at (0xF4C) DSCONL;
typedef union {
	struct {
		unsigned RELEASE   	: 1;
		unsigned DSBOR     	: 1;
		unsigned ULPWDIS   	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
	};
} __DSCONLbits_t;
extern volatile __DSCONLbits_t __at (0xF4C) DSCONLbits;

extern __sfr __at (0xF4D) DSCONH;
typedef union {
	struct {
		unsigned RTCWDIS   	: 1;
		unsigned DSULPEN   	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned DSEN      	: 1;
	};
} __DSCONHbits_t;
extern volatile __DSCONHbits_t __at (0xF4D) DSCONHbits;

extern __sfr __at (0xF4E) DSGPR0;

extern __sfr __at (0xF4F) DSGPR1;

extern __sfr __at (0xF52) TCLKCON;
typedef union {
	struct {
		unsigned T3CCP1    	: 1;
		unsigned T3CCP2    	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned T1RUN     	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
	};
} __TCLKCONbits_t;
extern volatile __TCLKCONbits_t __at (0xF52) TCLKCONbits;

extern __sfr __at (0xF53) CVRCON;
typedef union {
	struct {
		unsigned CVR0      	: 1;
		unsigned CVR1      	: 1;
		unsigned CVR2      	: 1;
		unsigned CVR3      	: 1;
		unsigned CVRSS     	: 1;
		unsigned CVRR      	: 1;
		unsigned CVROE     	: 1;
		unsigned CVREN     	: 1;
	};
} __CVRCONbits_t;
extern volatile __CVRCONbits_t __at (0xF53) CVRCONbits;

extern __sfr __at (0xF54) PMSTATL;
typedef union {
	struct {
		unsigned OB0E      	: 1;
		unsigned OB1E      	: 1;
		unsigned OB2E      	: 1;
		unsigned OB3E      	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned OBUF      	: 1;
		unsigned OBE       	: 1;
	};
} __PMSTATLbits_t;
extern volatile __PMSTATLbits_t __at (0xF54) PMSTATLbits;

extern __sfr __at (0xF55) PMSTATH;
typedef union {
	struct {
		unsigned IB0F      	: 1;
		unsigned IB1F      	: 1;
		unsigned IB2F      	: 1;
		unsigned IB3F      	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned IBOV      	: 1;
		unsigned IBF       	: 1;
	};
} __PMSTATHbits_t;
extern volatile __PMSTATHbits_t __at (0xF55) PMSTATHbits;

extern __sfr __at (0xF56) PMEL;
typedef union {
	struct {
		unsigned PTEN0     	: 1;
		unsigned PTEN1     	: 1;
		unsigned PTEN2     	: 1;
		unsigned PTEN3     	: 1;
		unsigned PTEN4     	: 1;
		unsigned PTEN5     	: 1;
		unsigned PTEN6     	: 1;
		unsigned PTEN7     	: 1;
	};
} __PMELbits_t;
extern volatile __PMELbits_t __at (0xF56) PMELbits;

extern __sfr __at (0xF57) PMEH;
typedef union {
	struct {
		unsigned PTEN8     	: 1;
		unsigned PTEN9     	: 1;
		unsigned PTEN10    	: 1;
		unsigned PTEN11    	: 1;
		unsigned PTEN12    	: 1;
		unsigned PTEN13    	: 1;
		unsigned PTEN14    	: 1;
		unsigned PTEN15    	: 1;
	};
} __PMEHbits_t;
extern volatile __PMEHbits_t __at (0xF57) PMEHbits;

extern __sfr __at (0xF58) PMDIN2L;

extern __sfr __at (0xF59) PMDIN2H;

extern __sfr __at (0xF5A) PMDOUT2L;

extern __sfr __at (0xF5B) PMDOUT2H;

extern __sfr __at (0xF5C) PMMODEL;
typedef union {
	struct {
		unsigned WAITE0    	: 1;
		unsigned WAITE1    	: 1;
		unsigned WAITM0    	: 1;
		unsigned WAITM1    	: 1;
		unsigned WAITM2    	: 1;
		unsigned WAITM3    	: 1;
		unsigned WAITB0    	: 1;
		unsigned WAITB1    	: 1;
	};
} __PMMODELbits_t;
extern volatile __PMMODELbits_t __at (0xF5C) PMMODELbits;

extern __sfr __at (0xF5D) PMMODEH;
typedef union {
	struct {
		unsigned MODE0     	: 1;
		unsigned MODE1     	: 1;
		unsigned MODE16    	: 1;
		unsigned INCM0     	: 1;
		unsigned INCM1     	: 1;
		unsigned IRQM0     	: 1;
		unsigned IRQM1     	: 1;
		unsigned BUSY      	: 1;
	};
} __PMMODEHbits_t;
extern volatile __PMMODEHbits_t __at (0xF5D) PMMODEHbits;

extern __sfr __at (0xF5E) PMCONL;
typedef union {
	struct {
		unsigned RDSP      	: 1;
		unsigned WRSP      	: 1;
		unsigned BEP       	: 1;
		unsigned CS1P      	: 1;
		unsigned CS2P      	: 1;
		unsigned ALP       	: 1;
		unsigned CSF0      	: 1;
		unsigned CSF1      	: 1;
	};
} __PMCONLbits_t;
extern volatile __PMCONLbits_t __at (0xF5E) PMCONLbits;

extern __sfr __at (0xF5F) PMCONH;
typedef union {
	struct {
		unsigned PTRDEN    	: 1;
		unsigned PTWREN    	: 1;
		unsigned PTBEEN    	: 1;
		unsigned ADRMUX0   	: 1;
		unsigned ADRMUX1   	: 1;
		unsigned PSIDL     	: 1;
		unsigned           	: 1;
		unsigned PMPEN     	: 1;
	};
} __PMCONHbits_t;
extern volatile __PMCONHbits_t __at (0xF5F) PMCONHbits;

extern __sfr __at (0xF60) UFRM;

extern __sfr __at (0xF60) UFRML;
typedef union {
	struct {
		unsigned FRM0      	: 1;
		unsigned FRM1      	: 1;
		unsigned FRM2      	: 1;
		unsigned FRM3      	: 1;
		unsigned FRM4      	: 1;
		unsigned FRM5      	: 1;
		unsigned FRM6      	: 1;
		unsigned FRM7      	: 1;
	};
} __UFRMLbits_t;
extern volatile __UFRMLbits_t __at (0xF60) UFRMLbits;

extern __sfr __at (0xF61) UFRMH;
typedef union {
	struct {
		unsigned FRM8      	: 1;
		unsigned FRM9      	: 1;
		unsigned FRM10     	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
	};
} __UFRMHbits_t;
extern volatile __UFRMHbits_t __at (0xF61) UFRMHbits;

extern __sfr __at (0xF62) UIR;
typedef union {
	struct {
		unsigned URSTIF    	: 1;
		unsigned UERRIF    	: 1;
		unsigned ACTVIF    	: 1;
		unsigned TRNIF     	: 1;
		unsigned IDLEIF    	: 1;
		unsigned STALLIF   	: 1;
		unsigned SOFIF     	: 1;
		unsigned           	: 1;
	};
} __UIRbits_t;
extern volatile __UIRbits_t __at (0xF62) UIRbits;

extern __sfr __at (0xF63) UEIR;
typedef union {
	struct {
		unsigned PIDEF     	: 1;
		unsigned CRC5EF    	: 1;
		unsigned CRC16EF   	: 1;
		unsigned DFN8EF    	: 1;
		unsigned BTOEF     	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned BTSEF     	: 1;
	};
} __UEIRbits_t;
extern volatile __UEIRbits_t __at (0xF63) UEIRbits;

extern __sfr __at (0xF64) USTAT;
typedef union {
	struct {
		unsigned           	: 1;
		unsigned PPBI      	: 1;
		unsigned DIR       	: 1;
		unsigned ENDP0     	: 1;
		unsigned ENDP1     	: 1;
		unsigned ENDP2     	: 1;
		unsigned ENDP3     	: 1;
		unsigned           	: 1;
	};
} __USTATbits_t;
extern volatile __USTATbits_t __at (0xF64) USTATbits;

extern __sfr __at (0xF65) UCON;
typedef union {
	struct {
		unsigned           	: 1;
		unsigned SUSPND    	: 1;
		unsigned RESUME    	: 1;
		unsigned USBEN     	: 1;
		unsigned PKTDIS    	: 1;
		unsigned SE0       	: 1;
		unsigned PPBRST    	: 1;
		unsigned           	: 1;
	};
} __UCONbits_t;
extern volatile __UCONbits_t __at (0xF65) UCONbits;

extern __sfr __at (0xF66) DMABCH;

extern __sfr __at (0xF67) DMABCL;

extern __sfr __at (0xF68) RXADDRH;

extern __sfr __at (0xF69) RXADDRL;

extern __sfr __at (0xF6A) TXADDRH;

extern __sfr __at (0xF6B) TXADDRL;

extern __sfr __at (0xF6C) PMDIN1L;

extern __sfr __at (0xF6D) PMDIN1H;

extern __sfr __at (0xF6E) PMADDRL;

extern __sfr __at (0xF6E) PMDOUT1L;

extern __sfr __at (0xF6F) PMADDRH;
typedef union {
	struct {
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned CS1       	: 1;
		unsigned           	: 1;
	};
} __PMADDRHbits_t;
extern volatile __PMADDRHbits_t __at (0xF6F) PMADDRHbits;

extern __sfr __at (0xF6F) PMDOUT1H;

extern __sfr __at (0xF70) CMSTAT;
typedef union {
	struct {
		unsigned COUT1     	: 1;
		unsigned COUT2     	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
	};
} __CMSTATbits_t;
extern volatile __CMSTATbits_t __at (0xF70) CMSTATbits;

extern __sfr __at (0xF70) CMSTATUS;
typedef union {
	struct {
		unsigned COUT1     	: 1;
		unsigned COUT2     	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
	};
} __CMSTATUSbits_t;
extern volatile __CMSTATUSbits_t __at (0xF70) CMSTATUSbits;

extern __sfr __at (0xF71) SSP2CON2;
typedef union {
	struct {
		unsigned SEN       	: 1;
		unsigned RSEN      	: 1;
		unsigned PEN       	: 1;
		unsigned RCEN      	: 1;
		unsigned ACKEN     	: 1;
		unsigned ACKDT     	: 1;
		unsigned ACKSTAT   	: 1;
		unsigned GCEN      	: 1;
	};
	struct {
		unsigned           	: 1;
		unsigned ADMSK1    	: 1;
		unsigned ADMSK2    	: 1;
		unsigned ADMSK3    	: 1;
		unsigned ADMSK4    	: 1;
		unsigned ADMSK5    	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
	};
} __SSP2CON2bits_t;
extern volatile __SSP2CON2bits_t __at (0xF71) SSP2CON2bits;

extern __sfr __at (0xF72) SSP2CON1;
typedef union {
	struct {
		unsigned SSPM0     	: 1;
		unsigned SSPM1     	: 1;
		unsigned SSPM2     	: 1;
		unsigned SSPM3     	: 1;
		unsigned CKP       	: 1;
		unsigned SSPEN     	: 1;
		unsigned SSPOV     	: 1;
		unsigned WCOL      	: 1;
	};
} __SSP2CON1bits_t;
extern volatile __SSP2CON1bits_t __at (0xF72) SSP2CON1bits;

extern __sfr __at (0xF73) SSP2STAT;
typedef union {
	struct {
		unsigned BF        	: 1;
		unsigned UA        	: 1;
		unsigned R_NOT_W   	: 1;
		unsigned S         	: 1;
		unsigned P         	: 1;
		unsigned D_NOT_A   	: 1;
		unsigned CKE       	: 1;
		unsigned SMP       	: 1;
	};
} __SSP2STATbits_t;
extern volatile __SSP2STATbits_t __at (0xF73) SSP2STATbits;

extern __sfr __at (0xF74) SSP2ADD;
typedef union {
	struct {
		unsigned MSK0      	: 1;
		unsigned MSK1      	: 1;
		unsigned MSK2      	: 1;
		unsigned MSK3      	: 1;
		unsigned MSK4      	: 1;
		unsigned MSK5      	: 1;
		unsigned MSK6      	: 1;
		unsigned MSK7      	: 1;
	};
} __SSP2ADDbits_t;
extern volatile __SSP2ADDbits_t __at (0xF74) SSP2ADDbits;

extern __sfr __at (0xF75) SSP2BUF;

extern __sfr __at (0xF76) T4CON;
typedef union {
	struct {
		unsigned T4CKPS0   	: 1;
		unsigned T4CKPS1   	: 1;
		unsigned TMR4ON    	: 1;
		unsigned T4OUTPS0  	: 1;
		unsigned T4OUTPS1  	: 1;
		unsigned T4OUTPS2  	: 1;
		unsigned T4OUTPS3  	: 1;
		unsigned           	: 1;
	};
} __T4CONbits_t;
extern volatile __T4CONbits_t __at (0xF76) T4CONbits;

extern __sfr __at (0xF77) PR4;

extern __sfr __at (0xF78) TMR4;

extern __sfr __at (0xF79) T3CON;
typedef union {
	struct {
		unsigned TMR3ON    	: 1;
		unsigned RD16      	: 1;
		unsigned T3SYNC    	: 1;
		unsigned           	: 1;
		unsigned T3CKPS0   	: 1;
		unsigned T3CKPS1   	: 1;
		unsigned TMR3CS0   	: 1;
		unsigned TMR3CS1   	: 1;
	};
} __T3CONbits_t;
extern volatile __T3CONbits_t __at (0xF79) T3CONbits;

extern __sfr __at (0xF7A) TMR3L;

extern __sfr __at (0xF7B) TMR3H;

extern __sfr __at (0xF7C) BAUDCON2;
typedef union {
	struct {
		unsigned ABDEN     	: 1;
		unsigned WUE       	: 1;
		unsigned           	: 1;
		unsigned BRG16     	: 1;
		unsigned TXCKP     	: 1;
		unsigned RXDTP     	: 1;
		unsigned RCIDL     	: 1;
		unsigned ABDOVF    	: 1;
	};
} __BAUDCON2bits_t;
extern volatile __BAUDCON2bits_t __at (0xF7C) BAUDCON2bits;

extern __sfr __at (0xF7D) SPBRGH2;

extern __sfr __at (0xF7E) BAUDCON;
typedef union {
	struct {
		unsigned ABDEN     	: 1;
		unsigned WUE       	: 1;
		unsigned           	: 1;
		unsigned BRG16     	: 1;
		unsigned TXCKP     	: 1;
		unsigned RXDTP     	: 1;
		unsigned RCIDL     	: 1;
		unsigned ABDOVF    	: 1;
	};
} __BAUDCONbits_t;
extern volatile __BAUDCONbits_t __at (0xF7E) BAUDCONbits;

extern __sfr __at (0xF7E) BAUDCON1;
typedef union {
	struct {
		unsigned ABDEN     	: 1;
		unsigned WUE       	: 1;
		unsigned           	: 1;
		unsigned BRG16     	: 1;
		unsigned TXCKP     	: 1;
		unsigned RXDTP     	: 1;
		unsigned RCIDL     	: 1;
		unsigned ABDOVF    	: 1;
	};
} __BAUDCON1bits_t;
extern volatile __BAUDCON1bits_t __at (0xF7E) BAUDCON1bits;

extern __sfr __at (0xF7E) BAUDCTL;
typedef union {
	struct {
		unsigned ABDEN     	: 1;
		unsigned WUE       	: 1;
		unsigned           	: 1;
		unsigned BRG16     	: 1;
		unsigned TXCKP     	: 1;
		unsigned RXDTP     	: 1;
		unsigned RCIDL     	: 1;
		unsigned ABDOVF    	: 1;
	};
} __BAUDCTLbits_t;
extern volatile __BAUDCTLbits_t __at (0xF7E) BAUDCTLbits;

extern __sfr __at (0xF7F) SPBRGH;

extern __sfr __at (0xF7F) SPBRGH1;

extern __sfr __at (0xF80) PORTA;
typedef union {
	struct {
		unsigned RA0       	: 1;
		unsigned RA1       	: 1;
		unsigned RA2       	: 1;
		unsigned RA3       	: 1;
		unsigned           	: 1;
		unsigned RA5       	: 1;
		unsigned RA6       	: 1;
		unsigned RA7       	: 1;
	};
	struct {
		unsigned AN0       	: 1;
		unsigned AN1       	: 1;
		unsigned AN2       	: 1;
		unsigned AN3       	: 1;
		unsigned           	: 1;
		unsigned AN4       	: 1;
		unsigned OSC2      	: 1;
		unsigned OSC1      	: 1;
	};
	struct {
		unsigned C1INA     	: 1;
		unsigned C2INA     	: 1;
		unsigned VREF_MINUS	: 1;
		unsigned VREF_PLUS 	: 1;
		unsigned           	: 1;
		unsigned NOT_SS1   	: 1;
		unsigned CLKO      	: 1;
		unsigned CLKI      	: 1;
	};
	struct {
		unsigned PMPA6     	: 1;
		unsigned PMPA7     	: 1;
		unsigned CVREF_MINUS	: 1;
		unsigned C1INB     	: 1;
		unsigned           	: 1;
		unsigned HLVDIN    	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
	};
	struct {
		unsigned RP0       	: 1;
		unsigned RP1       	: 1;
		unsigned C2INB     	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned RCV       	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
	};
	struct {
		unsigned ULPWU     	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned RP2       	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
	};
} __PORTAbits_t;
extern volatile __PORTAbits_t __at (0xF80) PORTAbits;

extern __sfr __at (0xF81) PORTB;
typedef union {
	struct {
		unsigned RB0       	: 1;
		unsigned RB1       	: 1;
		unsigned RB2       	: 1;
		unsigned RB3       	: 1;
		unsigned RB4       	: 1;
		unsigned RB5       	: 1;
		unsigned RB6       	: 1;
		unsigned RB7       	: 1;
	};
	struct {
		unsigned AN12      	: 1;
		unsigned AN10      	: 1;
		unsigned AN8       	: 1;
		unsigned AN9       	: 1;
		unsigned PMPA1     	: 1;
		unsigned PMPA0     	: 1;
		unsigned KBI2      	: 1;
		unsigned KBI3      	: 1;
	};
	struct {
		unsigned INT0      	: 1;
		unsigned PMPBE     	: 1;
		unsigned CTEDG1    	: 1;
		unsigned CTEDG2    	: 1;
		unsigned KBI0      	: 1;
		unsigned KBI1      	: 1;
		unsigned PGC       	: 1;
		unsigned PGD       	: 1;
	};
	struct {
		unsigned RP3       	: 1;
		unsigned RTCC      	: 1;
		unsigned PMPA3     	: 1;
		unsigned PMPA2     	: 1;
		unsigned SCK1      	: 1;
		unsigned SDI1      	: 1;
		unsigned RP9       	: 1;
		unsigned RP10      	: 1;
	};
	struct {
		unsigned           	: 1;
		unsigned RP4       	: 1;
		unsigned VMO       	: 1;
		unsigned VPO       	: 1;
		unsigned SCL1      	: 1;
		unsigned SDA1      	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
	};
	struct {
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned REFO      	: 1;
		unsigned RP6       	: 1;
		unsigned RP7       	: 1;
		unsigned RP8       	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
	};
	struct {
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned RP5       	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
	};
} __PORTBbits_t;
extern volatile __PORTBbits_t __at (0xF81) PORTBbits;

extern __sfr __at (0xF82) PORTC;
typedef union {
	struct {
		unsigned RC0       	: 1;
		unsigned RC1       	: 1;
		unsigned RC2       	: 1;
		unsigned           	: 1;
		unsigned RC4       	: 1;
		unsigned RC5       	: 1;
		unsigned RC6       	: 1;
		unsigned RC7       	: 1;
	};
	struct {
		unsigned T1OSO     	: 1;
		unsigned T1OSI     	: 1;
		unsigned AN11      	: 1;
		unsigned           	: 1;
		unsigned D_MINUS   	: 1;
		unsigned D_PLUS    	: 1;
		unsigned PMPA5     	: 1;
		unsigned PMPA4     	: 1;
	};
	struct {
		unsigned T1CK      	: 1;
		unsigned NOT_UOE   	: 1;
		unsigned CTPLS     	: 1;
		unsigned           	: 1;
		unsigned VM        	: 1;
		unsigned VP        	: 1;
		unsigned TX1       	: 1;
		unsigned RX1       	: 1;
	};
	struct {
		unsigned RP11      	: 1;
		unsigned RP12      	: 1;
		unsigned RP13      	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned CK1       	: 1;
		unsigned DT1       	: 1;
	};
	struct {
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned RP17      	: 1;
		unsigned SDO1      	: 1;
	};
	struct {
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned RP18      	: 1;
	};
} __PORTCbits_t;
extern volatile __PORTCbits_t __at (0xF82) PORTCbits;

extern __sfr __at (0xF83) PORTD;
typedef union {
	struct {
		unsigned RD0       	: 1;
		unsigned RD1       	: 1;
		unsigned RD2       	: 1;
		unsigned RD3       	: 1;
		unsigned RD4       	: 1;
		unsigned RD5       	: 1;
		unsigned RD6       	: 1;
		unsigned RD7       	: 1;
	};
	struct {
		unsigned PMPD0     	: 1;
		unsigned PMPD1     	: 1;
		unsigned PMPD2     	: 1;
		unsigned PMPD3     	: 1;
		unsigned PMPD4     	: 1;
		unsigned PMPD5     	: 1;
		unsigned PMPD6     	: 1;
		unsigned PMPD7     	: 1;
	};
	struct {
		unsigned SCL2      	: 1;
		unsigned SDA2      	: 1;
		unsigned RP19      	: 1;
		unsigned RP20      	: 1;
		unsigned RP21      	: 1;
		unsigned RP22      	: 1;
		unsigned RP23      	: 1;
		unsigned RP24      	: 1;
	};
} __PORTDbits_t;
extern volatile __PORTDbits_t __at (0xF83) PORTDbits;

extern __sfr __at (0xF84) PORTE;
typedef union {
	struct {
		unsigned RE0       	: 1;
		unsigned RE1       	: 1;
		unsigned RE2       	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned REPU      	: 1;
		unsigned RDPU      	: 1;
	};
	struct {
		unsigned AN5       	: 1;
		unsigned AN6       	: 1;
		unsigned AN7       	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
	};
	struct {
		unsigned PMPRD     	: 1;
		unsigned PMPWR     	: 1;
		unsigned PMPCS     	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
	};
} __PORTEbits_t;
extern volatile __PORTEbits_t __at (0xF84) PORTEbits;

extern __sfr __at (0xF85) HLVDCON;
typedef union {
	struct {
		unsigned HLVDL0    	: 1;
		unsigned HLVDL1    	: 1;
		unsigned HLVDL2    	: 1;
		unsigned HLVDL3    	: 1;
		unsigned HLVDEN    	: 1;
		unsigned IRVST     	: 1;
		unsigned BGVST     	: 1;
		unsigned VDIRMAG   	: 1;
	};
} __HLVDCONbits_t;
extern volatile __HLVDCONbits_t __at (0xF85) HLVDCONbits;

extern __sfr __at (0xF86) DMACON2;
typedef union {
	struct {
		unsigned INTLVL0   	: 1;
		unsigned INTLVL1   	: 1;
		unsigned INTLVL2   	: 1;
		unsigned INTLVL3   	: 1;
		unsigned DLYCYC0   	: 1;
		unsigned DLYCYC1   	: 1;
		unsigned DLYCYC2   	: 1;
		unsigned DLYCYC3   	: 1;
	};
} __DMACON2bits_t;
extern volatile __DMACON2bits_t __at (0xF86) DMACON2bits;

extern __sfr __at (0xF88) DMACON1;
typedef union {
	struct {
		unsigned DMAEN     	: 1;
		unsigned DLYINTEN  	: 1;
		unsigned DUPLEX0   	: 1;
		unsigned DUPLEX1   	: 1;
		unsigned RXINC     	: 1;
		unsigned TXINC     	: 1;
		unsigned SSCON0    	: 1;
		unsigned SSCON1    	: 1;
	};
} __DMACON1bits_t;
extern volatile __DMACON1bits_t __at (0xF88) DMACON1bits;

extern __sfr __at (0xF89) LATA;
typedef union {
	struct {
		unsigned LATA0     	: 1;
		unsigned LATA1     	: 1;
		unsigned LATA2     	: 1;
		unsigned LATA3     	: 1;
		unsigned           	: 1;
		unsigned LATA5     	: 1;
		unsigned LATA6     	: 1;
		unsigned LATA7     	: 1;
	};
} __LATAbits_t;
extern volatile __LATAbits_t __at (0xF89) LATAbits;

extern __sfr __at (0xF8A) LATB;
typedef union {
	struct {
		unsigned LATB0     	: 1;
		unsigned LATB1     	: 1;
		unsigned LATB2     	: 1;
		unsigned LATB3     	: 1;
		unsigned LATB4     	: 1;
		unsigned LATB5     	: 1;
		unsigned LATB6     	: 1;
		unsigned LATB7     	: 1;
	};
} __LATBbits_t;
extern volatile __LATBbits_t __at (0xF8A) LATBbits;

extern __sfr __at (0xF8B) LATC;
typedef union {
	struct {
		unsigned LATC0     	: 1;
		unsigned LATC1     	: 1;
		unsigned LATC2     	: 1;
		unsigned           	: 1;
		unsigned LATC4     	: 1;
		unsigned LATC5     	: 1;
		unsigned LATC6     	: 1;
		unsigned LATC7     	: 1;
	};
} __LATCbits_t;
extern volatile __LATCbits_t __at (0xF8B) LATCbits;

extern __sfr __at (0xF8C) LATD;
typedef union {
	struct {
		unsigned LATD0     	: 1;
		unsigned LATD1     	: 1;
		unsigned LATD2     	: 1;
		unsigned LATD3     	: 1;
		unsigned LATD4     	: 1;
		unsigned LATD5     	: 1;
		unsigned LATD6     	: 1;
		unsigned LATD7     	: 1;
	};
} __LATDbits_t;
extern volatile __LATDbits_t __at (0xF8C) LATDbits;

extern __sfr __at (0xF8D) LATE;
typedef union {
	struct {
		unsigned LATE0     	: 1;
		unsigned LATE1     	: 1;
		unsigned LATE2     	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
	};
} __LATEbits_t;
extern volatile __LATEbits_t __at (0xF8D) LATEbits;

extern __sfr __at (0xF8E) ALRMVALL;

extern __sfr __at (0xF8F) ALRMVALH;

extern __sfr __at (0xF90) ALRMRPT;
typedef union {
	struct {
		unsigned ARPT0     	: 1;
		unsigned ARPT1     	: 1;
		unsigned ARPT2     	: 1;
		unsigned ARPT3     	: 1;
		unsigned ARPT4     	: 1;
		unsigned ARPT5     	: 1;
		unsigned ARPT6     	: 1;
		unsigned ARPT7     	: 1;
	};
} __ALRMRPTbits_t;
extern volatile __ALRMRPTbits_t __at (0xF90) ALRMRPTbits;

extern __sfr __at (0xF91) ALRMCFG;
typedef union {
	struct {
		unsigned ALRMPTR0  	: 1;
		unsigned ALRMPTR1  	: 1;
		unsigned AMASK0    	: 1;
		unsigned AMASK1    	: 1;
		unsigned AMASK2    	: 1;
		unsigned AMASK3    	: 1;
		unsigned CHIME     	: 1;
		unsigned ALRMEN    	: 1;
	};
} __ALRMCFGbits_t;
extern volatile __ALRMCFGbits_t __at (0xF91) ALRMCFGbits;

extern __sfr __at (0xF92) TRISA;
typedef union {
	struct {
		unsigned TRISA0    	: 1;
		unsigned TRISA1    	: 1;
		unsigned TRISA2    	: 1;
		unsigned TRISA3    	: 1;
		unsigned           	: 1;
		unsigned TRISA5    	: 1;
		unsigned TRISA6    	: 1;
		unsigned TRISA7    	: 1;
	};
} __TRISAbits_t;
extern volatile __TRISAbits_t __at (0xF92) TRISAbits;

extern __sfr __at (0xF93) TRISB;
typedef union {
	struct {
		unsigned TRISB0    	: 1;
		unsigned TRISB1    	: 1;
		unsigned TRISB2    	: 1;
		unsigned TRISB3    	: 1;
		unsigned TRISB4    	: 1;
		unsigned TRISB5    	: 1;
		unsigned TRISB6    	: 1;
		unsigned TRISB7    	: 1;
	};
} __TRISBbits_t;
extern volatile __TRISBbits_t __at (0xF93) TRISBbits;

extern __sfr __at (0xF94) TRISC;
typedef union {
	struct {
		unsigned TRISC0    	: 1;
		unsigned TRISC1    	: 1;
		unsigned TRISC2    	: 1;
		unsigned           	: 1;
		unsigned TRISC4    	: 1;
		unsigned TRISC5    	: 1;
		unsigned TRISC6    	: 1;
		unsigned TRISC7    	: 1;
	};
} __TRISCbits_t;
extern volatile __TRISCbits_t __at (0xF94) TRISCbits;

extern __sfr __at (0xF95) TRISD;
typedef union {
	struct {
		unsigned TRISD0    	: 1;
		unsigned TRISD1    	: 1;
		unsigned TRISD2    	: 1;
		unsigned TRISD3    	: 1;
		unsigned TRISD4    	: 1;
		unsigned TRISD5    	: 1;
		unsigned TRISD6    	: 1;
		unsigned TRISD7    	: 1;
	};
} __TRISDbits_t;
extern volatile __TRISDbits_t __at (0xF95) TRISDbits;

extern __sfr __at (0xF96) TRISE;
typedef union {
	struct {
		unsigned TRISE0    	: 1;
		unsigned TRISE1    	: 1;
		unsigned TRISE2    	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
	};
} __TRISEbits_t;
extern volatile __TRISEbits_t __at (0xF96) TRISEbits;

extern __sfr __at (0xF97) T3GCON;
typedef union {
	struct {
		unsigned T3GSS0    	: 1;
		unsigned T3GSS1    	: 1;
		unsigned T3GVAL    	: 1;
		unsigned T3GGO_T3DONE	: 1;
		unsigned T3GSPM    	: 1;
		unsigned T3GTM     	: 1;
		unsigned T3GPOL    	: 1;
		unsigned TMR3GE    	: 1;
	};
	struct {
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned T3GGO     	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
	};
	struct {
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned T3DONE    	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
	};
} __T3GCONbits_t;
extern volatile __T3GCONbits_t __at (0xF97) T3GCONbits;

extern __sfr __at (0xF98) RTCVALL;

extern __sfr __at (0xF99) RTCVALH;

extern __sfr __at (0xF9A) T1GCON;
typedef union {
	struct {
		unsigned T1GSS0    	: 1;
		unsigned T1GSS1    	: 1;
		unsigned T1GVAL    	: 1;
		unsigned T1GGO_T1DONE	: 1;
		unsigned T1GSPM    	: 1;
		unsigned T1GTM     	: 1;
		unsigned T1GPOL    	: 1;
		unsigned TMR1GE    	: 1;
	};
	struct {
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned T1GGO     	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
	};
	struct {
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned T1DONE    	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
	};
} __T1GCONbits_t;
extern volatile __T1GCONbits_t __at (0xF9A) T1GCONbits;

extern __sfr __at (0xF9B) OSCTUNE;
typedef union {
	struct {
		unsigned TUN0      	: 1;
		unsigned TUN1      	: 1;
		unsigned TUN2      	: 1;
		unsigned TUN3      	: 1;
		unsigned TUN4      	: 1;
		unsigned TUN5      	: 1;
		unsigned PLLEN     	: 1;
		unsigned INTSRC    	: 1;
	};
} __OSCTUNEbits_t;
extern volatile __OSCTUNEbits_t __at (0xF9B) OSCTUNEbits;

extern __sfr __at (0xF9C) RCSTA2;
typedef union {
	struct {
		unsigned RX9D      	: 1;
		unsigned OERR      	: 1;
		unsigned FERR      	: 1;
		unsigned ADDEN     	: 1;
		unsigned CREN      	: 1;
		unsigned SREN      	: 1;
		unsigned RX9       	: 1;
		unsigned SPEN      	: 1;
	};
} __RCSTA2bits_t;
extern volatile __RCSTA2bits_t __at (0xF9C) RCSTA2bits;

extern __sfr __at (0xF9D) PIE1;
typedef union {
	struct {
		unsigned TMR1IE    	: 1;
		unsigned TMR2IE    	: 1;
		unsigned CCP1IE    	: 1;
		unsigned SSP1IE    	: 1;
		unsigned TX1IE     	: 1;
		unsigned RC1IE     	: 1;
		unsigned ADIE      	: 1;
		unsigned PMPIE     	: 1;
	};
	struct {
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned SSPIE     	: 1;
		unsigned TXIE      	: 1;
		unsigned RCIE      	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
	};
} __PIE1bits_t;
extern volatile __PIE1bits_t __at (0xF9D) PIE1bits;

extern __sfr __at (0xF9E) PIR1;
typedef union {
	struct {
		unsigned TMR1IF    	: 1;
		unsigned TMR2IF    	: 1;
		unsigned CCP1IF    	: 1;
		unsigned SSP1IF    	: 1;
		unsigned TX1IF     	: 1;
		unsigned RC1IF     	: 1;
		unsigned ADIF      	: 1;
		unsigned PMPIF     	: 1;
	};
	struct {
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned SSPIF     	: 1;
		unsigned TXIF      	: 1;
		unsigned RCIF      	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
	};
} __PIR1bits_t;
extern volatile __PIR1bits_t __at (0xF9E) PIR1bits;

extern __sfr __at (0xF9F) IPR1;
typedef union {
	struct {
		unsigned TMR1IP    	: 1;
		unsigned TMR2IP    	: 1;
		unsigned CCP1IP    	: 1;
		unsigned SSP1IP    	: 1;
		unsigned TX1IP     	: 1;
		unsigned RC1IP     	: 1;
		unsigned ADIP      	: 1;
		unsigned PMPIP     	: 1;
	};
	struct {
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned SSPIP     	: 1;
		unsigned TXIP      	: 1;
		unsigned RCIP      	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
	};
} __IPR1bits_t;
extern volatile __IPR1bits_t __at (0xF9F) IPR1bits;

extern __sfr __at (0xFA0) PIE2;
typedef union {
	struct {
		unsigned CCP2IE    	: 1;
		unsigned TMR3IE    	: 1;
		unsigned LVDIE     	: 1;
		unsigned BCL1IE    	: 1;
		unsigned USBIE     	: 1;
		unsigned CM1IE     	: 1;
		unsigned CM2IE     	: 1;
		unsigned OSCFIE    	: 1;
	};
	struct {
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned BCLIE     	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
	};
} __PIE2bits_t;
extern volatile __PIE2bits_t __at (0xFA0) PIE2bits;

extern __sfr __at (0xFA1) PIR2;
typedef union {
	struct {
		unsigned CCP2IF    	: 1;
		unsigned TMR3IF    	: 1;
		unsigned LVDIF     	: 1;
		unsigned BCL1IF    	: 1;
		unsigned USBIF     	: 1;
		unsigned CM1IF     	: 1;
		unsigned CM2IF     	: 1;
		unsigned OSCFIF    	: 1;
	};
	struct {
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned BCLIF     	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
	};
} __PIR2bits_t;
extern volatile __PIR2bits_t __at (0xFA1) PIR2bits;

extern __sfr __at (0xFA2) IPR2;
typedef union {
	struct {
		unsigned CCP2IP    	: 1;
		unsigned TMR3IP    	: 1;
		unsigned LVDIP     	: 1;
		unsigned BCL1IP    	: 1;
		unsigned USBIP     	: 1;
		unsigned CM1IP     	: 1;
		unsigned CM2IP     	: 1;
		unsigned OSCFIP    	: 1;
	};
	struct {
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned BCLIP     	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
	};
} __IPR2bits_t;
extern volatile __IPR2bits_t __at (0xFA2) IPR2bits;

extern __sfr __at (0xFA3) PIE3;
typedef union {
	struct {
		unsigned RTCCIE    	: 1;
		unsigned TMR3GIE   	: 1;
		unsigned CTMUIE    	: 1;
		unsigned TMR4IE    	: 1;
		unsigned TX2IE     	: 1;
		unsigned RC2IE     	: 1;
		unsigned BCL2IE    	: 1;
		unsigned SSP2IE    	: 1;
	};
} __PIE3bits_t;
extern volatile __PIE3bits_t __at (0xFA3) PIE3bits;

extern __sfr __at (0xFA4) PIR3;
typedef union {
	struct {
		unsigned RTCCIF    	: 1;
		unsigned TMR3GIF   	: 1;
		unsigned CTMUIF    	: 1;
		unsigned TMR4IF    	: 1;
		unsigned TX2IF     	: 1;
		unsigned RC2IF     	: 1;
		unsigned BCL2IF    	: 1;
		unsigned SSP2IF    	: 1;
	};
} __PIR3bits_t;
extern volatile __PIR3bits_t __at (0xFA4) PIR3bits;

extern __sfr __at (0xFA5) IPR3;
typedef union {
	struct {
		unsigned RTCCIP    	: 1;
		unsigned TMR3GIP   	: 1;
		unsigned CTMUIP    	: 1;
		unsigned TMR4IP    	: 1;
		unsigned TX2IP     	: 1;
		unsigned RC2IP     	: 1;
		unsigned BCL2IP    	: 1;
		unsigned SSP2IP    	: 1;
	};
} __IPR3bits_t;
extern volatile __IPR3bits_t __at (0xFA5) IPR3bits;

extern __sfr __at (0xFA6) EECON1;
typedef union {
	struct {
		unsigned           	: 1;
		unsigned WR        	: 1;
		unsigned WREN      	: 1;
		unsigned WRERR     	: 1;
		unsigned FREE      	: 1;
		unsigned WPROG     	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
	};
} __EECON1bits_t;
extern volatile __EECON1bits_t __at (0xFA6) EECON1bits;

extern __sfr __at (0xFA7) EECON2;

extern __sfr __at (0xFA8) TXSTA2;
typedef union {
	struct {
		unsigned TX9D      	: 1;
		unsigned TRMT      	: 1;
		unsigned BRGH      	: 1;
		unsigned SENDB     	: 1;
		unsigned SYNC      	: 1;
		unsigned TXEN      	: 1;
		unsigned TX9       	: 1;
		unsigned CSRC      	: 1;
	};
} __TXSTA2bits_t;
extern volatile __TXSTA2bits_t __at (0xFA8) TXSTA2bits;

extern __sfr __at (0xFA9) TXREG2;

extern __sfr __at (0xFAA) RCREG2;

extern __sfr __at (0xFAB) SPBRG2;

extern __sfr __at (0xFAC) RCSTA;
typedef union {
	struct {
		unsigned RX9D      	: 1;
		unsigned OERR      	: 1;
		unsigned FERR      	: 1;
		unsigned ADDEN     	: 1;
		unsigned CREN      	: 1;
		unsigned SREN      	: 1;
		unsigned RX9       	: 1;
		unsigned SPEN      	: 1;
	};
	struct {
		unsigned RCD8      	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned ADEN      	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned RC9       	: 1;
		unsigned           	: 1;
	};
	struct {
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned NOT_RC8   	: 1;
		unsigned           	: 1;
	};
	struct {
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned RC8_9     	: 1;
		unsigned           	: 1;
	};
} __RCSTAbits_t;
extern volatile __RCSTAbits_t __at (0xFAC) RCSTAbits;

extern __sfr __at (0xFAC) RCSTA1;
typedef union {
	struct {
		unsigned RX9D      	: 1;
		unsigned OERR      	: 1;
		unsigned FERR      	: 1;
		unsigned ADDEN     	: 1;
		unsigned CREN      	: 1;
		unsigned SREN      	: 1;
		unsigned RX9       	: 1;
		unsigned SPEN      	: 1;
	};
	struct {
		unsigned RCD8      	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned ADEN      	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned RC9       	: 1;
		unsigned           	: 1;
	};
	struct {
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned NOT_RC8   	: 1;
		unsigned           	: 1;
	};
	struct {
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned RC8_9     	: 1;
		unsigned           	: 1;
	};
} __RCSTA1bits_t;
extern volatile __RCSTA1bits_t __at (0xFAC) RCSTA1bits;

extern __sfr __at (0xFAD) TXSTA;
typedef union {
	struct {
		unsigned TX9D      	: 1;
		unsigned TRMT      	: 1;
		unsigned BRGH      	: 1;
		unsigned SENDB     	: 1;
		unsigned SYNC      	: 1;
		unsigned TXEN      	: 1;
		unsigned TX9       	: 1;
		unsigned CSRC      	: 1;
	};
	struct {
		unsigned TXD8      	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned TX8_9     	: 1;
		unsigned           	: 1;
	};
	struct {
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned NOT_TX8   	: 1;
		unsigned           	: 1;
	};
} __TXSTAbits_t;
extern volatile __TXSTAbits_t __at (0xFAD) TXSTAbits;

extern __sfr __at (0xFAD) TXSTA1;
typedef union {
	struct {
		unsigned TX9D      	: 1;
		unsigned TRMT      	: 1;
		unsigned BRGH      	: 1;
		unsigned SENDB     	: 1;
		unsigned SYNC      	: 1;
		unsigned TXEN      	: 1;
		unsigned TX9       	: 1;
		unsigned CSRC      	: 1;
	};
	struct {
		unsigned TXD8      	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned TX8_9     	: 1;
		unsigned           	: 1;
	};
	struct {
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned NOT_TX8   	: 1;
		unsigned           	: 1;
	};
} __TXSTA1bits_t;
extern volatile __TXSTA1bits_t __at (0xFAD) TXSTA1bits;

extern __sfr __at (0xFAE) TXREG;

extern __sfr __at (0xFAE) TXREG1;

extern __sfr __at (0xFAF) RCREG;

extern __sfr __at (0xFAF) RCREG1;

extern __sfr __at (0xFB0) SPBRG;

extern __sfr __at (0xFB0) SPBRG1;

extern __sfr __at (0xFB1) CTMUICON;
typedef union {
	struct {
		unsigned IRNG0     	: 1;
		unsigned IRNG1     	: 1;
		unsigned ITRIM0    	: 1;
		unsigned ITRIM1    	: 1;
		unsigned ITRIM2    	: 1;
		unsigned ITRIM3    	: 1;
		unsigned ITRIM4    	: 1;
		unsigned ITRIM5    	: 1;
	};
} __CTMUICONbits_t;
extern volatile __CTMUICONbits_t __at (0xFB1) CTMUICONbits;

extern __sfr __at (0xFB2) CTMUCONL;
typedef union {
	struct {
		unsigned EDG1STAT  	: 1;
		unsigned EDG2STAT  	: 1;
		unsigned EDG1SEL0  	: 1;
		unsigned EDG1SEL1  	: 1;
		unsigned EDG1POL   	: 1;
		unsigned EDG2SEL0  	: 1;
		unsigned EDG2SEL1  	: 1;
		unsigned EDG2POL   	: 1;
	};
} __CTMUCONLbits_t;
extern volatile __CTMUCONLbits_t __at (0xFB2) CTMUCONLbits;

extern __sfr __at (0xFB3) CTMUCONH;
typedef union {
	struct {
		unsigned CTTRIG    	: 1;
		unsigned IDISSEN   	: 1;
		unsigned EDGSEQEN  	: 1;
		unsigned EDGEN     	: 1;
		unsigned TGEN      	: 1;
		unsigned CTMUSIDL  	: 1;
		unsigned           	: 1;
		unsigned CTMUEN    	: 1;
	};
} __CTMUCONHbits_t;
extern volatile __CTMUCONHbits_t __at (0xFB3) CTMUCONHbits;

extern __sfr __at (0xFB4) CCP2CON;
typedef union {
	struct {
		unsigned CCP2M0    	: 1;
		unsigned CCP2M1    	: 1;
		unsigned CCP2M2    	: 1;
		unsigned CCP2M3    	: 1;
		unsigned DC2B0     	: 1;
		unsigned DC2B1     	: 1;
		unsigned P2M0      	: 1;
		unsigned P2M1      	: 1;
	};
	struct {
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned CCP2Y     	: 1;
		unsigned CCP2X     	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
	};
} __CCP2CONbits_t;
extern volatile __CCP2CONbits_t __at (0xFB4) CCP2CONbits;

extern __sfr __at (0xFB4) ECCP2CON;
typedef union {
	struct {
		unsigned CCP2M0    	: 1;
		unsigned CCP2M1    	: 1;
		unsigned CCP2M2    	: 1;
		unsigned CCP2M3    	: 1;
		unsigned DC2B0     	: 1;
		unsigned DC2B1     	: 1;
		unsigned P2M0      	: 1;
		unsigned P2M1      	: 1;
	};
	struct {
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned CCP2Y     	: 1;
		unsigned CCP2X     	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
	};
} __ECCP2CONbits_t;
extern volatile __ECCP2CONbits_t __at (0xFB4) ECCP2CONbits;

extern __sfr __at (0xFB5) CCPR2;

extern __sfr __at (0xFB5) CCPR2L;

extern __sfr __at (0xFB6) CCPR2H;

extern __sfr __at (0xFB7) ECCP2DEL;
typedef union {
	struct {
		unsigned P2DC0     	: 1;
		unsigned P2DC1     	: 1;
		unsigned P2DC2     	: 1;
		unsigned P2DC3     	: 1;
		unsigned P2DC4     	: 1;
		unsigned P2DC5     	: 1;
		unsigned P2DC6     	: 1;
		unsigned P2RSEN    	: 1;
	};
} __ECCP2DELbits_t;
extern volatile __ECCP2DELbits_t __at (0xFB7) ECCP2DELbits;

extern __sfr __at (0xFB7) PWM2CON;
typedef union {
	struct {
		unsigned P2DC0     	: 1;
		unsigned P2DC1     	: 1;
		unsigned P2DC2     	: 1;
		unsigned P2DC3     	: 1;
		unsigned P2DC4     	: 1;
		unsigned P2DC5     	: 1;
		unsigned P2DC6     	: 1;
		unsigned P2RSEN    	: 1;
	};
} __PWM2CONbits_t;
extern volatile __PWM2CONbits_t __at (0xFB7) PWM2CONbits;

extern __sfr __at (0xFB8) ECCP2AS;
typedef union {
	struct {
		unsigned PSS2BD0   	: 1;
		unsigned PSS2BD1   	: 1;
		unsigned PSS2AC0   	: 1;
		unsigned PSS2AC1   	: 1;
		unsigned ECCP2AS0  	: 1;
		unsigned ECCP2AS1  	: 1;
		unsigned ECCP2AS2  	: 1;
		unsigned ECCP2ASE  	: 1;
	};
} __ECCP2ASbits_t;
extern volatile __ECCP2ASbits_t __at (0xFB8) ECCP2ASbits;

extern __sfr __at (0xFB9) PSTR2CON;
typedef union {
	struct {
		unsigned STRA      	: 1;
		unsigned STRB      	: 1;
		unsigned STRC      	: 1;
		unsigned STRD      	: 1;
		unsigned STRSYNC   	: 1;
		unsigned P2DC5     	: 1;
		unsigned CMPL0     	: 1;
		unsigned CMPL1     	: 1;
	};
	struct {
		unsigned P2DC0     	: 1;
		unsigned P2DC1     	: 1;
		unsigned P2DC2     	: 1;
		unsigned P2DC3     	: 1;
		unsigned P2DC4     	: 1;
		unsigned           	: 1;
		unsigned P2DC6     	: 1;
		unsigned           	: 1;
	};
} __PSTR2CONbits_t;
extern volatile __PSTR2CONbits_t __at (0xFB9) PSTR2CONbits;

extern __sfr __at (0xFBA) CCP1CON;
typedef union {
	struct {
		unsigned CCP1M0    	: 1;
		unsigned CCP1M1    	: 1;
		unsigned CCP1M2    	: 1;
		unsigned CCP1M3    	: 1;
		unsigned DC1B0     	: 1;
		unsigned DC1B1     	: 1;
		unsigned P1M0      	: 1;
		unsigned P1M1      	: 1;
	};
	struct {
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned CCP1Y     	: 1;
		unsigned CCP1X     	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
	};
} __CCP1CONbits_t;
extern volatile __CCP1CONbits_t __at (0xFBA) CCP1CONbits;

extern __sfr __at (0xFBA) ECCP1CON;
typedef union {
	struct {
		unsigned CCP1M0    	: 1;
		unsigned CCP1M1    	: 1;
		unsigned CCP1M2    	: 1;
		unsigned CCP1M3    	: 1;
		unsigned DC1B0     	: 1;
		unsigned DC1B1     	: 1;
		unsigned P1M0      	: 1;
		unsigned P1M1      	: 1;
	};
	struct {
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned CCP1Y     	: 1;
		unsigned CCP1X     	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
	};
} __ECCP1CONbits_t;
extern volatile __ECCP1CONbits_t __at (0xFBA) ECCP1CONbits;

extern __sfr __at (0xFBB) CCPR1;

extern __sfr __at (0xFBB) CCPR1L;

extern __sfr __at (0xFBC) CCPR1H;

extern __sfr __at (0xFBD) ECCP1DEL;
typedef union {
	struct {
		unsigned P1DC0     	: 1;
		unsigned P1DC1     	: 1;
		unsigned P1DC2     	: 1;
		unsigned P1DC3     	: 1;
		unsigned P1DC4     	: 1;
		unsigned P1DC5     	: 1;
		unsigned P1DC6     	: 1;
		unsigned P1RSEN    	: 1;
	};
} __ECCP1DELbits_t;
extern volatile __ECCP1DELbits_t __at (0xFBD) ECCP1DELbits;

extern __sfr __at (0xFBD) PWM1CON;
typedef union {
	struct {
		unsigned P1DC0     	: 1;
		unsigned P1DC1     	: 1;
		unsigned P1DC2     	: 1;
		unsigned P1DC3     	: 1;
		unsigned P1DC4     	: 1;
		unsigned P1DC5     	: 1;
		unsigned P1DC6     	: 1;
		unsigned P1RSEN    	: 1;
	};
} __PWM1CONbits_t;
extern volatile __PWM1CONbits_t __at (0xFBD) PWM1CONbits;

extern __sfr __at (0xFBE) ECCP1AS;
typedef union {
	struct {
		unsigned PSS1BD0   	: 1;
		unsigned PSS1BD1   	: 1;
		unsigned PSS1AC0   	: 1;
		unsigned PSS1AC1   	: 1;
		unsigned ECCP1AS0  	: 1;
		unsigned ECCP1AS1  	: 1;
		unsigned ECCP1AS2  	: 1;
		unsigned ECCP1ASE  	: 1;
	};
} __ECCP1ASbits_t;
extern volatile __ECCP1ASbits_t __at (0xFBE) ECCP1ASbits;

extern __sfr __at (0xFBF) PSTR1CON;
typedef union {
	struct {
		unsigned STRA      	: 1;
		unsigned STRB      	: 1;
		unsigned STRC      	: 1;
		unsigned STRD      	: 1;
		unsigned STRSYNC   	: 1;
		unsigned           	: 1;
		unsigned CMPL0     	: 1;
		unsigned CMPL1     	: 1;
	};
} __PSTR1CONbits_t;
extern volatile __PSTR1CONbits_t __at (0xFBF) PSTR1CONbits;

extern __sfr __at (0xFC0) WDTCON;
typedef union {
	struct {
		unsigned SWDTEN    	: 1;
		unsigned ULPSINK   	: 1;
		unsigned ULPEN     	: 1;
		unsigned DS        	: 1;
		unsigned           	: 1;
		unsigned ULPLVL    	: 1;
		unsigned LVDSTAT   	: 1;
		unsigned REGSLP    	: 1;
	};
	struct {
		unsigned SWDTE     	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
	};
} __WDTCONbits_t;
extern volatile __WDTCONbits_t __at (0xFC0) WDTCONbits;

extern __sfr __at (0xFC1) ADCON1;
typedef union {
	struct {
		unsigned ADCS0     	: 1;
		unsigned ADCS1     	: 1;
		unsigned ADCS2     	: 1;
		unsigned ACQT0     	: 1;
		unsigned ACQT1     	: 1;
		unsigned ACQT2     	: 1;
		unsigned ADCAL     	: 1;
		unsigned ADFM      	: 1;
	};
} __ADCON1bits_t;
extern volatile __ADCON1bits_t __at (0xFC1) ADCON1bits;

extern __sfr __at (0xFC2) ADCON0;
typedef union {
	struct {
		unsigned ADON      	: 1;
		unsigned GO_NOT_DONE	: 1;
		unsigned CHS0      	: 1;
		unsigned CHS1      	: 1;
		unsigned CHS2      	: 1;
		unsigned CHS3      	: 1;
		unsigned VCFG0     	: 1;
		unsigned VCFG1     	: 1;
	};
	struct {
		unsigned           	: 1;
		unsigned GO_DONE   	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
	};
	struct {
		unsigned           	: 1;
		unsigned DONE      	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
	};
	struct {
		unsigned           	: 1;
		unsigned GO        	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
	};
	struct {
		unsigned           	: 1;
		unsigned NOT_DONE  	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
	};
} __ADCON0bits_t;
extern volatile __ADCON0bits_t __at (0xFC2) ADCON0bits;

extern __sfr __at (0xFC3) ADRES;

extern __sfr __at (0xFC3) ADRESL;

extern __sfr __at (0xFC4) ADRESH;

extern __sfr __at (0xFC5) SSP1CON2;
typedef union {
	struct {
		unsigned SEN       	: 1;
		unsigned RSEN      	: 1;
		unsigned PEN       	: 1;
		unsigned RCEN      	: 1;
		unsigned ACKEN     	: 1;
		unsigned ACKDT     	: 1;
		unsigned ACKSTAT   	: 1;
		unsigned GCEN      	: 1;
	};
	struct {
		unsigned           	: 1;
		unsigned ADMSK1    	: 1;
		unsigned ADMSK2    	: 1;
		unsigned ADMSK3    	: 1;
		unsigned ADMSK4    	: 1;
		unsigned ADMSK5    	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
	};
} __SSP1CON2bits_t;
extern volatile __SSP1CON2bits_t __at (0xFC5) SSP1CON2bits;

extern __sfr __at (0xFC5) SSPCON2;
typedef union {
	struct {
		unsigned SEN       	: 1;
		unsigned RSEN      	: 1;
		unsigned PEN       	: 1;
		unsigned RCEN      	: 1;
		unsigned ACKEN     	: 1;
		unsigned ACKDT     	: 1;
		unsigned ACKSTAT   	: 1;
		unsigned GCEN      	: 1;
	};
	struct {
		unsigned           	: 1;
		unsigned ADMSK1    	: 1;
		unsigned ADMSK2    	: 1;
		unsigned ADMSK3    	: 1;
		unsigned ADMSK4    	: 1;
		unsigned ADMSK5    	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
	};
} __SSPCON2bits_t;
extern volatile __SSPCON2bits_t __at (0xFC5) SSPCON2bits;

extern __sfr __at (0xFC6) SSP1CON1;
typedef union {
	struct {
		unsigned SSPM0     	: 1;
		unsigned SSPM1     	: 1;
		unsigned SSPM2     	: 1;
		unsigned SSPM3     	: 1;
		unsigned CKP       	: 1;
		unsigned SSPEN     	: 1;
		unsigned SSPOV     	: 1;
		unsigned WCOL      	: 1;
	};
} __SSP1CON1bits_t;
extern volatile __SSP1CON1bits_t __at (0xFC6) SSP1CON1bits;

extern __sfr __at (0xFC6) SSPCON1;
typedef union {
	struct {
		unsigned SSPM0     	: 1;
		unsigned SSPM1     	: 1;
		unsigned SSPM2     	: 1;
		unsigned SSPM3     	: 1;
		unsigned CKP       	: 1;
		unsigned SSPEN     	: 1;
		unsigned SSPOV     	: 1;
		unsigned WCOL      	: 1;
	};
} __SSPCON1bits_t;
extern volatile __SSPCON1bits_t __at (0xFC6) SSPCON1bits;

extern __sfr __at (0xFC7) SSP1STAT;
typedef union {
	struct {
		unsigned BF        	: 1;
		unsigned UA        	: 1;
		unsigned R_NOT_W   	: 1;
		unsigned S         	: 1;
		unsigned P         	: 1;
		unsigned D_NOT_A   	: 1;
		unsigned CKE       	: 1;
		unsigned SMP       	: 1;
	};
	struct {
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned R         	: 1;
		unsigned I2C_START 	: 1;
		unsigned I2C_STOP  	: 1;
		unsigned D         	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
	};
	struct {
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned R_W       	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned D_A       	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
	};
	struct {
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned NOT_W     	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned NOT_A     	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
	};
	struct {
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned NOT_WRITE 	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned NOT_ADDRESS	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
	};
	struct {
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned READ_WRITE	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned DATA_ADDRESS	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
	};
	struct {
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned I2C_READ  	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned I2C_DAT   	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
	};
} __SSP1STATbits_t;
extern volatile __SSP1STATbits_t __at (0xFC7) SSP1STATbits;

extern __sfr __at (0xFC7) SSPSTAT;
typedef union {
	struct {
		unsigned BF        	: 1;
		unsigned UA        	: 1;
		unsigned R_NOT_W   	: 1;
		unsigned S         	: 1;
		unsigned P         	: 1;
		unsigned D_NOT_A   	: 1;
		unsigned CKE       	: 1;
		unsigned SMP       	: 1;
	};
	struct {
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned R         	: 1;
		unsigned I2C_START 	: 1;
		unsigned I2C_STOP  	: 1;
		unsigned D         	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
	};
	struct {
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned R_W       	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned D_A       	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
	};
	struct {
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned NOT_W     	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned NOT_A     	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
	};
	struct {
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned NOT_WRITE 	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned NOT_ADDRESS	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
	};
	struct {
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned READ_WRITE	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned DATA_ADDRESS	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
	};
	struct {
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned I2C_READ  	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned I2C_DAT   	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
	};
} __SSPSTATbits_t;
extern volatile __SSPSTATbits_t __at (0xFC7) SSPSTATbits;

extern __sfr __at (0xFC8) SSP1ADD;
typedef union {
	struct {
		unsigned MSK0      	: 1;
		unsigned MSK1      	: 1;
		unsigned MSK2      	: 1;
		unsigned MSK3      	: 1;
		unsigned MSK4      	: 1;
		unsigned MSK5      	: 1;
		unsigned MSK6      	: 1;
		unsigned MSK7      	: 1;
	};
} __SSP1ADDbits_t;
extern volatile __SSP1ADDbits_t __at (0xFC8) SSP1ADDbits;

extern __sfr __at (0xFC8) SSPADD;
typedef union {
	struct {
		unsigned MSK0      	: 1;
		unsigned MSK1      	: 1;
		unsigned MSK2      	: 1;
		unsigned MSK3      	: 1;
		unsigned MSK4      	: 1;
		unsigned MSK5      	: 1;
		unsigned MSK6      	: 1;
		unsigned MSK7      	: 1;
	};
} __SSPADDbits_t;
extern volatile __SSPADDbits_t __at (0xFC8) SSPADDbits;

extern __sfr __at (0xFC9) SSP1BUF;

extern __sfr __at (0xFC9) SSPBUF;

extern __sfr __at (0xFCA) T2CON;
typedef union {
	struct {
		unsigned T2CKPS0   	: 1;
		unsigned T2CKPS1   	: 1;
		unsigned TMR2ON    	: 1;
		unsigned T2OUTPS0  	: 1;
		unsigned T2OUTPS1  	: 1;
		unsigned T2OUTPS2  	: 1;
		unsigned T2OUTPS3  	: 1;
		unsigned           	: 1;
	};
} __T2CONbits_t;
extern volatile __T2CONbits_t __at (0xFCA) T2CONbits;

extern __sfr __at (0xFCB) PR2;

extern __sfr __at (0xFCC) TMR2;

extern __sfr __at (0xFCD) T1CON;
typedef union {
	struct {
		unsigned TMR1ON    	: 1;
		unsigned RD16      	: 1;
		unsigned T1SYNC    	: 1;
		unsigned T1OSCEN   	: 1;
		unsigned T1CKPS0   	: 1;
		unsigned T1CKPS1   	: 1;
		unsigned TMR1CS0   	: 1;
		unsigned TMR1CS1   	: 1;
	};
} __T1CONbits_t;
extern volatile __T1CONbits_t __at (0xFCD) T1CONbits;

extern __sfr __at (0xFCE) TMR1L;

extern __sfr __at (0xFCF) TMR1H;

extern __sfr __at (0xFD0) RCON;
typedef union {
	struct {
		unsigned NOT_BOR   	: 1;
		unsigned NOT_POR   	: 1;
		unsigned NOT_PD    	: 1;
		unsigned NOT_TO    	: 1;
		unsigned NOT_RI    	: 1;
		unsigned NOT_CM    	: 1;
		unsigned           	: 1;
		unsigned IPEN      	: 1;
	};
	struct {
		unsigned BOR       	: 1;
		unsigned POR       	: 1;
		unsigned PD        	: 1;
		unsigned TO        	: 1;
		unsigned RI        	: 1;
		unsigned CM        	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
	};
} __RCONbits_t;
extern volatile __RCONbits_t __at (0xFD0) RCONbits;

extern __sfr __at (0xFD1) CM2CON;
typedef union {
	struct {
		unsigned CCH0      	: 1;
		unsigned CCH1      	: 1;
		unsigned CREF      	: 1;
		unsigned EVPOL0    	: 1;
		unsigned EVPOL1    	: 1;
		unsigned CPOL      	: 1;
		unsigned COE       	: 1;
		unsigned CON       	: 1;
	};
} __CM2CONbits_t;
extern volatile __CM2CONbits_t __at (0xFD1) CM2CONbits;

extern __sfr __at (0xFD1) CM2CON1;
typedef union {
	struct {
		unsigned CCH0      	: 1;
		unsigned CCH1      	: 1;
		unsigned CREF      	: 1;
		unsigned EVPOL0    	: 1;
		unsigned EVPOL1    	: 1;
		unsigned CPOL      	: 1;
		unsigned COE       	: 1;
		unsigned CON       	: 1;
	};
} __CM2CON1bits_t;
extern volatile __CM2CON1bits_t __at (0xFD1) CM2CON1bits;

extern __sfr __at (0xFD2) CM1CON;
typedef union {
	struct {
		unsigned CCH0      	: 1;
		unsigned CCH1      	: 1;
		unsigned CREF      	: 1;
		unsigned EVPOL0    	: 1;
		unsigned EVPOL1    	: 1;
		unsigned CPOL      	: 1;
		unsigned COE       	: 1;
		unsigned CON       	: 1;
	};
} __CM1CONbits_t;
extern volatile __CM1CONbits_t __at (0xFD2) CM1CONbits;

extern __sfr __at (0xFD2) CM1CON1;
typedef union {
	struct {
		unsigned CCH0      	: 1;
		unsigned CCH1      	: 1;
		unsigned CREF      	: 1;
		unsigned EVPOL0    	: 1;
		unsigned EVPOL1    	: 1;
		unsigned CPOL      	: 1;
		unsigned COE       	: 1;
		unsigned CON       	: 1;
	};
} __CM1CON1bits_t;
extern volatile __CM1CON1bits_t __at (0xFD2) CM1CON1bits;

extern __sfr __at (0xFD3) OSCCON;
typedef union {
	struct {
		unsigned SCS0      	: 1;
		unsigned SCS1      	: 1;
		unsigned           	: 1;
		unsigned OSTS      	: 1;
		unsigned IRCF0     	: 1;
		unsigned IRCF1     	: 1;
		unsigned IRCF2     	: 1;
		unsigned IDLEN     	: 1;
	};
} __OSCCONbits_t;
extern volatile __OSCCONbits_t __at (0xFD3) OSCCONbits;

extern __sfr __at (0xFD5) T0CON;
typedef union {
	struct {
		unsigned T0PS0     	: 1;
		unsigned T0PS1     	: 1;
		unsigned T0PS2     	: 1;
		unsigned PSA       	: 1;
		unsigned T0SE      	: 1;
		unsigned T0CS      	: 1;
		unsigned T08BIT    	: 1;
		unsigned TMR0ON    	: 1;
	};
} __T0CONbits_t;
extern volatile __T0CONbits_t __at (0xFD5) T0CONbits;

extern __sfr __at (0xFD6) TMR0L;

extern __sfr __at (0xFD7) TMR0H;

extern __sfr __at (0xFD8) STATUS;
typedef union {
	struct {
		unsigned C         	: 1;
		unsigned DC        	: 1;
		unsigned Z         	: 1;
		unsigned OV        	: 1;
		unsigned N         	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
	};
} __STATUSbits_t;
extern volatile __STATUSbits_t __at (0xFD8) STATUSbits;

extern __sfr __at (0xFD9) FSR2L;

extern __sfr __at (0xFDA) FSR2H;

extern __sfr __at (0xFDB) PLUSW2;

extern __sfr __at (0xFDC) PREINC2;

extern __sfr __at (0xFDD) POSTDEC2;

extern __sfr __at (0xFDE) POSTINC2;

extern __sfr __at (0xFDF) INDF2;

extern __sfr __at (0xFE0) BSR;

extern __sfr __at (0xFE1) FSR1L;

extern __sfr __at (0xFE2) FSR1H;

extern __sfr __at (0xFE3) PLUSW1;

extern __sfr __at (0xFE4) PREINC1;

extern __sfr __at (0xFE5) POSTDEC1;

extern __sfr __at (0xFE6) POSTINC1;

extern __sfr __at (0xFE7) INDF1;

extern __sfr __at (0xFE8) WREG;

extern __sfr __at (0xFE9) FSR0L;

extern __sfr __at (0xFEA) FSR0H;

extern __sfr __at (0xFEB) PLUSW0;

extern __sfr __at (0xFEC) PREINC0;

extern __sfr __at (0xFED) POSTDEC0;

extern __sfr __at (0xFEE) POSTINC0;

extern __sfr __at (0xFEF) INDF0;

extern __sfr __at (0xFF0) INTCON3;
typedef union {
	struct {
		unsigned INT1IF    	: 1;
		unsigned INT2IF    	: 1;
		unsigned INT3IF    	: 1;
		unsigned INT1IE    	: 1;
		unsigned INT2IE    	: 1;
		unsigned INT3IE    	: 1;
		unsigned INT1IP    	: 1;
		unsigned INT2IP    	: 1;
	};
	struct {
		unsigned INT1F     	: 1;
		unsigned INT2F     	: 1;
		unsigned INT3F     	: 1;
		unsigned INT1E     	: 1;
		unsigned INT2E     	: 1;
		unsigned INT3E     	: 1;
		unsigned INT1P     	: 1;
		unsigned INT2P     	: 1;
	};
} __INTCON3bits_t;
extern volatile __INTCON3bits_t __at (0xFF0) INTCON3bits;

extern __sfr __at (0xFF1) INTCON2;
typedef union {
	struct {
		unsigned RBIP      	: 1;
		unsigned INT3IP    	: 1;
		unsigned TMR0IP    	: 1;
		unsigned INTEDG3   	: 1;
		unsigned INTEDG2   	: 1;
		unsigned INTEDG1   	: 1;
		unsigned INTEDG0   	: 1;
		unsigned NOT_RBPU  	: 1;
	};
	struct {
		unsigned           	: 1;
		unsigned INT3P     	: 1;
		unsigned T0IP      	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned RBPU      	: 1;
	};
} __INTCON2bits_t;
extern volatile __INTCON2bits_t __at (0xFF1) INTCON2bits;

extern __sfr __at (0xFF2) INTCON;
typedef union {
	struct {
		unsigned RBIF      	: 1;
		unsigned INT0IF    	: 1;
		unsigned TMR0IF    	: 1;
		unsigned RBIE      	: 1;
		unsigned INT0IE    	: 1;
		unsigned TMR0IE    	: 1;
		unsigned PEIE_GIEL 	: 1;
		unsigned GIE_GIEH  	: 1;
	};
	struct {
		unsigned           	: 1;
		unsigned INT0F     	: 1;
		unsigned T0IF      	: 1;
		unsigned           	: 1;
		unsigned INT0E     	: 1;
		unsigned T0IE      	: 1;
		unsigned PEIE      	: 1;
		unsigned GIE       	: 1;
	};
	struct {
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned GIEL      	: 1;
		unsigned GIEH      	: 1;
	};
} __INTCONbits_t;
extern volatile __INTCONbits_t __at (0xFF2) INTCONbits;

extern __sfr __at (0xFF3) PROD;

extern __sfr __at (0xFF3) PRODL;

extern __sfr __at (0xFF4) PRODH;

extern __sfr __at (0xFF5) TABLAT;

extern __sfr __at (0xFF6) TBLPTR;

extern __sfr __at (0xFF6) TBLPTRL;

extern __sfr __at (0xFF7) TBLPTRH;

extern __sfr __at (0xFF8) TBLPTRU;

extern __sfr __at (0xFF9) PC;

extern __sfr __at (0xFF9) PCL;

extern __sfr __at (0xFFA) PCLATH;

extern __sfr __at (0xFFB) PCLATU;

extern __sfr __at (0xFFC) STKPTR;
typedef union {
	struct {
		unsigned SP0       	: 1;
		unsigned SP1       	: 1;
		unsigned SP2       	: 1;
		unsigned SP3       	: 1;
		unsigned SP4       	: 1;
		unsigned           	: 1;
		unsigned STKUNF    	: 1;
		unsigned STKFUL    	: 1;
	};
} __STKPTRbits_t;
extern volatile __STKPTRbits_t __at (0xFFC) STKPTRbits;

extern __sfr __at (0xFFD) TOS;

extern __sfr __at (0xFFD) TOSL;

extern __sfr __at (0xFFE) TOSH;

extern __sfr __at (0xFFF) TOSU;


#endif

