; SLIDE SHOW SAMPLE - ZX7 FORMAT
; COLECOVISION, 2016
;
; Idea by Paulo Silva, Portugal
; Coded by Daniel Bienvenu, Canada
; ZX7 compression by Einar Saukas, Brazil
;
; COMPILE WITH TNIASM
; 	> TNIASM filename.asm

fname "sshowzx7.rom"

; CONSTANTS

NMI_FLAG:	equ	$7000

; PROGRAM

	cpu	z80
	
	; COLECO ROM CARTRIDGE $8000-$FFFF
	org	$8000
	
	; COLECO ROM HEADER
	dw	$55AA

	; COLECO BIOS RESERVED RAM ADDRESSES
	dw	0,0,0,0
	
	; POINTER TO ROM CODE ENTRY POINT
	dw	start
	
	; RST ROUTINES
	; RST 08
	ret
	nop
	nop
	; RST 10
	ret
	nop
	nop
	; RST 18
	ret
	nop
	nop
	; RST 20
	ret
	nop
	nop
	; RST 28
	ret
	nop
	nop
	; RST 30
	ret
	nop
	nop
	; RST 38 ; SPINNER
	ret
	nop
	nop	
	
	; JUMP TO NON MASKABLE ROUTINE
	jp	nmi
	
	; COLECO SCREEN DATA : TITLE/AUTHOR/YEAR
	db "SLIDE SHOW SAMPLE IN ZX7/PRESENTS/2016"

	; NON MASKABLE INTERUPT
nmi:
	push	af
	ld		a, 1
	ld		(NMI_FLAG),a	; SET NMI FLAG
	call		$1FDC		; in a, ($BF)
	pop		af
	ret

start:
	; INTERUPT MODE = RST $38
	im		1
	; DISABLE INTETUPT
	di
	
	; CLEAR RAM 7000-73B7
	xor		a
	ld		bc, $03B8
	ld		hl, $7000
	ld		de, $7001
	ld		(hl), a
	ldir
	
	; TURN SOUND OFF
	call		$1FD6

	; CLEAR VRAM 0000-3FFF
	ld		de, $4000
	xor		a
	ld		l,a
	ld		h,a
	call		$1f82
	
	; SCREEN OFF, NMI OFF
	ld		bc, $0182		; vdp_out(1,$82)
	call		$1FD9
	; SET GRAPHIC MODE II
	ld		bc, $0002		; vdp_out(0,2) ; MODE 2
	call		$1FD9
	ld		a, 2
	ld		hl, $1800
	call		$1FB8		; vdp_out(2,ADDR($1800)) ; NAME $1800
	ld		bc, $03FF         ; vdp_out(3,$ff) ; PATTERN $0000
	call		$1FD9
	ld		bc, $0403         ; vdp_out(4,$03) ; COLOR $2000
	call		$1FD9
	ld		de, $1800
	call		default_name_table

	; SLiDE SHOW LOOP
slideshow:
	ld		hl, awblp2
	push	hl
	ld		hl, awblp1
	call		slide
	ld		hl, f1spp2
	push	hl
	ld		hl, f1spp1
	call		slide
	ld		hl, h6exp2
	push	hl
	ld		hl, h6exp1
	call		slide
	ld		hl, mgfap2
	push	hl
	ld		hl, mgfap1
	call		slide
	ld		hl, sotbp2
	push	hl
	ld		hl, sotbp1
	call		slide
	; TODO : SLIDE SHOW
	jp slideshow

slide:
	call		nmioff
	ld		de, $0000
	call		zx7
	pop		bc
	pop		hl
	push	bc
	ld		de, $2000
	call		zx7
	call		nmion
	ld		b, 100 ; (approx 2 seconds)
	call		delay
	jp		clear

;	DE = NAME TABLE VRAM ADDRESS
default_name_table:
	call		vdpwrite
	ld		d, 3
default_name_table_1:
	xor		a
default_name_table_2:
	out		($BE), a
	nop
	inc		a
	jp		nz,default_name_table_2
	dec		d
	jp		nz,default_name_table_1
	ret

; VDPWRITE
;	INPUT
;		DE = VRAM ADDRESS
;	DESTROY
;		C
vdpwrite:
	ld		c, $BF
	out		(c), e
	set		6, d
	out		(c), d
	res		6, d
	ret
	
nmioff:
	ld		bc, $01C2
	jp		$1FD9

nmion:
	ld		bc, $01E2
	jp		$1FD9

; DELAY
;	INPUT
;		B = DELAY TIME IN SCREEN REFRESH CYCLES
;	DESTROY
;		A, B
delay:
	xor		a
	ld		(NMI_FLAG),a
delay_loop:
	ld		a,(NMI_FLAG)
	or		a
	jr		z, delay_loop
	djnz		delay

clear:
	xor		a
	ld		hl, $2000 ; COLOR VRAM ADDR
	ld		de, $1800 ; SIZE
	call		$1f82 ; FILL_VRAM
	ld		hl, $0000 ; PATTERN VRAM ADDR
	ld		de, $1800 ; SIZE
	jp		$1f82 ; FILL_VRAM
	
; ZX7 - DECOMPRESSION ROUTINE
zx7:
	; Set Write in VRAM at DE
	call		vdpwrite	
	ld		a, $80

; copy literal byte
zx7_copy_byte_loop:
	ld		c, $be
	outi
	inc		de
zx7_main_loop:
	call		getbit                    ; check next bit
	jr		nc, zx7_copy_byte_loop

; determine number of bits used for length (Elias gamma coding)
        push	de
        ld		bc, $0001
        ld		d, b
zx7_len_size_loop:
        inc		d
	call		getbit                    ; check next bit
	jr		nc, zx7_len_size_loop
        jr		zx7_len_value_start

zx7_len_value_loop:
        call		getbit                    ; check next bit
        rl		c
        rl		b
        jr		c, zx7_exit           ; check end marker
zx7_len_value_start:
        dec		d
        jr		nz, zx7_len_value_loop
        inc		bc                      ; adjust length

; determine offset
        ld		e, (hl)                 ; load offset flag (1 bit) + offset value (7 bits)
        inc		hl
        db	$cb, $33                ; opcode for undocumented instruction "SLL E" aka "SLS E"
        jr		nc, zx7_offset_end    ; if offset flag is set, load 4 extra bits
        call		getbit                    ; check next bit
        rl		d                       ; insert first bit into D
        call		getbit                    ; check next bit
        rl		d                       ; insert second bit into D
        call		getbit                    ; check next bit
        rl		d                       ; insert third bit into D
        call		getbit                    ; check next bit
        ccf
        jr		c, zx7_offset_end
        inc		d                       ; equivalent to adding 128??? to DE   ??? NO!
zx7_offset_end:
        rr		e                       ; insert inverted fourth bit into E

; copy previous sequence
        ex		(sp), hl                ; store source, restore destination
        push	hl                      ; store destination
        sbc		hl, de                  ; HL = source = destination - offset - 1
        pop		de                      ; DE = destination
	; BC = count
	; COPY BYTES
	ex		af, af'
	set		6, d
zx7_copybytes_loop:
	push	bc
	ld		c, $BF
	out		(c), l
	nop
	out		(c), h
	inc		hl
	nop
	nop
	in		a, ($BE)
	nop
	nop
	nop
	out		(c), e
	nop
	out		(c), d
	inc		de
	nop
	nop
	out		($BE), a
	pop		bc
	dec		bc
	ld		a, b
	or		c
	jr		nz, zx7_copybytes_loop
	res		6, d
	ex		af, af'
zx7_exit:	
	pop		hl                      ; restore source address (compressed data)
        jp		nc, zx7_main_loop
	ret
	
getbit:
	add		a, a
  	ret		nz
	ld		a, (hl)
	inc		hl
	rla
	ret

; DATA

awblp1:
	incbin	"awblp1.zx7"
awblp2:
	incbin	"awblp2.zx7"
f1spp1:
	incbin	"f1spp1.zx7"
f1spp2:
	incbin	"f1spp2.zx7"
h6exp1:
	incbin	"h6exp1.zx7"
h6exp2:
	incbin	"h6exp2.zx7"
mgfap1:
	incbin	"mgfap1.zx7"
mgfap2:
	incbin	"mgfap2.zx7"
sotbp1:
	incbin	"sotbp1.zx7"
sotbp2:
	incbin	"sotbp2.zx7"
