; SLIDE SHOW SAMPLE - dan3 FORMAT
; COLECOVISION, 2016
;
; Idea by Paulo Silva, Portugal
; Coded by Daniel Bienvenu, Canada
; dan3 compression by Daniel Bienvenu, Canada
;
; COMPILE WITH TNIASM
; 	> TNIASM filename.asm

fname "sshowdan3s2.rom"

; CONSTANTS

NMI_FLAG:	equ	$7000

; PROGRAM

	cpu	z80
	
	; COLECO ROM CARTRIDGE $8000-$FFFF
	org	$8000
	
	; COLECO ROM HEADER
	;dw	$AA55 ; NO TITLE SCREEN
	dw	$55AA

	; COLECO BIOS RESERVED RAM ADDRESSES
	dw	0,0,0,0
	
	; POINTER TO ROM CODE ENTRY POINT
	dw	start
	
	; RST ROUTINES
	; RST 08
	ret
	nop
	nop
	; RST 10
	ret
	nop
	nop
	; RST 18
	ret
	nop
	nop
	; RST 20
	ret
	nop
	nop
	; RST 28
	ret
	nop
	nop
	; RST 30
	ret
	nop
	nop
	; RST 38 ; SPINNER
	ret
	nop
	nop	
	
	; JUMP TO NON MASKABLE ROUTINE
	jp	nmi
	
	; COLECO SCREEN DATA : TITLE/AUTHOR/YEAR
	db "SLIDE SHOW SAMPLE IN DAN3/PRESENTS/2017"

	; NON MASKABLE INTERUPT
nmi:
	push	af
	ld		a, 1
	ld		(NMI_FLAG),a	; SET NMI FLAG
	call		$1FDC		; in a, ($BF)
	pop		af
	ret

start:
	; INTERUPT MODE = RST $38
	im		1
	; DISABLE INTETUPT
	di
	
	; CLEAR RAM 7000-73B7
	xor		a
	ld		bc, $03B8
	ld		hl, $7000
	ld		de, $7001
	ld		(hl), a
	ldir
	
	; TURN SOUND OFF
	call		$1FD6

	; CLEAR VRAM 0000-3FFF
	ld		de, $4000
	xor		a
	ld		l,a
	ld		h,a
	call		$1f82
	
	; SCREEN OFF, NMI OFF
	ld		bc, $0182		; vdp_out(1,$82)
	call		$1FD9
	; SET GRAPHIC MODE II
	ld		bc, $0002		; vdp_out(0,2) ; MODE 2
	call		$1FD9
	ld		a, 2
	ld		hl, $1800
	call		$1FB8		; vdp_out(2,ADDR($1800)) ; NAME $1800
	ld		bc, $03FF         ; vdp_out(3,$ff) ; PATTERN $0000
	call		$1FD9
	ld		bc, $0403         ; vdp_out(4,$03) ; COLOR $2000
	call		$1FD9
	ld		de, $1800
	call		default_name_table

	; SLiDE SHOW LOOP
slideshow:
	ld		hl, awblp2
	push	hl
	ld		hl, awblp1
	call		slide
	ld		hl, f1spp2
	push	hl
	ld		hl, f1spp1
	call		slide
	ld		hl, h6exp2
	push	hl
	ld		hl, h6exp1
	call		slide
	ld		hl, mgfap2
	push	hl
	ld		hl, mgfap1
	call		slide
	ld		hl, sotbp2
	push	hl
	ld		hl, sotbp1
	call		slide
	; TODO : SLIDE SHOW
	jp slideshow

slide:
	call		nmioff
	ld		de, $0000
	call		dan3
	pop		bc
	pop		hl
	push	bc
	ld		de, $2000
	call		dan3
	call		nmion
	ld		b, 100 ; (approx 2 seconds)
	call		delay
	jp		clear

;	DE = NAME TABLE VRAM ADDRESS
default_name_table:
	call		vdpwrite
	ld		d, 3
default_name_table_1:
	xor		a
default_name_table_2:
	out		($BE), a
	nop
	inc		a
	jp		nz,default_name_table_2
	dec		d
	jp		nz,default_name_table_1
	ret

; VDPWRITE
;	INPUT
;		DE = VRAM ADDRESS
;	DESTROY
;		C
vdpwrite:
	ld		c, $BF
	out		(c), e
	set		6, d
	out		(c), d
	res		6, d
	ret
	
nmioff:
	ld		bc, $01C2
	jp		$1FD9

nmion:
	ld		bc, $01E2
	jp		$1FD9

; DELAY
;	INPUT
;		B = DELAY TIME IN SCREEN REFRESH CYCLES
;	DESTROY
;		A, B
delay:
	xor		a
	ld		(NMI_FLAG),a
delay_loop:
	ld		a,(NMI_FLAG)
	or		a
	jr		z, delay_loop
	djnz		delay

clear:
	xor		a
	ld		hl, $2000 ; COLOR VRAM ADDR
	ld		de, $1800 ; SIZE
	call		$1f82 ; FILL_VRAM
	ld		hl, $0000 ; PATTERN VRAM ADDR
	ld		de, $1800 ; SIZE
	jp		$1f82 ; FILL_VRAM
	
; dan3 - DECOMPRESSION ROUTINE
dan3:
	; Set Write in VRAM at DE
	call		vdpwrite	
	ld		a, $80
	
	push	ix
	ld	ix, getbite+3
dan3_offsetsize_loop:
	dec	ix
	dec	ix
	dec	ix
	call	getbit
	jr	c,dan3_offsetsize_loop
	
; Copy literal byte
dan3_copy_byte:
	ld	b,1

dan3_literal2main:
	ld		c, $BE
dan3_literals_loop:
	outi
;	inc		b
	inc		de
	jr	nz, dan3_literals_loop

; Main loop
dan3_main_loop:
	call		getbit                    ; check next bit
	jr		c,dan3_copy_byte
	
; ExpGolomb  decoding + Special marker
        push	de
        ld		de, $0001
        ld		b,e
dan3_expgolomb_0:
        inc		b
	call		getbit			; check next bit
	jr		c, dan3_expgolomb_value
	bit		3,b
	jr		z, dan3_expgolomb_0
	
	pop	de
	call	getbit
	jr	c, dan3_manyliterals
	pop	ix
	ret	; EXIT
dan3_manyliterals:
	ld      b, (hl)                 ; load counter value (8 bits)
	inc	hl
	inc	b
	jr	dan3_literal2main

dan3_expgolomb_value:
		dec	b
		;	b = 1 to 7
dan3_expgolomb_value_loop:
		call	getbite			; check next bit -> DE
		djnz	dan3_expgolomb_value_loop
		dec	e

	push	de
	pop		bc			; BC = LENGTH

		dec	e
		jr	z, dan3_offset1

; Get Offset value
	ld		e,d ; Reset DE to $0000
	
dan3_offsets:
	call		getbit			; check next bit
	jr		nc, dan3_offset3
	call		getbit			; check next bit
	jr		nc, dan3_offset2
	call		gethighbitse	; get high bits -> E
	inc		e
	ld		d,e				; D = E+1
dan3_offset3:
	ld     	e, (hl)			; load offset offset value (8 bits)
	inc   	hl
	ex		af, af'
	ld		a,e
	add		a, $20
	ld		e,a
	jr		nc, dan3_offset3b
	inc		d
dan3_offset3b:
	ex		af,af'
	jr		dan3_copy_from_offset
dan3_offset2:
	call		get5bitse			; get 5 bits -> E
	jr		dan3_copy_from_offset
dan3_offset1:
	call		getbit			; check next bit
	jr		nc, dan3_copy_from_offset	
	call		getbite			; get 1 bit -> E
	inc	e
	
; Copy previously seen bytes
dan3_copy_from_offset:
        ex		(sp), hl                ; store source, restore destination
        push	hl                      ; store destination
	scf
        sbc		hl, de                  ; HL = source = destination - offset - 1
        pop		de                      ; DE = destination
	; BC = count
	; COPY BYTES
	ex		af,af'
	set		6,d
dan3_copybytes_loop:
	push	bc
	ld		c, $BF
	out		(c), l
	nop
	out		(c), h
	inc		hl
	nop
	nop
	in		a, ($BE)
	nop
	nop
	nop
	out		(c), e
	nop
	out		(c), d
	inc		de
	nop
	nop
	out		($BE), a
	pop		bc
	dec		bc
	ld		a,b
	or		c
	jr		nz, dan3_copybytes_loop
	res		6,d
	ex		af,af'
        pop		hl		; restore source address (compressed data)
        jp		dan3_main_loop
	
gethighbitse:
		jp	(ix)
        ;call	getbite	; get next bit -> E
        ;call	getbite	; get next bit -> E
get5bitse:
        call	getbite	; get next bit -> E
        call	getbite	; get next bit -> E
        call	getbite	; get next bit -> E
        call	getbite	; get next bit -> E
getbite:
        call	getbit	; get next bit
        rl      e		; push bit into E
	ret

getbit:
	add		a, a
  	ret		nz
	ld		a, (hl)
	inc		hl
	rla
	ret

; DATA

awblp1:
	incbin	"awblp1.bin.dan3"
awblp2:
	incbin	"awblp2.bin.dan3"
f1spp1:
	incbin	"f1spp1.bin.dan3"
f1spp2:
	incbin	"f1spp2.bin.dan3"
h6exp1:
	incbin	"h6exp1.bin.dan3"
h6exp2:
	incbin	"h6exp2.bin.dan3"
mgfap1:
	incbin	"mgfap1.bin.dan3"
mgfap2:
	incbin	"mgfap2.bin.dan3"
sotbp1:
	incbin	"sotbp1.bin.dan3"
sotbp2:
	incbin	"sotbp2.bin.dan3"
