/*
 * This declarations of the PIC18F6490 MCU.
 *
 * This file is part of the GNU PIC library for SDCC, originally
 * created by Molnar Karoly <molnarkaroly@users.sf.net> 2012.
 *
 * This file is generated automatically by the cinc2h.pl, 2012-11-01 17:30:59 UTC.
 *
 * SDCC is licensed under the GNU Public license (GPL) v2. Note that
 * this license covers the code to the compiler and other executables,
 * but explicitly does not cover any code or objects generated by sdcc.
 *
 * For pic device libraries and header files which are derived from
 * Microchip header (.inc) and linker script (.lkr) files Microchip
 * requires that "The header files should state that they are only to be
 * used with authentic Microchip devices" which makes them incompatible
 * with the GPL. Pic device libraries and header files are located at
 * non-free/lib and non-free/include directories respectively.
 * Sdcc should be run with the --use-non-free command line option in
 * order to include non-free header files and libraries.
 *
 * See http://sdcc.sourceforge.net/ for the latest information on sdcc.
 */

#ifndef __PIC18F6490_H__
#define __PIC18F6490_H__

//==============================================================================

//==============================================================================
//
//	Register Definitions
//
//==============================================================================


//==============================================================================
//        LCDPS Bits

extern __at(0x0F58) __sfr LCDPS;

typedef union
  {
  struct
    {
    unsigned LP0                : 1;
    unsigned LP1                : 1;
    unsigned LP2                : 1;
    unsigned LP3                : 1;
    unsigned WA                 : 1;
    unsigned LCDA               : 1;
    unsigned BIASMD             : 1;
    unsigned WFT                : 1;
    };

  struct
    {
    unsigned LCDPS0             : 1;
    unsigned LCDPS1             : 1;
    unsigned LCDPS2             : 1;
    unsigned LCDPS3             : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned LCDPS              : 4;
    unsigned                    : 4;
    };

  struct
    {
    unsigned LP                 : 4;
    unsigned                    : 4;
    };
  } __LCDPSbits_t;

extern __at(0x0F58) volatile __LCDPSbits_t LCDPSbits;

#define _LP0                    0x01
#define _LCDPS0                 0x01
#define _LP1                    0x02
#define _LCDPS1                 0x02
#define _LP2                    0x04
#define _LCDPS2                 0x04
#define _LP3                    0x08
#define _LCDPS3                 0x08
#define _WA                     0x10
#define _LCDA                   0x20
#define _BIASMD                 0x40
#define _WFT                    0x80

//==============================================================================


//==============================================================================
//        LCDCON Bits

extern __at(0x0F59) __sfr LCDCON;

typedef union
  {
  struct
    {
    unsigned LMUX0              : 1;
    unsigned LMUX1              : 1;
    unsigned CS0                : 1;
    unsigned CS1                : 1;
    unsigned                    : 1;
    unsigned WERR               : 1;
    unsigned SLPEN              : 1;
    unsigned LCDEN              : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned LCDCS0             : 1;
    unsigned LCDCS1             : 1;
    unsigned                    : 1;
    unsigned LCDWERR            : 1;
    unsigned LCDSLPEN           : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned LMUX               : 2;
    unsigned                    : 6;
    };

  struct
    {
    unsigned                    : 2;
    unsigned CS                 : 2;
    unsigned                    : 4;
    };

  struct
    {
    unsigned                    : 2;
    unsigned LCDCS              : 2;
    unsigned                    : 4;
    };
  } __LCDCONbits_t;

extern __at(0x0F59) volatile __LCDCONbits_t LCDCONbits;

#define _LMUX0                  0x01
#define _LMUX1                  0x02
#define _CS0                    0x04
#define _LCDCS0                 0x04
#define _CS1                    0x08
#define _LCDCS1                 0x08
#define _WERR                   0x20
#define _LCDWERR                0x20
#define _SLPEN                  0x40
#define _LCDSLPEN               0x40
#define _LCDEN                  0x80

//==============================================================================


//==============================================================================
//        LCDSE0 Bits

extern __at(0x0F5A) __sfr LCDSE0;

typedef union
  {
  struct
    {
    unsigned SE0                : 1;
    unsigned SE1                : 1;
    unsigned SE2                : 1;
    unsigned SE3                : 1;
    unsigned SE4                : 1;
    unsigned SE5                : 1;
    unsigned SE6                : 1;
    unsigned SE7                : 1;
    };

  struct
    {
    unsigned SEGEN0             : 1;
    unsigned SEGEN1             : 1;
    unsigned SEGEN2             : 1;
    unsigned SEGEN3             : 1;
    unsigned SEGEN4             : 1;
    unsigned SEGEN5             : 1;
    unsigned SEGEN6             : 1;
    unsigned SEGEN7             : 1;
    };
  } __LCDSE0bits_t;

extern __at(0x0F5A) volatile __LCDSE0bits_t LCDSE0bits;

#define _SE0                    0x01
#define _SEGEN0                 0x01
#define _SE1                    0x02
#define _SEGEN1                 0x02
#define _SE2                    0x04
#define _SEGEN2                 0x04
#define _SE3                    0x08
#define _SEGEN3                 0x08
#define _SE4                    0x10
#define _SEGEN4                 0x10
#define _SE5                    0x20
#define _SEGEN5                 0x20
#define _SE6                    0x40
#define _SEGEN6                 0x40
#define _SE7                    0x80
#define _SEGEN7                 0x80

//==============================================================================


//==============================================================================
//        LCDSE1 Bits

extern __at(0x0F5B) __sfr LCDSE1;

typedef union
  {
  struct
    {
    unsigned SE8                : 1;
    unsigned SE9                : 1;
    unsigned SE10               : 1;
    unsigned SE11               : 1;
    unsigned SE12               : 1;
    unsigned SE13               : 1;
    unsigned SE14               : 1;
    unsigned SE15               : 1;
    };

  struct
    {
    unsigned SEGEN8             : 1;
    unsigned SEGEN9             : 1;
    unsigned SEGEN10            : 1;
    unsigned SEGEN11            : 1;
    unsigned SEGEN12            : 1;
    unsigned SEGEN13            : 1;
    unsigned SEGEN14            : 1;
    unsigned SEGEN15            : 1;
    };
  } __LCDSE1bits_t;

extern __at(0x0F5B) volatile __LCDSE1bits_t LCDSE1bits;

#define _SE8                    0x01
#define _SEGEN8                 0x01
#define _SE9                    0x02
#define _SEGEN9                 0x02
#define _SE10                   0x04
#define _SEGEN10                0x04
#define _SE11                   0x08
#define _SEGEN11                0x08
#define _SE12                   0x10
#define _SEGEN12                0x10
#define _SE13                   0x20
#define _SEGEN13                0x20
#define _SE14                   0x40
#define _SEGEN14                0x40
#define _SE15                   0x80
#define _SEGEN15                0x80

//==============================================================================


//==============================================================================
//        LCDSE2 Bits

extern __at(0x0F5C) __sfr LCDSE2;

typedef union
  {
  struct
    {
    unsigned SE16               : 1;
    unsigned SE17               : 1;
    unsigned SE18               : 1;
    unsigned SE19               : 1;
    unsigned SE20               : 1;
    unsigned SE21               : 1;
    unsigned SE22               : 1;
    unsigned SE23               : 1;
    };

  struct
    {
    unsigned SEGEN16            : 1;
    unsigned SEGEN17            : 1;
    unsigned SEGEN18            : 1;
    unsigned SEGEN19            : 1;
    unsigned SEGEN20            : 1;
    unsigned SEGEN21            : 1;
    unsigned SEGEN22            : 1;
    unsigned SEGEN23            : 1;
    };
  } __LCDSE2bits_t;

extern __at(0x0F5C) volatile __LCDSE2bits_t LCDSE2bits;

#define _SE16                   0x01
#define _SEGEN16                0x01
#define _SE17                   0x02
#define _SEGEN17                0x02
#define _SE18                   0x04
#define _SEGEN18                0x04
#define _SE19                   0x08
#define _SEGEN19                0x08
#define _SE20                   0x10
#define _SEGEN20                0x10
#define _SE21                   0x20
#define _SEGEN21                0x20
#define _SE22                   0x40
#define _SEGEN22                0x40
#define _SE23                   0x80
#define _SEGEN23                0x80

//==============================================================================


//==============================================================================
//        LCDSE3 Bits

extern __at(0x0F5D) __sfr LCDSE3;

typedef union
  {
  struct
    {
    unsigned SE24               : 1;
    unsigned SE25               : 1;
    unsigned SE26               : 1;
    unsigned SE27               : 1;
    unsigned SE28               : 1;
    unsigned SE29               : 1;
    unsigned SE30               : 1;
    unsigned SE31               : 1;
    };

  struct
    {
    unsigned SEGEN24            : 1;
    unsigned SEGEN25            : 1;
    unsigned SEGEN26            : 1;
    unsigned SEGEN27            : 1;
    unsigned SEGEN28            : 1;
    unsigned SEGEN29            : 1;
    unsigned SEGEN30            : 1;
    unsigned SEGEN31            : 1;
    };
  } __LCDSE3bits_t;

extern __at(0x0F5D) volatile __LCDSE3bits_t LCDSE3bits;

#define _SE24                   0x01
#define _SEGEN24                0x01
#define _SE25                   0x02
#define _SEGEN25                0x02
#define _SE26                   0x04
#define _SEGEN26                0x04
#define _SE27                   0x08
#define _SEGEN27                0x08
#define _SE28                   0x10
#define _SEGEN28                0x10
#define _SE29                   0x20
#define _SEGEN29                0x20
#define _SE30                   0x40
#define _SEGEN30                0x40
#define _SE31                   0x80
#define _SEGEN31                0x80

//==============================================================================


//==============================================================================
//        LCDDATA0 Bits

extern __at(0x0F60) __sfr LCDDATA0;

typedef union
  {
  struct
    {
    unsigned S0C0               : 1;
    unsigned S1C0               : 1;
    unsigned S2C0               : 1;
    unsigned S3C0               : 1;
    unsigned S4C0               : 1;
    unsigned S5C0               : 1;
    unsigned S6C0               : 1;
    unsigned S7C0               : 1;
    };

  struct
    {
    unsigned SEG0COM0           : 1;
    unsigned SEG1COM0           : 1;
    unsigned SEG2COM0           : 1;
    unsigned SEG3COM0           : 1;
    unsigned SEG4COM0           : 1;
    unsigned SEG5COM0           : 1;
    unsigned SEG6COM0           : 1;
    unsigned SEG7COM0           : 1;
    };

  struct
    {
    unsigned S00C0              : 1;
    unsigned S01C0              : 1;
    unsigned S02C0              : 1;
    unsigned S03C0              : 1;
    unsigned S04C0              : 1;
    unsigned S05C0              : 1;
    unsigned S06C0              : 1;
    unsigned S07C0              : 1;
    };
  } __LCDDATA0bits_t;

extern __at(0x0F60) volatile __LCDDATA0bits_t LCDDATA0bits;

#define _S0C0                   0x01
#define _SEG0COM0               0x01
#define _S00C0                  0x01
#define _S1C0                   0x02
#define _SEG1COM0               0x02
#define _S01C0                  0x02
#define _S2C0                   0x04
#define _SEG2COM0               0x04
#define _S02C0                  0x04
#define _S3C0                   0x08
#define _SEG3COM0               0x08
#define _S03C0                  0x08
#define _S4C0                   0x10
#define _SEG4COM0               0x10
#define _S04C0                  0x10
#define _S5C0                   0x20
#define _SEG5COM0               0x20
#define _S05C0                  0x20
#define _S6C0                   0x40
#define _SEG6COM0               0x40
#define _S06C0                  0x40
#define _S7C0                   0x80
#define _SEG7COM0               0x80
#define _S07C0                  0x80

//==============================================================================


//==============================================================================
//        LCDDATA1 Bits

extern __at(0x0F61) __sfr LCDDATA1;

typedef union
  {
  struct
    {
    unsigned S8C0               : 1;
    unsigned S9C0               : 1;
    unsigned S10C0              : 1;
    unsigned S11C0              : 1;
    unsigned S12C0              : 1;
    unsigned S13C0              : 1;
    unsigned S14C0              : 1;
    unsigned S15C0              : 1;
    };

  struct
    {
    unsigned SEG8COM0           : 1;
    unsigned SEG9COM0           : 1;
    unsigned SEG10COM0          : 1;
    unsigned SEG11COM0          : 1;
    unsigned SEG12COM0          : 1;
    unsigned SEG13COM0          : 1;
    unsigned SEG14COM0          : 1;
    unsigned SEG15COM0          : 1;
    };

  struct
    {
    unsigned S08C0              : 1;
    unsigned S09C0              : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };
  } __LCDDATA1bits_t;

extern __at(0x0F61) volatile __LCDDATA1bits_t LCDDATA1bits;

#define _S8C0                   0x01
#define _SEG8COM0               0x01
#define _S08C0                  0x01
#define _S9C0                   0x02
#define _SEG9COM0               0x02
#define _S09C0                  0x02
#define _S10C0                  0x04
#define _SEG10COM0              0x04
#define _S11C0                  0x08
#define _SEG11COM0              0x08
#define _S12C0                  0x10
#define _SEG12COM0              0x10
#define _S13C0                  0x20
#define _SEG13COM0              0x20
#define _S14C0                  0x40
#define _SEG14COM0              0x40
#define _S15C0                  0x80
#define _SEG15COM0              0x80

//==============================================================================


//==============================================================================
//        LCDDATA2 Bits

extern __at(0x0F62) __sfr LCDDATA2;

typedef union
  {
  struct
    {
    unsigned S16C0              : 1;
    unsigned S17C0              : 1;
    unsigned S18C0              : 1;
    unsigned S19C0              : 1;
    unsigned S20C0              : 1;
    unsigned S21C0              : 1;
    unsigned S22C0              : 1;
    unsigned S23C0              : 1;
    };

  struct
    {
    unsigned SEG16COM0          : 1;
    unsigned SEG17COM0          : 1;
    unsigned SEG18COM0          : 1;
    unsigned SEG19COM0          : 1;
    unsigned SEG20COM0          : 1;
    unsigned SEG21COM0          : 1;
    unsigned SEG22COM0          : 1;
    unsigned SEG23COM0          : 1;
    };
  } __LCDDATA2bits_t;

extern __at(0x0F62) volatile __LCDDATA2bits_t LCDDATA2bits;

#define _S16C0                  0x01
#define _SEG16COM0              0x01
#define _S17C0                  0x02
#define _SEG17COM0              0x02
#define _S18C0                  0x04
#define _SEG18COM0              0x04
#define _S19C0                  0x08
#define _SEG19COM0              0x08
#define _S20C0                  0x10
#define _SEG20COM0              0x10
#define _S21C0                  0x20
#define _SEG21COM0              0x20
#define _S22C0                  0x40
#define _SEG22COM0              0x40
#define _S23C0                  0x80
#define _SEG23COM0              0x80

//==============================================================================


//==============================================================================
//        LCDDATA3 Bits

extern __at(0x0F63) __sfr LCDDATA3;

typedef union
  {
  struct
    {
    unsigned S24C0              : 1;
    unsigned S25C0              : 1;
    unsigned S26C0              : 1;
    unsigned S27C0              : 1;
    unsigned S28C0              : 1;
    unsigned S29C0              : 1;
    unsigned S30C0              : 1;
    unsigned S31C0              : 1;
    };

  struct
    {
    unsigned SEG24COM0          : 1;
    unsigned SEG25COM0          : 1;
    unsigned SEG26COM0          : 1;
    unsigned SEG27COM0          : 1;
    unsigned SEG28COM0          : 1;
    unsigned SEG29COM0          : 1;
    unsigned SEG30COM0          : 1;
    unsigned SEG31COM0          : 1;
    };
  } __LCDDATA3bits_t;

extern __at(0x0F63) volatile __LCDDATA3bits_t LCDDATA3bits;

#define _S24C0                  0x01
#define _SEG24COM0              0x01
#define _S25C0                  0x02
#define _SEG25COM0              0x02
#define _S26C0                  0x04
#define _SEG26COM0              0x04
#define _S27C0                  0x08
#define _SEG27COM0              0x08
#define _S28C0                  0x10
#define _SEG28COM0              0x10
#define _S29C0                  0x20
#define _SEG29COM0              0x20
#define _S30C0                  0x40
#define _SEG30COM0              0x40
#define _S31C0                  0x80
#define _SEG31COM0              0x80

//==============================================================================


//==============================================================================
//        LCDDATA4 Bits

extern __at(0x0F64) __sfr LCDDATA4;

typedef union
  {
  struct
    {
    unsigned S32C0              : 1;
    unsigned S33C0              : 1;
    unsigned S34C0              : 1;
    unsigned S35C0              : 1;
    unsigned S36C0              : 1;
    unsigned S37C0              : 1;
    unsigned S38C0              : 1;
    unsigned S39C0              : 1;
    };

  struct
    {
    unsigned SEG32COM0          : 1;
    unsigned SEG33COM0          : 1;
    unsigned SEG34COM0          : 1;
    unsigned SEG35COM0          : 1;
    unsigned SEG36COM0          : 1;
    unsigned SEG37COM0          : 1;
    unsigned SEG38COM0          : 1;
    unsigned SEG39COM0          : 1;
    };
  } __LCDDATA4bits_t;

extern __at(0x0F64) volatile __LCDDATA4bits_t LCDDATA4bits;

#define _S32C0                  0x01
#define _SEG32COM0              0x01
#define _S33C0                  0x02
#define _SEG33COM0              0x02
#define _S34C0                  0x04
#define _SEG34COM0              0x04
#define _S35C0                  0x08
#define _SEG35COM0              0x08
#define _S36C0                  0x10
#define _SEG36COM0              0x10
#define _S37C0                  0x20
#define _SEG37COM0              0x20
#define _S38C0                  0x40
#define _SEG38COM0              0x40
#define _S39C0                  0x80
#define _SEG39COM0              0x80

//==============================================================================


//==============================================================================
//        LCDDATA5 Bits

extern __at(0x0F65) __sfr LCDDATA5;

typedef union
  {
  struct
    {
    unsigned S40C0              : 1;
    unsigned S41C0              : 1;
    unsigned S42C0              : 1;
    unsigned S43C0              : 1;
    unsigned S44C0              : 1;
    unsigned S45C0              : 1;
    unsigned S46C0              : 1;
    unsigned S47C0              : 1;
    };

  struct
    {
    unsigned SEG40COM0          : 1;
    unsigned SEG41COM0          : 1;
    unsigned SEG42COM0          : 1;
    unsigned SEG43COM0          : 1;
    unsigned SEG44COM0          : 1;
    unsigned SEG45COM0          : 1;
    unsigned SEG46COM0          : 1;
    unsigned SEG47COM0          : 1;
    };
  } __LCDDATA5bits_t;

extern __at(0x0F65) volatile __LCDDATA5bits_t LCDDATA5bits;

#define _S40C0                  0x01
#define _SEG40COM0              0x01
#define _S41C0                  0x02
#define _SEG41COM0              0x02
#define _S42C0                  0x04
#define _SEG42COM0              0x04
#define _S43C0                  0x08
#define _SEG43COM0              0x08
#define _S44C0                  0x10
#define _SEG44COM0              0x10
#define _S45C0                  0x20
#define _SEG45COM0              0x20
#define _S46C0                  0x40
#define _SEG46COM0              0x40
#define _S47C0                  0x80
#define _SEG47COM0              0x80

//==============================================================================


//==============================================================================
//        LCDDATA6 Bits

extern __at(0x0F66) __sfr LCDDATA6;

typedef union
  {
  struct
    {
    unsigned S0C1               : 1;
    unsigned S1C1               : 1;
    unsigned S2C1               : 1;
    unsigned S3C1               : 1;
    unsigned S4C1               : 1;
    unsigned S5C1               : 1;
    unsigned S6C1               : 1;
    unsigned S7C1               : 1;
    };

  struct
    {
    unsigned SEG0COM1           : 1;
    unsigned SEG1COM1           : 1;
    unsigned SEG2COM1           : 1;
    unsigned SEG3COM1           : 1;
    unsigned SEG4COM1           : 1;
    unsigned SEG5COM1           : 1;
    unsigned SEG6COM1           : 1;
    unsigned SEG7COM1           : 1;
    };

  struct
    {
    unsigned S00C1              : 1;
    unsigned S01C1              : 1;
    unsigned S02C1              : 1;
    unsigned S03C1              : 1;
    unsigned S04C1              : 1;
    unsigned S05C1              : 1;
    unsigned S06C1              : 1;
    unsigned S07C1              : 1;
    };
  } __LCDDATA6bits_t;

extern __at(0x0F66) volatile __LCDDATA6bits_t LCDDATA6bits;

#define _S0C1                   0x01
#define _SEG0COM1               0x01
#define _S00C1                  0x01
#define _S1C1                   0x02
#define _SEG1COM1               0x02
#define _S01C1                  0x02
#define _S2C1                   0x04
#define _SEG2COM1               0x04
#define _S02C1                  0x04
#define _S3C1                   0x08
#define _SEG3COM1               0x08
#define _S03C1                  0x08
#define _S4C1                   0x10
#define _SEG4COM1               0x10
#define _S04C1                  0x10
#define _S5C1                   0x20
#define _SEG5COM1               0x20
#define _S05C1                  0x20
#define _S6C1                   0x40
#define _SEG6COM1               0x40
#define _S06C1                  0x40
#define _S7C1                   0x80
#define _SEG7COM1               0x80
#define _S07C1                  0x80

//==============================================================================


//==============================================================================
//        LCDDATA7 Bits

extern __at(0x0F67) __sfr LCDDATA7;

typedef union
  {
  struct
    {
    unsigned S8C1               : 1;
    unsigned S9C1               : 1;
    unsigned S10C1              : 1;
    unsigned S11C1              : 1;
    unsigned S12C1              : 1;
    unsigned S13C1              : 1;
    unsigned S14C1              : 1;
    unsigned S15C1              : 1;
    };

  struct
    {
    unsigned SEG8COM1           : 1;
    unsigned SEG9COM1           : 1;
    unsigned SEG10COM1          : 1;
    unsigned SEG11COM1          : 1;
    unsigned SEG12COM1          : 1;
    unsigned SEG13COM1          : 1;
    unsigned SEG14COM1          : 1;
    unsigned SEG15COM1          : 1;
    };

  struct
    {
    unsigned S08C1              : 1;
    unsigned S09C1              : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };
  } __LCDDATA7bits_t;

extern __at(0x0F67) volatile __LCDDATA7bits_t LCDDATA7bits;

#define _S8C1                   0x01
#define _SEG8COM1               0x01
#define _S08C1                  0x01
#define _S9C1                   0x02
#define _SEG9COM1               0x02
#define _S09C1                  0x02
#define _S10C1                  0x04
#define _SEG10COM1              0x04
#define _S11C1                  0x08
#define _SEG11COM1              0x08
#define _S12C1                  0x10
#define _SEG12COM1              0x10
#define _S13C1                  0x20
#define _SEG13COM1              0x20
#define _S14C1                  0x40
#define _SEG14COM1              0x40
#define _S15C1                  0x80
#define _SEG15COM1              0x80

//==============================================================================


//==============================================================================
//        LCDDATA8 Bits

extern __at(0x0F68) __sfr LCDDATA8;

typedef union
  {
  struct
    {
    unsigned S16C1              : 1;
    unsigned S17C1              : 1;
    unsigned S18C1              : 1;
    unsigned S19C1              : 1;
    unsigned S20C1              : 1;
    unsigned S21C1              : 1;
    unsigned S22C1              : 1;
    unsigned S23C1              : 1;
    };

  struct
    {
    unsigned SEG16COM1          : 1;
    unsigned SEG17COM1          : 1;
    unsigned SEG18COM1          : 1;
    unsigned SEG19COM1          : 1;
    unsigned SEG20COM1          : 1;
    unsigned SEG21COM1          : 1;
    unsigned SEG22COM1          : 1;
    unsigned SEG23COM1          : 1;
    };
  } __LCDDATA8bits_t;

extern __at(0x0F68) volatile __LCDDATA8bits_t LCDDATA8bits;

#define _S16C1                  0x01
#define _SEG16COM1              0x01
#define _S17C1                  0x02
#define _SEG17COM1              0x02
#define _S18C1                  0x04
#define _SEG18COM1              0x04
#define _S19C1                  0x08
#define _SEG19COM1              0x08
#define _S20C1                  0x10
#define _SEG20COM1              0x10
#define _S21C1                  0x20
#define _SEG21COM1              0x20
#define _S22C1                  0x40
#define _SEG22COM1              0x40
#define _S23C1                  0x80
#define _SEG23COM1              0x80

//==============================================================================


//==============================================================================
//        LCDDATA9 Bits

extern __at(0x0F69) __sfr LCDDATA9;

typedef union
  {
  struct
    {
    unsigned S24C1              : 1;
    unsigned S25C1              : 1;
    unsigned S26C1              : 1;
    unsigned S27C1              : 1;
    unsigned S28C1              : 1;
    unsigned S29C1              : 1;
    unsigned S30C1              : 1;
    unsigned S31C1              : 1;
    };

  struct
    {
    unsigned SEG24COM1          : 1;
    unsigned SEG25COM1          : 1;
    unsigned SEG26COM1          : 1;
    unsigned SEG27COM1          : 1;
    unsigned SEG28COM1          : 1;
    unsigned SEG29COM1          : 1;
    unsigned SEG30COM1          : 1;
    unsigned SEG31COM1          : 1;
    };
  } __LCDDATA9bits_t;

extern __at(0x0F69) volatile __LCDDATA9bits_t LCDDATA9bits;

#define _S24C1                  0x01
#define _SEG24COM1              0x01
#define _S25C1                  0x02
#define _SEG25COM1              0x02
#define _S26C1                  0x04
#define _SEG26COM1              0x04
#define _S27C1                  0x08
#define _SEG27COM1              0x08
#define _S28C1                  0x10
#define _SEG28COM1              0x10
#define _S29C1                  0x20
#define _SEG29COM1              0x20
#define _S30C1                  0x40
#define _SEG30COM1              0x40
#define _S31C1                  0x80
#define _SEG31COM1              0x80

//==============================================================================


//==============================================================================
//        LCDDATA10 Bits

extern __at(0x0F6A) __sfr LCDDATA10;

typedef union
  {
  struct
    {
    unsigned S32C1              : 1;
    unsigned S33C1              : 1;
    unsigned S34C1              : 1;
    unsigned S35C1              : 1;
    unsigned S36C1              : 1;
    unsigned S37C1              : 1;
    unsigned S38C1              : 1;
    unsigned S39C1              : 1;
    };

  struct
    {
    unsigned SEG32COM1          : 1;
    unsigned SEG33COM1          : 1;
    unsigned SEG34COM1          : 1;
    unsigned SEG35COM1          : 1;
    unsigned SEG36COM1          : 1;
    unsigned SEG37COM1          : 1;
    unsigned SEG38COM1          : 1;
    unsigned SEG39COM1          : 1;
    };
  } __LCDDATA10bits_t;

extern __at(0x0F6A) volatile __LCDDATA10bits_t LCDDATA10bits;

#define _S32C1                  0x01
#define _SEG32COM1              0x01
#define _S33C1                  0x02
#define _SEG33COM1              0x02
#define _S34C1                  0x04
#define _SEG34COM1              0x04
#define _S35C1                  0x08
#define _SEG35COM1              0x08
#define _S36C1                  0x10
#define _SEG36COM1              0x10
#define _S37C1                  0x20
#define _SEG37COM1              0x20
#define _S38C1                  0x40
#define _SEG38COM1              0x40
#define _S39C1                  0x80
#define _SEG39COM1              0x80

//==============================================================================


//==============================================================================
//        RCSTA2 Bits

extern __at(0x0F6B) __sfr RCSTA2;

typedef union
  {
  struct
    {
    unsigned RX9D               : 1;
    unsigned OERR               : 1;
    unsigned FERR               : 1;
    unsigned ADDEN              : 1;
    unsigned CREN               : 1;
    unsigned SREN               : 1;
    unsigned RX9                : 1;
    unsigned SPEN               : 1;
    };

  struct
    {
    unsigned RCD8               : 1;
    unsigned OERR2              : 1;
    unsigned FERR2              : 1;
    unsigned ADEN               : 1;
    unsigned CREN2              : 1;
    unsigned SREN2              : 1;
    unsigned RC9                : 1;
    unsigned SPEN2              : 1;
    };

  struct
    {
    unsigned RX9D2              : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned ADDEN2             : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned NOT_RC8            : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned RC8_9              : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned RX92               : 1;
    unsigned                    : 1;
    };
  } __RCSTA2bits_t;

extern __at(0x0F6B) volatile __RCSTA2bits_t RCSTA2bits;

#define _RCSTA2_RX9D            0x01
#define _RCSTA2_RCD8            0x01
#define _RCSTA2_RX9D2           0x01
#define _RCSTA2_OERR            0x02
#define _RCSTA2_OERR2           0x02
#define _RCSTA2_FERR            0x04
#define _RCSTA2_FERR2           0x04
#define _RCSTA2_ADDEN           0x08
#define _RCSTA2_ADEN            0x08
#define _RCSTA2_ADDEN2          0x08
#define _RCSTA2_CREN            0x10
#define _RCSTA2_CREN2           0x10
#define _RCSTA2_SREN            0x20
#define _RCSTA2_SREN2           0x20
#define _RCSTA2_RX9             0x40
#define _RCSTA2_RC9             0x40
#define _RCSTA2_NOT_RC8         0x40
#define _RCSTA2_RC8_9           0x40
#define _RCSTA2_RX92            0x40
#define _RCSTA2_SPEN            0x80
#define _RCSTA2_SPEN2           0x80

//==============================================================================


//==============================================================================
//        TXSTA2 Bits

extern __at(0x0F6C) __sfr TXSTA2;

typedef union
  {
  struct
    {
    unsigned TX9D               : 1;
    unsigned TRMT               : 1;
    unsigned BRGH               : 1;
    unsigned SENDB2             : 1;
    unsigned SYNC               : 1;
    unsigned TXEN               : 1;
    unsigned TX9                : 1;
    unsigned CSRC               : 1;
    };

  struct
    {
    unsigned TXD8               : 1;
    unsigned TRMT2              : 1;
    unsigned BRGH2              : 1;
    unsigned                    : 1;
    unsigned SYNC2              : 1;
    unsigned TXEN2              : 1;
    unsigned TX8_9              : 1;
    unsigned CSRC2              : 1;
    };

  struct
    {
    unsigned TX9D2              : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned NOT_TX8            : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned TX92               : 1;
    unsigned                    : 1;
    };
  } __TXSTA2bits_t;

extern __at(0x0F6C) volatile __TXSTA2bits_t TXSTA2bits;

#define _TXSTA2_TX9D            0x01
#define _TXSTA2_TXD8            0x01
#define _TXSTA2_TX9D2           0x01
#define _TXSTA2_TRMT            0x02
#define _TXSTA2_TRMT2           0x02
#define _TXSTA2_BRGH            0x04
#define _TXSTA2_BRGH2           0x04
#define _TXSTA2_SENDB2          0x08
#define _TXSTA2_SYNC            0x10
#define _TXSTA2_SYNC2           0x10
#define _TXSTA2_TXEN            0x20
#define _TXSTA2_TXEN2           0x20
#define _TXSTA2_TX9             0x40
#define _TXSTA2_TX8_9           0x40
#define _TXSTA2_NOT_TX8         0x40
#define _TXSTA2_TX92            0x40
#define _TXSTA2_CSRC            0x80
#define _TXSTA2_CSRC2           0x80

//==============================================================================

extern __at(0x0F6D) __sfr TXREG2;
extern __at(0x0F6E) __sfr RCREG2;
extern __at(0x0F6F) __sfr SPBRG2;

//==============================================================================
//        LCDDATA11 Bits

extern __at(0x0F70) __sfr LCDDATA11;

typedef union
  {
  struct
    {
    unsigned S40C1              : 1;
    unsigned S41C1              : 1;
    unsigned S42C1              : 1;
    unsigned S43C1              : 1;
    unsigned S44C1              : 1;
    unsigned S45C1              : 1;
    unsigned S46C1              : 1;
    unsigned S47C1              : 1;
    };

  struct
    {
    unsigned SEG40COM1          : 1;
    unsigned SEG41COM1          : 1;
    unsigned SEG42COM1          : 1;
    unsigned SEG43COM1          : 1;
    unsigned SEG44COM1          : 1;
    unsigned SEG45COM1          : 1;
    unsigned SEG46COM1          : 1;
    unsigned SEG47COM1          : 1;
    };
  } __LCDDATA11bits_t;

extern __at(0x0F70) volatile __LCDDATA11bits_t LCDDATA11bits;

#define _S40C1                  0x01
#define _SEG40COM1              0x01
#define _S41C1                  0x02
#define _SEG41COM1              0x02
#define _S42C1                  0x04
#define _SEG42COM1              0x04
#define _S43C1                  0x08
#define _SEG43COM1              0x08
#define _S44C1                  0x10
#define _SEG44COM1              0x10
#define _S45C1                  0x20
#define _SEG45COM1              0x20
#define _S46C1                  0x40
#define _SEG46COM1              0x40
#define _S47C1                  0x80
#define _SEG47COM1              0x80

//==============================================================================


//==============================================================================
//        LCDDATA12 Bits

extern __at(0x0F71) __sfr LCDDATA12;

typedef union
  {
  struct
    {
    unsigned S0C2               : 1;
    unsigned S1C2               : 1;
    unsigned S2C2               : 1;
    unsigned S3C2               : 1;
    unsigned S4C2               : 1;
    unsigned S5C2               : 1;
    unsigned S6C2               : 1;
    unsigned S7C2               : 1;
    };

  struct
    {
    unsigned SEG0COM2           : 1;
    unsigned SEG1COM2           : 1;
    unsigned SEG2COM2           : 1;
    unsigned SEG3COM2           : 1;
    unsigned SEG4COM2           : 1;
    unsigned SEG5COM2           : 1;
    unsigned SEG6COM2           : 1;
    unsigned SEG7COM2           : 1;
    };

  struct
    {
    unsigned S00C2              : 1;
    unsigned S01C2              : 1;
    unsigned S02C2              : 1;
    unsigned S03C2              : 1;
    unsigned S04C2              : 1;
    unsigned S05C2              : 1;
    unsigned S06C2              : 1;
    unsigned S07C2              : 1;
    };
  } __LCDDATA12bits_t;

extern __at(0x0F71) volatile __LCDDATA12bits_t LCDDATA12bits;

#define _S0C2                   0x01
#define _SEG0COM2               0x01
#define _S00C2                  0x01
#define _S1C2                   0x02
#define _SEG1COM2               0x02
#define _S01C2                  0x02
#define _S2C2                   0x04
#define _SEG2COM2               0x04
#define _S02C2                  0x04
#define _S3C2                   0x08
#define _SEG3COM2               0x08
#define _S03C2                  0x08
#define _S4C2                   0x10
#define _SEG4COM2               0x10
#define _S04C2                  0x10
#define _S5C2                   0x20
#define _SEG5COM2               0x20
#define _S05C2                  0x20
#define _S6C2                   0x40
#define _SEG6COM2               0x40
#define _S06C2                  0x40
#define _S7C2                   0x80
#define _SEG7COM2               0x80
#define _S07C2                  0x80

//==============================================================================


//==============================================================================
//        LCDDATA13 Bits

extern __at(0x0F72) __sfr LCDDATA13;

typedef union
  {
  struct
    {
    unsigned S8C2               : 1;
    unsigned S9C2               : 1;
    unsigned S10C2              : 1;
    unsigned S11C2              : 1;
    unsigned S12C2              : 1;
    unsigned S13C2              : 1;
    unsigned S14C2              : 1;
    unsigned S15C2              : 1;
    };

  struct
    {
    unsigned SEG8COM2           : 1;
    unsigned SEG9COM2           : 1;
    unsigned SEG10COM2          : 1;
    unsigned SEG11COM2          : 1;
    unsigned SEG12COM2          : 1;
    unsigned SEG13COM2          : 1;
    unsigned SEG14COM2          : 1;
    unsigned SEG15COM2          : 1;
    };

  struct
    {
    unsigned S08C2              : 1;
    unsigned S09C2              : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };
  } __LCDDATA13bits_t;

extern __at(0x0F72) volatile __LCDDATA13bits_t LCDDATA13bits;

#define _S8C2                   0x01
#define _SEG8COM2               0x01
#define _S08C2                  0x01
#define _S9C2                   0x02
#define _SEG9COM2               0x02
#define _S09C2                  0x02
#define _S10C2                  0x04
#define _SEG10COM2              0x04
#define _S11C2                  0x08
#define _SEG11COM2              0x08
#define _S12C2                  0x10
#define _SEG12COM2              0x10
#define _S13C2                  0x20
#define _SEG13COM2              0x20
#define _S14C2                  0x40
#define _SEG14COM2              0x40
#define _S15C2                  0x80
#define _SEG15COM2              0x80

//==============================================================================


//==============================================================================
//        LCDDATA14 Bits

extern __at(0x0F73) __sfr LCDDATA14;

typedef union
  {
  struct
    {
    unsigned S16C2              : 1;
    unsigned S17C2              : 1;
    unsigned S18C2              : 1;
    unsigned S19C2              : 1;
    unsigned S20C2              : 1;
    unsigned S21C2              : 1;
    unsigned S22C2              : 1;
    unsigned S23C2              : 1;
    };

  struct
    {
    unsigned SEG16COM2          : 1;
    unsigned SEG17COM2          : 1;
    unsigned SEG18COM2          : 1;
    unsigned SEG19COM2          : 1;
    unsigned SEG20COM2          : 1;
    unsigned SEG21COM2          : 1;
    unsigned SEG22COM2          : 1;
    unsigned SEG23COM2          : 1;
    };
  } __LCDDATA14bits_t;

extern __at(0x0F73) volatile __LCDDATA14bits_t LCDDATA14bits;

#define _S16C2                  0x01
#define _SEG16COM2              0x01
#define _S17C2                  0x02
#define _SEG17COM2              0x02
#define _S18C2                  0x04
#define _SEG18COM2              0x04
#define _S19C2                  0x08
#define _SEG19COM2              0x08
#define _S20C2                  0x10
#define _SEG20COM2              0x10
#define _S21C2                  0x20
#define _SEG21COM2              0x20
#define _S22C2                  0x40
#define _SEG22COM2              0x40
#define _S23C2                  0x80
#define _SEG23COM2              0x80

//==============================================================================


//==============================================================================
//        LCDDATA15 Bits

extern __at(0x0F74) __sfr LCDDATA15;

typedef union
  {
  struct
    {
    unsigned S24C2              : 1;
    unsigned S25C2              : 1;
    unsigned S26C2              : 1;
    unsigned S27C2              : 1;
    unsigned S28C2              : 1;
    unsigned S29C2              : 1;
    unsigned S30C2              : 1;
    unsigned S31C2              : 1;
    };

  struct
    {
    unsigned SEG24COM2          : 1;
    unsigned SEG25COM2          : 1;
    unsigned SEG26COM2          : 1;
    unsigned SEG27COM2          : 1;
    unsigned SEG28COM2          : 1;
    unsigned SEG29COM2          : 1;
    unsigned SEG30COM2          : 1;
    unsigned SEG31COM2          : 1;
    };
  } __LCDDATA15bits_t;

extern __at(0x0F74) volatile __LCDDATA15bits_t LCDDATA15bits;

#define _S24C2                  0x01
#define _SEG24COM2              0x01
#define _S25C2                  0x02
#define _SEG25COM2              0x02
#define _S26C2                  0x04
#define _SEG26COM2              0x04
#define _S27C2                  0x08
#define _SEG27COM2              0x08
#define _S28C2                  0x10
#define _SEG28COM2              0x10
#define _S29C2                  0x20
#define _SEG29COM2              0x20
#define _S30C2                  0x40
#define _SEG30COM2              0x40
#define _S31C2                  0x80
#define _SEG31COM2              0x80

//==============================================================================


//==============================================================================
//        LCDDATA16 Bits

extern __at(0x0F75) __sfr LCDDATA16;

typedef union
  {
  struct
    {
    unsigned S32C2              : 1;
    unsigned S33C2              : 1;
    unsigned S34C2              : 1;
    unsigned S35C2              : 1;
    unsigned S36C2              : 1;
    unsigned S37C2              : 1;
    unsigned S38C2              : 1;
    unsigned S39C2              : 1;
    };

  struct
    {
    unsigned SEG32COM2          : 1;
    unsigned SEG33COM2          : 1;
    unsigned SEG34COM2          : 1;
    unsigned SEG35COM2          : 1;
    unsigned SEG36COM2          : 1;
    unsigned SEG37COM2          : 1;
    unsigned SEG38COM2          : 1;
    unsigned SEG39COM2          : 1;
    };
  } __LCDDATA16bits_t;

extern __at(0x0F75) volatile __LCDDATA16bits_t LCDDATA16bits;

#define _S32C2                  0x01
#define _SEG32COM2              0x01
#define _S33C2                  0x02
#define _SEG33COM2              0x02
#define _S34C2                  0x04
#define _SEG34COM2              0x04
#define _S35C2                  0x08
#define _SEG35COM2              0x08
#define _S36C2                  0x10
#define _SEG36COM2              0x10
#define _S37C2                  0x20
#define _SEG37COM2              0x20
#define _S38C2                  0x40
#define _SEG38COM2              0x40
#define _S39C2                  0x80
#define _SEG39COM2              0x80

//==============================================================================


//==============================================================================
//        LCDDATA17 Bits

extern __at(0x0F76) __sfr LCDDATA17;

typedef union
  {
  struct
    {
    unsigned S40C2              : 1;
    unsigned S41C2              : 1;
    unsigned S42C2              : 1;
    unsigned S43C2              : 1;
    unsigned S44C2              : 1;
    unsigned S45C2              : 1;
    unsigned S46C2              : 1;
    unsigned S47C2              : 1;
    };

  struct
    {
    unsigned SEG40COM2          : 1;
    unsigned SEG41COM2          : 1;
    unsigned SEG42COM2          : 1;
    unsigned SEG43COM2          : 1;
    unsigned SEG44COM2          : 1;
    unsigned SEG45COM2          : 1;
    unsigned SEG46COM2          : 1;
    unsigned SEG47COM2          : 1;
    };
  } __LCDDATA17bits_t;

extern __at(0x0F76) volatile __LCDDATA17bits_t LCDDATA17bits;

#define _S40C2                  0x01
#define _SEG40COM2              0x01
#define _S41C2                  0x02
#define _SEG41COM2              0x02
#define _S42C2                  0x04
#define _SEG42COM2              0x04
#define _S43C2                  0x08
#define _SEG43COM2              0x08
#define _S44C2                  0x10
#define _SEG44COM2              0x10
#define _S45C2                  0x20
#define _SEG45COM2              0x20
#define _S46C2                  0x40
#define _SEG46COM2              0x40
#define _S47C2                  0x80
#define _SEG47COM2              0x80

//==============================================================================


//==============================================================================
//        LCDDATA18 Bits

extern __at(0x0F77) __sfr LCDDATA18;

typedef union
  {
  struct
    {
    unsigned S0C3               : 1;
    unsigned S1C3               : 1;
    unsigned S2C3               : 1;
    unsigned S3C3               : 1;
    unsigned S4C3               : 1;
    unsigned S5C3               : 1;
    unsigned S6C3               : 1;
    unsigned S7C3               : 1;
    };

  struct
    {
    unsigned SEG0COM3           : 1;
    unsigned SEG1COM3           : 1;
    unsigned SEG2COM3           : 1;
    unsigned SEG3COM3           : 1;
    unsigned SEG4COM3           : 1;
    unsigned SEG5COM3           : 1;
    unsigned SEG6COM3           : 1;
    unsigned SEG7COM3           : 1;
    };

  struct
    {
    unsigned S00C3              : 1;
    unsigned S01C3              : 1;
    unsigned S02C3              : 1;
    unsigned S03C3              : 1;
    unsigned S04C3              : 1;
    unsigned S05C3              : 1;
    unsigned S06C3              : 1;
    unsigned S07C3              : 1;
    };
  } __LCDDATA18bits_t;

extern __at(0x0F77) volatile __LCDDATA18bits_t LCDDATA18bits;

#define _S0C3                   0x01
#define _SEG0COM3               0x01
#define _S00C3                  0x01
#define _S1C3                   0x02
#define _SEG1COM3               0x02
#define _S01C3                  0x02
#define _S2C3                   0x04
#define _SEG2COM3               0x04
#define _S02C3                  0x04
#define _S3C3                   0x08
#define _SEG3COM3               0x08
#define _S03C3                  0x08
#define _S4C3                   0x10
#define _SEG4COM3               0x10
#define _S04C3                  0x10
#define _S5C3                   0x20
#define _SEG5COM3               0x20
#define _S05C3                  0x20
#define _S6C3                   0x40
#define _SEG6COM3               0x40
#define _S06C3                  0x40
#define _S7C3                   0x80
#define _SEG7COM3               0x80
#define _S07C3                  0x80

//==============================================================================


//==============================================================================
//        LCDDATA19 Bits

extern __at(0x0F78) __sfr LCDDATA19;

typedef union
  {
  struct
    {
    unsigned S8C3               : 1;
    unsigned S9C3               : 1;
    unsigned S10C3              : 1;
    unsigned S11C3              : 1;
    unsigned S12C3              : 1;
    unsigned S13C3              : 1;
    unsigned S14C3              : 1;
    unsigned S15C3              : 1;
    };

  struct
    {
    unsigned SEG8COM3           : 1;
    unsigned SEG9COM3           : 1;
    unsigned SEG10COM3          : 1;
    unsigned SEG11COM3          : 1;
    unsigned SEG12COM3          : 1;
    unsigned SEG13COM3          : 1;
    unsigned SEG14COM3          : 1;
    unsigned SEG15COM3          : 1;
    };

  struct
    {
    unsigned S08C3              : 1;
    unsigned S09C3              : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };
  } __LCDDATA19bits_t;

extern __at(0x0F78) volatile __LCDDATA19bits_t LCDDATA19bits;

#define _S8C3                   0x01
#define _SEG8COM3               0x01
#define _S08C3                  0x01
#define _S9C3                   0x02
#define _SEG9COM3               0x02
#define _S09C3                  0x02
#define _S10C3                  0x04
#define _SEG10COM3              0x04
#define _S11C3                  0x08
#define _SEG11COM3              0x08
#define _S12C3                  0x10
#define _SEG12COM3              0x10
#define _S13C3                  0x20
#define _SEG13COM3              0x20
#define _S14C3                  0x40
#define _SEG14COM3              0x40
#define _S15C3                  0x80
#define _SEG15COM3              0x80

//==============================================================================


//==============================================================================
//        LCDDATA20 Bits

extern __at(0x0F79) __sfr LCDDATA20;

typedef union
  {
  struct
    {
    unsigned S16C3              : 1;
    unsigned S17C3              : 1;
    unsigned S18C3              : 1;
    unsigned S19C3              : 1;
    unsigned S20C3              : 1;
    unsigned S21C3              : 1;
    unsigned S22C3              : 1;
    unsigned S23C3              : 1;
    };

  struct
    {
    unsigned SEG16COM3          : 1;
    unsigned SEG17COM3          : 1;
    unsigned SEG18COM3          : 1;
    unsigned SEG19COM3          : 1;
    unsigned SEG20COM3          : 1;
    unsigned SEG21COM3          : 1;
    unsigned SEG22COM3          : 1;
    unsigned SEG23COM3          : 1;
    };
  } __LCDDATA20bits_t;

extern __at(0x0F79) volatile __LCDDATA20bits_t LCDDATA20bits;

#define _S16C3                  0x01
#define _SEG16COM3              0x01
#define _S17C3                  0x02
#define _SEG17COM3              0x02
#define _S18C3                  0x04
#define _SEG18COM3              0x04
#define _S19C3                  0x08
#define _SEG19COM3              0x08
#define _S20C3                  0x10
#define _SEG20COM3              0x10
#define _S21C3                  0x20
#define _SEG21COM3              0x20
#define _S22C3                  0x40
#define _SEG22COM3              0x40
#define _S23C3                  0x80
#define _SEG23COM3              0x80

//==============================================================================


//==============================================================================
//        LCDDATA21 Bits

extern __at(0x0F7A) __sfr LCDDATA21;

typedef union
  {
  struct
    {
    unsigned S24C3              : 1;
    unsigned S25C3              : 1;
    unsigned S26C3              : 1;
    unsigned S27C3              : 1;
    unsigned S28C3              : 1;
    unsigned S29C3              : 1;
    unsigned S30C3              : 1;
    unsigned S31C3              : 1;
    };

  struct
    {
    unsigned SEG24COM3          : 1;
    unsigned SEG25COM3          : 1;
    unsigned SEG26COM3          : 1;
    unsigned SEG27COM3          : 1;
    unsigned SEG28COM3          : 1;
    unsigned SEG29COM3          : 1;
    unsigned SEG30COM3          : 1;
    unsigned SEG31COM3          : 1;
    };
  } __LCDDATA21bits_t;

extern __at(0x0F7A) volatile __LCDDATA21bits_t LCDDATA21bits;

#define _S24C3                  0x01
#define _SEG24COM3              0x01
#define _S25C3                  0x02
#define _SEG25COM3              0x02
#define _S26C3                  0x04
#define _SEG26COM3              0x04
#define _S27C3                  0x08
#define _SEG27COM3              0x08
#define _S28C3                  0x10
#define _SEG28COM3              0x10
#define _S29C3                  0x20
#define _SEG29COM3              0x20
#define _S30C3                  0x40
#define _SEG30COM3              0x40
#define _S31C3                  0x80
#define _SEG31COM3              0x80

//==============================================================================


//==============================================================================
//        LCDDATA22 Bits

extern __at(0x0F7B) __sfr LCDDATA22;

typedef union
  {
  struct
    {
    unsigned S32C3              : 1;
    unsigned S33C3              : 1;
    unsigned S34C3              : 1;
    unsigned S35C3              : 1;
    unsigned S36C3              : 1;
    unsigned S37C3              : 1;
    unsigned S38C3              : 1;
    unsigned S39C3              : 1;
    };

  struct
    {
    unsigned SEG32COM3          : 1;
    unsigned SEG33COM3          : 1;
    unsigned SEG34COM3          : 1;
    unsigned SEG35COM3          : 1;
    unsigned SEG36COM3          : 1;
    unsigned SEG37COM3          : 1;
    unsigned SEG38COM3          : 1;
    unsigned SEG39COM3          : 1;
    };
  } __LCDDATA22bits_t;

extern __at(0x0F7B) volatile __LCDDATA22bits_t LCDDATA22bits;

#define _S32C3                  0x01
#define _SEG32COM3              0x01
#define _S33C3                  0x02
#define _SEG33COM3              0x02
#define _S34C3                  0x04
#define _SEG34COM3              0x04
#define _S35C3                  0x08
#define _SEG35COM3              0x08
#define _S36C3                  0x10
#define _SEG36COM3              0x10
#define _S37C3                  0x20
#define _SEG37COM3              0x20
#define _S38C3                  0x40
#define _SEG38COM3              0x40
#define _S39C3                  0x80
#define _SEG39COM3              0x80

//==============================================================================


//==============================================================================
//        LCDDATA23 Bits

extern __at(0x0F7C) __sfr LCDDATA23;

typedef union
  {
  struct
    {
    unsigned S40C3              : 1;
    unsigned S41C3              : 1;
    unsigned S42C3              : 1;
    unsigned S43C3              : 1;
    unsigned S44C3              : 1;
    unsigned S45C3              : 1;
    unsigned S46C3              : 1;
    unsigned S47C3              : 1;
    };

  struct
    {
    unsigned SEG40COM3          : 1;
    unsigned SEG41COM3          : 1;
    unsigned SEG42COM3          : 1;
    unsigned SEG43COM3          : 1;
    unsigned SEG44COM3          : 1;
    unsigned SEG45COM3          : 1;
    unsigned SEG46COM3          : 1;
    unsigned SEG47COM3          : 1;
    };
  } __LCDDATA23bits_t;

extern __at(0x0F7C) volatile __LCDDATA23bits_t LCDDATA23bits;

#define _S40C3                  0x01
#define _SEG40COM3              0x01
#define _S41C3                  0x02
#define _SEG41COM3              0x02
#define _S42C3                  0x04
#define _SEG42COM3              0x04
#define _S43C3                  0x08
#define _SEG43COM3              0x08
#define _S44C3                  0x10
#define _SEG44COM3              0x10
#define _S45C3                  0x20
#define _SEG45COM3              0x20
#define _S46C3                  0x40
#define _SEG46COM3              0x40
#define _S47C3                  0x80
#define _SEG47COM3              0x80

//==============================================================================


//==============================================================================
//        BAUDCON1 Bits

extern __at(0x0F7E) __sfr BAUDCON1;

typedef union
  {
  struct
    {
    unsigned ABDEN              : 1;
    unsigned WUE                : 1;
    unsigned                    : 1;
    unsigned BRG16              : 1;
    unsigned SCKP               : 1;
    unsigned                    : 1;
    unsigned RCIDL              : 1;
    unsigned ABDOVF             : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned RCMT               : 1;
    unsigned                    : 1;
    };
  } __BAUDCON1bits_t;

extern __at(0x0F7E) volatile __BAUDCON1bits_t BAUDCON1bits;

#define _ABDEN                  0x01
#define _WUE                    0x02
#define _BRG16                  0x08
#define _SCKP                   0x10
#define _RCIDL                  0x40
#define _RCMT                   0x40
#define _ABDOVF                 0x80

//==============================================================================


//==============================================================================
//        BAUDCTL1 Bits

extern __at(0x0F7E) __sfr BAUDCTL1;

typedef union
  {
  struct
    {
    unsigned ABDEN              : 1;
    unsigned WUE                : 1;
    unsigned                    : 1;
    unsigned BRG16              : 1;
    unsigned SCKP               : 1;
    unsigned                    : 1;
    unsigned RCIDL              : 1;
    unsigned ABDOVF             : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned RCMT               : 1;
    unsigned                    : 1;
    };
  } __BAUDCTL1bits_t;

extern __at(0x0F7E) volatile __BAUDCTL1bits_t BAUDCTL1bits;

#define _BAUDCTL1_ABDEN         0x01
#define _BAUDCTL1_WUE           0x02
#define _BAUDCTL1_BRG16         0x08
#define _BAUDCTL1_SCKP          0x10
#define _BAUDCTL1_RCIDL         0x40
#define _BAUDCTL1_RCMT          0x40
#define _BAUDCTL1_ABDOVF        0x80

//==============================================================================

extern __at(0x0F7F) __sfr SPBRGH1;

//==============================================================================
//        PORTA Bits

extern __at(0x0F80) __sfr PORTA;

typedef union
  {
  struct
    {
    unsigned RA0                : 1;
    unsigned RA1                : 1;
    unsigned RA2                : 1;
    unsigned RA3                : 1;
    unsigned RA4                : 1;
    unsigned RA5                : 1;
    unsigned RA6                : 1;
    unsigned RA7                : 1;
    };

  struct
    {
    unsigned AN0                : 1;
    unsigned AN1                : 1;
    unsigned AN2                : 1;
    unsigned AN3                : 1;
    unsigned T0CKI              : 1;
    unsigned AN4                : 1;
    unsigned OSC2               : 1;
    unsigned OSC1               : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned VREFM              : 1;
    unsigned VREFP              : 1;
    unsigned SEG14              : 1;
    unsigned LVDIN              : 1;
    unsigned CLKO               : 1;
    unsigned CLKI               : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned SEG16              : 1;
    unsigned SEG17              : 1;
    unsigned                    : 1;
    unsigned SEG15              : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };
  } __PORTAbits_t;

extern __at(0x0F80) volatile __PORTAbits_t PORTAbits;

#define _PORTA_RA0              0x01
#define _PORTA_AN0              0x01
#define _PORTA_RA1              0x02
#define _PORTA_AN1              0x02
#define _PORTA_RA2              0x04
#define _PORTA_AN2              0x04
#define _PORTA_VREFM            0x04
#define _PORTA_SEG16            0x04
#define _PORTA_RA3              0x08
#define _PORTA_AN3              0x08
#define _PORTA_VREFP            0x08
#define _PORTA_SEG17            0x08
#define _PORTA_RA4              0x10
#define _PORTA_T0CKI            0x10
#define _PORTA_SEG14            0x10
#define _PORTA_RA5              0x20
#define _PORTA_AN4              0x20
#define _PORTA_LVDIN            0x20
#define _PORTA_SEG15            0x20
#define _PORTA_RA6              0x40
#define _PORTA_OSC2             0x40
#define _PORTA_CLKO             0x40
#define _PORTA_RA7              0x80
#define _PORTA_OSC1             0x80
#define _PORTA_CLKI             0x80

//==============================================================================


//==============================================================================
//        PORTB Bits

extern __at(0x0F81) __sfr PORTB;

typedef union
  {
  struct
    {
    unsigned RB0                : 1;
    unsigned RB1                : 1;
    unsigned RB2                : 1;
    unsigned RB3                : 1;
    unsigned RB4                : 1;
    unsigned RB5                : 1;
    unsigned RB6                : 1;
    unsigned RB7                : 1;
    };

  struct
    {
    unsigned INT0               : 1;
    unsigned INT1               : 1;
    unsigned INT2               : 1;
    unsigned INT3               : 1;
    unsigned KBI0               : 1;
    unsigned KBI1               : 1;
    unsigned KBI2               : 1;
    unsigned KBI3               : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned SEG8               : 1;
    unsigned SEG9               : 1;
    unsigned SEG10              : 1;
    unsigned SEG11              : 1;
    unsigned PGM                : 1;
    unsigned PGC                : 1;
    unsigned PGD                : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned CCP2B              : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned INT                : 4;
    unsigned                    : 4;
    };

  struct
    {
    unsigned                    : 4;
    unsigned KBI                : 4;
    };
  } __PORTBbits_t;

extern __at(0x0F81) volatile __PORTBbits_t PORTBbits;

#define _PORTB_RB0              0x01
#define _PORTB_INT0             0x01
#define _PORTB_RB1              0x02
#define _PORTB_INT1             0x02
#define _PORTB_SEG8             0x02
#define _PORTB_RB2              0x04
#define _PORTB_INT2             0x04
#define _PORTB_SEG9             0x04
#define _PORTB_RB3              0x08
#define _PORTB_INT3             0x08
#define _PORTB_SEG10            0x08
#define _PORTB_CCP2B            0x08
#define _PORTB_RB4              0x10
#define _PORTB_KBI0             0x10
#define _PORTB_SEG11            0x10
#define _PORTB_RB5              0x20
#define _PORTB_KBI1             0x20
#define _PORTB_PGM              0x20
#define _PORTB_RB6              0x40
#define _PORTB_KBI2             0x40
#define _PORTB_PGC              0x40
#define _PORTB_RB7              0x80
#define _PORTB_KBI3             0x80
#define _PORTB_PGD              0x80

//==============================================================================


//==============================================================================
//        PORTC Bits

extern __at(0x0F82) __sfr PORTC;

typedef union
  {
  struct
    {
    unsigned RC0                : 1;
    unsigned RC1                : 1;
    unsigned RC2                : 1;
    unsigned RC3                : 1;
    unsigned RC4                : 1;
    unsigned RC5                : 1;
    unsigned RC6                : 1;
    unsigned RC7                : 1;
    };

  struct
    {
    unsigned T1OSO              : 1;
    unsigned T1OSI              : 1;
    unsigned CCP1               : 1;
    unsigned SCK                : 1;
    unsigned SDI                : 1;
    unsigned SDO                : 1;
    unsigned TX                 : 1;
    unsigned RX                 : 1;
    };

  struct
    {
    unsigned T13CKI             : 1;
    unsigned CCP2C              : 1;
    unsigned SEG13              : 1;
    unsigned SCL                : 1;
    unsigned SDA                : 1;
    unsigned                    : 1;
    unsigned CK                 : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned SEG12              : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };
  } __PORTCbits_t;

extern __at(0x0F82) volatile __PORTCbits_t PORTCbits;

#define _PORTC_RC0              0x01
#define _PORTC_T1OSO            0x01
#define _PORTC_T13CKI           0x01
#define _PORTC_RC1              0x02
#define _PORTC_T1OSI            0x02
#define _PORTC_CCP2C            0x02
#define _PORTC_RC2              0x04
#define _PORTC_CCP1             0x04
#define _PORTC_SEG13            0x04
#define _PORTC_RC3              0x08
#define _PORTC_SCK              0x08
#define _PORTC_SCL              0x08
#define _PORTC_SEG12            0x08
#define _PORTC_RC4              0x10
#define _PORTC_SDI              0x10
#define _PORTC_SDA              0x10
#define _PORTC_RC5              0x20
#define _PORTC_SDO              0x20
#define _PORTC_RC6              0x40
#define _PORTC_TX               0x40
#define _PORTC_CK               0x40
#define _PORTC_RC7              0x80
#define _PORTC_RX               0x80

//==============================================================================


//==============================================================================
//        PORTD Bits

extern __at(0x0F83) __sfr PORTD;

typedef union
  {
  struct
    {
    unsigned RD0                : 1;
    unsigned RD1                : 1;
    unsigned RD2                : 1;
    unsigned RD3                : 1;
    unsigned RD4                : 1;
    unsigned RD5                : 1;
    unsigned RD6                : 1;
    unsigned RD7                : 1;
    };

  struct
    {
    unsigned SEG0               : 1;
    unsigned SEG1               : 1;
    unsigned SEG2               : 1;
    unsigned SEG3               : 1;
    unsigned SEG4               : 1;
    unsigned SEG5               : 1;
    unsigned SEG6               : 1;
    unsigned SEG7               : 1;
    };
  } __PORTDbits_t;

extern __at(0x0F83) volatile __PORTDbits_t PORTDbits;

#define _PORTD_RD0              0x01
#define _PORTD_SEG0             0x01
#define _PORTD_RD1              0x02
#define _PORTD_SEG1             0x02
#define _PORTD_RD2              0x04
#define _PORTD_SEG2             0x04
#define _PORTD_RD3              0x08
#define _PORTD_SEG3             0x08
#define _PORTD_RD4              0x10
#define _PORTD_SEG4             0x10
#define _PORTD_RD5              0x20
#define _PORTD_SEG5             0x20
#define _PORTD_RD6              0x40
#define _PORTD_SEG6             0x40
#define _PORTD_RD7              0x80
#define _PORTD_SEG7             0x80

//==============================================================================


//==============================================================================
//        PORTE Bits

extern __at(0x0F84) __sfr PORTE;

typedef union
  {
  struct
    {
    unsigned LCDBIAS1           : 1;
    unsigned LCDBIAS2           : 1;
    unsigned LCDBIAS3           : 1;
    unsigned COM0               : 1;
    unsigned RE4                : 1;
    unsigned RE5                : 1;
    unsigned RE6                : 1;
    unsigned RE7                : 1;
    };

  struct
    {
    unsigned BIAS1              : 1;
    unsigned BIAS2              : 1;
    unsigned BIAS3              : 1;
    unsigned                    : 1;
    unsigned COM1               : 1;
    unsigned COM2               : 1;
    unsigned COM3               : 1;
    unsigned SEG31              : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned CCP2E              : 1;
    };

  struct
    {
    unsigned                    : 3;
    unsigned COM                : 4;
    unsigned                    : 1;
    };
  } __PORTEbits_t;

extern __at(0x0F84) volatile __PORTEbits_t PORTEbits;

#define _PORTE_LCDBIAS1         0x01
#define _PORTE_BIAS1            0x01
#define _PORTE_LCDBIAS2         0x02
#define _PORTE_BIAS2            0x02
#define _PORTE_LCDBIAS3         0x04
#define _PORTE_BIAS3            0x04
#define _PORTE_COM0             0x08
#define _PORTE_RE4              0x10
#define _PORTE_COM1             0x10
#define _PORTE_RE5              0x20
#define _PORTE_COM2             0x20
#define _PORTE_RE6              0x40
#define _PORTE_COM3             0x40
#define _PORTE_RE7              0x80
#define _PORTE_SEG31            0x80
#define _PORTE_CCP2E            0x80

//==============================================================================


//==============================================================================
//        PORTF Bits

extern __at(0x0F85) __sfr PORTF;

typedef union
  {
  struct
    {
    unsigned RF0                : 1;
    unsigned RF1                : 1;
    unsigned RF2                : 1;
    unsigned RF3                : 1;
    unsigned RF4                : 1;
    unsigned RF5                : 1;
    unsigned RF6                : 1;
    unsigned RF7                : 1;
    };

  struct
    {
    unsigned AN5                : 1;
    unsigned AN6                : 1;
    unsigned AN7                : 1;
    unsigned AN8                : 1;
    unsigned AN9                : 1;
    unsigned AN10               : 1;
    unsigned AN11               : 1;
    unsigned SS                 : 1;
    };

  struct
    {
    unsigned SEG18              : 1;
    unsigned SEG19              : 1;
    unsigned SEG20              : 1;
    unsigned SEG21              : 1;
    unsigned SEG22              : 1;
    unsigned SEG23              : 1;
    unsigned SEG24              : 1;
    unsigned SEG25              : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned C2OUTF             : 1;
    unsigned C1OUTF             : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned CVREFF             : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };
  } __PORTFbits_t;

extern __at(0x0F85) volatile __PORTFbits_t PORTFbits;

#define _PORTF_RF0              0x01
#define _PORTF_AN5              0x01
#define _PORTF_SEG18            0x01
#define _PORTF_RF1              0x02
#define _PORTF_AN6              0x02
#define _PORTF_SEG19            0x02
#define _PORTF_C2OUTF           0x02
#define _PORTF_RF2              0x04
#define _PORTF_AN7              0x04
#define _PORTF_SEG20            0x04
#define _PORTF_C1OUTF           0x04
#define _PORTF_RF3              0x08
#define _PORTF_AN8              0x08
#define _PORTF_SEG21            0x08
#define _PORTF_RF4              0x10
#define _PORTF_AN9              0x10
#define _PORTF_SEG22            0x10
#define _PORTF_RF5              0x20
#define _PORTF_AN10             0x20
#define _PORTF_SEG23            0x20
#define _PORTF_CVREFF           0x20
#define _PORTF_RF6              0x40
#define _PORTF_AN11             0x40
#define _PORTF_SEG24            0x40
#define _PORTF_RF7              0x80
#define _PORTF_SS               0x80
#define _PORTF_SEG25            0x80

//==============================================================================


//==============================================================================
//        PORTG Bits

extern __at(0x0F86) __sfr PORTG;

typedef union
  {
  struct
    {
    unsigned RG0                : 1;
    unsigned RG1                : 1;
    unsigned RG2                : 1;
    unsigned RG3                : 1;
    unsigned RG4                : 1;
    unsigned RG5                : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned SEG30              : 1;
    unsigned TX2                : 1;
    unsigned RX2                : 1;
    unsigned SEG27              : 1;
    unsigned SEG26              : 1;
    unsigned MCLR               : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned CK2                : 1;
    unsigned DT2                : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned VPP                : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned SEG29              : 1;
    unsigned SEG28              : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned RG                 : 6;
    unsigned                    : 2;
    };
  } __PORTGbits_t;

extern __at(0x0F86) volatile __PORTGbits_t PORTGbits;

#define _PORTG_RG0              0x01
#define _PORTG_SEG30            0x01
#define _PORTG_RG1              0x02
#define _PORTG_TX2              0x02
#define _PORTG_CK2              0x02
#define _PORTG_SEG29            0x02
#define _PORTG_RG2              0x04
#define _PORTG_RX2              0x04
#define _PORTG_DT2              0x04
#define _PORTG_SEG28            0x04
#define _PORTG_RG3              0x08
#define _PORTG_SEG27            0x08
#define _PORTG_RG4              0x10
#define _PORTG_SEG26            0x10
#define _PORTG_RG5              0x20
#define _PORTG_MCLR             0x20
#define _PORTG_VPP              0x20

//==============================================================================


//==============================================================================
//        LATA Bits

extern __at(0x0F89) __sfr LATA;

typedef struct
  {
  unsigned LATA0                : 1;
  unsigned LATA1                : 1;
  unsigned LATA2                : 1;
  unsigned LATA3                : 1;
  unsigned LATA4                : 1;
  unsigned LATA5                : 1;
  unsigned LATA6                : 1;
  unsigned LATA7                : 1;
  } __LATAbits_t;

extern __at(0x0F89) volatile __LATAbits_t LATAbits;

#define _LATA0                  0x01
#define _LATA1                  0x02
#define _LATA2                  0x04
#define _LATA3                  0x08
#define _LATA4                  0x10
#define _LATA5                  0x20
#define _LATA6                  0x40
#define _LATA7                  0x80

//==============================================================================


//==============================================================================
//        LATB Bits

extern __at(0x0F8A) __sfr LATB;

typedef struct
  {
  unsigned LATB0                : 1;
  unsigned LATB1                : 1;
  unsigned LATB2                : 1;
  unsigned LATB3                : 1;
  unsigned LATB4                : 1;
  unsigned LATB5                : 1;
  unsigned LATB6                : 1;
  unsigned LATB7                : 1;
  } __LATBbits_t;

extern __at(0x0F8A) volatile __LATBbits_t LATBbits;

#define _LATB0                  0x01
#define _LATB1                  0x02
#define _LATB2                  0x04
#define _LATB3                  0x08
#define _LATB4                  0x10
#define _LATB5                  0x20
#define _LATB6                  0x40
#define _LATB7                  0x80

//==============================================================================


//==============================================================================
//        LATC Bits

extern __at(0x0F8B) __sfr LATC;

typedef struct
  {
  unsigned LATC0                : 1;
  unsigned LATC1                : 1;
  unsigned LATC2                : 1;
  unsigned LATC3                : 1;
  unsigned LATC4                : 1;
  unsigned LATC5                : 1;
  unsigned LATC6                : 1;
  unsigned LATC7                : 1;
  } __LATCbits_t;

extern __at(0x0F8B) volatile __LATCbits_t LATCbits;

#define _LATC0                  0x01
#define _LATC1                  0x02
#define _LATC2                  0x04
#define _LATC3                  0x08
#define _LATC4                  0x10
#define _LATC5                  0x20
#define _LATC6                  0x40
#define _LATC7                  0x80

//==============================================================================


//==============================================================================
//        LATD Bits

extern __at(0x0F8C) __sfr LATD;

typedef struct
  {
  unsigned LATD0                : 1;
  unsigned LATD1                : 1;
  unsigned LATD2                : 1;
  unsigned LATD3                : 1;
  unsigned LATD4                : 1;
  unsigned LATD5                : 1;
  unsigned LATD6                : 1;
  unsigned LATD7                : 1;
  } __LATDbits_t;

extern __at(0x0F8C) volatile __LATDbits_t LATDbits;

#define _LATD0                  0x01
#define _LATD1                  0x02
#define _LATD2                  0x04
#define _LATD3                  0x08
#define _LATD4                  0x10
#define _LATD5                  0x20
#define _LATD6                  0x40
#define _LATD7                  0x80

//==============================================================================


//==============================================================================
//        LATE Bits

extern __at(0x0F8D) __sfr LATE;

typedef struct
  {
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned LATE4                : 1;
  unsigned LATE5                : 1;
  unsigned LATE6                : 1;
  unsigned LATE7                : 1;
  } __LATEbits_t;

extern __at(0x0F8D) volatile __LATEbits_t LATEbits;

#define _LATE4                  0x10
#define _LATE5                  0x20
#define _LATE6                  0x40
#define _LATE7                  0x80

//==============================================================================


//==============================================================================
//        LATF Bits

extern __at(0x0F8E) __sfr LATF;

typedef struct
  {
  unsigned LATF0                : 1;
  unsigned LATF1                : 1;
  unsigned LATF2                : 1;
  unsigned LATF3                : 1;
  unsigned LATF4                : 1;
  unsigned LATF5                : 1;
  unsigned LATF6                : 1;
  unsigned LATF7                : 1;
  } __LATFbits_t;

extern __at(0x0F8E) volatile __LATFbits_t LATFbits;

#define _LATF0                  0x01
#define _LATF1                  0x02
#define _LATF2                  0x04
#define _LATF3                  0x08
#define _LATF4                  0x10
#define _LATF5                  0x20
#define _LATF6                  0x40
#define _LATF7                  0x80

//==============================================================================


//==============================================================================
//        LATG Bits

extern __at(0x0F8F) __sfr LATG;

typedef union
  {
  struct
    {
    unsigned LATG0              : 1;
    unsigned LATG1              : 1;
    unsigned LATG2              : 1;
    unsigned LATG3              : 1;
    unsigned LATG4              : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned LATG               : 5;
    unsigned                    : 3;
    };
  } __LATGbits_t;

extern __at(0x0F8F) volatile __LATGbits_t LATGbits;

#define _LATG0                  0x01
#define _LATG1                  0x02
#define _LATG2                  0x04
#define _LATG3                  0x08
#define _LATG4                  0x10

//==============================================================================


//==============================================================================
//        DDRA Bits

extern __at(0x0F92) __sfr DDRA;

typedef union
  {
  struct
    {
    unsigned TRISA0             : 1;
    unsigned TRISA1             : 1;
    unsigned TRISA2             : 1;
    unsigned TRISA3             : 1;
    unsigned TRISA4             : 1;
    unsigned TRISA5             : 1;
    unsigned TRISA6             : 1;
    unsigned TRISA7             : 1;
    };

  struct
    {
    unsigned RA0                : 1;
    unsigned RA1                : 1;
    unsigned RA2                : 1;
    unsigned RA3                : 1;
    unsigned RA4                : 1;
    unsigned RA5                : 1;
    unsigned RA6                : 1;
    unsigned RA7                : 1;
    };
  } __DDRAbits_t;

extern __at(0x0F92) volatile __DDRAbits_t DDRAbits;

#define _TRISA0                 0x01
#define _RA0                    0x01
#define _TRISA1                 0x02
#define _RA1                    0x02
#define _TRISA2                 0x04
#define _RA2                    0x04
#define _TRISA3                 0x08
#define _RA3                    0x08
#define _TRISA4                 0x10
#define _RA4                    0x10
#define _TRISA5                 0x20
#define _RA5                    0x20
#define _TRISA6                 0x40
#define _RA6                    0x40
#define _TRISA7                 0x80
#define _RA7                    0x80

//==============================================================================


//==============================================================================
//        TRISA Bits

extern __at(0x0F92) __sfr TRISA;

typedef union
  {
  struct
    {
    unsigned TRISA0             : 1;
    unsigned TRISA1             : 1;
    unsigned TRISA2             : 1;
    unsigned TRISA3             : 1;
    unsigned TRISA4             : 1;
    unsigned TRISA5             : 1;
    unsigned TRISA6             : 1;
    unsigned TRISA7             : 1;
    };

  struct
    {
    unsigned RA0                : 1;
    unsigned RA1                : 1;
    unsigned RA2                : 1;
    unsigned RA3                : 1;
    unsigned RA4                : 1;
    unsigned RA5                : 1;
    unsigned RA6                : 1;
    unsigned RA7                : 1;
    };
  } __TRISAbits_t;

extern __at(0x0F92) volatile __TRISAbits_t TRISAbits;

#define _TRISA_TRISA0           0x01
#define _TRISA_RA0              0x01
#define _TRISA_TRISA1           0x02
#define _TRISA_RA1              0x02
#define _TRISA_TRISA2           0x04
#define _TRISA_RA2              0x04
#define _TRISA_TRISA3           0x08
#define _TRISA_RA3              0x08
#define _TRISA_TRISA4           0x10
#define _TRISA_RA4              0x10
#define _TRISA_TRISA5           0x20
#define _TRISA_RA5              0x20
#define _TRISA_TRISA6           0x40
#define _TRISA_RA6              0x40
#define _TRISA_TRISA7           0x80
#define _TRISA_RA7              0x80

//==============================================================================


//==============================================================================
//        DDRB Bits

extern __at(0x0F93) __sfr DDRB;

typedef union
  {
  struct
    {
    unsigned TRISB0             : 1;
    unsigned TRISB1             : 1;
    unsigned TRISB2             : 1;
    unsigned TRISB3             : 1;
    unsigned TRISB4             : 1;
    unsigned TRISB5             : 1;
    unsigned TRISB6             : 1;
    unsigned TRISB7             : 1;
    };

  struct
    {
    unsigned RB0                : 1;
    unsigned RB1                : 1;
    unsigned RB2                : 1;
    unsigned RB3                : 1;
    unsigned RB4                : 1;
    unsigned RB5                : 1;
    unsigned RB6                : 1;
    unsigned RB7                : 1;
    };
  } __DDRBbits_t;

extern __at(0x0F93) volatile __DDRBbits_t DDRBbits;

#define _TRISB0                 0x01
#define _RB0                    0x01
#define _TRISB1                 0x02
#define _RB1                    0x02
#define _TRISB2                 0x04
#define _RB2                    0x04
#define _TRISB3                 0x08
#define _RB3                    0x08
#define _TRISB4                 0x10
#define _RB4                    0x10
#define _TRISB5                 0x20
#define _RB5                    0x20
#define _TRISB6                 0x40
#define _RB6                    0x40
#define _TRISB7                 0x80
#define _RB7                    0x80

//==============================================================================


//==============================================================================
//        TRISB Bits

extern __at(0x0F93) __sfr TRISB;

typedef union
  {
  struct
    {
    unsigned TRISB0             : 1;
    unsigned TRISB1             : 1;
    unsigned TRISB2             : 1;
    unsigned TRISB3             : 1;
    unsigned TRISB4             : 1;
    unsigned TRISB5             : 1;
    unsigned TRISB6             : 1;
    unsigned TRISB7             : 1;
    };

  struct
    {
    unsigned RB0                : 1;
    unsigned RB1                : 1;
    unsigned RB2                : 1;
    unsigned RB3                : 1;
    unsigned RB4                : 1;
    unsigned RB5                : 1;
    unsigned RB6                : 1;
    unsigned RB7                : 1;
    };
  } __TRISBbits_t;

extern __at(0x0F93) volatile __TRISBbits_t TRISBbits;

#define _TRISB_TRISB0           0x01
#define _TRISB_RB0              0x01
#define _TRISB_TRISB1           0x02
#define _TRISB_RB1              0x02
#define _TRISB_TRISB2           0x04
#define _TRISB_RB2              0x04
#define _TRISB_TRISB3           0x08
#define _TRISB_RB3              0x08
#define _TRISB_TRISB4           0x10
#define _TRISB_RB4              0x10
#define _TRISB_TRISB5           0x20
#define _TRISB_RB5              0x20
#define _TRISB_TRISB6           0x40
#define _TRISB_RB6              0x40
#define _TRISB_TRISB7           0x80
#define _TRISB_RB7              0x80

//==============================================================================


//==============================================================================
//        DDRC Bits

extern __at(0x0F94) __sfr DDRC;

typedef union
  {
  struct
    {
    unsigned TRISC0             : 1;
    unsigned TRISC1             : 1;
    unsigned TRISC2             : 1;
    unsigned TRISC3             : 1;
    unsigned TRISC4             : 1;
    unsigned TRISC5             : 1;
    unsigned TRISC6             : 1;
    unsigned TRISC7             : 1;
    };

  struct
    {
    unsigned RC0                : 1;
    unsigned RC1                : 1;
    unsigned RC2                : 1;
    unsigned RC3                : 1;
    unsigned RC4                : 1;
    unsigned RC5                : 1;
    unsigned RC6                : 1;
    unsigned RC7                : 1;
    };
  } __DDRCbits_t;

extern __at(0x0F94) volatile __DDRCbits_t DDRCbits;

#define _TRISC0                 0x01
#define _RC0                    0x01
#define _TRISC1                 0x02
#define _RC1                    0x02
#define _TRISC2                 0x04
#define _RC2                    0x04
#define _TRISC3                 0x08
#define _RC3                    0x08
#define _TRISC4                 0x10
#define _RC4                    0x10
#define _TRISC5                 0x20
#define _RC5                    0x20
#define _TRISC6                 0x40
#define _RC6                    0x40
#define _TRISC7                 0x80
#define _RC7                    0x80

//==============================================================================


//==============================================================================
//        TRISC Bits

extern __at(0x0F94) __sfr TRISC;

typedef union
  {
  struct
    {
    unsigned TRISC0             : 1;
    unsigned TRISC1             : 1;
    unsigned TRISC2             : 1;
    unsigned TRISC3             : 1;
    unsigned TRISC4             : 1;
    unsigned TRISC5             : 1;
    unsigned TRISC6             : 1;
    unsigned TRISC7             : 1;
    };

  struct
    {
    unsigned RC0                : 1;
    unsigned RC1                : 1;
    unsigned RC2                : 1;
    unsigned RC3                : 1;
    unsigned RC4                : 1;
    unsigned RC5                : 1;
    unsigned RC6                : 1;
    unsigned RC7                : 1;
    };
  } __TRISCbits_t;

extern __at(0x0F94) volatile __TRISCbits_t TRISCbits;

#define _TRISC_TRISC0           0x01
#define _TRISC_RC0              0x01
#define _TRISC_TRISC1           0x02
#define _TRISC_RC1              0x02
#define _TRISC_TRISC2           0x04
#define _TRISC_RC2              0x04
#define _TRISC_TRISC3           0x08
#define _TRISC_RC3              0x08
#define _TRISC_TRISC4           0x10
#define _TRISC_RC4              0x10
#define _TRISC_TRISC5           0x20
#define _TRISC_RC5              0x20
#define _TRISC_TRISC6           0x40
#define _TRISC_RC6              0x40
#define _TRISC_TRISC7           0x80
#define _TRISC_RC7              0x80

//==============================================================================


//==============================================================================
//        DDRD Bits

extern __at(0x0F95) __sfr DDRD;

typedef union
  {
  struct
    {
    unsigned TRISD0             : 1;
    unsigned TRISD1             : 1;
    unsigned TRISD2             : 1;
    unsigned TRISD3             : 1;
    unsigned TRISD4             : 1;
    unsigned TRISD5             : 1;
    unsigned TRISD6             : 1;
    unsigned TRISD7             : 1;
    };

  struct
    {
    unsigned RD0                : 1;
    unsigned RD1                : 1;
    unsigned RD2                : 1;
    unsigned RD3                : 1;
    unsigned RD4                : 1;
    unsigned RD5                : 1;
    unsigned RD6                : 1;
    unsigned RD7                : 1;
    };
  } __DDRDbits_t;

extern __at(0x0F95) volatile __DDRDbits_t DDRDbits;

#define _TRISD0                 0x01
#define _RD0                    0x01
#define _TRISD1                 0x02
#define _RD1                    0x02
#define _TRISD2                 0x04
#define _RD2                    0x04
#define _TRISD3                 0x08
#define _RD3                    0x08
#define _TRISD4                 0x10
#define _RD4                    0x10
#define _TRISD5                 0x20
#define _RD5                    0x20
#define _TRISD6                 0x40
#define _RD6                    0x40
#define _TRISD7                 0x80
#define _RD7                    0x80

//==============================================================================


//==============================================================================
//        TRISD Bits

extern __at(0x0F95) __sfr TRISD;

typedef union
  {
  struct
    {
    unsigned TRISD0             : 1;
    unsigned TRISD1             : 1;
    unsigned TRISD2             : 1;
    unsigned TRISD3             : 1;
    unsigned TRISD4             : 1;
    unsigned TRISD5             : 1;
    unsigned TRISD6             : 1;
    unsigned TRISD7             : 1;
    };

  struct
    {
    unsigned RD0                : 1;
    unsigned RD1                : 1;
    unsigned RD2                : 1;
    unsigned RD3                : 1;
    unsigned RD4                : 1;
    unsigned RD5                : 1;
    unsigned RD6                : 1;
    unsigned RD7                : 1;
    };
  } __TRISDbits_t;

extern __at(0x0F95) volatile __TRISDbits_t TRISDbits;

#define _TRISD_TRISD0           0x01
#define _TRISD_RD0              0x01
#define _TRISD_TRISD1           0x02
#define _TRISD_RD1              0x02
#define _TRISD_TRISD2           0x04
#define _TRISD_RD2              0x04
#define _TRISD_TRISD3           0x08
#define _TRISD_RD3              0x08
#define _TRISD_TRISD4           0x10
#define _TRISD_RD4              0x10
#define _TRISD_TRISD5           0x20
#define _TRISD_RD5              0x20
#define _TRISD_TRISD6           0x40
#define _TRISD_RD6              0x40
#define _TRISD_TRISD7           0x80
#define _TRISD_RD7              0x80

//==============================================================================


//==============================================================================
//        DDRE Bits

extern __at(0x0F96) __sfr DDRE;

typedef union
  {
  struct
    {
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned TRISE4             : 1;
    unsigned TRISE5             : 1;
    unsigned TRISE6             : 1;
    unsigned TRISE7             : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned RE4                : 1;
    unsigned RE5                : 1;
    unsigned RE6                : 1;
    unsigned RE7                : 1;
    };
  } __DDREbits_t;

extern __at(0x0F96) volatile __DDREbits_t DDREbits;

#define _TRISE4                 0x10
#define _RE4                    0x10
#define _TRISE5                 0x20
#define _RE5                    0x20
#define _TRISE6                 0x40
#define _RE6                    0x40
#define _TRISE7                 0x80
#define _RE7                    0x80

//==============================================================================


//==============================================================================
//        TRISE Bits

extern __at(0x0F96) __sfr TRISE;

typedef union
  {
  struct
    {
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned TRISE4             : 1;
    unsigned TRISE5             : 1;
    unsigned TRISE6             : 1;
    unsigned TRISE7             : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned RE4                : 1;
    unsigned RE5                : 1;
    unsigned RE6                : 1;
    unsigned RE7                : 1;
    };
  } __TRISEbits_t;

extern __at(0x0F96) volatile __TRISEbits_t TRISEbits;

#define _TRISE_TRISE4           0x10
#define _TRISE_RE4              0x10
#define _TRISE_TRISE5           0x20
#define _TRISE_RE5              0x20
#define _TRISE_TRISE6           0x40
#define _TRISE_RE6              0x40
#define _TRISE_TRISE7           0x80
#define _TRISE_RE7              0x80

//==============================================================================


//==============================================================================
//        DDRF Bits

extern __at(0x0F97) __sfr DDRF;

typedef union
  {
  struct
    {
    unsigned TRISF0             : 1;
    unsigned TRISF1             : 1;
    unsigned TRISF2             : 1;
    unsigned TRISF3             : 1;
    unsigned TRISF4             : 1;
    unsigned TRISF5             : 1;
    unsigned TRISF6             : 1;
    unsigned TRISF7             : 1;
    };

  struct
    {
    unsigned RF0                : 1;
    unsigned RF1                : 1;
    unsigned RF2                : 1;
    unsigned RF3                : 1;
    unsigned RF4                : 1;
    unsigned RF5                : 1;
    unsigned RF6                : 1;
    unsigned RF7                : 1;
    };
  } __DDRFbits_t;

extern __at(0x0F97) volatile __DDRFbits_t DDRFbits;

#define _TRISF0                 0x01
#define _RF0                    0x01
#define _TRISF1                 0x02
#define _RF1                    0x02
#define _TRISF2                 0x04
#define _RF2                    0x04
#define _TRISF3                 0x08
#define _RF3                    0x08
#define _TRISF4                 0x10
#define _RF4                    0x10
#define _TRISF5                 0x20
#define _RF5                    0x20
#define _TRISF6                 0x40
#define _RF6                    0x40
#define _TRISF7                 0x80
#define _RF7                    0x80

//==============================================================================


//==============================================================================
//        TRISF Bits

extern __at(0x0F97) __sfr TRISF;

typedef union
  {
  struct
    {
    unsigned TRISF0             : 1;
    unsigned TRISF1             : 1;
    unsigned TRISF2             : 1;
    unsigned TRISF3             : 1;
    unsigned TRISF4             : 1;
    unsigned TRISF5             : 1;
    unsigned TRISF6             : 1;
    unsigned TRISF7             : 1;
    };

  struct
    {
    unsigned RF0                : 1;
    unsigned RF1                : 1;
    unsigned RF2                : 1;
    unsigned RF3                : 1;
    unsigned RF4                : 1;
    unsigned RF5                : 1;
    unsigned RF6                : 1;
    unsigned RF7                : 1;
    };
  } __TRISFbits_t;

extern __at(0x0F97) volatile __TRISFbits_t TRISFbits;

#define _TRISF_TRISF0           0x01
#define _TRISF_RF0              0x01
#define _TRISF_TRISF1           0x02
#define _TRISF_RF1              0x02
#define _TRISF_TRISF2           0x04
#define _TRISF_RF2              0x04
#define _TRISF_TRISF3           0x08
#define _TRISF_RF3              0x08
#define _TRISF_TRISF4           0x10
#define _TRISF_RF4              0x10
#define _TRISF_TRISF5           0x20
#define _TRISF_RF5              0x20
#define _TRISF_TRISF6           0x40
#define _TRISF_RF6              0x40
#define _TRISF_TRISF7           0x80
#define _TRISF_RF7              0x80

//==============================================================================


//==============================================================================
//        DDRG Bits

extern __at(0x0F98) __sfr DDRG;

typedef union
  {
  struct
    {
    unsigned TRISG0             : 1;
    unsigned TRISG1             : 1;
    unsigned TRISG2             : 1;
    unsigned TRISG3             : 1;
    unsigned TRISG4             : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned RG0                : 1;
    unsigned RG1                : 1;
    unsigned RG2                : 1;
    unsigned RG3                : 1;
    unsigned RG4                : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned TRISG              : 5;
    unsigned                    : 3;
    };

  struct
    {
    unsigned RG                 : 5;
    unsigned                    : 3;
    };
  } __DDRGbits_t;

extern __at(0x0F98) volatile __DDRGbits_t DDRGbits;

#define _TRISG0                 0x01
#define _RG0                    0x01
#define _TRISG1                 0x02
#define _RG1                    0x02
#define _TRISG2                 0x04
#define _RG2                    0x04
#define _TRISG3                 0x08
#define _RG3                    0x08
#define _TRISG4                 0x10
#define _RG4                    0x10

//==============================================================================


//==============================================================================
//        TRISG Bits

extern __at(0x0F98) __sfr TRISG;

typedef union
  {
  struct
    {
    unsigned TRISG0             : 1;
    unsigned TRISG1             : 1;
    unsigned TRISG2             : 1;
    unsigned TRISG3             : 1;
    unsigned TRISG4             : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned RG0                : 1;
    unsigned RG1                : 1;
    unsigned RG2                : 1;
    unsigned RG3                : 1;
    unsigned RG4                : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned TRISG              : 5;
    unsigned                    : 3;
    };

  struct
    {
    unsigned RG                 : 5;
    unsigned                    : 3;
    };
  } __TRISGbits_t;

extern __at(0x0F98) volatile __TRISGbits_t TRISGbits;

#define _TRISG_TRISG0           0x01
#define _TRISG_RG0              0x01
#define _TRISG_TRISG1           0x02
#define _TRISG_RG1              0x02
#define _TRISG_TRISG2           0x04
#define _TRISG_RG2              0x04
#define _TRISG_TRISG3           0x08
#define _TRISG_RG3              0x08
#define _TRISG_TRISG4           0x10
#define _TRISG_RG4              0x10

//==============================================================================


//==============================================================================
//        OSCTUNE Bits

extern __at(0x0F9B) __sfr OSCTUNE;

typedef union
  {
  struct
    {
    unsigned TUN0               : 1;
    unsigned TUN1               : 1;
    unsigned TUN2               : 1;
    unsigned TUN3               : 1;
    unsigned TUN4               : 1;
    unsigned                    : 1;
    unsigned PLLEN              : 1;
    unsigned INTSRC             : 1;
    };

  struct
    {
    unsigned TUN                : 5;
    unsigned                    : 3;
    };
  } __OSCTUNEbits_t;

extern __at(0x0F9B) volatile __OSCTUNEbits_t OSCTUNEbits;

#define _TUN0                   0x01
#define _TUN1                   0x02
#define _TUN2                   0x04
#define _TUN3                   0x08
#define _TUN4                   0x10
#define _PLLEN                  0x40
#define _INTSRC                 0x80

//==============================================================================


//==============================================================================
//        PIE1 Bits

extern __at(0x0F9D) __sfr PIE1;

typedef union
  {
  struct
    {
    unsigned TMR1IE             : 1;
    unsigned TMR2IE             : 1;
    unsigned CCP1IE             : 1;
    unsigned SSPIE              : 1;
    unsigned TXIE               : 1;
    unsigned RCIE               : 1;
    unsigned ADIE               : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned TX1IE              : 1;
    unsigned RC1IE              : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };
  } __PIE1bits_t;

extern __at(0x0F9D) volatile __PIE1bits_t PIE1bits;

#define _TMR1IE                 0x01
#define _TMR2IE                 0x02
#define _CCP1IE                 0x04
#define _SSPIE                  0x08
#define _TXIE                   0x10
#define _TX1IE                  0x10
#define _RCIE                   0x20
#define _RC1IE                  0x20
#define _ADIE                   0x40

//==============================================================================


//==============================================================================
//        PIR1 Bits

extern __at(0x0F9E) __sfr PIR1;

typedef union
  {
  struct
    {
    unsigned TMR1IF             : 1;
    unsigned TMR2IF             : 1;
    unsigned CCP1IF             : 1;
    unsigned SSPIF              : 1;
    unsigned TXIF               : 1;
    unsigned RCIF               : 1;
    unsigned ADIF               : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned TX1IF              : 1;
    unsigned RC1IF              : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };
  } __PIR1bits_t;

extern __at(0x0F9E) volatile __PIR1bits_t PIR1bits;

#define _TMR1IF                 0x01
#define _TMR2IF                 0x02
#define _CCP1IF                 0x04
#define _SSPIF                  0x08
#define _TXIF                   0x10
#define _TX1IF                  0x10
#define _RCIF                   0x20
#define _RC1IF                  0x20
#define _ADIF                   0x40

//==============================================================================


//==============================================================================
//        IPR1 Bits

extern __at(0x0F9F) __sfr IPR1;

typedef union
  {
  struct
    {
    unsigned TMR1IP             : 1;
    unsigned TMR2IP             : 1;
    unsigned CCP1IP             : 1;
    unsigned SSPIP              : 1;
    unsigned TXIP               : 1;
    unsigned RCIP               : 1;
    unsigned ADIP               : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned TX1IP              : 1;
    unsigned RC1IP              : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };
  } __IPR1bits_t;

extern __at(0x0F9F) volatile __IPR1bits_t IPR1bits;

#define _TMR1IP                 0x01
#define _TMR2IP                 0x02
#define _CCP1IP                 0x04
#define _SSPIP                  0x08
#define _TXIP                   0x10
#define _TX1IP                  0x10
#define _RCIP                   0x20
#define _RC1IP                  0x20
#define _ADIP                   0x40

//==============================================================================


//==============================================================================
//        PIE2 Bits

extern __at(0x0FA0) __sfr PIE2;

typedef union
  {
  struct
    {
    unsigned CCP2IE             : 1;
    unsigned TMR3IE             : 1;
    unsigned HLVDIE             : 1;
    unsigned BCLIE              : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned CMIE               : 1;
    unsigned OSCFIE             : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned LVDIE              : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };
  } __PIE2bits_t;

extern __at(0x0FA0) volatile __PIE2bits_t PIE2bits;

#define _CCP2IE                 0x01
#define _TMR3IE                 0x02
#define _HLVDIE                 0x04
#define _LVDIE                  0x04
#define _BCLIE                  0x08
#define _CMIE                   0x40
#define _OSCFIE                 0x80

//==============================================================================


//==============================================================================
//        PIR2 Bits

extern __at(0x0FA1) __sfr PIR2;

typedef union
  {
  struct
    {
    unsigned CCP2IF             : 1;
    unsigned TMR3IF             : 1;
    unsigned HLVDIF             : 1;
    unsigned BCLIF              : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned CMIF               : 1;
    unsigned OSCFIF             : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned LVDIF              : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };
  } __PIR2bits_t;

extern __at(0x0FA1) volatile __PIR2bits_t PIR2bits;

#define _CCP2IF                 0x01
#define _TMR3IF                 0x02
#define _HLVDIF                 0x04
#define _LVDIF                  0x04
#define _BCLIF                  0x08
#define _CMIF                   0x40
#define _OSCFIF                 0x80

//==============================================================================


//==============================================================================
//        IPR2 Bits

extern __at(0x0FA2) __sfr IPR2;

typedef union
  {
  struct
    {
    unsigned CCP2IP             : 1;
    unsigned TMR3IP             : 1;
    unsigned HLVDIP             : 1;
    unsigned BCLIP              : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned CMIP               : 1;
    unsigned OSCFIP             : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned LVDIP              : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };
  } __IPR2bits_t;

extern __at(0x0FA2) volatile __IPR2bits_t IPR2bits;

#define _CCP2IP                 0x01
#define _TMR3IP                 0x02
#define _HLVDIP                 0x04
#define _LVDIP                  0x04
#define _BCLIP                  0x08
#define _CMIP                   0x40
#define _OSCFIP                 0x80

//==============================================================================


//==============================================================================
//        PIE3 Bits

extern __at(0x0FA3) __sfr PIE3;

typedef struct
  {
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned TX2IE                : 1;
  unsigned RC2IE                : 1;
  unsigned LCDIE                : 1;
  unsigned                      : 1;
  } __PIE3bits_t;

extern __at(0x0FA3) volatile __PIE3bits_t PIE3bits;

#define _TX2IE                  0x10
#define _RC2IE                  0x20
#define _LCDIE                  0x40

//==============================================================================


//==============================================================================
//        PIR3 Bits

extern __at(0x0FA4) __sfr PIR3;

typedef struct
  {
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned TX2IF                : 1;
  unsigned RC2IF                : 1;
  unsigned LCDIF                : 1;
  unsigned                      : 1;
  } __PIR3bits_t;

extern __at(0x0FA4) volatile __PIR3bits_t PIR3bits;

#define _TX2IF                  0x10
#define _RC2IF                  0x20
#define _LCDIF                  0x40

//==============================================================================


//==============================================================================
//        IPR3 Bits

extern __at(0x0FA5) __sfr IPR3;

typedef struct
  {
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned TX2IP                : 1;
  unsigned RC2IP                : 1;
  unsigned LCDIP                : 1;
  unsigned                      : 1;
  } __IPR3bits_t;

extern __at(0x0FA5) volatile __IPR3bits_t IPR3bits;

#define _TX2IP                  0x10
#define _RC2IP                  0x20
#define _LCDIP                  0x40

//==============================================================================


//==============================================================================
//        RCSTA Bits

extern __at(0x0FAB) __sfr RCSTA;

typedef union
  {
  struct
    {
    unsigned RX9D               : 1;
    unsigned OERR               : 1;
    unsigned FERR               : 1;
    unsigned ADDEN              : 1;
    unsigned CREN               : 1;
    unsigned SREN               : 1;
    unsigned RX9                : 1;
    unsigned SPEN               : 1;
    };

  struct
    {
    unsigned RX9D1              : 1;
    unsigned OERR1              : 1;
    unsigned FERR1              : 1;
    unsigned ADEN               : 1;
    unsigned CREN1              : 1;
    unsigned SREN1              : 1;
    unsigned RX91               : 1;
    unsigned SPEN1              : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned ADDEN1             : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };
  } __RCSTAbits_t;

extern __at(0x0FAB) volatile __RCSTAbits_t RCSTAbits;

#define _RX9D                   0x01
#define _RX9D1                  0x01
#define _OERR                   0x02
#define _OERR1                  0x02
#define _FERR                   0x04
#define _FERR1                  0x04
#define _ADDEN                  0x08
#define _ADEN                   0x08
#define _ADDEN1                 0x08
#define _CREN                   0x10
#define _CREN1                  0x10
#define _SREN                   0x20
#define _SREN1                  0x20
#define _RX9                    0x40
#define _RX91                   0x40
#define _SPEN                   0x80
#define _SPEN1                  0x80

//==============================================================================


//==============================================================================
//        RCSTA1 Bits

extern __at(0x0FAB) __sfr RCSTA1;

typedef union
  {
  struct
    {
    unsigned RX9D               : 1;
    unsigned OERR               : 1;
    unsigned FERR               : 1;
    unsigned ADDEN              : 1;
    unsigned CREN               : 1;
    unsigned SREN               : 1;
    unsigned RX9                : 1;
    unsigned SPEN               : 1;
    };

  struct
    {
    unsigned RX9D1              : 1;
    unsigned OERR1              : 1;
    unsigned FERR1              : 1;
    unsigned ADEN               : 1;
    unsigned CREN1              : 1;
    unsigned SREN1              : 1;
    unsigned RX91               : 1;
    unsigned SPEN1              : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned ADDEN1             : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };
  } __RCSTA1bits_t;

extern __at(0x0FAB) volatile __RCSTA1bits_t RCSTA1bits;

#define _RCSTA1_RX9D            0x01
#define _RCSTA1_RX9D1           0x01
#define _RCSTA1_OERR            0x02
#define _RCSTA1_OERR1           0x02
#define _RCSTA1_FERR            0x04
#define _RCSTA1_FERR1           0x04
#define _RCSTA1_ADDEN           0x08
#define _RCSTA1_ADEN            0x08
#define _RCSTA1_ADDEN1          0x08
#define _RCSTA1_CREN            0x10
#define _RCSTA1_CREN1           0x10
#define _RCSTA1_SREN            0x20
#define _RCSTA1_SREN1           0x20
#define _RCSTA1_RX9             0x40
#define _RCSTA1_RX91            0x40
#define _RCSTA1_SPEN            0x80
#define _RCSTA1_SPEN1           0x80

//==============================================================================


//==============================================================================
//        TXSTA Bits

extern __at(0x0FAC) __sfr TXSTA;

typedef union
  {
  struct
    {
    unsigned TX9D               : 1;
    unsigned TRMT               : 1;
    unsigned BRGH               : 1;
    unsigned SENDB              : 1;
    unsigned SYNC               : 1;
    unsigned TXEN               : 1;
    unsigned TX9                : 1;
    unsigned CSRC               : 1;
    };

  struct
    {
    unsigned TX9D1              : 1;
    unsigned TRMT1              : 1;
    unsigned BRGH1              : 1;
    unsigned SENDB1             : 1;
    unsigned SYNC1              : 1;
    unsigned TXEN1              : 1;
    unsigned TX91               : 1;
    unsigned CSRC1              : 1;
    };
  } __TXSTAbits_t;

extern __at(0x0FAC) volatile __TXSTAbits_t TXSTAbits;

#define _TX9D                   0x01
#define _TX9D1                  0x01
#define _TRMT                   0x02
#define _TRMT1                  0x02
#define _BRGH                   0x04
#define _BRGH1                  0x04
#define _SENDB                  0x08
#define _SENDB1                 0x08
#define _SYNC                   0x10
#define _SYNC1                  0x10
#define _TXEN                   0x20
#define _TXEN1                  0x20
#define _TX9                    0x40
#define _TX91                   0x40
#define _CSRC                   0x80
#define _CSRC1                  0x80

//==============================================================================


//==============================================================================
//        TXSTA1 Bits

extern __at(0x0FAC) __sfr TXSTA1;

typedef union
  {
  struct
    {
    unsigned TX9D               : 1;
    unsigned TRMT               : 1;
    unsigned BRGH               : 1;
    unsigned SENDB              : 1;
    unsigned SYNC               : 1;
    unsigned TXEN               : 1;
    unsigned TX9                : 1;
    unsigned CSRC               : 1;
    };

  struct
    {
    unsigned TX9D1              : 1;
    unsigned TRMT1              : 1;
    unsigned BRGH1              : 1;
    unsigned SENDB1             : 1;
    unsigned SYNC1              : 1;
    unsigned TXEN1              : 1;
    unsigned TX91               : 1;
    unsigned CSRC1              : 1;
    };
  } __TXSTA1bits_t;

extern __at(0x0FAC) volatile __TXSTA1bits_t TXSTA1bits;

#define _TXSTA1_TX9D            0x01
#define _TXSTA1_TX9D1           0x01
#define _TXSTA1_TRMT            0x02
#define _TXSTA1_TRMT1           0x02
#define _TXSTA1_BRGH            0x04
#define _TXSTA1_BRGH1           0x04
#define _TXSTA1_SENDB           0x08
#define _TXSTA1_SENDB1          0x08
#define _TXSTA1_SYNC            0x10
#define _TXSTA1_SYNC1           0x10
#define _TXSTA1_TXEN            0x20
#define _TXSTA1_TXEN1           0x20
#define _TXSTA1_TX9             0x40
#define _TXSTA1_TX91            0x40
#define _TXSTA1_CSRC            0x80
#define _TXSTA1_CSRC1           0x80

//==============================================================================

extern __at(0x0FAD) __sfr TXREG;
extern __at(0x0FAD) __sfr TXREG1;
extern __at(0x0FAE) __sfr RCREG;
extern __at(0x0FAE) __sfr RCREG1;
extern __at(0x0FAF) __sfr SPBRG;
extern __at(0x0FAF) __sfr SPBRG1;

//==============================================================================
//        T3CON Bits

extern __at(0x0FB1) __sfr T3CON;

typedef union
  {
  struct
    {
    unsigned TMR3ON             : 1;
    unsigned TMR3CS             : 1;
    unsigned NOT_T3SYNC         : 1;
    unsigned T3CCP1             : 1;
    unsigned T3CKPS0            : 1;
    unsigned T3CKPS1            : 1;
    unsigned T3CCP2             : 1;
    unsigned RD16               : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned T3SYNC             : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned T3INSYNC           : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned                    : 4;
    unsigned T3CKPS             : 2;
    unsigned                    : 2;
    };
  } __T3CONbits_t;

extern __at(0x0FB1) volatile __T3CONbits_t T3CONbits;

#define _T3CON_TMR3ON           0x01
#define _T3CON_TMR3CS           0x02
#define _T3CON_NOT_T3SYNC       0x04
#define _T3CON_T3SYNC           0x04
#define _T3CON_T3INSYNC         0x04
#define _T3CON_T3CCP1           0x08
#define _T3CON_T3CKPS0          0x10
#define _T3CON_T3CKPS1          0x20
#define _T3CON_T3CCP2           0x40
#define _T3CON_RD16             0x80

//==============================================================================

extern __at(0x0FB2) __sfr TMR3;
extern __at(0x0FB2) __sfr TMR3L;
extern __at(0x0FB3) __sfr TMR3H;

//==============================================================================
//        CMCON Bits

extern __at(0x0FB4) __sfr CMCON;

typedef union
  {
  struct
    {
    unsigned CM0                : 1;
    unsigned CM1                : 1;
    unsigned CM2                : 1;
    unsigned CIS                : 1;
    unsigned C1INV              : 1;
    unsigned C2INV              : 1;
    unsigned C1OUT              : 1;
    unsigned C2OUT              : 1;
    };

  struct
    {
    unsigned CM                 : 3;
    unsigned                    : 5;
    };
  } __CMCONbits_t;

extern __at(0x0FB4) volatile __CMCONbits_t CMCONbits;

#define _CM0                    0x01
#define _CM1                    0x02
#define _CM2                    0x04
#define _CIS                    0x08
#define _C1INV                  0x10
#define _C2INV                  0x20
#define _C1OUT                  0x40
#define _C2OUT                  0x80

//==============================================================================


//==============================================================================
//        CVRCON Bits

extern __at(0x0FB5) __sfr CVRCON;

typedef union
  {
  struct
    {
    unsigned CVR0               : 1;
    unsigned CVR1               : 1;
    unsigned CVR2               : 1;
    unsigned CVR3               : 1;
    unsigned CVRSS              : 1;
    unsigned CVRR               : 1;
    unsigned CVROE              : 1;
    unsigned CVREN              : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned CVREF              : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned CVR                : 4;
    unsigned                    : 4;
    };
  } __CVRCONbits_t;

extern __at(0x0FB5) volatile __CVRCONbits_t CVRCONbits;

#define _CVR0                   0x01
#define _CVR1                   0x02
#define _CVR2                   0x04
#define _CVR3                   0x08
#define _CVRSS                  0x10
#define _CVREF                  0x10
#define _CVRR                   0x20
#define _CVROE                  0x40
#define _CVREN                  0x80

//==============================================================================


//==============================================================================
//        CCP2CON Bits

extern __at(0x0FBA) __sfr CCP2CON;

typedef union
  {
  struct
    {
    unsigned CCP2M0             : 1;
    unsigned CCP2M1             : 1;
    unsigned CCP2M2             : 1;
    unsigned CCP2M3             : 1;
    unsigned DCCP2Y             : 1;
    unsigned DCCP2X             : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned CCP2Y              : 1;
    unsigned CCP2X              : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned DC2B0              : 1;
    unsigned DC2B1              : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned CCP2M              : 4;
    unsigned                    : 4;
    };

  struct
    {
    unsigned                    : 4;
    unsigned DC2B               : 2;
    unsigned                    : 2;
    };
  } __CCP2CONbits_t;

extern __at(0x0FBA) volatile __CCP2CONbits_t CCP2CONbits;

#define _CCP2M0                 0x01
#define _CCP2M1                 0x02
#define _CCP2M2                 0x04
#define _CCP2M3                 0x08
#define _DCCP2Y                 0x10
#define _CCP2Y                  0x10
#define _DC2B0                  0x10
#define _DCCP2X                 0x20
#define _CCP2X                  0x20
#define _DC2B1                  0x20

//==============================================================================

extern __at(0x0FBB) __sfr CCPR2;
extern __at(0x0FBB) __sfr CCPR2L;
extern __at(0x0FBC) __sfr CCPR2H;

//==============================================================================
//        CCP1CON Bits

extern __at(0x0FBD) __sfr CCP1CON;

typedef union
  {
  struct
    {
    unsigned CCP1M0             : 1;
    unsigned CCP1M1             : 1;
    unsigned CCP1M2             : 1;
    unsigned CCP1M3             : 1;
    unsigned DCCP1Y             : 1;
    unsigned DCCP1X             : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned CCP1Y              : 1;
    unsigned CCP1X              : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned DC1B0              : 1;
    unsigned DC1B1              : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned CCP1M              : 4;
    unsigned                    : 4;
    };

  struct
    {
    unsigned                    : 4;
    unsigned DC1B               : 2;
    unsigned                    : 2;
    };
  } __CCP1CONbits_t;

extern __at(0x0FBD) volatile __CCP1CONbits_t CCP1CONbits;

#define _CCP1M0                 0x01
#define _CCP1M1                 0x02
#define _CCP1M2                 0x04
#define _CCP1M3                 0x08
#define _DCCP1Y                 0x10
#define _CCP1Y                  0x10
#define _DC1B0                  0x10
#define _DCCP1X                 0x20
#define _CCP1X                  0x20
#define _DC1B1                  0x20

//==============================================================================

extern __at(0x0FBE) __sfr CCPR1;
extern __at(0x0FBE) __sfr CCPR1L;
extern __at(0x0FBF) __sfr CCPR1H;

//==============================================================================
//        ADCON2 Bits

extern __at(0x0FC0) __sfr ADCON2;

typedef union
  {
  struct
    {
    unsigned ADCS0              : 1;
    unsigned ADCS1              : 1;
    unsigned ADCS2              : 1;
    unsigned ACQT0              : 1;
    unsigned ACQT1              : 1;
    unsigned ACQT2              : 1;
    unsigned                    : 1;
    unsigned ADFM               : 1;
    };

  struct
    {
    unsigned ADCS               : 3;
    unsigned                    : 5;
    };

  struct
    {
    unsigned                    : 3;
    unsigned ACQT               : 3;
    unsigned                    : 2;
    };
  } __ADCON2bits_t;

extern __at(0x0FC0) volatile __ADCON2bits_t ADCON2bits;

#define _ADCS0                  0x01
#define _ADCS1                  0x02
#define _ADCS2                  0x04
#define _ACQT0                  0x08
#define _ACQT1                  0x10
#define _ACQT2                  0x20
#define _ADFM                   0x80

//==============================================================================


//==============================================================================
//        ADCON1 Bits

extern __at(0x0FC1) __sfr ADCON1;

typedef union
  {
  struct
    {
    unsigned PCFG0              : 1;
    unsigned PCFG1              : 1;
    unsigned PCFG2              : 1;
    unsigned PCFG3              : 1;
    unsigned VCFG0              : 1;
    unsigned VCFG1              : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned PCFG               : 4;
    unsigned                    : 4;
    };

  struct
    {
    unsigned                    : 4;
    unsigned VCFG               : 2;
    unsigned                    : 2;
    };
  } __ADCON1bits_t;

extern __at(0x0FC1) volatile __ADCON1bits_t ADCON1bits;

#define _PCFG0                  0x01
#define _PCFG1                  0x02
#define _PCFG2                  0x04
#define _PCFG3                  0x08
#define _VCFG0                  0x10
#define _VCFG1                  0x20

//==============================================================================


//==============================================================================
//        ADCON0 Bits

extern __at(0x0FC2) __sfr ADCON0;

typedef union
  {
  struct
    {
    unsigned ADON               : 1;
    unsigned GO_NOT_DONE        : 1;
    unsigned CHS0               : 1;
    unsigned CHS1               : 1;
    unsigned CHS2               : 1;
    unsigned CHS3               : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned GO_DONE            : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned DONE               : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned GO                 : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned NOT_DONE           : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned                    : 2;
    unsigned CHS                : 4;
    unsigned                    : 2;
    };
  } __ADCON0bits_t;

extern __at(0x0FC2) volatile __ADCON0bits_t ADCON0bits;

#define _ADON                   0x01
#define _GO_NOT_DONE            0x02
#define _GO_DONE                0x02
#define _DONE                   0x02
#define _GO                     0x02
#define _NOT_DONE               0x02
#define _CHS0                   0x04
#define _CHS1                   0x08
#define _CHS2                   0x10
#define _CHS3                   0x20

//==============================================================================

extern __at(0x0FC3) __sfr ADRES;
extern __at(0x0FC3) __sfr ADRESL;
extern __at(0x0FC4) __sfr ADRESH;

//==============================================================================
//        SSPCON2 Bits

extern __at(0x0FC5) __sfr SSPCON2;

typedef struct
  {
  unsigned SEN                  : 1;
  unsigned RSEN                 : 1;
  unsigned PEN                  : 1;
  unsigned RCEN                 : 1;
  unsigned ACKEN                : 1;
  unsigned ACKDT                : 1;
  unsigned ACKSTAT              : 1;
  unsigned GCEN                 : 1;
  } __SSPCON2bits_t;

extern __at(0x0FC5) volatile __SSPCON2bits_t SSPCON2bits;

#define _SEN                    0x01
#define _RSEN                   0x02
#define _PEN                    0x04
#define _RCEN                   0x08
#define _ACKEN                  0x10
#define _ACKDT                  0x20
#define _ACKSTAT                0x40
#define _GCEN                   0x80

//==============================================================================


//==============================================================================
//        SSPCON1 Bits

extern __at(0x0FC6) __sfr SSPCON1;

typedef union
  {
  struct
    {
    unsigned SSPM0              : 1;
    unsigned SSPM1              : 1;
    unsigned SSPM2              : 1;
    unsigned SSPM3              : 1;
    unsigned CKP                : 1;
    unsigned SSPEN              : 1;
    unsigned SSPOV              : 1;
    unsigned WCOL               : 1;
    };

  struct
    {
    unsigned SSPM               : 4;
    unsigned                    : 4;
    };
  } __SSPCON1bits_t;

extern __at(0x0FC6) volatile __SSPCON1bits_t SSPCON1bits;

#define _SSPM0                  0x01
#define _SSPM1                  0x02
#define _SSPM2                  0x04
#define _SSPM3                  0x08
#define _CKP                    0x10
#define _SSPEN                  0x20
#define _SSPOV                  0x40
#define _WCOL                   0x80

//==============================================================================


//==============================================================================
//        SSPSTAT Bits

extern __at(0x0FC7) __sfr SSPSTAT;

typedef union
  {
  struct
    {
    unsigned BF                 : 1;
    unsigned UA                 : 1;
    unsigned R_NOT_W            : 1;
    unsigned S                  : 1;
    unsigned P                  : 1;
    unsigned D_NOT_A            : 1;
    unsigned CKE                : 1;
    unsigned SMP                : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned R_W                : 1;
    unsigned I2C_START          : 1;
    unsigned I2C_STOP           : 1;
    unsigned D_A                : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned I2C_READ           : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned I2C_DAT            : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned NOT_W              : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned NOT_A              : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned NOT_WRITE          : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned NOT_ADDRESS        : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned READ_WRITE         : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned DATA_ADDRESS       : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned R                  : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned D                  : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };
  } __SSPSTATbits_t;

extern __at(0x0FC7) volatile __SSPSTATbits_t SSPSTATbits;

#define _BF                     0x01
#define _UA                     0x02
#define _R_NOT_W                0x04
#define _R_W                    0x04
#define _I2C_READ               0x04
#define _NOT_W                  0x04
#define _NOT_WRITE              0x04
#define _READ_WRITE             0x04
#define _R                      0x04
#define _S                      0x08
#define _I2C_START              0x08
#define _P                      0x10
#define _I2C_STOP               0x10
#define _D_NOT_A                0x20
#define _D_A                    0x20
#define _I2C_DAT                0x20
#define _NOT_A                  0x20
#define _NOT_ADDRESS            0x20
#define _DATA_ADDRESS           0x20
#define _D                      0x20
#define _CKE                    0x40
#define _SMP                    0x80

//==============================================================================

extern __at(0x0FC8) __sfr SSPADD;
extern __at(0x0FC9) __sfr SSPBUF;

//==============================================================================
//        T2CON Bits

extern __at(0x0FCA) __sfr T2CON;

typedef union
  {
  struct
    {
    unsigned T2CKPS0            : 1;
    unsigned T2CKPS1            : 1;
    unsigned TMR2ON             : 1;
    unsigned T2OUTPS0           : 1;
    unsigned T2OUTPS1           : 1;
    unsigned T2OUTPS2           : 1;
    unsigned T2OUTPS3           : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned T2CKPS             : 2;
    unsigned                    : 6;
    };

  struct
    {
    unsigned                    : 3;
    unsigned T2OUTPS            : 4;
    unsigned                    : 1;
    };
  } __T2CONbits_t;

extern __at(0x0FCA) volatile __T2CONbits_t T2CONbits;

#define _T2CKPS0                0x01
#define _T2CKPS1                0x02
#define _TMR2ON                 0x04
#define _T2OUTPS0               0x08
#define _T2OUTPS1               0x10
#define _T2OUTPS2               0x20
#define _T2OUTPS3               0x40

//==============================================================================

extern __at(0x0FCB) __sfr PR2;
extern __at(0x0FCC) __sfr TMR2;

//==============================================================================
//        T1CON Bits

extern __at(0x0FCD) __sfr T1CON;

typedef union
  {
  struct
    {
    unsigned TMR1ON             : 1;
    unsigned TMR1CS             : 1;
    unsigned NOT_T1SYNC         : 1;
    unsigned T1OSCEN            : 1;
    unsigned T1CKPS0            : 1;
    unsigned T1CKPS1            : 1;
    unsigned T1RUN              : 1;
    unsigned RD16               : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned T1INSYNC           : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned T1SYNC             : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned                    : 4;
    unsigned T1CKPS             : 2;
    unsigned                    : 2;
    };
  } __T1CONbits_t;

extern __at(0x0FCD) volatile __T1CONbits_t T1CONbits;

#define _TMR1ON                 0x01
#define _TMR1CS                 0x02
#define _NOT_T1SYNC             0x04
#define _T1INSYNC               0x04
#define _T1SYNC                 0x04
#define _T1OSCEN                0x08
#define _T1CKPS0                0x10
#define _T1CKPS1                0x20
#define _T1RUN                  0x40
#define _RD16                   0x80

//==============================================================================

extern __at(0x0FCE) __sfr TMR1;
extern __at(0x0FCE) __sfr TMR1L;
extern __at(0x0FCF) __sfr TMR1H;

//==============================================================================
//        RCON Bits

extern __at(0x0FD0) __sfr RCON;

typedef union
  {
  struct
    {
    unsigned NOT_BOR            : 1;
    unsigned NOT_POR            : 1;
    unsigned NOT_PD             : 1;
    unsigned NOT_TO             : 1;
    unsigned NOT_RI             : 1;
    unsigned                    : 1;
    unsigned SBOREN             : 1;
    unsigned IPEN               : 1;
    };

  struct
    {
    unsigned BOR                : 1;
    unsigned POR                : 1;
    unsigned PD                 : 1;
    unsigned TO                 : 1;
    unsigned RI                 : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };
  } __RCONbits_t;

extern __at(0x0FD0) volatile __RCONbits_t RCONbits;

#define _NOT_BOR                0x01
#define _BOR                    0x01
#define _NOT_POR                0x02
#define _POR                    0x02
#define _NOT_PD                 0x04
#define _PD                     0x04
#define _NOT_TO                 0x08
#define _TO                     0x08
#define _NOT_RI                 0x10
#define _RI                     0x10
#define _SBOREN                 0x40
#define _IPEN                   0x80

//==============================================================================


//==============================================================================
//        WDTCON Bits

extern __at(0x0FD1) __sfr WDTCON;

typedef union
  {
  struct
    {
    unsigned SWDTEN             : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned SWDTE              : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };
  } __WDTCONbits_t;

extern __at(0x0FD1) volatile __WDTCONbits_t WDTCONbits;

#define _SWDTEN                 0x01
#define _SWDTE                  0x01

//==============================================================================


//==============================================================================
//        HLVDCON Bits

extern __at(0x0FD2) __sfr HLVDCON;

typedef union
  {
  struct
    {
    unsigned HLVDL0             : 1;
    unsigned HLVDL1             : 1;
    unsigned HLVDL2             : 1;
    unsigned HLVDL3             : 1;
    unsigned HLVDEN             : 1;
    unsigned IRVST              : 1;
    unsigned                    : 1;
    unsigned VDIRMAG            : 1;
    };

  struct
    {
    unsigned LVDL0              : 1;
    unsigned LVDL1              : 1;
    unsigned LVDL2              : 1;
    unsigned LVDL3              : 1;
    unsigned LVDEN              : 1;
    unsigned BGST               : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned LVV0               : 1;
    unsigned LVV1               : 1;
    unsigned LVV2               : 1;
    unsigned LVV3               : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned LVV                : 4;
    unsigned                    : 4;
    };

  struct
    {
    unsigned HLVDL              : 4;
    unsigned                    : 4;
    };

  struct
    {
    unsigned LVDL               : 4;
    unsigned                    : 4;
    };
  } __HLVDCONbits_t;

extern __at(0x0FD2) volatile __HLVDCONbits_t HLVDCONbits;

#define _HLVDL0                 0x01
#define _LVDL0                  0x01
#define _LVV0                   0x01
#define _HLVDL1                 0x02
#define _LVDL1                  0x02
#define _LVV1                   0x02
#define _HLVDL2                 0x04
#define _LVDL2                  0x04
#define _LVV2                   0x04
#define _HLVDL3                 0x08
#define _LVDL3                  0x08
#define _LVV3                   0x08
#define _HLVDEN                 0x10
#define _LVDEN                  0x10
#define _IRVST                  0x20
#define _BGST                   0x20
#define _VDIRMAG                0x80

//==============================================================================


//==============================================================================
//        LVDCON Bits

extern __at(0x0FD2) __sfr LVDCON;

typedef union
  {
  struct
    {
    unsigned HLVDL0             : 1;
    unsigned HLVDL1             : 1;
    unsigned HLVDL2             : 1;
    unsigned HLVDL3             : 1;
    unsigned HLVDEN             : 1;
    unsigned IRVST              : 1;
    unsigned                    : 1;
    unsigned VDIRMAG            : 1;
    };

  struct
    {
    unsigned LVDL0              : 1;
    unsigned LVDL1              : 1;
    unsigned LVDL2              : 1;
    unsigned LVDL3              : 1;
    unsigned LVDEN              : 1;
    unsigned BGST               : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned LVV0               : 1;
    unsigned LVV1               : 1;
    unsigned LVV2               : 1;
    unsigned LVV3               : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned LVV                : 4;
    unsigned                    : 4;
    };

  struct
    {
    unsigned HLVDL              : 4;
    unsigned                    : 4;
    };

  struct
    {
    unsigned LVDL               : 4;
    unsigned                    : 4;
    };
  } __LVDCONbits_t;

extern __at(0x0FD2) volatile __LVDCONbits_t LVDCONbits;

#define _LVDCON_HLVDL0          0x01
#define _LVDCON_LVDL0           0x01
#define _LVDCON_LVV0            0x01
#define _LVDCON_HLVDL1          0x02
#define _LVDCON_LVDL1           0x02
#define _LVDCON_LVV1            0x02
#define _LVDCON_HLVDL2          0x04
#define _LVDCON_LVDL2           0x04
#define _LVDCON_LVV2            0x04
#define _LVDCON_HLVDL3          0x08
#define _LVDCON_LVDL3           0x08
#define _LVDCON_LVV3            0x08
#define _LVDCON_HLVDEN          0x10
#define _LVDCON_LVDEN           0x10
#define _LVDCON_IRVST           0x20
#define _LVDCON_BGST            0x20
#define _LVDCON_VDIRMAG         0x80

//==============================================================================


//==============================================================================
//        OSCCON Bits

extern __at(0x0FD3) __sfr OSCCON;

typedef union
  {
  struct
    {
    unsigned SCS0               : 1;
    unsigned SCS1               : 1;
    unsigned IOFS               : 1;
    unsigned OSTS               : 1;
    unsigned IRCF0              : 1;
    unsigned IRCF1              : 1;
    unsigned IRCF2              : 1;
    unsigned IDLEN              : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned FLTS               : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned SCS                : 2;
    unsigned                    : 6;
    };

  struct
    {
    unsigned                    : 4;
    unsigned IRCF               : 3;
    unsigned                    : 1;
    };
  } __OSCCONbits_t;

extern __at(0x0FD3) volatile __OSCCONbits_t OSCCONbits;

#define _SCS0                   0x01
#define _SCS1                   0x02
#define _IOFS                   0x04
#define _FLTS                   0x04
#define _OSTS                   0x08
#define _IRCF0                  0x10
#define _IRCF1                  0x20
#define _IRCF2                  0x40
#define _IDLEN                  0x80

//==============================================================================


//==============================================================================
//        T0CON Bits

extern __at(0x0FD5) __sfr T0CON;

typedef union
  {
  struct
    {
    unsigned T0PS0              : 1;
    unsigned T0PS1              : 1;
    unsigned T0PS2              : 1;
    unsigned PSA                : 1;
    unsigned T0SE               : 1;
    unsigned T0CS               : 1;
    unsigned T08BIT             : 1;
    unsigned TMR0ON             : 1;
    };

  struct
    {
    unsigned T0PS               : 3;
    unsigned                    : 5;
    };
  } __T0CONbits_t;

extern __at(0x0FD5) volatile __T0CONbits_t T0CONbits;

#define _T0PS0                  0x01
#define _T0PS1                  0x02
#define _T0PS2                  0x04
#define _PSA                    0x08
#define _T0SE                   0x10
#define _T0CS                   0x20
#define _T08BIT                 0x40
#define _TMR0ON                 0x80

//==============================================================================

extern __at(0x0FD6) __sfr TMR0;
extern __at(0x0FD6) __sfr TMR0L;
extern __at(0x0FD7) __sfr TMR0H;

//==============================================================================
//        STATUS Bits

extern __at(0x0FD8) __sfr STATUS;

typedef struct
  {
  unsigned C                    : 1;
  unsigned DC                   : 1;
  unsigned Z                    : 1;
  unsigned OV                   : 1;
  unsigned N                    : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  } __STATUSbits_t;

extern __at(0x0FD8) volatile __STATUSbits_t STATUSbits;

#define _C                      0x01
#define _DC                     0x02
#define _Z                      0x04
#define _OV                     0x08
#define _N                      0x10

//==============================================================================

extern __at(0x0FD9) __sfr FSR2L;
extern __at(0x0FDA) __sfr FSR2H;
extern __at(0x0FDB) __sfr PLUSW2;
extern __at(0x0FDC) __sfr PREINC2;
extern __at(0x0FDD) __sfr POSTDEC2;
extern __at(0x0FDE) __sfr POSTINC2;
extern __at(0x0FDF) __sfr INDF2;
extern __at(0x0FE0) __sfr BSR;
extern __at(0x0FE1) __sfr FSR1L;
extern __at(0x0FE2) __sfr FSR1H;
extern __at(0x0FE3) __sfr PLUSW1;
extern __at(0x0FE4) __sfr PREINC1;
extern __at(0x0FE5) __sfr POSTDEC1;
extern __at(0x0FE6) __sfr POSTINC1;
extern __at(0x0FE7) __sfr INDF1;
extern __at(0x0FE8) __sfr WREG;
extern __at(0x0FE9) __sfr FSR0L;
extern __at(0x0FEA) __sfr FSR0H;
extern __at(0x0FEB) __sfr PLUSW0;
extern __at(0x0FEC) __sfr PREINC0;
extern __at(0x0FED) __sfr POSTDEC0;
extern __at(0x0FEE) __sfr POSTINC0;
extern __at(0x0FEF) __sfr INDF0;

//==============================================================================
//        INTCON3 Bits

extern __at(0x0FF0) __sfr INTCON3;

typedef union
  {
  struct
    {
    unsigned INT1IF             : 1;
    unsigned INT2IF             : 1;
    unsigned INT3IF             : 1;
    unsigned INT1IE             : 1;
    unsigned INT2IE             : 1;
    unsigned INT3IE             : 1;
    unsigned INT1IP             : 1;
    unsigned INT2IP             : 1;
    };

  struct
    {
    unsigned INT1F              : 1;
    unsigned INT2F              : 1;
    unsigned INT3F              : 1;
    unsigned INT1E              : 1;
    unsigned INT2E              : 1;
    unsigned INT3E              : 1;
    unsigned INT1P              : 1;
    unsigned INT2P              : 1;
    };
  } __INTCON3bits_t;

extern __at(0x0FF0) volatile __INTCON3bits_t INTCON3bits;

#define _INT1IF                 0x01
#define _INT1F                  0x01
#define _INT2IF                 0x02
#define _INT2F                  0x02
#define _INT3IF                 0x04
#define _INT3F                  0x04
#define _INT1IE                 0x08
#define _INT1E                  0x08
#define _INT2IE                 0x10
#define _INT2E                  0x10
#define _INT3IE                 0x20
#define _INT3E                  0x20
#define _INT1IP                 0x40
#define _INT1P                  0x40
#define _INT2IP                 0x80
#define _INT2P                  0x80

//==============================================================================


//==============================================================================
//        INTCON2 Bits

extern __at(0x0FF1) __sfr INTCON2;

typedef union
  {
  struct
    {
    unsigned RBIP               : 1;
    unsigned INT3IP             : 1;
    unsigned TMR0IP             : 1;
    unsigned INTEDG3            : 1;
    unsigned INTEDG2            : 1;
    unsigned INTEDG1            : 1;
    unsigned INTEDG0            : 1;
    unsigned NOT_RBPU           : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned INT3P              : 1;
    unsigned T0IP               : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned RBPU               : 1;
    };
  } __INTCON2bits_t;

extern __at(0x0FF1) volatile __INTCON2bits_t INTCON2bits;

#define _RBIP                   0x01
#define _INT3IP                 0x02
#define _INT3P                  0x02
#define _TMR0IP                 0x04
#define _T0IP                   0x04
#define _INTEDG3                0x08
#define _INTEDG2                0x10
#define _INTEDG1                0x20
#define _INTEDG0                0x40
#define _NOT_RBPU               0x80
#define _RBPU                   0x80

//==============================================================================


//==============================================================================
//        INTCON Bits

extern __at(0x0FF2) __sfr INTCON;

typedef union
  {
  struct
    {
    unsigned RBIF               : 1;
    unsigned INT0IF             : 1;
    unsigned TMR0IF             : 1;
    unsigned RBIE               : 1;
    unsigned INT0IE             : 1;
    unsigned TMR0IE             : 1;
    unsigned PEIE_GIEL          : 1;
    unsigned GIE_GIEH           : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned INT0F              : 1;
    unsigned T0IF               : 1;
    unsigned                    : 1;
    unsigned INT0E              : 1;
    unsigned T0IE               : 1;
    unsigned PEIE               : 1;
    unsigned GIE                : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned GIEL               : 1;
    unsigned GIEH               : 1;
    };
  } __INTCONbits_t;

extern __at(0x0FF2) volatile __INTCONbits_t INTCONbits;

#define _RBIF                   0x01
#define _INT0IF                 0x02
#define _INT0F                  0x02
#define _TMR0IF                 0x04
#define _T0IF                   0x04
#define _RBIE                   0x08
#define _INT0IE                 0x10
#define _INT0E                  0x10
#define _TMR0IE                 0x20
#define _T0IE                   0x20
#define _PEIE_GIEL              0x40
#define _PEIE                   0x40
#define _GIEL                   0x40
#define _GIE_GIEH               0x80
#define _GIE                    0x80
#define _GIEH                   0x80

//==============================================================================

extern __at(0x0FF3) __sfr PROD;
extern __at(0x0FF3) __sfr PRODL;
extern __at(0x0FF4) __sfr PRODH;
extern __at(0x0FF5) __sfr TABLAT;
extern __at(0x0FF6) __sfr TBLPTR;
extern __at(0x0FF6) __sfr TBLPTRL;
extern __at(0x0FF7) __sfr TBLPTRH;
extern __at(0x0FF8) __sfr TBLPTRU;
extern __at(0x0FF9) __sfr PC;
extern __at(0x0FF9) __sfr PCL;
extern __at(0x0FFA) __sfr PCLATH;
extern __at(0x0FFB) __sfr PCLATU;

//==============================================================================
//        STKPTR Bits

extern __at(0x0FFC) __sfr STKPTR;

typedef union
  {
  struct
    {
    unsigned STKPTR0            : 1;
    unsigned STKPTR1            : 1;
    unsigned STKPTR2            : 1;
    unsigned STKPTR3            : 1;
    unsigned STKPTR4            : 1;
    unsigned                    : 1;
    unsigned STKUNF             : 1;
    unsigned STKFUL             : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned STKOVF             : 1;
    };

  struct
    {
    unsigned STKPTR             : 5;
    unsigned                    : 3;
    };
  } __STKPTRbits_t;

extern __at(0x0FFC) volatile __STKPTRbits_t STKPTRbits;

#define _STKPTR0                0x01
#define _STKPTR1                0x02
#define _STKPTR2                0x04
#define _STKPTR3                0x08
#define _STKPTR4                0x10
#define _STKUNF                 0x40
#define _STKFUL                 0x80
#define _STKOVF                 0x80

//==============================================================================

extern __at(0x0FFD) __sfr TOS;
extern __at(0x0FFD) __sfr TOSL;
extern __at(0x0FFE) __sfr TOSH;
extern __at(0x0FFF) __sfr TOSU;

//==============================================================================
//
//        Configuration Bits
//
//==============================================================================

#define __CONFIG1H              0x300001
#define __CONFIG2L              0x300002
#define __CONFIG2H              0x300003
#define __CONFIG3H              0x300005
#define __CONFIG4L              0x300006
#define __CONFIG5L              0x300008

//----------------------------- CONFIG1H Options -------------------------------

#define _OSC_LP_1H              0xF0    // LP oscillator.
#define _OSC_XT_1H              0xF1    // XT oscillator.
#define _OSC_HS_1H              0xF2    // HS oscillator.
#define _OSC_RC_1H              0xF3    // External RC oscillator, CLKO function on RA6.
#define _OSC_EC_1H              0xF4    // EC oscillator, CLKO function on RA6.
#define _OSC_ECIO_1H            0xF5    // EC oscillator, port function on RA6.
#define _OSC_HSPLL_1H           0xF6    // HS oscillator, PLL enabled (clock frequency = 4 x FOSC1).
#define _OSC_RCIO_1H            0xF7    // External RC oscillator, port function on RA6.
#define _OSC_INTIO67_1H         0xF8    // Internal oscillator block, port function on RA6 and RA7.
#define _OSC_INTIO7_1H          0xF9    // Internal oscillator block, CLKO function on RA6, port function on RA7.
#define _FCMEN_OFF_1H           0xBF    // Fail-Safe Clock Monitor disabled.
#define _FCMEN_ON_1H            0xFF    // Fail-Safe Clock Monitor enabled.
#define _IESO_OFF_1H            0x7F    // Oscillator Switchover mode disabled.
#define _IESO_ON_1H             0xFF    // Oscillator Switchover mode enabled.

//----------------------------- CONFIG2L Options -------------------------------

#define _PWRT_ON_2L             0xFE    // PWRT enabled.
#define _PWRT_OFF_2L            0xFF    // PWRT disabled.
#define _BOREN_OFF_2L           0xF9    // Brown-out Reset disabled in hardware and software.
#define _BOREN_ON_2L            0xFB    // Brown-out Reset enabled and controlled by software (SBOREN is enabled).
#define _BOREN_NOSLP_2L         0xFD    // Brown-out Reset enabled in hardware only and disabled in Sleep mode (SBOREN is disabled).
#define _BOREN_SBORDIS_2L       0xFF    // Brown-out Reset enabled in hardware only (SBOREN is disabled).
#define _BORV_0_2L              0xE7    // VBOR set to 4.6V.
#define _BORV_1_2L              0xEF    // VBOR set to 4.3V.
#define _BORV_2_2L              0xF7    // VBOR set to 2.8V.
#define _BORV_3_2L              0xFF    // VBOR set to 2.1V.

//----------------------------- CONFIG2H Options -------------------------------

#define _WDT_OFF_2H             0xFE    // WDT disabled (control is placed on the SWDTEN bit).
#define _WDT_ON_2H              0xFF    // WDT enabled.
#define _WDTPS_1_2H             0xE1    // 1:1.
#define _WDTPS_2_2H             0xE3    // 1:2.
#define _WDTPS_4_2H             0xE5    // 1:4.
#define _WDTPS_8_2H             0xE7    // 1:8.
#define _WDTPS_16_2H            0xE9    // 1:16.
#define _WDTPS_32_2H            0xEB    // 1:32.
#define _WDTPS_64_2H            0xED    // 1:64.
#define _WDTPS_128_2H           0xEF    // 1:128.
#define _WDTPS_256_2H           0xF1    // 1:256.
#define _WDTPS_512_2H           0xF3    // 1:512.
#define _WDTPS_1024_2H          0xF5    // 1:1024.
#define _WDTPS_2048_2H          0xF7    // 1:2048.
#define _WDTPS_4096_2H          0xF9    // 1:4096.
#define _WDTPS_8192_2H          0xFB    // 1:8192.
#define _WDTPS_16384_2H         0xFD    // 1:16384.
#define _WDTPS_32768_2H         0xFF    // 1:32768.

//----------------------------- CONFIG3H Options -------------------------------

#define _CCP2MX_PORTBE_3H       0xFE    // CCP2 input/output is multiplexed with RE7.
#define _CCP2MX_PORTC_3H        0xFF    // CCP2 input/output is multiplexed with RC1.
#define _LPT1OSC_OFF_3H         0xFB    // Timer1 configured for higher power operation.
#define _LPT1OSC_ON_3H          0xFF    // Timer1 configured for low-power operation.
#define _MCLRE_OFF_3H           0x7F    // RG5 input pin enabled; MCLR disabled.
#define _MCLRE_ON_3H            0xFF    // MCLR pin enabled; RG5 input pin disabled.

//----------------------------- CONFIG4L Options -------------------------------

#define _STVREN_OFF_4L          0xFE    // Stack full/underflow will not cause Reset.
#define _STVREN_ON_4L           0xFF    // Stack full/underflow will cause Reset.
#define _XINST_OFF_4L           0xBF    // Instruction set extension and Indexed Addressing mode disabled (Legacy mode).
#define _XINST_ON_4L            0xFF    // Instruction set extension and Indexed Addressing mode enabled.
#define _DEBUG_ON_4L            0x7F    // Background debugger enabled, RB6 and RB7 are dedicated to In-Circuit Debug.
#define _DEBUG_OFF_4L           0xFF    // Background debugger disabled, RB6 and RB7 configured as general purpose I/O pins.

//----------------------------- CONFIG5L Options -------------------------------

#define _CP_ON_5L               0xFE    // Program memory block (000000-003FFFh) code-protected.
#define _CP_OFF_5L              0xFF    // Program memory block (000000-003FFFh) not code-protected.

//==============================================================================

#define __DEVID1                0x3FFFFE
#define __DEVID2                0x3FFFFF

#define __IDLOC0                0x200000
#define __IDLOC1                0x200001
#define __IDLOC2                0x200002
#define __IDLOC3                0x200003
#define __IDLOC4                0x200004
#define __IDLOC5                0x200005
#define __IDLOC6                0x200006
#define __IDLOC7                0x200007

#endif // #ifndef __PIC18F6490_H__
