#!/usr/bin/perl -w

# RLE compression:
# 00-7F = copy next 01H..80H bytes
# 80-FF = repeat next byte 02H..80H times
# FF = end of data (removes need for loading BC)

my $line;

sub flush_bytes
{
  if (length $line)
  {
    printf "        HEX    %s\n", $line;
    $line = "";
  }
}


sub send_byte
{
  my ($byte) = @_;

  my $str;

  $str = sprintf " %.2X", $byte;

  $line .= $str;
  if (length $line > 3*15)
  {
    flush_bytes;
  }
}


sub rle_file
{
  my ($file) = @_;
  my $buf;
  my $i;
  my $c;
  my $len;
  my $start;

  open (INFILE,"< ${file}") or die "Can't open input file ${file}!";

  read INFILE, $buf, 65536;

  close INFILE;

$| = 1;

#  printf "; file %s length %d\n\n", $file, length $buf;

  printf "RLE%s\n", $file;

  $line = "";
  $i = 0;
  while ($i < length $buf)
  {
    $c = substr $buf, $i, 1;
    $len = 1;

    # special case at last byte
    if ($i == length($buf) - 1)
    {
      send_byte 0x00;
      send_byte ord($c);
      $i++;
    }

    # if next two bytes are identical, look for a repeat run
    elsif ($c eq substr($buf, $i+1, 1))
    {
#printf " : %.2X %.2X", ord($c), ord(substr($buf, $i+1, 1));
      $i++; $i++;
      $len++;
      while ($len < 0x80 && $i < length($buf) && $c eq substr($buf, $i, 1))
      {
#printf " %.2X", ord(substr($buf, $i, 1));
        $i++;
        $len++;
      }
#printf " len = 0x%.2X, byte = 0x%.2X\n", $len, ord($c);
      send_byte $len + 0x7E;
      send_byte ord($c);
#flush_bytes;
    }

    # if next two bytes were not identical, look for a long run
    else
    {
      $start = $i;
#printf " : %.2X", ord($c);
      $i++;
      $c = substr $buf, $i, 1;
      while ($len < 0x80 && $i < length($buf) && $c ne substr($buf, $i+1, 1))
      {
#printf " %.2X", ord(substr($buf, $i, 1));
        $c = substr $buf, $i+1, 1;
        $i++;
        $len++;
      }
#printf " len = 0x%.2X\n", $len, ord($c);

      send_byte $len-1;
      while ($start < $i)
      {
        send_byte ord(substr($buf, $start, 1));
        $start++;
      }
#flush_bytes;
    }
  }

  send_byte 0xFF;
  flush_bytes;

  print "\n";
}


rle_file "391E";
rle_file "547C";
rle_file "596C";