; Girls Garden for SG-1000

    IF      COLECO
    ELSE
    ENDIF

	CPU	Z80

	MACRO   DEFAULT,SYM,VAL
	IF	..UNDEF SYM
SYM	SET	VAL
	ENDIF
	ENDM

	DEFAULT COLECO,0	; assemble for Colecovision
;	DEFAULT TEST,0		; test stuff
	DEFAULT HAX,0		; turn on hacks (coleco only)
	DEFAULT OPT,0		; optimize code
	DEFAULT SEGA,1		; sega logo in titile screen
	DEFAULT RLE,0
	DEFAULT	PIX,0
	DEFAULT	DATE,0

    IF COLECO
	OPT	NOSYM
SEGA	SET	0
OPT	SET	1
RLE SET 1
pix set 1
    ELSE
	OPT	NOSYM
HAX	SET	0
    ENDIF

	DEFAULT LIVES,3
	DEFAULT HONEY,5

;-----------------------------------------------------------------------

; 20H blank
; 21H "!"
_copy	EQU	22H	; copyright symbol
; 23-26 "SEGA" logo letters
; 27-2A "1994" copyright year
; 30H-39H "0"-"9"
__	EQU	20H
_EXCL	EQU	21H
_A	EQU	2BH
_B	EQU	2CH
_C	EQU	2DH
_D	EQU	2EH
_E	EQU	2FH
_G	EQU	3AH
_H	EQU	3BH
_I	EQU	3CH
_L	EQU	3DH
_M	EQU	3EH
_N	EQU	3FH
_O	EQU	40H
_P	EQU	41H
_R	EQU	42H
_S	EQU	43H
_T	EQU	44H
_U	EQU	45H
_V	EQU	46H
_dash	EQU	47H
_F	EQU	48H

  if sega
  else
_J	EQU	23H
_K	EQU	24H
_Q	EQU	25H
_W	EQU	26H
_X	EQU	27H
_Y	EQU	28H
_Z	EQU	29H
  endif

;-----------------------------------------------------------------------

; RAM

    IF      COLECO
	ORG     7000H
KPLAST	DS	2	; last value read from a keypad
NMIDIS	DS	1	; true if interrupts are supposed to be disabled
NMICNT	DS	1	; counter to detect an interrupt has happened
NMILAST	DS	1	; true if an interrupt has occurred
  if hax
CHTFLG	DS	1	; true if cheats have been enabled
CHTPTR	DS	2	; pointer to current position in cheat code
  endif
    ELSE
	ORG	0C000H
    ENDIF

DC000	DS	7	; bit flags - bit 0 = something to do with keyboard
DC001	EQU	DC000+1	; high score (3 bytes BCD)
DC004	EQU	DC000+4	; current score (3 bytes BCD)
DC007	DS	3	; bonus score? (3 bytes BCD)

DC00A	DS	1	; 1,A	; round number (BCD)
DC00B	DS	2	; 2
DC00D	DS	1	; 1
DC00E	DS	1	; 1,A	; remaining honey (BCD)
DC00F	DS	1	; 1	; remaining lives ("love")
DC010	DS	1	; 1	; pause button debounce timer
DC011	DS	1	; 1	; pause flag
DC012	DS	1	; 1	; non-zero if in title screen
DC013	DS	1	; 1	; current offset to attract mode input
DC014	DS	2	; 2	; attract mode timer
DC016	DS	1	; 1
DC017	DS	1	; 1

; block from DC018 to DC173 is cleared as a group
DC018	DS	1	; 1,A	; input read from joystick, 0 = button pressed
; bits in DC018
B_1U	EQU	0	; player 1 up
B_1D	EQU	1	; player 1 down
B_1L	EQU	2	; player 1 left
B_1R	EQU	3	; player 1 right
B_1A	EQU	4	; player 1 left trigger
B_1B	EQU	5	; player 1 right trigger
;B_2U	EQU	6	; player 2 up
;B_2D	EQU	7	; player 2 down

DC019	DS	1	; 1,A	; time remaining?
DC01A	DS	1	; 1
DC01B	DS	1	; 1
	DS	1
DC01D	DS	1	; 1
DC01E	DS	1	; 1
DC01F	DS	1	; 1
DC020	DS	1	; 1
DC021	DS	1	; 1
DC022	DS	1	; 1
DC023	DS	1	; 1
DC024	DS	1	; 1
	DS	1

; C026-C075 is a group, sprite attribute table data for 20 sprites
; 4 bytes per entry: Y, X, pattern, color
DC026	DS	4	; 1,A	; sprite 0
DC027	EQU	DC026+1	; 1
DC028	EQU	DC026+2	; 1
DC029	EQU	DC026+3	; 1

DC02A	DS	4	; 1	; sprite 1
DC02B	EQU	DC02A+1	; 1
DC02C	EQU	DC02A+2	; 1
DC02D	EQU	DC02A+3	; 1

DC02E	DS	4	; 1	; sprite 2
DC02F	EQU	DC02E+1	; 1
DC030	EQU	DC02E+2	; 1
DC031	EQU	DC02E+3	; 1

DC032	DS	4	; 1	; sprite 3
DC033	EQU	DC032+1	; 1
DC034	EQU	DC032+2	; 1
DC035	EQU	DC032+3	; 1

DC036	DS	4	; 1,A,IX; sprite 4
DC037	EQU	DC036+1	; 1
DC038	EQU	DC036+2	; 1

DC03A	DS	4	; 1	; sprite 5
DC03B	EQU	DC03A+1	; 1
DC03C	EQU	DC03A+2	; 1

DC03E	DS	4	; A,IX	; sprite 6
DC03F	EQU	DC03E+1	; 1
DC040	EQU	DC03E+2	; 1

	DS	4	; DC042	; sprite 7

DC046	DS	4	; A	; sprite 8
DC048	EQU	DC046+2	; 1
DC049	EQU	DC046+3	; 1

	DS	4	; DC04A	; sprite 9

DC04E	DS	4	; 1	; sprite 10
DC04F	EQU	DC04E+1	; 1
DC050	EQU	DC04E+2	; 1

	DS	4	; DC052	; sprite 11
	DS	4	; DC056	; sprite 12

DC05A	DS	4	; 1	; sprite 13
DC05B	EQU	DC05A+1	; 1
DC05C	EQU	DC05A+2	; 1
DC05D	EQU	DC05A+3	; 1

DC05E	DS	4	; 1	; sprite 14
DC05F	EQU	DC05E+1	; 1
DC060	EQU	DC05E+2	; 1
DC061	EQU	DC05E+3	; 1

DC062	DS	4	; 1,A	; sprite 15
DC063	EQU	DC062+1	; 1
DC064	EQU	DC062+2	; 1
DC065	EQU	DC062+3	; 1

DC066	DS	4	; A	; sprite 16
DC067	EQU	DC066+1	; A

	DS	4	; DC06A	; sprite 17

DC06F	EQU	$+1	; A
	DS	4	; DC06E	; sprite 18

	DS	4	; DC072	; sprite 19

NC026	EQU	$-DC026	; end of block starting at DC026

	DS	1
DC077	DS	1	; 1
DC078	DS	1	; 1
DC079	DS	1	; 1
DC07A	DS	1	; 1
DC07B	DS	1	; 1
	DS	1
DC07D	DS	1	; 1	; grass scroll horizontal position
DC07E	DS	1	; 1	; grass scroll delay counter
DC07F	DS	1	; 1	; grass scroll request flag
DC080	DS	1	; 1	; dropping honey flag (for when holding button down)
DC081	DS	1	; 1	; hills scroll request flag
DC082	DS	1	; 1	; hills scroll delay counter
DC083	DS	1	; 1	; hills scroll position
DC084	DS	1	; 1	; hills scroll vertical flag?
DC085	DS	10	; A,IX	; honey position list
NC085	EQU	$-DC085
DC08F	DS	1	; 1	; "hit obstacle" flag
DC090	DS	1	; 1
DC091	DS	1	; 1
DC092	DS	1	; 1
DC093	DS	1	; 1
DC094	DS	2	; 2
DC096	DS	2	; 2
DC098	DS	1	; 1
DC099	DS	1	; 1
DC09A	DS	1	; A,IX	; block 16H
DC09B	DS	1	; A
	DS	18
DC0AE	DS	1	; 1,A
DC0AF	DS	1	; 1,A
	DS	10
DC0BA	DS	1	; 1
DC0BB	DS	1	; 1
DC0BC	DS	2	; 2
DC0BE	DS	1	; 1	; count of flowers picked
DC0BF	DS	1	; 1
DC0C0	DS	1	; 1
DC0C1	DS	1	; 1	; 10 flowers picked flag
DC0C2	DS	1	; 1
DC0C3	DS	1	; 1
DC0C4	DS	1	; 1
DC0C5	DS	2	; 2
DC0C7	DS	1	; 1
DC0C8	DS	1	; 1
DC0C9	DS	1	; 1
DC0CA	DS	1	; 1
DC0CB	DS	1	; 1
DC0CC	DS	1	; 1
DC0CD	DS	1	; 1
DC0CE	DS	1	; 1
DC0CF	DS	1	; 1	; non-zero if in challenge level
DC0D0	DS	1	; 1
DC0D1	DS	1	; 1
DC0D2	DS	1	; 1
DC0D3	DS	1	; 1
DC0D4	DS	1	; 1
DC0D5	DS	1	; 1,A
DC0D6	DS	1	; 1
DC0D7	DS	1	; 1	; power-up ID
DC0D8	DS	1	; 1	; counter for clock power-up
DC0D9	DS	1	; 1,A
DC0DA	DS	1	; 1,A
DC0DB	DS	1	; 1,A
DC0DC	DS	1	; 1,A
DC0DD	DS	1	; 1
DC0DE	DS	1	; 1,A
DC0DF	DS	1	; 1
DC0E0	DS	1	; 1,A
DC0E1	DS	1	; A
DC0E2	DS	1	; 1,A
DC0E3	DS	1	; 1,A
DC0E4	DS	1	; 1,A
DC0E5	DS	1	; 1,A
DC0E6	DS	1	; 1,A
DC0E7	DS	1	; 1,A
	DS	12
DC0F4	DS	1	; 1,A
	DS	4
DC0F9	DS	1	; 1,A
	DS	4
DC0FE	DS	1	; 1,A
	DS	3
DC102	DS	1	; A
DC103	DS	1	; 1,A
	DS	4
DC108	DS	1	; 1,A
	DS	4
DC10D	DS	1	; 1,A
	DS	4
DC112	DS	1	; 1,A
	DS	4
DC117	DS	1	; A
	DS	4
DC11C	DS	1	; 1,A
DC11D	DS	1	; A,IY
	DS	3
DC121	DS	1	; A,IX
DC122	DS	1	; IY
	DS	8
DC12B	DS	1	; A,IX
DC12C	DS	1	; IX
	DS	8
DC135	DS	1	; 1,A
	DS	4
DC13A	DS	1	; A,IX
	DS	19
DC14E	DS	1	; 1,A,IX
DC14F	DS	1	; A
	DS	3
DC153	DS	1	; A
	DS	4
DC158	DS	1	; 1,A
	DS	4
DC15D	DS	1	; 1,A
	DS	4
DC162	DS	1	; 1,A
DC163	DS	1	; 1,A
DC164	DS	1	; 1
DC165	DS	1	; 1
DC166	DS	1	; 1,A
	DS	1
DC168	DS	1	; 1
DC169	DS	1	; 1
DC16A	DS	1	; 1
DC16B	DS	2	; 2
DC16D	DS	2	; 2
DC16F	DS	2	; 2
DC171	DS	2	; 2
NC018	EQU	$-DC018	; end of block starting at DC018

; unused memory here?
	DS	8DH

DC200	DS	1	; 1,A - song ID to play?
DC201	DS	1	; 1,A - sound channel enable/disable flags?
DC202	DS	1	; 1
	DS	1

; sound channel control data, all one block
SCHNSZ  EQU	1CH	; size of one sound channel block
NSCHN	EQU	6
DC204	DS	SCHNSZ*NSCHN	; A,IX - channels 1, 2, 3
DC258	EQU	DC204+SCHNSZ*3	; A - channel 4
DC274	EQU	DC204+SCHNSZ*4	; A	; channels 5, 6
NC204	EQU	$-DC204	; A8H

	DS	SCHNSZ*2 ; C2AC - 2 more sound channel blocks used by L73CD?

RAMEND  EQU	$	; C2E4 - last known RAM used before stack

; unknown space used between here and stack

    IF      COLECO
STACK	EQU	73FFH	; top of stack
    ELSE
STACK	EQU	0C3FFH	; top of stack
    ENDIF

;-----------------------------------------------------------------------

; VDP addresses
PT	EQU	0000H	; pattern table          0000-17FF
SPT	EQU	1800H	; sprite pattern table   1800-1FFF
CT	EQU	2000H	; color table            2000-37FF
NT	EQU	3800H	; name table             3800-3AFF
SAT	EQU	3F00H	; sprite attribute table 3F00-3F7F

;-----------------------------------------------------------------------

; I/O port addresses
    IF      COLECO
PSG	EQU	0FFH	; PSG write
VDPdata EQU	0BEH	; VDP data read/write
VDPcmd  EQU	0BFH	; VDP command write
VDPstat EQU	0BFH	; VDP status read
Joy1	EQU	0FCH	; joypad 1 = -- 1A -- -- 1U 1R 1D 1L / -- 1B -- -- K3 K2 K1 K0
Joy2	EQU	0FFH	; joypad 2 = -- 2A -- -- 2U 2R 2D 2L / -- 2B -- -- K3 K2 K1 K0
KeySel	EQU	80H	; select keypad
JoySel	EQU	0C0H	; select joystick
KP_hash	EQU	09H
KP_star	EQU	06H
KP_0	EQU	05H
KP_1	EQU	02H
KP_2	EQU	08H
KP_3	EQU	03H
KP_4	EQU	0DH
KP_5	EQU	0CH
KP_6	EQU	01H
KP_7	EQU	0AH
KP_8	EQU	0EH
KP_9	EQU	04H
KP_F3	EQU	07H
KP_F4	EQU	08H
; pause and reset keys
KPpause	EQU	KP_star
KPreset	EQU	KP_hash
    ELSE
PSG	EQU	7FH	; PSG write
VDPdata	EQU	0BEH	; VDP data read/write
VDPcmd	EQU	0BFH	; VDP command write
VDPstat	EQU	0BFH	; VDP status read
Joy1	EQU	0DCH	; joypad 1 = 2D 2U 1B 1A 1R 1L 1D 1U
Joy2	EQU	0DDH	; joypad 2 = xx xx x RES 2B 2A 2R 2L
KeybPtA	EQU	0DCH	; 8255 for keyboard? - data register port A
KeybPtC	EQU	0DEH	; 8255 for keyboard? - data register port C
KeybCtl	EQU	0DFH	; 8255 for keyboard? - control register?
    ENDIF

;-----------------------------------------------------------------------

; Coleco made a bonehead move by putting the VDP interrupt on NMI.
; If you read the VDP status register in an interrupt when any VDP access
; was going on in the main code, it will mess things up in various ways,
; which is why the DI instruction is used in code for Sega consoles.
; Since DI can't be used to disable the NMI interrupt, it needs a flag
; so that the interrupt isn't acknowledged while the VDP is in use,
; and all the EI and DI instructions have to be replaced with a bunch
; of code.

    IF      COLECO
	MACRO	_DI
;	RST	10H
; push af
; in a,(vdpstat)
; pop af
	ENDM	

	MACRO	_EI
	RST	20H
	ENDM

	MACRO	_HALT
	RST	30H
	ENDM
    ELSE
	MACRO	_DI
	DI
	ENDM

	MACRO	_EI
	EI
	ENDM

	MACRO	_HALT
	HALT
	ENDM
    ENDIF

;-----------------------------------------------------------------------

    IF      COLECO
	ORG	8000H

	; ColecoVision cartridge header
;	DW	55AAH		; Cartridge signature bytes (slow start)
	DW	0AA55H		; Cartridge signature bytes (fast start)
	DW	0,0		; No RAM sprite tables
	DW	0		; No VDP_Temp storage
	DW	0		; Controller state table not used
	DW	Main		; Main entry point

	JR	L0008		; RST 08
	NOP
	JP	0000H		; RST 10
	JR	L0018		; RST 18
	NOP
	JR	ENAINT		; RST 20 - enable interrupt routine
	NOP
	JR	L0028		; RST 28
	NOP
	JR	WAITINT		; RST 30 - wait for interrupt routine
	NOP
	JP	0000H		; RST 38 (spinner)
	JP	L02CC		; NMI (VDP interrupt)

	DB	'-/-/----'	; 'WORLD/HELLO/2006'

 if date
	DB	DATE/10000000 + '0'	; date
	DB	(DATE - DATE/10000000*10000000)/1000000 + '0'
	DB	(DATE - DATE/1000000*1000000)/100000 + '0'
	DB	(DATE - DATE/100000*100000)/10000 + '0'
	DB	'-'
	DB	(DATE - DATE/10000*10000)/1000 + '0'
	DB	(DATE - DATE/1000*1000)/100 + '0'
	DB	'-'
	DB	(DATE - DATE/100*100)/10 + '0'
	DB	(DATE - DATE/10*10)/1 + '0'
 endif

WAITINT
	PUSH	AF

	IN	A,(VDPstat)	; acknowledge previous interrupt just in case

	LD	A,(NMICNT)	; get initial NMI count
	LD	C,A
.10
	LD	A,(NMICNT)	; wait for NMI count to change
	CP	C
	JR	Z,.10

	JR	GOTINT

ENAINT
CHECKINT
	PUSH	AF
	PUSH	BC

	LD	A,(NMILAST)	; has an interrupt occurred?
	LD	C,A
	LD	A,(NMICNT)
	CP	C

	POP	BC
	JR	Z,NOINT		; exit if no interrupt

GOTINT
	LD	(NMILAST),A	; update last interrupt count

	LD	A,(NMIDIS)	; is interrupt disabled?
	OR	A
	JR	NZ,ACKINT	; exit if disabled

	JP	VBSTUFF		; do vblank stuff
ACKINT
NOINT
	IN	A,(VDPstat)	; we still need to acknowledge the interrupt
;NOINT
	POP	AF
	RET

    ELSE
	ORG	0000H

    ENDIF

;-----------------------------------------------------------------------

Main	LD	SP,STACK	; initialize stack pointer
	IM	1		; set RST 38H interrupt mode
	_DI			; disable interrupts
    IF      COLECO
	XOR	A
	LD	(NMICNT),A	; clear NMI counter
	INC	A
	LD	(NMIDIS),A
	LD	(NMILAST),A
	LD	(KPLAST),A
	LD	(KPLAST+1),A
    ENDIF
	JR	L0078

;-----------------------------------------------------------------------

; RST 08H - write data to VDP: HL=data, DE=VRAM address, BC=length
L0008	RST	18H		; set VDP write address = DE
.0009	LD	A,(HL)		; get next data byte
	OUT	(VDPdata),A	; write data to VDP
	PUSH	HL		; delay a moment
	POP	HL
	INC	HL		; increment data address
	DEC	BC		; decrement counter
	LD	A,B
	OR	C
	JR	NZ,.0009	; loop until end of data
	RET

    IF      COLECO
    ELSE
	DB	0,0,0	; filler
    ENDIF

;-----------------------------------------------------------------------

; RST 18H - set VDP write address = DE
L0018
	LD	A,E
	OUT	(VDPcmd),A
	LD	A,40H
	ADD	A,D
	OUT	(VDPcmd),A
	PUSH	AF		; delay a moment
	POP	AF
	PUSH	AF
	POP	AF
	RET

    IF      COLECO
    ELSE
	DB	0,0,0	; filler
    ENDIF

;-----------------------------------------------------------------------

; RST 28H - set VDP write address = HL
L0028
	LD	A,L
	OUT	(VDPcmd),A
	LD	A,40H
	ADD	A,H
	OUT	(VDPcmd),A
	PUSH	AF		; delay a moment
	POP	AF
	PUSH	AF
	POP	AF
	RET

    IF      COLECO
    ELSE
	DB	0,0,0	; filler
    ENDIF

;-----------------------------------------------------------------------

    IF      COLECO
    ELSE
; RST 38H - VDP interrupt
L0038	JP	L02CC
    ENDIF

;-----------------------------------------------------------------------

; set VDP read address = HL
L003B
	LD	A,L
	OUT	(VDPcmd),A
	LD	A,H
	OUT	(VDPcmd),A
	PUSH	AF		; delay a moment
	POP	AF
	PUSH	AF
	POP	AF
	RET

;-----------------------------------------------------------------------

; initialize VDP
L0046	LD	HL,D0054
	LD	B,10H
.004B	LD	A,(HL)
	OUT	(VDPcmd),A
	INC	HL
	PUSH	AF		; delay a moment
	POP	AF
	DJNZ	.004B
	RET

D0054	DB		02H,80H	; reg 0 = 02: mode 2
 if coleco
	DB		82H|20H,81H	; reg 1 = 82: 16K, blank, disable V-int, 16x16 sprites
 else
	DB		82H,81H	; reg 1 = 82: 16K, blank, disable V-int, 16x16 sprites
 endif
	DB	NT    >> 10,82H	; reg 2 = 0E: 1110 0000000000 3800 - NT at 3800
	DB	3FC0H >>  6,83H	; reg 3 = FF: 11111111 000000 3FC0 - CT at 2000
	DB	1800H >> 11,84H	; reg 4 = 03: 011 00000000000 1800 - PT at 0000
	DB	SAT   >>  7,85H	; reg 5 = 7E: 1111110 0000000 3F00 - SAT at 3F00
	DB	SPT   >> 11,86H	; reg 6 = 03: 011 00000000000 1800 - SPT at 1800
	DB		00H,87H	; reg 7 = 00: text and background color transparent

    IF      COLECO
    ELSE
	DB	0,0	; filler
    ENDIF

;-----------------------------------------------------------------------

    IF      COLECO
    ELSE
; NMI (SG-1000 pause button)
L0066	JP	L0330
    ENDIF

;-----------------------------------------------------------------------

; delay a while
L0069	LD	B,02H
  if coleco
L006B
	PUSH	BC
	LD	A,(0069H)	; frames per second
	RRCA
	AND	7FH
	LD	B,A
.10
	_HALT

	DJNZ	.10
	POP	BC
  else
L006B	PUSH	BC
	LD	BC,0FFFFH
.006F	DEC	BC
	LD	A,B
	OR	C
	JR	NZ,.006F
	POP	BC
  endif
	DJNZ	L006B

  if coleco
	XOR	A		; clear pause flag
	LD	(DC011),A
  endif

	RET

;-----------------------------------------------------------------------

; initialization
 if coleco
L0078	LD	HL,7000H	; clear flags, high score, and score
	LD	DE,7001H
	LD	BC,03FFH
 else
L0078	LD	HL,DC000	; clear flags, high score, and score
	LD	DE,DC000+1
	LD	BC,DC007-DC000-1
 endif
	LD	(HL),00H
	LDIR

 if coleco
 if 0
; clear VRAM
	LD	DE,0000H
	RST	18H		; set VDP write address = DE
	LD	BC,4000H
	LD	A,C
.1
	OUT	(VDPdata),A
	PUSH	AF
	POP	AF

	DEC	BC
	LD	A,B
	OR	C
	JR	NZ,.1
 endif

	LD	A,1
	LD	(NMIDIS),A

	LD	A,82H|20H	; register 1 = 82H
 else
	LD	A,82H		; register 1 = 82H
 endif
	OUT	(VDPcmd),A	; 16K, blank screen, disable V-int, 16x16 sprites
	LD	A,81H
	OUT	(VDPcmd),A

	CALL	L7312		; silence PSG

    IF      OPT
	XOR	A		; initialize high score to 010000
	LD	(DC001+2),A
	LD	(DC001+1),A
	INC	A
	LD	(DC001),A
    ELSE
	LD	A,01H		; initialize high score to 010000
	LD	(DC001),A
	XOR	A
	LD	(DC001+1),A
	XOR	A
	LD	(DC001+2),A
    ENDIF

    if coleco
    else
	CALL	L0069		; delay a bit
    endif
	CALL	L0046		; initialize VDP

    IF      COLECO
    ELSE
	CALL	L02A7		; initialize keyboard?
    ENDIF

L00A6
    IF      COLECO
	LD	SP,STACK	; initialize stack pointer
    ENDIF

	LD	HL,DC007	; clear all of RAM except for flags, high score, and score
	LD	DE,DC007+1
	LD	BC,STACK-DC007-1
	LD	(HL),00H
	LDIR

	CALL	L029B		; clear VDP sprite attribute table
	CALL	L2F86		; title screen
	CALL	L30DB
	CALL	L2B29

	XOR	A
	LD	(DC012),A	; clear title screen flag

L00C3	CALL	L7312		; silence PSG

	LD	A,(DC00D)
	OR	A
	JR	Z,L00D1
	BIT	0,A
    IF    OPT
	JR	Z,L0135		; challenging stage
    ELSE
	JP	Z,L0135		; challenging stage
    ENDIF

L00D1	CALL	L029B		; clear sprite attribute table
	CALL	L3045		; "ROUND ##" intro
L00D7	CALL	L028A		; clear screen
	CALL	L016A		; initialize graphics tables for game
	CALL	L2B4A
 if coleco
	XOR	A
	LD	(NMIDIS),A
 endif
	LD	A,0E2H		; reg 1 = E2H
	OUT	(VDPcmd),A	; Mode 0, 16K, unblank screen, enable V-int, 16x16 sprites
	LD	A,81H
	OUT	(VDPcmd),A
.00E8	_EI
	_HALT			; wait for vertical retrace?
	CALL	L31BD		; attract mode joystick input
	CALL	L2FF0		; check for start button?
	_DI
	CALL	L216C		; put flower count on screen
	CALL	L21D1		; print remaining honey
	CALL	L2A82		; check for high score
	_EI

	LD	A,(DC011)	; pause flag
	OR	A
	CALL	NZ,L02BE	; wait for pause to end

	CALL	L10E8
	CALL	L1161
	CALL	L03C8		; handle joystick input?
	CALL	L0790		; set sprite 4+5 pattern
	CALL	L09BB
	CALL	L0A27
	CALL	L21EF
	CALL	L24B0
	CALL	L2917
	CALL	L2282
	CALL	L2853
	CALL	L1364
	CALL	L3127
	CALL	L315C
	CALL	L37D5
	CALL	L382D
    IF    OPT
	JR	.00E8
    ELSE
	JP	.00E8
    ENDIF

;-----------------------------------------------------------------------

L0135	CALL	L30DB
	CALL	L029B		; clear VDP sprite attribute table
	CALL	L3030		; "CHALLENGING STAGE" intro
	CALL	L028A		; clear screen
	CALL	L016A		; initialize graphics tables for game
	CALL	L3705

 if coleco
	XOR	A
	LD	(NMIDIS),A
 endif
	LD	A,0E3H		; register 1 = E3H
	OUT	(VDPcmd),A	; Mode 0, 16K, unblank screen, enable V-int, 16x16 2x sprites
	LD	A,81H
	OUT	(VDPcmd),A

.014F	_EI
	_HALT			; wait for vertical retrace?

	LD	A,(DC011)	; pause flag
	OR	A
	CALL	NZ,L02BE	; wait for pause to end

	CALL	L3212		; handle joystick input?
	CALL	L35D3
	CALL	L0790		; set sprite 4+5 pattern
	CALL	L09BB
	CALL	L317E
    IF    OPT
	JR	.014F
    ELSE
	JP	.014F
    ENDIF

 if opt
; ds 60H
 endif

;-----------------------------------------------------------------------

  IF RLE
;	RLE compression:
;	Entry with DE = VRAM write address
;	Entry with HL => compressed data
;		00-7F = copy next 01H..80H bytes
;		80-FF = repeat next byte 02H..80H times
;		FF = end of data
;	Exit with BC = length of uncompressed data
;	Exit with DE unchanged

RLE0008 RST	18H		; set VDP write address = DE

.10	LD	A,(HL)		; get RLE code byte
	INC	HL

	INC	A		; check for end of data and set count to 01H..80H
	RET	Z

	CP	81H		; is it a repeat byte or end of data?
	JR	NC,.30		; branch if so

	LD	B,A

.20	LD	A,(HL)		; get next data byte
	INC	HL

	OUT	(VDPdata),A	; write data to VDP
	PUSH	HL		; delay a moment
	POP	HL

	DJNZ	.20		; loop for next data byte
	JR	.10		; loop for next RLE code

.30	SUB	7FH		; set repeat count to 02H..80H
	LD	B,A

	LD	A,(HL)		; get repeat data byte
	INC	HL

.40	OUT	(VDPdata),A	; write data to VDP
	PUSH	HL		; delay a moment
	POP	HL

	DJNZ	.40		; loop for next data byte
	JR	.10		; loop for next RLE code

  ENDIF	; RLE

;-----------------------------------------------------------------------

L016A	LD	HL,PT+0000H	; start of pattern table
	RST	28H		; set VDP write address = HL
	LD	B,8*4
.0170	LD	A,0FFH		; write 4 characters of all-on blocks
	OUT	(VDPdata),A
	DJNZ	.0170
	LD	HL,D5284
	LD	DE,PT+0AH*8
	LD	BC,N5284	; 0A-46
	RST	08H		; write data to VDP: HL=data, DE=VRAM address, BC=length
  IF RLE
	LD	HL,RLE547C
	LD	DE,PT+60H*8
	CALL	RLE0008
  ELSE
	LD	HL,D547C
	LD	DE,PT+60H*8
	LD	BC,N547C
	RST	08H		; write data to VDP: HL=data, DE=VRAM address, BC=length
  ENDIF
	LD	HL,D411E
	LD	DE,PT+0800H	; second bank, first character
	LD	BC,N411E	; 00-C8
	RST	08H		; write data to VDP: HL=data, DE=VRAM address, BC=length
	LD	HL,D411E
	LD	DE,PT+1000H	; third bank, first character
	LD	BC,N411E	; 00-C8
	RST	08H		; write data to VDP: HL=data, DE=VRAM address, BC=length
	LD	DE,CT+0AH*8
	RST	18H		; set VDP write address = DE
	LD	B,20H
	LD	C,90H
	CALL	L2F30		; fill VDP: C=data, B=length
	LD	B,38H
	LD	C,0F0H
	CALL	L2F30		; fill VDP: C=data, B=length
	LD	B,20H
	LD	C,90H
	CALL	L2F30		; fill VDP: C=data, B=length
	LD	B,78H
	LD	C,0F0H
	CALL	L2F30		; fill VDP: C=data, B=length
	CALL	L2F30		; fill VDP: C=data, B=length
  IF RLE
	LD	HL,RLE596C
	LD	DE,CT+60H*8	; 60-FD
	CALL	RLE0008
  ELSE
	LD	HL,D596C
	LD	DE,CT+60H*8	; 60-FD
	LD	BC,N596C
	RST	08H		; write data to VDP: HL=data, DE=VRAM address, BC=length
  ENDIF
	LD	HL,CT+0000H	; start of color table
	RST	28H		; set VDP write address = HL
	LD	B,08H
	LD	C,77H
	CALL	L2F30		; fill VDP: C=data, B=length
	LD	B,10H
	LD	C,00H
	CALL	L2F30		; fill VDP: C=data, B=length
	LD	HL,D475E
	LD	DE,CT+0800H	; second bank, first character
	LD	BC,N475E	; 00-4F
	RST	08H		; write data to VDP: HL=data, DE=VRAM address, BC=length
	LD	C,0A4H
	LD	B,0E0H
	CALL	L2F30		; fill VDP: C=data, B=length
	LD	HL,D49E6
	LD	DE,CT+0800H+6DH*8
	LD	BC,N49E6	; 6D-C8
	CALL	L0008		; write data to VDP: HL=data, DE=VRAM address, BC=length
	LD	HL,D475E
	LD	DE,CT+1000H	; third bank, first character
	LD	BC,N475E	; 00-4F
	RST	08H		; write data to VDP: HL=data, DE=VRAM address, BC=length
	LD	C,0A4H
	LD	B,0E0H
	CALL	L2F30		; fill VDP: C=data, B=length
	LD	HL,D49E6
	LD	DE,CT+1000H+6DH*8
	LD	BC,N49E6	; 6D-C8
	CALL	L0008		; write data to VDP: HL=data, DE=VRAM address, BC=length
  IF RLE
	LD	HL,RLE391E
	LD	DE,SPT+0000H	; start of sprite pattern table
	CALL	RLE0008
  ELSE
	LD	HL,D391E	; sprite pattern table data
	LD	DE,SPT+0000H
	LD	BC,N391E	; 00-FF
	RST	08H		; write data to VDP: HL=data, DE=VRAM address, BC=length
  ENDIF

	LD	A,(DC00D)
	AND	03H
    IF      OPT
    ELSE
	OR	A
    ENDIF
	RET	Z

	DEC	A
	LD	L,A
	LD	H,00H
	ADD	HL,HL
	ADD	HL,HL
	ADD	HL,HL
	ADD	HL,HL
	ADD	HL,HL
	ADD	HL,HL
	LD	D,H
	LD	E,L
	ADD	HL,HL
	ADD	HL,DE

	PUSH	HL
	LD	DE,D4CBE
	ADD	HL,DE

	PUSH	HL
	LD	DE,PT+0800H+08H*8
	LD	BC,18H*8
	RST	08H		; write data to VDP: HL=data, DE=VRAM address, BC=length
	POP	HL

	LD	DE,PT+1000H+08H*8
	LD	BC,18H*8
	RST	08H		; write data to VDP: HL=data, DE=VRAM address, BC=length
	POP	HL

	LD	DE,D4EFE
	ADD	HL,DE

	PUSH	HL
	LD	DE,CT+0800H+08H*8
	LD	BC,18H*8
	RST	08H		; write data to VDP: HL=data, DE=VRAM address, BC=length
	POP	HL

	LD	DE,CT+1000H+08H*8
	LD	BC,18H*8
	RST	08H		; write data to VDP: HL=data, DE=VRAM address, BC=length

	LD	DE,CT+0800H+19H
	RST	18H		; set VDP write address = DE

	LD	A,(DC00D)
	AND	03H
	DEC	A
	LD	L,A
	LD	H,00H
	ADD	HL,HL
	LD	DE,D513E
	ADD	HL,DE

	LD	B,04H
.0274	LD	A,(HL)
	OUT	(VDPdata),A
	PUSH	AF
	POP	AF
	DJNZ	.0274

	LD	DE,CT+0800H+29H
	RST	18H		; set VDP write address = DE

	INC	HL
	LD	B,04H
.0282	LD	A,(HL)
	OUT	(VDPdata),A
	PUSH	AF
	POP	AF
	DJNZ	.0282
	RET

;-----------------------------------------------------------------------

; clear screen
L028A	LD	DE,NT+0000H
	RST	18H		; set VDP write address = DE
	LD	B,00H
	LD	C,B
	CALL	L2F30		; fill VDP: C=data, B=length
	CALL	L2F30		; fill VDP: C=data, B=length
	CALL	L2F30		; fill VDP: C=data, B=length
	RET

;-----------------------------------------------------------------------

; clear sprite attribute table (fill with E8H)
L029B	LD	DE,SAT		; start of sprite attribute table
	RST	18H		; set VDP write address = DE
	LD	B,80H
	LD	C,0E8H
	CALL	L2F30		; fill VDP: C=data, B=length
	RET

;-----------------------------------------------------------------------

    IF      COLECO
    ELSE
L02A7	LD	A,92H		; 8255 port A input, port B input, port C output
	OUT	(KeybCtl),A
	LD	HL,DC000	; address of bit flags
	LD	A,00H
	OUT	(KeybPtC),A	; write zero to Port C output?
	IN	A,(KeybPtC)
    IF      OPT
	OR	A
    ELSE
	CP	00H		; test if zero returned from port C register?
    ENDIF
	JR	NZ,.02BB
	SET	0,(HL)		; set flag bit 0 if byte is zero
	RET

.02BB	RES	0,(HL)		; clear flag bit 0 if byte not zero
	RET
    ENDIF

;-----------------------------------------------------------------------

; wait for pause to end
    IF      COLECO

; HL = KPLAST address
; C = I/O port address (Joy1/Joy2)
; returns NZ if key pressed
GETKP
	OUT	(KeySel),A
	EX	(SP),HL
	EX	(SP),HL
	IN	A,(C)		; - B - - K K K K

	CPL			; invert bits to positive logic
	AND	0FH		; mask keypad code

	CP	(HL)		; compare with last key
	LD	(HL),A		; update last key
	RET

L02BE
	CALL	L7312		; silence PSG
	_HALT			; wait for vertical retrace

	PUSH	HL
	PUSH	BC

	LD	HL,KPLAST	; check player 1 keypad
	LD	C,Joy1
	CALL	GETKP
	JR	NZ,.1		; branch if key found

	INC	HL		; check player 2 keypad
	LD	C,Joy2
	CALL	GETKP

.1	POP	BC
	POP	HL

	JR	Z,L02BE		; exit if no key found

; keypad * = reset
	CP	KPreset
	JR	NZ,.10

	LD	A,82H|20H	; register 1 = 82H
	OUT	(VDPcmd),A	; 16K, blank screen, disable V-int, 16x16 sprites
	LD	A,81H
	OUT	(VDPcmd),A

	JP	L00A6

.10
; keypad # = pause key
	CP	KPpause
	JR	NZ,L02BE

	XOR	A
	LD	(DC011),A	; set pause flag
	RET

    ELSE
L02BE	PUSH	BC
	PUSH	HL
	CALL	L7312		; silence PSG
	POP	HL
	POP	BC
	LD	A,(DC011)	; pause flag
	OR	A
	RET	Z
	JR	L02BE
    ENDIF

;-----------------------------------------------------------------------

; RST 38H (VDP interrupt) handler
L02CC
    IF      COLECO
	PUSH	AF

	LD	A,(NMICNT)	; increment NMI counter
	INC	A
	LD	(NMICNT),A

	POP	AF
	RETN

VBSTUFF
    ELSE
	_DI
	PUSH	AF
    ENDIF
	PUSH	HL
	PUSH	BC
	PUSH	DE
	PUSH	IX
	PUSH	IY
	EXX
	PUSH	HL
	PUSH	BC
	PUSH	DE
	EX	AF,AF'
	PUSH	AF

	IN	A,(VDPstat)	; acknowledge interrupt
	LD	A,(DC010)	; pause button debounce timer
	INC	A
	CP	0F0H
	JR	NC,.02E7
	LD	A,0F0H
.02E7	LD	(DC010),A

	LD	A,(DC011)	; pause flag
	OR	A
	JR	NZ,.031F	; branch if paused

	LD	A,(DC012)	; test title screen flag
	OR	A
	JR	Z,.02FB		; skip if not title screen

	LD	HL,DC200	; silence sound
	LD	(HL),80H

.02FB	CALL	L6EB4		; update music (?)
	CALL	L0360		; read keyboard
	CALL	L07D7		; write DC026..DC075 to sprite attribute table
	CALL	L08D9		; update grass at bottom of screen

	LD	A,(DC0CF)	; test challenge level flag
	OR	A
	JR	NZ,.031F	; skip if challenge level

	CALL	L0FB9
	CALL	L11B1
	CALL	L084B		; update honey pots
	CALL	L1A6E
	CALL	L0974		; update hills
	CALL	L103F

.031F	POP	AF
	EX	AF,AF'
	POP	DE
	POP	BC
	POP	HL
	EXX
	POP	IY
	POP	IX
	POP	DE
	POP	BC
	POP	HL
	POP	AF
    IF      COLECO
	RET
    ELSE
	_EI
	RETI
    ENDIF

;-----------------------------------------------------------------------

    IF      COLECO
    ELSE
; NMI (pause) handler
L0330	PUSH	AF
	LD	A,(DC010)	; pause button debounce timer
	CP	10H
	JR	C,.0346
	XOR	A
	LD	(DC010),A	; pause button debounce timer
	LD	A,(DC011)	; pause flag
	AND	A
	JR	Z,.0349
	XOR	A
	LD	(DC011),A	; pause flag
.0346	POP	AF
	RETN

.0349	CPL
	LD	(DC011),A	; pause flag

	LD	A,9FH		; silence PSG
	OUT	(PSG),A
	LD	A,0BFH
	OUT	(PSG),A
	LD	A,0DFH
	OUT	(PSG),A
	LD	A,0FFH
	OUT	(PSG),A

	POP	AF
	RETN
    ENDIF

;-----------------------------------------------------------------------

; read keyboard
L0360	LD	A,(DC012)	; test title screen flag
	OR	A
	RET	NZ		; return if title screen

    IF      COLECO
; FIXME: this can surely be optimized later

	LD	C,0FFH

	OUT	(JoySel),A
	EX	(SP),HL
	EX	(SP),HL
	IN	A,(Joy1)	; - A - - L D R U

	BIT	6,A	; A
	JR	NZ,.1
	RES	B_1A,C		; - - B A R L D U
.1
	BIT	3,A	; U
	JR	NZ,.2
	RES	B_1L,C
.2
	BIT	2,A	; R
	JR	NZ,.3
	RES	B_1D,C
.3
	BIT	1,A	; D
	JR	NZ,.4
	RES	B_1R,C
.4
	BIT	0,A	; L
	JR	NZ,.5
	RES	B_1U,C
.5
	OUT	(KeySel),A	; check P1 right fire button
	EX	(SP),HL
	EX	(SP),HL
	IN	A,(Joy1)	; - B - - K K K K

	BIT	6,A	; B
	JR	NZ,.6
	RES	B_1B,C
.6
	PUSH	HL
	PUSH	BC

	LD	HL,KPLAST	; check player 1 keypad
	LD	C,Joy1
	CALL	GETKP
	JR	NZ,.6a		; branch if key found

	INC	HL		; check player 2 keypad
	LD	C,Joy2
	CALL	GETKP

.6a	POP	BC
	POP	HL

	JR	Z,.89		; skip if same key

; keypad # = pause key
	CP	KPpause
	JR	NZ,.7

	LD	(DC011),A	; set pause flag
.7

    IF      HAX
	OR	A		; skip hax if no key pressed
	JR	Z,.89

	PUSH	AF
	LD	A,(DC0CF)	; test challenge level flag
	OR	A
	JR	NZ,.88		; challenging stage

	LD	A,(CHTFLG)	; test if cheats are enabled
	OR	A
	JR	NZ,.CHEATED	; branch if cheats have been enabled

	POP	AF
	PUSH	AF

	PUSH	HL
	LD	HL,(CHTPTR)	; get next code location
.7a
	CP	(HL)		; test if code matches
	INC	HL
	JR	Z,.8		; update pointer if match
	LD	HL,CHTCODE	; reset sequence if no match
	CP	(HL)
	JR	Z,.7a		; if bad digit is first digit, start over
.8
	LD	(CHTPTR),HL

	JR	NZ,.9		; skip code if no match

	LD	A,(HL)		; check if end of list
	OR	A
	JR	NZ,.9		; branch if not end of list

	LD	A,96H
	LD	(CHTFLG),A	; enable cheats
	LD	(DC200),A	; play a sound

.9	POP	HL

	JR	.88

.CHEATED
	POP	AF

; HACK - keypad 1 = extra lives
	CP	KP_1
	JR	NZ,.11

	PUSH	AF
	LD	A,(DC00F)	; hearts
	INC	A
	CP	30+1
	JR	NC,.10
	LD	(DC00F),A

	PUSH	BC
	PUSH	HL
	CALL	L219F		; update hearts
	POP	HL
	POP	BC
.10	POP	AF
.11

; HACK - keypad 2 = extra honey
	CP	KP_2
	JR	NZ,.13

	PUSH	AF
	LD	A,(DC00E)	; remaining honey
	ADD	A,01H		; decrement honey (BCD)
	DAA
	JR	Z,.12
	LD	(DC00E),A	; remaining honey
.12	POP	AF
.13

; HACK - keypad 3 = extra flowers
	CP	KP_3
	JR	NZ,.14

	PUSH	AF
	PUSH	BC
	PUSH	DE
	PUSH	HL
	CALL	ADDFLOWER
	POP	HL
	POP	DE
	POP	BC
	POP	AF
.14

    IF      0	; pattern dump
	CP	KP_5
	JR	NZ,.22

	LD	DE,NT+0200H
	RST	18H
	XOR	A
.21	OUT	(VDPdata),A
	INC	A
	JR	NZ,.21

	JR	$
.22
    ENDIF	; pattern dump

	JR	.89
.88
	POP	AF
.89

    ENDIF	; HAX

    ELSE	; !COLECO

	LD	A,(DC000)	; test keyboard flag
	BIT	0,A
	JP	NZ,.0375	; branch if port C stayed 0 during test

	IN	A,(KeybPtA)	; read port A data
	OR	0C0H		; set unused bits
	LD	(DC018),A	; save the result and return
	RET

.0375	LD	A,07H		; joystick bits are on row 7
	OUT	(KeybPtC),A
	IN	A,(KeybPtA)	; read all P1 joystick bits from port A
	OR	0C0H		; mask out P2 joystick bits
    IF      OPT
    ELSE
	LD	(DC018),A	; save value (redundant)
    ENDIF
	LD	C,A		; accumulate bits in C register

	LD	A,02H		; row 2 bit 4 = HOME/CLR -> left button
	OUT	(KeybPtC),A
	IN	A,(KeybPtA)
	BIT	4,A
	JR	NZ,.038D

	RES	B_1A,C

.038D	LD	A,03H		; row 3 bit 4 = INS/DEL -> right button
	OUT	(KeybPtC),A
	IN	A,(KeybPtA)
	BIT	4,A
	JR	NZ,.0399

	RES	B_1B,C

.0399	LD	A,04H		; row 4 bit 5 = down arrow
	OUT	(KeybPtC),A
	IN	A,(KeybPtA)
	BIT	5,A
	JR	NZ,.03A5

	RES	B_1D,C

.03A5	LD	A,05H		; row 5 bit 5 = left arrow
	OUT	(KeybPtC),A
	IN	A,(KeybPtA)
	BIT	5,A
	JR	NZ,.03B1

	RES	B_1L,C

.03B1	LD	A,06H		; row 6 bit 5 = right arrow
	OUT	(KeybPtC),A
	IN	A,(KeybPtA)
	BIT	5,A
	JR	NZ,.03BD

	RES	B_1R,C

.03BD	BIT	6,A		; row 6 bit 6 = up arrow
	JR	NZ,.03C3

	RES	B_1U,C
    ENDIF

.03C3	LD	A,C		; save the result and return
	LD	(DC018),A
	RET

  if hax
CHTCODE	DB	KP_8,KP_6,KP_7,KP_5,KP_3,KP_0,KP_9,0 ; JENNY
  endif

;-----------------------------------------------------------------------

L03C8	LD	A,(DC0D8)	; counter for clock power-up
	OR	A
	CALL	NZ,L06B0

	LD	A,(DC01D)
	OR	A
	RET	Z

	LD	A,(DC01E)
	DEC	A
	LD	(DC01E),A

	JR	NZ,.03E3
	LD	A,05H
	LD	(DC01E),A
	RET

.03E3	XOR	A
	LD	(DC08F),A	; reset "hit obstacle" flag
	LD	(DC0BF),A
	LD	(DC0C2),A
	LD	A,(DC018)
	BIT	B_1A,A
	JR	Z,.03FF
	BIT	B_1B,A
	JR	Z,.03FF
	PUSH	AF
	XOR	A
	LD	(DC080),A	; clear dropping honey flag
	JR	.0405

; fire button = drop honey
.03FF	PUSH	AF
	_DI
	CALL	L07E2		; drop a honey
	_EI
.0405	POP	AF
	BIT	B_1U,A
	PUSH	AF
	CALL	Z,L041D
	POP	AF
	BIT	B_1D,A
	PUSH	AF
	CALL	Z,L0430
	POP	AF
	BIT	B_1L,A
	JR	Z,L0448
	BIT	B_1R,A
	JR	Z,L045D
	RET

; up
L041D	LD	A,00H
	CALL	L047D		; check ground ahead?
	LD	B,00H
	CALL	L07A5		; turn girl sprite?
	LD	A,(DC036)	; sprite 4 Y
	CP	39H
	RET	C
	DEC	A
	JR	L0441

; down
L0430	LD	A,01H
	CALL	L047D		; check ground ahead?
	LD	B,01H
	CALL	L07A5		; turn girl sprite?
	LD	A,(DC036)	; sprite 4 Y
	CP	90H
	RET	NC
	INC	A
L0441	LD	(DC036),A	; sprite 4 Y
	LD	(DC03A),A	; sprite 5 Y
	RET

; left
L0448	LD	A,02H
	CALL	L047D		; check ground ahead?
	LD	B,02H
	CALL	L07A5		; turn girl sprite?
	LD	A,(DC037)	; sprite 4 X
	CP	44H
	JP	C,L08B5		; scroll grass right (to move left)
	DEC	A
	JR	L0470

; right
L045D	LD	A,03H
	CALL	L047D		; check ground ahead?
	LD	B,03H
	CALL	L07A5		; turn girl sprite?
	LD	A,(DC037)	; sprite 4 X
	CP	0ADH
	JP	NC,L0890	; scroll grass left (to move right)
	INC	A

L0470	LD	(DC037),A	; sprite 4 X
	LD	(DC03B),A	; sprite 5 X
	RET

;-----------------------------------------------------------------------

; A = high 5 bits of A
L0477	RRCA
	RRCA
	RRCA
	AND	1FH
	RET

;-----------------------------------------------------------------------

; check ground ahead?
L047D	_DI
	LD	C,A		; C = girl direction
	ADD	A,A
	ADD	A,A
	LD	D,00H		; DE = girl direction * 4
	LD	E,A
	LD	HL,D04ED	; look-ahead X,Y table
	ADD	HL,DE		; offset based on girl direction
	LD	B,02H		; check two X,Y pairs
.048A	LD	A,(DC036)	; sprite 4 Y + dy
	ADD	A,(HL)
	LD	D,A
	INC	HL
	LD	A,(DC037)	; sprite 4 X + dx
	ADD	A,(HL)
	LD	E,A
	INC	HL

	PUSH	HL
	PUSH	BC
	CALL	L04A1		; check for obstacle
	POP	BC
	POP	HL

	DJNZ	.048A
	_EI
	RET

L04A1	LD	A,D
	AND	0F8H
	LD	H,00H
	LD	L,A
	ADD	HL,HL
	ADD	HL,HL
	LD	A,E
	CALL	L0477		; A = high 5 bits of A
	LD	D,NT/256
	LD	E,A
	ADD	HL,DE
	CALL	L003B		; set VDP read address = HL
	IN	A,(VDPdata)	; read data from screen
	CP	08H
	RET	C		; ground, flower spawn, honey
	CP	24H
	JR	C,L0539		; flower
	CP	30H
	JR	C,L04E7		; house window, rock, stump
	CP	3EH
	RET	C		; some water
	CP	40H
	JP	C,L0702
	CP	41H
	JP	Z,L0702
	CP	44H
	JP	Z,L0702
	CP	48H
	RET	C
	CP	54H
	JP	C,L0702		; more water
	CP	6FH
	RET	C		; shore, clump of grass
	CP	84H
	JR	C,L04E7		; fence around house
	CP	88H
	JR	C,L04FD		; "Wellcome" below house
	RET

; hit obstacle, don't move
L04E7	LD	A,01H
	LD	(DC08F),A	; set "hit obstacle" flag
	RET

; screen offsets to check when girl moves
;		 Y   X   Y   X
D04ED	DB	08H,0AH,08H,05H
	DB	10H,05H,10H,0AH
	DB	0FH,04H,09H,04H
	DB	09H,0BH,0FH,0BH

; hit "Wellcome"
L04FD	LD	A,(DC0C1)	; 10 flowers picked flag
	OR	A
	JR	Z,L04E7		; just hit obstacle if not 10 flowers

	LD	(DC0C5),HL
	LD	(DC0C3),A
	XOR	A
	LD	(DC01D),A
	LD	(DC023),A
	LD	A,04H
	LD	(DC022),A
	LD	A,0AH
	LD	(DC16A),A
	LD	HL,DC14E
	SET	7,(HL)
	RET

L0520	PUSH	AF
	LD	A,01H
	CP	C
	JR	Z,.052B
	LD	A,02H
	CP	C
	JR	NZ,.0536
.052B	LD	HL,(DC0BC)
	LD	DE,0020H
	SBC	HL,DE
	LD	(DC0BC),HL
.0536	POP	AF
	JR	L0558

; hit a flower
L0539	LD	(DC0BC),HL
	CP	0AH
	RET	C		; ignore top half of sprout
	CP	24H
	RET	NC		; return if not a flower (shouldn't get here)
	CP	1CH
	RET	Z		; ignore top of dead flower
	CP	1DH
	RET	Z		; ignore top of dead flower
	CP	0AH
	JR	Z,L0520		; bottom of sprout
	CP	0BH
	JR	Z,L0520		; bottom of sprout
	CP	1EH
	JR	Z,L0520		; bottom of dead flower
	CP	1FH
	JR	Z,L0520		; bottom of dead flower
L0558	PUSH	AF
	LD	A,C		; DE = girl direction * 8
	ADD	A,A
	ADD	A,A
	ADD	A,A
	LD	E,A
	POP	AF
	LD	D,00H
	LD	HL,D063A
	ADD	HL,DE
	LD	B,08H
.0567	LD	D,(HL)
	CP	D
	JR	Z,.0573
	INC	HL
	DJNZ	.0567
	LD	HL,D065E
	JR	.0576

.0573	LD	HL,D065A
.0576	LD	D,00H
	LD	E,C
	ADD	HL,DE
	LD	A,(HL)
	LD	HL,(DC0BC)
	LD	E,A
	SBC	HL,DE
	LD	(DC0BC),HL
	LD	DE,NT+0100H
	SBC	HL,DE
	LD	A,L
	AND	1FH
	ADD	A,10H
	LD	E,A
	RL	L
	RL	H
	RL	L
	RL	H
	RL	L
	RL	H
	LD	A,H
	AND	0FH
	LD	D,A
	LD	HL,DC09A
	LD	A,(DC099)
	INC	A
	LD	B,A
.05A7	LD	A,(HL)
	AND	0FH
	CP	D
	JR	Z,.05B2
	INC	HL
.05AE	INC	HL
	DJNZ	.05A7
	RET

.05B2	INC	HL
	LD	A,(HL)
	CP	E
	JR	NZ,.05AE
	DEC	HL
	LD	A,(HL)
	RLCA
	RLCA
	RLCA
	RLCA
	AND	0FH
	CP	08H
	JP	Z,L0662

	LD	(HL),0FFH
	INC	HL
	LD	(HL),0FFH
	PUSH	AF

	LD	HL,(DC0BC)
	LD	D,00H
	LD	A,18H
	CALL	L1212
	POP	AF
	CP	03H
	JR	Z,.0602
	CP	05H
	JR	C,.05EC

	LD	A,(DC0BE)	; count of flowers picked
	RRCA			; divide by 2
	AND	7FH
	LD	(DC0BE),A

	LD	HL,DC200
	LD	(HL),88H
	RET

.05EC	LD	A,01H		; 10 points
	CALL	L2A40		; add to score
	LD	HL,DC200
	LD	A,86H
	CP	(HL)
	RET	Z
	DEC	A
	CP	(HL)
	RET	Z
	LD	A,88H
	CP	(HL)
	RET	Z
	LD	(HL),8DH
	RET

.0602
	XOR	A		; 100 points
	CALL	L2A40		; add to score

	LD	HL,DC200
	LD	(HL),85H

	CALL	L0E93
ADDFLOWER
	LD	A,(DC0BE)	; count of flowers picked
	INC	A		; add one flower
	LD	(DC0BE),A
	CP	0AH		; test for 10 flowers
	JR	C,.0628

	PUSH	AF
	CALL	L062C
	LD	HL,DC200
	LD	(HL),89H
	POP	AF

	CP	14H		; check if 20 flowers
	RET	C
	LD	A,14H		; cap flowers at 20

.0628	LD	(DC0BE),A	; update count of flowers picked
	RET

L062C	LD	A,(DC0C1)	; test 10 flowers picked flag
	OR	A
	JR	NZ,L0639	; exit if already set

	INC	A
	LD	(DC0C1),A	; set 10 flowers picked flag

	CALL	L27F2		; put boy in window

L0639	RET

D063A	DB	0BH,0FH,13H,17H,1BH,1FH,23H,23H
	DB	0AH,0CH,10H,14H,18H,1EH,20H,20H
	DB	0BH,0DH,11H,15H,19H,1FH,21H,21H
	DB	0AH,0EH,12H,16H,1AH,1EH,22H,22H

D065A	DB	21H,00H,01H,20H

D065E	DB	20H,01H,21H,00H

L0662	LD	A,(DC0D7)	; get power-up ID
	OR	A
	RET	Z

	LD	HL,DC200
	LD	(HL),92H

	CP	01H
	JR	Z,.068A		; 01 = heart, add one life
	CP	02H
	JR	Z,.0699		; 02 = bouquet, add 5 flowers
	CP	04H
	JP	Z,L1D1B		; 04 = skull
	CP	0AH
	RET	NC		; 10+ = out of range
	CP	05H
	JR	NC,L06DE	; 05, 06, 07 = bonus score

	LD	A,10H		; 03 = clock, add time
	LD	(DC0D8),A	; counter for clock power-up
	CALL	L0EBC
	JR	L06B0

.068A	LD	A,(DC00F)	; remaining lives ("love")
    IF      OPT
	INC	A
    ELSE
	ADD	A,01H
    ENDIF
	LD	(DC00F),A	; remaining lives ("love")
	CALL	L219F		; update hearts
	CALL	L0EBC
	RET

; add 5 flowers (boquet picked up)
.0699	LD	A,(DC0BE)	; count of flowers picked
	CP	0FH
	JR	NC,.06A4	; if 15+ already picked, set it to 20
	ADD	A,05H		; add 5 flowers
	JR	.06A6

.06A4	LD	A,20H
.06A6	LD	(DC0BE),A	; update count of flowers picked
	CALL	L062C
	CALL	L0EBC
	RET

L06B0	LD	A,(DC0D8)	; counter for clock power-up
	DEC	A
	LD	(DC0D8),A
	RET	Z

	LD	A,(DC019)	; time remaining?
	CP	01H
	RET	Z
	DEC	A
	LD	(DC019),A

	LD	C,A
	LD	A,5CH
	ADD	A,C
	LD	IX,DC03E
	CALL	L2907
	LD	A,(DC040)
	CP	60H
	JR	Z,.06D8
	LD	A,60H
	JR	.06DA

.06D8	LD	A,68H
.06DA	CALL	L290E
	RET

L06DE	LD	A,70H
	LD	(DC0E5),A

	LD	A,(DC0D7)	; get power-up ID
	ADD	A,03H		; apple=1500 cherry=2500 grape=500
	CALL	L0E18		; display powerup in A-reg

	LD	HL,(DC0BC)
	LD	D,00H
	LD	A,20H
	CALL	L1212

	LD	A,(DC0D7)	; get power-up ID
	DEC	A
	DEC	A		; 5,6,7 -> 3,4,5 (1500,2500,500)
	CALL	L2A40		; add to score
	XOR	A
	LD	(DC0D7),A	; clear power-up ID
	RET

; hit water
L0702	LD	A,(DC0BF)
	OR	A
	RET	NZ

	LD	A,(DC037)	; sprite 4 X
	LD	(DC021),A
	BIT	1,C
	JR	Z,.071B
	BIT	0,C
	JR	NZ,.0719
	SUB	08H
	JR	.071B

.0719	ADD	A,08H
.071B	CALL	L0470
	LD	A,(DC036)	; sprite 4 Y
	LD	(DC020),A
	BIT	1,C
	JR	NZ,.0732
	BIT	0,C
	JR	NZ,.0730
	SUB	08H
	JR	.0732

.0730	ADD	A,08H
.0732	CALL	L0441
	PUSH	HL
	CALL	L07D7		; write DC026..DC075 to sprite attribute table
	POP	HL
	DEC	HL
	LD	A,L
	OUT	(VDPcmd),A
	LD	A,H
	OUT	(VDPcmd),A
	PUSH	AF
	POP	AF
	PUSH	AF
	POP	AF
	IN	A,(VDPdata)
	CP	49H
	JR	C,.074F
	CP	54H
	JR	C,.0750
.074F	INC	HL
.0750	LD	A,L
	RLCA
	RLCA
	RLCA
	AND	0F8H
	CALL	L0470
	RR	H
	RR	L
	RR	H
	RR	L
	LD	A,L
	AND	0F8H
	CALL	L0441
	LD	A,70H
	CALL	L079C		; set sprite 4+5 pattern
	LD	A,07H
	LD	(DC022),A
	XOR	A
	LD	(DC01D),A
	INC	A
	LD	(DC0BF),A
	LD	(DC0C2),A
	LD	A,07H
	LD	(DC024),A
	LD	A,(DC0BE)	; count of flowers picked
	RRCA			; divide by 2
	AND	7FH
	LD	(DC0BE),A
	LD	HL,DC200
	LD	(HL),86H
	RET

;-----------------------------------------------------------------------

; set sprite 4+5 pattern
L0790	LD	A,(DC022)
	ADD	A,A
	ADD	A,A
	ADD	A,A
	ADD	A,A
	LD	B,A
	LD	A,(DC023)
	ADD	A,B

L079C	LD	(DC038),A	; sprite 4 pattern
	ADD	A,04H
	LD	(DC03C),A	; sprite 5 pattern
	RET

;-----------------------------------------------------------------------

; turn girl sprite?
L07A5	LD	A,(DC0C2)
	OR	A
	RET	NZ

	LD	A,(DC08F)	; test "hit obstacle" flag
	OR	A
	JR	Z,.07B1

	POP	HL		; remove return address if hit obstacle

.07B1	XOR	A
	LD	(DC08F),A	; reset "hit obstacle" flag

L07B5	LD	A,B
	LD	(DC022),A
	LD	A,(DC024)
	DEC	A
	LD	(DC024),A
	RET	NZ
	LD	A,07H
	LD	(DC024),A
	LD	A,(DC023)
	OR	A
	JR	Z,.07D1
	XOR	A
	LD	(DC023),A
	RET

.07D1	LD	A,08H
	LD	(DC023),A
	RET

;-----------------------------------------------------------------------

; write DC026..DC075 to sprite attribute table
L07D7	LD	DE,SAT		; start of sprite attribute table
	LD	HL,DC026
	LD	BC,NC026
	RST	08H		; write data to VDP: HL=data, DE=VRAM address, BC=length
	RET

;-----------------------------------------------------------------------

; drop a honey
L07E2	LD	A,(DC080)	; check dropping honey flag
	OR	A
	RET	NZ		; return if currently dropping honey

	INC	A
	LD	(DC080),A	; set dropping honey flag

	LD	A,(DC00E)	; remaining honey
	OR	A
	RET	Z		; return if no honey left

	LD	B,NC085/2
	LD	HL,DC085	; honey position list
.07F5	LD	A,(HL)
	CP	0FFH
	JR	Z,.07FF		; empty position found
	INC	HL
	INC	HL
	DJNZ	.07F5
	RET			; don't drop honey if list is full

.07FF	LD	A,(DC036)	; sprite 4 Y
	AND	0F8H
	LD	(HL),A
	LD	A,(DC037)	; sprite 4 X
	CALL	L0477		; A = high 5 bits of A
	PUSH	HL		; IX = HL (= DC085)
	POP	IX
	INC	HL
	LD	(HL),A

	LD	A,(IX+00H)
	LD	L,A
	LD	H,00H
	ADD	HL,HL
	ADD	HL,HL
	LD	A,(IX+01H)
	LD	E,A
	LD	D,NT/256
	ADD	HL,DE
	LD	DE,0021H
	ADD	HL,DE
	CALL	L003B		; set VDP read address = HL

	IN	A,(VDPdata)	; get what's on space under the honey
	OR	A		; brown ground
	JR	Z,.083C
	CP	06H		; brown ground / flower spawn
	JR	Z,.083C
	CP	6EH		; clump of grass
	JR	Z,.083C

	LD	(IX+00H),0FFH	; can't drop honey, clear the position
	LD	(IX+01H),0FFH
	RET

.083C
	LD	A,(DC00E)	; remaining honey
	SUB	01H		; decrement honey (BCD)
	DAA
	LD	(DC00E),A	; remaining honey

	LD	HL,DC200	; start honey drop music
	LD	(HL),91H
	RET

;-----------------------------------------------------------------------

; update honey pots
L084B	LD	A,(DC098)
	OR	A
	RET	NZ
	LD	IX,DC085	; honey position list
	LD	B,NC085/2
.0856	CALL	L0860
	INC	IX
	INC	IX
	DJNZ	.0856
	RET

L0860	LD	A,(IX+00H)
	CP	0FFH
	RET	Z
	LD	H,00H
	LD	L,A
	ADD	HL,HL
	ADD	HL,HL
	LD	A,(IX+01H)
	LD	D,NT/256
	LD	E,A
	ADD	HL,DE
	LD	DE,0021H
	ADD	HL,DE
	CALL	L003B		; set VDP read address = HL

	IN	A,(VDPdata)
	OR	A	; brown ground?
	JR	Z,.0889
	CP	06H	; flower spawn?
	JR	Z,.0889
	CP	07H	; honey pot
	JR	Z,.0889
	CP	6EH	; grass clump
	RET	NZ
.0889	EX	DE,HL
	RST	18H		; set VDP write address = DE
	LD	A,07H		; put honey pot on screen
	OUT	(VDPdata),A
	RET

;-----------------------------------------------------------------------

; scroll grass left (to move right)
L0890	_DI
	CALL	L0904		; scroll hills left (to move right)
	CALL	L0EF0		; scroll map left?
	LD	A,(DC07E)	; decrement grass scroll delay count
	DEC	A
	LD	(DC07E),A
	RET	NZ
L089F	LD	A,06H		; reset grass scroll delay count
	LD	(DC07E),A
	LD	(DC07F),A	; set grass scroll request flag
	LD	A,(DC07D)	; get grass scroll position
	CP	1FH
	JR	NZ,.08B0
	LD	A,0FFH
.08B0	INC	A
	LD	(DC07D),A	; update grass scroll position
	RET

;-----------------------------------------------------------------------

; scroll grass right (to move left)
L08B5	_DI
	CALL	L093B		; scroll hills right (to move left)
	CALL	L0F54		; scroll map right?
	LD	A,(DC07E)	; decrement grass scroll delay count
	DEC	A
	LD	(DC07E),A
	RET	NZ
	LD	A,06H		; reset grass scroll delay count
	LD	(DC07E),A
	LD	(DC07F),A	; set grass scroll request flag
	LD	A,(DC07D)	; get grass scroll position
	OR	A
	JR	NZ,.08D4
	LD	A,20H
.08D4	DEC	A
	LD	(DC07D),A	; update grass scroll position
	RET

;-----------------------------------------------------------------------

; update grass at bottom of screen
L08D9	LD	A,(DC07F)	; test scroll request flag
	OR	A
	RET	Z		; return if not scrolling

	XOR	A		; clear scroll request flag
	LD	(DC07F),A

	LD	A,(DC07D)	; get grass scroll position
	LD	E,A
	LD	D,00H
	LD	HL,D5144	; add offset into grass data
	ADD	HL,DE

	LD	A,(DC0CF)	; test if in challenge mode
	OR	A
	JR	NZ,.08F7

	LD	DE,NT+0280H	; VDP start address in normal mode
	JR	.08FA

.08F7	LD	DE,NT+0240H	; VDP start address in challenge mode
.08FA	RST	18H		; set VDP write address = DE

	LD	B,02H		; B = two rows of grass data
	LD	A,(DC07D)	; get grass scroll position ***OPT: move next line up
	LD	C,A		; C = offset into grass data
	JP	L099B		; copy grass data to VDP

;-----------------------------------------------------------------------

; scroll hills left (to move right)
L0904	LD	A,(DC082)	; test hills scroll delay counter
	DEC	A
	LD	(DC082),A
	RET	NZ
	LD	A,10H		; reset hills scroll delay counter
	LD	(DC082),A
	LD	(DC081),A	; set hills scroll request flag
	LD	A,(DC083)	; get hills scroll position
	CP	1FH
	JR	NZ,.0923
	XOR	A
	LD	(DC083),A	; update hills scroll position
	LD	(DC084),A
	RET

.0923	LD	A,(DC084)
	OR	A
	JR	Z,.092E
	XOR	A
	LD	(DC084),A
	RET

.092E	LD	A,01H
	LD	(DC084),A
	LD	A,(DC083)	; get hills scroll position
	INC	A
	LD	(DC083),A	; update hills scroll position
	RET

;-----------------------------------------------------------------------

; scroll hills right (to move left)
L093B	LD	A,(DC082)	; test hills scroll delay counter
	DEC	A
	LD	(DC082),A
	RET	NZ
	LD	A,10H		; reset hills scroll delay counter
	LD	(DC082),A
	LD	(DC081),A	; set hills scroll request flag
	LD	A,(DC083)	; get hills scroll position
	OR	A
	JR	NZ,.095C
	LD	A,1FH
	LD	(DC083),A	; update hills scroll position
	LD	A,01H
	LD	(DC084),A
	RET

.095C	LD	A,(DC084)
	OR	A
	JR	Z,.096E
	XOR	A
	LD	(DC084),A
	LD	A,(DC083)	; get hills scroll position
	DEC	A
	LD	(DC083),A	; update hills scroll position
	RET

.096E	LD	A,01H
	LD	(DC084),A
	RET

;-----------------------------------------------------------------------

L0974	LD	A,(DC081)	; test hills scroll request flag
	OR	A
	RET	Z
	XOR	A
	LD	(DC081),A	; clear hills scroll request flag

	LD	DE,NT+0080H
	RST	18H		; set VDP write address = DE

 if coleco
 push de
 endif

	LD	A,(DC083)	; get hills scroll position
	LD	L,A
	LD	H,00H
	LD	DE,D5184	; add offset into hills data
	ADD	HL,DE

	LD	A,(DC084)
	OR	A
	JR	NZ,.0995
	LD	DE,0080H
	ADD	HL,DE

.0995	LD	B,04H
	LD	A,(DC083)	; get hills scroll position
	LD	C,A		; C = offset into hills data

 if coleco
 pop de
 endif

L099B
 if coleco
	LD	A,E
	ADD	A,20H
	LD	E,A
	JR	NC,.1
	INC	D
.1	PUSH	DE
 endif
	LD	D,C		; D = width to right edge of data
	PUSH	BC
	PUSH	HL
	LD	A,20H		; B = 20H - D, width of left half of data
	SUB	D
	LD	B,A
	CALL	L2F27		; write VDP: HL=data, B=length
	LD	A,D		; skip write if all of data already written
	OR	A
	JR	Z,.09B2
	LD	B,D		; B = width of right half of data
	LD	DE,0020H	; skip back to start of row
	SBC	HL,DE
	CALL	L2F27		; write VDP: HL=data, B=length
.09B2	POP	HL
	LD	DE,0020H	; point HL to next row
	ADD	HL,DE
	POP	BC
    if      coleco
;	CALL	checkint
	POP	DE
	RST	18H
    else
    endif
	DJNZ	L099B		; loop for another row
	RET

;-----------------------------------------------------------------------

L09BB	LD	A,(DC079)
	OR	A
	RET	Z
	LD	A,(DC077)
	DEC	A
	LD	(DC077),A
	JR	NZ,.09DC
	LD	A,14H
	LD	(DC077),A
	LD	B,02H
	LD	HL,DC067
.09D3	CALL	L09F8
	LD	DE,0004H
	ADD	HL,DE
	DJNZ	.09D3
.09DC	LD	A,(DC078)
	DEC	A
	LD	(DC078),A
	RET	NZ
	LD	A,0CH
	LD	(DC078),A
	LD	B,02H
	LD	HL,DC06F
.09EE	CALL	L09F8
	LD	DE,0004H
	ADD	HL,DE
	DJNZ	.09EE
	RET

L09F8	LD	A,(HL)
	INC	A
	CALL	Z,L0A04
	CP	40H
	CALL	Z,L0A04
	LD	(HL),A
	RET

L0A04	PUSH	HL
	INC	HL
	INC	HL
	BIT	7,(HL)
	JR	Z,.0A11
	SUB	20H
	RES	7,(HL)
	POP	HL
	RET

.0A11	CP	40H
	JR	Z,.0A17
	SET	7,(HL)
.0A17	POP	HL
	RET

;-----------------------------------------------------------------------

; clear sprites 16 and 17
L0A19	LD	HL,DC066	; sprite 16
	LD	DE,DC067
	LD	BC,000FH
	LD	(HL),0E8H
	LDIR

	RET

;-----------------------------------------------------------------------

L0A27	CALL	L0EB7
	LD	HL,DC0DB
	BIT	7,(HL)
	JR	NZ,.0A3F
	LD	A,(DC07A)
	OR	A
	RET	NZ
	CALL	L0A50
	LD	HL,DC0DB
	BIT	7,(HL)
	RET	Z
.0A3F	BIT	5,(HL)
	JP	NZ,L0C83
	_DI
	CALL	L0ACE
	CALL	L0B35
	CALL	L0C83
	_EI
	RET

L0A50	XOR	A
	LD	(DC0DB),A
	LD	A,(DC14E)
	BIT	7,A
	RET	NZ
	CALL	L387D
	LD	D,A
	CP	64H
	RET	C
	LD	E,00H
	CP	0C8H
	JR	C,.0A7C
	LD	HL,DC0E4
	LD	D,(HL)
	BIT	7,D
	JR	NZ,.0A7C
	LD	A,(DC0AE)
	INC	A
	JR	NZ,.0A7C
	LD	HL,DC0E4
	LD	(HL),80H
	LD	E,01H
.0A7C	BIT	0,D
	JR	Z,.0A96
	LD	A,0FFH
	LD	(DC0DA),A
	BIT	0,E
	JR	Z,.0A8C
	LD	(DC0E3),A
.0A8C	LD	A,0C0H
	LD	(DC0DC),A
	LD	HL,DC0DB
	JR	.0AB2

.0A96	XOR	A
	LD	(DC0DA),A
	BIT	0,E
	JR	Z,.0AA6
	LD	(DC0E3),A
	LD	HL,DC0E4
	SET	4,(HL)
.0AA6	LD	A,0D0H	; 208 = end of sprite attribute table?
	LD	(DC0DC),A
	LD	HL,DC0DB
	SET	0,(HL)
	SET	4,(HL)
.0AB2	SET	7,(HL)
	LD	A,D
	AND	0FH
	CP	0BH
	JR	C,.0ABD
	SUB	05H
.0ABD	ADD	A,02H
	ADD	A,A
	ADD	A,A
	ADD	A,A
	LD	(DC0D9),A
	BIT	0,E
	RET	Z
	ADD	A,10H
	LD	(DC0E2),A
	RET

;-----------------------------------------------------------------------

L0ACE	LD	A,(DC0DB)
	BIT	6,A
	RET	NZ
	LD	A,(DC0DA)
	AND	07H
	RET	NZ
	CALL	L0E6F
	LD	A,(DC0E4)
	BIT	7,A
	JP	NZ,L0D33
	LD	A,(DC0DB)
	RRA
	JR	Z,.0AF0
	LD	DE,0008H
	JR	.0AF3

.0AF0	LD	DE,0FFF8H
.0AF3	ADD	HL,DE
	LD	B,08H
.0AF6	CALL	L003B		; set VDP read address = HL
	IN	A,(VDPdata)
	CP	14H
	JR	NZ,.0B2E
	LD	HL,DC0DB
	SET	6,(HL)
	LD	A,08H
	SUB	B
	SLA	A
	SLA	A
	SLA	A
	LD	B,A
	LD	A,(DC0D9)
	AND	07H
	LD	C,A
	LD	A,B
	SUB	C
	LD	C,A
	LD	HL,0040H
	CALL	L0E61
	OR	A
	JR	Z,.0B21
	INC	L
.0B21	LD	A,L
	LD	(DC0DF),A
	LD	(DC0E0),A
	LD	A,41H
	LD	(DC0DE),A
	RET

.0B2E	LD	DE,0020H
	ADD	HL,DE
	DJNZ	.0AF6
	RET

;-----------------------------------------------------------------------

L0B35	LD	A,(DC0E4)
	BIT	6,A
	CALL	NZ,L0D44
	LD	A,(DC14E)
	RLA
	JR	C,.0BB4
	LD	HL,DC0DB
	BIT	6,(HL)
	JR	Z,.0B94
	LD	HL,DC0DE
	DEC	(HL)
	JR	NZ,.0B81
	CALL	L0E6F
	LD	B,02H
	LD	DE,0020H
.0B58	ADD	HL,DE
	CALL	L003B		; set VDP read address = HL
	IN	A,(VDPdata)
	CP	14H
	JR	Z,.0B6F
	DJNZ	.0B58
	LD	HL,DC0DB
	SET	2,(HL)
	LD	HL,DC0DE
	LD	(HL),40H
	RET

.0B6F	LD	HL,DC0DB
	BIT	2,(HL)
	JR	Z,.0B79
	RES	6,(HL)
	RET

.0B79	SET	5,(HL)
	LD	HL,DC0E1
	LD	(HL),00H
	RET

.0B81	LD	HL,DC0E0
	DEC	(HL)
	JR	NZ,.0BC8
	LD	A,(DC0DF)
	LD	(HL),A
	LD	HL,DC0DB
	BIT	2,(HL)
	JR	NZ,.0BB4
	JR	.0B9E

.0B94	LD	A,R
	BIT	2,A
	JR	Z,.0BC8
	BIT	1,A
	JR	Z,.0BB4
.0B9E	LD	HL,DC0D9
	LD	A,80H
	CP	(HL)
	JR	Z,.0BC8
	INC	(HL)
	LD	A,(DC0E4)
	BIT	6,A
	JR	NZ,.0BC8
	LD	HL,DC0E2
	INC	(HL)
	JR	.0BC8

.0BB4	LD	HL,DC0D9
	LD	A,10H
	CP	(HL)
	JR	Z,.0BC8
	DEC	(HL)
	LD	A,(DC0E4)
	BIT	6,A
	JR	NZ,.0BC8
	LD	HL,DC0E2
	DEC	(HL)
.0BC8	LD	A,(DC0DB)
	BIT	0,A
	JR	Z,.0BFA
	LD	HL,DC0DA
	LD	A,0FFH
	CP	(HL)
	JR	NZ,.0BEC
	LD	HL,DC0D9
	LD	(HL),0E8H	; 232
	LD	HL,DC0DB
	RES	7,(HL)
	LD	HL,DC0E4
	BIT	6,(HL)
	JR	NZ,.0C55
	RES	7,(HL)
	JR	.0C55

.0BEC	INC	(HL)
	LD	A,(DC0E4)
	BIT	6,A
	JR	NZ,.0C19
	LD	HL,DC0E3
	INC	(HL)
	JR	.0C19

.0BFA	LD	HL,DC0DA
	XOR	A
	CP	(HL)
	JR	NZ,.0C0D
	LD	HL,DC0D9
	LD	(HL),0E8H	; 232
	LD	HL,DC0DB
	RES	7,(HL)
	JR	.0C55

.0C0D	DEC	(HL)
	LD	A,(DC0E4)
	BIT	6,A
	JR	NZ,.0C19
	LD	HL,DC0E3
	DEC	(HL)
.0C19	LD	HL,DC0DA
	LD	A,60H
	CP	(HL)
	JR	C,.0C37
	LD	HL,DC0DB
	BIT	4,(HL)
	JR	NZ,.0C37
	SET	4,(HL)
	LD	A,20H
	LD	HL,DC0E4
	BIT	6,(HL)
	JR	NZ,.0C55
	SET	4,(HL)
	JR	.0C55

.0C37	LD	A,0A0H
	LD	HL,DC0DA
	CP	(HL)
	LD	A,00H
	JR	NC,.0C55
	LD	HL,DC0DB
	BIT	4,(HL)
	JR	Z,.0C55
	RES	4,(HL)
	LD	A,0E0H
	LD	HL,DC0E4
	BIT	6,(HL)
	JR	NZ,.0C55
	RES	4,(HL)
.0C55	LD	HL,DC0DA
	LD	D,A
	ADD	A,(HL)
	LD	(HL),A
	LD	HL,DC0E4
	BIT	6,(HL)
	JR	NZ,.0C68
	LD	HL,DC0E3
	LD	A,D
	ADD	A,(HL)
	LD	(HL),A
.0C68	LD	A,(DC0DB)
	AND	08H
	LD	E,A
	LD	HL,DC0DC
	ADD	A,(HL)
	LD	(DC0DD),A
	LD	A,E
	XOR	08H
	LD	B,A
	LD	A,(DC0DB)
	AND	0F7H
	OR	B
	LD	(DC0DB),A
	RET

;-----------------------------------------------------------------------

L0C83	LD	HL,DC0DB
	BIT	5,(HL)
	JR	Z,.0CBE
	LD	A,(DC091)
	OR	A
	JR	NZ,.0CBE
	CALL	L0E6F
	LD	DE,0020H
	ADD	HL,DE
	CALL	L003B		; set VDP read address = HL
	IN	A,(VDPdata)
	CP	14H
	JR	Z,.0CAC
	LD	HL,DC0DB
	RES	5,(HL)
	SET	2,(HL)
	LD	HL,DC0DE
	LD	(HL),40H
.0CAC	LD	HL,DC0E1
	DEC	(HL)
	JR	NZ,.0CBE
	LD	HL,DC0DE
	LD	(HL),40H
	LD	HL,DC0DB
	RES	5,(HL)
	SET	2,(HL)
.0CBE	LD	A,(DC0D9)
	LD	(DC026),A
	LD	(DC02A),A
	LD	A,(DC0DA)
	LD	(DC027),A
	LD	(DC02B),A
	LD	A,(DC0DD)
	LD	(DC028),A
	LD	B,04H
	ADD	A,B
	LD	(DC02C),A
	LD	A,01H
	LD	HL,DC0DB
	BIT	4,(HL)
	JR	Z,.0CE7
	SET	7,A
.0CE7	LD	(DC029),A
	ADD	A,0EH
	LD	(DC02D),A
	LD	A,(DC0E2)
	LD	HL,DC14E
	BIT	7,(HL)
	JR	NZ,.0D04
	LD	HL,DC0E4
	BIT	5,(HL)
	JR	NZ,.0D04
	BIT	7,(HL)
	JR	NZ,.0D06
.0D04	LD	A,0E8H	; 232
.0D06	LD	(DC02E),A
	LD	(DC032),A
	LD	A,(DC0E3)
	LD	(DC02F),A
	LD	(DC033),A
	LD	A,0E8H	; 232
	LD	(DC030),A
	LD	A,0ECH
	LD	(DC034),A
	LD	A,0DH
	LD	HL,DC0E4
	BIT	4,(HL)
	JR	Z,.0D2A
	SET	7,A
.0D2A	LD	(DC031),A
	ADD	A,02H
	LD	(DC035),A
	RET

;-----------------------------------------------------------------------

L0D33	LD	A,(DC0E3)
	CP	20H
	RET	C
	LD	A,R
	AND	17H
	RET	NZ
	LD	HL,DC0E4
	SET	6,(HL)
	RET

;-----------------------------------------------------------------------

L0D44	LD	A,(DC0E4)
	BIT	5,A
	RET	NZ
	BIT	4,A
	JR	Z,.0D56
	LD	A,(DC0E3)
	CP	10H
	JP	C,L0E5B
.0D56	LD	A,(DC0E2)
	CP	98H
	JP	NC,L0E5B
	LD	D,A
	AND	07H
	JP	NZ,L0E56
	LD	A,(DC091)
	OR	A
	JP	NZ,L0E56
	LD	L,D
	LD	H,00H
	ADD	HL,HL
	ADD	HL,HL
	LD	A,(DC0E3)
	CALL	L0477		; A = high 5 bits of A
	LD	E,A
	LD	D,00H
	ADD	HL,DE
	LD	DE,NT+0000H
	ADD	HL,DE
	LD	A,(DC0E4)
	BIT	4,A
	JR	Z,.0D89
	LD	DE,0FFFCH
	ADD	HL,DE
.0D89	CALL	L003B		; set VDP read address = HL
	IN	A,(VDPdata)
	CP	06H
	JP	NZ,L0E56
	LD	B,02H
.0D95	CALL	L003B		; set VDP read address = HL
	PUSH	BC
	LD	B,02H
.0D9B	IN	A,(VDPdata)
	CALL	L17C1
	JR	Z,.0DA6
	POP	BC
	JP	L0E56

.0DA6	DJNZ	.0D9B
	POP	BC
	LD	DE,0020H
	ADD	HL,DE
	DJNZ	.0D95
	LD	A,(DC0E2)
	CALL	L0477		; A = high 5 bits of A
	SUB	08H
	SET	7,A
	LD	(DC0AE),A
	LD	A,(DC0E3)
	CALL	L0477		; A = high 5 bits of A
	LD	HL,DC0E4
	LD	B,10H
	BIT	4,(HL)
	JR	Z,.0DCD
	LD	B,0CH
.0DCD	ADD	A,B
	LD	(DC0AF),A
	LD	HL,DC0E5
	LD	(HL),0FFH
	LD	HL,DC0E4
	SET	5,(HL)
	CALL	L387D
	LD	D,A
	CP	28H
	JR	NC,.0DF6
	BIT	0,D
	JR	Z,.0DF2
	LD	A,(DC00F)	; remaining lives ("love")
	CP	05H
	JR	NC,.0DF2
	LD	E,01H
	JR	.0E14

.0DF2	LD	E,02H
	JR	.0E14

.0DF6	LD	A,64H
	CP	D
	JR	C,.0E07
	BIT	0,D
	JR	Z,.0E03
	LD	E,03H
	JR	.0E14

.0E03	LD	E,04H
	JR	.0E14

.0E07	CALL	L387D
	AND	03H
	CP	03H
	JR	C,.0E11
	DEC	A
.0E11	ADD	A,05H
	LD	E,A
.0E14	LD	A,E
	LD	(DC0D7),A	; set power-up ID

; display powerup in A-reg
L0E18	DEC	A
	LD	L,A
	EX	AF,AF'
	LD	H,00H
	ADD	HL,HL	; multiply by 32
	ADD	HL,HL
	ADD	HL,HL
	ADD	HL,HL
	ADD	HL,HL
	EX	DE,HL

	PUSH	DE
	LD	HL,D6494	; graphics for power-ups
	ADD	HL,DE
	PUSH	HL
	LD	DE,PT+0800H+20H*8
	LD	BC,N6494	; 20-23
	RST	08H		; write data to VDP: HL=data, DE=VRAM address, BC=length
	POP	HL
	LD	DE,PT+1000H+20H*8
	LD	BC,N6494	; 20-23
	RST	08H		; write data to VDP: HL=data, DE=VRAM address, BC=length
	POP	DE

	LD	HL,D65D4	; color table for power-ups
	ADD	HL,DE
	EX	AF,AF'
	CP	08H		; use same color for bonus scores (7, 8, 9)
	JR	C,.0E45
	LD	HL,D66B4	; color table for bonus scores

.0E45	PUSH	HL
	LD	DE,CT+0800H+20H*8
	LD	BC,N65D4	; 20-23
	RST	08H		; write data to VDP: HL=data, DE=VRAM address, BC=length
	POP	HL
	LD	DE,CT+1000H+20H*8
	LD	BC,N65D4
	RST	08H		; write data to VDP: HL=data, DE=VRAM address, BC=length
	RET

L0E56	LD	HL,DC0E2
	INC	(HL)
	RET

L0E5B	LD	HL,DC0E4
	LD	(HL),00H
	RET

;-----------------------------------------------------------------------

L0E61	LD	B,10H
	XOR	A
.0E64	ADD	HL,HL
	RLA
	CP	C
	JR	C,.0E6C
	SUB	C
	SET	0,L
.0E6C	DJNZ	.0E64
	RET

;-----------------------------------------------------------------------

L0E6F	LD	A,(DC0D9)
	AND	0F8H
	LD	L,A
	LD	H,00H
	ADD	HL,HL
	ADD	HL,HL
	LD	A,(DC0DA)
	CALL	L0477		; A = high 5 bits of A
	LD	E,A
	LD	D,00H
	ADD	HL,DE
	LD	DE,NT+0000H
	ADD	HL,DE
	LD	A,(DC0DB)
	BIT	4,A
	JR	Z,.0E92
	LD	DE,0FFFCH
	ADD	HL,DE
.0E92	RET

;-----------------------------------------------------------------------

L0E93	LD	A,(DC0DB)
	BIT	5,A
	RET	Z

	CALL	L0E6F
	LD	DE,0020H
	ADD	HL,DE
	CALL	L003B		; set VDP read address = HL
	IN	A,(VDPdata)
	CP	06H		; flower spawn

	RET	NZ
	LD	A,(DC00E)	; remaining honey
	ADD	A,03H		; add 3 honey (BCD)
	DAA
	LD	(DC00E),A	; remaining honey

	LD	HL,DC200
	LD	(HL),92H
	RET

;-----------------------------------------------------------------------

L0EB7	LD	HL,DC0E5
	DEC	(HL)
	RET	NZ

L0EBC	_DI
	LD	A,(DC0AE)
	CP	0FFH
	JR	Z,.0EEE

	AND	0FH
	LD	B,A

	LD	A,(DC0AF)
	CP	10H
	JR	C,.0EE4
	CP	30H
	JR	NC,.0EE4
	SUB	10H
	LD	C,A

	CALL	L1154

	LD	D,00H
	LD	A,18H
	CALL	L1212

	LD	HL,DC0E4
	RES	3,(HL)

.0EE4	LD	HL,DC0AF
	LD	(HL),0FFH
	LD	HL,DC0AE
	LD	(HL),0FFH
.0EEE	_EI
	RET

;-----------------------------------------------------------------------

; scroll map left (to move right)?
L0EF0	LD	A,(DC0BF)
	OR	A
	RET	NZ

	LD	A,(DC090)
	OR	A
	JR	Z,.0F00
	DEC	A
	LD	(DC090),A
	RET

.0F00	LD	A,08H
	LD	(DC090),A
	LD	(DC091),A
	CALL	L19A5

	LD	B,NC085/2
	LD	HL,DC085+1
.0F10	LD	A,(HL)		; check for honey out of range?
	CP	0FFH
	JR	Z,.0F2C
	CP	01H
	JR	NC,.0F2A
	DEC	HL		; if out of range, remove it and add to count
	LD	(HL),0FFH
	INC	HL
	LD	(HL),0FFH

	LD	A,(DC00E)	; remaining honey
	ADD	A,01H		; increment honey (BCD)
	DAA
	LD	(DC00E),A	; remaining honey

	JR	.0F2C

.0F2A	DEC	A		; move honey position left
	LD	(HL),A
.0F2C	INC	HL
	INC	HL
	DJNZ	.0F10

	CALL	L1275
	LD	A,(DC092)
	CP	0FH
	JR	Z,.0F3F
	INC	A
	LD	(DC092),A
	RET

.0F3F	XOR	A
	LD	(DC092),A
	LD	A,(DC093)
	CP	06H
	JR	Z,.0F4F
	INC	A
	LD	(DC093),A
	RET

.0F4F	XOR	A
	LD	(DC093),A
	RET

;-----------------------------------------------------------------------

; scroll map right (to move left)?
L0F54	LD	A,(DC0BF)
	OR	A
	RET	NZ

	LD	A,(DC090)
	CP	08H
	JR	Z,.0F65
	INC	A
	LD	(DC090),A
	RET

.0F65	XOR	A
	LD	(DC090),A
	INC	A
	LD	(DC091),A
	CALL	L1A12

	LD	B,NC085/2
	LD	HL,DC085+1
.0F75	LD	A,(HL)
	CP	0FFH
	JR	Z,.0F91
	CP	1EH
	JR	C,.0F8F
	DEC	HL
	LD	(HL),0FFH
	INC	HL
	LD	(HL),0FFH

	LD	A,(DC00E)	; remaining honey
	ADD	A,01H		; increment honey (BCD)
	DAA
	LD	(DC00E),A	; remaining honey

	JR	.0F91

.0F8F	INC	A
	LD	(HL),A
.0F91	INC	HL
	INC	HL
	DJNZ	.0F75

	CALL	L12A7
	LD	A,(DC092)
	OR	A
	JR	Z,.0FA3
	DEC	A
	LD	(DC092),A
	RET

.0FA3	LD	A,0FH
	LD	(DC092),A
	LD	A,(DC093)
	OR	A
	JR	Z,.0FB3
	DEC	A
	LD	(DC093),A
	RET

.0FB3	LD	A,06H
	LD	(DC093),A
	RET

;-----------------------------------------------------------------------

L0FB9	LD	A,(DC091)
	OR	A
	RET	Z
	XOR	A
	LD	(DC091),A
	LD	DE,NT+0100H
    IF      OPT
	LD	(DC094),DE
    ELSE
	EX	DE,HL
	LD	(DC094),HL
	EX	DE,HL
    ENDIF
	RST	18H		; set VDP write address = DE
	LD	E,00H
L0FCD
	LD	A,(DC092)
	LD	D,A
	LD	A,(DC093)
	LD	C,A
	CALL	L1010		; compute map address?
	LD	B,20H		; screen width
.0FDA	LD	A,(HL)
	OUT	(VDPdata),A
	INC	HL
	DEC	B
	JR	Z,.0FF8
	INC	D
	LD	A,D
	CP	10H
    IF    OPT
	JR	NZ,.0FDA
    ELSE
	JP	NZ,.0FDA
    ENDIF
	INC	C
	LD	A,C
	CP	07H
	JR	NZ,.0FEF
	XOR	A
.0FEF	LD	C,A
	LD	D,00H
	CALL	L1010		; compute map address?
    IF    OPT
	JR	.0FDA
    ELSE
	JP	.0FDA
    ENDIF

.0FF8	INC	E
	LD	A,E
	CP	0CH
	RET	Z
    if      coleco
;	CALL	checkint
    endif
	PUSH	DE
	PUSH	HL
	LD	HL,(DC094)
	LD	DE,0020H
	ADD	HL,DE
	LD	(DC094),HL
	EX	DE,HL
	RST	18H		; set VDP write address = DE
	POP	HL
	POP	DE
    IF    OPT
	JR	L0FCD
    ELSE
	JP	L0FCD
    ENDIF

;-----------------------------------------------------------------------

; compute map address?
L1010	PUSH	BC
	PUSH	DE
	LD	B,D
	LD	C,E
	PUSH	BC
	LD	HL,(DC096)
	LD	D,00H
	LD	E,A
	ADD	HL,DE
	LD	A,(HL)
	LD	H,00H
	LD	L,A
	ADD	HL,HL
	ADD	HL,HL
	ADD	HL,HL
	ADD	HL,HL
	ADD	HL,HL
	ADD	HL,HL
	LD	D,H
	LD	E,L
	ADD	HL,HL
	ADD	HL,DE
	LD	DE,D5E94
	ADD	HL,DE
	POP	BC
	LD	D,00H
	LD	E,B
	ADD	HL,DE
	EX	DE,HL
	LD	H,00H
	LD	L,C
	ADD	HL,HL
	ADD	HL,HL
	ADD	HL,HL
	ADD	HL,HL
	ADD	HL,DE
	POP	DE
	POP	BC
	RET

;-----------------------------------------------------------------------

L103F	LD	A,(DC098)
	OR	A
	RET	Z
	PUSH	AF
	LD	A,(DC0BA)
	DEC	A
	LD	(DC0BA),A
	OR	A
	JR	Z,.1051
	POP	AF
	RET

.1051	LD	A,32H
	LD	(DC0BA),A
	POP	AF
	INC	A
	OR	A
	RET	Z
	LD	(DC098),A
	CP	06H
	JR	NZ,.1067
	LD	A,0FFH
	LD	(DC098),A
	RET

.1067	DEC	A
	DEC	A
	LD	L,A
	LD	H,00H
	LD	DE,D10D3
	ADD	HL,DE
	LD	D,(HL)
	LD	E,A
	LD	HL,NT+0100H
	LD	B,0BH
.1077	PUSH	BC
	LD	B,1FH
.107A	CALL	L003B		; set VDP read address = HL
.107D	IN	A,(VDPdata)
	CP	D
	JR	Z,.1096
	CP	06H
	JR	Z,.1096
	CP	18H
	JR	Z,.1096
	CP	1CH
	JR	Z,.1096
	INC	HL
	DJNZ	.107D
.1091	POP	BC
	INC	HL
	DJNZ	.1077
	RET

.1096	PUSH	HL
	RST	28H		; set VDP write address = HL
	LD	A,E
	PUSH	DE
	LD	D,00H
	RLCA
	RLCA
	AND	0FCH
	LD	E,A
	LD	IX,D10D8
	ADD	IX,DE
	POP	DE
	LD	A,(IX+00H)
	OUT	(VDPdata),A
	PUSH	AF
	POP	AF
	LD	A,(IX+01H)
	OUT	(VDPdata),A
	PUSH	DE
	LD	DE,0020H
	ADD	HL,DE
	POP	DE
	PUSH	AF
	RST	28H		; set VDP write address = HL
	POP	AF
	LD	A,(IX+02H)
	OUT	(VDPdata),A
	PUSH	AF
	POP	AF
	LD	A,(IX+03H)
	OUT	(VDPdata),A
	POP	HL
	INC	HL
	DEC	B
	JR	Z,.1091
	INC	HL
	DJNZ	.107A
	JR	.1091

D10D3	DB	06H,08H,0CH,10H,14H
D10D8	DB	08H,09H,0AH,0BH,0CH,0DH,0EH,0FH
	DB	10H,11H,12H,13H,14H,15H,16H,17H

;-----------------------------------------------------------------------

L10E8	LD	A,(DC098)
	OR	A
	RET	NZ
	LD	A,(DC099)
	LD	B,A
	CALL	L387D
	CP	B
	RET	NC
	_DI
	LD	HL,DC09A
.10FA	LD	A,(HL)
	CP	0FFH
	JR	Z,.1105
	INC	HL
	INC	HL
	DJNZ	.10FA
	_EI
	RET

.1105	PUSH	HL
	CALL	L387D
	AND	1FH
	LD	C,A
.110C	CALL	L387D
	AND	0FH
	CP	0CH
	JR	NC,.110C
	LD	B,A
	CALL	L1154
	CALL	L003B		; set VDP read address = HL
	IN	A,(VDPdata)
	CP	06H
	JR	Z,.112F
.1122	LD	BC,0FFEFH
.1125	POP	HL
	LD	(HL),B
	INC	HL
	LD	A,10H
	ADD	A,C
	LD	(HL),A
	DEC	HL
	_EI
	RET

.112F	PUSH	AF
	POP	AF
	PUSH	AF
	POP	AF
	IN	A,(VDPdata)
	OR	A
	JR	NZ,.1122
	LD	DE,0020H
	ADD	HL,DE
	CALL	L003B		; set VDP read address = HL
	IN	A,(VDPdata)
	OR	A
	JR	NZ,.1122
	PUSH	AF
	POP	AF
	PUSH	AF
	POP	AF
	IN	A,(VDPdata)
	OR	A
	JR	NZ,.1122
	POP	HL
	PUSH	HL
	CALL	L11C9
	JR	.1125

;-----------------------------------------------------------------------

L1154	LD	H,00H
	LD	L,B
	ADD	HL,HL
	ADD	HL,HL
	ADD	HL,HL
	ADD	HL,HL
	ADD	HL,HL
	LD	D,39H
	LD	E,C
	ADD	HL,DE
	RET

;-----------------------------------------------------------------------

L1161	LD	A,(DC098)
	OR	A
	RET	NZ
	LD	A,(DC0BA)
	DEC	A
	LD	(DC0BA),A
	RET	NZ
	LD	A,1EH
	LD	(DC0BA),A
	LD	A,(DC099)
	LD	B,A
	LD	A,(DC0BB)
	INC	A
	LD	(DC0BB),A
	CP	B
	JR	C,.1185
	XOR	A
	LD	(DC0BB),A
.1185	LD	H,00H
	LD	L,A
	CALL	L387D
	BIT	5,A
	RET	Z
	ADD	HL,HL
	LD	DE,DC09A
	ADD	HL,DE
	LD	A,(HL)
	CP	0FFH
	RET	Z
	RRCA
	RRCA
	RRCA
	RRCA
	AND	0FH
	CP	07H
	JR	C,.11A7
	LD	(HL),0FFH
	INC	HL
	LD	(HL),0FFH
	RET

.11A7	INC	A
	RRD
	LD	C,A
	LD	A,(HL)
	AND	0F0H
	OR	C
	LD	(HL),A
	RET

;-----------------------------------------------------------------------

L11B1	LD	A,(DC098)
	OR	A
	RET	NZ
	LD	A,(DC099)
	INC	A
	LD	B,A
	LD	HL,DC09A
.11BE	LD	A,(HL)
	CP	0FFH
	CALL	NZ,L11C9
	INC	HL
	INC	HL
	DJNZ	.11BE
	RET

;-----------------------------------------------------------------------

L11C9	PUSH	BC
	PUSH	HL
	LD	A,(HL)
	PUSH	AF
	AND	0FH
	LD	B,A
	INC	HL
	LD	A,(HL)
	LD	D,00H
	CP	0FH
	JR	NZ,.11DC
	LD	D,01H
	LD	A,10H
.11DC	CP	10H
	JR	C,.1205
	CP	30H
	JR	NC,.1205
	CP	2FH
	JR	NZ,.11EA
	LD	D,02H
.11EA	SUB	10H
	LD	C,A
	PUSH	DE
	CALL	L1154
	POP	DE
	POP	AF
	RRCA
	RRCA
	AND	3CH
	PUSH	AF
	CALL	L1212
	POP	AF
	CP	20H
	JR	NC,.1206
	CP	18H
	JR	NC,.1209
	PUSH	AF
.1205	POP	AF
.1206	POP	HL
	POP	BC
	RET

.1209	POP	HL
	LD	(HL),0FFH
	INC	HL
	LD	(HL),0FFH
	DEC	HL
	POP	BC
	RET

;-----------------------------------------------------------------------

L1212	PUSH	AF
	RST	28H		; set VDP write address = HL
	POP	AF
	PUSH	DE
	LD	D,00H
	LD	E,A
	LD	IX,D1251
	ADD	IX,DE
	POP	DE
	LD	A,(IX+00H)
	BIT	0,D
	JR	NZ,.1229
	OUT	(VDPdata),A

.1229	PUSH	AF
	POP	AF
	LD	A,(IX+01H)
	BIT	1,D
	JR	NZ,.1234
	OUT	(VDPdata),A
.1234	PUSH	DE
	LD	DE,0020H
	ADD	HL,DE
	POP	DE
	PUSH	AF
	RST	28H		; set VDP write address = HL
	POP	AF
	LD	A,(IX+02H)
	BIT	0,D
	JR	NZ,.1246
	OUT	(VDPdata),A
.1246	PUSH	AF
	POP	AF
	LD	A,(IX+03H)
	BIT	1,D
	RET	NZ
	OUT	(VDPdata),A
	RET

; name table values for 4-tile background sprites
D1251	HEX	08 09 0A 0B	; flower stage 1 (sprout)
	HEX	0C 0D 0E 0F	; flower stage 2
	HEX	10 11 12 13	; flower stage 3
	HEX	14 15 16 17	; flower stage 4 (bloom)
	HEX	18 19 1A 1B	; flower stage 5 (wilted)
	HEX	1C 1D 1E 1F	; flower stage 6 (dead)
	HEX	06 00 00 00	; flower spawn point
	HEX	AC AD AE AF	; bear eating honey
	HEX 	20 21 22 23	; bonus score from bee-dropped item

;-----------------------------------------------------------------------

L1275	LD	HL,NT+011EH
	CALL	L12D1
	LD	A,(DC099)
	INC	A
	LD	B,A
	LD	IX,DC09A
.1284	LD	A,(IX+00H)
	CP	0FFH
	CALL	NZ,.1293
	INC	IX
	INC	IX
	DJNZ	.1284
	RET

.1293	LD	A,(IX+01H)
	OR	A
	JR	Z,L129E
	DEC	A
	LD	(IX+01H),A
	RET

L129E	LD	(IX+00H),0FFH
	LD	(IX+01H),0FFH
	RET

;-----------------------------------------------------------------------

L12A7	LD	HL,NT+0100H
	CALL	L12D1
	LD	A,(DC099)
	INC	A
	LD	B,A
	LD	IX,DC09A
.12B6	LD	A,(IX+00H)
	CP	0FFH
	CALL	NZ,.12C5
	INC	IX
	INC	IX
	DJNZ	.12B6
	RET

.12C5	LD	A,(IX+01H)
	CP	3FH
	JR	NC,L129E
	INC	A
	LD	(IX+01H),A
	RET

;-----------------------------------------------------------------------

L12D1	LD	A,(DC099)
	LD	B,A
	LD	IX,DC09A
.12D9	LD	A,(IX+00H)
	CP	0FFH
	JR	Z,.12E7
	INC	IX
	INC	IX
	DJNZ	.12D9
	RET

.12E7	LD	B,0AH
.12E9	CALL	L387D
	AND	0FH
	CP	0BH
	JR	NC,.12E9
	EX	DE,HL
	LD	L,A
	LD	H,00H
	ADD	HL,HL
	ADD	HL,HL
	ADD	HL,HL
	ADD	HL,HL
	ADD	HL,HL
	ADD	HL,DE
	CALL	L003B		; set VDP read address = HL
	PUSH	HL
	IN	A,(VDPdata)
	CP	06H
	JR	Z,.130B
.1306	POP	HL
	EX	DE,HL
	DJNZ	.12E9
	RET

.130B	PUSH	AF
	POP	AF
	PUSH	AF
	POP	AF
	IN	A,(VDPdata)
	OR	A
	JR	NZ,.1306
	PUSH	DE
	LD	DE,0020H
	ADD	HL,DE
	POP	DE
	CALL	L003B		; set VDP read address = HL
	IN	A,(VDPdata)
	OR	A
	JR	NZ,.1306
	PUSH	AF
	POP	AF
	PUSH	AF
	POP	AF
	IN	A,(VDPdata)
	OR	A
	JR	NZ,.1306
	POP	HL
	PUSH	HL
	LD	DE,NT+0100H
	SBC	HL,DE
	LD	A,L
	AND	1FH
	ADD	A,10H
	LD	(IX+01H),A
	RL	L
	RL	H
	RL	L
	RL	H
	RL	L
	RL	H
	LD	A,H
	AND	0FH
	LD	L,A
	CALL	L387D
	AND	03H
	INC	A
	LD	H,A
	RRCA
	RRCA
	RRCA
	RRCA
	LD	C,A
	LD	A,L
	OR	C
	LD	(IX+00H),A
	LD	A,H
	ADD	A,A
	ADD	A,A
	POP	HL
	LD	D,00H
	JP	L1212

;-----------------------------------------------------------------------

L1364	LD	A,(DC16A)
	LD	B,A
.1368	PUSH	BC
	_DI
	LD	HL,DC163
	LD	A,(DC169)
	CP	(HL)
	JR	NZ,.1375
	LD	(HL),00H
.1375	INC	(HL)
	LD	A,(HL)
	LD	C,A
	LD	B,00H

	LD	HL,DC0F4
	ADD	HL,BC
	LD	A,(HL)
	LD	(DC0F4),A

	LD	HL,DC0F9
	ADD	HL,BC
	LD	A,(HL)
	LD	(DC0F9),A

	LD	HL,DC0FE
	ADD	HL,BC
	LD	A,(HL)
	LD	(DC0FE),A

	LD	HL,DC103
	ADD	HL,BC
	LD	A,(HL)
	LD	(DC103),A

	LD	HL,DC108
	ADD	HL,BC
	LD	A,(HL)
	LD	(DC108),A

	LD	HL,DC10D
	ADD	HL,BC
	LD	A,(HL)
	LD	(DC10D),A

	LD	HL,DC112
	ADD	HL,BC
	LD	A,(HL)
	LD	(DC112),A

	LD	HL,DC135
	ADD	HL,BC
	LD	A,(HL)
	LD	(DC135),A

	LD	HL,DC11C
	ADD	HL,BC
	LD	A,(HL)
	LD	(DC11C),A

	LD	HL,DC158
	ADD	HL,BC
	LD	A,(HL)
	LD	(DC158),A

	LD	HL,DC15D
	ADD	HL,BC
	LD	A,(HL)
	LD	(DC15D),A

	CALL	L1424
	LD	A,(DC163)
	LD	C,A
	LD	B,00H

	LD	HL,DC0F4
	LD	A,(HL)
	ADD	HL,BC
	LD	(HL),A

	LD	HL,DC0F9
	LD	A,(HL)
	ADD	HL,BC
	LD	(HL),A

	LD	HL,DC0FE
	LD	A,(HL)
	ADD	HL,BC
	LD	(HL),A

	LD	HL,DC103
	LD	A,(HL)
	ADD	HL,BC
	LD	(HL),A

	LD	HL,DC108
	LD	A,(HL)
	ADD	HL,BC
	LD	(HL),A

	LD	HL,DC10D
	LD	A,(HL)
	ADD	HL,BC
	LD	(HL),A

	LD	HL,DC112
	LD	A,(HL)
	ADD	HL,BC
	LD	(HL),A

	LD	HL,DC135
	LD	A,(HL)
	ADD	HL,BC
	LD	(HL),A

	LD	HL,DC11C
	LD	A,(HL)
	ADD	HL,BC
	LD	(HL),A

	LD	HL,DC158
	LD	A,(HL)
	ADD	HL,BC
	LD	(HL),A

	LD	HL,DC15D
	LD	A,(HL)
	ADD	HL,BC
	LD	(HL),A

	_EI
	POP	BC
	DEC	B
	JP	NZ,.1368
	RET

;-----------------------------------------------------------------------

L1424	LD	A,(DC0FE)
	BIT	4,A
	JP	NZ,L191E
	LD	A,(DC11C)
	BIT	3,A
    IF    OPT
	JR	NZ,.1447
    ELSE
	JP	NZ,.1447
    ENDIF
	LD	HL,DC103
	DEC	(HL)
	RET	NZ
	LD	A,0BH
	LD	HL,DC0FE
	BIT	7,(HL)
	JR	Z,.1444
	SUB	03H
.1444	LD	(DC103),A
.1447	CALL	L1DD7
	LD	A,(DC11C)
	BIT	3,A
	JR	Z,.1456
	CALL	L1D84
	JR	.14AD

.1456	CALL	L1E64
	LD	A,(DC163)
	LD	C,A
	LD	HL,DC14E
	BIT	7,(HL)
	JR	Z,.146D
	LD	HL,DC0FE
	SET	4,(HL)
	SET	1,(HL)
	JR	.14AD

.146D	ADD	HL,BC
	BIT	3,(HL)
	JR	NZ,.14AD
	LD	A,(DC108)
	JR	NZ,.147A
	CALL	L17FD
.147A	LD	HL,DC0FE
	BIT	0,(HL)
	JR	Z,.1487
	RES	0,(HL)
	SET	2,(HL)
	JR	.14AD

.1487	SET	0,(HL)
	RES	2,(HL)
	LD	HL,DC0E4
	SET	3,(HL)
	LD	A,(DC10D)
	PUSH	AF
	BIT	4,A
	CALL	NZ,L14FA
	POP	AF
	PUSH	AF
	BIT	5,A
	CALL	NZ,L1593
	POP	AF
	PUSH	AF
	BIT	6,A
	CALL	NZ,L162D
	POP	AF
	BIT	7,A
	CALL	NZ,L16DD
.14AD	LD	A,(DC163)
	LD	C,A
	LD	B,00H
	LD	IX,DC12B
	SLA	C
	ADD	IX,BC
	LD	HL,DC121
	ADD	HL,BC
	LD	A,(HL)
	LD	(IX+00H),A
	INC	HL
	LD	A,(HL)
	LD	(IX+01H),A
	CALL	L14DD
	LD	IX,DC121
	ADD	IX,BC
	LD	(IX+00H),H
	LD	(IX+01H),L
	LD	HL,DC0FE
	SET	3,(HL)
	RET

;-----------------------------------------------------------------------

L14DD	LD	A,(DC0F9)
	LD	L,A
	LD	H,00H
	ADD	HL,HL
	ADD	HL,HL
	ADD	HL,HL
	ADD	HL,HL
	ADD	HL,HL
	LD	DE,NT+0000H
	ADD	HL,DE
	LD	A,(DC0F4)
	CP	0FFH
	JR	NZ,.14F5
	DEC	HL
	RET

.14F5	LD	E,A
	LD	D,00H
	ADD	HL,DE
	RET

;-----------------------------------------------------------------------

L14FA	LD	A,05H
	LD	(DC112),A
	CALL	L14DD
	LD	DE,0FFE0H
	ADD	HL,DE
	CALL	L003B		; set VDP read address = HL
	LD	B,02H
.150B	IN	A,(VDPdata)
	CALL	L17C1
	JR	NZ,.1529
	DJNZ	.150B
	LD	A,(DC0F9)
	CP	08H
	RET	Z
	LD	HL,DC135
	BIT	5,(HL)
	JP	NZ,L17A3
	DEC	A
	LD	(DC0F9),A
	JP	L17B8

.1529	LD	A,(DC135)
	AND	0E0H
	JP	NZ,L17A3
	LD	A,(DC0FE)
	RES	6,A
	LD	(DC0FE),A
	LD	A,(DC10D)
	BIT	3,A
	JR	Z,.156A
.1540	INC	HL
	INC	HL
	LD	B,02H
	LD	DE,0020H
.1547	ADD	HL,DE
	CALL	L003B		; set VDP read address = HL
	IN	A,(VDPdata)
	CALL	L17C1
	JR	Z,.1565
	LD	DE,0FFBEH
	ADD	HL,DE
	LD	A,(DC0FE)
	BIT	6,A
	JP	NZ,L1795
	SET	6,A
	LD	(DC0FE),A
	JR	.156A

.1565	DJNZ	.1547
	JP	L1787

.156A	DEC	HL
	LD	B,02H
	LD	DE,0020H
.1570	ADD	HL,DE
	CALL	L003B		; set VDP read address = HL
	IN	A,(VDPdata)
	CALL	L17C1
	JR	Z,.158E
	LD	DE,003FH
	ADD	HL,DE
	LD	A,(DC0FE)
	BIT	6,A
	JP	NZ,L1795
	SET	6,A
	LD	(DC0FE),A
	JR	.1540

.158E	DJNZ	.1570
	JP	L178E

;-----------------------------------------------------------------------

L1593	LD	A,07H
	LD	(DC112),A
	CALL	L14DD
	LD	DE,0040H
	ADD	HL,DE
	CALL	L003B		; set VDP read address = HL
	LD	B,02H
L15A4	IN	A,(VDPdata)
	CALL	L17C1
	JR	NZ,.15C2
	DJNZ	L15A4
	LD	A,(DC0F9)
	CP	12H
	RET	Z
	LD	HL,DC135
	BIT	4,(HL)
	JP	NZ,L17A3
	INC	A
	LD	(DC0F9),A
	JP	L17B8

.15C2	LD	A,(DC135)
	AND	0D0H
	JP	NZ,L17A3
	LD	A,(DC0FE)
	RES	6,A
	LD	(DC0FE),A
	LD	A,(DC10D)
	BIT	3,A
	JR	Z,.1603
.15D9	INC	HL
	INC	HL
	LD	B,02H
	LD	DE,0FFE0H
.15E0	ADD	HL,DE
	CALL	L003B		; set VDP read address = HL
	IN	A,(VDPdata)
	CALL	L17C1
	JR	Z,.15FE
	LD	DE,003EH
	ADD	HL,DE
	LD	A,(DC0FE)
	BIT	6,A
	JP	NZ,L179C
	SET	6,A
	LD	(DC0FE),A
	JR	.1603

.15FE	DJNZ	.15E0
	JP	L1787

.1603	DEC	HL
	LD	B,02H
	LD	DE,0FFE0H
.1609	ADD	HL,DE
	CALL	L003B		; set VDP read address = HL
	ADD	HL,DE
	IN	A,(VDPdata)
	CALL	L17C1
	JR	NZ,.1628
	LD	DE,0042H
	ADD	HL,DE
	LD	A,(DC0FE)
	BIT	6,A
	JP	NZ,L179C
	SET	6,A
	LD	(DC0FE),A
	JR	.15D9

.1628	DJNZ	.1609
	JP	L178E

;-----------------------------------------------------------------------

L162D	LD	A,(DC0F4)
	CP	0FFH
	JR	NZ,.163C
	LD	HL,DC0FE
	SET	4,(HL)
	SET	1,(HL)
	RET

.163C	LD	A,03H
	LD	(DC112),A
	LD	A,(DC0F4)
	OR	A
	JR	Z,.166B
	CALL	L14DD
	DEC	HL
	CALL	L003B		; set VDP read address = HL
	IN	A,(VDPdata)
	CALL	L17C1
	JR	NZ,.1675
	LD	DE,0020H
	ADD	HL,DE
	CALL	L003B		; set VDP read address = HL
	IN	A,(VDPdata)
	CALL	L17C1
	JR	NZ,.1672
	LD	A,(DC135)
	BIT	7,A
	JP	NZ,L17A3
.166B	LD	HL,DC0F4
	DEC	(HL)
	JP	L17B8

.1672	OR	A
	SBC	HL,DE
.1675	LD	A,(DC135)
	AND	0B0H
	JP	NZ,L17A3
	LD	A,(DC0FE)
	RES	6,A
	LD	(DC0FE),A
	LD	A,(DC10D)
	BIT	2,A
	JR	Z,.16B6
.168C	LD	DE,0041H
	ADD	HL,DE
	CALL	L003B		; set VDP read address = HL
	LD	B,02H
.1695	IN	A,(VDPdata)
	CALL	L17C1
	JR	Z,.16B1
	OR	A
	LD	DE,0041H
	SBC	HL,DE
	LD	A,(DC0FE)
	BIT	6,A
	JP	NZ,L1787
	SET	6,A
	LD	(DC0FE),A
	JR	.16B6

.16B1	DJNZ	.1695
	JP	L1795

.16B6	LD	DE,0FFE1H
	ADD	HL,DE
	CALL	L003B		; set VDP read address = HL
	LD	B,02H
.16BF	IN	A,(VDPdata)
	CALL	L17C1
	JR	Z,.16D8
	OR	A
	SBC	HL,DE
	LD	A,(DC0FE)
	BIT	6,A
	JP	NZ,L1787
	SET	6,A
	LD	(DC0FE),A
	JR	.168C

.16D8	DJNZ	.16BF
	JP	L179C

;-----------------------------------------------------------------------

L16DD	LD	A,(DC0F4)
	CP	1FH
	JR	NZ,.16EC
	LD	HL,DC0FE
	SET	4,(HL)
	SET	1,(HL)
	RET

.16EC	LD	A,01H
	LD	(DC112),A
	LD	A,(DC0F4)
	CP	1EH
	JR	Z,.171D
	CALL	L14DD
	INC	HL
	INC	HL
	CALL	L003B		; set VDP read address = HL
	IN	A,(VDPdata)
	CALL	L17C1
	JR	NZ,.1727
	LD	DE,0020H
	ADD	HL,DE
	CALL	L003B		; set VDP read address = HL
	IN	A,(VDPdata)
	CALL	L17C1
	JR	NZ,.1724
	LD	A,(DC135)
	BIT	6,A
	JP	NZ,L17A3
.171D	LD	HL,DC0F4
	INC	(HL)
	JP	L17B8

.1724	OR	A
	SBC	HL,DE
.1727	LD	A,(DC135)
	AND	70H
	JR	NZ,L17A3
	LD	A,(DC0FE)
	RES	6,A
	LD	(DC0FE),A
	LD	A,(DC10D)
	BIT	2,A
	JR	Z,.1762
.173D	LD	DE,003EH
	ADD	HL,DE
	CALL	L003B		; set VDP read address = HL
	LD	B,02H
.1746	IN	A,(VDPdata)
	CALL	L17C1
	JR	Z,.175E
	OR	A
	SBC	HL,DE
	LD	A,(DC0FE)
	BIT	6,A
	JR	NZ,L178E
	SET	6,A
	LD	(DC0FE),A
	JR	.1762

.175E	DJNZ	.1746
	JR	L1795

.1762	LD	DE,0022H
	OR	A
	SBC	HL,DE
	CALL	L003B		; set VDP read address = HL
	LD	B,02H
.176D	IN	A,(VDPdata)
	CALL	L17C1
	JR	Z,.1783
	ADD	HL,DE
	LD	A,(DC0FE)
	BIT	6,A
	JR	NZ,L178E
	SET	6,A
	LD	(DC0FE),A
	JR	.173D

.1783	DJNZ	.176D
	JR	L179C

;-----------------------------------------------------------------------

L1787	XOR	A
	SET	7,A
	LD	(DC135),A
	RET

L178E	XOR	A
	SET	6,A
	LD	(DC135),A
	RET

L1795	XOR	A
	SET	5,A
	LD	(DC135),A
	RET

L179C	XOR	A
	SET	4,A
	LD	(DC135),A
	RET

L17A3	LD	HL,DC135
	LD	A,(HL)
	RLA
	JP	C,L16DD
	RLA
	JP	C,L162D
	RLA
	JP	C,L1593
	RLA
	JP	C,L14FA
	RET

L17B8	LD	A,(DC135)
	AND	0FH
	LD	(DC135),A
	RET

;-----------------------------------------------------------------------

L17C1	PUSH	HL
	LD	HL,DC10D
	RES	0,(HL)
	CP	08H
	JR	C,.17E5
	CP	6EH
	JR	Z,.17E5
	CP	54H
	JR	C,.17E8
	CP	57H
	JR	C,.17E5
	CP	5BH
	JR	C,.17E8
	CP	5EH
	JR	C,.17E5
	CP	6DH
	JR	NZ,.17E8
	SET	0,(HL)
.17E5	XOR	A
	POP	HL
	RET

.17E8	CP	20H
	JR	C,.17F8
	CP	24H
	JR	NC,.17F8
	LD	A,(DC0E4)
	BIT	3,A
	CALL	NZ,L0EBC
.17F8	LD	A,01H
	OR	A
	POP	HL
	RET

;-----------------------------------------------------------------------

L17FD	LD	HL,DC14E
	LD	A,(DC163)
	LD	C,A
	LD	B,00H
	ADD	HL,BC
	BIT	7,(HL)
	JR	Z,.1827
	PUSH	BC
	LD	A,(HL)
	AND	07H
	SLA	A
	LD	C,A
	LD	B,00H
	LD	HL,DC085	; honey position list
	ADD	HL,BC
	LD	A,(HL)
	CALL	L0477		; A = high 5 bits of A
	LD	(DC164),A
	INC	HL
	LD	A,(HL)
	LD	(DC165),A
	POP	BC
	JR	.1839

.1827	LD	A,(DC036)	; sprite 4 Y
	CALL	L0477		; A = high 5 bits of A
	LD	(DC164),A
	LD	A,(DC037)	; sprite 4 X
	CALL	L0477		; A = high 5 bits of A
	LD	(DC165),A
.1839	XOR	A
	LD	(DC10D),A
	CALL	L18CD
	LD	HL,DC10D
	LD	A,(DC0F9)
	LD	B,A
	LD	A,(DC164)
	SUB	B
	JR	C,.184F
	SET	2,(HL)
.184F	CALL	M,L18C5
	LD	(DC158),A
	LD	A,(DC0F4)
	LD	B,A
	LD	A,(DC165)
	SUB	B
	JR	C,.1861
	SET	3,(HL)
.1861	CALL	M,L18C5
	LD	(DC15D),A
	LD	A,(DC158)
	OR	A
	JR	Z,L18B7
	LD	A,(DC15D)
	OR	A
	JR	Z,L18AD
L1873	LD	A,(DC022)
	LD	B,04H
	LD	HL,DC10D
	BIT	1,A
	JR	Z,.1881
	SLA	B
.1881	BIT	0,A
	LD	A,(HL)
	JR	Z,.188B
	AND	B
	JR	Z,.188E
	JR	.1899

.188B	AND	B
	JR	Z,.1899
.188E	LD	A,(DC135)
	AND	0F0H
	JR	NZ,.18A0
.1895	RES	1,(HL)
	JR	.18A2

.1899	LD	A,(DC135)
	AND	0F0H
	JR	NZ,.1895
.18A0	SET	1,(HL)
.18A2	LD	A,(DC022)
	BIT	1,A
	JR	Z,L18B7
	BIT	1,(HL)
	JR	NZ,L18BB
L18AD	BIT	2,(HL)
	JR	NZ,.18B4
	SET	4,(HL)
	RET

.18B4	SET	5,(HL)
	RET

L18B7	BIT	1,(HL)
	JR	NZ,L18AD
L18BB	BIT	3,(HL)
	JR	NZ,.18C2
	SET	6,(HL)
	RET

.18C2	SET	7,(HL)
	RET

;-----------------------------------------------------------------------

L18C5	PUSH	BC
	LD	B,A
	LD	A,0FFH
	SUB	B
	INC	A
	POP	BC
	RET

;-----------------------------------------------------------------------

L18CD	LD	A,(DC0FE)
	BIT	7,A
	RET	NZ
	LD	HL,DC14E
	ADD	HL,BC
	BIT	7,(HL)
	RET	NZ
	LD	A,(DC108)
	OR	A
	JR	NZ,.1915
	LD	A,R
	AND	01H
	CP	01H
	RET	NZ
	CALL	L387D
	AND	07H
	INC	A
	LD	(DC108),A
	LD	HL,DC10D
	CP	01H
	JR	NZ,.18FA
	SET	4,(HL)
	RET

.18FA	CP	02H
	JR	NZ,.1901
	SET	5,(HL)
	RET

.1901	CP	03H
	JR	NZ,.1908
	SET	6,(HL)
	RET

.1908	CP	04H
	JR	NZ,.190F
	SET	7,(HL)
	RET

.190F	LD	HL,DC108
	LD	(HL),00H
	RET

.1915	DEC	A
	LD	(DC108),A
	RET	Z
	POP	HL
	JP	L1873

;-----------------------------------------------------------------------

L191E	LD	A,(DC14E)
	RLA
	RET	C
	CALL	L387D
	OR	A
	RET	Z
	CP	0BH
	RET	NC
	ADD	A,08H
	LD	(DC0F9),A
	LD	A,R
	RRA
	JR	C,.193A
	XOR	A
	LD	B,01H
	JR	.193E

.193A	LD	A,1EH
	LD	B,02H
.193E	LD	(DC0F4),A
	LD	A,B
	LD	(DC112),A
	CALL	L14DD
	LD	B,02H
.194A	CALL	L003B		; set VDP read address = HL
	PUSH	BC
	LD	B,02H
.1950	IN	A,(VDPdata)
	CALL	L17C1
    IF    OPT
	JR	NZ,.199E
    ELSE
	JP	NZ,.199E
    ENDIF
	DJNZ	.1950
	POP	BC
	LD	DE,0020H
	ADD	HL,DE
	DJNZ	.194A
	OR	A
	SBC	HL,DE
	SBC	HL,DE
	EX	DE,HL
	LD	HL,DC121
	SLA	C
	ADD	HL,BC
	LD	(HL),D
	INC	HL
	LD	(HL),E
	LD	HL,DC12B
	ADD	HL,BC
	LD	(HL),D
	INC	HL
	LD	(HL),E
	SRA	C
	XOR	A
	LD	(DC108),A
	LD	HL,DC14E
	LD	(HL),A
	ADD	HL,BC
	LD	(HL),A
	LD	HL,DC158
	LD	(HL),64H
	LD	HL,DC15D
	LD	(HL),64H
	LD	(DC11C),A
	LD	(DC10D),A
	LD	HL,DC0FE
	LD	(HL),28H
	LD	HL,DC103
	LD	(HL),0BH
	RET

.199E	POP	BC
	LD	HL,DC0FE
	SET	4,(HL)
	RET

;-----------------------------------------------------------------------

L19A5	LD	A,(DC0DA)
	AND	0F8H
	JR	NZ,.19B1
	LD	HL,DC0DB
	RES	7,(HL)
.19B1	LD	A,(DC0DA)
	SUB	08H
	LD	(DC0DA),A
	LD	A,(DC0E3)
	CP	08H
	JR	NC,.19C7
	LD	HL,DC0E4
	LD	(HL),00H
	JR	.19CF

.19C7	LD	A,(DC0E3)
	SUB	08H
	LD	(DC0E3),A
.19CF	LD	A,(DC169)
	INC	A
	LD	B,A
	LD	DE,0000H
	LD	HL,DC0F4
	LD	IX,DC12C
	LD	IY,DC122
.19E2	LD	A,0FFH
	CP	(HL)
	JR	NZ,.19EF
	PUSH	HL
	LD	HL,DC0FE
	ADD	HL,DE
	SET	4,(HL)
	POP	HL
.19EF	DEC	(HL)
	DEC	(IX+00H)
	DEC	(IY+00H)
	INC	HL
	INC	IX
	INC	IX
	INC	IY
	INC	IY
	INC	DE
	DJNZ	.19E2
L1A02	CALL	L1D58
	LD	B,04H
	LD	HL,DC102
.1A0A	SET	3,(HL)
	SET	5,(HL)
	DEC	HL
	DJNZ	.1A0A
	RET

;-----------------------------------------------------------------------

L1A12	LD	A,(DC0DA)
	CP	0F8H
	JR	C,.1A1E
	LD	HL,DC0DB
	LD	(HL),00H
.1A1E	LD	A,(DC0DA)
	ADD	A,08H
	LD	(DC0DA),A
	LD	A,(DC0E3)
	CP	0F8H
	JR	C,.1A34
	LD	HL,DC0E4
	LD	(HL),00H
	JR	.1A39

.1A34	LD	A,(DC0E3)
	ADD	A,08H
.1A39	LD	(DC0E3),A
	LD	B,05H
	LD	DE,0000H
	LD	HL,DC0F4
	LD	IX,DC12C
	LD	IY,DC122
.1A4C	LD	A,1FH
	CP	(HL)
	JR	NZ,.1A59
	PUSH	HL
	LD	HL,DC0FE
	ADD	HL,DE
	SET	4,(HL)
	POP	HL
.1A59	INC	(HL)
	INC	(IX+00H)
	INC	(IY+00H)
	INC	HL
	INC	IX
	INC	IX
	INC	IY
	INC	IY
	INC	DE
	DJNZ	.1A4C
	JR	L1A02

;-----------------------------------------------------------------------

L1A6E	LD	A,(DC169)
	LD	B,A
	LD	HL,DC166
	LD	(HL),01H
.1A77	PUSH	BC
	CALL	L1A83
	LD	HL,DC166
	INC	(HL)
	POP	BC
	DJNZ	.1A77
	RET

L1A83	LD	A,(DC166)
	LD	C,A
	LD	B,00H
	CALL	L1CDC
	LD	HL,DC0FE
	ADD	HL,BC
	BIT	3,(HL)
	RET	Z
	RES	3,(HL)
	BIT	1,(HL)
	JR	NZ,.1AA7
	BIT	4,(HL)
	RET	NZ
	SLA	C
	BIT	5,(HL)
	JR	Z,.1AA7
	RES	5,(HL)
    IF    OPT
	JR	.1B15
    ELSE
	JP	.1B15
    ENDIF

.1AA7	BIT	5,(HL)
	RET	NZ
	LD	A,(DC166)
	LD	C,A
	LD	B,00H
	SLA	C
	BIT	1,(HL)
	JR	NZ,.1ABE
	LD	HL,DC121
	ADD	HL,BC
	LD	A,(HL)
	INC	HL
	LD	L,(HL)
	LD	H,A
.1ABE	PUSH	HL
	LD	HL,DC12B
	ADD	HL,BC
	LD	D,(HL)
	INC	HL
	LD	E,(HL)
	POP	HL
	OR	A
	SBC	HL,DE
	JR	NZ,.1AD4
	PUSH	DE
	POP	IY
	SRA	C
	JP	.1BCA

.1AD4	LD	HL,DC13A
	SLA	C
	ADD	HL,BC
	LD	B,02H
.1ADC	LD	A,D
	CP	NT/256
	JR	Z,.1AEA
	RST	18H		; set VDP write address = DE
	LD	A,(HL)
	CP	0F0H
	JR	C,.1AE8
	XOR	A
.1AE8	OUT	(VDPdata),A
.1AEA	INC	DE
	LD	A,D
	CP	NT/256
	JR	Z,.1AFA
	RST	18H		; set VDP write address = DE
	INC	HL
	LD	A,(HL)
	CP	0F0H
	JR	C,.1AF8
	XOR	A
.1AF8	OUT	(VDPdata),A
.1AFA	PUSH	HL
	LD	HL,001FH
	ADD	HL,DE
	EX	DE,HL
	POP	HL
	INC	HL
	DJNZ	.1ADC
	LD	HL,DC0FE
	SRL	C
	SRL	C
	ADD	HL,BC
	BIT	1,(HL)
	JR	Z,.1B13
	RES	1,(HL)
	RET

.1B13	SLA	C
.1B15	LD	A,(DC0F9)
	CP	08H
	RET	C
	LD	HL,DC121
	ADD	HL,BC
	LD	D,(HL)
	INC	HL
	LD	E,(HL)
	PUSH	DE
	POP	IY
	LD	HL,DC13A
	SLA	C
	ADD	HL,BC
	EX	DE,HL
	SRL	C
	SRL	C
	PUSH	HL
	LD	HL,DC11C
	ADD	HL,BC
	LD	A,(HL)
	AND	0FH
	LD	(HL),A
	POP	HL
	LD	B,02H
.1B3C	CALL	L003B		; set VDP read address = HL
	IN	A,(VDPdata)
	LD	(DE),A
	CP	07H
	JR	NZ,.1B60
	PUSH	HL
	PUSH	DE
	PUSH	BC
	PUSH	AF
	CALL	L1BFC
	POP	AF
	POP	BC
	POP	DE
	POP	HL
	PUSH	BC
	LD	B,00H
	LD	IX,DC14E
	ADD	IX,BC
	POP	BC
	BIT	3,(IX+00H)
	RET	NZ
.1B60	CALL	L17C1
	PUSH	HL
	LD	HL,DC10D
	BIT	0,(HL)
	JR	Z,.1B7D
	PUSH	BC
	LD	B,00H
	LD	HL,DC11C
	ADD	HL,BC
	POP	BC
	BIT	0,B
	JR	NZ,.1B7B
	SET	7,(HL)
	JR	.1B7D

.1B7B	SET	5,(HL)
.1B7D	INC	DE
	IN	A,(VDPdata)
	LD	(DE),A
	POP	HL
	INC	HL
	CP	07H
	JR	NZ,.1BA1
	PUSH	HL
	PUSH	DE
	PUSH	BC
	PUSH	AF
	CALL	L1BFC
	POP	AF
	POP	BC
	POP	DE
	POP	HL
	PUSH	BC
	LD	B,00H
	LD	IX,DC14E
	ADD	IX,BC
	POP	BC
	BIT	3,(IX+00H)
	RET	NZ
.1BA1	PUSH	HL
	CALL	L17C1
	LD	HL,DC10D
	BIT	0,(HL)
	JR	Z,.1BBE
	PUSH	BC
	LD	B,00H
	LD	HL,DC11C
	ADD	HL,BC
	POP	BC
	BIT	0,B
	JR	NZ,.1BBC
	SET	6,(HL)
	JR	.1BBE

.1BBC	SET	4,(HL)
.1BBE	POP	HL
	PUSH	DE
	LD	DE,001FH
	ADD	HL,DE
	POP	DE
	INC	DE
	DEC	B
	JP	NZ,.1B3C
.1BCA	CALL	L1EAB
	PUSH	IY
	POP	DE
	LD	B,02H
.1BD2	PUSH	BC
	LD	B,00H
	LD	HL,DC0F4
	ADD	HL,BC
	LD	L,(HL)
	INC	L
	JR	Z,.1BE3
	PUSH	AF
	RST	18H		; set VDP write address = DE
	POP	AF
	OR	A
	OUT	(VDPdata),A
.1BE3	INC	A
	INC	DE
	LD	H,A
	LD	A,20H
	CP	L
	LD	A,H
	JR	Z,.1BF2
	PUSH	AF
	RST	18H		; set VDP write address = DE
	POP	AF
	OR	A
	OUT	(VDPdata),A
.1BF2	POP	BC
	INC	A
	LD	HL,001FH
	ADD	HL,DE
	EX	DE,HL
	DJNZ	.1BD2
	RET

;-----------------------------------------------------------------------

L1BFC	LD	B,00H
	PUSH	HL
	LD	HL,DC14E
	BIT	7,(HL)
	POP	HL
	JP	NZ,.1C98
	SLA	C
	SLA	C
	LD	IX,DC13A
	ADD	IX,BC
	LD	B,04H
.1C14	LD	A,(IX+00H)
	CP	6DH
	RET	Z
	INC	IX
	DJNZ	.1C14
	SRL	C
	SRL	C
	PUSH	IY
	POP	DE
	EX	DE,HL
	LD	IX,DC085	; honey position list
	LD	A,00H
	LD	B,NC085/2
.1C2E	PUSH	BC
	LD	L,(IX+00H)
	LD	H,00H
	ADD	HL,HL
	ADD	HL,HL
	LD	C,(IX+01H)
	LD	B,00H
	ADD	HL,BC
	LD	BC,3821H
	ADD	HL,BC
	POP	BC
	OR	A
	SBC	HL,DE
	JR	Z,.1C4E
	INC	IX
	INC	IX
	INC	A
	DJNZ	.1C2E
	RET

.1C4E	LD	IX,DC14E
	LD	B,00H
	ADD	IX,BC
	SET	3,(IX+00H)
	LD	E,A
	OR	(IX+00H)
	LD	(IX+00H),A
	LD	A,E
	ADD	A,A
	LD	E,A
	LD	D,00H
	LD	HL,DC085	; honey position list
	ADD	HL,DE
	LD	(HL),0FFH
	INC	HL
	LD	(HL),0FFH
	LD	HL,DC153
	LD	B,00H
	ADD	HL,BC
	LD	(HL),7FH
	LD	HL,DC14F
	LD	B,04H
.1C7C	LD	A,(HL)
	AND	7FH
	LD	(HL),A
	INC	HL
	DJNZ	.1C7C
	SLA	C
	SLA	C
	LD	HL,DC13A
	ADD	HL,BC
	LD	B,04H
.1C8D	LD	A,(HL)
	CP	07H
	JR	NZ,.1C94
	LD	(HL),00H
.1C94	INC	HL
	DJNZ	.1C8D
	RET

.1C98	LD	B,04H
	LD	HL,DC14F
.1C9D	LD	(HL),00H
	INC	HL
	DJNZ	.1C9D
	RET

;-----------------------------------------------------------------------

L1CA3	LD	HL,DC153
	ADD	HL,BC
	DEC	(HL)
	JR	NZ,.1CCD
	LD	HL,DC14E
	ADD	HL,BC
	LD	A,(HL)
	AND	70H
	LD	(HL),A
	LD	HL,DC0FE
	ADD	HL,BC
	RES	7,(HL)
	LD	A,80H
	LD	HL,DC158
	ADD	HL,BC
	LD	(HL),A
	LD	HL,DC15D
	ADD	HL,BC
	LD	(HL),A
	LD	A,07H
	LD	HL,DC112
	LD	(HL),A
	ADD	HL,BC
	LD	(HL),A
	RET

.1CCD	BIT	2,(HL)
	JR	NZ,.1CD5
	LD	A,09H
	JR	.1CD7

.1CD5	LD	A,0AH
.1CD7	LD	HL,DC112
	LD	(HL),A
	RET

;-----------------------------------------------------------------------

L1CDC	LD	HL,DC0FE
	ADD	HL,BC
	BIT	4,(HL)
	RET	NZ
	LD	HL,DC14E
	ADD	HL,BC
	BIT	3,(HL)
	RET	NZ
	LD	HL,DC0F9
	ADD	HL,BC
	LD	A,(HL)
	ADD	A,A
	ADD	A,A
	ADD	A,A
	SUB	04H
	LD	D,A
	LD	A,(DC036)	; sprite 4 Y
	SUB	D
	CALL	C,L18C5
	LD	B,00H
	CP	0AH
	RET	NC
	LD	HL,DC0F4
	ADD	HL,BC
	LD	A,(HL)
	ADD	A,A
	ADD	A,A
	ADD	A,A
	LD	D,A
	LD	A,(DC037)	; sprite 4 X
	SUB	D
	CALL	C,L18C5
	LD	B,00H
	CP	06H
	RET	NC

	LD	A,(DC01D)
	OR	A
	RET	Z

L1D1B	LD	HL,DC200
	LD	(HL),87H

	LD	A,08H
	LD	(DC022),A
	LD	A,80H
	CALL	L079C		; set sprite 4+5 pattern
	LD	A,02H
	LD	(DC0BF),A
	LD	A,90H
	LD	(DC07B),A
	XOR	A
	LD	(DC01D),A
	LD	(DC0C0),A
	INC	A
	LD	(DC0C2),A
	LD	A,07H
	LD	(DC024),A
	LD	A,(DC0BE)	; count of flowers picked
	RRCA			; divide by 2
	AND	7FH
	LD	(DC0BE),A
	LD	HL,DC103
	LD	B,05H
.1D52	LD	(HL),77H
	INC	HL
	DJNZ	.1D52
	RET

;-----------------------------------------------------------------------

L1D58	LD	A,(DC169)
	LD	B,A
	LD	DE,0001H
	LD	IY,DC11D
.1D63	BIT	3,(IY+00H)
	JR	Z,.1D7E
	LD	HL,DC0F9
	ADD	HL,DE
	LD	A,(HL)
	LD	(DC0F9),A
	LD	HL,DC0F4
	ADD	HL,DE
	LD	A,(HL)
	LD	(DC0F4),A
	PUSH	BC
	CALL	L1DB3
	POP	BC
.1D7E	INC	IY
	INC	DE
	DJNZ	.1D63
	RET

;-----------------------------------------------------------------------

L1D84	LD	HL,DC11C
	LD	A,(DC14E)
	RLA
	JR	C,.1D96
	LD	A,(HL)
	AND	0F8H
	LD	B,A
	LD	A,(HL)
	AND	07H
	JR	NZ,.1D9C
.1D96	RES	3,(HL)
	LD	A,0E8H	; 232
	JR	L1DC1

.1D9C	LD	E,A
	LD	D,00H
	DEC	A
	OR	B
	LD	(HL),A
	LD	HL,D1DCF
	ADD	HL,DE
	LD	A,(HL)
	LD	(DC168),A
	CP	0FCH
	JR	NZ,L1DB3
	LD	HL,DC0FE
	SET	7,(HL)
L1DB3	LD	A,(DC0F4)
	ADD	A,A
	ADD	A,A
	ADD	A,A
	LD	B,A
	LD	A,(DC0F9)
	ADD	A,A
	ADD	A,A
	ADD	A,A
	DEC	A
L1DC1	LD	(DC04E),A
	LD	A,B
	LD	(DC04F),A
	LD	A,(DC168)
	LD	(DC050),A
	RET

D1DCF	DB	00H,0F0H,0F4H,0F8H,0FCH,0F8H,0F4H,0F0H

;-----------------------------------------------------------------------

L1DD7	LD	A,(DC0FE)
	RLA
	RET	C
	LD	HL,DC14E
	BIT	7,(HL)
	RET	NZ
	ADD	HL,BC
	LD	A,(HL)
	AND	88H
	RET	NZ
	LD	A,(DC158)
	CP	05H
	RET	NC
	LD	A,(DC15D)
	CP	05H
	RET	NC
	LD	HL,DC11D
	LD	A,(DC169)
	LD	B,A
.1DFA	BIT	3,(HL)
	RET	NZ
	INC	HL
	DJNZ	.1DFA
	SLA	C
	SLA	C
	LD	HL,DC13A
	ADD	HL,BC
	LD	B,04H
.1E0A	LD	A,(HL)
	CP	6DH
	RET	Z
	INC	HL
	DJNZ	.1E0A
	CALL	L14DD
.1E14	LD	A,(DC15D)
	OR	A
	JR	Z,.1E29
	DEC	A
	LD	(DC15D),A
	LD	A,(DC10D)
	BIT	3,A
	JR	Z,.1E28
	INC	HL
	JR	.1E29

.1E28	DEC	HL
.1E29	LD	A,(DC158)
	OR	A
	JR	Z,.1E44
	DEC	A
	LD	(DC158),A
	LD	A,(DC10D)
	BIT	2,A
	JR	Z,.1E40
	LD	DE,0020H
	ADD	HL,DE
	JR	.1E44

.1E40	LD	DE,0FFE0H
	ADD	HL,DE
.1E44	CALL	L003B		; set VDP read address = HL
	IN	A,(VDPdata)
	CP	6EH
	JR	Z,.1E54
	CP	28H
	JR	C,.1E54
	CP	88H
	RET	C
.1E54	LD	A,(DC158)
	LD	B,A
	LD	A,(DC15D)
	OR	B
	JR	NZ,.1E14
	LD	HL,DC11C
	LD	(HL),0FH
	RET

;-----------------------------------------------------------------------

L1E64	LD	DE,0000H
	LD	B,NC085/2
.1E69	LD	HL,DC085	; honey position list
	ADD	HL,DE
	LD	A,(HL)
	INC	A
	JR	Z,.1EA6
	DEC	A
	CALL	L0477		; A = high 5 bits of A
	LD	C,A
	LD	A,(DC0F9)
	SUB	C
	CALL	C,L18C5
	CP	05H
	JR	NC,.1EA6
	INC	HL
	LD	A,(HL)
	LD	C,A
	LD	A,(DC0F4)
	SUB	C
	CALL	C,L18C5
	CP	05H
	JR	NC,.1EA6
	LD	HL,DC14E
	LD	A,(DC163)
	LD	C,A
	LD	B,00H
	ADD	HL,BC
	BIT	3,(HL)
	RET	NZ
	LD	A,(HL)
	AND	0F0H
	SRA	E
	OR	E
	SET	7,A
	LD	(HL),A
	RET

.1EA6	INC	DE
	INC	DE
	DJNZ	.1E69
	RET

;-----------------------------------------------------------------------

L1EAB	LD	HL,DC14E
	ADD	HL,BC
	BIT	3,(HL)
	JR	Z,.1EB8
	CALL	L1CA3
	JR	.1ECA

.1EB8	LD	HL,DC112
	ADD	HL,BC
	LD	A,(HL)
	LD	HL,DC0FE
	ADD	HL,BC
	BIT	2,(HL)
	JR	Z,.1EC6
	INC	A
.1EC6	BIT	7,(HL)
	JR	NZ,.1ED3
.1ECA	LD	HL,DC117
	ADD	HL,BC
	CP	(HL)
	JP	Z,.1F77
	LD	(HL),A
.1ED3	DEC	A
	LD	HL,DC11C
	ADD	HL,BC
	LD	E,(HL)
	LD	HL,DC162
	LD	(HL),E
	LD	HL,0000H
	LD	DE,0020H
	LD	B,C
.1EE4	ADD	HL,DE
	DJNZ	.1EE4
	LD	DE,0F60H
	ADD	HL,DE
	LD	(DC16B),HL
	LD	DE,0800H
	ADD	HL,DE
	LD	(DC16D),HL
	LD	DE,1800H
	ADD	HL,DE
	LD	(DC16F),HL
	LD	DE,0800H
	ADD	HL,DE
	LD	(DC171),HL
	LD	B,04H
.1F05	PUSH	BC
	PUSH	AF
	LD	HL,DC162
	RLC	(HL)
	LD	L,A
	LD	H,00H
	ADD	HL,HL
	ADD	HL,HL
	ADD	HL,HL
	ADD	HL,HL
	ADD	HL,HL
	LD	A,04H
	SUB	B
	ADD	A,A
	ADD	A,A
	ADD	A,A
	LD	E,A
	LD	D,00H
	EX	AF,AF'
	ADD	HL,DE
	LD	DE,D1FCC
	ADD	HL,DE
	LD	DE,(DC16B)
	LD	BC,0008H
	PUSH	HL
	CALL	L0008		; write data to VDP: HL=data, DE=VRAM address, BC=length
	LD	HL,0008H
	ADD	HL,DE
	LD	(DC16B),HL
	POP	HL
	PUSH	HL
	CALL	L1F7E
	LD	DE,(DC16F)
	LD	BC,0008H
	CALL	L0008		; write data to VDP: HL=data, DE=VRAM address, BC=length
	LD	HL,0008H
	ADD	HL,DE
	LD	(DC16F),HL
	POP	HL
	LD	DE,(DC16D)
	LD	BC,0008H
	PUSH	HL
	CALL	L0008		; write data to VDP: HL=data, DE=VRAM address, BC=length
	LD	HL,0008H
	ADD	HL,DE
	LD	(DC16D),HL
	POP	HL
	CALL	L1F7E
	LD	DE,(DC171)
	LD	BC,0008H
	CALL	L0008		; write data to VDP: HL=data, DE=VRAM address, BC=length
	LD	HL,0008H
	ADD	HL,DE
	LD	(DC171),HL
	POP	AF
	POP	BC
	DJNZ	.1F05
.1F77	LD	A,C
	DEC	A
	ADD	A,A
	ADD	A,A
	ADD	A,0F0H
	RET

L1F7E	LD	A,(DC166)
	LD	C,A
	LD	B,00H
	LD	HL,DC14E
	BIT	7,(HL)
	JR	NZ,.1FA6
	ADD	HL,BC
	BIT	3,(HL)
	JR	Z,.1FA6
	LD	A,(DC112)
	CP	09H
	JR	NZ,.1FA1
	LD	HL,D212C
.1F9A	EX	AF,AF'
	LD	E,A
	EX	AF,AF'
	LD	D,00H
	ADD	HL,DE
	RET

.1FA1	LD	HL,D214C
	JR	.1F9A

.1FA6	LD	HL,DC0FE
	ADD	HL,BC
	BIT	7,(HL)
	JR	NZ,.1FBD
	LD	A,(DC162)
	BIT	0,A
	JR	NZ,.1FB9
	LD	HL,D210C
	RET

.1FB9	LD	HL,D2114
	RET

.1FBD	LD	A,(DC162)
	BIT	0,A
	JR	NZ,.1FC8
	LD	HL,D211C
	RET

.1FC8	LD	HL,D2124
	RET

; bears
D1FCC
;	................
;	................
;	................
;	.....###........
;	....#..####.....
;	....#.######....
;	....########....
;	.##..###.#..##..
;	.#.######....#..
;	..#######...#...
;	.#####.###.#....
;	.######...#.....
;	###########.....
;	#########.#.....
;	##...####.##....
;	......####.##...

	HEX	00 00 00 07 09 0B 0F 67  00 00 00 00 E0 F0 F0 4C
	HEX	5F 3F 7D 7E FF FF C7 03  84 88 D0 20 E0 A0 B0 D8

;	................
;	.......###......
;	......#..####...
;	......#.######..
;	......########..
;	...##..###.#..#.
;	...#.######...##
;	....#######....#
;	....####.###..#.
;	....#####...##..
;	....#########...
;	.....##.#####...
;	.......#####....
;	........###.....
;	................
;	................

	HEX	00 01 02 02 03 19 17 0F  00 C0 78 FC FC D2 E3 E1
	HEX	0F 0F 0F 06 01 00 00 00  72 8C F8 F8 F0 E0 00 00

;	................
;	................
;	................
;	........###.....
;	.....####..#....
;	....######.#....
;	....########....
;	..##..#.###..##.
;	..#....######.#.
;	...#...#######..
;	....#.###.#####.
;	.....#...######.
;	.....###########
;	.....#.#########
;	....##.####...##
;	...##.####......

	HEX	00 00 00 00 07 0F 0F 32  00 00 00 E0 90 D0 F0 E6
	HEX	21 11 0B 04 07 05 0D 1B  FA FC BE 7E FF FF E3 C0

;	................
;	......###.......
;	...####..#......
;	..######.#......
;	..########......
;	.#..#.###..##...
;	##...######.#...
;	#....#######....
;	.#..###.####....
;	..##...#####....
;	...#########....
;	...#####.##.....
;	....#####.......
;	.....###........
;	................
;	................

	HEX	00 03 1E 3F 3F 4B C7 87  00 80 40 40 C0 98 E8 F0
	HEX	4E 31 1F 1F 0F 07 00 00  F0 F0 F0 60 80 00 00 00

;	................
;	................
;	................
;	...##....##.....
;	..##########....
;	..##########....
;	...########.....
;	..###....###....
;	..##.####..#....
;	...####.###.....
;	..####.#.###....
;	.###########....
;	.##..##.#####...
;	.##..#...####...
;	..###....####...
;	........####....

	HEX	00 00 00 18 3F 3F 1F 38  00 00 00 60 F0 F0 E0 70
	HEX	37 1E 3D 7F 66 64 38 00  90 E0 70 F0 F8 78 78 F0

;	...##....##.....
;	..##########....
;	..##########....
;	...########.....
;	..###....###....
;	..#..####.##....
;	...###.####.....
;	..###.#.####....
;	..###########...
;	.#####.##..##...
;	.####...#..##...
;	.####....###....
;	..####..........
;	................
;	................
;	................

	HEX	18 3F 3F 1F 38 27 1D 3A  60 F0 F0 E0 70 B0 E0 F0
	HEX	3F 7D 78 78 3C 00 00 00  F8 98 98 70 00 00 00 00

;	....##....##....
;	...#..####..#...
;	...#.######.#...
;	...###.##.###...
;	....###..###....
;	...###..#.##....
;	..####....###...
;	..##.##..##.##..
;	..###.###..####.
;	..#############.
;	...#####...####.
;	...####...####..
;	................
;	................
;	................
;	................

	HEX	0C 13 17 1D 0E 1C 3C 36  30 C8 E8 B8 70 B0 38 6C
	HEX	3B 3F 1F 1E 00 00 00 00  9E FE 1E 3C 00 00 00 00

;	................
;	................
;	....##....##....
;	...#..####..#...
;	...#.######.#...
;	...###.##.###...
;	....###..###....
;	....##..#.###...
;	...###....####..
;	..##.##..##.##..
;	.####..###.###..
;	.#############..
;	.####...######..
;	..####...####...
;	.........####...
;	........####....

	HEX	00 00 0C 13 17 1D 0E 0C  00 00 30 C8 E8 B8 70 B8
	HEX	1C 36 79 7F 78 3C 00 00  3C 6C DC FC FC 78 78 F0

;	................	honey eating bear, honey down
;	.##....##.......
;	#..####..#......
;	#.######.#......
;	###.##.###......
;	.###..###.......
;	###..#.###......
;	.##....##.......
;	..#####.##......
;	..#####.###.....
;	...###..###.....
;	...###..###.....
;	.##########.....
;	.#########......
;	..#####.##......
;	.####.###.......

	HEX	00 61 9E BF ED 73 E5 61  00 80 40 40 C0 80 C0 80
	HEX	3E 3E 1C 1C 7F 7F 3E 7B  C0 E0 E0 E0 E0 C0 C0 80

;	................	honey eating bear, honey up
;	...#####........
;	.#########......
;	#.#.##.##.#.....
;	####..#####.....
;	..#####.##......
;	.#########......
;	.########.......
;	.#########......
;	.##########.....
;	..#####.###.....
;	#.######.##.....
;	##..###..##.....
;	####.#.###......
;	#####.####......
;	.####.###.......

	HEX	00 1F 7F AD F3 3E 7F 7F  00 00 C0 A0 E0 C0 C0 80
	HEX	7F 7F 3E BF CE F5 FB 7B  C0 E0 E0 60 60 C0 C0 80

; color tables

D210C	HEX	1A 1A 1A 1A 1A 1A 1A 1A

D2114	HEX	1F 1F 13 13 1F 1F 13 13

D211C	HEX	4A 4A 4A 4A 4A 4A 4A 4A

D2124	HEX	4F 4F 43 43 4F 4F 43 43

D212C	HEX	0A 1A 1A 1A 1A 1A 1A 1A
	HEX	0A 1A 1A 1A 1A 1A 1A 1A
	HEX	41 41 41 41 41 41 41 1A
	HEX	1A 1A 1A 1A 1A 1A 1A 1A

D214C	HEX	0A 1A 1A 1A 1A 41 41 4A
	HEX	0A 0A 1A 1A 1A 1A 1A 1A
	HEX	41 41 41 1A 1A 1A 1A 1A
	HEX	1A 1A 1A 1A 1A 1A 1A 1A

;-----------------------------------------------------------------------

L216C	LD	HL,NT+02EDH
	RST	28H		; set VDP write address = HL
	LD	A,(DC0BE)	; count of flowers picked
	LD	C,A
	OR	A
	JR	Z,.219B

	CP	0AH		; more than 10 flowers picked?
	JR	C,.217D
	LD	A,0AH		; set to 10 if 10+
.217D	LD	B,A
.217E	LD	A,05H		; flower
	OUT	(VDPdata),A
	PUSH	AF
	POP	AF
	PUSH	AF
	POP	AF
	DJNZ	.217E

	LD	A,C		; return if 10 already shown
	CP	0AH
	RET	NC

	LD	A,0AH		; computer number of sprouts
	SUB	C
	LD	B,A

.2190	LD	A,3AH		; sprout
	OUT	(VDPdata),A
	PUSH	AF
	POP	AF
	PUSH	AF
	POP	AF
	DJNZ	.2190
	RET

.219B	LD	B,0AH
	JR	.2190

;-----------------------------------------------------------------------

; update hearts
L219F	LD	HL,NT+02E1H
	RST	28H		; set VDP write address = HL

	LD	A,(DC00F)	; remaining lives ("love")
	LD	C,A
	OR	A
	JR	Z,.21CD		; print 5 blanks if none left

	CP	06H
	JR	C,.21B1
	LD	A,05H		; cap displayed hearts at 5
	LD	C,A
.21B1	LD	B,A
.21B2	LD	A,01H		; heart
	OUT	(VDPdata),A
	PUSH	AF
	POP	AF
	PUSH	AF
	POP	AF
	DJNZ	.21B2
	LD	A,05H
	SUB	C
	LD	B,A
	OR	A
	RET	Z
.21C2	LD	A,02H		; black square
	OUT	(VDPdata),A
	PUSH	AF
	POP	AF
	PUSH	AF
	POP	AF
	DJNZ	.21C2
	RET

.21CD	LD	B,05H
	JR	.21C2

;-----------------------------------------------------------------------

L21D1	LD	HL,NT+02E8H
	RST	28H		; set VDP write address = HL
	LD	DE,DC00E	; remaining honey
	LD	B,01H		; 2 digits
	LD	C,00H	; $OPT: CALL L2AAA	; clear leading zero flag
	CALL	L2AAC		; print BCD number: DE=address, B=bytes
	RET

;-----------------------------------------------------------------------

L21E0	LD	HL,NT+02F9H
	RST	28H		; set VDP write address = HL
	LD	DE,DC00A	; round number
	LD	B,01H		; 2 digits
	LD	C,00H	; $OPT: CALL L2AAA	; clear leading zero flag
	CALL	L2AAC		; print BCD number: DE=address, B=bytes
	RET

;-----------------------------------------------------------------------

L21EF	LD	A,(DC0BF)
	OR	A
	RET	Z
	LD	IX,DC036
	CP	02H
	JR	Z,.222C
	LD	A,(DC0C0)
	INC	A
	LD	(DC0C0),A
	CP	0B4H
	JR	C,L2261
	LD	A,(DC020)
	CALL	L0441
	LD	A,(DC021)
	CALL	L0470
	LD	A,08H
	LD	(DC022),A
	LD	A,80H
	CALL	L079C		; set sprite 4+5 pattern
	LD	A,02H
	LD	(DC0BF),A
	LD	A,10H
	LD	(DC07B),A
	XOR	A
	LD	(DC0C0),A
	RET

.222C	CALL	L25D3
	LD	HL,DC14E
	SET	7,(HL)
	LD	A,(DC0CA)
	CP	06H
	JR	NZ,L2261
	XOR	A
	LD	(DC0CA),A
	LD	A,01H
	LD	(DC022),A
	LD	A,07H
	LD	(DC024),A
	LD	A,10H
	CALL	L079C		; set sprite 4+5 pattern
	LD	HL,DC14E
	RES	7,(HL)
	XOR	A
	LD	(DC0BF),A
	LD	(DC14E),A
	INC	A
	LD	(DC01D),A
	JP	L2CA2

;-----------------------------------------------------------------------

L2261	LD	A,(DC024)
	OR	A
	JR	Z,.226C
	DEC	A
	LD	(DC024),A
	RET

.226C	LD	A,07H
	LD	(DC024),A
	LD	A,(DC023)
	OR	A
	JR	Z,.227C
	XOR	A
	LD	(DC023),A
	RET

.227C	LD	A,08H
	LD	(DC023),A
	RET

;-----------------------------------------------------------------------

L2282	LD	A,(DC07A)
	OR	A
	RET	Z
	CP	02H
  if  coleco
	JR	Z,.230C
;	JP	Z,.230C
  else
	JP	Z,.230C
  endif
	CP	03H
	JP	Z,L235D
	CP	04H
	JP	NC,L2412
	LD	A,(DC07B)
	DEC	A
	LD	(DC07B),A
	RET	NZ
	LD	A,64H
	LD	(DC07B),A
	CALL	L298E
	LD	A,(DC0C4)
	LD	L,A
	LD	H,00H
	ADD	HL,HL
	ADD	HL,HL
	ADD	HL,HL
	ADD	HL,HL
	LD	DE,D26D2
	ADD	HL,DE
	LD	DE,PT+0800H+03H*8
	LD	BC,0010H
	_DI
	PUSH	AF
	PUSH	HL
	RST	08H		; write data to VDP: HL=data, DE=VRAM address, BC=length
	POP	HL
	LD	DE,PT+1000H+03H*8
	LD	BC,0010H
	RST	08H		; write data to VDP: HL=data, DE=VRAM address, BC=length
	POP	AF
	_EI
	LD	L,A
	LD	H,00H
	CP	01H
	JR	NZ,.22D2
	LD	HL,0080H	; use second half of D26F2
.22D2	LD	DE,D26F2
	ADD	HL,DE
	LD	DE,SPT+40H*8
	LD	BC,N26F2	; 40-4F
	_DI
	PUSH	AF
	RST	08H		; write data to VDP: HL=data, DE=VRAM address, BC=length
	POP	AF
	_EI
	INC	A
	LD	(DC0C4),A
	CP	02H
	RET	C
	XOR	A
	LD	(DC0C4),A
	LD	A,02H
	LD	(DC07A),A
	LD	A,(DC036)	; sprite 4 Y
	SUB	10H
	LD	(DC062),A
	LD	A,(DC037)	; sprite 4 X
	ADD	A,0CH
	LD	(DC063),A
	LD	A,90H
	LD	(DC064),A
	LD	A,0DH
	LD	(DC065),A
	RET

.230C	LD	A,(DC07B)
	DEC	A
	LD	(DC07B),A
	RET	NZ
	LD	A,08H
	LD	(DC07B),A
	LD	A,(DC062)
	DEC	A
	LD	(DC062),A
	AND	07H
	OR	A
	RET	NZ
	LD	A,(DC064)
	ADD	A,04H
	LD	(DC064),A
	CP	0A4H
	RET	NZ
	LD	A,03H
	LD	(DC07A),A
	XOR	A
	LD	(DC0DB),A
	CALL	L0A19		; clear sprites 16 and 17

	LD	HL,D235A	; BCD 010000
	LD	DE,DC007	; bonus score
	LD	BC,N235A
	LDIR			; set bonus score = 10000

	LD	HL,D2354	; "BONUS"
	LD	DE,NT+006AH
	LD	B,N2354-1
	_DI
	CALL	L2D31		; write data to VDP: HL=data, DE=VRAM address, B=length
	_EI

	RET

D2354	DB	_B,_O,_N,_U,_S,02H
N2354	EQU	$-D2354

D235A	DB	01H,00H,00H	; BCD 010000
N235A	EQU	$-D235A

L235D	CALL	L2AEC
	LD	A,(DC07B)
	DEC	A
	LD	(DC07B),A
	AND	07H
	OR	A
	RET	NZ

	LD	HL,DC200
	LD	(HL),8AH

	LD	IX,DC03E
	LD	A,(DC019)	; time remaining?
	LD	B,A
	LD	A,58H
	ADD	A,B
	CALL	L2907
	LD	A,B
	DEC	A
	LD	(DC019),A	; time remaining?
	OR	A
	JR	NZ,.23ED
	LD	A,04H
	LD	(DC07A),A
	LD	A,(DC062)
	LD	(DC05E),A
	LD	A,0A4H
	LD	(DC064),A
	LD	HL,DC200
	LD	(HL),8BH
	LD	A,(DC063)
	BIT	7,A
	JR	Z,.23C7
	XOR	A
	LD	(DC05F),A
	LD	A,0B4H
	LD	(DC060),A
	LD	A,8FH
	LD	(DC061),A
	LD	A,(DC062)
	LD	(DC05A),A
	LD	A,(DC063)
	LD	(DC05B),A
	LD	A,0B8H
	LD	(DC05C),A
	LD	A,0DH
	LD	(DC05D),A
	RET

.23C7	LD	A,0FFH
	LD	(DC05F),A
	LD	A,0B0H
	LD	(DC060),A
	LD	A,0FH
	LD	(DC061),A
	LD	A,(DC062)
	LD	(DC05A),A
	LD	A,(DC063)
	LD	(DC05B),A
	LD	A,0ACH
	LD	(DC05C),A
	LD	A,0DH
	LD	(DC05D),A
	RET

.23ED	LD	IX,DC03E
	LD	A,(DC048)
	CP	50H
	JR	NZ,.23FC
	LD	A,58H
	JR	.23FE

.23FC	LD	A,50H
.23FE	CALL	L290E
	LD	A,(DC064)
	CP	0A0H
	JR	NZ,.240C
	LD	A,0A4H
	JR	.240E

.240C	LD	A,0A0H
.240E	LD	(DC064),A
	RET

;-----------------------------------------------------------------------

L2412	LD	A,(DC060)
	CP	0B0H
	JR	NZ,.242F
	LD	A,(DC05F)
	DEC	A
	DEC	A
	LD	(DC05F),A
	AND	0FEH
	LD	B,A
	LD	A,(DC063)
	DEC	A
	DEC	A
	AND	0FEH
	CP	B
	RET	NZ
	JR	.2443

.242F	LD	A,(DC05F)
	INC	A
	INC	A
	LD	(DC05F),A
	AND	0FEH
	LD	B,A
	LD	A,(DC063)
	ADD	A,22H
	AND	0FEH
	CP	B
	RET	NZ
.2443	LD	HL,DC200
	LD	(HL),8CH
	CALL	L2B00
	_DI
	XOR	A		; bonus index = 0
	LD	DE,DC004+2	; current score
	LD	HL,DC007+2	; bonus score
	CALL	L2A46		; add to score
	CALL	L2A82		; check for high score
	_EI
    IF    OPT
	CALL	L0069		; delay a bit
    ELSE
	LD	B,02H
	CALL	L006B		; delay a while
    ENDIF
	_DI
	LD	A,(DC0BE)	; count of flowers picked
	SUB	0AH
	JR	Z,.2474
	LD	B,A
.2468	LD	A,02H		; 500 points
	PUSH	BC
	CALL	L2A40		; add to score
	CALL	L2A82		; check for high score
	POP	BC
	DJNZ	.2468
.2474	_EI
    IF    OPT
	CALL	L0069		; delay a bit
    ELSE
	LD	B,02H
	CALL	L006B		; delay a while
    ENDIF

	LD	A,(DC00A)	; round number
	ADD	A,01H		; increment round number (BCD)
	DAA
	LD	(DC00A),A	; round number

	LD	A,(DC00D)
	INC	A
	LD	(DC00D),A

	LD	A,(DC00E)	; remaining honey
	ADD	A,01H		; increment honey (BCD)
	DAA
	LD	(DC00E),A	; remaining honey

	_DI
  if coleco
	LD	A,1
	LD	(NMIDIS),A

	LD	A,82H|20H	; register 1 = 82H
  else
	LD	A,82H		; register 1 = 82H
  endif
	OUT	(VDPcmd),A	; 16K, blank screen, disable V-int, 16x16 sprites
	LD	A,81H
	OUT	(VDPcmd),A

	LD	HL,DC018	; clear a bunch of stuff
	LD	DE,DC018+1
	LD	BC,NC018-1	; 015AH
	LD	(HL),00H
	LDIR

	CALL	L30DB
	POP	HL
	JP	L00C3

;-----------------------------------------------------------------------

L24B0	LD	A,(DC0CA)
	OR	A
	RET	Z

	LD	IX,DC036
	CP	07H
	JP	Z,.25BB
	CP	05H
	JP	Z,.258A
	CP	04H
	JP	Z,.2556
	CP	02H
	JR	Z,.24F4
	CP	03H
	JP	Z,.25A8
	CP	06H
	RET	NC
	LD	A,(DC062)
	DEC	A
	LD	(DC062),A
	CP	(IX+00H)
	JR	NZ,.24E6
	LD	A,04H
	LD	(DC0CA),A
	RET

.24E6	AND	07H
	RET	NZ
	LD	A,(DC063)
	INC	A
	LD	(DC063),A
	LD	(DC0CE),A
	RET

.24F4	LD	A,(DC0CE)
	LD	B,A
	LD	A,(DC0CB)
	INC	A
	LD	(DC0CB),A
	LD	D,A
	ADD	A,B
	LD	(DC063),A
	LD	A,(DC0CC)
	LD	C,A
	LD	A,D
	SUB	C
	JP	P,.2513
	LD	A,(DC0CB)
	LD	B,A
	LD	A,C
	SUB	B
.2513	LD	D,00H
	LD	E,A
	LD	H,A
	LD	L,D
	LD	B,08H
.251A	ADD	HL,HL
	JR	NC,.251E
	ADD	HL,DE
.251E	DJNZ	.251A
	LD	B,10H
	XOR	A
.2523	ADD	HL,HL
	RLA
	CP	C
	JR	C,.252B
	SUB	C
	SET	0,L
.252B	DJNZ	.2523
	LD	A,L
	SUB	C
	ADD	A,(IX+00H)
	LD	(DC062),A
	LD	A,(DC063)
	CP	(IX+01H)
	RET	NZ
	LD	A,03H
	LD	(DC0CA),A
	LD	A,32H
	LD	(DC07B),A
	LD	HL,DC062
	LD	B,04H
.254B	LD	(HL),0F0H
	INC	HL
	DJNZ	.254B
	LD	HL,DC200
	LD	(HL),94H
	RET

.2556	LD	A,(DC0CD)
	INC	A
	LD	(DC0CD),A
	CP	61H
	JR	NC,.2579
	LD	L,A
	LD	H,00H
	ADD	HL,HL
	LD	DE,D2610
	ADD	HL,DE
	LD	A,(HL)
	ADD	A,(IX+2CH)
	LD	(DC062),A
	INC	HL
	LD	A,(HL)
	ADD	A,(IX+2DH)
	LD	(DC063),A
	RET

.2579	LD	A,02H
	LD	(DC0CA),A
	LD	A,(DC037)	; sprite 4 X
	SUB	(IX+2DH)
	SRL	A
	LD	(DC0CC),A
	RET

.258A	LD	A,(DC07B)
	DEC	A
	LD	(DC07B),A
	RET	NZ
	LD	A,14H
	LD	(DC07B),A
	LD	A,(DC064)
	ADD	A,04H
	LD	(DC064),A
	CP	0A4H
	RET	NZ
	LD	A,01H
	LD	(DC0CA),A
	RET

.25A8	LD	A,(DC07B)
	DEC	A
	LD	(DC07B),A
	RET	NZ
	LD	HL,DC200
	LD	(HL),81H
	LD	A,06H
	LD	(DC0CA),A
	RET

.25BB	LD	A,(DC07B)
	DEC	A
	LD	(DC07B),A
	RET	NZ
	LD	A,14H
	LD	(DC07B),A
	LD	HL,DC200
	LD	(HL),93H
	LD	A,05H
	LD	(DC0CA),A
	RET

;-----------------------------------------------------------------------

L25D3	LD	A,(DC0CA)
	OR	A
	RET	NZ

	LD	A,(DC00F)	; remaining lives ("love")
	OR	A
	JP	Z,L3088		; game over
	DEC	A		; decrement remaining lives
	LD	(DC00F),A	; remaining lives ("love")

	LD	HL,D260C
	LD	DE,DC062	; sprite 15
	LD	BC,N260C
	LDIR

	LD	A,(DC00F)	; remaining lives ("love")
	INC	A
	RLCA
	RLCA
	RLCA
	AND	0F8H
	LD	(DC063),A	; sprite 15 X = horizontal position of flying heart

	XOR	A
	LD	(DC0CD),A
	LD	(DC0CB),A
	LD	A,07H
	LD	(DC0CA),A
	_DI
	CALL	L219F		; update hearts
	_EI
	RET

; re-initialization for DC062 (sprite 15)
D260C	DB	0B0H,08H,90H,0DH	; Y X pattern color
N260C	EQU	$-D260C

;-----------------------------------------------------------------------

D2610	HEX	FF 00 FF 01 FF 00 FF 00
	HEX	FF 01 FF 00 FF 01 FF 00
	HEX	FF 01 FF 01 FF 01 FF 01
	HEX	FF 01 FF 01 00 01 FF 01
	HEX	00 01 FF 01 00 01 00 01
	HEX	FF 01 00 01 00 01 00 01
	HEX	00 01 00 01 00 01 00 01
	HEX	01 01 00 01 00 01 01 01
	HEX	00 01 01 01 00 01 01 01
	HEX	01 01 01 01 01 01 01 01
	HEX	01 01 01 00 01 01 01 00
	HEX	01 01 01 00 01 00 01 01
	HEX	01 00 01 00 01 00 01 00
	HEX	01 00 01 00 01 00 01 FF
	HEX	01 00 01 00 01 FF 01 00
	HEX	01 FF 01 00 01 FF 01 FF
	HEX	01 FF 01 FF 01 FF 01 FF
	HEX	00 FF 01 FF 00 FF 01 FF
	HEX	00 FF 00 FF 01 FF 00 FF
	HEX	00 FF 00 FF 00 FF 00 FF
	HEX	00 FF 00 FF FF FF 00 FF
	HEX	00 FF FF FF 00 FF FF FF
	HEX	00 FF FF FF FE FE FE FE
	HEX	FE FF FE FF FD FF FD 00
	HEX	FD 00

D26D2	HEX	FF F3 D5 EA D5 2D 36 2C 38 20 00 00 00 00 00 00
	HEX	FF F3 D5 EA D5 2D 1F 0D 0F 03 01 00 00 00 00 00

D26F2
;	...##..######...
;	..##.#..######..
;	..##..#########.
;	..##..#####...#.
;	......###...#...
;	......##....#...
;	.......##.......
;	........#.......
;	........###.....
;	.......###......
;	......####......
;	.....#######....
;	....########....
;	......#....#....
;	................
;	................

	DB	00011001B
	DB	00110100B
	DB	00110011B
	DB	00110011B
	DB	00000011B
	DB	00000011B
	DB	00000001B
	DB	00000000B

	DB	00000000B
	DB	00000001B
	DB	00000011B
	DB	00000111B
	DB	00001111B
	DB	00000010B
	DB	00000000B
	DB	00000000B

	DB	11111000B
	DB	11111100B
	DB	11111110B
	DB	11100010B
	DB	10001000B
	DB	00001000B
	DB	10000000B
	DB	10000000B

	DB	11100000B
	DB	11000000B
	DB	11000000B
	DB	11110000B
	DB	11110000B
	DB	00010000B
	DB	00000000B
	DB	00000000B

;	......#.........
;	......##........
;	....##..........
;	.....#.....###..
;	.........###.#..
;	........####.#..
;	.........#####..
;	.........####...
;	.............###
;	..........######
;	..........#####.
;	................
;	................
;	.......####.....
;	......#.####....
;	.....##..####...

	DB	00000010B
	DB	00000011B
	DB	00001100B
	DB	00000100B
	DB	00000000B
	DB	00000000B
	DB	00000000B
	DB	00000000B

	DB	00000000B
	DB	00000000B
	DB	00000000B
	DB	00000000B
	DB	00000000B
	DB	00000001B
	DB	00000010B
	DB	00000110B

	DB	00000000B
	DB	00000000B
	DB	00000000B
	DB	00011100B
	DB	01110100B
	DB	11110100B
	DB	01111100B
	DB	01111000B

	DB	00000111B
	DB	00111111B
	DB	00111110B
	DB	00000000B
	DB	00000000B
	DB	11100000B
	DB	11110000B
	DB	01111000B

;	.......#######..
;	......#########.
;	.....##########.
;	.....##....####.
;	.......#.....##.
;	.......#....##..
;	................
;	........####....
;	..........##....
;	...........##...
;	......##..###...
;	......#######...
;	......#######...
;	......######....
;	................
;	................

	DB	00000001B
	DB	00000011B
	DB	00000111B
	DB	00000110B
	DB	00000001B
	DB	00000001B
	DB	00000000B
	DB	00000000B

	DB	00000000B
	DB	00000000B
	DB	00000011B
	DB	00000011B
	DB	00000011B
	DB	00000011B
	DB	00000000B
	DB	00000000B

	DB	11111100B
	DB	11111110B
	DB	11111110B
	DB	00011110B
	DB	00000110B
	DB	00001100B
	DB	00000000B
	DB	11110000B

	DB	00110000B
	DB	00011000B
	DB	00111000B
	DB	11111000B
	DB	11111000B
	DB	11110000B
	DB	00000000B
	DB	00000000B

;	................
;	................
;	................
;	.......#####....
;	......#.#####...
;	......#.####....
;	.......######...
;	....###.........
;	...#######......
;	.....######.....
;	........##......
;	................
;	................
;	................
;	........###.....
;	.......####.....

	DB	00000000B
	DB	00000000B
	DB	00000000B
	DB	00000001B
	DB	00000010B
	DB	00000010B
	DB	00000001B
	DB	00001110B

	DB	00011111B
	DB	00000111B
	DB	00000000B
	DB	00000000B
	DB	00000000B
	DB	00000000B
	DB	00000000B
	DB	00000001B

	DB	00000000B
	DB	00000000B
	DB	00000000B
	DB	11100000B
	DB	11111000B
	DB	11110000B
	DB	11111000B
	DB	00000000B

	DB	11000000B
	DB	11100000B
	DB	11000000B
	DB	00000000B
	DB	00000000B
	DB	00000000B
	DB	11100000B
	DB	11100000B

N26F2	EQU	$-D26F2
;	...##..######...
;	..##.#..######..
;	..##..#########.
;	..##..#####...#.
;	......###...#...
;	......##....#...
;	.......##.......
;	........#.......
;	........###.....
;	.......#...#....
;	......##....#...
;	......###.......
;	.....#####..##..
;	......#...###...
;	................
;	................

	DB	00011001B
	DB	00110100B
	DB	00110011B
	DB	00110011B
	DB	00000011B
	DB	00000011B
	DB	00000001B
	DB	00000000B

	DB	00000000B
	DB	00000001B
	DB	00000011B
	DB	00000011B
	DB	00000111B
	DB	00000010B
	DB	00000000B
	DB	00000000B

	DB	11111000B
	DB	11111100B
	DB	11111110B
	DB	11100010B
	DB	10001000B
	DB	00001000B
	DB	10000000B
	DB	10000000B

	DB	11100000B
	DB	00010000B
	DB	00001000B
	DB	10000000B
	DB	11001100B
	DB	00111000B
	DB	00000000B
	DB	00000000B

;	......#.........
;	......##........
;	....##..........
;	.....#.....###..
;	.........###.#..
;	........####.#..
;	.........#####..
;	.........####...
;	................
;	........###.....
;	........####....
;	.........####...
;	..........##....
;	.......###......
;	.......###......
;	.......####.....

	DB	00000010B
	DB	00000011B
	DB	00001100B
	DB	00000100B
	DB	00000000B
	DB	00000000B
	DB	00000000B
	DB	00000000B

	DB	00000000B
	DB	00000000B
	DB	00000000B
	DB	00000000B
	DB	00000000B
	DB	00000001B
	DB	00000001B
	DB	00000001B

	DB	00000000B
	DB	00000000B
	DB	00000000B
	DB	00011100B
	DB	01110100B
	DB	11110100B
	DB	01111100B
	DB	01111000B

	DB	00000000B
	DB	11100000B
	DB	11110000B
	DB	01111000B
	DB	00110000B
	DB	11000000B
	DB	11000000B
	DB	11100000B

;	.......#######..
;	......#########.
;	.....##########.
;	.....##....####.
;	.......#.....##.
;	.......#....##..
;	................
;	........####....
;	...........#....
;	...........##...
;	..........###...
;	......#######...
;	......#######...
;	......######....
;	................
;	................

	DB	00000001B
	DB	00000011B
	DB	00000111B
	DB	00000110B
	DB	00000001B
	DB	00000001B
	DB	00000000B
	DB	00000000B

	DB	00000000B
	DB	00000000B
	DB	00000000B
	DB	00000011B
	DB	00000011B
	DB	00000011B
	DB	00000000B
	DB	00000000B

	DB	11111100B
	DB	11111110B
	DB	11111110B
	DB	00011110B
	DB	00000110B
	DB	00001100B
	DB	00000000B
	DB	11110000B

	DB	00010000B
	DB	00011000B
	DB	00111000B
	DB	11111000B
	DB	11111000B
	DB	11110000B
	DB	00000000B
	DB	00000000B

;	................
;	................
;	................
;	.......#####....
;	......#.#####...
;	......#.####....
;	.......######...
;	................
;	....##..###.....
;	....#######.....
;	....######......
;	................
;	................
;	................
;	........###.....
;	.......####.....

	DB	00000000B
	DB	00000000B
	DB	00000000B
	DB	00000001B
	DB	00000010B
	DB	00000010B
	DB	00000001B
	DB	00000000B

	DB	00001100B
	DB	00001111B
	DB	00001111B
	DB	00000000B
	DB	00000000B
	DB	00000000B
	DB	00000000B
	DB	00000001B

	DB	00000000B
	DB	00000000B
	DB	00000000B
	DB	11100000B
	DB	11111000B
	DB	11110000B
	DB	11111000B
	DB	00000000B

	DB	11100000B
	DB	11100000B
	DB	11000000B
	DB	00000000B
	DB	00000000B
	DB	00000000B
	DB	11100000B
	DB	11100000B

;-----------------------------------------------------------------------

; put boy in window
L27F2	_DI
	LD	DE,PT+0800H+24H*8
	LD	HL,D29C0	; window with boy
	LD	BC,0020H
	RST	08H		; write data to VDP: HL=data, DE=VRAM address, BC=length

	LD	DE,CT+0800H+24H*8
	LD	HL,D2A00	; color table for window with boy
	LD	BC,0020H
	RST	08H		; write data to VDP: HL=data, DE=VRAM address, BC=length

	LD	A,02H
	LD	(DC0C1),A	; 10 flowers picked flag = 2

	_EI
	RET

;-----------------------------------------------------------------------

; boy receiving flowers?
L280E	_DI
	LD	DE,PT+0800H+24H*8
	LD	HL,D29E0	; boy receiving flowers
	LD	BC,0020H
	RST	08H		; write data to VDP: HL=data, DE=VRAM address, BC=length

	LD	DE,CT+0800H+24H*8
	LD	HL,D2A20	; color table for boy receiving flowers
	LD	BC,0020H
	RST	08H		; write data to VDP: HL=data, DE=VRAM address, BC=length

	LD	A,01H
	LD	(DC0C1),A	; 10 flowers picked flag = 1

	_EI
	RET

;-----------------------------------------------------------------------

; remove boy from window
L282A	LD	A,(DC0BE)	; count of flowers picked
	CP	0AH
	RET	NC		; return if 10 or more

	LD	A,(DC0C1)	; test 10 flowers picked flag
	OR	A
	RET	Z

	XOR	A
	LD	(DC0C3),A
	LD	(DC0C1),A	; clear 10 flowers flag

L283C	_DI
	LD	DE,PT+0800H+24H*8
	LD	HL,D423E	; window without boy
	LD	BC,N423E	; 24-27
	RST	08H		; write data to VDP: HL=data, DE=VRAM address, BC=length

	LD	DE,CT+0800H+24H*8
	LD	HL,D487E	; color table for window without boy
	LD	BC,N487E	; 24-27
	RST	08H		; write data to VDP: HL=data, DE=VRAM address, BC=length
	_EI
	RET

;-----------------------------------------------------------------------

L2853	CALL	L282A

	LD	A,(DC0BF)
	OR	A
	RET	NZ

	LD	A,(DC07A)
	OR	A
	RET	NZ

	LD	A,(DC0CA)
	OR	A
	RET	NZ

	LD	A,(DC0C7)
	OR	A
	RET	NZ

	LD	A,(DC01B)
	DEC	A
	LD	(DC01B),A
	RET	NZ

	LD	A,0AH
	LD	(DC01B),A
	LD	A,(DC0C1)	; 10 flowers picked flag
	CP	01H		; alternate boy in window graphics
	JR	NZ,.2883
	CALL	L27F2		; put boy in window
	JR	.288A

.2883	CP	02H
	JR	NZ,.288A
	CALL	L280E		; boy receiving flowers
.288A	LD	A,(DC01A)
	DEC	A
	LD	(DC01A),A
	RET	NZ
	LD	A,14H
	LD	(DC01A),A
	LD	IX,DC03E
	LD	A,(DC048)
	CP	60H
	JR	NZ,.28A6
	LD	A,68H
	JR	.28A8

.28A6	LD	A,60H
.28A8	CALL	L290E

	LD	A,(DC019)	; time remaining?
	LD	B,A
	LD	A,5CH
	ADD	A,B
	CALL	L2907
	LD	A,B
	INC	A
	LD	(DC019),A	; time remaining?
	CP	32H
	RET	C

	LD	HL,DC200
	LD	(HL),90H

	LD	HL,DC14E
	SET	7,(HL)

	CALL	L29A7

	XOR	A
	LD	(DC01D),A
	LD	A,05H
	LD	(DC0C9),A
	LD	(DC0C7),A
	LD	(DC07B),A
	LD	A,0D0H	; 208 = end of sprite attribute table?
	LD	(DC0C8),A
	LD	A,08H
	LD	(DC022),A
	_DI
	CALL	L0A19		; clear sprites 16 and 17
	CALL	L07D7		; write DC026..DC075 to sprite attribute table
	LD	HL,D28F7	; "TIME UP !"
	LD	DE,NT+006BH
	LD	B,09H
	CALL	L2D31		; write data to VDP: HL=data, DE=VRAM address, B=length
	_EI
	RET

D28F7	DB	_T,_I,_M,_E,__,_U,_P," !"

;-----------------------------------------------------------------------

L2900	LD	(IX+08H),A
	LD	(IX+0CH),A
	RET

;-----------------------------------------------------------------------

L2907	LD	(IX+09H),A
	LD	(IX+0DH),A
	RET

;-----------------------------------------------------------------------

L290E	LD	(IX+0AH),A
	ADD	A,04H
	LD	(IX+0EH),A
	RET

;-----------------------------------------------------------------------

L2917	LD	A,(DC0C3)
	OR	A
	RET	Z
	XOR	A
	LD	(DC0C3),A
	CALL	L283C
	LD	IX,DC03E
	LD	A,50H
	CALL	L290E
	LD	IX,DC036
	LD	HL,(DC0C5)
	LD	DE,001EH
	ADD	HL,DE
	LD	A,L
	RLCA
	RLCA
	RLCA
	AND	0F8H
	ADD	A,02H
	CALL	L0470
	ADD	A,12H
	CALL	L2907
	RR	H
	RR	L
	RR	H
	RR	L
	LD	A,L
	AND	0F8H
	CALL	L0441
	CALL	L2900
	CALL	L298E
	LD	A,04H
	LD	(DC022),A
	XOR	A
	LD	(DC023),A
	LD	A,40H
	CALL	L079C		; set sprite 4+5 pattern
	LD	A,48H
	CALL	L290E
	LD	(IX+0BH),04H
	LD	(IX+0FH),0FH
	LD	A,1EH
	LD	(DC0BA),A
	LD	A,01H
	LD	(DC098),A
	LD	(DC07A),A
	LD	A,64H
	LD	(DC07B),A
	LD	HL,DC200
	LD	(HL),83H
	RET

;-----------------------------------------------------------------------

L298E	LD	HL,(DC0C5)
	LD	DE,0020H
	ADD	HL,DE
	_DI
	RST	28H		; set VDP write address = HL
	PUSH	AF
	POP	AF
	LD	A,03H
	OUT	(VDPdata),A
	ADD	HL,DE
	RST	28H		; set VDP write address = HL
	PUSH	AF
	POP	AF
	LD	A,04H
	OUT	(VDPdata),A
	_EI
	RET

;-----------------------------------------------------------------------

L29A7	LD	A,(DC036)	; sprite 4 Y
	SUB	10H
	LD	(DC062),A
	LD	A,(DC037)	; sprite 4 X
	LD	(DC063),A
	LD	A,90H
	LD	(DC064),A
	LD	A,0DH
	LD	(DC065),A
	RET

;	################	window with boy
;	################
;	##.....#########
;	#.......########
;	########.#######
;	###...##.#######
;	##.....#.#######
;	...#.#...#######
;	#..#.#...#######
;	#.......#..#####
;	###...###..#####
;	##....###..#####
;	#..........#####
;	.#######...#####
;	.###############
;	#.......########

D29C0	HEX	FF FF C1 80 FF E3 C1 14  FF FF FF FF 7F 7F 7F 7F
	HEX	94 80 E3 C3 80 7F 7F 80  7F 9F 9F 9F 1F 1F FF FF

;	################	boy receiving flowers
;	################
;	##.....#########
;	#.......########
;	########.#######
;	###...##.#######
;	##.....#.#######
;	.....#...#######
;	#..#.#...#######
;	#.......########
;	###...#####..###
;	##....####...###
;	#...........####
;	.#######...#####
;	.###############
;	#.......########

D29E0	HEX	FF FF C1 80 FF E3 C1 04  FF FF FF FF 7F 7F 7F 7F
	HEX	94 80 E3 C3 80 7F 7F 80  7F FF E7 C7 0F 1F FF FF

; color table for window with boy
D2A00	HEX	99 99 94 94 44 4F 4F 4F
	HEX	99 99 99 99 94 94 94 9F
	HEX	4F 9F 9F 94 94 4F 4F 94
	HEX	94 9F 9F 9F 9F 9F 99 99

; color table for boy receiving flowers
D2A20	HEX	99 99 94 94 44 4F 4F 4F
	HEX	99 99 99 99 94 94 94 9F
	HEX	4F 9F 9F 94 94 4F 4F 94
	HEX	94 99 9F 9F 9F 9F 99 99

;-----------------------------------------------------------------------

L2A40	LD	DE,DC004+2	; current score
	LD	HL,D2A70+2
L2A46	LD	C,A		; C = bonus score index

	LD	A,(DC012)	; test title screen flag
	OR	A
	RET	NZ		; return if title scren

	LD	A,C		; get offset to bonus score in table
	ADD	A,A
	ADD	A,C
	LD	C,A
	LD	B,00H
	ADD	HL,BC

	LD	A,(DE)		; add bonus score to current score
	ADD	A,(HL)
	DAA
	LD	(DE),A

	DEC	HL
	DEC	DE

	LD	A,(DE)
	ADC	A,(HL)
	DAA
	LD	(DE),A

	DEC	HL
	DEC	DE

	LD	A,(DE)
	ADC	A,(HL)
	DAA
	LD	(DE),A

	RET	NC		; return if no overflow

	LD	HL,DC001+2	; if overflow, set score = 999990
	LD	(HL),90H
	DEC	HL
	LD	(HL),99H
	DEC	HL
	LD	(HL),99H
	RET

D2A70	DB	00H,01H,00H	; 0 = 000100
	DB	00H,00H,10H	; 1 = 000010
	DB	00H,05H,00H	; 2 = 000500
	DB	00H,15H,00H	; 3 = 001500
	DB	00H,25H,00H	; 4 = 002500
	DB	00H,05H,00H	; 5 = 000500

;-----------------------------------------------------------------------

L2A82	CALL	L2A8D		; check for high score
; put score on screen
L2A85
  if hax
	LD	A,(CHTFLG)	; are cheats enabled?
	OR	A
	JR	Z,.1		; skip if not enabled
	LD	DE,NT+0038H+6	; next position after last digit of score
	RST	18H		; set VDP write address = DE
	LD	A,2AH		; put hax indicator next to score
	OUT	(VDPdata),A
.1
  endif
	LD	DE,DC004	; current score
	LD	HL,NT+0038H	; current score at upper-right
	JR	L2AA9		; print BCD number: HL=VRAM address, DE=address, B=bytes

L2A8D	LD	DE,DC004+3	; current score at C004-C006
	LD	HL,DC001+3	; high score at C001-C003
	LD	B,03H		; 6 digits
	AND	A		; clear carry flag
.2A96	DEC	HL
	DEC	DE
	LD	A,(DE)
	SBC	A,(HL)		; compare with carry
	DJNZ	.2A96		; loop for next byte
	RET	C		; return if (HL) > (DE)

	EX	DE,HL		; HL=C004 DE=C001
	LD	BC,0003H	; copy 3 bytes of score
	LDIR

; put hi-score on screen
L2AA3	LD	DE,DC001	; high score
	LD	HL,NT+0023H	; high score at upper-left
; print BCD number: HL=VRAM address, DE=address, B=bytes
L2AA9	RST	28H		; set VDP write address = HL
	LD	C,00H		; clear leading zero flag
; print BCD number: DE=address, B=bytes
L2AAC	LD	A,B		; A = number of bytes
    IF      OPT
	DEC	A
    ELSE
	CP	01H
    ENDIF
	JR	Z,.2ACB		; branch if 1 byte (2 digits)

	LD	A,(DE)
	RRCA
	RRCA
	RRCA
	RRCA
	CALL	L2ADA		; write BCD digit: A=digit, C=leading zero flag
	LD	A,(DE)
	CALL	L2ADA		; write BCD digit: A=digit, C=leading zero flag
	INC	DE

	LD	A,(DE)
	RRCA
	RRCA
	RRCA
	RRCA
	CALL	L2ADA		; write BCD digit: A=digit, C=leading zero flag
	LD	A,(DE)
	CALL	L2ADA		; write BCD digit: A=digit, C=leading zero flag
	INC	DE

.2ACB	LD	A,(DE)
	RRCA
	RRCA
	RRCA
	RRCA
	CALL	L2ADA		; write BCD digit: A=digit, C=leading zero flag
	LD	C,10H		; set leading zero flag for last digit
	LD	A,(DE)

    IF      OPT
    ELSE
	CALL	L2ADA		; write BCD digit: A=digit, C=leading zero flag
	RET
    ENDIF

; write BCD digit: A=digit, C=leading zero flag
L2ADA	INC	HL
	AND	0FH
	CP	C
	JR	Z,.2AE7
	ADD	A,'0'
	OUT	(VDPdata),A
	LD	C,10H
	RET

.2AE7	LD	A,02H
	OUT	(VDPdata),A
	RET

;-----------------------------------------------------------------------

L2AEC	LD	DE,DC007+2	; bonus score
	LD	A,(DE)
	SUB	20H
	DAA
	LD	(DE),A
	DEC	DE
	LD	A,(DE)
	SBC	A,00H
	DAA
	LD	(DE),A
	DEC	DE
	LD	A,(DE)
	SBC	A,00H
	DAA
	LD	(DE),A
L2B00	LD	HL,NT+006FH
	LD	DE,DC007	; bonus score
	_DI
	CALL	L2AA9		; print BCD number: HL=VRAM address, DE=address, B=bytes
	_EI
	RET

;-----------------------------------------------------------------------

L2B0C	LD	DE,DC007+2	; bonus score
	LD	A,(DE)
	ADD	A,50H
	DAA
	LD	(DE),A
	DEC	DE
	LD	A,(DE)
	ADC	A,02H
	DAA
	LD	(DE),A
	DEC	DE
	LD	A,(DE)
	ADC	A,00H
	DAA
	LD	(DE),A
L2B20	_DI
	LD	HL,NT+0070H
	CALL	L2AA9		; print BCD number: HL=VRAM address, DE=address, B=bytes
	_EI
	RET

;-----------------------------------------------------------------------

L2B29	LD	A,01H		; start at round 1
	LD	(DC00A),A
	XOR	A
	LD	(DC00D),A
    IF      COLECO
	LD	A,HONEY		; start with 5 honey
    ELSE
	LD	A,05H
    ENDIF
	LD	(DC00E),A	; remaining honey
    IF      COLECO
	LD	A,LIVES-1
    ELSE
	LD	A,02H		; start with 2+1 lives
    ENDIF
	LD	(DC00F),A	; remaining lives ("love")

	LD	HL,DC026
	LD	DE,DC026+1
	LD	BC,004CH-1	; sprites 0-18
	LD	(HL),0E8H
	LDIR

	RET

;-----------------------------------------------------------------------

L2B4A	LD	HL,DC018
	LD	DE,DC018+1
	LD	BC,NC018-1	; 015AH
	LD	(HL),00H
	LDIR

	LD	A,(DC012)	; test title screen flag
	OR	A
	JR	Z,.2B61		; skip if not title screen

	LD	A,05H
	JR	.2B62

.2B61
    IF      OPT
	; A already = 00H here
    ELSE
	XOR	A
    ENDIF

.2B62	LD	(DC0BE),A	; update count of flowers picked
	XOR	A
	LD	(DC0CF),A	; clear challenge level flag
	LD	(DC0C8),A
	INC	A
	LD	(DC01D),A
	LD	(DC079),A
	LD	(DC080),A	; set dropping honey flag
	LD	A,02H
	LD	(DC01B),A
	LD	A,0AH
	LD	(DC01A),A
	LD	A,10H		; set grass scroll position to middle
	LD	(DC07D),A
	LD	A,06H		; reset grass scroll delay count
	LD	(DC07E),A
	LD	(DC07F),A	; set grass scroll request flag
	CALL	L08D9		; update grass at bottom of screen

	LD	HL,DC026	; clear RAM sprite table
	LD	DE,DC026+1
	LD	BC,004CH-1
	LD	(HL),0E8H
	LDIR

	CALL	L2D39		; show high score and score
	LD	HL,NT+02C0H
	RST	28H		; set VDP write address = HL
	LD	B,40H
.2BA6	LD	A,02H
	OUT	(VDPdata),A
	PUSH	AF
	POP	AF
	DJNZ	.2BA6
	CALL	L219F		; update hearts

	LD	HL,D2D21	; "HONEY"
	LD	DE,NT+02C7H
	LD	B,N2D21
	CALL	L2D31		; write data to VDP: HL=data, DE=VRAM address, B=length

	LD	HL,D2D25	; "ROUND"
	LD	DE,NT+02D8H
	LD	B,N2D21
	CALL	L2D31		; write data to VDP: HL=data, DE=VRAM address, B=length

	LD	HL,D2D29	; "FLOWER"
	LD	DE,NT+02CDH
	LD	B,N2D29
	CALL	L2D31		; write data to VDP: HL=data, DE=VRAM address, B=length

	LD	HL,D2D2E	; "LOVE"
	LD	DE,NT+02C1H
	LD	B,N2D2E
	CALL	L2D31		; write data to VDP: HL=data, DE=VRAM address, B=length

	CALL	L21D1
	CALL	L21E0
	LD	A,10H
	LD	(DC082),A	; reset hills scroll delay counter
	LD	(DC081),A	; set hills scroll request flag
	LD	(DC084),A
	LD	A,10H
	LD	(DC083),A
	CALL	L0974		; update hills

	LD	HL,DC085	; honey position list
	LD	DE,DC085+1
	LD	BC,NC085-1
	LD	(HL),0FFH
	LDIR

	LD	A,01H
	LD	(DC080),A	; set dropping honey flag
	XOR	A
	LD	(DC092),A
	LD	(DC093),A
	LD	A,(DC00D)
	AND	07H
	LD	L,A
	LD	H,00H
	LD	D,H
	LD	E,L
	ADD	HL,HL
	ADD	HL,DE
	ADD	HL,HL
	ADD	HL,DE
	LD	DE,D5E5C
	ADD	HL,DE
	LD	(DC096),HL
	LD	A,08H
	LD	(DC090),A
	LD	(DC091),A
	CALL	L0FB9

	LD	HL,D2CE8
	LD	DE,DC036	; sprites 4 and 5
	LD	BC,N2CE8
	LDIR

	LD	A,07H
	LD	(DC024),A
	LD	A,01H
	LD	(DC01E),A
	LD	(DC022),A
	LD	A,0AH
	LD	(DC099),A

	LD	HL,DC09A
	LD	DE,DC09B
	LD	BC,0015H
	LD	(HL),0FFH
	LDIR

	LD	HL,D2CF0
	LD	DE,DC066	; sprites 16-19
	LD	BC,0010H
	LDIR

	LD	A,14H
	LD	(DC077),A
	LD	A,0CH
	LD	(DC078),A
	LD	A,0AH
	LD	(DC07B),A

	LD	HL,D2D00
	LD	DE,DC046	; sprites 8-12
	LD	BC,N2D00
	LDIR

	LD	HL,NT+0013H
	RST	28H		; set VDP write address = HL
	LD	A,0F4H
	CALL	L2D64		; write A and A+1 to VDP
	LD	HL,NT+0033H
	RST	28H		; set VDP write address = HL
	LD	A,0F6H
	CALL	L2D64		; write A and A+1 to VDP
	LD	HL,NT+000AH
	RST	28H		; set VDP write address = HL
	LD	A,0F8H
	CALL	L2D64		; write A and A+1 to VDP
	LD	HL,NT+002AH
	RST	28H		; set VDP write address = HL
	LD	A,0FAH
	CALL	L2D64		; write A and A+1 to VDP
L2CA2	LD	A,01H
	LD	(DC0E7),A
	LD	(DC0E6),A
	LD	(DC163),A

	LD	HL,D2CE3
	LD	DE,DC0FE
	LD	BC,000AH
	LDIR

	LD	B,05H
	LD	HL,DC103
.2CBD	LD	(HL),0BH
	INC	HL
	DJNZ	.2CBD
	LD	A,(DC00D)
	RRCA
	RRCA
	AND	3FH
	INC	A
	INC	A
	CP	04H
	JR	C,.2CD1
	LD	A,04H
.2CD1	LD	(DC169),A
	LD	A,(DC00D)
	RRCA
	RRCA
	AND	3FH
	INC	A
	RLCA
	AND	0FEH
	LD	(DC16A),A
	RET

D2CE3	DB	10H,10H,10H,10H,10H

;		 X   Y  pat colr
D2CE8	HEX	58 78 10 0D	; -> sprite 4
	HEX	58 78 14 0F	; -> sprite 5
N2CE8	EQU	$-D2CE8

;		 X   Y  pat colr
D2CF0	HEX	0A 00 E0 8F	; -> sprite 16
	HEX	0A 10 E0 8F	; -> sprite 17
	HEX	1A 70 E4 8F	; -> sprite 18
	HEX	1A 80 E4 8F	; -> sprite 19

D2D00	HEX	FF 5C 50 04	; -> sprite  8
	HEX	FF 5C 54 0F	; -> sprite  9
	HEX	E8 F0 F0 0A	; -> sprite 10
	HEX	FF 50 30 0D	; -> sprite 11
	HEX	FF 98 BC 09	; -> sprite 12
N2D00	EQU	$-D2D00

  IF opt

D2D14	DB	_H,_I,_dash
D2D1C	DB	_S,_C,_O,_R,_E
N2D1C	EQU	$-D2D1C
N2D14	EQU	$-D2D14

  ELSE

D2D14	DB	_H,_I,_dash,_S,_C,_O,_R,_E
N2D14	EQU	$-D2D14

D2D1C	DB	_S,_C,_O,_R,_E
N2D1C	EQU	$-D2D1C

  ENDIF

D2D21	DB	8CH,8DH,8EH,8FH		; "HONEY"
N2D21	EQU	$-D2D21

D2D25	DB	88H,89H,8AH,8BH		; "ROUND"
N2D25	EQU	$-D2D25

D2D29	DB	0C0H,0C1H,0C2H,0C3H,0C4H ; "FLOWER"
N2D29	EQU	$-D2D29

D2D2E	DB	0C5H,0C6H,0C7H		; "LOVE"
N2D2E	EQU	$-D2D2E

;-----------------------------------------------------------------------

; write data to VDP: HL=data, DE=VRAM address, B=length
L2D31	RST	18H		; set VDP write address = DE
.2D32	LD	A,(HL)
	OUT	(VDPdata),A
	INC	HL
	DJNZ	.2D32
	RET

;-----------------------------------------------------------------------

; show high score and score
L2D39	LD	HL,NT+0000H
	RST	28H		; set VDP write address = HL
	LD	B,40H
.2D3F	LD	A,20H
	OUT	(VDPdata),A
	PUSH	AF
	POP	AF
	DJNZ	.2D3F
	CALL	L2AA3		; put hi-score on screen
	CALL	L2A85		; put score on screen
	LD	HL,D2D14	; "HI-SCORE"
	LD	DE,NT+0001H
	LD	B,N2D14
	CALL	L2D31		; write data to VDP: HL=data, DE=VRAM address, B=length
	LD	HL,D2D1C	; "SCORE"
	LD	DE,NT+0016H
	LD	B,N2D1C
	CALL	L2D31		; write data to VDP: HL=data, DE=VRAM address, B=length
	RET

;-----------------------------------------------------------------------

; write A and A+1 to VDP
L2D64	OUT	(VDPdata),A
	PUSH	AF
	POP	AF
	PUSH	AF
	POP	AF
	INC	A
	OUT	(VDPdata),A
	RET

;-----------------------------------------------------------------------

; title screen graphics
  IF RLE
L2D6E	LD	HL,RLE391E
	LD	DE,SPT+0000H	; start of sprite pattern table
	CALL	RLE0008
  ELSE
L2D6E	LD	HL,D391E	; sprite pattern table data
	LD	DE,SPT+0000H	; start of sprite pattern table
	LD	BC,N391E	; 00-FF
	RST	08H		; write data to VDP: HL=data, DE=VRAM address, BC=length
  ENDIF

 if coleco
	LD	DE,PT+0000H+80H*8 ; start of pattern table
 else
	LD	DE,PT+0000H	; start of pattern table
 endif
	LD	HL,D66D4
	LD	BC,N66D4	; 00-D1
	RST	08H		; write data to VDP: HL=data, DE=VRAM address, BC=length

	LD	DE,PT+0800H	; pattern table, second bank
	LD	HL,D66D4
	LD	BC,N66D4	; 00-D1
	RST	08H		; write data to VDP: HL=data, DE=VRAM address, BC=length

	LD	DE,PT+1000H	; pattern table, third bank
	LD	HL,D66D4
	LD	BC,N66D4	; 00-D1
	RST	08H		; write data to VDP: HL=data, DE=VRAM address, BC=length

	LD	HL,D5334
	LD	DE,PT+1000H+20H*8
	LD	BC,N5334	; 20-46
	RST	08H		; write data to VDP: HL=data, DE=VRAM address, BC=length

 if coleco
	LD	DE,CT+0000H+80H*8
 else
	LD	DE,CT+0000H
 endif
	RST	18H		; set VDP write address = DE
	LD	C,94H
	LD	B,00H
	CALL	L2F30		; fill VDP: C=data, B=length
	LD	B,20H
	CALL	L2F30		; fill VDP: C=data, B=length
	LD	C,0F4H
	CALL	L2F30		; fill VDP: C=data, B=length
	LD	B,10H
	CALL	L2F30		; fill VDP: C=data, B=length
	PUSH	BC

	LD	DE,CT+0800H+23H*8
	RST	18H		; set VDP write address = DE
	LD	C,44H
	LD	B,08H
	CALL	L2F30		; fill VDP: C=data, B=length
	POP	BC

	LD	DE,CT+0800H+46H*8
	RST	18H		; set VDP write address = DE
	CALL	L2F30		; fill VDP: C=data, B=length
	LD	B,90H	; actual length is 0190H
	CALL	L2F30		; fill VDP: C=data, B=length
	LD	HL,D6D24
	CALL	L2F27		; write VDP: HL=data, B=length
	CALL	L2F27		; write VDP: HL=data, B=length (256)

	LD	DE,CT+1000H+20H*8
	RST	18H		; set VDP write address = DE
	LD	C,0F4H
	CALL	L2F30		; fill VDP: C=data, B=length
	LD	B,40H
	CALL	L2F30		; fill VDP: C=data, B=length

	LD	DE,CT+1000H+78H*8
	RST	18H		; set VDP write address = DE
	LD	HL,D6D24
	CALL	L2F27		; write VDP: HL=data, B=length (256)
	LD	B,88H	; actual length is 0188H
	CALL	L2F27		; write VDP: HL=data, B=length
	LD	C,34H
	CALL	L2F30		; fill VDP: C=data, B=length
	LD	B,08H
	CALL	L2F30		; fill VDP: C=data, B=length

	LD	DE,NT+0000H
	RST	18H		; set VDP write address = DE
 if coleco
	LD	C,A3H
 else
	LD	C,23H
 endif
	CALL	L2F30		; fill VDP: C=data, B=length
 if coleco
	LD	C,23H
 endif
	CALL	L2F30		; fill VDP: C=data, B=length
	LD	C,20H
	CALL	L2F30		; fill VDP: C=data, B=length

	LD	DE,NT+006CH
	RST	18H		; set VDP write address = DE
 if coleco
	LD	C,80H
 else
	LD	C,00H
 endif
	LD	B,0CH
	CALL	L2F1E		; fill VDP with incrementing data: C=data, B=length

	LD	DE,NT+008CH
	RST	18H		; set VDP write address = DE
	LD	B,0CH
	CALL	L2F1E		; fill VDP with incrementing data: C=data, B=length

	LD	DE,NT+00ACH
	RST	18H		; set VDP write address = DE
	LD	B,0CH
	CALL	L2F1E		; fill VDP with incrementing data: C=data, B=length

	LD	DE,NT+00C8H
	RST	18H		; set VDP write address = DE
	LD	B,06H
	CALL	L2F1E		; fill VDP with incrementing data: C=data, B=length

 if coleco
	LD	A,A3H
 else
	LD	A,23H
 endif
	OUT	(VDPdata),A
	LD	B,03H
	CALL	L2F1E		; fill VDP with incrementing data: C=data, B=length

	LD	DE,NT+00D5H
	RST	18H		; set VDP write address = DE
	LD	B,06H
	CALL	L2F1E		; fill VDP with incrementing data: C=data, B=length

	LD	DE,NT+00E8H
	RST	18H		; set VDP write address = DE
	LD	B,13H
	CALL	L2F1E		; fill VDP with incrementing data: C=data, B=length

 if coleco
	LD	A,C
	AND	7FH
	LD	C,A
 endif

	LD	DE,NT+0108H
	RST	18H		; set VDP write address = DE
	LD	B,13H
	CALL	L2F1E		; fill VDP with incrementing data: C=data, B=length

	LD	DE,NT+0128H
	RST	18H		; set VDP write address = DE
	LD	B,13H
	CALL	L2F1E		; fill VDP with incrementing data: C=data, B=length

	LD	DE,NT+014BH
	RST	18H		; set VDP write address = DE
	LD	B,04H
	CALL	L2F1E		; fill VDP with incrementing data: C=data, B=length

	LD	A,23H
	OUT	(VDPdata),A
	PUSH	AF
	POP	AF
	OUT	(VDPdata),A
	LD	B,07H
	CALL	L2F1E		; fill VDP with incrementing data: C=data, B=length

	LD	DE,NT+0175H
	RST	18H		; set VDP write address = DE
	LD	A,C
	OUT	(VDPdata),A
	INC	C

	LD	DE,NT+0194H
	RST	18H		; set VDP write address = DE
	LD	B,02H
	CALL	L2F1E		; fill VDP with incrementing data: C=data, B=length

	LD	DE,NT+01B1H
	RST	18H		; set VDP write address = DE
	LD	B,06H
	CALL	L2F1E		; fill VDP with incrementing data: C=data, B=length

	LD	DE,NT+01D1H
	RST	18H		; set VDP write address = DE
	LD	B,06H
	CALL	L2F1E		; fill VDP with incrementing data: C=data, B=length

	LD	DE,NT+01F2H
	RST	18H		; set VDP write address = DE
	LD	B,04H
	CALL	L2F1E		; fill VDP with incrementing data: C=data, B=length

	LD	DE,NT+01E6H
	RST	18H		; set VDP write address = DE
	LD	C,8EH
	LD	B,05H
	CALL	L2F1E		; fill VDP with incrementing data: C=data, B=length

	LD	DE,NT+01CDH
	RST	18H		; set VDP write address = DE
	LD	C,99H
	LD	B,02H
	CALL	L2F1E		; fill VDP with incrementing data: C=data, B=length

	LD	DE,NT+01EDH
	RST	18H		; set VDP write address = DE
	LD	B,02H
	CALL	L2F1E		; fill VDP with incrementing data: C=data, B=length

	LD	DE,NT+01D8H
	RST	18H		; set VDP write address = DE
	LD	HL,D2F38
	LD	B,03H
	CALL	L2F27		; write VDP: HL=data, B=length

	LD	DE,NT+01F8H
	RST	18H		; set VDP write address = DE
	LD	B,05H
	CALL	L2F27		; write VDP: HL=data, B=length

	LD	DE,NT+0201H
	RST	18H		; set VDP write address = DE
	LD	B,1FH
	CALL	L2F27		; write VDP: HL=data, B=length

	LD	C,0B3H
	LD	B,04H
	CALL	L2F30		; fill VDP: C=data, B=length

	LD	B,17H
	CALL	L2F1E		; fill VDP with incrementing data: C=data, B=length

	LD	C,0B3H
	LD	B,05H
	CALL	L2F30		; fill VDP: C=data, B=length

	LD	DE,NT+02F5H
	RST	18H		; set VDP write address = DE

    IF      SEGA
	LD	C,22H		; "(C)SEGA 1984"
	LD	B,09H
	CALL	L2F1E		; fill VDP with incrementing data: C=data, B=length
    ENDIF

	LD	HL,D2F73	; "PUSH START BUTTON !"
    if coleco
	LD	DE,NT+0265H
    else
	LD	DE,NT+0267H
    endif
	LD	B,N2F73
	CALL	L2D31		; write data to VDP: HL=data, DE=VRAM address, B=length

  if pix
	LD	HL,PIXMSG	; "PUSH START BUTTON !"
	LD	DE,NT+02C3H
	LD	B,PIXLEN
	CALL	L2D31		; write data to VDP: HL=data, DE=VRAM address, B=length
  endif

	LD	HL,D2F5F
	LD	DE,DC036	; sprites 4-8
	LD	BC,N2F5F
	LDIR

	CALL	L07D7		; write DC026..DC075 to sprite attribute table
	RET

;-----------------------------------------------------------------------

; fill VDP with incrementing data: C=data, B=length
L2F1E	LD	A,C
	OUT	(VDPdata),A
	PUSH	AF
	POP	AF
	INC	C
	DJNZ	L2F1E
	RET

;-----------------------------------------------------------------------

; write VDP: HL=data, B=length
L2F27	LD	A,(HL)
	OUT	(VDPdata),A
	PUSH	AF
	POP	AF
	INC	HL
	DJNZ	L2F27
	RET

;-----------------------------------------------------------------------

; fill VDP: C=data, B=length
L2F30	LD	A,C
	OUT	(VDPdata),A
	PUSH	AF
	POP	AF
	DJNZ	L2F30
	RET

;-----------------------------------------------------------------------

D2F38	HEX	99 9F A0 9B		; to NT+01D8H

	HEX	A1 A2 A5 A6 A9		; to NT+01F8H

	HEX	AA 8D AB AC 93 94 95 96	; to NT+0201H
	HEX	97 98 AD 9D 9E AE AF AA
	HEX	8A 8B 8B 8C B0 98 9D A3
	HEX	A4 A7 A8 8D B1 B2

D2F5F	DB	77H,00H,30H,0DH		; -> sprite 4
	DB	77H,00H,34H,0FH		; -> sprite 5
	DB	77H,80H,50H,01H		; -> sprite 6
	DB	77H,80H,54H,0FH		; -> sprite 7
	DB	67H,78H,0A4H,00H	; -> sprite 8
N2F5F	EQU	$-D2F5F

  if coleco
D2F73	DB	_P,_U,_S,_H,__,_B,_U,_T,_T,_O,_N,__,_T,_O,__,_S,_T,_A,_R,_T,__,_EXCL
  else
D2F73	DB	_P,_U,_S,_H,__,_S,_T,_A,_R,_T,__,_B,_U,_T,_T,_O,_N,__,_EXCL
  endif
N2F73	EQU	$-D2F73

  if pix
PIXMSG	DB	_P,_U,_B,_L,_I,_S,_H,_E,_D,__,_B,_Y,__,_T,_E,_A,_M,__,_P,_I,_X,_E,_L,_B,_O,_Y
PIXLEN	EQU	$-PIXMSG
  endif

;-----------------------------------------------------------------------

; title screen
L2F86	CALL	L7312		; silence PSG

	LD	A,01H
	LD	(DC012),A	; set title screen flag

	CALL	L2D6E		; title screen graphics

 if coleco
	LD	HL,D5334
	LD	DE,PT+0000H+20H*8
	LD	BC,N5334+16	; 20-46
	RST	08H		; write data to VDP: HL=data, DE=VRAM address, BC=length

	LD	DE,CT+0000H+20H*8
	RST	18H		; set VDP write address = DE
	LD	BC,0F4H
	CALL	L2F30		; fill VDP: C=data, B=length
	LD	B,N5334+16
	CALL	L2F30		; fill VDP: C=data, B=length

	LD	DE,PT+0000H+02H*8
	RST	18H		; set VDP write address = DE
	LD	BC,0800H
	CALL	L2F30		; fill VDP: C=data, B=length

	LD	DE,CT+0000H+02H*8
	RST	18H		; set VDP write address = DE
	LD	BC,08F4H
	CALL	L2F30		; fill VDP: C=data, B=length

 if 0	; pattern dump
	LD	DE,NT+0000H
	RST	18H		; set VDP write address = DE
;	LD	A,' '
	XOR	A
.21	OUT	(VDPdata),A
	INC	A
;	CP	_F+1
	JR	NZ,.21

 endif	; pattern dump

	CALL	L2D39		; show high score and score

 endif

  if coleco
	LD	A,1
	LD	(NMIDIS),A

	LD	A,0C2H|20H	; register 1 = C2H
  else
	LD	A,0C2H		; register 1 = C2H
  endif
	OUT	(VDPcmd),A	; Mode 0, 16K, unblank screen, disable V-int, 16x16 sprites
	LD	A,81H
	OUT	(VDPcmd),A

	LD	A,3CH
	LD	(DC01E),A

.2F9E	JR	.2FEB

.2FA0	CALL	L07D7		; write DC026..DC075 to sprite attribute table
	LD	A,(DC01E)
	DEC	A
	LD	(DC01E),A
	JR	NZ,.2F9E
	LD	A,3CH
	LD	(DC01E),A
	LD	A,(DC037)	; sprite 4 X
	INC	A
	CALL	L0470
	CP	70H
	JR	NC,.2FCE
	LD	A,(DC038)	; sprite 4 pattern
	CP	30H
	JR	Z,.2FC7
	LD	A,30H
	JR	.2FC9

.2FC7	LD	A,38H
.2FC9	CALL	L079C		; set sprite 4+5 pattern
	JR	.2F9E

.2FCE	LD	A,0DH
	LD	(DC049),A
	CALL	L07D7		; write DC026..DC075 to sprite attribute table
    IF    OPT
	CALL	L0069		; delay a bit
    ELSE
	LD	B,02H
	CALL	L006B		; delay a while
    ENDIF
  if coleco
	LD	A,1
	LD	(NMIDIS),A

	LD	A,82H|20H	; register 1 = 82H
  else
	LD	A,82H		; register 1 = 82H
  endif
	OUT	(VDPcmd),A	; 16K, blank screen, disable V-int, 16x16 sprites
	LD	A,81H
	OUT	(VDPcmd),A

	LD	A,01H
	LD	(DC012),A	; set title screen flag

	JP	L31A7

.2FEB	CALL	L2FF0		; check for start button?
	JR	.2FA0

;-----------------------------------------------------------------------

; check for start button?
L2FF0	LD	A,(DC012)	; test title screen flag
	OR	A
	RET	Z		; return if not title screen

    IF    COLECO

	OUT	(JoySel),A
	EX	(SP),HL
	EX	(SP),HL
	IN	A,(Joy1)	; - A - - U R D L
	BIT	6,A
	JR	Z,.3016

	OUT	(KeySel),A
	EX	(SP),HL
	EX	(SP),HL
	IN	A,(Joy1)	; - B - - K K K K
	BIT	6,A
	RET	NZ

    ELSE

	LD	A,02H		; row 2 bit 4 = HOME/CLEAR
	OUT	(KeybPtC),A
	IN	A,(KeybPtA)
	BIT	4,A
	JR	Z,.3016

	LD	A,03H		; row 3 bit 4 = INS/DEL
	OUT	(KeybPtC),A
	IN	A,(KeybPtA)
	BIT	4,A
	JR	Z,.3016

	LD	A,07H		; row 7 = joystick inputs
	OUT	(KeybPtC),A
	IN	A,(KeybPtA)
	BIT	B_1A,A
	JR	Z,.3016

	BIT	B_1B,A
	RET	NZ

    ENDIF

.3016	_DI
  if coleco
	LD	A,1
	LD	(NMIDIS),A

	LD	A,82H|20H	; register 1 = 82H
  else
	LD	A,82H		; register 1 = 82H
  endif
	OUT	(VDPcmd),A	; 16K, blank screen, disable V-int, 16x16 sprites
	LD	A,81H
	OUT	(VDPcmd),A

	XOR	A		; set current score = 000000
	LD	(DC004),A
	LD	(DC004+1),A
	LD	(DC004+2),A

  if hax
;	XOR	A		; reset cheat status
	LD	(CHTFLG),A
	LD	HL,CHTCODE
	LD	(CHTPTR),HL
  endif

	LD	HL,DC200	; play game start music
	LD	(HL),81H
	POP	HL
	RET

;-----------------------------------------------------------------------

; "CHALLENGING STAGE" intro
L3030	CALL	L3116		; clear screen
	LD	HL,D30CA	; "CHALLENGING STAGE"
	LD	DE,NT+0147H
	LD	B,N30CA
	CALL	L2D31		; write data to VDP: HL=data, DE=VRAM address, B=length
	LD	HL,DC200
	LD	(HL),95H
	JR	L3066

; "ROUND ##" intro
L3045	CALL	L3116		; clear screen
	LD	HL,D30C5	; "ROUND"
	LD	DE,NT+014CH
	LD	B,N30C5
	CALL	L2D31		; write data to VDP: HL=data, DE=VRAM address, B=length

	LD	HL,NT+0152H
	RST	28H		; set VDP write address = HL
	LD	DE,DC00A	; round number
	LD	B,01H		; 2 digits
	LD	C,00H	; $OPT: CALL L2AAA	; clear leading zero flag
	CALL	L2AAC		; print BCD number: DE=address, B=bytes

	LD	HL,DC200
	LD	(HL),81H
  if coleco
L3066
	LD	A,1
	LD	(NMIDIS),A

	LD	A,0C2H|20H	; register 1 = C2H
  else
L3066	LD	A,0C2H		; register 1 = C2H
  endif
	OUT	(VDPcmd),A	; Mode 0, 16K, unblank screen, disable V-int, 16x16 sprites
	LD	A,81H
	OUT	(VDPcmd),A
	LD	B,0FFH
.3070	PUSH	BC
	CALL	L6EB4		; update music (?)
	LD	BC,0898H
.3077	DEC	BC
	LD	A,C
	OR	B
	JR	NZ,.3077
	POP	BC
	DJNZ	.3070
  if coleco
	LD	A,1
	LD	(NMIDIS),A

	LD	A,82H		; register 1 = 82H
  else
	LD	A,82H		; register 1 = 82H
  endif
	OUT	(VDPcmd),A	; 16K, blank screen, disable V-int, 16x16 sprites
	LD	A,81H
	OUT	(VDPcmd),A
	RET

;-----------------------------------------------------------------------

; game over
L3088	CALL	L0A19		; clear sprites 16 and 17
	LD	IX,DC036
	CALL	L29A7
	LD	A,05H
	LD	(DC0C9),A
	LD	(DC0C7),A
	LD	(DC07B),A
	XOR	A
	LD	(DC0BF),A
	LD	A,0D0H	; 208 = end of sprite attribute table?
	LD	(DC0C8),A
	_DI
	CALL	L07D7		; write DC026..DC075 to sprite attribute table
	LD	HL,D30BC	; "GAME OVER"
	LD	DE,NT+006BH
	LD	B,N30BC
	CALL	L2D31		; write data to VDP: HL=data, DE=VRAM address, B=length
	LD	HL,DC200
	LD	(HL),82H
	_EI
	RET

D30BC	DB	_G,_A,_M,_E,__,_O,_V,_E,_R
N30BC	EQU	$-D30BC

D30C5	DB	_R,_O,_U,_N,_D
N30C5	EQU	$-D30C5

D30CA	DB	_C,_H,_A,_L,_L,_E,_N,_G,_I,_N,_G,__,_S,_T,_A,_G,_E
N30CA	EQU	$-D30CA

;-----------------------------------------------------------------------

L30DB	LD	DE,PT+0800H+02H*8
	RST	18H		; set VDP write address = DE
	LD	B,08H
.30E1	XOR	A
	OUT	(VDPdata),A
	PUSH	AF
	POP	AF
	DJNZ	.30E1

	LD	HL,D5334
	LD	DE,PT+0000H+20H*8
	LD	BC,40H*8	; 20-5F
	RST	08H		; write data to VDP: HL=data, DE=VRAM address, BC=length

	LD	HL,D5334
	LD	DE,PT+0800H+20H*8
	LD	BC,40H*8	; 20-5F
	RST	08H		; write data to VDP: HL=data, DE=VRAM address, BC=length

	LD	HL,D5334
	LD	DE,PT+1000H+20H*8
	LD	BC,40H*8	; 20-5F
	RST	08H		; write data to VDP: HL=data, DE=VRAM address, BC=length

	LD	DE,CT+0000H
	RST	18H		; set VDP write address = DE

	LD	BC,1800H
.310D	LD	A,0F0H
	OUT	(VDPdata),A
	DEC	BC
	LD	A,B
	OR	C
	JR	NZ,.310D
; clear screen
L3116	LD	DE,NT+0000H
	RST	18H		; set VDP write address = DE
	LD	BC,0300H	; size of name table
.311D	LD	A,' '
	OUT	(VDPdata),A
	DEC	BC
	LD	A,B
	OR	C
	JR	NZ,.311D
	RET

;-----------------------------------------------------------------------

L3127	LD	A,(DC0C9)
	OR	A
	RET	Z
	CALL	L2261
	LD	A,(DC07B)
	DEC	A
	LD	(DC07B),A
	RET	NZ
	LD	A,05H
	LD	(DC07B),A
	LD	A,(DC062)
	DEC	A
	LD	(DC062),A
	AND	07H
	OR	A
	RET	NZ
	LD	A,(DC064)
	ADD	A,04H
	LD	(DC064),A
	CP	0A4H
	RET	NZ
	LD	A,0A8H
	LD	(DC064),A
	XOR	A
	LD	(DC0C9),A
	RET

;-----------------------------------------------------------------------

L315C	LD	A,(DC0C7)
	OR	A
	RET	Z

	LD	A,(DC0C8)
	DEC	A
	LD	(DC0C8),A
	RET	NZ
	LD	(DC0C7),A

    IF      COLECO
	LD	B,04H
    ELSE
	LD	B,04H
    ENDIF
	CALL	L006B		; delay a while

  if coleco
	LD	A,1
	LD	(NMIDIS),A

	LD	A,82H|20H	; register 1 = 82H
  else
	LD	A,82H		; register 1 = 82H
  endif
	OUT	(VDPcmd),A	; 16K, blank screen, disable V-int, 16x16 sprites
	LD	A,81H
	OUT	(VDPcmd),A
	_DI
    IF      COLECO
    ELSE
	POP	HL		; remove return address and return to title screen
    ENDIF
	JP	L00A6

;-----------------------------------------------------------------------

L317E	LD	A,(DC0C7)
	OR	A
	RET	Z
	LD	A,(DC0C8)
	DEC	A
	LD	(DC0C8),A
	RET	NZ
	XOR	A
	LD	(DC0CF),A	; clear challenge level flag
	LD	(DC0C7),A
	_DI

    IF      COLECO
	LD	B,03H
    ELSE
	LD	B,04H
    ENDIF
	CALL	L006B		; delay a while

  if coleco
	LD	A,1
	LD	(NMIDIS),A

	LD	A,82H|20H	; register 1 = 82H
  else
	LD	A,82H		; register 1 = 82H
  endif
	OUT	(VDPcmd),A	; 16K, blank screen, disable V-int, 16x16 sprites
	LD	A,81H
	OUT	(VDPcmd),A
	CALL	L30DB
	POP	HL
	JP	L00D1

;-----------------------------------------------------------------------

L31A7	LD	HL,0400H	; reset attract mode timer
	LD	(DC014),HL

	XOR	A		; reset attract mode input offset
	LD	(DC013),A

	CALL	L2B29
	CALL	L30DB
	CALL	L029B		; clear VDP sprite attribute table
	JP	L00D7

;-----------------------------------------------------------------------

; attract mode joystick input
L31BD	LD	A,(DC012)	; test title screen flag
	OR	A
	RET	Z		; return if not title screen

	LD	A,(DC01D)
	OR	A
	RET	Z

	LD	A,(DC013)	; get attract mode input offset
	LD	L,A
	LD	H,00H
	LD	DE,D389C
	ADD	HL,DE

	LD	A,(HL)		; get input value
	LD	(DC018),A

	LD	HL,(DC014)	; decrement attract mode timer
	DEC	HL
	LD	(DC014),HL

	LD	A,H		; check if attract mode expired
	OR	L
	JR	Z,.31F1

	LD	A,L		; return if L MOD 8 != 0
	AND	07H
	RET	NZ

	LD	A,(DC013)	; increment attract mode input offset
	INC	A
	CP	50H
	JR	C,.31ED
	XOR	A
.31ED	LD	(DC013),A
	RET

; attract mode expired
.31F1	_DI
  if coleco
	LD	A,1
	LD	(NMIDIS),A

	LD	A,82H|20H	; register 1 = 82H
  else
	LD	A,82H		; register 1 = 82H
  endif
	OUT	(VDPcmd),A	; 16K, blank screen, disable V-int, 16x16 sprites
	LD	A,81H
	OUT	(VDPcmd),A

	LD	HL,DC026	; clear RAM sprite attribute table
	LD	DE,DC026+1
	LD	BC,0048H-1
	LD	(HL),0E8H
	LDIR

	CALL	L7312		; silence PSG
	CALL	L029B		; clear VDP sprite attribute table
    IF      COLECO
    ELSE
	POP	HL
	POP	HL		; remove return address and return to title screen
    ENDIF
	JP	L00A6

;-----------------------------------------------------------------------

L3212	LD	A,(DC0D0)
	CP	01H
	JR	Z,.3220
	LD	A,(DC0D2)
	OR	A
	JP	Z,L343A
.3220	LD	A,(DC01E)
	DEC	A
	LD	(DC01E),A
	JR	NZ,.322F
	LD	A,05H
	LD	(DC01E),A
	RET

.322F	LD	A,(DC01F)
	DEC	A
	LD	(DC01F),A
	JR	NZ,.3242
	LD	A,08H
	LD	(DC01F),A
	_DI
	CALL	L089F		; scroll grass left (to move right)
	_EI
.3242	LD	IX,DC036
	LD	A,(DC0D2)
	CP	01H
	JR	NZ,.3253
	CALL	L327B
	JP	L32DF

.3253	CP	02H
	JR	NZ,.325D
	CALL	L32A1
	JP	L32DF

.325D	CP	03H
	JR	NZ,.3266
	CALL	L3299
	JR	L32DF

.3266	LD	A,(DC018)
	BIT	B_1A,A
	JR	Z,L32C0
	BIT	B_1B,A
	JR	Z,L32C0
	BIT	B_1L,A
	JR	Z,L327B
	BIT	B_1R,A
	JR	Z,L32A1
	JR	L3299

; left
L327B	CALL	L3325
	LD	B,02H
	CALL	L07B5
	LD	A,(DC037)	; sprite 4 X
	OR	A
	JR	Z,.328D
	DEC	A
	JP	L0470

.328D	LD	A,(DC0D2)
	CP	01H
	RET	NZ
	LD	A,02H
	LD	(DC0D2),A
	RET

;-----------------------------------------------------------------------

L3299	CALL	L3325
	LD	B,03H
	JP	L07B5

;-----------------------------------------------------------------------

; right
L32A1	CALL	L3325
	LD	B,03H
	CALL	L07B5
	LD	A,(DC037)	; sprite 4 X
	CP	0E0H
	JR	Z,.32B4
	INC	A
	JP	L0470

.32B4	LD	A,(DC0D2)
	CP	02H
	RET	NZ
	LD	A,01H
	LD	(DC0D2),A
	RET

;-----------------------------------------------------------------------

L32C0	BIT	2,A
	JR	NZ,.32C8
	LD	A,01H
	JR	.32D2

.32C8	BIT	3,A
	JR	NZ,.32D0
	LD	A,02H
	JR	.32D2

.32D0	LD	A,03H
.32D2	LD	(DC0D2),A
	XOR	A
	LD	(DC0D1),A
	LD	HL,DC200
	LD	(HL),96H
	RET

;-----------------------------------------------------------------------

L32DF	LD	A,(DC0D2)
	CP	01H
	CALL	NZ,L3391
	LD	A,(DC0D1)
	CP	70H
	JR	C,.32F3
	XOR	A
	LD	(DC0D2),A
	RET

.32F3	INC	A
	LD	(DC0D1),A
	LD	D,A
	LD	A,38H
	LD	C,A
	LD	A,D
	SUB	C
	JP	P,.3302
	LD	A,C
	SUB	D
.3302	LD	D,00H
	LD	E,A
	LD	H,A
	LD	L,D
	LD	B,08H
.3309	ADD	HL,HL
	JR	NC,.330D
	ADD	HL,DE
.330D	DJNZ	.3309
	LD	C,30H
	LD	B,10H
	XOR	A
.3314	ADD	HL,HL
	RLA
	CP	C
	JR	C,.331C
	SUB	C
	SET	0,L
.331C	DJNZ	.3314
	LD	A,L
	ADD	A,2FH
	CALL	L0441
	RET

;-----------------------------------------------------------------------

L3325	LD	B,04H
.3327	LD	H,00H
	LD	L,B
	DEC	L
	ADD	HL,HL
	LD	DE,D3359
	ADD	HL,DE
	EX	DE,HL
	LD	A,(DE)
	ADD	A,(IX+00H)
	AND	0F8H
	LD	H,00H
	LD	L,A
	ADD	HL,HL
	ADD	HL,HL
	INC	DE
	LD	A,(DE)
	ADD	A,(IX+01H)
	CALL	L0477		; A = high 5 bits of A
	LD	D,00H
	LD	E,A
	ADD	HL,DE
	LD	DE,NT+0000H
	ADD	HL,DE
	_DI
	CALL	L003B		; set VDP read address = HL
	IN	A,(VDPdata)
	_EI
	OR	A
	JR	NZ,L3361
	DJNZ	.3327
	RET

D3359	DB	08H,08H,10H,08H,08H,18H,10H,18H

L3361	LD	A,(DC0D0)
	CP	04H
	RET	Z
	LD	HL,DC200
	LD	(HL),84H
	LD	A,03H
	LD	(DC0D2),A
	DEC	A
	DEC	A
	LD	(DC0D3),A
	LD	(DC090),A
	LD	A,80H
	LD	(DC01E),A
	LD	A,04H
	LD	(DC0D0),A
	LD	A,(DC0D1)
	CP	38H
	RET	NC
	LD	C,A
	LD	A,70H
	SUB	C
	LD	(DC0D1),A
	RET

;-----------------------------------------------------------------------

L3391	LD	A,(DC0D0)
	CP	01H
	RET	NZ
	_DI
	LD	A,(DC037)	; sprite 4 X
	CALL	L0477		; A = high 5 bits of A
	LD	L,A
	LD	H,00H
	LD	DE,NT+01C0H
	ADD	HL,DE
	CALL	L003B		; set VDP read address = HL
	IN	A,(VDPdata)
	_EI
	RES	5,A
	CP	90H
	JR	Z,.33B5
	CP	94H
	JR	NZ,.33BB
.33B5	LD	A,01H
	LD	(DC099),A
	RET

.33BB	CP	98H
	JR	Z,.33C2
	CP	9CH
	RET	NZ
.33C2	LD	A,(DC099)
	CP	01H
	RET	NZ
	XOR	A
	LD	(DC099),A

	LD	A,(DC0BE)	; count of flowers picked
	INC	A		; add a flower
	LD	(DC0BE),A

	LD	HL,DC200
	LD	(HL),85H

	LD	C,1CH
L33DA	LD	H,00H
	CP	0BH
	JR	NC,.33E7
	LD	L,A
	ADD	HL,HL
	LD	DE,NT+0284H
	JR	.33EE

.33E7	SUB	0AH
	LD	L,A
	ADD	HL,HL
	LD	DE,NT+02C4H
.33EE	ADD	HL,DE
	LD	D,00H
	LD	A,C
	_DI
	CALL	L1212
	_EI
	RET

;-----------------------------------------------------------------------

L33F8	LD	A,(DC01E)
	DEC	A
	LD	(DC01E),A
	RET	NZ
	LD	A,05H
	LD	(DC01E),A

	LD	A,(DC0BE)	; count of flowers picked
	OR	A
	JR	Z,.342D		; skip if already at zero flowers

	LD	C,18H
	CALL	L33DA
	CALL	L2B0C
	LD	A,(DC0BE)	; count of flowers picked
	DEC	A		; deduct one flower
	LD	(DC0BE),A

	LD	HL,DC200
	LD	(HL),8DH

.341F	LD	HL,D2354	; "BONUS",02H
	LD	DE,NT+006AH
	LD	B,N2354
	_DI
	CALL	L2D31		; write data to VDP: HL=data, DE=VRAM address, B=length
	_EI
	RET

.342D	LD	DE,DC007	; bonus score
	CALL	L2B20
	LD	A,06H
	LD	(DC0D0),A
	JR	.341F

;-----------------------------------------------------------------------

L343A	LD	A,(DC0D3)
	OR	A
	JR	Z,.3465
	LD	A,(DC0D0)
	CP	05H
	JR	Z,.345F
	CP	06H
	JP	Z,L3568
	CP	07H
	JP	Z,L3596
	CP	08H
	RET	NC
	CALL	L34D6
	LD	A,08H
	LD	(DC022),A
	JP	L2261

.345F	CALL	L33F8
	JP	L2261

.3465	LD	IX,DC036
	LD	A,(DC0D0)
	CP	02H
	JP	Z,L353B
	CP	03H
	JR	Z,L34F2
	CP	04H
	JR	Z,L34D6
	CP	05H
	JP	Z,L33F8
	CP	06H
	JP	Z,L3568
	CP	07H
	JP	Z,L3596
	CP	08H
	RET	NC
	LD	A,(DC01E)
	DEC	A
	LD	(DC01E),A
	JR	NZ,.349A
	LD	A,02H
	LD	(DC01E),A
	RET

.349A	LD	A,(DC037)	; sprite 4 X
	CP	64H
	JR	NZ,.34B6
	LD	A,03H
	LD	(DC0D0),A

	LD	HL,D34CA
	LD	DE,DC03E
	LD	BC,N34CA
	LDIR

	XOR	A
	LD	(DC023),A
	RET

.34B6	JR	NC,.34C1
	INC	A
	CALL	L0470
	LD	B,03H
	JP	L07B5

.34C1	DEC	A
	CALL	L0470
	LD	B,03H
	JP	L07B5

D34CA	DB	70H,0FFH,50H,04H,70H,0FFH,58H,0FH
N34CA	EQU	$-D34CA

;-----------------------------------------------------------------------

D34D2	DB	50H,7CH,90H,0DH
N34D2	EQU	$-D34D2

L34D6	LD	A,(DC01E)
	DEC	A
	LD	(DC01E),A
	RET	NZ
	LD	A,05H
	LD	(DC01E),A
	LD	(DC0D0),A
	LD	(DC0C7),A
	LD	A,80H
	LD	(DC0C8),A
	CALL	L0A19		; clear sprites 16 and 17
	RET

L34F2	LD	A,(DC01E)
	DEC	A
	LD	(DC01E),A
	JR	NZ,.3501
	LD	A,02H
	LD	(DC01E),A
	RET

.3501	LD	A,(DC03F)
	DEC	A
	CALL	L2907
	CP	78H
	JR	NZ,.351D
	LD	A,02H
	LD	(DC0D0),A

	LD	HL,D34D2
	LD	DE,DC062
	LD	BC,N34D2
	LDIR

	RET

.351D	LD	A,(DC024)
	DEC	A
	LD	(DC024),A
	RET	NZ
	LD	A,07H
	LD	(DC024),A
	LD	A,(DC040)
	CP	50H
	JR	Z,.3535
	LD	A,50H
	JR	.3537

.3535	LD	A,58H
.3537	CALL	L290E
	RET

;-----------------------------------------------------------------------

L353B	LD	A,(DC01E)
	DEC	A
	LD	(DC01E),A
	RET	NZ
	LD	A,0AH
	LD	(DC01E),A
	LD	A,(DC063)
	DEC	A
	DEC	A
	LD	(DC063),A
	CP	70H
	JR	NZ,.355F
	LD	A,0D8H
	LD	(DC01E),A
	LD	A,04H
	LD	(DC0D0),A
	RET

.355F	LD	A,(DC064)
	ADD	A,04H
	LD	(DC064),A
	RET

;-----------------------------------------------------------------------

L3568	LD	A,(DC0D3)
	OR	A
	JR	NZ,.3590
	_DI
	LD	HL,D35B8	; "PERFECT 5000"
	LD	DE,NT+00AAH
	LD	B,N35B8
	CALL	L2D31		; write data to VDP: HL=data, DE=VRAM address, B=length
	LD	HL,D35C4	; "TOTAL  10000"
	LD	DE,NT+00EAH
	LD	B,N35C4
	CALL	L2D31		; write data to VDP: HL=data, DE=VRAM address, B=length
	_EI
	XOR	A		; bonus index = 0
	LD	DE,DC007+2	; bonus score
	LD	HL,D35D0+2	; 005000 points
	CALL	L2A46		; add to score
.3590	LD	A,07H
	LD	(DC0D0),A
	RET

;-----------------------------------------------------------------------

L3596	_DI
	XOR	A		; bonus index = 0
	LD	DE,DC004+2	; current score
	LD	HL,DC007+2	; bonus score
	CALL	L2A46		; add to score
	CALL	L2A82
	_EI
	LD	A,08H
	LD	(DC0D0),A
	LD	(DC0C7),A
	LD	A,(DC0D3)
	OR	A
	RET	NZ
	LD	A,40H
	LD	(DC0C8),A
	RET

;-----------------------------------------------------------------------

D35B8	DB	_P,_E,_R,_F,_E,_C,_T," 5000"
N35B8	EQU	$-D35B8

D35C4	DB	_T,_O,_T,_A,_L,"  10000"
N35C4	EQU	$-D35C4

D35D0	DB	00H,50H,00H	; BCD 005000

;-----------------------------------------------------------------------

L35D3	LD	A,(DC090)
	DEC	A
	LD	(DC090),A
	RET	NZ
	LD	A,(DC0D0)
	DEC	A
	JR	NZ,.35E5
	LD	A,0CH
	JR	.35E7

.35E5	LD	A,01H
.35E7	LD	(DC090),A
	_DI
	LD	HL,NT+01C0H
	LD	B,04H
.35F0	PUSH	BC
	LD	DE,DC09A
	LD	B,20H
	LD	A,L
	OUT	(VDPcmd),A
	LD	A,H
	OUT	(VDPcmd),A
.35FC	PUSH	AF
	POP	AF
	PUSH	AF
	POP	AF
	IN	A,(VDPdata)
	LD	(DE),A
	INC	DE
	DJNZ	.35FC
	LD	DE,DC09B
	LD	B,1FH
	RST	28H		; set VDP write address = HL
	PUSH	AF
	POP	AF
.360E	LD	A,(DE)
	OR	A
	JR	Z,.361C
	BIT	5,A
	JR	Z,.361A
	RES	5,A
	JR	.361C

.361A	SET	5,A
.361C	OUT	(VDPdata),A
	INC	DE
	DJNZ	.360E
	XOR	A
	OUT	(VDPdata),A
	LD	DE,0020H
	ADD	HL,DE
	POP	BC
	DJNZ	.35F0
	CALL	.3630
	_EI
	RET

.3630	LD	A,(DC0D0)
	CP	01H
	JR	Z,.363C
	LD	A,(DC0D4)
	DEC	A
	RET	Z
.363C	LD	A,(DC0D4)
	DEC	A
	LD	(DC0D4),A
	JR	NZ,.364E
	LD	A,04H
	LD	(DC0D4),A
	LD	HL,DC0D5
	INC	(HL)
.364E	LD	H,00H
	DEC	A
	LD	L,A
	LD	DE,D36C1
	ADD	HL,DE
	LD	A,(HL)
	LD	C,A
	LD	A,(DC0D5)
	OR	A
	JR	Z,.3689
	LD	B,A
	LD	HL,(DC0C5)
	CP	08H
	JR	NZ,.3683
	XOR	A
	LD	(DC0D5),A
	LD	A,(DC0D6)
	DEC	A
	LD	(DC0D6),A
	JR	Z,.3679
	INC	HL
	LD	(DC0C5),HL
	JR	.368C

.3679	XOR	A
	LD	(DC0D0),A
	LD	HL,DC200
	LD	(HL),83H
	RET

.3683	LD	A,(HL)
.3684	RLCA
	DJNZ	.3684
	JR	.368D

.3689	LD	HL,(DC0C5)
.368C	LD	A,(HL)
.368D	RLCA
	CALL	C,.3692
	RET

.3692	LD	HL,NT+01DFH
	CALL	L36AA
	INC	C
	LD	HL,NT+01FFH
	CALL	L36AA
	INC	C
	LD	HL,NT+021FH
	CALL	L36AA
	INC	C
	LD	HL,NT+023FH
L36AA	CALL	L003B		; set VDP read address = HL
	IN	A,(VDPdata)
	OR	A
	JR	Z,.36BC
	BIT	5,A
	JR	Z,.36BA
	RES	5,C
	JR	.36BC

.36BA	SET	5,C
.36BC	RST	28H		; set VDP write address = HL
	LD	A,C
	OUT	(VDPdata),A
	RET

;-----------------------------------------------------------------------

D36C1	DB	9CH,0B8H,94H,0B0H

D36C5	HEX	92 4C 24 78 B1 C3 00 00
	HEX	88 E3 12 38 E2 47 00 00
	HEX	A9 24 68 4C 8E 93 00 00
	HEX	D1 45 16 49 18 CB 00 00
	HEX	7C 78 E3 0A 24 24 00 00
	HEX	92 78 66 93 0A 52 00 00
	HEX	94 52 13 34 6C A5 00 00
	HEX	99 71 94 4C C4 29 00 00

L3705	LD	HL,DC018
	LD	DE,DC018+1
	LD	BC,NC018-1	; 015AH
	LD	(HL),00H
	LDIR

	XOR	A		; clear bonus score
	LD	(DC007),A
	LD	(DC007+1),A
	LD	(DC007+2),A
	LD	(DC0BE),A	; clear count of flowers picked
	LD	A,01H
	LD	(DC0CF),A	; set challenge level flag
	LD	(DC0D0),A
	LD	(DC079),A

	LD	HL,DC026
	LD	DE,DC026+1
	LD	BC,004CH-1
	LD	(HL),0E8H	; 232
	LDIR

	CALL	L2D39		; show high score and score
	LD	HL,NT+000AH
	LD	A,0AH
	LD	B,02H
.3741	PUSH	BC
	LD	B,0BH
	PUSH	AF
	RST	28H		; set VDP write address = HL
	POP	AF
.3747	PUSH	AF
	POP	AF
	OUT	(VDPdata),A
	INC	A
	DJNZ	.3747
	POP	BC
	LD	DE,0020H
	ADD	HL,DE
	DJNZ	.3741
	LD	HL,CT+0800H
	RST	28H		; set VDP write address = HL
	LD	B,08H
.375B	LD	A,77H
	OUT	(VDPdata),A
	PUSH	AF
	POP	AF
	DJNZ	.375B

	LD	HL,D37C5
	LD	DE,DC036
	LD	BC,N37C5
	LDIR

	LD	A,07H
	LD	(DC024),A
	LD	A,01H
	LD	(DC01E),A
	LD	(DC022),A
	LD	A,08H
	LD	(DC01F),A

	LD	HL,D37CD
	LD	DE,DC066
	LD	BC,N37CD
	LDIR

	LD	A,14H
	LD	(DC077),A
	LD	A,0CH
	LD	(DC078),A
	LD	A,07H
	LD	(DC0D6),A
	LD	A,05H
	LD	(DC0D4),A
	LD	A,0CH
	LD	(DC090),A
	LD	A,06H		; reset grass scroll delay count
	LD	(DC07E),A
	LD	(DC07F),A	; set grass scroll request flag
	CALL	L08D9		; update grass at bottom of screen
	LD	A,(DC00D)
	DEC	A
	DEC	A
	RRCA
	AND	07H
	LD	L,A
	LD	H,00H
	ADD	HL,HL
	ADD	HL,HL
	ADD	HL,HL
	LD	DE,D36C5
	ADD	HL,DE
	LD	(DC0C5),HL
	RET

D37C5	DB	70H,78H,10H,0DH,70H,78H,14H,0FH
N37C5	EQU	$-D37C5

D37CD	DB	08H,00H,0E0H,8FH,20H,70H,0E4H,8FH
N37CD	EQU	$-D37CD

;-----------------------------------------------------------------------

L37D5	LD	A,(DC017)
	DEC	A
	LD	(DC017),A
	RET	NZ
	LD	A,10H
	LD	(DC017),A
	_DI

	LD	DE,PT+0800H+3CH*8
	CALL	L3806
	LD	DE,PT+0800H+4AH*8
	CALL	L3806
	LD	DE,PT+1000H+3CH*8
	CALL	L3806
	LD	DE,PT+1000H+4AH*8
	CALL	L3806

	LD	A,(DC016)
	DEC	A
	AND	07H
	LD	(DC016),A
	_EI
	RET

L3806	RST	18H		; set VDP write address = DE
	LD	A,(DC016)
	OR	A
	JR	NZ,.3811
	LD	B,08H
	JR	.3821

.3811	LD	B,A
	LD	HL,D42FE
.3815	INC	HL
	DJNZ	.3815
	LD	C,A
	LD	A,08H
	SUB	C
	LD	B,A
	CALL	.3824
	LD	B,C
.3821	LD	HL,D42FE
.3824	LD	A,(HL)
	OUT	(VDPdata),A
	INC	HL
	PUSH	HL
	POP	HL
	DJNZ	.3824
	RET

;-----------------------------------------------------------------------

L382D	LD	HL,DC0E6
	DEC	(HL)
	RET	NZ
	LD	(HL),0FH
    IF      OPT
	INC	HL
    ELSE
	LD	HL,DC0E7
    ENDIF
	DEC	(HL)
	JR	NZ,.3851
	CALL	L387D
	AND	07H
	INC	A
	LD	(HL),A
	LD	A,(DC14E)
	LD	B,A
	AND	0EFH
	LD	C,A
	LD	A,B
	AND	10H
	XOR	10H
	OR	C
	LD	(DC14E),A
.3851	LD	A,(DC14E)
	LD	C,A
	LD	HL,0A20H
	_DI
	LD	B,02H
.385B	PUSH	BC
	LD	B,08H
.385E	CALL	L003B		; set VDP read address = HL
	IN	A,(VDPdata)
	BIT	4,C
	JR	Z,.386A
	RRCA
	JR	.386B

.386A	RLCA
.386B	EX	AF,AF'
	EX	DE,HL
	RST	18H		; set VDP write address = DE
	EX	AF,AF'
	OUT	(VDPdata),A
	EX	DE,HL
	INC	HL
	DJNZ	.385E
	LD	HL,1220H
	POP	BC
	DJNZ	.385B
	_EI
	RET

;-----------------------------------------------------------------------

L387D	PUSH	HL
	LD	HL,(DC00B)
	LD	A,H
	RRCA
	RRCA
	XOR	H
	RRCA
	XOR	L
	RRCA
	RRCA
	RRCA
	RRCA
	XOR	L
	RRA
	ADC	HL,HL
	JR	NZ,.3894
	LD	HL,733CH
.3894	LD	A,R
	XOR	L
	LD	(DC00B),HL
	POP	HL
	RET

;-----------------------------------------------------------------------

; input data for attract mode
D389C	HEX	F9 F9 F9 F9 F9 F9 F9 F9 F9 F9 F9 F9 F9 F9 F9 F9
	HEX	F9 F9 DD F5 F5 F5 F5 F5 F5 F5 F5 F5 F5 F5 F5 F5
	HEX	F7 F7 F7 F7 F7 F7 F7 F7 D9 F9 F9 F9 F9 FA F6 F6
	HEX	F6 F6 F6 F6 F6 F6 F7 D9 FB FB FA FA FE F6 F6 F6
	HEX	F6 F6 F6 F6 F6 F6 F6 F6 F6 F6 F6 F6 F5 F5 FD FD
	HEX	FD FD FD FD FD FD FD FD FD F5 F5 F7 F7 F5 F5 F5
	HEX	F5 F5 F5 F5 F5 F5 F5 F5 F7 FE F7 F5 F5 F5 F5 F5
	HEX	F5 F5 F5 F5 F5 F7 FE FE FE FE DD FD FD FD FD F5
	HEX	00 00

  IF RLE
RLE391E
	HEX	01 0F 7F 81 DF 07 0F 07 00 01 07 0F 1F 18 81 00
	HEX	02 F0 78 7C 80 7A 07 70 E0 00 C0 E0 F0 F8 88 88
	HEX	00 04 01 0C 18 10 00 82 07 85 00 04 80 38 1C 0C
	HEX	00 80 70 04 30 80 0F 1E 3E 80 5E 07 0E 07 00 03
	HEX	07 0F 1F 11 81 00 01 F0 FE 81 FB 07 F0 E0 00 80
	HEX	E0 F0 F8 18 89 00 04 01 1C 38 30 00 80 0E 00 0C
	HEX	86 00 04 80 30 18 08 00 81 E0 0C 0F 7F DF DC D9
	HEX	01 08 00 01 03 01 11 1F 81 00 05 F0 F8 FC 9A 2A
	HEX	20 80 00 04 C0 60 F0 70 88 84 00 09 03 06 0E 07
	HEX	01 0C 1C 1E 0E 00 81 07 81 00 00 60 80 D0 05 E0
	HEX	80 38 1C 0C 08 80 70 07 30 80 0F 1F 3F 59 54 04
	HEX	80 00 04 03 06 0F 0E 11 81 00 0C F0 FE FB 3B 9B
	HEX	80 10 00 80 C0 80 88 F8 84 00 00 06 80 0B 05 07
	HEX	01 1C 38 30 10 80 0E 01 0C 01 81 00 09 C0 60 70
	HEX	E0 80 30 38 78 70 00 81 E0 05 1F 3F 7F 47 11 10
	HEX	80 01 00 07 80 08 02 1C 1F 1E 80 00 00 D8 81 EC
	HEX	80 C0 06 80 00 80 C0 00 60 E0 84 00 05 38 2E 2F
	HEX	3E 1E 00 80 07 04 03 00 01 07 0F 88 00 01 C0 80
	HEX	82 00 08 1F 3F 7F 47 11 10 01 00 07 80 08 00 11
	HEX	80 1F 80 00 00 D8 80 EC 00 E4 80 C0 06 80 00 80
	HEX	E0 F0 E0 C0 84 00 05 38 2E 2F 3E 1F 00 80 07 00
	HEX	0E 80 00 01 0E 1C 8B 00 03 F0 E0 00 37 81 6F 08
	HEX	07 06 03 01 03 06 00 0C 0F 81 00 03 F0 F8 FC C4
	HEX	80 10 80 00 00 C0 80 20 00 70 80 F0 85 00 00 01
	HEX	81 00 03 01 07 03 00 81 01 81 00 00 38 80 E8 02
	HEX	F8 F0 00 80 C0 00 80 80 00 0F C0 E0 37 6F EF 4F
	HEX	07 06 03 00 03 0E 1E 0F 07 01 80 00 03 F0 F8 FC
	HEX	C4 80 10 80 00 00 C0 80 20 00 10 80 F0 85 00 03
	HEX	01 00 01 00 80 01 80 00 01 1E 0E 82 00 00 38 80
	HEX	E8 02 F8 F0 00 80 C0 00 E0 80 00 03 E0 70 67 D3
	HEX	80 CF 09 0E 0C 06 02 03 07 0F 1F 3F 08 80 00 03
	HEX	E0 F0 F8 88 80 20 80 00 00 80 80 00 81 C0 80 00
	HEX	05 08 0C 30 10 01 03 80 01 83 00 81 07 81 00 00
	HEX	70 80 D0 04 F0 E0 1C FC F8 82 00 04 80 01 03 07
	HEX	06 80 01 83 00 00 02 80 03 80 00 00 FC 80 FE 05
	HEX	1E 06 0C 00 70 90 80 18 02 38 F8 F0 83 00 00 01
	HEX	80 02 05 01 00 03 07 03 01 81 00 00 01 81 00 05
	HEX	E0 F8 F0 F8 80 60 80 E0 00 C0 80 00 80 E0 03 07
	HEX	0F 1F 18 80 04 01 00 03 80 04 03 0C 04 0C 0F 80
	HEX	00 00 F0 80 F8 05 78 18 30 00 C0 40 81 60 01 E0
	HEX	C0 83 00 00 07 80 0B 09 07 00 03 0B 03 0B 03 00
	HEX	03 07 81 00 04 80 E0 C0 E0 00 82 80 80 00 80 80
	HEX	03 07 0F 1F 18 80 04 01 00 03 80 06 03 04 0C 0F
	HEX	06 80 00 00 F0 80 F8 05 78 18 30 00 C0 60 80 30
	HEX	00 70 80 E0 83 00 00 07 80 0B 01 07 00 80 01 80
	HEX	03 03 00 08 0E 1F 81 00 05 80 E0 C0 E0 00 80 80
	HEX	C0 00 80 80 00 80 C0 00 0F 80 1F 05 1E 18 0C 00
	HEX	03 02 81 06 01 07 03 80 00 03 E0 F0 F8 18 80 20
	HEX	01 00 C0 80 20 03 30 20 30 F0 83 00 04 01 07 03
	HEX	07 00 82 01 80 00 80 01 81 00 00 E0 80 D0 0A E0
	HEX	00 C0 D0 C0 D0 C0 00 C0 E0 0F 80 1F 05 1E 18 0C
	HEX	00 03 06 80 0C 00 0E 80 07 80 00 03 E0 F0 F8 18
	HEX	80 20 01 00 C0 80 60 03 20 30 F0 60 83 00 05 01
	HEX	07 03 07 00 01 80 03 00 01 80 00 80 03 81 00 00
	HEX	E0 80 D0 03 E0 00 80 90 80 C0 0A 00 10 70 F8 0F
	HEX	7F DF 1C 19 01 08 87 00 05 E0 FC F6 9A 28 20 8B
	HEX	00 04 03 06 6E 77 3D 89 00 04 60 D0 DC EC B8 87
	HEX	00 05 20 67 27 07 08 11 88 00 05 02 E6 F8 F0 48
	HEX	20 8A 00 04 18 38 37 2E 17 89 00 04 04 0E B6 DA
	HEX	F4 86 00 01 30 6F 80 5F 80 1F 06 05 00 01 02 07
	HEX	0E 1F 81 00 01 0E F7 80 FB 80 F8 06 D0 00 80 C0
	HEX	E0 F0 F8 87 00 04 0A 1F 38 3C 38 80 00 80 0E 00
	HEX	0F 84 00 04 20 F0 38 1C 18 80 00 80 70 02 F0 70
	HEX	EF 80 DF 80 1F 06 0B 00 01 03 07 0F 1F 81 00 01
	HEX	0C F6 80 FA 80 F8 06 A0 00 80 40 E0 70 F8 87 00
	HEX	04 04 0F 1C 38 18 80 00 80 0E 00 0F 84 00 04 50
	HEX	F8 1C 3C 1C 80 00 80 70 00 F0 87 00 00 6C 80 BE
	HEX	03 FE 5C 38 10 97 00 00 6C 80 BE 03 FE 5C 38 10
	HEX	95 00 01 77 FF 80 BF 04 FF 5F 3E 1C 08 86 00 82
	HEX	80 87 00 01 71 FB 81 BF 05 FF 5F 2F 1F 0E 04 83
	HEX	00 00 C0 83 E0 01 C0 80 84 00 01 38 7D 82 DF 06
	HEX	FF 6F 37 1F 0F 07 02 81 00 01 E0 F0 83 F8 03 F0
	HEX	E0 C0 80 81 00 01 38 7E 83 DF 0A 7F 6F 37 1F 0F
	HEX	07 03 01 00 38 FC 83 FE 80 FC 04 F8 F0 E0 C0 80
	HEX	80 00 1C 38 7C DE DC D8 DC DF 7E 6C 36 1F 0E 04
	HEX	02 01 00 38 7C 3E 7E FE 7E 3E 7C FC 78 30 60 C0
	HEX	81 00 01 38 7E 83 DF 07 7F 6F 37 1F 0F 07 03 01
	HEX	93 00 04 20 60 FF 60 20 89 00 04 1F 3E FC 3E 1F
	HEX	89 00 04 F8 7C 3F 7C F8 89 00 04 04 06 FF 06 04
	HEX	95 00 01 38 FC 83 FE 80 FC 07 F8 F0 E0 C0 80 00
	HEX	1F 3F 80 7F 00 03 81 01 00 06 80 01 01 0F 1F 80
	HEX	3F 01 00 80 84 C0 00 80 82 00 00 80 80 C0 85 00
	HEX	08 06 09 1C 27 44 48 21 1C 07 85 00 09 1E 71 86
	HEX	FC 9A 5B 55 AB 56 3D 85 00 06 06 03 18 3B 37 16
	HEX	03 87 00 01 0E 78 80 00 80 80 84 00 00 03 81 04
	HEX	07 02 19 27 44 48 21 1C 07 82 00 00 B0 80 48 80
	HEX	88 07 90 FC 9A 5B 55 AB 56 3D 82 00 81 03 06 01
	HEX	00 18 3B 37 16 03 84 00 01 30 B0 80 70 00 60 80
	HEX	00 80 80 87 00 09 78 8E 61 3F 59 DA AA D5 6A BC
	HEX	84 00 08 60 90 38 E4 22 12 84 38 E0 86 00 01 70
	HEX	1E 80 00 80 01 88 00 06 60 C0 18 DC EC 68 C0 83
	HEX	00 00 0D 80 12 80 11 07 09 3F 59 DA AA D5 6A BC
	HEX	81 00 00 C0 81 20 07 40 98 E4 22 12 84 38 E0 83
	HEX	00 01 0C 0D 80 0E 00 06 80 00 80 01 85 00 81 C0
	HEX	06 80 00 18 DC EC 68 C0 85 00 00 1E 80 7F 84 FF
	HEX	01 7F 1E 84 00 04 80 B8 DE DF F7 81 FB 02 F6 68
	HEX	1E 80 7F 84 FF 01 7F 1E 84 00 04 80 B8 DE DF F7
	HEX	81 FB 01 F6 68 83 00 07 03 04 08 09 0F 09 04 03
	HEX	86 00 01 C0 E0 82 F0 01 E0 C0 87 00 05 03 07 06
	HEX	00 06 03 97 00 02 FF FC F0 80 E0 84 C0 80 E0 01
	HEX	F0 FC 80 FF 01 3F 0F 80 07 84 03 80 07 01 0F 3F
	HEX	83 FF 00 FE 80 F8 80 F0 80 F8 00 FE 86 FF 00 7F
	HEX	80 1F 80 0F 80 1F 00 7F 88 FF 00 FE 80 FC 00 FE
	HEX	8A FF 00 7F 80 3F 00 7F A4 FF FF
  ELSE
; sprite pattern table data
D391E
	DB	00001111B	; 00
	DB	01111111B
	DB	11011111B
	DB	11011111B
	DB	11011111B
	DB	00001111B
	DB	00000111B
	DB	00000000B

	DB	00000001B	; 01
	DB	00000111B
	DB	00001111B
	DB	00011111B
	DB	00011000B
	DB	00000000B
	DB	00000000B
	DB	00000000B

	DB	11110000B	; 02
	DB	01111000B
	DB	01111100B
	DB	01111010B
	DB	01111010B
	DB	01110000B
	DB	11100000B
	DB	00000000B

	DB	11000000B	; 03
	DB	11100000B
	DB	11110000B
	DB	11111000B
	DB	10001000B
	DB	00000000B
	DB	00000000B
	DB	00000000B

	DB	00000000B	; 04
	DB	00000000B
	DB	00000000B
	DB	00000000B
	DB	00000000B
	DB	00000000B
	DB	00000000B
	DB	00000001B

	DB	00001100B	; 05
	DB	00011000B
	DB	00010000B
	DB	00000000B
	DB	00000111B
	DB	00000111B
	DB	00000111B
	DB	00000111B

	DB	00000000B	; 06
	DB	00000000B
	DB	00000000B
	DB	00000000B
	DB	00000000B
	DB	00000000B
	DB	00000000B
	DB	10000000B

	DB	00111000B	; 07
	DB	00011100B
	DB	00001100B
	DB	00000000B
	DB	01110000B
	DB	01110000B
	DB	00110000B
	DB	10000000B

	DB	00001111B	; 08
	DB	00011110B
	DB	00111110B
	DB	01011110B
	DB	01011110B
	DB	00001110B
	DB	00000111B
	DB	00000000B

	DB	00000011B	; 09
	DB	00000111B
	DB	00001111B
	DB	00011111B
	DB	00010001B
	DB	00000000B
	DB	00000000B
	DB	00000000B

	DB	11110000B	; 0A
	DB	11111110B
	DB	11111011B
	DB	11111011B
	DB	11111011B
	DB	11110000B
	DB	11100000B
	DB	00000000B

	DB	10000000B	; 0B
	DB	11100000B
	DB	11110000B
	DB	11111000B
	DB	00011000B
	DB	00000000B
	DB	00000000B
	DB	00000000B

	DB	00000000B	; 0C
	DB	00000000B
	DB	00000000B
	DB	00000000B
	DB	00000000B
	DB	00000000B
	DB	00000000B
	DB	00000000B

	DB	00000001B	; 0D
	DB	00011100B
	DB	00111000B
	DB	00110000B
	DB	00000000B
	DB	00001110B
	DB	00001110B
	DB	00001100B

	DB	00000000B	; 0E
	DB	00000000B
	DB	00000000B
	DB	00000000B
	DB	00000000B
	DB	00000000B
	DB	00000000B
	DB	00000000B

	DB	10000000B	; 0F
	DB	00110000B
	DB	00011000B
	DB	00001000B
	DB	00000000B
	DB	11100000B
	DB	11100000B
	DB	11100000B

	DB	00001111B	; 10
	DB	01111111B
	DB	11011111B
	DB	11011100B
	DB	11011001B
	DB	00000001B
	DB	00001000B
	DB	00000000B


	DB	00000001B	; 11
	DB	00000011B
	DB	00000001B
	DB	00010001B
	DB	00011111B
	DB	00000000B
	DB	00000000B
	DB	00000000B

	DB	11110000B	; 12
	DB	11111000B
	DB	11111100B
	DB	10011010B
	DB	00101010B
	DB	00100000B
	DB	00000000B
	DB	00000000B

	DB	11000000B	; 13
	DB	01100000B
	DB	11110000B
	DB	01110000B
	DB	10001000B
	DB	00000000B
	DB	00000000B
	DB	00000000B

	DB	00000000B	; 14
	DB	00000000B
	DB	00000000B
	DB	00000011B
	DB	00000110B
	DB	00001110B
	DB	00000111B
	DB	00000001B

	DB	00001100B	; 15
	DB	00011100B
	DB	00011110B
	DB	00001110B
	DB	00000000B
	DB	00000111B
	DB	00000111B
	DB	00000111B

	DB	00000000B	; 16
	DB	00000000B
	DB	00000000B
	DB	01100000B
	DB	11010000B
	DB	11010000B
	DB	11100000B
	DB	10000000B

	DB	00111000B	; 17
	DB	00011100B
	DB	00001100B
	DB	00001000B
	DB	01110000B
	DB	01110000B
	DB	00110000B
	DB	10000000B

	DB	00001111B	; 18
	DB	00011111B
	DB	00111111B
	DB	01011001B
	DB	01010100B
	DB	00000100B
	DB	00000000B
	DB	00000000B

	DB	00000011B	; 19
	DB	00000110B
	DB	00001111B
	DB	00001110B
	DB	00010001B
	DB	00000000B
	DB	00000000B
	DB	00000000B

	DB	11110000B	; 1A
	DB	11111110B
	DB	11111011B
	DB	00111011B
	DB	10011011B
	DB	10000000B
	DB	00010000B
	DB	00000000B

	DB	10000000B	; 1B
	DB	11000000B
	DB	10000000B
	DB	10001000B
	DB	11111000B
	DB	00000000B
	DB	00000000B
	DB	00000000B

	DB	00000000B	; 1C
	DB	00000000B
	DB	00000000B
	DB	00000110B
	DB	00001011B
	DB	00001011B
	DB	00000111B
	DB	00000001B

	DB	00011100B	; 1D
	DB	00111000B
	DB	00110000B
	DB	00010000B
	DB	00001110B
	DB	00001110B
	DB	00001100B
	DB	00000001B

	DB	00000000B	; 1E
	DB	00000000B
	DB	00000000B
	DB	11000000B
	DB	01100000B
	DB	01110000B
	DB	11100000B
	DB	10000000B

	DB	00110000B	; 1F
	DB	00111000B
	DB	01111000B
	DB	01110000B
	DB	00000000B
	DB	11100000B
	DB	11100000B
	DB	11100000B

	DB	00011111B	; 20
	DB	00111111B
	DB	01111111B
	DB	01000111B
	DB	00010001B
	DB	00010000B
	DB	00000001B
	DB	00000001B

	DB	00000111B	; 21
	DB	00001000B
	DB	00001000B
	DB	00011100B
	DB	00011111B
	DB	00011110B
	DB	00000000B
	DB	00000000B

	DB	11011000B	; 22
	DB	11101100B
	DB	11101100B
	DB	11101100B
	DB	11000000B
	DB	11000000B
	DB	10000000B
	DB	00000000B

	DB	10000000B	; 23
	DB	11000000B
	DB	00000000B
	DB	01100000B
	DB	11100000B
	DB	00000000B
	DB	00000000B
	DB	00000000B

	DB	00000000B	; 24
	DB	00000000B
	DB	00000000B
	DB	00111000B
	DB	00101110B
	DB	00101111B
	DB	00111110B
	DB	00011110B

	DB	00000000B	; 
	DB	00000111B
	DB	00000111B
	DB	00000011B
	DB	00000000B
	DB	00000001B
	DB	00000111B
	DB	00001111B

	DB	00000000B	; 
	DB	00000000B
	DB	00000000B
	DB	00000000B
	DB	00000000B
	DB	00000000B
	DB	00000000B
	DB	00000000B

	DB	00000000B	; 
	DB	00000000B
	DB	11000000B
	DB	10000000B
	DB	00000000B
	DB	00000000B
	DB	00000000B
	DB	00000000B

	DB	00011111B	; 28
	DB	00111111B
	DB	01111111B
	DB	01000111B
	DB	00010001B
	DB	00010000B
	DB	00000001B
	DB	00000000B

	DB	00000111B	; 
	DB	00001000B
	DB	00001000B
	DB	00010001B
	DB	00011111B
	DB	00011111B
	DB	00000000B
	DB	00000000B

	DB	11011000B	; 
	DB	11101100B
	DB	11101100B
	DB	11100100B
	DB	11000000B
	DB	11000000B
	DB	10000000B
	DB	00000000B

	DB	10000000B	; 
	DB	11100000B
	DB	11110000B
	DB	11100000B
	DB	11000000B
	DB	00000000B
	DB	00000000B
	DB	00000000B

	DB	00000000B	; 2C
	DB	00000000B
	DB	00000000B
	DB	00111000B
	DB	00101110B
	DB	00101111B
	DB	00111110B
	DB	00011111B

	DB	00000000B	; 
	DB	00000111B
	DB	00000111B
	DB	00001110B
	DB	00000000B
	DB	00000000B
	DB	00001110B
	DB	00011100B

	DB	00000000B	; 
	DB	00000000B
	DB	00000000B
	DB	00000000B
	DB	00000000B
	DB	00000000B
	DB	00000000B
	DB	00000000B

	DB	00000000B	; 
	DB	00000000B
	DB	00000000B
	DB	00000000B
	DB	00000000B
	DB	11110000B
	DB	11100000B
	DB	00000000B

	DB	00110111B	; 30
	DB	01101111B
	DB	01101111B
	DB	01101111B
	DB	00000111B
	DB	00000110B
	DB	00000011B
	DB	00000001B

	DB	00000011B	; 
	DB	00000110B
	DB	00000000B
	DB	00001100B
	DB	00001111B
	DB	00000000B
	DB	00000000B
	DB	00000000B

	DB	11110000B	; 
	DB	11111000B
	DB	11111100B
	DB	11000100B
	DB	00010000B
	DB	00010000B
	DB	00000000B
	DB	00000000B

	DB	11000000B	; 
	DB	00100000B
	DB	00100000B
	DB	01110000B
	DB	11110000B
	DB	11110000B
	DB	00000000B
	DB	00000000B

	DB	00000000B	; 34
	DB	00000000B
	DB	00000000B
	DB	00000000B
	DB	00000000B
	DB	00000001B
	DB	00000000B
	DB	00000000B

	DB	00000000B	; 
	DB	00000001B
	DB	00000111B
	DB	00000011B
	DB	00000000B
	DB	00000001B
	DB	00000001B
	DB	00000001B

	DB	00000000B	; 
	DB	00000000B
	DB	00000000B
	DB	00111000B
	DB	11101000B
	DB	11101000B
	DB	11111000B
	DB	11110000B

	DB	00000000B	; 
	DB	11000000B
	DB	11000000B
	DB	10000000B
	DB	00000000B
	DB	00000000B
	DB	11000000B
	DB	11100000B

	DB	00110111B	; 38
	DB	01101111B
	DB	11101111B
	DB	01001111B
	DB	00000111B
	DB	00000110B
	DB	00000011B
	DB	00000000B

	DB	00000011B	; 
	DB	00001110B
	DB	00011110B
	DB	00001111B
	DB	00000111B
	DB	00000001B
	DB	00000000B
	DB	00000000B

	DB	11110000B	; 
	DB	11111000B
	DB	11111100B
	DB	11000100B
	DB	00010000B
	DB	00010000B
	DB	00000000B
	DB	00000000B

	DB	11000000B	; 
	DB	00100000B
	DB	00100000B
	DB	00010000B
	DB	11110000B
	DB	11110000B
	DB	00000000B
	DB	00000000B

	DB	00000000B	; 3C
	DB	00000000B
	DB	00000000B
	DB	00000000B
	DB	00000000B
	DB	00000001B
	DB	00000000B
	DB	00000001B

	DB	00000000B	; 
	DB	00000001B
	DB	00000001B
	DB	00000000B
	DB	00000000B
	DB	00011110B
	DB	00001110B
	DB	00000000B

	DB	00000000B	; 
	DB	00000000B
	DB	00000000B
	DB	00111000B
	DB	11101000B
	DB	11101000B
	DB	11111000B
	DB	11110000B

	DB	00000000B	; 
	DB	11000000B
	DB	11000000B
	DB	11100000B
	DB	00000000B
	DB	00000000B
	DB	11100000B
	DB	01110000B

	DB	01100111B	; 40
	DB	11010011B
	DB	11001111B
	DB	11001111B
	DB	00001110B
	DB	00001100B
	DB	00000110B
	DB	00000010B

	DB	00000011B	; 
	DB	00000111B
	DB	00001111B
	DB	00011111B
	DB	00111111B
	DB	00001000B
	DB	00000000B
	DB	00000000B

	DB	11100000B	; 
	DB	11110000B
	DB	11111000B
	DB	10001000B
	DB	00100000B
	DB	00100000B
	DB	00000000B
	DB	00000000B

	DB	10000000B	; 
	DB	00000000B
	DB	00000000B
	DB	11000000B
	DB	11000000B
	DB	11000000B
	DB	00000000B
	DB	00000000B

	DB	00001000B	; 44
	DB	00001100B
	DB	00110000B
	DB	00010000B
	DB	00000001B
	DB	00000011B
	DB	00000001B
	DB	00000001B

	DB	00000000B	; 
	DB	00000000B
	DB	00000000B
	DB	00000000B
	DB	00000000B
	DB	00000111B
	DB	00000111B
	DB	00000111B

	DB	00000000B	; 
	DB	00000000B
	DB	00000000B
	DB	01110000B
	DB	11010000B
	DB	11010000B
	DB	11110000B
	DB	11100000B

	DB	00011100B	; 
	DB	11111100B
	DB	11111000B
	DB	00000000B
	DB	00000000B
	DB	00000000B
	DB	00000000B
	DB	10000000B

	DB	00000001B	; 48
	DB	00000011B
	DB	00000111B
	DB	00000110B
	DB	00000001B
	DB	00000001B
	DB	00000000B
	DB	00000000B

	DB	00000000B	; 
	DB	00000000B
	DB	00000000B
	DB	00000010B
	DB	00000011B
	DB	00000011B
	DB	00000000B
	DB	00000000B

	DB	11111100B	; 
	DB	11111110B
	DB	11111110B
	DB	00011110B
	DB	00000110B
	DB	00001100B
	DB	00000000B
	DB	01110000B

	DB	10010000B	; 
	DB	00011000B
	DB	00011000B
	DB	00111000B
	DB	11111000B
	DB	11110000B
	DB	00000000B
	DB	00000000B

	DB	00000000B	; 4C
	DB	00000000B
	DB	00000000B
	DB	00000001B
	DB	00000010B
	DB	00000010B
	DB	00000001B
	DB	00000000B

	DB	00000011B	; 
	DB	00000111B
	DB	00000011B
	DB	00000001B
	DB	00000000B
	DB	00000000B
	DB	00000000B
	DB	00000001B

	DB	00000000B	; 
	DB	00000000B
	DB	00000000B
	DB	11100000B
	DB	11111000B
	DB	11110000B
	DB	11111000B
	DB	10000000B

	DB	01100000B	; 
	DB	11100000B
	DB	11100000B
	DB	11000000B
	DB	00000000B
	DB	00000000B
	DB	11100000B
	DB	11100000B

	DB	00000111B	; 50
	DB	00001111B
	DB	00011111B
	DB	00011000B
	DB	00000100B
	DB	00000100B
	DB	00000000B
	DB	00000011B

	DB	00000100B	; 
	DB	00000100B
	DB	00001100B
	DB	00000100B
	DB	00001100B
	DB	00001111B
	DB	00000000B
	DB	00000000B

	DB	11110000B	; 
	DB	11111000B
	DB	11111000B
	DB	01111000B
	DB	00011000B
	DB	00110000B
	DB	00000000B
	DB	11000000B

	DB	01000000B	; 
	DB	01100000B
	DB	01100000B
	DB	01100000B
	DB	11100000B
	DB	11000000B
	DB	00000000B
	DB	00000000B

	DB	00000000B	; 54
	DB	00000000B
	DB	00000000B
	DB	00000111B
	DB	00001011B
	DB	00001011B
	DB	00000111B
	DB	00000000B

	DB	00000011B	; 
	DB	00001011B
	DB	00000011B
	DB	00001011B
	DB	00000011B
	DB	00000000B
	DB	00000011B
	DB	00000111B

	DB	00000000B	; 
	DB	00000000B
	DB	00000000B
	DB	10000000B
	DB	11100000B
	DB	11000000B
	DB	11100000B
	DB	00000000B

	DB	10000000B	; 
	DB	10000000B
	DB	10000000B
	DB	10000000B
	DB	00000000B
	DB	00000000B
	DB	10000000B
	DB	10000000B

	DB	00000111B	; 58
	DB	00001111B
	DB	00011111B
	DB	00011000B
	DB	00000100B
	DB	00000100B
	DB	00000000B
	DB	00000011B

	DB	00000110B	; 
	DB	00000110B
	DB	00000100B
	DB	00001100B
	DB	00001111B
	DB	00000110B
	DB	00000000B
	DB	00000000B

	DB	11110000B	; 
	DB	11111000B
	DB	11111000B
	DB	01111000B
	DB	00011000B
	DB	00110000B
	DB	00000000B
	DB	11000000B

	DB	01100000B	; 
	DB	00110000B
	DB	00110000B
	DB	01110000B
	DB	11100000B
	DB	11100000B
	DB	00000000B
	DB	00000000B

	DB	00000000B	; 5C
	DB	00000000B
	DB	00000000B
	DB	00000111B
	DB	00001011B
	DB	00001011B
	DB	00000111B
	DB	00000000B

	DB	00000001B	; 
	DB	00000001B
	DB	00000011B
	DB	00000011B
	DB	00000000B
	DB	00001000B
	DB	00001110B
	DB	00011111B

	DB	00000000B	; 
	DB	00000000B
	DB	00000000B
	DB	10000000B
	DB	11100000B
	DB	11000000B
	DB	11100000B
	DB	00000000B

	DB	10000000B	; 
	DB	11000000B
	DB	11000000B
	DB	10000000B
	DB	00000000B
	DB	00000000B
	DB	11000000B
	DB	11000000B

	DB	00001111B	; 60
	DB	00011111B
	DB	00011111B
	DB	00011110B
	DB	00011000B
	DB	00001100B
	DB	00000000B
	DB	00000011B

	DB	00000010B	; 
	DB	00000110B
	DB	00000110B
	DB	00000110B
	DB	00000111B
	DB	00000011B
	DB	00000000B
	DB	00000000B

	DB	11100000B	; 
	DB	11110000B
	DB	11111000B
	DB	00011000B
	DB	00100000B
	DB	00100000B
	DB	00000000B
	DB	11000000B

	DB	00100000B	; 
	DB	00100000B
	DB	00110000B
	DB	00100000B
	DB	00110000B
	DB	11110000B
	DB	00000000B
	DB	00000000B

	DB	00000000B	; 64
	DB	00000000B
	DB	00000000B
	DB	00000001B
	DB	00000111B
	DB	00000011B
	DB	00000111B
	DB	00000000B

	DB	00000001B	; 
	DB	00000001B
	DB	00000001B
	DB	00000001B
	DB	00000000B
	DB	00000000B
	DB	00000001B
	DB	00000001B

	DB	00000000B	; 
	DB	00000000B
	DB	00000000B
	DB	11100000B
	DB	11010000B
	DB	11010000B
	DB	11100000B
	DB	00000000B

	DB	11000000B	; 
	DB	11010000B
	DB	11000000B
	DB	11010000B
	DB	11000000B
	DB	00000000B
	DB	11000000B
	DB	11100000B

	DB	00001111B	; 68
	DB	00011111B
	DB	00011111B
	DB	00011110B
	DB	00011000B
	DB	00001100B
	DB	00000000B
	DB	00000011B

	DB	00000110B	; 
	DB	00001100B
	DB	00001100B
	DB	00001110B
	DB	00000111B
	DB	00000111B
	DB	00000000B
	DB	00000000B

	DB	11100000B	; 
	DB	11110000B
	DB	11111000B
	DB	00011000B
	DB	00100000B
	DB	00100000B
	DB	00000000B
	DB	11000000B

	DB	01100000B	; 
	DB	01100000B
	DB	00100000B
	DB	00110000B
	DB	11110000B
	DB	01100000B
	DB	00000000B
	DB	00000000B

	DB	00000000B	; 6C
	DB	00000000B
	DB	00000000B
	DB	00000001B
	DB	00000111B
	DB	00000011B
	DB	00000111B
	DB	00000000B

	DB	00000001B	; 
	DB	00000011B
	DB	00000011B
	DB	00000001B
	DB	00000000B
	DB	00000000B
	DB	00000011B
	DB	00000011B

	DB	00000000B	; 
	DB	00000000B
	DB	00000000B
	DB	11100000B
	DB	11010000B
	DB	11010000B
	DB	11100000B
	DB	00000000B

	DB	10000000B	; 
	DB	10010000B
	DB	11000000B
	DB	11000000B
	DB	00000000B
	DB	00010000B
	DB	01110000B
	DB	11111000B

	DB	00001111B	; 70
	DB	01111111B
	DB	11011111B
	DB	00011100B
	DB	00011001B
	DB	00000001B
	DB	00001000B
	DB	00000000B

	DB	00000000B	; 
	DB	00000000B
	DB	00000000B
	DB	00000000B
	DB	00000000B
	DB	00000000B
	DB	00000000B
	DB	00000000B

	DB	11100000B	; 
	DB	11111100B
	DB	11110110B
	DB	10011010B
	DB	00101000B
	DB	00100000B
	DB	00000000B
	DB	00000000B

	DB	00000000B	; 
	DB	00000000B
	DB	00000000B
	DB	00000000B
	DB	00000000B
	DB	00000000B
	DB	00000000B
	DB	00000000B

	DB	00000000B	; 74
	DB	00000000B
	DB	00000000B
	DB	00000011B
	DB	00000110B
	DB	01101110B
	DB	01110111B
	DB	00111101B

	DB	00000000B	; 
	DB	00000000B
	DB	00000000B
	DB	00000000B
	DB	00000000B
	DB	00000000B
	DB	00000000B
	DB	00000000B

	DB	00000000B	; 
	DB	00000000B
	DB	00000000B
	DB	01100000B
	DB	11010000B
	DB	11011100B
	DB	11101100B
	DB	10111000B

	DB	00000000B	; 
	DB	00000000B
	DB	00000000B
	DB	00000000B
	DB	00000000B
	DB	00000000B
	DB	00000000B
	DB	00000000B

	DB	00000000B	; 78
	DB	00100000B
	DB	01100111B
	DB	00100111B
	DB	00000111B
	DB	00001000B
	DB	00010001B
	DB	00000000B

	DB	00000000B	; 
	DB	00000000B
	DB	00000000B
	DB	00000000B
	DB	00000000B
	DB	00000000B
	DB	00000000B
	DB	00000000B

	DB	00000000B	; 
	DB	00000010B
	DB	11100110B
	DB	11111000B
	DB	11110000B
	DB	01001000B
	DB	00100000B
	DB	00000000B

	DB	00000000B	; 
	DB	00000000B
	DB	00000000B
	DB	00000000B
	DB	00000000B
	DB	00000000B
	DB	00000000B
	DB	00000000B

	DB	00000000B	; 7C
	DB	00000000B
	DB	00000000B
	DB	00011000B
	DB	00111000B
	DB	00110111B
	DB	00101110B
	DB	00010111B

	DB	00000000B	; 
	DB	00000000B
	DB	00000000B
	DB	00000000B
	DB	00000000B
	DB	00000000B
	DB	00000000B
	DB	00000000B

	DB	00000000B	; 
	DB	00000000B
	DB	00000000B
	DB	00000100B
	DB	00001110B
	DB	10110110B
	DB	11011010B
	DB	11110100B

	DB	00000000B	; 
	DB	00000000B
	DB	00000000B
	DB	00000000B
	DB	00000000B
	DB	00000000B
	DB	00000000B
	DB	00000000B

	DB	00110000B	; 80
	DB	01101111B
	DB	01011111B
	DB	01011111B
	DB	00011111B
	DB	00011111B
	DB	00000101B
	DB	00000000B

	DB	00000001B	; 
	DB	00000010B
	DB	00000111B
	DB	00001110B
	DB	00011111B
	DB	00000000B
	DB	00000000B
	DB	00000000B

	DB	00001110B	; 
	DB	11110111B
	DB	11111011B
	DB	11111011B
	DB	11111000B
	DB	11111000B
	DB	11010000B
	DB	00000000B

	DB	10000000B	; 
	DB	11000000B
	DB	11100000B
	DB	11110000B
	DB	11111000B
	DB	00000000B
	DB	00000000B
	DB	00000000B

	DB	00000000B	; 84
	DB	00000000B
	DB	00000000B
	DB	00000000B
	DB	00000000B
	DB	00000000B
	DB	00001010B
	DB	00011111B

	DB	00111000B	; 
	DB	00111100B
	DB	00111000B
	DB	00000000B
	DB	00000000B
	DB	00001110B
	DB	00001110B
	DB	00001111B

	DB	00000000B	; 
	DB	00000000B
	DB	00000000B
	DB	00000000B
	DB	00000000B
	DB	00000000B
	DB	00100000B
	DB	11110000B

	DB	00111000B	; 
	DB	00011100B
	DB	00011000B
	DB	00000000B
	DB	00000000B
	DB	01110000B
	DB	01110000B
	DB	11110000B

	DB	01110000B	; 88
	DB	11101111B
	DB	11011111B
	DB	11011111B
	DB	00011111B
	DB	00011111B
	DB	00001011B
	DB	00000000B

	DB	00000001B	; 
	DB	00000011B
	DB	00000111B
	DB	00001111B
	DB	00011111B
	DB	00000000B
	DB	00000000B
	DB	00000000B

	DB	00001100B	; 
	DB	11110110B
	DB	11111010B
	DB	11111010B
	DB	11111000B
	DB	11111000B
	DB	10100000B
	DB	00000000B

	DB	10000000B	; 
	DB	01000000B
	DB	11100000B
	DB	01110000B
	DB	11111000B
	DB	00000000B
	DB	00000000B
	DB	00000000B

	DB	00000000B	; 8C
	DB	00000000B
	DB	00000000B
	DB	00000000B
	DB	00000000B
	DB	00000000B
	DB	00000100B
	DB	00001111B

	DB	00011100B	; 
	DB	00111000B
	DB	00011000B
	DB	00000000B
	DB	00000000B
	DB	00001110B
	DB	00001110B
	DB	00001111B

	DB	00000000B	; 
	DB	00000000B
	DB	00000000B
	DB	00000000B
	DB	00000000B
	DB	00000000B
	DB	01010000B
	DB	11111000B

	DB	00011100B	; 
	DB	00111100B
	DB	00011100B
	DB	00000000B
	DB	00000000B
	DB	01110000B
	DB	01110000B
	DB	11110000B

	DB	00000000B	; 90
	DB	00000000B
	DB	00000000B
	DB	00000000B
	DB	00000000B
	DB	00000000B
	DB	00000000B
	DB	00000000B

	DB	00000000B	; 
	DB	01101100B
	DB	10111110B
	DB	10111110B
	DB	11111110B
	DB	01011100B
	DB	00111000B
	DB	00010000B

	DB	00000000B	; 
	DB	00000000B
	DB	00000000B
	DB	00000000B
	DB	00000000B
	DB	00000000B
	DB	00000000B
	DB	00000000B

	DB	00000000B	; 
	DB	00000000B
	DB	00000000B
	DB	00000000B
	DB	00000000B
	DB	00000000B
	DB	00000000B
	DB	00000000B

	DB	00000000B	; 94
	DB	00000000B
	DB	00000000B
	DB	00000000B
	DB	00000000B
	DB	00000000B
	DB	00000000B
	DB	00000000B

	DB	00000000B	; 
	DB	01101100B
	DB	10111110B
	DB	10111110B
	DB	11111110B
	DB	01011100B
	DB	00111000B
	DB	00010000B

	DB	00000000B	; 
	DB	00000000B
	DB	00000000B
	DB	00000000B
	DB	00000000B
	DB	00000000B
	DB	00000000B
	DB	00000000B

	DB	00000000B	; 
	DB	00000000B
	DB	00000000B
	DB	00000000B
	DB	00000000B
	DB	00000000B
	DB	00000000B
	DB	00000000B

	DB	00000000B	; 98
	DB	00000000B
	DB	00000000B
	DB	00000000B
	DB	00000000B
	DB	00000000B
	DB	00000000B
	DB	01110111B

	DB	11111111B	; 
	DB	10111111B
	DB	10111111B
	DB	11111111B
	DB	01011111B
	DB	00111110B
	DB	00011100B
	DB	00001000B

	DB	00000000B	; 
	DB	00000000B
	DB	00000000B
	DB	00000000B
	DB	00000000B
	DB	00000000B
	DB	00000000B
	DB	00000000B

	DB	10000000B	; 
	DB	10000000B
	DB	10000000B
	DB	10000000B
	DB	00000000B
	DB	00000000B
	DB	00000000B
	DB	00000000B

	DB	00000000B	; 9C
	DB	00000000B
	DB	00000000B
	DB	00000000B
	DB	00000000B
	DB	01110001B
	DB	11111011B
	DB	10111111B

	DB	10111111B	; 
	DB	10111111B
	DB	11111111B
	DB	01011111B
	DB	00101111B
	DB	00011111B
	DB	00001110B
	DB	00000100B

	DB	00000000B	; 
	DB	00000000B
	DB	00000000B
	DB	00000000B
	DB	00000000B
	DB	11000000B
	DB	11100000B
	DB	11100000B

	DB	11100000B	; 
	DB	11100000B
	DB	11100000B
	DB	11000000B
	DB	10000000B
	DB	00000000B
	DB	00000000B
	DB	00000000B

	DB	00000000B	; A0
	DB	00000000B
	DB	00000000B
	DB	00111000B
	DB	01111101B
	DB	11011111B
	DB	11011111B
	DB	11011111B

	DB	11011111B	; 
	DB	11111111B
	DB	01101111B
	DB	00110111B
	DB	00011111B
	DB	00001111B
	DB	00000111B
	DB	00000010B

	DB	00000000B	; 
	DB	00000000B
	DB	00000000B
	DB	11100000B
	DB	11110000B
	DB	11111000B
	DB	11111000B
	DB	11111000B

	DB	11111000B	; 
	DB	11111000B
	DB	11110000B
	DB	11100000B
	DB	11000000B
	DB	10000000B
	DB	00000000B
	DB	00000000B

	DB	00000000B	; A4
	DB	00111000B
	DB	01111110B
	DB	11011111B
	DB	11011111B
	DB	11011111B
	DB	11011111B
	DB	11011111B

	DB	01111111B	; 
	DB	01101111B
	DB	00110111B
	DB	00011111B
	DB	00001111B
	DB	00000111B
	DB	00000011B
	DB	00000001B

	DB	00000000B	; 
	DB	00111000B
	DB	11111100B
	DB	11111110B
	DB	11111110B
	DB	11111110B
	DB	11111110B
	DB	11111110B

	DB	11111100B	; 
	DB	11111100B
	DB	11111000B
	DB	11110000B
	DB	11100000B
	DB	11000000B
	DB	10000000B
	DB	00000000B

	DB	00000000B	; A8
	DB	00111000B
	DB	01111100B
	DB	11011110B
	DB	11011100B
	DB	11011000B
	DB	11011100B
	DB	11011111B

	DB	01111110B	; 
	DB	01101100B
	DB	00110110B
	DB	00011111B
	DB	00001110B
	DB	00000100B
	DB	00000010B
	DB	00000001B

	DB	00000000B	; 
	DB	00111000B
	DB	01111100B
	DB	00111110B
	DB	01111110B
	DB	11111110B
	DB	01111110B
	DB	00111110B

	DB	01111100B	; 
	DB	11111100B
	DB	01111000B
	DB	00110000B
	DB	01100000B
	DB	11000000B
	DB	00000000B
	DB	00000000B

	DB	00000000B	; AC
	DB	00111000B
	DB	01111110B
	DB	11011111B
	DB	11011111B
	DB	11011111B
	DB	11011111B
	DB	11011111B

	DB	01111111B	; 
	DB	01101111B
	DB	00110111B
	DB	00011111B
	DB	00001111B
	DB	00000111B
	DB	00000011B
	DB	00000001B

	DB	00000000B	; 
	DB	00000000B
	DB	00000000B
	DB	00000000B
	DB	00000000B
	DB	00000000B
	DB	00000000B
	DB	00000000B

	DB	00000000B	; 
	DB	00000000B
	DB	00000000B
	DB	00000000B
	DB	00000000B
	DB	00000000B
	DB	00000000B
	DB	00000000B

	DB	00000000B	; B0
	DB	00000000B
	DB	00000000B
	DB	00000000B
	DB	00000000B
	DB	00100000B
	DB	01100000B
	DB	11111111B

	DB	01100000B	; 
	DB	00100000B
	DB	00000000B
	DB	00000000B
	DB	00000000B
	DB	00000000B
	DB	00000000B
	DB	00000000B

	DB	00000000B	; 
	DB	00000000B
	DB	00000000B
	DB	00000000B
	DB	00000000B
	DB	00011111B
	DB	00111110B
	DB	11111100B

	DB	00111110B	; 
	DB	00011111B
	DB	00000000B
	DB	00000000B
	DB	00000000B
	DB	00000000B
	DB	00000000B
	DB	00000000B

	DB	00000000B	; B4
	DB	00000000B
	DB	00000000B
	DB	00000000B
	DB	00000000B
	DB	11111000B
	DB	01111100B
	DB	00111111B

	DB	01111100B	; 
	DB	11111000B
	DB	00000000B
	DB	00000000B
	DB	00000000B
	DB	00000000B
	DB	00000000B
	DB	00000000B

	DB	00000000B	; 
	DB	00000000B
	DB	00000000B
	DB	00000000B
	DB	00000000B
	DB	00000100B
	DB	00000110B
	DB	11111111B

	DB	00000110B	; 
	DB	00000100B
	DB	00000000B
	DB	00000000B
	DB	00000000B
	DB	00000000B
	DB	00000000B
	DB	00000000B

	DB	00000000B	; B8
	DB	00000000B
	DB	00000000B
	DB	00000000B
	DB	00000000B
	DB	00000000B
	DB	00000000B
	DB	00000000B

	DB	00000000B	; 
	DB	00000000B
	DB	00000000B
	DB	00000000B
	DB	00000000B
	DB	00000000B
	DB	00000000B
	DB	00000000B

	DB	00000000B	; 
	DB	00111000B
	DB	11111100B
	DB	11111110B
	DB	11111110B
	DB	11111110B
	DB	11111110B
	DB	11111110B

	DB	11111100B	; 
	DB	11111100B
	DB	11111000B
	DB	11110000B
	DB	11100000B
	DB	11000000B
	DB	10000000B
	DB	00000000B

	DB	00011111B	; BC
	DB	00111111B
	DB	01111111B
	DB	01111111B
	DB	00000011B
	DB	00000001B
	DB	00000001B
	DB	00000001B

	DB	00000110B	; 
	DB	00000001B
	DB	00000001B
	DB	00001111B
	DB	00011111B
	DB	00111111B
	DB	00111111B
	DB	00000000B

	DB	10000000B	; 
	DB	11000000B
	DB	11000000B
	DB	11000000B
	DB	11000000B
	DB	11000000B
	DB	11000000B
	DB	10000000B

	DB	00000000B	; 
	DB	00000000B
	DB	00000000B
	DB	00000000B
	DB	10000000B
	DB	11000000B
	DB	11000000B
	DB	00000000B

	DB	00000000B	; C0
	DB	00000000B
	DB	00000000B
	DB	00000000B
	DB	00000000B
	DB	00000000B
	DB	00000110B
	DB	00001001B

	DB	00011100B	; 
	DB	00100111B
	DB	01000100B
	DB	01001000B
	DB	00100001B
	DB	00011100B
	DB	00000111B
	DB	00000000B

	DB	00000000B	; 
	DB	00000000B
	DB	00000000B
	DB	00000000B
	DB	00000000B
	DB	00000000B
	DB	00011110B
	DB	01110001B

	DB	10000110B	; 
	DB	11111100B
	DB	10011010B
	DB	01011011B
	DB	01010101B
	DB	10101011B
	DB	01010110B
	DB	00111101B

	DB	00000000B	; C4
	DB	00000000B
	DB	00000000B
	DB	00000000B
	DB	00000000B
	DB	00000000B
	DB	00000000B
	DB	00000110B

	DB	00000011B	; 
	DB	00011000B
	DB	00111011B
	DB	00110111B
	DB	00010110B
	DB	00000011B
	DB	00000000B
	DB	00000000B

	DB	00000000B	; 
	DB	00000000B
	DB	00000000B
	DB	00000000B
	DB	00000000B
	DB	00000000B
	DB	00000000B
	DB	00001110B

	DB	01111000B	; 
	DB	00000000B
	DB	00000000B
	DB	10000000B
	DB	10000000B
	DB	00000000B
	DB	00000000B
	DB	00000000B

	DB	00000000B	; C8
	DB	00000000B
	DB	00000000B
	DB	00000011B
	DB	00000100B
	DB	00000100B
	DB	00000100B
	DB	00000010B

	DB	00011001B	; 
	DB	00100111B
	DB	01000100B
	DB	01001000B
	DB	00100001B
	DB	00011100B
	DB	00000111B
	DB	00000000B

	DB	00000000B	; 
	DB	00000000B
	DB	00000000B
	DB	10110000B
	DB	01001000B
	DB	01001000B
	DB	10001000B
	DB	10001000B

	DB	10010000B	; 
	DB	11111100B
	DB	10011010B
	DB	01011011B
	DB	01010101B
	DB	10101011B
	DB	01010110B
	DB	00111101B

	DB	00000000B	; CC
	DB	00000000B
	DB	00000000B
	DB	00000000B
	DB	00000011B
	DB	00000011B
	DB	00000011B
	DB	00000001B

	DB	00000000B	; 
	DB	00011000B
	DB	00111011B
	DB	00110111B
	DB	00010110B
	DB	00000011B
	DB	00000000B
	DB	00000000B

	DB	00000000B	; 
	DB	00000000B
	DB	00000000B
	DB	00000000B
	DB	00110000B
	DB	10110000B
	DB	01110000B
	DB	01110000B

	DB	01100000B	; 
	DB	00000000B
	DB	00000000B
	DB	10000000B
	DB	10000000B
	DB	00000000B
	DB	00000000B
	DB	00000000B

	DB	00000000B	; D0
	DB	00000000B
	DB	00000000B
	DB	00000000B
	DB	00000000B
	DB	00000000B
	DB	01111000B
	DB	10001110B

	DB	01100001B	; 
	DB	00111111B
	DB	01011001B
	DB	11011010B
	DB	10101010B
	DB	11010101B
	DB	01101010B
	DB	10111100B

	DB	00000000B	; 
	DB	00000000B
	DB	00000000B
	DB	00000000B
	DB	00000000B
	DB	00000000B
	DB	01100000B
	DB	10010000B

	DB	00111000B	; 
	DB	11100100B
	DB	00100010B
	DB	00010010B
	DB	10000100B
	DB	00111000B
	DB	11100000B
	DB	00000000B

	DB	00000000B	; D4
	DB	00000000B
	DB	00000000B
	DB	00000000B
	DB	00000000B
	DB	00000000B
	DB	00000000B
	DB	01110000B

	DB	00011110B	; 
	DB	00000000B
	DB	00000000B
	DB	00000001B
	DB	00000001B
	DB	00000000B
	DB	00000000B
	DB	00000000B

	DB	00000000B	; 
	DB	00000000B
	DB	00000000B
	DB	00000000B
	DB	00000000B
	DB	00000000B
	DB	00000000B
	DB	01100000B

	DB	11000000B	; 
	DB	00011000B
	DB	11011100B
	DB	11101100B
	DB	01101000B
	DB	11000000B
	DB	00000000B
	DB	00000000B

	DB	00000000B	; D8
	DB	00000000B
	DB	00000000B
	DB	00001101B
	DB	00010010B
	DB	00010010B
	DB	00010001B
	DB	00010001B

	DB	00001001B	; 
	DB	00111111B
	DB	01011001B
	DB	11011010B
	DB	10101010B
	DB	11010101B
	DB	01101010B
	DB	10111100B

	DB	00000000B	; 
	DB	00000000B
	DB	00000000B
	DB	11000000B
	DB	00100000B
	DB	00100000B
	DB	00100000B
	DB	01000000B

	DB	10011000B	; 
	DB	11100100B
	DB	00100010B
	DB	00010010B
	DB	10000100B
	DB	00111000B
	DB	11100000B
	DB	00000000B

	DB	00000000B	; DC
	DB	00000000B
	DB	00000000B
	DB	00000000B
	DB	00001100B
	DB	00001101B
	DB	00001110B
	DB	00001110B

	DB	00000110B	; 
	DB	00000000B
	DB	00000000B
	DB	00000001B
	DB	00000001B
	DB	00000000B
	DB	00000000B
	DB	00000000B

	DB	00000000B	; 
	DB	00000000B
	DB	00000000B
	DB	00000000B
	DB	11000000B
	DB	11000000B
	DB	11000000B
	DB	10000000B

	DB	00000000B	; 
	DB	00011000B
	DB	11011100B
	DB	11101100B
	DB	01101000B
	DB	11000000B
	DB	00000000B
	DB	00000000B

	DB	00000000B	; E0
	DB	00000000B
	DB	00000000B
	DB	00000000B
	DB	00000000B
	DB	00011110B
	DB	01111111B
	DB	01111111B

	DB	11111111B	; 
	DB	11111111B
	DB	11111111B
	DB	11111111B
	DB	11111111B
	DB	11111111B
	DB	01111111B
	DB	00011110B

	DB	00000000B	; 
	DB	00000000B
	DB	00000000B
	DB	00000000B
	DB	00000000B
	DB	00000000B
	DB	10000000B
	DB	10111000B

	DB	11011110B	; 
	DB	11011111B
	DB	11110111B
	DB	11111011B
	DB	11111011B
	DB	11111011B
	DB	11110110B
	DB	01101000B

	DB	00011110B	; E4
	DB	01111111B
	DB	01111111B
	DB	11111111B
	DB	11111111B
	DB	11111111B
	DB	11111111B
	DB	11111111B

	DB	11111111B	; 
	DB	01111111B
	DB	00011110B
	DB	00000000B
	DB	00000000B
	DB	00000000B
	DB	00000000B
	DB	00000000B

	DB	00000000B	; 
	DB	10000000B
	DB	10111000B
	DB	11011110B
	DB	11011111B
	DB	11110111B
	DB	11111011B
	DB	11111011B

	DB	11111011B	; 
	DB	11110110B
	DB	01101000B
	DB	00000000B
	DB	00000000B
	DB	00000000B
	DB	00000000B
	DB	00000000B

	DB	00000011B	; E8
	DB	00000100B
	DB	00001000B
	DB	00001001B
	DB	00001111B
	DB	00001001B
	DB	00000100B
	DB	00000011B

	DB	00000000B	; 
	DB	00000000B
	DB	00000000B
	DB	00000000B
	DB	00000000B
	DB	00000000B
	DB	00000000B
	DB	00000000B

	DB	11000000B	; 
	DB	11100000B
	DB	11110000B
	DB	11110000B
	DB	11110000B
	DB	11110000B
	DB	11100000B
	DB	11000000B

	DB	00000000B	; 
	DB	00000000B
	DB	00000000B
	DB	00000000B
	DB	00000000B
	DB	00000000B
	DB	00000000B
	DB	00000000B

	DB	00000000B	; EC
	DB	00000011B
	DB	00000111B
	DB	00000110B
	DB	00000000B
	DB	00000110B
	DB	00000011B
	DB	00000000B

	DB	00000000B	; 
	DB	00000000B
	DB	00000000B
	DB	00000000B
	DB	00000000B
	DB	00000000B
	DB	00000000B
	DB	00000000B

	DB	00000000B	; 
	DB	00000000B
	DB	00000000B
	DB	00000000B
	DB	00000000B
	DB	00000000B
	DB	00000000B
	DB	00000000B

	DB	00000000B	; 
	DB	00000000B
	DB	00000000B
	DB	00000000B
	DB	00000000B
	DB	00000000B
	DB	00000000B
	DB	00000000B

	DB	11111111B	; F0
	DB	11111100B
	DB	11110000B
	DB	11100000B
	DB	11100000B
	DB	11000000B
	DB	11000000B
	DB	11000000B

	DB	11000000B	; 
	DB	11000000B
	DB	11000000B
	DB	11100000B
	DB	11100000B
	DB	11110000B
	DB	11111100B
	DB	11111111B

	DB	11111111B	; 
	DB	00111111B
	DB	00001111B
	DB	00000111B
	DB	00000111B
	DB	00000011B
	DB	00000011B
	DB	00000011B

	DB	00000011B	; 
	DB	00000011B
	DB	00000011B
	DB	00000111B
	DB	00000111B
	DB	00001111B
	DB	00111111B
	DB	11111111B

	DB	11111111B	; F4
	DB	11111111B
	DB	11111111B
	DB	11111111B
	DB	11111110B
	DB	11111000B
	DB	11111000B
	DB	11110000B

	DB	11110000B	; 
	DB	11111000B
	DB	11111000B
	DB	11111110B
	DB	11111111B
	DB	11111111B
	DB	11111111B
	DB	11111111B

	DB	11111111B	; 
	DB	11111111B
	DB	11111111B
	DB	11111111B
	DB	01111111B
	DB	00011111B
	DB	00011111B
	DB	00001111B

	DB	00001111B	; 
	DB	00011111B
	DB	00011111B
	DB	01111111B
	DB	11111111B
	DB	11111111B
	DB	11111111B
	DB	11111111B

	DB	11111111B	; F8
	DB	11111111B
	DB	11111111B
	DB	11111111B
	DB	11111111B
	DB	11111111B
	DB	11111110B
	DB	11111100B

	DB	11111100B	; 
	DB	11111110B
	DB	11111111B
	DB	11111111B
	DB	11111111B
	DB	11111111B
	DB	11111111B
	DB	11111111B

	DB	11111111B	; 
	DB	11111111B
	DB	11111111B
	DB	11111111B
	DB	11111111B
	DB	11111111B
	DB	01111111B
	DB	00111111B

	DB	00111111B	; 
	DB	01111111B
	DB	11111111B
	DB	11111111B
	DB	11111111B
	DB	11111111B
	DB	11111111B
	DB	11111111B

	DB	11111111B	; FC
	DB	11111111B
	DB	11111111B
	DB	11111111B
	DB	11111111B
	DB	11111111B
	DB	11111111B
	DB	11111111B

	DB	11111111B	; 
	DB	11111111B
	DB	11111111B
	DB	11111111B
	DB	11111111B
	DB	11111111B
	DB	11111111B
	DB	11111111B

	DB	11111111B	; 
	DB	11111111B
	DB	11111111B
	DB	11111111B
	DB	11111111B
	DB	11111111B
	DB	11111111B
	DB	11111111B

	DB	11111111B	; FF
	DB	11111111B
	DB	11111111B
	DB	11111111B
	DB	11111111B
	DB	11111111B
	DB	11111111B
	DB	11111111B
N391E	EQU	$-D391E
  ENDIF

; pattern table for second and third banks
D411E
	DB	11111111B	; 00
	DB	11111111B
	DB	11111111B
	DB	11111111B
	DB	11111111B
	DB	11111111B
	DB	11111111B
	DB	11111111B

	DB	00000000B	; 
	DB	01101100B
	DB	11111110B
	DB	11111110B
	DB	11111110B
	DB	01111100B
	DB	00111000B
	DB	00010000B

	DB	11111111B	; 
	DB	11111111B
	DB	11111111B
	DB	11111111B
	DB	11111111B
	DB	11111111B
	DB	11111111B
	DB	11111111B

	DB	11111111B	; 
	DB	11001111B
	DB	01010111B
	DB	10101011B
	DB	01010111B
	DB	10110100B
	DB	11011000B
	DB	10110000B

	DB	11100000B	; 04
	DB	10000000B
	DB	00000000B
	DB	00000000B
	DB	00000000B
	DB	00000000B
	DB	00000000B
	DB	00000000B

	DB	00000000B	; 
	DB	01010101B
	DB	01111111B
	DB	01111111B
	DB	00111110B
	DB	00001000B
	DB	01101011B
	DB	00111110B

	DB	11111111B	; 
	DB	11111111B
	DB	11111111B
	DB	11111111B
	DB	11111111B
	DB	11111111B
	DB	11111111B
	DB	11111111B

	DB	11111111B	; 
	DB	01000010B
	DB	00101100B
	DB	01010110B
	DB	10101011B
	DB	01111000B
	DB	00110000B
	DB	01111110B

	DB	11111111B	; 08
	DB	11111111B
	DB	11111111B
	DB	11111111B
	DB	11111111B
	DB	11111111B
	DB	11111111B
	DB	11111111B

	DB	11111111B	; 
	DB	11111111B
	DB	11111111B
	DB	11111111B
	DB	11111111B
	DB	11111111B
	DB	11111111B
	DB	11111111B

	DB	11111111B	; 
	DB	00011100B
	DB	00111110B
	DB	00111111B
	DB	00011101B
	DB	00000001B
	DB	00000001B
	DB	00000001B

	DB	11111111B	; 
	DB	01110000B
	DB	11111000B
	DB	11111000B
	DB	01110000B
	DB	11111111B
	DB	11111111B
	DB	11111111B

	DB	11111111B	; 0C
	DB	11111111B
	DB	11111111B
	DB	11111111B
	DB	11111111B
	DB	11111110B
	DB	11111100B
	DB	00000001B

	DB	11111111B	; 
	DB	11111111B
	DB	11111111B
	DB	11111111B
	DB	11111111B
	DB	11111111B
	DB	01111111B
	DB	11111111B

	DB	00000001B	; 
	DB	00000001B
	DB	00000001B
	DB	00011001B
	DB	00111101B
	DB	01111111B
	DB	01100001B
	DB	00000001B

	DB	11111111B	; 
	DB	11111111B
	DB	11111111B
	DB	00110000B
	DB	01111000B
	DB	11111100B
	DB	00001100B
	DB	11111111B

	DB	11111111B	; 10
	DB	11111111B
	DB	11111110B
	DB	11111100B
	DB	11111000B
	DB	11111000B
	DB	11111100B
	DB	11111110B

	DB	11111111B	; 
	DB	11111111B
	DB	11111111B
	DB	01111111B
	DB	00111111B
	DB	00111111B
	DB	01111111B
	DB	11111111B

	DB	00000001B	; 
	DB	00000001B
	DB	00000001B
	DB	00011001B
	DB	00111101B
	DB	00100111B
	DB	00000011B
	DB	00000001B

	DB	11111111B	; 
	DB	11111111B
	DB	11111111B
	DB	00111100B
	DB	01111110B
	DB	01100010B
	DB	01000000B
	DB	11000000B

	DB	11111110B	; 14
	DB	11111100B
	DB	11100100B
	DB	11000011B
	DB	10000100B
	DB	10001000B
	DB	10111000B
	DB	11111000B

	DB	11111111B	; 
	DB	01111111B
	DB	01001111B
	DB	10000111B
	DB	01000011B
	DB	00100011B
	DB	00111011B
	DB	00111111B

	DB	11111100B	; 
	DB	11111110B
	DB	00111001B
	DB	01111101B
	DB	01001111B
	DB	00000011B
	DB	00000011B
	DB	00000001B

	DB	01111111B	; 
	DB	00001110B
	DB	00111111B
	DB	01111001B
	DB	11100000B
	DB	11000000B
	DB	10000000B
	DB	11111111B

	DB	11111111B	; 18
	DB	11111111B
	DB	11111111B
	DB	11111111B
	DB	11111111B
	DB	11111111B
	DB	00000001B
	DB	00000001B

	DB	11111111B	; 
	DB	11111111B
	DB	11111111B
	DB	11111111B
	DB	11111111B
	DB	00011111B
	DB	10001111B
	DB	10000111B

	DB	00000001B	; 
	DB	00000001B
	DB	00000001B
	DB	00000001B
	DB	00000001B
	DB	00001101B
	DB	00011111B
	DB	01110001B

	DB	11010011B	; 
	DB	11010101B
	DB	11110101B
	DB	11111011B
	DB	01111000B
	DB	11101100B
	DB	10000110B
	DB	00000011B

	DB	11111111B	; 1C
	DB	11111111B
	DB	11111111B
	DB	11111111B
	DB	11111111B
	DB	11111111B
	DB	11111111B
	DB	11111111B

	DB	11111111B	; 
	DB	11111111B
	DB	11111111B
	DB	11111111B
	DB	11111111B
	DB	11111111B
	DB	11111111B
	DB	11111111B

	DB	11111111B	; 
	DB	11111111B
	DB	00000011B
	DB	00000110B
	DB	00000100B
	DB	01101110B
	DB	11111111B
	DB	11011100B

	DB	11111111B	; 
	DB	11111111B
	DB	00111111B
	DB	00001111B
	DB	10000011B
	DB	11010001B
	DB	11100000B
	DB	11111000B

	DB	00000000B	; 20
	DB	01010101B
	DB	01111111B
	DB	01111111B
	DB	00111110B
	DB	00001000B
	DB	01101011B
	DB	00111110B

	DB	00000000B	; 
	DB	01010101B
	DB	01111111B
	DB	01111111B
	DB	00111110B
	DB	00001000B
	DB	01101011B
	DB	00111110B

	DB	00000000B	; 
	DB	01010101B
	DB	01111111B
	DB	01111111B
	DB	00111110B
	DB	00001000B
	DB	01101011B
	DB	00111110B

	DB	00000000B	; 
	DB	01010101B
	DB	01111111B
	DB	01111111B
	DB	00111110B
	DB	00001000B
	DB	01101011B
	DB	00111110B
D423E	; window without boy
	DB	11111111B	; 24
	DB	10000000B
	DB	10000000B
	DB	10000000B
	DB	10000000B
	DB	10000000B
	DB	10000000B
	DB	10000000B

	DB	11111111B	; 25
	DB	00000001B
	DB	00000001B
	DB	00000001B
	DB	00000001B
	DB	00000001B
	DB	00000001B
	DB	00000001B

	DB	10000000B	; 26
	DB	10000000B
	DB	10000000B
	DB	11101101B
	DB	10010010B
	DB	10010010B
	DB	10010010B
	DB	11111111B

	DB	00000001B	; 27
	DB	00000001B
	DB	00000001B
	DB	10110111B
	DB	01001001B
	DB	01001001B
	DB	01001001B
	DB	11111111B
N423E	EQU	$-D423E
	DB	00000000B	; 28
	DB	00000000B
	DB	00000001B
	DB	00000010B
	DB	00000111B
	DB	00001111B
	DB	00011101B
	DB	00011011B

	DB	00000000B	; 
	DB	00000000B
	DB	11000000B
	DB	11100000B
	DB	01111000B
	DB	00101100B
	DB	10010110B
	DB	01110010B

	DB	00101011B	; 
	DB	01010110B
	DB	01111110B
	DB	11111111B
	DB	11111101B
	DB	01111010B
	DB	11000100B
	DB	01111111B

	DB	00010011B	; 
	DB	01101001B
	DB	10001001B
	DB	00000111B
	DB	10000011B
	DB	01110111B
	DB	01000011B
	DB	11111100B

	DB	00000000B	; 2C
	DB	00000000B
	DB	00000000B
	DB	00001111B
	DB	00011101B
	DB	00100110B
	DB	00110011B
	DB	00111100B

	DB	00000000B	; 
	DB	00000000B
	DB	00000000B
	DB	11110000B
	DB	10111000B
	DB	01100100B
	DB	11001100B
	DB	00111100B

	DB	00101111B	; 
	DB	00100101B
	DB	01010101B
	DB	01010011B
	DB	01111011B
	DB	00110000B
	DB	11111001B
	DB	00000010B

	DB	11110100B	; 
	DB	10011100B
	DB	10010100B
	DB	10111110B
	DB	11110110B
	DB	10001100B
	DB	11001111B
	DB	11100111B

	DB	01111100B	; 30 - "0"
	DB	11101110B
	DB	11101110B
	DB	11101110B
	DB	11101110B
	DB	11101110B
	DB	11101110B
	DB	01111100B

	DB	00011000B	; 31 - "1"
	DB	00011000B
	DB	00011000B
	DB	00011000B
	DB	00011000B
	DB	00111000B
	DB	00111000B
	DB	00111000B

	DB	01111100B	; 32 - "2"
	DB	11101110B
	DB	11101110B
	DB	00001100B
	DB	00111000B
	DB	01100000B
	DB	11111110B
	DB	11111110B

	DB	01111100B	; 33 - "3"
	DB	11101110B
	DB	11101110B
	DB	00011100B
	DB	00001110B
	DB	11101110B
	DB	11101110B
	DB	01111100B

	DB	00011100B	; 34 - "4"
	DB	00111100B
	DB	01101100B
	DB	11101100B
	DB	11101100B
	DB	11111110B
	DB	00001100B
	DB	00001100B

	DB	11111110B	; 35 - "5"
	DB	11111110B
	DB	11000000B
	DB	11111100B
	DB	00001110B
	DB	11101110B
	DB	11111110B
	DB	01111100B

	DB	01111100B	; 36 - "6"
	DB	11101110B
	DB	11100000B
	DB	11111100B
	DB	11101110B
	DB	11101110B
	DB	11101110B
	DB	01111100B

	DB	01111110B	; 37 - "7"
	DB	01111110B
	DB	00000110B
	DB	00001100B
	DB	00011100B
	DB	00011000B
	DB	00111000B
	DB	00111000B

	DB	01111100B	; 38 - "8"
	DB	11101110B
	DB	11101110B
	DB	11111110B
	DB	11101110B
	DB	11101110B
	DB	11101110B
	DB	01111100B

	DB	01111100B	; 39 - "9"
	DB	11101110B
	DB	11101110B
	DB	11101110B
	DB	01111110B
	DB	00001110B
	DB	11101110B
	DB	01111100B

	DB	00000000B	; 3A - sprout (flower needing picked)
	DB	00000000B
	DB	00000000B
	DB	00000000B
	DB	01101100B
	DB	11111110B
	DB	00010000B
	DB	00010000B

	DB	10000000B	; 3B
	DB	10000000B
	DB	10000000B
	DB	10000000B
	DB	11111111B
	DB	11111111B
	DB	11111111B
	DB	11111111B
D42FE
	DB	00000010B	; 3C
	DB	00100010B
	DB	00100010B
	DB	00100100B
	DB	00000100B
	DB	01000000B
	DB	01000000B
	DB	00001000B

	DB	00000001B	; 3D
	DB	00000001B
	DB	00000001B
	DB	00000001B
	DB	11111111B
	DB	11111111B
	DB	11111111B
	DB	11111111B

	DB	11111111B	; 3E
	DB	11111111B
	DB	11111111B
	DB	11111111B
	DB	10000000B
	DB	10000000B
	DB	10000000B
	DB	10000000B

	DB	11111111B	; 3F
	DB	00100000B
	DB	00101000B
	DB	01000000B
	DB	00000001B
	DB	00000001B
	DB	00000001B
	DB	00000001B

	DB	11111100B	; 40
	DB	11110000B
	DB	11100000B
	DB	11000000B
	DB	10000000B
	DB	10000000B
	DB	11111111B
	DB	11111111B

	DB	11000000B	; 
	DB	11111111B
	DB	11111111B
	DB	11111111B
	DB	11111111B
	DB	11111111B
	DB	11111111B
	DB	11111111B

	DB	00111111B	; 
	DB	00001111B
	DB	00000111B
	DB	00000011B
	DB	00000001B
	DB	00000001B
	DB	11111111B
	DB	11111111B

	DB	11111111B	; 
	DB	11111111B
	DB	11111111B
	DB	11111111B
	DB	11111111B
	DB	11000000B
	DB	11110000B
	DB	11111110B

	DB	11111111B	; 44
	DB	00110000B
	DB	11111111B
	DB	00001100B
	DB	11111111B
	DB	11111111B
	DB	01100010B
	DB	11111111B

	DB	11111111B	; 
	DB	11111111B
	DB	10000000B
	DB	10000000B
	DB	11000000B
	DB	11100000B
	DB	11110000B
	DB	11111100B

	DB	11111111B	; 
	DB	00000001B
	DB	00000001B
	DB	00000011B
	DB	00000111B
	DB	00001111B
	DB	00111111B
	DB	11111111B

	DB	11111111B	; 
	DB	00000001B
	DB	00000001B
	DB	00000011B
	DB	00000111B
	DB	00001111B
	DB	00111111B
	DB	00000011B

	DB	11111111B	; 48
	DB	11111100B
	DB	11100000B
	DB	10000000B
	DB	11111111B
	DB	11111111B
	DB	11111111B
	DB	11111111B

	DB	11111111B	; 
	DB	11111111B
	DB	11111111B
	DB	11111111B
	DB	10000000B
	DB	10000000B
	DB	10000000B
	DB	10000000B

	DB	00000010B	; 
	DB	00100010B
	DB	00100010B
	DB	00100100B
	DB	00000100B
	DB	01000000B
	DB	01000000B
	DB	00001000B

	DB	11000000B	; 
	DB	11000000B
	DB	11000000B
	DB	11000000B
	DB	11100000B
	DB	11100000B
	DB	11100000B
	DB	11100000B

	DB	00000111B	; 4C
	DB	00000111B
	DB	00000011B
	DB	00000011B
	DB	00000001B
	DB	00000001B
	DB	11111111B
	DB	11111111B

	DB	00000111B	; 
	DB	00000111B
	DB	00000111B
	DB	00000111B
	DB	00000011B
	DB	00000011B
	DB	00000011B
	DB	00000011B

	DB	11111111B	; 
	DB	11111111B
	DB	00000001B
	DB	00000001B
	DB	00000011B
	DB	00000011B
	DB	00000111B
	DB	00000111B

	DB	11100000B	; 
	DB	11100000B
	DB	11100000B
	DB	11100000B
	DB	11000000B
	DB	11000000B
	DB	11000000B
	DB	11000000B

	DB	00000000B	; 50
	DB	00000000B
	DB	00000000B
	DB	00000000B
	DB	00000001B
	DB	00000001B
	DB	00000001B
	DB	00000001B

	DB	11100000B	; 
	DB	11100000B
	DB	11000000B
	DB	11000000B
	DB	10000000B
	DB	10000000B
	DB	00000000B
	DB	00000000B

	DB	00000011B	; 
	DB	00000011B
	DB	00000011B
	DB	00000011B
	DB	00000111B
	DB	00000111B
	DB	00000111B
	DB	00000111B

	DB	00000001B	; 
	DB	00000001B
	DB	00000001B
	DB	00000001B
	DB	00000000B
	DB	00000000B
	DB	00000000B
	DB	00000000B

	DB	11111111B	; 54
	DB	11111111B
	DB	11111111B
	DB	11111111B
	DB	11111111B
	DB	11111111B
	DB	11111111B
	DB	11111100B

	DB	11111111B	; 
	DB	11111111B
	DB	11111111B
	DB	11111111B
	DB	11111111B
	DB	11111111B
	DB	11000000B
	DB	00000000B

	DB	11111111B	; 
	DB	11111111B
	DB	11111111B
	DB	11111111B
	DB	11111111B
	DB	11111111B
	DB	00111111B
	DB	00000011B

	DB	01111111B	; 
	DB	00111111B
	DB	00111111B
	DB	00011111B
	DB	00011111B
	DB	00011111B
	DB	00001111B
	DB	00001111B

	DB	00001111B	; 58
	DB	00001111B
	DB	00011111B
	DB	00011111B
	DB	00011111B
	DB	00111111B
	DB	00111111B
	DB	01111111B

	DB	11000000B	; 
	DB	11111111B
	DB	11111111B
	DB	11111111B
	DB	11111111B
	DB	11111111B
	DB	11111111B
	DB	11111111B

	DB	00000000B	; 
	DB	00000000B
	DB	11111100B
	DB	11111110B
	DB	11111111B
	DB	11111111B
	DB	11111111B
	DB	11111111B

	DB	11000000B	; 
	DB	11111100B
	DB	11111111B
	DB	11111111B
	DB	11111111B
	DB	11111111B
	DB	11111111B
	DB	11111111B

	DB	00000000B	; 5C
	DB	00000000B
	DB	11111111B
	DB	11111111B
	DB	11111111B
	DB	11111111B
	DB	11111111B
	DB	11111111B

	DB	00001111B	; 
	DB	11111111B
	DB	11111111B
	DB	11111111B
	DB	11111111B
	DB	11111111B
	DB	11111111B
	DB	11111111B

	DB	11111111B	; 
	DB	11111111B
	DB	11111111B
	DB	11111111B
	DB	11111110B
	DB	11111100B
	DB	00111000B
	DB	00000000B

	DB	01111111B	; 
	DB	01111111B
	DB	00111111B
	DB	00111111B
	DB	00011111B
	DB	00011111B
	DB	00001111B
	DB	00001111B

	DB	11110000B	; 60
	DB	11110000B
	DB	11111000B
	DB	11111000B
	DB	11111100B
	DB	11111100B
	DB	11111110B
	DB	11111110B

	DB	01111111B	; 
	DB	01111111B
	DB	01111111B
	DB	01111111B
	DB	00111111B
	DB	00111111B
	DB	00111111B
	DB	00111111B

	DB	00011111B	; 
	DB	00011111B
	DB	00011111B
	DB	00011111B
	DB	00001111B
	DB	00001111B
	DB	00001111B
	DB	00001111B

	DB	11000000B	; 
	DB	11000000B
	DB	11100000B
	DB	11100000B
	DB	11110000B
	DB	11110000B
	DB	11111000B
	DB	11111000B

	DB	11111100B	; 64
	DB	11111100B
	DB	11111100B
	DB	11111100B
	DB	11111110B
	DB	11111110B
	DB	11111110B
	DB	11111110B

	DB	11110000B	; 
	DB	11110000B
	DB	11110000B
	DB	11110000B
	DB	11111000B
	DB	11111000B
	DB	11111000B
	DB	11111000B

	DB	11111000B	; 
	DB	11111000B
	DB	11111000B
	DB	11111000B
	DB	11111000B
	DB	11111000B
	DB	11111000B
	DB	11111000B

	DB	11111110B	; 
	DB	11111110B
	DB	11111100B
	DB	11111100B
	DB	11111000B
	DB	11111000B
	DB	11110000B
	DB	11110000B

	DB	00001111B	; 68
	DB	00001111B
	DB	00001111B
	DB	00001111B
	DB	00011111B
	DB	00011111B
	DB	00011111B
	DB	00011111B

	DB	00111111B	; 
	DB	00111111B
	DB	00111111B
	DB	00111111B
	DB	01111111B
	DB	01111111B
	DB	01111111B
	DB	01111111B

	DB	11111110B	; 
	DB	11111110B
	DB	11111110B
	DB	11111110B
	DB	11111100B
	DB	11111100B
	DB	11111100B
	DB	11111100B

	DB	11111000B	; 
	DB	11111000B
	DB	11111000B
	DB	11111000B
	DB	11110000B
	DB	11110000B
	DB	11110000B
	DB	11110000B

	DB	00001111B	; 6C
	DB	00001111B
	DB	00001111B
	DB	00001111B
	DB	00001111B
	DB	00001111B
	DB	00001111B
	DB	00001111B

	DB	11111111B	; 
	DB	11111111B
	DB	11111111B
	DB	11111111B
	DB	11111111B
	DB	11111111B
	DB	11111111B
	DB	11111111B

	DB	00000000B	; 
	DB	00000000B
	DB	00000000B
	DB	00000000B
	DB	00000000B
	DB	00011000B
	DB	00111100B
	DB	11111111B

	DB	00000000B	; 
	DB	00000000B
	DB	00000000B
	DB	01111000B
	DB	11111100B
	DB	11111100B
	DB	11111100B
	DB	11111100B

	DB	00000000B	; 70
	DB	00000000B
	DB	00000000B
	DB	00000000B
	DB	00000001B
	DB	00000111B
	DB	00001111B
	DB	00011111B

	DB	11111100B	; 
	DB	11111100B
	DB	11111100B
	DB	00000011B
	DB	00000011B
	DB	11111100B
	DB	00011111B
	DB	01111111B

	DB	00000000B	; 
	DB	00000000B
	DB	11110000B
	DB	11111110B
	DB	01101100B
	DB	01111100B
	DB	00111000B
	DB	00010000B

	DB	00000000B	; 
	DB	00000000B
	DB	00000000B
	DB	00000000B
	DB	10000000B
	DB	11100000B
	DB	11110000B
	DB	11111000B

	DB	11000000B	; 74
	DB	01111111B
	DB	01111111B
	DB	11111110B
	DB	11111000B
	DB	11110000B
	DB	01100000B
	DB	11111111B

	DB	11111111B	; 
	DB	11111111B
	DB	10000000B
	DB	10000001B
	DB	00111000B
	DB	01110010B
	DB	01110000B
	DB	10000001B

	DB	11111111B	; 
	DB	11111111B
	DB	00000011B
	DB	10000001B
	DB	00011100B
	DB	01001110B
	DB	00001110B
	DB	10000001B

	DB	00000011B	; 
	DB	11111110B
	DB	11111110B
	DB	01111111B
	DB	00011111B
	DB	00001111B
	DB	00000110B
	DB	11111111B

	DB	00111111B	; 78
	DB	01111111B
	DB	10000000B
	DB	10000000B
	DB	10000000B
	DB	00111111B
	DB	01111111B
	DB	10000000B

	DB	11111100B	; 
	DB	11111110B
	DB	00000001B
	DB	00000001B
	DB	00000001B
	DB	11111100B
	DB	11111110B
	DB	00000001B

	DB	10000000B	; 
	DB	10000000B
	DB	00111111B
	DB	01111111B
	DB	10000000B
	DB	10000000B
	DB	10000000B
	DB	00111111B

	DB	00000001B	; 
	DB	00000001B
	DB	11111100B
	DB	11111110B
	DB	00000001B
	DB	00000001B
	DB	00000001B
	DB	11111100B

	DB	00000011B	; 7C
	DB	00000011B
	DB	00000011B
	DB	00000011B
	DB	00000011B
	DB	00000011B
	DB	00000011B
	DB	00000011B

	DB	11111111B	; 
	DB	11111111B
	DB	11111111B
	DB	11111111B
	DB	11111111B
	DB	11111111B
	DB	00000000B
	DB	00000000B

	DB	11000000B	; 
	DB	11000000B
	DB	11000000B
	DB	11000000B
	DB	11000000B
	DB	11000000B
	DB	11000000B
	DB	11000000B

	DB	00000011B	; 
	DB	00000011B
	DB	00000011B
	DB	00000011B
	DB	00000011B
	DB	00000011B
	DB	00000011B
	DB	00000011B

	DB	11000000B	; 80
	DB	11000000B
	DB	11000000B
	DB	11000000B
	DB	11000000B
	DB	11000000B
	DB	11000000B
	DB	11000000B

	DB	00000011B	; 
	DB	00000011B
	DB	00000011B
	DB	00000011B
	DB	00000011B
	DB	00000011B
	DB	00000011B
	DB	00000011B

	DB	11111111B	; 
	DB	11111111B
	DB	11111111B
	DB	11111111B
	DB	11111111B
	DB	11111111B
	DB	11111111B
	DB	11111111B

	DB	11000000B	; 
	DB	11000000B
	DB	11000000B
	DB	11000000B
	DB	11000000B
	DB	11000000B
	DB	11000000B
	DB	11000000B

	DB	00111111B	; 84 - 87 = "Wellcome"
	DB	10111011B
	DB	10111011B
	DB	10111011B
	DB	10111010B
	DB	10101010B
	DB	10010010B
	DB	10111011B

	DB	11111111B	; 85
	DB	11101011B
	DB	11101011B
	DB	01101011B
	DB	10101010B
	DB	00101010B
	DB	11101010B
	DB	01101011B

	DB	11111111B	; 86
	DB	11111111B
	DB	11111111B
	DB	01110111B
	DB	10101010B
	DB	11101010B
	DB	10101010B
	DB	01110110B

	DB	11111100B	; 87
	DB	11111111B
	DB	11111111B
	DB	01011101B
	DB	10101010B
	DB	10101000B
	DB	10101011B
	DB	10101101B

	DB	00000000B	; 88 - 88-8B = "ROUND"
	DB	01111101B
	DB	01100101B
	DB	01100101B
	DB	01111101B
	DB	01101001B
	DB	01100101B
	DB	00000000B

	DB	00000000B	; 89
	DB	11110110B
	DB	10010110B
	DB	10010110B
	DB	10010110B
	DB	11110111B
	DB	11110011B
	DB	00000000B

	DB	00000000B	; 8A
	DB	01011001B
	DB	01011101B
	DB	01011111B
	DB	01011111B
	DB	11011011B
	DB	10011001B
	DB	00000000B

	DB	00000000B	; 8B
	DB	01111000B
	DB	01100100B
	DB	01100100B
	DB	01100100B
	DB	01111100B
	DB	01111000B
	DB	00000000B

	DB	00000000B	; 8C - 8C-8F = "HONEY"
	DB	01100101B
	DB	01100101B
	DB	01111101B
	DB	01100101B
	DB	01100101B
	DB	01100101B
	DB	00000000B

	DB	00000000B	; 8D
	DB	11110110B
	DB	10010111B
	DB	10010111B
	DB	10010110B
	DB	11110110B
	DB	11110110B
	DB	00000000B

	DB	00000000B	; 8E
	DB	01011111B
	DB	01011000B
	DB	11011110B
	DB	11011000B
	DB	01011111B
	DB	01011111B
	DB	00000000B

	DB	00000000B	; 8F
	DB	01100100B
	DB	01100100B
	DB	01111100B
	DB	00011000B
	DB	00011000B
	DB	00011000B
	DB	00000000B

	DB	11111111B	; 90
	DB	11111111B
	DB	11111111B
	DB	11111111B
	DB	11111111B
	DB	11111111B
	DB	11111111B
	DB	11111111B

	DB	11111110B	; 
	DB	11111100B
	DB	11111100B
	DB	11111000B
	DB	11100100B
	DB	11000111B
	DB	11001111B
	DB	11011111B

	DB	11001111B	; 
	DB	11101111B
	DB	11110011B
	DB	11111000B
	DB	11111111B
	DB	11111111B
	DB	11111111B
	DB	11111111B

	DB	11111111B	; 
	DB	11111111B
	DB	11111111B
	DB	11111111B
	DB	11111111B
	DB	11111111B
	DB	11111111B
	DB	11111111B

	DB	11111111B	; 94
	DB	11111111B
	DB	11111111B
	DB	11111111B
	DB	11111111B
	DB	11110000B
	DB	11100111B
	DB	00001111B

	DB	00000111B	; 
	DB	00000001B
	DB	00000000B
	DB	11000000B
	DB	11000000B
	DB	00000000B
	DB	10000000B
	DB	11000000B

	DB	11000000B	; 
	DB	11000001B
	DB	10000011B
	DB	00011110B
	DB	11001100B
	DB	11100000B
	DB	11100000B
	DB	11110000B

	DB	11110000B	;
	DB	11110000B
	DB	11111000B
	DB	11111000B
	DB	11111100B
	DB	11111100B
	DB	11111000B
	DB	11110000B

	DB	11111111B	; 98
	DB	11111111B
	DB	11111111B
	DB	11111111B
	DB	11111111B
	DB	01111111B
	DB	00111111B
	DB	10111111B

	DB	10111111B	; 
	DB	00111111B
	DB	01111111B
	DB	00110001B
	DB	00000000B
	DB	00000000B
	DB	01000000B
	DB	01000000B

	DB	10000000B	; 
	DB	10000000B
	DB	00000000B
	DB	00000000B
	DB	00000000B
	DB	00000000B
	DB	00000000B
	DB	00000000B

	DB	00000000B	; 
	DB	00000100B
	DB	00001110B
	DB	00001110B
	DB	00011100B
	DB	00011100B
	DB	00011000B
	DB	00110000B

	DB	11111111B	; 9C
	DB	11111111B
	DB	11111111B
	DB	11111111B
	DB	11111111B
	DB	11111111B
	DB	11111111B
	DB	11111111B

	DB	11111111B	; 
	DB	11111111B
	DB	11111111B
	DB	11111111B
	DB	01111111B
	DB	00011111B
	DB	00001111B
	DB	00001111B

	DB	00000011B	; 
	DB	00000001B
	DB	00000001B
	DB	00000001B
	DB	00000011B
	DB	00000111B
	DB	00000111B
	DB	00000111B

	DB	00000111B	; 
	DB	00000111B
	DB	00001111B
	DB	00001111B
	DB	00001111B
	DB	00011111B
	DB	00011111B
	DB	00111111B

	DB	11111111B	; A0
	DB	11111111B
	DB	00001000B
	DB	00000100B
	DB	01010010B
	DB	10001010B
	DB	10011011B
	DB	11001101B

	DB	11111111B	; 
	DB	11111111B
	DB	01100000B
	DB	01000010B
	DB	01100010B
	DB	11000100B
	DB	11001100B
	DB	11011010B

	DB	00001000B	; 
	DB	00001000B
	DB	00001100B
	DB	01010110B
	DB	10110100B
	DB	01011010B
	DB	01101011B
	DB	11101111B

	DB	11111111B	; 
	DB	01001000B
	DB	00101000B
	DB	10101010B
	DB	01000101B
	DB	01010101B
	DB	10111100B
	DB	11111110B

	DB	11111111B	; A4
	DB	01001010B
	DB	01001010B
	DB	01001001B
	DB	10011001B
	DB	10110111B
	DB	01010101B
	DB	11011111B

	DB	11111111B	; 
	DB	00001000B
	DB	00011000B
	DB	01010100B
	DB	10110010B
	DB	10111010B
	DB	10101011B
	DB	11111101B

	DB	11111111B	; 
	DB	11101110B
	DB	00010001B
	DB	01010010B
	DB	01001010B
	DB	10010101B
	DB	10110111B
	DB	11111011B

	DB	11111111B	; 
	DB	11111111B
	DB	11110111B
	DB	00001000B
	DB	01011010B
	DB	10101110B
	DB	10110101B
	DB	11110111B

	DB	11010101B	; A8
	DB	11111101B
	DB	11111111B
	DB	11111111B
	DB	11111111B
	DB	11111111B
	DB	11111111B
	DB	11111111B

	DB	10111101B	; 
	DB	11111101B
	DB	11111111B
	DB	11111111B
	DB	11111111B
	DB	11111111B
	DB	11111111B
	DB	11111111B

	DB	11111111B	; 
	DB	11111111B
	DB	11111111B
	DB	11111111B
	DB	11111111B
	DB	11111111B
	DB	11111111B
	DB	11111111B

	DB	10010111B	; 
	DB	10111111B
	DB	11111111B
	DB	11111111B
	DB	11111111B
	DB	11111111B
	DB	11111111B
	DB	11111111B

	DB	11110011B	; AC
	DB	11101100B
	DB	11101000B
	DB	11100010B
	DB	11110001B
	DB	11010011B
	DB	11100011B
	DB	11000101B

	DB	11001111B	; 
	DB	00110111B
	DB	00010111B
	DB	01000111B
	DB	10001111B
	DB	01001111B
	DB	11001111B
	DB	10010111B

	DB	11000010B	; 
	DB	11000000B
	DB	11000000B
	DB	11110001B
	DB	11110000B
	DB	11111111B
	DB	11111111B
	DB	11111111B

	DB	00100111B	; 
	DB	00000111B
	DB	10110111B
	DB	11001111B
	DB	11111111B
	DB	11111111B
	DB	11111111B
	DB	11111111B

	DB	11111111B	; B0
	DB	11111111B
	DB	11111111B
	DB	11111111B
	DB	11111111B
	DB	11111100B
	DB	11111000B
	DB	11110000B

	DB	11110000B	; 
	DB	10000011B
	DB	00010011B
	DB	00011100B
	DB	01111110B
	DB	00111111B
	DB	10111111B
	DB	11011111B

	DB	11101110B	; 
	DB	11110000B
	DB	11111111B
	DB	11111110B
	DB	11111100B
	DB	11111000B
	DB	11110000B
	DB	11110000B

	DB	11110000B	; 
	DB	11110000B
	DB	11111000B
	DB	11111111B
	DB	11111111B
	DB	11111111B
	DB	11111111B
	DB	11111111B

	DB	11111111B	; B4
	DB	11111111B
	DB	11111111B
	DB	11000001B
	DB	10011100B
	DB	00111110B
	DB	00011110B
	DB	00000100B

	DB	00000001B	; 
	DB	00000000B
	DB	00000000B
	DB	00000000B
	DB	00000001B
	DB	00000001B
	DB	00000010B
	DB	00000110B

	DB	00001100B	; 
	DB	01111000B
	DB	00000000B
	DB	00000000B
	DB	00000000B
	DB	00000000B
	DB	00000011B
	DB	00011111B

	DB	00111111B	; 
	DB	00111111B
	DB	01111111B
	DB	11111111B
	DB	11111111B
	DB	11111111B
	DB	11111111B
	DB	11111111B

	DB	11111111B	; B8
	DB	11111111B
	DB	11111111B
	DB	11111111B
	DB	11111111B
	DB	11111111B
	DB	11111111B
	DB	11111111B

	DB	11111111B	; 
	DB	11000111B
	DB	00000001B
	DB	00000000B
	DB	00000000B
	DB	00000000B
	DB	00000000B
	DB	00000000B

	DB	00000000B	; 
	DB	00000000B
	DB	00000000B
	DB	00000000B
	DB	00000000B
	DB	00000000B
	DB	11111100B
	DB	11111110B

	DB	11111111B	; 
	DB	11111111B
	DB	11111111B
	DB	11111111B
	DB	11111111B
	DB	11111111B
	DB	11111111B
	DB	11111111B

	DB	11111111B	; BC
	DB	11111111B
	DB	11111111B
	DB	11111111B
	DB	11111111B
	DB	11111111B
	DB	11111111B
	DB	11111111B

	DB	11111111B	; 
	DB	11111111B
	DB	11111111B
	DB	01111111B
	DB	00111111B
	DB	00111111B
	DB	00001111B
	DB	00000111B

	DB	00000111B	; 
	DB	00000111B
	DB	00000011B
	DB	00000001B
	DB	00000001B
	DB	00000001B
	DB	00000001B
	DB	00000001B

	DB	00000001B	; BF
	DB	11110011B
	DB	11111111B
	DB	11111111B
	DB	11111111B
	DB	11111111B
	DB	11111111B
	DB	11111111B

	DB	00000000B	; C0 - C0-C4 = "FLOWER"
	DB	00111110B
	DB	00110000B
	DB	00111100B
	DB	00110000B
	DB	00110000B
	DB	00110000B
	DB	00000000B

	DB	00000000B	; C1
	DB	11000011B
	DB	11000011B
	DB	11000011B
	DB	11000011B
	DB	11111011B
	DB	11111011B
	DB	00000000B

	DB	00000000B	; C2
	DB	11101100B
	DB	00101100B
	DB	00101101B
	DB	00101101B
	DB	11101111B
	DB	11100111B
	DB	00000000B

	DB	00000000B	; C3
	DB	01011111B
	DB	01011000B
	DB	01011110B
	DB	01011000B
	DB	11011111B
	DB	10011111B
	DB	00000000B

	DB	00000000B	; C4
	DB	01111100B
	DB	01100100B
	DB	01100100B
	DB	01111100B
	DB	01101000B
	DB	01100100B
	DB	00000000B

	DB	00000000B	; C5 - C5-C7 = "LOVE"
	DB	01100011B
	DB	01100011B
	DB	01100011B
	DB	01100011B
	DB	01111011B
	DB	01111011B
	DB	00000000B

	DB	00000000B	; C6
	DB	11101100B
	DB	00101100B
	DB	00101100B
	DB	00101100B
	DB	11100111B
	DB	11100111B
	DB	00000000B

	DB	00000000B	; C7
	DB	10111110B
	DB	10110000B
	DB	10111100B
	DB	10110000B
	DB	10111110B
	DB	10111110B
	DB	00000000B
N411E	EQU	$-D411E

; color table for second and third banks
D475E	HEX	AA AA AA AA AA AA AA AA	; 00
	HEX	00 D0 D0 D0 D0 D0 D0 D0
	HEX	00 00 00 00 00 00 00 00
	HEX	AA A9 A9 A9 A9 CA CA CA
	HEX	CA CA CA AA AA AA AA AA
	HEX	00 90 90 90 90 30 30 30
	HEX	AA AA AA AA AA AA AA AA
	HEX	44 4A 4A 4A 4A 74 74 4A
	HEX	AA AA AA AA AA AA AA AA	; C-08
	HEX	AA AA AA AA AA AA AA AA
	HEX	AA CA CA CA CA CA CA CA
	HEX	AA CA CA CA CA AA AA AA
	HEX	AA AA AA AA AA A6 A6 CA
	HEX	AA AA AA AA AA AA A6 AA
	HEX	CA CA CA CA CA CA CA CA
	HEX	AA AA AA CA CA CA CA AA
	HEX	AA AA A6 A6 A6 A6 A6 A6	; C-10
	HEX	AA AA AA A6 A6 A6 A6 AA
	HEX	CA CA CA CA CA CA CA CA
	HEX	AA AA AA CA CA CA CA CA
	HEX	A9 A9 A9 A9 A9 A9 A9 A9
	HEX	AA A9 A9 A9 A9 A9 A9 A9
	HEX	A9 A9 CA CA CA CA CA CA
	HEX	A9 CA CA CA CA CA CA AA
	HEX	AA AA AA AA AA AA CA CA	; C-18
	HEX	AA AA AA AA AA A6 A6 A6
	HEX	CA CA CA CA CA CA CA CA
	HEX	A6 A6 A6 A6 CA CA CA CA
	HEX	AA AA AA AA AA AA AA AA
	HEX	AA AA AA AA AA AA AA AA
	HEX	AA AA CA CA CA CA CC CA
	HEX	AA AA A1 A1 A1 A1 CA CA
	HEX	00 90 90 90 90 30 30 30	; C-20
	HEX	00 90 90 90 90 30 30 30
	HEX	00 90 90 90 90 30 30 30
	HEX	00 90 90 90 90 30 30 30
D487E	; color table for window without boy
	HEX	D7 D7 D7 D7 D7 D7 D7 D7	; C-24
	HEX	D7 D7 D7 D7 D7 D7 D7 D7	; C-25
	HEX	D7 D7 D7 D7 D7 D7 D7 D7	; C-26
	HEX	D7 D7 D7 D7 D7 D7 D7 D7	; C-27
N487E	EQU	$-D487E
	HEX	AA AA 1A 1A 1A 1A 1A 1A	; C-28
	HEX	AA AA 1A 1A 1A 1A 1A 1A
	HEX	1A 1A 1A 11 1A 1A A1 C0
	HEX	1A 1A 1A 1A 1A 1A A1 C0
	HEX	AA AA AA 6A 6A 6A 6A 6A
	HEX	AA AA AA 6A 6A 6A 6A 6A
	HEX	6A 6A 6A 6A 6A C6 C6 6A
	HEX	6A 6A 6A 6A 6A C6 C6 C6
	HEX	F1 F1 F1 F1 F1 F1 F1 F1	; C-30
	HEX	F1 F1 F1 F1 F1 F1 F1 F1
	HEX	F1 F1 F1 F1 F1 F1 F1 F1
	HEX	F1 F1 F1 F1 F1 F1 F1 F1
	HEX	F1 F1 F1 F1 F1 F1 F1 F1
	HEX	F1 F1 F1 F1 F1 F1 F1 F1
	HEX	F1 F1 F1 F1 F1 F1 F1 F1
	HEX	F1 F1 F1 F1 F1 F1 F1 F1
	HEX	F1 F1 F1 F1 F1 F1 F1 F1	; C-38
	HEX	F1 F1 F1 F1 F1 F1 F1 F1
	HEX	00 00 00 00 30 30 30 30
	HEX	A4 A4 A4 A4 44 44 44 44
	HEX	74 74 74 74 74 74 74 74
	HEX	A4 A4 A4 A4 44 44 44 44
	HEX	44 44 44 44 A4 A4 A4 A4
	HEX	44 74 74 74 A4 A4 A4 A4
	HEX	A4 A4 A4 A4 A4 A4 44 44	; C-40
	HEX	A4 44 44 44 44 44 44 44
	HEX	A4 A4 A4 A4 A4 A4 44 44
	HEX	44 44 44 44 44 A4 A4 A4
	HEX	44 74 44 74 44 44 74 44
	HEX	44 44 A4 A4 A4 A4 A4 A4
	HEX	44 A4 A4 A4 A4 A4 A4 AA
	HEX	44 A4 A4 A4 A4 A4 A4 A4
	HEX	A4 A4 A4 A4 44 44 44 44	; C-48
	HEX	44 44 44 44 A4 A4 A4 A4
	HEX	74 74 74 74 74 74 74 74
	HEX	A4 A4 A4 A4 A4 A4 A4 A4
	HEX	A4 A4 A4 A4 A4 A4 44 44
	HEX	A4 A4 A4 A4 A4 A4 A4 A4
	HEX	44 44 A4 A4 A4 A4 A4 A4
	HEX	A4 A4 A4 A4 A4 A4 A4 A4	; C-4F
N475E	EQU	$-D475E
	HEX	44 74 74 74 A4 A4 A4 A4

; color table, second and third banks
D49E6	HEX	FF FF 33 33 FF FF 33 33	; C-6D
	HEX	AA AA AA AA AA 3A 3A 3A	; C-6E
	HEX	AA AA AA 9A 9A 9A 7A EA	; C-6F
	HEX	AA AA AA AA 9A 9A 9A 9A	; C-70
	HEX	5A 7A E9 95 97 E9 95 97
	HEX	AA AA 8A 8A F8 F8 F8 F8
	HEX	AA AA AA AA 8A 8A 8A 8A
	HEX	F9 94 94 93 93 93 93 33
	HEX	99 99 93 31 F1 F1 F1 31
	HEX	88 88 83 31 F1 F1 F1 31
	HEX	F8 84 84 83 83 83 83 33
	HEX	BA CA C3 C3 C3 BA CA C3	; C-78
	HEX	BA CA C3 C3 C3 BA CA C3
	HEX	C3 C3 BA CA C3 C3 C3 BA
	HEX	C3 C3 BA CA C3 C3 C3 BA
	HEX	FA FA FA FA FA FA FA FA
	HEX	FF 44 44 44 44 44 AA AA
	HEX	FA FA FA FA FA FA FA FA
	HEX	FA FA FA 4A 4A 4A 4A 4A
	HEX	FA FA 4A 4A 4A 4A 4A 4A	; C-80
	HEX	FA FA 4A 5A 5A 5A 5A 5A
	HEX	FF FF 44 55 55 55 55 55
	HEX	FA FA 4A 5A 5A 5A 5A 5A
	HEX	C8 81 91 91 91 91 91 81
	HEX	CC 81 91 91 91 91 91 81
	HEX	CC 88 99 91 91 91 91 81
	HEX	C8 88 99 91 91 91 91 81
	HEX	00 F4 F4 F4 F4 F4 F4 00	; C-88
	HEX	00 F4 F4 F4 F4 F4 F4 00
	HEX	00 F4 F4 F4 F4 F4 F4 00
	HEX	00 F4 F4 F4 F4 F4 F4 00
	HEX	00 F4 F4 F4 F4 F4 F4 00
	HEX	00 F4 F4 F4 F4 F4 F4 00
	HEX	00 F4 F4 F4 F4 F4 F4 00
	HEX	00 F4 F4 F4 F4 F4 F4 00
	HEX	77 77 77 77 77 77 77 77	; C-90
	HEX	70 70 70 70 70 70 70 70
	HEX	A0 A0 A0 A0 AA AA AA AA
	HEX	AA AA AA AA AA AA AA AA
	HEX	77 77 77 77 77 70 70 70
	HEX	70 70 00 70 70 00 70 70
	HEX	A0 A0 A0 A0 A0 A0 A0 A0
	HEX	A0 A0 A0 A0 A0 A0 A0 A0
	HEX	77 77 77 77 77 70 70 70	; C-98
	HEX	70 70 70 70 00 00 70 70
	HEX	A0 A0 00 00 00 00 00 00
	HEX	00 A0 A0 A0 A0 A0 A0 A0
	HEX	77 77 77 77 77 77 77 77
	HEX	77 77 77 77 70 70 70 70
	HEX	A0 A0 A0 A0 A0 A0 A0 A0
	HEX	A0 A0 A0 A0 A0 A0 A0 A0
	HEX	AA AA CA CA CA CA CA CA	; C-A0
	HEX	AA AA CA CA CA CA CA CA
	HEX	DA CA CA CA CA CA CA CA
	HEX	AA CA CA CA CA CA CA CA
	HEX	AA DA CA CA CA CA CA CA
	HEX	AA CA CA CA CA CA CA CA
	HEX	AA A9 CA CA CA CA CA CA
	HEX	AA AA A9 CA CA CA CA CA
	HEX	CA CA CC CC CC CC CC CC	; C-A8
	HEX	CA CA CC CC CC CC CC CC
	HEX	CC CC CC CC CC CC CC CC
	HEX	CA CA CC CC CC CC CC CC
	HEX	A1 A1 A1 A1 A1 A1 A1 A1
	HEX	A1 A1 A1 A1 A1 A1 A1 A1
	HEX	A1 A1 A1 A1 A1 AA AA AA
	HEX	A1 A1 A1 A1 AA AA AA AA
	HEX	77 77 77 77 77 70 70 70	; C-B0
	HEX	70 70 70 70 70 70 70 70
	HEX	A0 A0 AA A0 A0 A0 A0 A0
	HEX	A0 A0 A0 AA AA AA AA AA
	HEX	77 77 77 70 70 70 70 70
	HEX	70 00 00 00 70 70 70 70
	HEX	A0 A0 00 00 00 00 A0 A0
	HEX	A0 A0 A0 AA AA AA AA AA
	HEX	77 77 77 77 77 77 77 77	; C-B8
	HEX	77 70 70 00 00 00 00 00
	HEX	00 00 00 00 00 00 A0 A0
	HEX	AA AA AA AA AA AA AA AA
	HEX	77 77 77 77 77 77 77 77
	HEX	77 77 77 70 70 70 70 70
	HEX	A0 A0 A0 A0 A0 A0 A0 A0
	HEX	A0 A0 AA AA AA AA AA AA
	HEX	00 F4 F4 F4 F4 F4 F4 00	; C-C0
	HEX	00 F4 F4 F4 F4 F4 F4 00
	HEX	00 F4 F4 F4 F4 F4 F4 00
	HEX	00 F4 F4 F4 F4 F4 F4 00
	HEX	00 F4 F4 F4 F4 F4 F4 00
	HEX	00 F4 F4 F4 F4 F4 F4 00
	HEX	00 F4 F4 F4 F4 F4 F4 00
	HEX	00 F4 F4 F4 F4 F4 F4 00
D4CBE	HEX	FF FF FF FF FF FF FF FF	; C-C8
N49E6	EQU	$-D49E6
	HEX	FF FF FF FF FF FF FF FF
	HEX	FF 71 FB FF 75 0C 08 18
	HEX	FF C0 E0 E0 C0 FF FF FF
	HEX	FF FF FF FF FF 04 0E 04
	HEX	FF FF FF FF FF FF FF FF
	HEX	04 04 04 44 E9 EB BA 1C
	HEX	FF FF FF C0 E0 E0 20 FF
	HEX	FF FF FF 06 0F 0F 06 02
	HEX	FF FF FF FF FF FF FF FF
	HEX	02 06 46 64 25 37 1E 0C
	HEX	FF FF FF FF F0 38 18 04
	HEX	4C ED 7F 1E 0C 0C 3F 75
	HEX	80 C0 80 FF C0 C0 FF 80
	HEX	ED 4C 03 C3 66 6C 3B 1F
	HEX	C0 80 FF FF 7C FE C6 02
	HEX	FF FF FF FF FF FF FF FE
	HEX	FF FF FF FF FF FF 7F 3F
	HEX	FE FE 03 06 64 EC BB 9F
	HEX	0F 07 93 FF FF F0 FC 0E
	HEX	FF FF FF FF FF FF FF FF
	HEX	FF FF FF FF FF FF FF FF
	HEX	FF FF 03 06 04 6E FF DC
	HEX	FF FF 3F 0F 83 D1 E0 F8
N4CBE	EQU	$-D4CBE
	HEX	FF FF FF FF FF FF FF FF
	HEX	FF FF FF FF FF FF FF FF
	HEX	FF 1C 3E 3F 1D 01 01 01
	HEX	FF 70 F8 F8 70 FF FF FF
	HEX	FF FF FF FF FF FE FC 01
	HEX	FF FF FF FF FF FF 7F FF
	HEX	01 01 01 19 3D 7F 61 01
	HEX	FF FF FF 30 78 FC 0C FF
	HEX	FF 01 01 01 01 01 01 01
	HEX	C0 E0 E7 E7 7F 3F FF 7F
	HEX	01 01 19 3D 3F 07 01 01
	HEX	3F FF FF 38 7C 60 C0 C0
	HEX	FF 01 01 01 01 01 01 01
	HEX	F0 98 99 88 C8 ED 3F 0F
	HEX	71 F9 39 1F 0F 0F 07 03
	HEX	9F DF 3F 1F BF 3C 7E C2
	HEX	FF FF FF FF FF 01 01 01
	HEX	FF FF FF FF FF 80 40 9F
	HEX	01 01 01 01 79 FD DF 83
	HEX	8F C7 27 9F CF FF 7C DF
	HEX	FF FF FF FF FF FF FF FF
	HEX	FF FF FF FF FF FF FF FF
	HEX	FF FF 03 06 04 6E FF DC
	HEX	FF FF 3F 0F 83 D1 E0 F8

	HEX	FF FF FF FF FF FF FF FF
	HEX	FF FF FF FF FF FF FF FF
	HEX	FF FF FF FF 18 0E 07 01
	HEX	FF FF FF FF 20 E0 80 80
	HEX	FF FF FF FF FF FF FF FF
	HEX	FF FF FF FF FF FF FF FF
	HEX	FF 01 FF FF 02 0D 13 01
	HEX	80 C0 80 80 D8 F0 C8 80
	HEX	FF FF FF FF FF 03 07 07
	HEX	FF FF FF FF FF 40 C0 A0
	HEX	03 01 01 01 09 1F 2D 03
	HEX	FF FF FF FF 60 F8 94 A8
	HEX	FF 15 2E 1F 7F BB 6D 5E
	HEX	80 58 B4 E2 7C C6 B8 AE
	HEX	3D 6F 37 0F 0B 5D 2B 05
	HEX	6C DA E4 70 80 76 C9 90
	HEX	FF FF FF FF FF FF FF FF
	HEX	FF FF FF FF FF FF FF FF
	HEX	FF 02 05 06 0D 0A 1E 59
	HEX	40 F0 A8 E8 5C B4 5A EC
	HEX	FF FF FF FF FF FF FF FF
	HEX	FF FF FF FF FF FF FF FF
	HEX	FF FF FF FD F8 E2 15 49
	HEX	FF FF FF 3F 1F C7 E8 16

D4EFE	HEX	AA AA AA AA AA AA AA AA
	HEX	AA AA AA AA AA AA AA AA
	HEX	AA CA CA CC CA CA CA CA
	HEX	AA CA CA CA CA AA AA AA
	HEX	AA AA AA AA AA DA DA DA
	HEX	AA AA AA AA AA AA AA AA
	HEX	CA CA CA CA CA CA CA CA
	HEX	AA AA AA CA CA CA CA AA
	HEX	AA AA AA DA DA DA DA CA
	HEX	AA AA AA AA AA AA AA AA
	HEX	CA CA CA CA CA CA CA CA
	HEX	AA AA AA AA CA CA CA CA
	HEX	DA DA DA DA FD FD DA DA
	HEX	DA DA DA AA DA DA AA DA
	HEX	DA DA CA CA CA CA CA CA
	HEX	DA DA AA AA CA CA CA CA
	HEX	AA AA AA AA AA AA AA A6
	HEX	AA AA AA AA AA AA A6 A6
	HEX	A6 A6 CA CA CA CA CA CA
	HEX	A6 A6 A6 AA AA CA CA CA
	HEX	AA AA AA AA AA AA AA AA
	HEX	AA AA AA AA AA AA AA AA
	HEX	AA AA CA CA CA CA CC CA
	HEX	AA AA A1 A1 A1 A1 CA CA
N4EFE	EQU	$-D4EFE
	HEX	AA AA AA AA AA AA AA AA
	HEX	AA AA AA AA AA AA AA AA
	HEX	AA CA CA CA CA CA CA CA
	HEX	AA CA CA CA CA AA AA AA
	HEX	AA AA AA AA AA A6 A6 CA
	HEX	AA AA AA AA AA AA A6 AA
	HEX	CA CA CA CA CA CA CA CA
	HEX	AA AA AA CA CA CA CA AA
	HEX	AA CA CA CA CA CA CA CA
	HEX	CA CA A6 A6 A6 A6 AA A6
	HEX	CA CA CA CA CA CA CA CA
	HEX	A6 AA AA CA CA CA CA CA
	HEX	AA CA CA CA CA CA CA CA
	HEX	CA CA A9 A9 A9 A9 A9 A9
	HEX	CA CA CA CA CA CA CA CA
	HEX	A9 A9 A9 A9 A9 CA CA CA
	HEX	AA AA AA AA AA CA CA CA
	HEX	AA AA AA AA AA CA CA A6
	HEX	CA CA CA CA CA CA CA CA
	HEX	A6 A6 A6 A6 A6 AA CA CA
	HEX	AA AA AA AA AA AA AA AA
	HEX	AA AA AA AA AA AA AA AA
	HEX	AA AA CA CA CA CA CC CA
	HEX	AA AA A1 A1 A1 A1 CA CA

	HEX	AA AA AA AA AA AA AA AA
	HEX	AA AA AA AA AA AA AA AA
	HEX	AA AA AA AA CA CA CA CA
	HEX	AA AA AA AA CA CA CA CA
	HEX	AA AA AA AA AA AA AA AA
	HEX	AA AA AA AA AA AA AA AA
	HEX	AA FA AA AA CA CA CA CA
	HEX	FA FA FA CA CA CA CA CA
	HEX	AA AA AA AA AA FA FA FA
	HEX	AA AA AA AA AA FA FA FA
	HEX	FA CA CA CA CA CA CA CA
	HEX	AA AA AA AA CA CA CA CA
	HEX	AA FA FA FA FA FA FA FA
	HEX	FA FA FA FA FA FA FA FA
	HEX	FA FA FA FA FA CA CA CA
	HEX	FA FA FA FA FA CA CA CA
	HEX	AA AA AA AA AA AA AA AA
	HEX	AA AA AA AA AA AA AA AA
	HEX	AA EA EA EA EA EA CA CA
	HEX	EA EA EA EA EA EA CA CA
	HEX	AA AA AA AA AA AA AA AA
	HEX	AA AA AA AA AA AA AA AA
	HEX	AA AA AA A1 A1 A1 CA CA
	HEX	AA AA AA A1 A1 A1 CA CA

D513E	HEX	AD D0  A9 90  AF F0

; two rows of grass for bottom of playfield
D5144	HEX	A0 A1 A2 A3 A4 A3 A5 A6 A7 A0 A1 A4 A2 A4 A2 A3
	HEX	A5 A7 A0 A0 A1 A5 A6 A4 A3 A5 A3 A7 A0 A5 A6 A5
	HEX	A8 A9 AA AA AB AA AA AA AA A8 A9 AB AA AB AA AA
	HEX	AA AA A8 A8 A9 AA AA AB AA AA AA AA A8 AA AA AA

D5184	HEX	61 61 61 61 61 61 61 61
	HEX	61 61 61 61 61 61 61 60
	HEX	7B 7C 7D 61 61 61 7E 7F
	HEX	80 81 82 61 61 61 61 61
	HEX	61 61 61 62 63 64 65 66
	HEX	67 68 61 61 61 69 6A 6B
	HEX	77 83 84 85 61 86 87 79
	HEX	88 89 79 8A 8B 8C 8D 85
	HEX	6C 6D 6E 9C 6F 70 71 72
	HEX	9D 9D 73 74 75 76 77 78
	HEX	8E 8F 77 90 91 92 A0 A1
	HEX	9C 93 94 95 96 97 98 99
	HEX	79 9D 9D 9E 9F 9D 9D 9D
	HEX	9F 9D 9F 9D 9D 7A FC FD
	HEX	9A 9B 9F 9D 9D 9F A2 A3
	HEX	9E 9D 9D 9D 9D 9F 9D 9D
	HEX	A5 A5 A5 A5 A5 A5 A5 A5
	HEX	A5 A5 A5 A5 A5 A5 A4 A5
	HEX	BB BC A5 A5 A5 A5 BD BE
	HEX	BF C0 C1 A5 A5 A5 A5 A5
	HEX	A5 A5 A5 A6 A7 A8 A9 AA
	HEX	AB AC A5 A5 A5 AD AE AF
	HEX	C2 C3 C4 A5 A5 C5 C6 C7
	HEX	C8 C9 CA CB CC CD CE A5
	HEX	B0 B1 DC DD B2 B3 B4 DE
	HEX	DF E0 B5 B6 B7 B8 B9 BA
	HEX	CF D0 D1 D2 D3 EB EC ED
	HEX	EE D4 D5 D6 D7 D8 D9 DA
	HEX	E1 E0 E2 E3 E4 E0 E0 E5
	HEX	E6 E5 E6 E0 E7 E8 E9 EA
	HEX	DB EF E6 E0 E5 F0 F1 F2
	HEX	F3 E0 E0 E0 E5 E6 E0 E7

D5284
	DB	00000000B	; 0A - 14, 15 - 1F = small "Girl's Garden" 
	DB	00000000B	;			for challenge stage
	DB	00000000B
	DB	00000000B
	DB	00000000B
	DB	00000000B
	DB	01111100B
	DB	11111110B

	DB	00000000B	; 
	DB	00000000B
	DB	00000000B
	DB	00000000B
	DB	00000000B
	DB	00000000B
	DB	11001111B
	DB	11011111B

	DB	00000000B	; 0C
	DB	00000000B
	DB	00000000B
	DB	00000000B
	DB	00000110B
	DB	00000110B
	DB	00110010B
	DB	10110100B

	DB	00000000B	; 
	DB	00000000B
	DB	00000000B
	DB	00000000B
	DB	00000000B
	DB	00000000B
	DB	01111000B
	DB	11111100B

	DB	00000000B	; 
	DB	00000000B
	DB	00001110B
	DB	00111111B
	DB	01111111B
	DB	01100011B
	DB	11000000B
	DB	11011111B

	DB	00000000B	; 
	DB	00000000B
	DB	00000000B
	DB	00000111B
	DB	10001111B
	DB	10001111B
	DB	00011101B
	DB	00011000B

	DB	00000000B	; 10
	DB	00000000B
	DB	00000111B
	DB	00001111B
	DB	10001110B
	DB	10001100B
	DB	11001100B
	DB	11001110B

	DB	00000000B	; 
	DB	00000000B
	DB	10000000B
	DB	11100001B
	DB	01110011B
	DB	00110011B
	DB	00110011B
	DB	01110011B

	DB	00000000B	; 
	DB	00000000B
	DB	00000000B
	DB	11000000B
	DB	11110001B
	DB	11111001B
	DB	00111001B
	DB	00011101B

	DB	00000000B	; 
	DB	00000000B
	DB	01111000B
	DB	11111101B
	DB	11111101B
	DB	11111001B
	DB	11000001B
	DB	10011001B

	DB	00000000B	; 14
	DB	00000000B
	DB	11000110B
	DB	11001111B
	DB	11101111B
	DB	11100111B
	DB	11100111B
	DB	10110011B

	DB	11100110B	; 
	DB	11000000B
	DB	11011100B
	DB	11011110B
	DB	11100110B
	DB	11111110B
	DB	01111100B
	DB	00000000B

	DB	11011001B	; 
	DB	11011001B
	DB	11011111B
	DB	11011111B
	DB	11011111B
	DB	11011011B
	DB	11011001B
	DB	00000000B

	DB	10110000B	; 
	DB	10110000B
	DB	10110000B
	DB	00110000B
	DB	00111000B
	DB	10111110B
	DB	10011110B
	DB	00000000B

	DB	11001100B	; 18
	DB	11100000B
	DB	01111000B
	DB	00011100B
	DB	11001100B
	DB	11111100B
	DB	01111000B
	DB	00000000B

	DB	11011111B	; 
	DB	11000011B
	DB	11000001B
	DB	01100011B
	DB	01111111B
	DB	00111111B
	DB	00011100B
	DB	00000000B

	DB	10011000B	; 
	DB	10111111B
	DB	10111111B
	DB	10111000B
	DB	10111101B
	DB	00111101B
	DB	00011000B
	DB	00000000B

	DB	11001111B	; 
	DB	11101111B
	DB	11101111B
	DB	11101110B
	DB	11101110B
	DB	11101111B
	DB	11000111B
	DB	00000000B

	DB	11100011B	; 1C
	DB	10000011B
	DB	11110011B
	DB	11111011B
	DB	01111011B
	DB	00110011B
	DB	00000001B
	DB	00000000B

	DB	00011101B	; 
	DB	00011101B
	DB	00011101B
	DB	00111001B
	DB	11111001B
	DB	11110001B
	DB	11000000B
	DB	00000000B

	DB	11111101B	; 
	DB	11111001B
	DB	11000001B
	DB	10011001B
	DB	11111100B
	DB	11111100B
	DB	11111000B
	DB	00000000B

	DB	10111011B	; 1F
	DB	10011011B
	DB	11011111B
	DB	11001111B
	DB	11101111B
	DB	11101111B
	DB	01100110B
	DB	00000000B
D5334
	DB	00000000B	; 20 - BLANK
	DB	00000000B
	DB	00000000B
	DB	00000000B
	DB	00000000B
	DB	00000000B
	DB	00000000B
	DB	00000000B

	DB	00111100B	; 21 - "!"
	DB	01111110B
	DB	01111110B
	DB	00111100B
	DB	00011000B
	DB	00000000B
	DB	00011000B
	DB	00000000B

	DB	00111100B	; 22 - (c)
	DB	01000010B
	DB	10011101B
	DB	10100001B
	DB	10100001B
	DB	10011101B
	DB	01000010B
	DB	00111100B

 if sega
	DB	00111111B	; 23 - 23-26 = "SEGA"
	DB	01111111B
	DB	01100000B
	DB	01111110B
	DB	00111111B
	DB	00000011B
	DB	01111111B
	DB	01111110B

	DB	01111110B	; 24
	DB	01111110B
	DB	01100000B
	DB	01111100B
	DB	01111100B
	DB	01100000B
	DB	01111110B
	DB	01111110B

	DB	01111110B	; 25
	DB	11111110B
	DB	11000000B
	DB	11011110B
	DB	11011110B
	DB	11000110B
	DB	11111110B
	DB	01111110B

	DB	00011000B	; 26
	DB	00111100B
	DB	00111100B
	DB	01111110B
	DB	01100110B
	DB	11100111B
	DB	11011111B
	DB	11011111B

	DB	00000000B	; 27 - 27-2A = "1984"
	DB	00000110B
	DB	00001110B
	DB	00000110B
	DB	00000110B
	DB	00000110B
	DB	00000110B
	DB	00001111B

	DB	00000000B	; 28
	DB	01111000B
	DB	11001101B
	DB	11001101B
	DB	11001100B
	DB	01111101B
	DB	10001101B
	DB	01111000B

	DB	00000000B	; 29
	DB	11110000B
	DB	10011000B
	DB	10011001B
	DB	11110011B
	DB	10011010B
	DB	10011011B
	DB	11110000B

	DB	00000000B	; 2A
	DB	01100000B
	DB	11100000B
	DB	11100000B
	DB	01100000B
	DB	01100000B
	DB	11110000B
	DB	01100000B
 else
	DB	00000111B	; 23 - "J"
	DB	00000111B
	DB	00000111B
	DB	00000111B
	DB	00000111B
	DB	01000111B
	DB	00111110B
	DB	00000000B

	DB	01110001B	; 24 - "K"
	DB	01110010B
	DB	01110100B
	DB	01111000B
	DB	01110100B
	DB	01110010B
	DB	01110001B
	DB	00000000B

	DB	00111110B	; 25 - "Q"
	DB	01110001B
	DB	01110001B
	DB	01110001B
	DB	01110101B
	DB	01110010B
	DB	00111101B
	DB	00000000B

	DB	01100001B	; 26 - "W"
	DB	01100001B
	DB	01100001B
	DB	01101001B
	DB	01111101B
	DB	01110011B
	DB	01100001B
	DB	00000000B

	DB	01110001B	; 27 - "X"
	DB	01110001B
	DB	01111011B
	DB	00111110B
	DB	01111011B
	DB	01110001B
	DB	01110001B
	DB	00000000B

	DB	01110001B	; 28 - "Y"
	DB	01110001B
	DB	01110001B
	DB	00111010B
	DB	00011100B
	DB	00011100B
	DB	00011100B
	DB	00000000B

	DB	01111111B	; 29 - "Z"
	DB	00000111B
	DB	00001110B
	DB	00011100B
	DB	00111000B
	DB	01110000B
	DB	01111111B
	DB	00000000B

	DB	00000000B	; 2A - hax indicator
	DB	00000000B
	DB	00000000B
	DB	00000000B
	DB	00000000B
	DB	00110000B
	DB	00110000B
	DB	00000000B
 endif

	DB	00011100B	; 2B - "A"
	DB	00111010B
	DB	01110001B
	DB	01110001B
	DB	01111111B
	DB	01110001B
	DB	01110001B
	DB	00000000B

	DB	01111110B	; 2C - "B"
	DB	01110001B
	DB	01110001B
	DB	01111110B
	DB	01110001B
	DB	01110001B
	DB	01111110B
	DB	00000000B

	DB	00111110B	; 2D - "C"
	DB	01110001B
	DB	01110000B
	DB	01110000B
	DB	01110000B
	DB	01110001B
	DB	00111110B
	DB	00000000B

	DB	01111100B	; 2E - "D"
	DB	01110010B
	DB	01110001B
	DB	01110001B
	DB	01110001B
	DB	01110010B
	DB	01111100B
	DB	00000000B

	DB	01111111B	; 2F - "E"
	DB	01110000B
	DB	01110000B
	DB	01111110B
	DB	01110000B
	DB	01110000B
	DB	01111111B
	DB	00000000B

	DB	00111110B	; 30 - "0"
	DB	01110001B
	DB	01110011B
	DB	01110101B
	DB	01111001B
	DB	01110001B
	DB	00111110B
	DB	00000000B

	DB	00011110B	; 31 - "1"
	DB	00111110B
	DB	00001110B
	DB	00001110B
	DB	00001110B
	DB	00001110B
	DB	00001110B
	DB	00000000B

	DB	00111110B	; 32 - "2"
	DB	01000111B
	DB	00000111B
	DB	00001110B
	DB	00111000B
	DB	01110000B
	DB	01111111B
	DB	00000000B

	DB	00111110B	; 33 - "3"
	DB	01000111B
	DB	00000111B
	DB	00001110B
	DB	00000111B
	DB	01000111B
	DB	00111110B
	DB	00000000B

	DB	00001110B	; 34 - "4"
	DB	00011110B
	DB	00101110B
	DB	01001110B
	DB	01001110B
	DB	01111111B
	DB	00001110B
	DB	00000000B

	DB	01111111B	; 35 - "5"
	DB	01100000B
	DB	01111110B
	DB	01000111B
	DB	00000111B
	DB	01000111B
	DB	00111110B
	DB	00000000B

	DB	00111110B	; 36 - "6"
	DB	01110001B
	DB	01110000B
	DB	01111110B
	DB	01110001B
	DB	01110001B
	DB	00111110B
	DB	00000000B

	DB	01111111B	; 37 - "7"
	DB	00000011B
	DB	00000011B
	DB	00000111B
	DB	00001110B
	DB	00011100B
	DB	00111000B
	DB	00000000B

	DB	00111110B	; 38 - "8"
	DB	01110001B
	DB	01111001B
	DB	00111110B
	DB	01001111B
	DB	01000111B
	DB	00111110B
	DB	00000000B

	DB	00111110B	; 39 - "9"
	DB	01000111B
	DB	01000111B
	DB	00111111B
	DB	00000111B
	DB	01000111B
	DB	00111110B
	DB	00000000B

	DB	00111110B	; 3A - "G"
	DB	01110001B
	DB	01110000B
	DB	01110111B
	DB	01110001B
	DB	01110001B
	DB	00111110B
	DB	00000000B

	DB	01110001B	; 3B - "H"
	DB	01110001B
	DB	01110001B
	DB	01111111B
	DB	01110001B
	DB	01110001B
	DB	01110001B
	DB	00000000B

	DB	00011100B	; 3C - "I"
	DB	00011100B
	DB	00011100B
	DB	00011100B
	DB	00011100B
	DB	00011100B
	DB	00011100B
	DB	00000000B

	DB	01110000B	; 3D - "L"
	DB	01110000B
	DB	01110000B
	DB	01110000B
	DB	01110000B
	DB	01110000B
	DB	01111110B
	DB	00000000B

	DB	01100001B	; 3E - "M"
	DB	01110011B
	DB	01111101B
	DB	01101001B
	DB	01100001B
	DB	01100001B
	DB	01100001B
	DB	00000000B

	DB	01100001B	; 3F - "N"
	DB	01110001B
	DB	01111001B
	DB	01101101B
	DB	01100111B
	DB	01100011B
	DB	01100001B
	DB	00000000B

	DB	00111110B	; 40 - "O"
	DB	01110001B
	DB	01110001B
	DB	01110001B
	DB	01110001B
	DB	01110001B
	DB	00111110B
	DB	00000000B

	DB	01111110B	; 41 - "P"
	DB	01110001B
	DB	01110001B
	DB	01110001B
	DB	01111110B
	DB	01110000B
	DB	01110000B
	DB	00000000B

	DB	01111110B	; 42 - "R"
	DB	01110001B
	DB	01110001B
	DB	01110001B
	DB	01111110B
	DB	01110010B
	DB	01110001B
	DB	00000000B

	DB	00111110B	; 43 - "S"
	DB	01110001B
	DB	01111000B
	DB	00111110B
	DB	00001111B
	DB	01000111B
	DB	00111110B
	DB	00000000B

	DB	01111111B	; 44 - "T"
	DB	00011100B
	DB	00011100B
	DB	00011100B
	DB	00011100B
	DB	00011100B
	DB	00011100B
	DB	00000000B

	DB	01110001B	; 45 - "U"
	DB	01110001B
	DB	01110001B
	DB	01110001B
	DB	01110001B
	DB	01110011B
	DB	00111110B
	DB	00000000B

	DB	01110001B	; 46 - "V"
	DB	01110001B
	DB	01110001B
	DB	01110001B
	DB	01110001B
	DB	00111010B
	DB	00011100B
	DB	00000000B
N5284	EQU	$-D5284
N5334	EQU	$-D5334
	DB	00000000B	; 47 - "-"
	DB	00000000B
	DB	00000000B
	DB	00111110B
	DB	00111110B
	DB	00000000B
	DB	00000000B
	DB	00000000B

	DB	01111111B	; 48 - "F"
	DB	01110000B
	DB	01110000B
	DB	01111110B
	DB	01110000B
	DB	01110000B
	DB	01110000B
	DB	00000000B

  IF RLE
RLE547C
	HEX	85 FF 00 70 8A FF 06 FE FC F8 F0 FF F1 E0 81 FF
	HEX	01 07 0F 80 FF 02 7F 3E 07 83 FF 03 8F 03 C0 F0
	HEX	84 FF 03 7F 0F FF C0 81 FF 02 F8 E0 80 83 FF 03
	HEX	7F 1F 07 03 84 FF 06 FE F8 F0 03 F0 E0 C0 82 FF
	HEX	07 FC 7E 3E 3F 1F 0F 07 03 82 FF 01 FC 1F 82 FF
	HEX	01 F8 C0 83 FF 00 80 84 FF 03 1F 8F C7 F0 85 FF
	HEX	02 3F 87 F0 85 FF 03 7F 83 F8 F1 85 FF 03 7F 1F
	HEX	07 01 86 FF 01 7F 0F 82 FF 07 FC F0 E0 FF 80 F8
	HEX	E0 80 8C FF 00 01 83 FF 01 0F 7F 86 FF 00 F0 8B
	HEX	FF 01 03 C0 83 FF 02 FC FF 7F 85 FF 00 80 84 FF
	HEX	01 FE F8 84 FF 07 1F F8 FF FE FC F8 F0 C0 80 FF
	HEX	03 80 FF 01 03 81 07 04 0F 7F 1F 0F 07 80 03 03
	HEX	01 FF 1F 0F 82 07 80 0E 05 C0 E0 0F 07 03 01 87
	HEX	FF 00 7F 82 FF 06 FE FC F8 F0 E0 C0 80 83 FF 80
	HEX	80 03 C0 E0 F8 FE 80 FF 82 0F 80 07 08 87 C3 7F
	HEX	3F 1F 0F 07 03 01 82 FF 01 01 0F 80 FF 00 7F 80
	HEX	FF 03 7E FF F8 F0 80 E0 81 FF 02 80 07 03 80 FF
	HEX	03 80 C0 73 1F 82 FF 02 1C 78 E0 82 FF 08 E0 3F
	HEX	1F 0F 07 01 FF 01 1F 81 FF 01 F8 C0 81 FF 01 C0
	HEX	80 84 FF 03 F3 F9 FC FE 85 FF 02 3F 87 F0 85 FF
	HEX	0A 7F FF F8 1F 07 03 01 FF FE F0 01 80 F0 03 F8
	HEX	FE FF 3F 84 FF 07 C0 F8 FF F8 3F 1F 0F 03 80 FF
	HEX	00 03 83 FF 00 1C 81 FF 80 F0 01 E0 80 86 FF 11
	HEX	10 28 54 28 04 80 08 FF 21 FF 08 40 54 AA 54 AA
	HEX	54 28 80 10 07 FF 28 54 AA 54 AA 54 10 80 FF 05
	HEX	02 05 0A 15 2A 15 80 FF 0B 80 40 A0 50 A8 54 2A
	HEX	15 2A 15 0A 05 80 01 05 A8 54 A8 54 A8 50 80 80
	HEX	85 FF 00 FC 88 FF 0C FE F0 E0 C0 80 F0 FF 1F 07
	HEX	03 FF 0F 7F 81 FF 02 F8 E0 7C 84 FF 04 3F 07 FF
	HEX	F0 FC 82 FF 01 FE F8 80 0F 81 FF 01 87 01 86 FF
	HEX	02 7F 3F 0F 80 FF 07 FE FC F0 E0 80 FF 3F 07 80
	HEX	03 00 01 81 FF 00 C0 80 E0 81 F0 01 70 30 81 FF
	HEX	01 FC C0 82 FF 01 F8 80 85 FF 02 7F 03 F8 85 FF
	HEX	02 7F 07 F8 85 FF 01 3F 8F 80 FF 02 7F 1F 07 85
	HEX	FF 06 FE F0 F8 FF FE F8 C0 82 FF 00 80 8D FF 04
	HEX	07 18 0C 07 01 87 FF 02 0F 3F 07 83 FF 02 C0 F0
	HEX	F8 84 FF 01 E1 80 83 FF 06 FC F0 80 F8 E0 C0 80
	HEX	82 FF 03 07 01 1F 3F 81 7F 82 FF 00 7F 80 3F 02
	HEX	1F 0F 01 85 FF 01 FC FE 82 70 80 E0 81 FF 0B 7F
	HEX	3F 1F 0F 07 FE FC F8 F0 E0 C0 80 87 FF 80 F8 01
	HEX	FC FE 86 FF 03 80 E0 F8 FC 82 FF 81 7F 03 3F 07
	HEX	03 01 87 FF 03 7F 3F 1F 07 80 FF 01 07 1F 80 FF
	HEX	80 FE 80 FF 02 E0 F8 80 85 FF 07 7F 3F 0F 07 01
	HEX	07 3E F0 80 FF 03 F0 FE C0 80 84 FF 01 03 01 83
	HEX	FF 00 01 81 FF 08 7F 1F 0F 1F FF FC F8 F0 80 82
	HEX	FF 04 3F 9F CF E3 F8 85 FF 04 7F 07 F0 FF 01 83
	HEX	FF 09 0F 80 FF 7F 3F 1F 0F E3 0F 1F 80 FF 07 80
	HEX	E0 FC 3F 0F FF 03 01 81 FF 02 80 F0 8F 81 FF 03
	HEX	3F 0F 01 3F 81 FF 02 FE F8 C0 81 FF 00 F0 81 FF
	HEX	06 01 02 05 02 F1 F8 FC 80 FF 04 80 40 80 1F 08
	HEX	80 FF 00 02 80 FF 12 04 40 08 80 FF 12 FF 80 04
	HEX	40 08 80 FF 12 FF 80 04 FF 08 80 FF 00 02 80 FF
	HEX	2F 04 45 0A 85 0A 15 02 81 01 40 A2 45 AA 45 8A
	HEX	05 01 FF 88 40 A0 42 A0 40 04 40 02 85 0A 15 0A
	HEX	85 01 FF 88 40 A0 42 A0 40 04 40 FF 80 FF 10 FF
	HEX	80 80 FF 00 FE 82 FF 01 02 08 80 0F 05 07 40 FF
	HEX	12 FF 21 81 FF 03 3F 01 FF 10 84 FF 02 01 02 01
	HEX	80 FF 05 28 54 AA 55 AA 55 82 FF 03 01 02 85 42
	HEX	83 FF 18 80 40 80 03 02 05 0A 05 0A 05 01 02 81
	HEX	42 A1 40 A0 40 FF AA 55 AA 55 AA 55 80 18 05 85
	HEX	4A 85 4A 85 02 80 01 07 40 A8 40 A0 42 80 FF 04
	HEX	82 00 03 16 37 1F 0F 87 00 01 1F 3F 82 00 00 07
	HEX	8B 00 00 01 83 00 00 38 80 E8 06 F8 F0 00 01 07
	HEX	03 00 81 01 00 00 80 C0 00 80 80 00 09 C0 E0 FF
	HEX	1F 00 04 00 01 20 82 80 00 05 80 FC 00 20 01 10
	HEX	FF
  ELSE
D547C
	DB	11111111B	; 60
	DB	11111111B
	DB	11111111B
	DB	11111111B
	DB	11111111B
	DB	11111111B
	DB	11111111B
	DB	01110000B

	DB	11111111B	; 
	DB	11111111B
	DB	11111111B
	DB	11111111B
	DB	11111111B
	DB	11111111B
	DB	11111111B
	DB	11111111B

	DB	11111111B	; 
	DB	11111111B
	DB	11111111B
	DB	11111111B
	DB	11111110B
	DB	11111100B
	DB	11111000B
	DB	11110000B

	DB	11111111B	; 
	DB	11110001B
	DB	11100000B
	DB	11111111B
	DB	11111111B
	DB	11111111B
	DB	00000111B
	DB	00001111B

	DB	11111111B	; 64
	DB	11111111B
	DB	01111111B
	DB	00111110B
	DB	00000111B
	DB	11111111B
	DB	11111111B
	DB	11111111B

	DB	11111111B	; 
	DB	11111111B
	DB	10001111B
	DB	00000011B
	DB	11000000B
	DB	11110000B
	DB	11111111B
	DB	11111111B

	DB	11111111B	; 
	DB	11111111B
	DB	11111111B
	DB	11111111B
	DB	01111111B
	DB	00001111B
	DB	11111111B
	DB	11000000B

	DB	11111111B	; 
	DB	11111111B
	DB	11111111B
	DB	11111000B
	DB	11100000B
	DB	10000000B
	DB	11111111B
	DB	11111111B

	DB	11111111B	; 68
	DB	11111111B
	DB	11111111B
	DB	01111111B
	DB	00011111B
	DB	00000111B
	DB	00000011B
	DB	11111111B

	DB	11111111B	; 
	DB	11111111B
	DB	11111111B
	DB	11111111B
	DB	11111111B
	DB	11111110B
	DB	11111000B
	DB	11110000B

	DB	00000011B	; 
	DB	11110000B
	DB	11100000B
	DB	11000000B
	DB	11111111B
	DB	11111111B
	DB	11111111B
	DB	11111111B

	DB	11111100B	; 
	DB	01111110B
	DB	00111110B
	DB	00111111B
	DB	00011111B
	DB	00001111B
	DB	00000111B
	DB	00000011B

	DB	11111111B	; 6C
	DB	11111111B
	DB	11111111B
	DB	11111111B
	DB	11111100B
	DB	00011111B
	DB	11111111B
	DB	11111111B

	DB	11111111B	; 
	DB	11111111B
	DB	11111000B
	DB	11000000B
	DB	11111111B
	DB	11111111B
	DB	11111111B
	DB	11111111B

	DB	11111111B	; 
	DB	10000000B
	DB	11111111B
	DB	11111111B
	DB	11111111B
	DB	11111111B
	DB	11111111B
	DB	11111111B

	DB	00011111B	; 
	DB	10001111B
	DB	11000111B
	DB	11110000B
	DB	11111111B
	DB	11111111B
	DB	11111111B
	DB	11111111B

	DB	11111111B	; 70
	DB	11111111B
	DB	11111111B
	DB	00111111B
	DB	10000111B
	DB	11110000B
	DB	11111111B
	DB	11111111B

	DB	11111111B	; 
	DB	11111111B
	DB	11111111B
	DB	11111111B
	DB	11111111B
	DB	01111111B
	DB	10000011B
	DB	11111000B

	DB	11110001B	; 
	DB	11111111B
	DB	11111111B
	DB	11111111B
	DB	11111111B
	DB	11111111B
	DB	11111111B
	DB	11111111B

	DB	01111111B	; 
	DB	00011111B
	DB	00000111B
	DB	00000001B
	DB	11111111B
	DB	11111111B
	DB	11111111B
	DB	11111111B

	DB	11111111B	; 74
	DB	11111111B
	DB	11111111B
	DB	11111111B
	DB	01111111B
	DB	00001111B
	DB	11111111B
	DB	11111111B

	DB	11111111B	; 
	DB	11111111B
	DB	11111100B
	DB	11110000B
	DB	11100000B
	DB	11111111B
	DB	10000000B
	DB	11111000B

	DB	11100000B	; 
	DB	10000000B
	DB	11111111B
	DB	11111111B
	DB	11111111B
	DB	11111111B
	DB	11111111B
	DB	11111111B

	DB	11111111B	; 
	DB	11111111B
	DB	11111111B
	DB	11111111B
	DB	11111111B
	DB	11111111B
	DB	11111111B
	DB	11111111B

	DB	00000001B	; 78
	DB	11111111B
	DB	11111111B
	DB	11111111B
	DB	11111111B
	DB	11111111B
	DB	00001111B
	DB	01111111B

	DB	11111111B	; 
	DB	11111111B
	DB	11111111B
	DB	11111111B
	DB	11111111B
	DB	11111111B
	DB	11111111B
	DB	11111111B

	DB	11110000B	; 
	DB	11111111B
	DB	11111111B
	DB	11111111B
	DB	11111111B
	DB	11111111B
	DB	11111111B
	DB	11111111B

	DB	11111111B	; 
	DB	11111111B
	DB	11111111B
	DB	11111111B
	DB	11111111B
	DB	11111111B
	DB	00000011B
	DB	11000000B

	DB	11111111B	; 7C
	DB	11111111B
	DB	11111111B
	DB	11111111B
	DB	11111111B
	DB	11111100B
	DB	11111111B
	DB	01111111B

	DB	11111111B	; 
	DB	11111111B
	DB	11111111B
	DB	11111111B
	DB	11111111B
	DB	11111111B
	DB	11111111B
	DB	10000000B

	DB	11111111B	; 
	DB	11111111B
	DB	11111111B
	DB	11111111B
	DB	11111111B
	DB	11111111B
	DB	11111110B
	DB	11111000B

	DB	11111111B	; 
	DB	11111111B
	DB	11111111B
	DB	11111111B
	DB	11111111B
	DB	11111111B
	DB	00011111B
	DB	11111000B

	DB	11111111B	; 80
	DB	11111110B
	DB	11111100B
	DB	11111000B
	DB	11110000B
	DB	11000000B
	DB	11111111B
	DB	11111111B

	DB	10000000B	; 
	DB	11111111B
	DB	00000001B
	DB	00000011B
	DB	00000111B
	DB	00000111B
	DB	00000111B
	DB	00001111B

	DB	01111111B	; 
	DB	00011111B
	DB	00001111B
	DB	00000111B
	DB	00000011B
	DB	00000011B
	DB	00000001B
	DB	11111111B

	DB	00011111B	; 
	DB	00001111B
	DB	00000111B
	DB	00000111B
	DB	00000111B
	DB	00000111B
	DB	00001110B
	DB	00001110B

	DB	11000000B	; 84
	DB	11100000B
	DB	00001111B
	DB	00000111B
	DB	00000011B
	DB	00000001B
	DB	11111111B
	DB	11111111B

	DB	11111111B	; 
	DB	11111111B
	DB	11111111B
	DB	11111111B
	DB	11111111B
	DB	11111111B
	DB	11111111B
	DB	01111111B

	DB	11111111B	; 
	DB	11111111B
	DB	11111111B
	DB	11111111B
	DB	11111110B
	DB	11111100B
	DB	11111000B
	DB	11110000B

	DB	11100000B	; 
	DB	11000000B
	DB	10000000B
	DB	11111111B
	DB	11111111B
	DB	11111111B
	DB	11111111B
	DB	11111111B

	DB	10000000B	; 88
	DB	10000000B
	DB	11000000B
	DB	11100000B
	DB	11111000B
	DB	11111110B
	DB	11111111B
	DB	11111111B

	DB	00001111B	; 
	DB	00001111B
	DB	00001111B
	DB	00001111B
	DB	00000111B
	DB	00000111B
	DB	10000111B
	DB	11000011B

	DB	01111111B	; 
	DB	00111111B
	DB	00011111B
	DB	00001111B
	DB	00000111B
	DB	00000011B
	DB	00000001B
	DB	11111111B

	DB	11111111B	; 
	DB	11111111B
	DB	11111111B
	DB	00000001B
	DB	00001111B
	DB	11111111B
	DB	11111111B
	DB	01111111B

	DB	11111111B	; 8C
	DB	11111111B
	DB	01111110B
	DB	11111111B
	DB	11111000B
	DB	11110000B
	DB	11100000B
	DB	11100000B

	DB	11111111B	; 
	DB	11111111B
	DB	11111111B
	DB	10000000B
	DB	00000111B
	DB	00000011B
	DB	11111111B
	DB	11111111B

	DB	10000000B	; 
	DB	11000000B
	DB	01110011B
	DB	00011111B
	DB	11111111B
	DB	11111111B
	DB	11111111B
	DB	11111111B

	DB	00011100B	; 
	DB	01111000B
	DB	11100000B
	DB	11111111B
	DB	11111111B
	DB	11111111B
	DB	11111111B
	DB	11100000B

	DB	00111111B	; 90
	DB	00011111B
	DB	00001111B
	DB	00000111B
	DB	00000001B
	DB	11111111B
	DB	00000001B
	DB	00011111B

	DB	11111111B	; 
	DB	11111111B
	DB	11111111B
	DB	11111000B
	DB	11000000B
	DB	11111111B
	DB	11111111B
	DB	11111111B

	DB	11000000B	; 
	DB	10000000B
	DB	11111111B
	DB	11111111B
	DB	11111111B
	DB	11111111B
	DB	11111111B
	DB	11111111B

	DB	11110011B	; 
	DB	11111001B
	DB	11111100B
	DB	11111110B
	DB	11111111B
	DB	11111111B
	DB	11111111B
	DB	11111111B

	DB	11111111B	; 94
	DB	11111111B
	DB	11111111B
	DB	00111111B
	DB	10000111B
	DB	11110000B
	DB	11111111B
	DB	11111111B

	DB	11111111B	; 
	DB	11111111B
	DB	11111111B
	DB	11111111B
	DB	11111111B
	DB	01111111B
	DB	11111111B
	DB	11111000B

	DB	00011111B	; 
	DB	00000111B
	DB	00000011B
	DB	00000001B
	DB	11111111B
	DB	11111110B
	DB	11110000B
	DB	00000001B

	DB	11110000B	; 
	DB	11110000B
	DB	11111000B
	DB	11111110B
	DB	11111111B
	DB	00111111B
	DB	11111111B
	DB	11111111B

	DB	11111111B	; 98
	DB	11111111B
	DB	11111111B
	DB	11111111B
	DB	11000000B
	DB	11111000B
	DB	11111111B
	DB	11111000B

	DB	00111111B	; 
	DB	00011111B
	DB	00001111B
	DB	00000011B
	DB	11111111B
	DB	11111111B
	DB	00000011B
	DB	11111111B

	DB	11111111B	; 
	DB	11111111B
	DB	11111111B
	DB	11111111B
	DB	00011100B
	DB	11111111B
	DB	11111111B
	DB	11111111B

	DB	11110000B	; 
	DB	11110000B
	DB	11100000B
	DB	10000000B
	DB	11111111B
	DB	11111111B
	DB	11111111B
	DB	11111111B

	DB	11111111B	; 9C
	DB	11111111B
	DB	11111111B
	DB	11111111B
	DB	00010000B
	DB	00101000B
	DB	01010100B
	DB	00101000B

	DB	00000100B	; 
	DB	10000000B
	DB	00001000B
	DB	11111111B
	DB	00100001B
	DB	11111111B
	DB	00001000B
	DB	01000000B

	DB	01010100B	; 
	DB	10101010B
	DB	01010100B
	DB	10101010B
	DB	01010100B
	DB	00101000B
	DB	00010000B
	DB	00010000B

	DB	11111111B	; 
	DB	00101000B
	DB	01010100B
	DB	10101010B
	DB	01010100B
	DB	10101010B
	DB	01010100B
	DB	00010000B

	DB	11111111B	; A0
	DB	11111111B
	DB	00000010B
	DB	00000101B
	DB	00001010B
	DB	00010101B
	DB	00101010B
	DB	00010101B

	DB	11111111B	; 
	DB	11111111B
	DB	10000000B
	DB	01000000B
	DB	10100000B
	DB	01010000B
	DB	10101000B
	DB	01010100B

	DB	00101010B	; 
	DB	00010101B
	DB	00101010B
	DB	00010101B
	DB	00001010B
	DB	00000101B
	DB	00000001B
	DB	00000001B

	DB	10101000B	; 
	DB	01010100B
	DB	10101000B
	DB	01010100B
	DB	10101000B
	DB	01010000B
	DB	10000000B
	DB	10000000B

	DB	11111111B	; A4
	DB	11111111B
	DB	11111111B
	DB	11111111B
	DB	11111111B
	DB	11111111B
	DB	11111111B
	DB	11111100B

	DB	11111111B	; 
	DB	11111111B
	DB	11111111B
	DB	11111111B
	DB	11111111B
	DB	11111111B
	DB	11111111B
	DB	11111111B

	DB	11111111B	; 
	DB	11111111B
	DB	11111110B
	DB	11110000B
	DB	11100000B
	DB	11000000B
	DB	10000000B
	DB	11110000B

	DB	11111111B	; 
	DB	00011111B
	DB	00000111B
	DB	00000011B
	DB	11111111B
	DB	00001111B
	DB	01111111B
	DB	11111111B

	DB	11111111B	; A8
	DB	11111111B
	DB	11111000B
	DB	11100000B
	DB	01111100B
	DB	11111111B
	DB	11111111B
	DB	11111111B

	DB	11111111B	; 
	DB	11111111B
	DB	11111111B
	DB	00111111B
	DB	00000111B
	DB	11111111B
	DB	11110000B
	DB	11111100B

	DB	11111111B	; 
	DB	11111111B
	DB	11111111B
	DB	11111111B
	DB	11111110B
	DB	11111000B
	DB	00001111B
	DB	00001111B

	DB	11111111B	; 
	DB	11111111B
	DB	11111111B
	DB	10000111B
	DB	00000001B
	DB	11111111B
	DB	11111111B
	DB	11111111B

	DB	11111111B	; AC
	DB	11111111B
	DB	11111111B
	DB	11111111B
	DB	11111111B
	DB	01111111B
	DB	00111111B
	DB	00001111B

	DB	11111111B	; 
	DB	11111111B
	DB	11111110B
	DB	11111100B
	DB	11110000B
	DB	11100000B
	DB	10000000B
	DB	11111111B

	DB	00111111B	; 
	DB	00000111B
	DB	00000011B
	DB	00000011B
	DB	00000001B
	DB	11111111B
	DB	11111111B
	DB	11111111B

	DB	11000000B	; 
	DB	11100000B
	DB	11100000B
	DB	11110000B
	DB	11110000B
	DB	11110000B
	DB	01110000B
	DB	00110000B

	DB	11111111B	; B0
	DB	11111111B
	DB	11111111B
	DB	11111100B
	DB	11000000B
	DB	11111111B
	DB	11111111B
	DB	11111111B

	DB	11111111B	; 
	DB	11111000B
	DB	10000000B
	DB	11111111B
	DB	11111111B
	DB	11111111B
	DB	11111111B
	DB	11111111B

	DB	11111111B	; 
	DB	11111111B
	DB	01111111B
	DB	00000011B
	DB	11111000B
	DB	11111111B
	DB	11111111B
	DB	11111111B

	DB	11111111B	; 
	DB	11111111B
	DB	11111111B
	DB	11111111B
	DB	01111111B
	DB	00000111B
	DB	11111000B
	DB	11111111B

	DB	11111111B	; B4
	DB	11111111B
	DB	11111111B
	DB	11111111B
	DB	11111111B
	DB	11111111B
	DB	00111111B
	DB	10001111B

	DB	11111111B	; 
	DB	11111111B
	DB	01111111B
	DB	00011111B
	DB	00000111B
	DB	11111111B
	DB	11111111B
	DB	11111111B

	DB	11111111B	; 
	DB	11111111B
	DB	11111111B
	DB	11111111B
	DB	11111110B
	DB	11110000B
	DB	11111000B
	DB	11111111B

	DB	11111110B	; 
	DB	11111000B
	DB	11000000B
	DB	11111111B
	DB	11111111B
	DB	11111111B
	DB	11111111B
	DB	10000000B

	DB	11111111B	; B8
	DB	11111111B
	DB	11111111B
	DB	11111111B
	DB	11111111B
	DB	11111111B
	DB	11111111B
	DB	11111111B

	DB	11111111B	; 
	DB	11111111B
	DB	11111111B
	DB	11111111B
	DB	11111111B
	DB	11111111B
	DB	11111111B
	DB	00000111B

	DB	00011000B	; 
	DB	00001100B
	DB	00000111B
	DB	00000001B
	DB	11111111B
	DB	11111111B
	DB	11111111B
	DB	11111111B

	DB	11111111B	; 
	DB	11111111B
	DB	11111111B
	DB	11111111B
	DB	11111111B
	DB	00001111B
	DB	00111111B
	DB	00000111B

	DB	11111111B	; BC
	DB	11111111B
	DB	11111111B
	DB	11111111B
	DB	11111111B
	DB	11000000B
	DB	11110000B
	DB	11111000B

	DB	11111111B	; 
	DB	11111111B
	DB	11111111B
	DB	11111111B
	DB	11111111B
	DB	11111111B
	DB	11100001B
	DB	10000000B

	DB	11111111B	; 
	DB	11111111B
	DB	11111111B
	DB	11111111B
	DB	11111111B
	DB	11111100B
	DB	11110000B
	DB	10000000B

	DB	11111000B	; 
	DB	11100000B
	DB	11000000B
	DB	10000000B
	DB	11111111B
	DB	11111111B
	DB	11111111B
	DB	11111111B

	DB	00000111B	; C0
	DB	00000001B
	DB	00011111B
	DB	00111111B
	DB	01111111B
	DB	01111111B
	DB	01111111B
	DB	11111111B

	DB	11111111B	; 
	DB	11111111B
	DB	11111111B
	DB	01111111B
	DB	00111111B
	DB	00111111B
	DB	00011111B
	DB	00001111B

	DB	00000001B	; 
	DB	11111111B
	DB	11111111B
	DB	11111111B
	DB	11111111B
	DB	11111111B
	DB	11111111B
	DB	11111111B

	DB	11111100B	; 
	DB	11111110B
	DB	01110000B
	DB	01110000B
	DB	01110000B
	DB	01110000B
	DB	11100000B
	DB	11100000B

	DB	11111111B	; C4
	DB	11111111B
	DB	11111111B
	DB	01111111B
	DB	00111111B
	DB	00011111B
	DB	00001111B
	DB	00000111B

	DB	11111110B	; 
	DB	11111100B
	DB	11111000B
	DB	11110000B
	DB	11100000B
	DB	11000000B
	DB	10000000B
	DB	11111111B

	DB	11111111B	; 
	DB	11111111B
	DB	11111111B
	DB	11111111B
	DB	11111111B
	DB	11111111B
	DB	11111111B
	DB	11111111B

	DB	11111000B	; 
	DB	11111000B
	DB	11111100B
	DB	11111110B
	DB	11111111B
	DB	11111111B
	DB	11111111B
	DB	11111111B

	DB	11111111B	; C8
	DB	11111111B
	DB	11111111B
	DB	11111111B
	DB	10000000B
	DB	11100000B
	DB	11111000B
	DB	11111100B

	DB	11111111B	; 
	DB	11111111B
	DB	11111111B
	DB	11111111B
	DB	01111111B
	DB	01111111B
	DB	01111111B
	DB	00111111B

	DB	00000111B	; 
	DB	00000011B
	DB	00000001B
	DB	11111111B
	DB	11111111B
	DB	11111111B
	DB	11111111B
	DB	11111111B

	DB	11111111B	; 
	DB	11111111B
	DB	11111111B
	DB	11111111B
	DB	01111111B
	DB	00111111B
	DB	00011111B
	DB	00000111B

	DB	11111111B	; CC
	DB	11111111B
	DB	00000111B
	DB	00011111B
	DB	11111111B
	DB	11111111B
	DB	11111110B
	DB	11111110B

	DB	11111111B	; 
	DB	11111111B
	DB	11100000B
	DB	11111000B
	DB	10000000B
	DB	11111111B
	DB	11111111B
	DB	11111111B

	DB	11111111B	; 
	DB	11111111B
	DB	11111111B
	DB	11111111B
	DB	01111111B
	DB	00111111B
	DB	00001111B
	DB	00000111B

	DB	00000001B	; 
	DB	00000111B
	DB	00111110B
	DB	11110000B
	DB	11111111B
	DB	11111111B
	DB	11110000B
	DB	11111110B

	DB	11000000B	; D0
	DB	10000000B
	DB	11111111B
	DB	11111111B
	DB	11111111B
	DB	11111111B
	DB	11111111B
	DB	11111111B

	DB	00000011B	; 
	DB	00000001B
	DB	11111111B
	DB	11111111B
	DB	11111111B
	DB	11111111B
	DB	11111111B
	DB	00000001B

	DB	11111111B	; 
	DB	11111111B
	DB	11111111B
	DB	01111111B
	DB	00011111B
	DB	00001111B
	DB	00011111B
	DB	11111111B

	DB	11111100B	; 
	DB	11111000B
	DB	11110000B
	DB	10000000B
	DB	11111111B
	DB	11111111B
	DB	11111111B
	DB	11111111B

	DB	00111111B	; D4
	DB	10011111B
	DB	11001111B
	DB	11100011B
	DB	11111000B
	DB	11111111B
	DB	11111111B
	DB	11111111B

	DB	11111111B	; 
	DB	11111111B
	DB	11111111B
	DB	11111111B
	DB	01111111B
	DB	00000111B
	DB	11110000B
	DB	11111111B

	DB	00000001B	; 
	DB	11111111B
	DB	11111111B
	DB	11111111B
	DB	11111111B
	DB	11111111B
	DB	00001111B
	DB	10000000B

	DB	11111111B	; 
	DB	01111111B
	DB	00111111B
	DB	00011111B
	DB	00001111B
	DB	11100011B
	DB	00001111B
	DB	00011111B

	DB	11111111B	; D8
	DB	11111111B
	DB	10000000B
	DB	11100000B
	DB	11111100B
	DB	00111111B
	DB	00001111B
	DB	11111111B

	DB	00000011B	; 
	DB	00000001B
	DB	11111111B
	DB	11111111B
	DB	11111111B
	DB	10000000B
	DB	11110000B
	DB	10001111B

	DB	11111111B	; 
	DB	11111111B
	DB	11111111B
	DB	00111111B
	DB	00001111B
	DB	00000001B
	DB	00111111B
	DB	11111111B

	DB	11111111B	; 
	DB	11111111B
	DB	11111110B
	DB	11111000B
	DB	11000000B
	DB	11111111B
	DB	11111111B
	DB	11111111B

	DB	11110000B	; DC
	DB	11111111B
	DB	11111111B
	DB	11111111B
	DB	00000001B
	DB	00000010B
	DB	00000101B
	DB	00000010B

	DB	11110001B	; 
	DB	11111000B
	DB	11111100B
	DB	11111111B
	DB	11111111B
	DB	10000000B
	DB	01000000B
	DB	10000000B

	DB	00011111B	; 
	DB	00001000B
	DB	11111111B
	DB	11111111B
	DB	00000010B
	DB	11111111B
	DB	11111111B
	DB	00000100B

	DB	01000000B	; 
	DB	00001000B
	DB	10000000B
	DB	11111111B
	DB	00010010B
	DB	11111111B
	DB	10000000B
	DB	00000100B

	DB	01000000B	; E0
	DB	00001000B
	DB	10000000B
	DB	11111111B
	DB	00010010B
	DB	11111111B
	DB	10000000B
	DB	00000100B

	DB	11111111B	; 
	DB	00001000B
	DB	11111111B
	DB	11111111B
	DB	00000010B
	DB	11111111B
	DB	11111111B
	DB	00000100B

	DB	01000101B	; 
	DB	00001010B
	DB	10000101B
	DB	00001010B
	DB	00010101B
	DB	00000010B
	DB	10000001B
	DB	00000001B

	DB	01000000B	; 
	DB	10100010B
	DB	01000101B
	DB	10101010B
	DB	01000101B
	DB	10001010B
	DB	00000101B
	DB	00000001B

	DB	11111111B	; E4
	DB	10001000B
	DB	01000000B
	DB	10100000B
	DB	01000010B
	DB	10100000B
	DB	01000000B
	DB	00000100B

	DB	01000000B	; 
	DB	00000010B
	DB	10000101B
	DB	00001010B
	DB	00010101B
	DB	00001010B
	DB	10000101B
	DB	00000001B

	DB	11111111B	; 
	DB	10001000B
	DB	01000000B
	DB	10100000B
	DB	01000010B
	DB	10100000B
	DB	01000000B
	DB	00000100B

	DB	01000000B	; 
	DB	11111111B
	DB	10000000B
	DB	11111111B
	DB	00010000B
	DB	11111111B
	DB	10000000B
	DB	11111111B

	DB	11111111B	; E8
	DB	11111110B
	DB	11111111B
	DB	11111111B
	DB	11111111B
	DB	11111111B
	DB	00000010B
	DB	00001000B

	DB	00001111B	; 
	DB	00001111B
	DB	00000111B
	DB	01000000B
	DB	11111111B
	DB	00010010B
	DB	11111111B
	DB	00100001B

	DB	11111111B	; 
	DB	11111111B
	DB	11111111B
	DB	00111111B
	DB	00000001B
	DB	11111111B
	DB	00010000B
	DB	11111111B

	DB	11111111B	; 
	DB	11111111B
	DB	11111111B
	DB	11111111B
	DB	11111111B
	DB	00000001B
	DB	00000010B
	DB	00000001B

	DB	11111111B	; EC
	DB	11111111B
	DB	00101000B
	DB	01010100B
	DB	10101010B
	DB	01010101B
	DB	10101010B
	DB	01010101B

	DB	11111111B	; 
	DB	11111111B
	DB	11111111B
	DB	11111111B
	DB	00000001B
	DB	00000010B
	DB	10000101B
	DB	01000010B

	DB	11111111B	; 
	DB	11111111B
	DB	11111111B
	DB	11111111B
	DB	11111111B
	DB	10000000B
	DB	01000000B
	DB	10000000B

	DB	00000011B	; 
	DB	00000010B
	DB	00000101B
	DB	00001010B
	DB	00000101B
	DB	00001010B
	DB	00000101B
	DB	00000001B

	DB	00000010B	; F0
	DB	10000001B
	DB	01000010B
	DB	10100001B
	DB	01000000B
	DB	10100000B
	DB	01000000B
	DB	11111111B

	DB	10101010B	; 
	DB	01010101B
	DB	10101010B
	DB	01010101B
	DB	10101010B
	DB	01010101B
	DB	00011000B
	DB	00011000B

	DB	10000101B	; 
	DB	01001010B
	DB	10000101B
	DB	01001010B
	DB	10000101B
	DB	00000010B
	DB	00000001B
	DB	00000001B

	DB	01000000B	; 
	DB	10101000B
	DB	01000000B
	DB	10100000B
	DB	01000010B
	DB	10000000B
	DB	11111111B
	DB	00000100B

	DB	00000000B	; F4
	DB	00000000B
	DB	00000000B
	DB	00000000B
	DB	00010110B
	DB	00110111B
	DB	00011111B
	DB	00001111B

	DB	00000000B	; 
	DB	00000000B
	DB	00000000B
	DB	00000000B
	DB	00000000B
	DB	00000000B
	DB	00000000B
	DB	00000000B

	DB	00000000B	; 
	DB	00011111B
	DB	00111111B
	DB	00000000B
	DB	00000000B
	DB	00000000B
	DB	00000000B
	DB	00000111B

	DB	00000000B	; 
	DB	00000000B
	DB	00000000B
	DB	00000000B
	DB	00000000B
	DB	00000000B
	DB	00000000B
	DB	00000000B

	DB	00000000B	; F8
	DB	00000000B
	DB	00000000B
	DB	00000000B
	DB	00000000B
	DB	00000001B
	DB	00000000B
	DB	00000000B

	DB	00000000B	; 
	DB	00000000B
	DB	00000000B
	DB	00111000B
	DB	11101000B
	DB	11101000B
	DB	11111000B
	DB	11110000B

	DB	00000000B	; 
	DB	00000001B
	DB	00000111B
	DB	00000011B
	DB	00000000B
	DB	00000001B
	DB	00000001B
	DB	00000001B

	DB	00000000B	; 
	DB	11000000B
	DB	11000000B
	DB	10000000B
	DB	00000000B
	DB	00000000B
	DB	11000000B
	DB	11100000B

	DB	11111111B	; FC
	DB	00011111B
	DB	00000000B
	DB	00000100B
	DB	00000000B
	DB	00000001B
	DB	00100000B
	DB	10000010B

	DB	00000000B	; FD
	DB	00000000B
	DB	10000000B
	DB	11111100B
	DB	00000000B
	DB	00100000B
	DB	00000001B
	DB	00010000B
N547C	EQU	$-D547C
  ENDIF

  IF RLE
RLE596C
	HEX	85 77 00 C7 8A 77 81 72 01 73 77 80 72 81 22 80
	HEX	32 80 77 80 72 00 32 81 33 80 77 80 72 80 32 80
	HEX	33 82 77 80 72 01 22 32 81 77 81 73 80 33 81 77
	HEX	82 73 00 33 83 77 81 72 00 C7 81 72 82 22 86 C2
	HEX	82 77 01 73 32 80 33 80 77 80 73 82 33 01 77 73
	HEX	84 33 82 32 85 33 81 32 85 33 82 32 85 33 82 73
	HEX	82 33 82 77 80 73 80 33 80 77 81 72 00 22 80 32
	HEX	80 72 8C 22 00 C2 83 22 80 42 86 33 00 32 85 33
	HEX	84 77 01 C7 72 83 77 02 C7 CC C2 85 77 00 C7 84
	HEX	77 80 73 84 77 02 73 32 77 83 72 80 22 01 72 22
	HEX	84 32 80 72 83 73 00 33 86 C2 80 C7 82 72 80 22
	HEX	85 77 00 72 82 77 85 73 83 33 84 32 80 33 86 32
	HEX	83 73 80 C3 00 33 81 77 80 C7 80 CC 00 C3 80 77
	HEX	01 C7 CC 82 C2 81 77 00 C7 80 72 80 22 82 C2 80
	HEX	22 80 44 81 C2 82 22 00 42 83 72 00 22 80 32 81
	HEX	77 80 73 81 33 80 73 84 33 82 32 85 33 81 32 85
	HEX	33 02 32 22 32 82 C3 00 33 81 32 82 C2 01 CC C2
	HEX	80 33 82 22 80 C2 01 CC 32 82 72 80 22 01 32 33
	HEX	82 44 00 43 81 33 00 42 81 43 86 33 85 D3 02 33
	HEX	D3 33 87 D3 01 63 33 84 D3 00 63 80 33 84 D3 80
	HEX	33 8A D3 80 63 84 D3 80 63 85 77 00 72 88 77 83
	HEX	72 01 32 77 81 72 00 22 80 32 00 33 80 77 80 72
	HEX	00 32 81 33 81 77 80 72 00 22 80 32 82 77 80 73
	HEX	80 32 81 77 80 73 81 33 83 77 81 73 80 77 83 72
	HEX	01 22 C7 82 C2 81 22 86 C2 81 77 80 73 81 33 00
	HEX	77 80 73 85 33 81 32 85 33 81 32 85 33 80 32 80
	HEX	77 81 73 81 33 82 77 80 72 01 32 33 81 72 82 22
	HEX	00 32 8D 22 00 42 82 C2 80 22 80 44 83 77 80 C7
	HEX	00 C2 83 77 81 C7 84 77 80 73 83 77 80 72 00 32
	HEX	82 72 82 22 80 72 83 32 00 33 81 77 83 73 00 C2
	HEX	85 22 80 C7 84 C2 81 77 83 72 85 73 87 33 82 32
	HEX	82 33 82 22 82 32 82 33 82 32 81 73 83 33 82 77
	HEX	00 73 81 C3 80 77 80 C7 80 CC 80 C2 80 77 80 C7
	HEX	00 C2 81 22 82 77 82 72 82 C2 80 22 80 42 80 C2
	HEX	84 22 80 72 83 22 00 32 81 77 80 72 80 32 00 33
	HEX	82 73 82 33 83 32 85 33 81 32 01 33 C3 83 33 80
	HEX	32 00 CC 82 C3 81 32 80 22 81 C2 80 C3 00 33 80
	HEX	72 81 22 80 C2 00 32 81 77 80 72 80 32 00 33 80
	HEX	44 81 43 81 33 00 73 81 33 82 D3 81 32 80 33 81
	HEX	D3 01 32 D3 80 33 00 D3 80 33 82 D3 02 33 D3 33
	HEX	83 D3 02 33 D3 33 80 D3 01 33 D3 80 33 00 D3 80
	HEX	33 86 D3 00 63 85 D3 01 63 33 8C D3 01 63 33 86
	HEX	D3 08 33 D3 33 D3 33 D3 33 22 32 82 33 80 D3 80
	HEX	42 05 43 D3 33 D3 33 D3 81 44 80 43 01 33 D3 84
	HEX	33 81 D3 80 33 84 D3 82 33 82 D3 83 33 81 D3 00
	HEX	32 84 D3 00 63 85 D3 00 33 84 D3 80 63 85 D3 00
	HEX	63 84 D3 01 33 D3 BE F0 04 22 23 33 D3 33 81 D3
	HEX	80 44 80 34 00 33 81 D3 FF
  ELSE
D596C	HEX	77 77 77 77 77 77 77 C7	; C-60
	HEX	77 77 77 77 77 77 77 77
	HEX	77 77 77 77 72 72 72 73
	HEX	77 72 72 22 22 22 32 32
	HEX	77 77 72 72 32 33 33 33
	HEX	77 77 72 72 32 32 33 33
	HEX	77 77 77 77 72 72 22 32
	HEX	77 77 77 73 73 73 33 33
	HEX	77 77 77 73 73 73 73 33
	HEX	77 77 77 77 77 72 72 72
	HEX	C7 72 72 72 22 22 22 22
	HEX	C2 C2 C2 C2 C2 C2 C2 C2
	HEX	77 77 77 77 73 32 33 33
	HEX	77 77 73 73 33 33 33 33
	HEX	77 73 33 33 33 33 33 33
	HEX	32 32 32 32 33 33 33 33
	HEX	33 33 33 32 32 32 33 33	; C-70
	HEX	33 33 33 33 33 32 32 32
	HEX	32 33 33 33 33 33 33 33
	HEX	73 73 73 73 33 33 33 33
	HEX	77 77 77 77 73 73 33 33
	HEX	77 77 72 72 72 22 32 32
	HEX	72 72 22 22 22 22 22 22
	HEX	22 22 22 22 22 22 22 22
	HEX	C2 22 22 22 22 22 42 42
	HEX	33 33 33 33 33 33 33 33
	HEX	32 33 33 33 33 33 33 33
	HEX	77 77 77 77 77 77 C7 72
	HEX	77 77 77 77 77 C7 CC C2
	HEX	77 77 77 77 77 77 77 C7
	HEX	77 77 77 77 77 77 73 73
	HEX	77 77 77 77 77 77 73 32
	HEX	77 72 72 72 72 72 22 22	; C-80
	HEX	72 22 32 32 32 32 32 32
	HEX	72 72 73 73 73 73 73 33
	HEX	C2 C2 C2 C2 C2 C2 C2 C2
	HEX	C7 C7 72 72 72 72 22 22
	HEX	77 77 77 77 77 77 77 72
	HEX	77 77 77 77 73 73 73 73
	HEX	73 73 73 33 33 33 33 33
	HEX	32 32 32 32 32 32 33 33
	HEX	32 32 32 32 32 32 32 32
	HEX	73 73 73 73 73 C3 C3 33
	HEX	77 77 77 C7 C7 CC CC C3
	HEX	77 77 C7 CC C2 C2 C2 C2
	HEX	77 77 77 C7 72 72 22 22
	HEX	C2 C2 C2 C2 22 22 44 44
	HEX	C2 C2 C2 22 22 22 22 42
	HEX	72 72 72 72 72 22 32 32	; C-90
	HEX	77 77 77 73 73 33 33 33
	HEX	73 73 33 33 33 33 33 33
	HEX	32 32 32 32 33 33 33 33
	HEX	33 33 33 32 32 32 33 33
	HEX	33 33 33 33 33 32 22 32
	HEX	C3 C3 C3 C3 33 32 32 32
	HEX	C2 C2 C2 C2 CC C2 33 33
	HEX	22 22 22 22 C2 C2 CC 32
	HEX	72 72 72 72 22 22 32 33
	HEX	44 44 44 44 43 33 33 33
	HEX	42 43 43 43 33 33 33 33
	HEX	33 33 33 33 D3 D3 D3 D3
	HEX	D3 D3 D3 33 D3 33 D3 D3
	HEX	D3 D3 D3 D3 D3 D3 D3 63
	HEX	33 D3 D3 D3 D3 D3 D3 63
	HEX	33 33 D3 D3 D3 D3 D3 D3	; C-A0
	HEX	33 33 D3 D3 D3 D3 D3 D3
	HEX	D3 D3 D3 D3 D3 D3 63 63
	HEX	D3 D3 D3 D3 D3 D3 63 63
	HEX	77 77 77 77 77 77 77 72
	HEX	77 77 77 77 77 77 77 77
	HEX	77 77 72 72 72 72 72 32
	HEX	77 72 72 72 22 32 32 33
	HEX	77 77 72 72 32 33 33 33
	HEX	77 77 77 72 72 22 32 32
	HEX	77 77 77 77 73 73 32 32
	HEX	77 77 77 73 73 33 33 33
	HEX	77 77 77 77 77 73 73 73
	HEX	77 77 72 72 72 72 72 22
	HEX	C7 C2 C2 C2 C2 22 22 22
	HEX	C2 C2 C2 C2 C2 C2 C2 C2
	HEX	77 77 77 73 73 33 33 33	; C-B0
	HEX	77 73 73 33 33 33 33 33
	HEX	33 33 32 32 32 33 33 33
	HEX	33 33 33 33 32 32 32 33
	HEX	33 33 33 33 33 33 32 32
	HEX	77 77 73 73 73 33 33 33
	HEX	77 77 77 77 72 72 32 33
	HEX	72 72 72 22 22 22 22 32
	HEX	22 22 22 22 22 22 22 22
	HEX	22 22 22 22 22 22 22 42
	HEX	C2 C2 C2 C2 22 22 44 44
	HEX	77 77 77 77 77 C7 C7 C2
	HEX	77 77 77 77 77 C7 C7 C7
	HEX	77 77 77 77 77 77 73 73
	HEX	77 77 77 77 77 72 72 32
	HEX	72 72 72 72 22 22 22 22
	HEX	72 72 32 32 32 32 32 33	; C-C0
	HEX	77 77 77 73 73 73 73 73
	HEX	C2 22 22 22 22 22 22 22
	HEX	C7 C7 C2 C2 C2 C2 C2 C2
	HEX	77 77 77 72 72 72 72 72
	HEX	73 73 73 73 73 73 73 33
	HEX	33 33 33 33 33 33 33 33
	HEX	32 32 32 32 33 33 33 33
	HEX	22 22 22 22 32 32 32 32
	HEX	33 33 33 33 32 32 32 32
	HEX	73 73 73 33 33 33 33 33
	HEX	77 77 77 77 73 C3 C3 C3
	HEX	77 77 C7 C7 CC CC C2 C2
	HEX	77 77 C7 C7 C2 22 22 22
	HEX	77 77 77 77 72 72 72 72
	HEX	C2 C2 C2 C2 22 22 42 42
	HEX	C2 C2 22 22 22 22 22 22	; C-D0
	HEX	72 72 22 22 22 22 22 32
	HEX	77 77 77 72 72 32 32 33
	HEX	73 73 73 73 33 33 33 33
	HEX	32 32 32 32 32 33 33 33
	HEX	33 33 33 33 32 32 32 33
	HEX	C3 33 33 33 33 33 32 32
	HEX	CC C3 C3 C3 C3 32 32 32
	HEX	22 22 C2 C2 C2 C3 C3 33
	HEX	72 72 22 22 22 C2 C2 32
	HEX	77 77 77 72 72 32 32 33
	HEX	44 44 43 43 43 33 33 33
	HEX	73 33 33 33 D3 D3 D3 D3
	HEX	32 32 32 33 33 D3 D3 D3
	HEX	32 D3 33 33 D3 33 33 D3
	HEX	D3 D3 D3 33 D3 33 D3 D3
	HEX	D3 D3 D3 33 D3 33 D3 D3	; C-E0
	HEX	33 D3 33 33 D3 33 33 D3
	HEX	D3 D3 D3 D3 D3 D3 D3 63
	HEX	D3 D3 D3 D3 D3 D3 D3 63
	HEX	33 D3 D3 D3 D3 D3 D3 D3
	HEX	D3 D3 D3 D3 D3 D3 D3 63
	HEX	33 D3 D3 D3 D3 D3 D3 D3
	HEX	D3 33 D3 33 D3 33 D3 33
	HEX	22 32 33 33 33 33 D3 D3
	HEX	42 42 43 D3 33 D3 33 D3
	HEX	44 44 44 43 43 33 D3 33
	HEX	33 33 33 33 33 D3 D3 D3
	HEX	33 33 D3 D3 D3 D3 D3 D3
	HEX	33 33 33 33 D3 D3 D3 D3
	HEX	33 33 33 33 33 D3 D3 D3
	HEX	32 D3 D3 D3 D3 D3 D3 63
	HEX	D3 D3 D3 D3 D3 D3 D3 33	; C-F0
	HEX	D3 D3 D3 D3 D3 D3 63 63
	HEX	D3 D3 D3 D3 D3 D3 D3 63
	HEX	D3 D3 D3 D3 D3 D3 33 D3
	HEX	F0 F0 F0 F0 F0 F0 F0 F0
	HEX	F0 F0 F0 F0 F0 F0 F0 F0
	HEX	F0 F0 F0 F0 F0 F0 F0 F0
	HEX	F0 F0 F0 F0 F0 F0 F0 F0
	HEX	F0 F0 F0 F0 F0 F0 F0 F0	; C-F8
	HEX	F0 F0 F0 F0 F0 F0 F0 F0	; C-F9
	HEX	F0 F0 F0 F0 F0 F0 F0 F0	; C-FA
	HEX	F0 F0 F0 F0 F0 F0 F0 F0	; C-FB
	HEX	22 23 33 D3 33 D3 D3 D3	; C-FC
	HEX	44 44 34 34 33 D3 D3 D3	; C-FD
N596C	EQU	$-D596C
  ENDIF

D5E5C	HEX	00 05 01 02 06 04 05 00
	HEX	05 03 06 04 01 07 00 03
	HEX	07 05 02 06 04 00 01 06
	HEX	07 02 05 04 00 05 06 05
	HEX	06 05 06 00 01 03 01 03
	HEX	01 03 00 02 04 07 04 02
	HEX	07 00 07 02 04 03 02 01

; map graphics, four (?) of these make the map for a level

D5E94	HEX	06 00 00 2C 2D 6E 00 6F 00 00 06 00 00 28 29 00
	HEX	00 00 6E 2E 2F 00 70 71 72 73 00 00 00 2A 2B 00
	HEX	6E 06 00 7C 7D 7D 74 75 76 77 7D 7D 7E 06 00 6E
	HEX	00 00 00 7F 00 00 78 24 25 79 00 00 7E 00 00 00
	HEX	06 00 00 00 00 00 7A 26 27 7B 00 00 80 6E 06 00
	HEX	00 00 6E 00 00 00 84 85 86 87 00 00 00 00 00 00	; 84..87 = "Wellcome"
	HEX	00 06 00 7C 00 00 00 00 00 00 00 00 00 06 00 00
	HEX	6E 00 00 7C 00 00 00 00 00 00 00 00 7E 00 00 6E
	HEX	06 00 6E 81 82 82 82 00 00 82 82 82 83 00 06 00
	HEX	00 00 00 06 00 6E 00 06 00 00 6E 06 00 6E 00 00
	HEX	00 06 00 00 00 06 00 00 00 06 00 00 00 06 00 00
	HEX	6E 00 00 00 6E 00 00 6E 00 00 00 00 6E 00 00 00

	HEX	6E 00 06 00 6E 00 00 6E 06 00 06 00 06 00 06 00
	HEX	06 00 00 00 06 00 06 00 00 00 00 00 00 00 00 00
	HEX	00 00 28 29 00 00 00 00 54 55 56 55 56 6E 06 00
	HEX	06 00 2A 2B 54 55 5E 48 41 44 44 44 44 42 00 00
	HEX	00 00 00 40 41 44 44 44 44 44 44 44 44 47 6E 00
	HEX	6E 00 40 44 44 44 44 44 44 44 44 44 44 44 57 00
	HEX	00 00 45 44 44 44 44 44 44 44 44 44 44 44 58 6E
	HEX	06 00 00 45 44 44 44 44 44 44 44 44 46 5D 06 00
	HEX	00 00 28 29 59 5A 43 44 44 44 46 5D 28 29 00 00
	HEX	00 00 2A 2B 06 00 6E 5B 5C 5D 06 00 2A 2B 06 00
	HEX	00 00 06 00 00 00 06 00 06 00 00 00 06 00 00 00
	HEX	6E 00 00 00 00 6E 00 00 00 00 6E 00 00 00 6E 00

	HEX	06 00 06 00 49 4A 4A 5F 06 00 06 00 06 00 06 00
	HEX	00 00 00 00 4B 4A 4A 4C 00 00 00 00 00 00 00 00
	HEX	00 06 00 00 60 4A 4A 4A 61 28 29 06 00 06 00 6E
	HEX	6E 00 00 00 6E 49 4A 4A 62 2A 2B 00 00 00 00 00
	HEX	06 00 6E 2C 2D 63 4A 4A 4D 00 06 00 06 00 06 00
	HEX	00 00 00 2E 2F 64 3C 3C 3D 6E 00 00 00 00 00 00
	HEX	00 06 00 06 00 00 6D 6D 6D 00 06 00 06 00 28 29
	HEX	6E 00 00 00 00 6E 6D 6D 6D 00 00 00 00 00 2A 2B
	HEX	00 28 29 6E 00 00 6D 6D 6D 00 00 06 00 06 00 6E
	HEX	6E 2A 2B 00 06 00 3E 4A 4A 61 6E 00 00 00 00 00
	HEX	06 00 06 00 00 00 4B 4A 4A 62 2C 2D 06 00 06 00
	HEX	00 00 00 00 6E 00 65 4A 4A 4C 2E 2F 00 00 00 00

	HEX	6E 06 00 06 00 06 00 06 00 6E 00 00 06 00 06 00
	HEX	00 00 00 00 00 00 00 00 00 54 55 56 00 00 00 00
	HEX	06 00 6E 06 00 2C 2D 00 40 41 44 44 42 55 56 6E
	HEX	00 00 00 00 00 2E 2F 00 45 44 44 44 44 44 44 57
	HEX	6E 06 00 6E 06 00 06 00 6E 59 5A 43 44 44 44 58
	HEX	00 00 00 00 00 00 00 00 06 00 06 00 5B 5C 5D 6E
	HEX	6E 00 6E 54 55 56 6E 00 00 00 00 00 06 00 6E 00
	HEX	00 40 41 41 44 44 42 55 56 6E 00 6E 00 00 06 00
	HEX	00 45 44 44 44 44 44 44 44 42 2C 2D 06 00 00 00
	HEX	06 00 59 5A 43 44 44 44 44 46 2E 2F 00 00 06 00
	HEX	00 00 06 00 6E 5B 5C 5D 5D 06 00 6E 06 00 00 00
	HEX	6E 00 00 00 00 00 00 6E 00 00 00 00 00 00 6E 00

	HEX	06 00 06 00 28 29 67 4A 4A 4E 6E 06 00 06 00 6E
	HEX	00 00 00 00 2A 2B 4F 4A 4A 68 00 00 00 00 00 00
	HEX	00 06 00 06 00 6E 3B 3C 3C 69 06 00 2C 2D 06 00
	HEX	6E 00 00 00 00 00 6D 6D 6D 00 00 00 2E 2F 00 00
	HEX	06 00 06 00 06 00 6D 6D 6D 00 6E 06 00 06 00 6E
	HEX	00 00 00 00 00 00 6D 6D 6D 00 00 00 00 00 00 00
	HEX	6E 06 00 06 00 6A 4A 4A 4A 28 29 00 06 00 06 00
	HEX	00 00 00 00 00 6B 4A 4A 50 2A 2B 6E 00 00 00 00
	HEX	06 00 06 00 6E 51 4A 4A 52 06 00 06 00 06 00 6E
	HEX	00 00 00 00 6A 4A 4A 4A 68 00 00 00 00 00 00 00
	HEX	06 00 2C 2D 6B 4A 4A 4A 69 06 00 6E 06 00 06 00
	HEX	00 00 2E 2F 51 4A 4A 50 6E 00 00 00 00 00 00 00

	HEX	00 00 00 06 00 06 00 06 00 6E 00 06 00 6E 00 00
	HEX	00 06 00 00 00 00 00 00 00 06 00 00 00 06 00 00
	HEX	00 00 00 00 06 00 6E 28 29 00 00 06 00 00 00 00
	HEX	00 00 6E 00 00 00 00 2A 2B 06 00 00 00 06 00 6E
	HEX	00 06 00 06 00 06 00 06 00 00 00 06 00 00 00 00
	HEX	00 00 00 00 00 00 00 00 00 6E 00 00 00 00 06 00
	HEX	06 00 06 00 00 06 00 28 29 28 29 00 06 00 00 00
	HEX	00 00 00 00 00 00 00 2A 2B 2A 2B 6E 00 00 00 00
	HEX	06 00 6E 06 00 2C 2D 06 00 28 29 06 00 06 00 00
	HEX	00 00 00 00 00 2E 2F 00 00 2A 2B 00 00 00 00 00
	HEX	06 00 06 00 00 06 00 06 00 06 00 6E 06 00 06 00
	HEX	00 00 00 00 6E 00 00 00 00 00 00 00 00 00 00 00

	HEX	06 00 06 00 6E 00 06 00 00 6E 06 00 06 00 06 00
	HEX	00 00 00 00 06 00 00 00 06 00 00 00 00 00 00 00
	HEX	28 29 28 29 00 00 06 00 00 00 06 00 2C 2D 6E 00
	HEX	2A 2B 2A 2B 28 29 00 00 06 00 00 00 2E 2F 06 00
	HEX	6E 06 00 00 2A 2B 28 29 00 00 06 00 06 00 00 00
	HEX	00 00 00 06 00 6E 2A 2B 28 29 00 00 00 00 06 00
	HEX	06 00 6E 00 00 00 06 00 2A 2B 06 00 00 6E 00 00
	HEX	00 00 2C 2D 06 00 00 00 06 00 00 00 06 00 00 6E
	HEX	06 00 2E 2F 00 00 00 6E 00 00 06 00 00 00 06 00
	HEX	00 00 6E 06 00 6E 00 06 00 6E 00 00 6E 00 00 00
	HEX	6E 06 00 00 00 06 00 00 00 00 28 29 00 06 00 6E
	HEX	00 00 00 6E 00 00 00 00 6E 00 2A 2B 00 00 00 00

	HEX	06 00 00 6E 00 6E 4F 4A 4A 4A 68 06 00 00 6E 00
	HEX	00 00 06 00 06 00 3B 3C 3C 3C 6E 00 00 06 00 00
	HEX	06 00 00 00 00 00 6D 6D 6D 6D 06 00 6E 00 00 00
	HEX	00 00 06 00 06 00 6D 6D 6D 6D 00 00 06 00 06 00
	HEX	06 00 00 00 00 00 6D 6D 6D 6D 06 00 00 00 00 00
	HEX	00 00 06 00 6E 6A 4A 4A 4A 3F 00 00 06 00 06 00
	HEX	06 00 00 00 00 6B 4A 50 49 53 6E 00 00 00 00 00
	HEX	00 00 28 29 6E 51 4A 52 4B 4A 61 06 00 6E 06 00
	HEX	06 00 2A 2B 6A 4A 4A 68 65 4A 62 00 00 00 00 00
	HEX	00 00 06 00 6B 4A 4A 69 64 4A 4C 6E 06 00 00 6E
	HEX	06 00 00 00 51 4A 50 06 00 49 4A 5F 00 00 06 00
	HEX	00 00 6E 67 4A 4A 53 00 00 4B 4A 4C 6E 00 00 00

; graphics for power-ups
D6494
;	################	(00) heart
;	..####....####..
;	.######..######.
;	.###############
;	##...###########
;	#...############
;	#...############
;	#....###########
;	##...#..########
;	######..########
;	.##############.
;	.##############.
;	..############..
;	...##########...
;	.....######.....
;	.......##.......

	HEX	FF 3C 7E 7F C7 8F 8F 87  FF 3C 7E FF FF FF FF FF
	HEX	C4 FC 7F 7F 3F 1F 07 01  FF FF FE FE FC F8 E0 80
N6494	EQU	$-D6494

;	##..##..##..#.##	(01) bouquet
;	...##.####..##.#
;	.##.##....##..##
;	.#..##....##..#.
;	..##..####..##..
;	#.##..####..#..#
;	##..##....###...
;	.##.##...##.###.
;	...###..##..#..#
;	.###.##.##..##..
;	#....###..##..##
;	#......#..##..#.
;	###.....##..##..
;	######..##..#..#
;	...###..#..##..#
;	....####..##....

	HEX	CC 1B 6C 4C 33 B3 CC 6C CB CD 33 32 CC C9 38 6E
	HEX	1C 76 87 81 E0 FC 1C 0F C9 CC 33 32 CC C9 99 30

;	#####......#####	(02) clock
;	####........####
;	####........####
;	#######..#######
;	##............##
;	.###........###.
;	###...#..#...###
;	##..#..#...#..##
;	##.....#......##
;	##.#...#....#.##
;	##.....####...##
;	##.#........#.##
;	##............##
;	###.#.#..#.#.###
;	.###.........##.
;	##............##

	HEX	F8 F0 F0 FE C0 70 E2 C9 1F 0F 0F 7F 03 0E 47 13
	HEX	C1 D1 C1 D0 C0 EA 70 C0 03 0B E3 0B 03 57 06 03

;	####........####	(03) skull
;	##............##
;	#..............#
;	################
;	...####..####...
;	..#####..#####..
;	..#####..#####..
;	..#####..#####..
;	....##....##....
;	################
;	#..............#
;	#..............#
;	##............##
;	####.#.#.#..####
;	####.#.#.#..####
;	#####......#####

	HEX	F0 C0 80 FF 1E 3E 3E 3E  0F 03 01 FF 78 7C 7C 7C
	HEX	0C FF 80 80 C0 F5 F5 F8  30 FF 01 01 03 4F 4F 1F

;	......#.#...####	(04) apple
;	.......######...
;	.......#########
;	....###.####....
;	..############..
;	#.......#######.
;	.######...######
;	##..####...#####
;	##..####...#####
;	#####.##...#####
;	.######....#####
;	#.........######
;	#.......#######.
;	..############..
;	...##########...
;	.....##.###.....

	HEX	02 01 01 0E 3F 80 7E CF  8F F8 FF F0 FC FE 3F 1F
	HEX	CF FB 7E 80 80 3F 1F 06  1F 1F 1F 3F FE FC F8 E0

;	##########......	(05) cherries
;	.......#######..
;	......#..#.####.
;	.....#...#......
;	.....#....#.....
;	....#.....#.....
;	....#......#....
;	....#...##....##
;	##....###......#
;	#......###..####
;	.......###..#.##
;	#..######.......
;	#..#.##########.
;	.######.#......#
;	#......###....##
;	##....##########

	HEX	FF 01 02 04 04 08 08 08  C0 FC 5E 40 20 20 10 C3
	HEX	C3 81 01 9F 97 7E 81 C3  81 CF CB 80 FE 81 C3 FF

;	.....####.....#.	(06) grapes
;	...#######...#.#
;	.....#####....##
;	.......##.###..#
;	#####..#.##..##.
;	#####..#..######
;	###..###..#..###
;	###..#..###..###
;	######..#..##..#
;	###..####..##..#
;	###....#..#..###
;	#..##..#..#..###
;	#....#..########
;	###..#..########
;	#..#############
;	#..#############

	HEX	07 1F 07 01 F9 F9 E7 E4  82 C5 C3 B9 66 3F 27 E7
	HEX	FC E7 E1 99 84 E4 9F 9F  99 99 27 27 FF FF FF FF

;	################	(07) "1500"
;	################
;	################
;	################
;	################
;	.#....##########
;	.#....##########
;	.#.#############
;	.#.#############
;	.#.#############
;	.#....#....#....
;	.###..#.#..#.#..
;	.###..#.#..#.#..
;	.###..#.#..#.#..
;	.#....#....#....
;	################

	HEX	FF FF FF FF FF 43 43 5F  FF FF FF FF FF FF FF FF
	HEX	5F 5F 42 72 72 72 42 FF  FF FF 10 94 94 94 10 FF

;	################	(08) "2500"
;	################
;	################
;	################
;	################
;	....#....#######
;	....#....#######
;	##..#.##########
;	##..#.##########
;	##..#.##########
;	....#....#......
;	.######..#.#..#.
;	.######..#.#..#.
;	.######..#.#..#.
;	....#....#......
;	################

	HEX	FF FF FF FF FF 08 08 CB  FF FF FF FF FF 7F 7F FF
	HEX	CB CB 08 7E 7E 7E 08 FF  FF FF 40 52 52 52 40 FF

;	################	(09) "500"
;	################
;	################
;	################
;	################
;	#....###########
;	#....###########
;	#.##############
;	#.##############
;	#.##############
;	#....#....#....#
;	###..#.#..#.#..#
;	###..#.#..#.#..#
;	###..#.#..#.#..#
;	#....#....#....#
;	################

	HEX	FF FF FF FF FF 87 87 BF  FF FF FF FF FF FF FF FF
	HEX	BF BF 84 E5 E5 E5 84 FF  FF FF 21 29 29 29 21 FF

; color table for power-ups
D65D4	HEX	AA DA DA DA DF DF DF DF	; C-20 (00) heart
	HEX	AA DA DA DD DD DD DD DD	; C-21
	HEX	DF DF DA DA DA DA DA DA	; C-22
	HEX	DD DD DA DA DA DA DA DA	; C-23
N65D4	EQU	$-D65D4
	HEX	A2 CA DA DA DA DA DA DA	; (01) bouquet
	HEX	A9 A9 A9 A9 A9 A9 A2 CA
	HEX	A2 CA CF CF 9F 9F 9F AF
	HEX	A9 A9 A9 A9 A9 A9 A2 CA

	HEX	A7 A7 A5 A4 A5 5F 5F 5F	; (02) clock
	HEX	A7 A7 A5 A4 A5 5F 5F 5F
	HEX	5F 5F 5F 5F 5F 5F 5F A4
	HEX	5F 5F 5F 5F 5F 5F 5F A4

	HEX	AF AF AF FF 1F 1F 1F 1F	; (03) skull
	HEX	AF AF AF FF 1F 1F 1F 1F
	HEX	1F FF AF AF AF AF AF AF
	HEX	1F FF AF AF AF AF AF AF

	HEX	CA CA CA CA CA A2 32 3F	; (04) apple
	HEX	A2 CA AA CA CA CA C2 C2
	HEX	3F 3F 32 C2 A2 CA CA CA
	HEX	C2 C2 C2 C2 CA CA CA CA

	HEX	AA CA CA CA CA CA CA CA	; (05) cherries
	HEX	CA CA CA CA CA CA CA A9
	HEX	A9 A9 A9 9F 9F 98 A8 A8
	HEX	A9 9F 9F A9 9A A8 A8 AA

	HEX	CA CA CA CA A4 A4 A4 A4	; (06) grapes
	HEX	CA CA CA CA CA A4 A4 A4
	HEX	A4 A4 A4 A4 A4 A4 A4 A4
	HEX	A4 A4 A4 A4 AA AA AA AA

; color table for bonus scores
D66B4	HEX	A0 A0 A0 A0 A0 A0 A0 A0	; (07) 1500 (08) 2500 (09) 500
	HEX	A0 A0 A0 A0 A0 A0 A0 A0
	HEX	A0 A0 A0 A0 A0 A0 A0 A0
	HEX	A0 A0 A0 A0 A0 A0 A0 A0
N66B4	EQU	$-D66B4

D66D4
	DB	00000000B	; 00
	DB	00000000B
	DB	00000011B
	DB	00001111B
	DB	00011111B
	DB	00111111B
	DB	01111111B
	DB	01111100B

	DB	00000000B	; 
	DB	11111110B
	DB	11111111B
	DB	11111111B
	DB	11111111B
	DB	11111111B
	DB	00001111B
	DB	00000011B

	DB	00000000B	; 
	DB	00000000B
	DB	10000000B
	DB	11000000B
	DB	11000001B
	DB	11100001B
	DB	11100011B
	DB	11100011B

	DB	00000000B	; 
	DB	00000000B
	DB	00111000B
	DB	11111100B
	DB	11111100B
	DB	11111100B
	DB	11111100B
	DB	11111000B

	DB	00000000B	; 04
	DB	00000000B
	DB	00000011B
	DB	00001111B
	DB	00001111B
	DB	00011111B
	DB	00011110B
	DB	00011110B

	DB	00000000B	; 
	DB	00000000B
	DB	11111000B
	DB	11111110B
	DB	11111111B
	DB	00011111B
	DB	00000111B
	DB	00000011B

	DB	00000000B	; 
	DB	00000000B
	DB	00000011B
	DB	00000111B
	DB	00000111B
	DB	00001111B
	DB	10001111B
	DB	10011111B

	DB	00000000B	; 
	DB	00000000B
	DB	11000000B
	DB	11100000B
	DB	11100000B
	DB	11100000B
	DB	11000000B
	DB	10000000B

	DB	00000000B	; 08
	DB	00111110B
	DB	01111111B
	DB	11111111B
	DB	11111111B
	DB	11111111B
	DB	01111111B
	DB	00111110B

	DB	00000000B	; 
	DB	00000000B
	DB	00000011B
	DB	10000111B
	DB	10001111B
	DB	10001111B
	DB	00011110B
	DB	00011110B

	DB	00000000B	; 
	DB	01111000B
	DB	11111111B
	DB	11111111B
	DB	11111111B
	DB	00001111B
	DB	00000111B
	DB	00000111B

	DB	00000000B	; 
	DB	00000000B
	DB	00000000B
	DB	10000000B
	DB	11000000B
	DB	11000000B
	DB	11000000B
	DB	11000000B

	DB	01111000B	; 0C
	DB	11111000B
	DB	11110000B
	DB	11110000B
	DB	11110000B
	DB	11110000B
	DB	11110000B
	DB	11111000B

	DB	00000011B	; 
	DB	00000001B
	DB	00000000B
	DB	00000111B
	DB	00001111B
	DB	00001111B
	DB	00001111B
	DB	00000111B

	DB	11100011B	; 
	DB	11000001B
	DB	00000001B
	DB	10000001B
	DB	11100001B
	DB	11110000B
	DB	11110000B
	DB	11111000B

	DB	11111000B	; 
	DB	11111000B
	DB	11110000B
	DB	11110000B
	DB	11110000B
	DB	11111000B
	DB	11111000B
	DB	11111000B

	DB	00111100B	; 10
	DB	00111100B
	DB	00111100B
	DB	01111110B
	DB	01111111B
	DB	01111111B
	DB	01111111B
	DB	01111101B

	DB	00000011B	; 
	DB	00000011B
	DB	00000111B
	DB	00011111B
	DB	11111111B
	DB	11111111B
	DB	11111110B
	DB	11111000B

	DB	10011111B	; 
	DB	10011111B
	DB	10011111B
	DB	10111110B
	DB	00111110B
	DB	00111110B
	DB	00111100B
	DB	00111100B

	DB	10000000B	; 
	DB	00000000B
	DB	00000000B
	DB	00000000B
	DB	00000000B
	DB	00000000B
	DB	00000000B
	DB	00000000B

	DB	01110000B	; 14
	DB	00000000B
	DB	00000000B
	DB	00000000B
	DB	00000000B
	DB	00000000B
	DB	00000000B
	DB	00000000B

	DB	00011110B	; 
	DB	00011110B
	DB	00001111B
	DB	00000111B
	DB	00000011B
	DB	00000000B
	DB	01110000B
	DB	11111000B

	DB	00000011B	; 
	DB	00000001B
	DB	00000000B
	DB	11110000B
	DB	11111100B
	DB	01111110B
	DB	00011111B
	DB	00001111B

	DB	11000000B	; 
	DB	10000000B
	DB	00000000B
	DB	00000000B
	DB	00000000B
	DB	00000000B
	DB	00000000B
	DB	00000000B

	DB	11111000B	; 18
	DB	01111100B
	DB	00111111B
	DB	00111111B
	DB	00011111B
	DB	00001111B
	DB	00000011B
	DB	00000000B

	DB	00000011B	; 
	DB	00000011B
	DB	00000111B
	DB	11111111B
	DB	11111111B
	DB	11111101B
	DB	11110000B
	DB	00000000B

	DB	11111000B	; 
	DB	11111000B
	DB	11111000B
	DB	11111000B
	DB	11110000B
	DB	11110000B
	DB	11100000B
	DB	00000000B

	DB	11111100B	; 
	DB	11111110B
	DB	01111110B
	DB	01111111B
	DB	01111111B
	DB	00111111B
	DB	00001110B
	DB	00000000B

	DB	01111100B	; 1C
	DB	01111100B
	DB	00111110B
	DB	00111110B
	DB	00111110B
	DB	00111100B
	DB	00011000B
	DB	00000000B

	DB	11110000B	; 
	DB	01111100B
	DB	01111110B
	DB	00111111B
	DB	00111111B
	DB	00011111B
	DB	00001110B
	DB	00000000B

	DB	00111110B	; 
	DB	00111110B
	DB	00011111B
	DB	00011111B
	DB	00001111B
	DB	00000111B
	DB	00000001B
	DB	00000000B

	DB	00000011B	; 
	DB	00000111B
	DB	00011111B
	DB	11111111B
	DB	11111111B
	DB	11111111B
	DB	11111000B
	DB	00000000B

	DB	10000000B	; 20
	DB	11000000B
	DB	11000000B
	DB	11000000B
	DB	10000000B
	DB	00000000B
	DB	00000000B
	DB	00000000B

	DB	11111000B	; 
	DB	11111000B
	DB	11111100B
	DB	01111111B
	DB	00111111B
	DB	00011111B
	DB	00000011B
	DB	00000000B

	DB	00001111B	; 
	DB	00001111B
	DB	00111110B
	DB	11111110B
	DB	11111100B
	DB	11110000B
	DB	11000000B
	DB	00000000B

	DB	00000000B	; 
	DB	00000000B
	DB	00000000B
	DB	00000000B
	DB	00000000B
	DB	00000000B
	DB	00000000B
	DB	00000000B

	DB	00000000B	; 24
	DB	00000000B
	DB	00000000B
	DB	00000000B
	DB	00000000B
	DB	00000001B
	DB	00000011B
	DB	00000111B

	DB	00000000B	; 
	DB	00000000B
	DB	00000011B
	DB	00011111B
	DB	01111111B
	DB	11111111B
	DB	11111111B
	DB	11111111B

	DB	00000000B	; 
	DB	00000000B
	DB	11111100B
	DB	11111111B
	DB	11111111B
	DB	11111111B
	DB	11111111B
	DB	11111111B

	DB	00000000B	; 
	DB	00000000B
	DB	00000000B
	DB	00000000B
	DB	10000000B
	DB	11000000B
	DB	11000000B
	DB	11100000B

	DB	00000000B	; 28
	DB	00000000B
	DB	00000000B
	DB	00000000B
	DB	00000000B
	DB	00000000B
	DB	00000001B
	DB	00000111B

	DB	00000000B	; 
	DB	00000000B
	DB	00000000B
	DB	00000000B
	DB	00000000B
	DB	00000000B
	DB	11110000B
	DB	11111100B

	DB	00000000B	; 
	DB	00000000B
	DB	00000001B
	DB	00000111B
	DB	00001111B
	DB	00011111B
	DB	00111111B
	DB	00111111B

	DB	00000000B	; 
	DB	00000000B
	DB	11111100B
	DB	11111111B
	DB	11111111B
	DB	11111111B
	DB	11111111B
	DB	11111111B

	DB	00000000B	; 2C
	DB	00000000B
	DB	00000000B
	DB	10000000B
	DB	11100000B
	DB	11100000B
	DB	11110000B
	DB	11110000B

	DB	00000000B	; 
	DB	00000000B
	DB	00000011B
	DB	00001111B
	DB	00011111B
	DB	00111111B
	DB	01111111B
	DB	01111111B

	DB	00000000B	; 
	DB	00000000B
	DB	11111100B
	DB	11111111B
	DB	11111111B
	DB	11111111B
	DB	11111111B
	DB	11111111B

	DB	00000000B	; 
	DB	00000000B
	DB	00000000B
	DB	00000000B
	DB	10000001B
	DB	10000011B
	DB	11000111B
	DB	11000111B

	DB	00000000B	; 30
	DB	00000000B
	DB	00000000B
	DB	11100000B
	DB	11110000B
	DB	11110000B
	DB	11111000B
	DB	11111000B

	DB	00000000B	; 
	DB	00000000B
	DB	00000111B
	DB	00001111B
	DB	00011111B
	DB	00011111B
	DB	00011111B
	DB	00111111B

	DB	00000000B	; 
	DB	00000000B
	DB	00000000B
	DB	10000000B
	DB	11000000B
	DB	11000000B
	DB	11000000B
	DB	11000000B

	DB	00001111B	; 
	DB	00001111B
	DB	00011111B
	DB	00011111B
	DB	00011111B
	DB	00111111B
	DB	00111111B
	DB	00111111B

	DB	11111110B	; 34
	DB	11111000B
	DB	11100000B
	DB	11000000B
	DB	11000000B
	DB	10000000B
	DB	10000000B
	DB	00000001B

	DB	00111111B	; 
	DB	00001111B
	DB	00001111B
	DB	00000111B
	DB	00000000B
	DB	00000000B
	DB	01111110B
	DB	11111111B

	DB	11100000B	; 
	DB	11100000B
	DB	11100000B
	DB	11000000B
	DB	00000000B
	DB	00000000B
	DB	00000001B
	DB	10000001B

	DB	00001111B	; 
	DB	00011111B
	DB	00111111B
	DB	01111111B
	DB	11111111B
	DB	11111110B
	DB	11111100B
	DB	11111001B

	DB	11111110B	; 38
	DB	11111111B
	DB	11111111B
	DB	11111111B
	DB	11111111B
	DB	00011111B
	DB	11001111B
	DB	11100111B

	DB	00000000B	; 
	DB	00000000B
	DB	10000000B
	DB	10000000B
	DB	11000000B
	DB	11000001B
	DB	11100001B
	DB	11100001B

	DB	01111111B	; 
	DB	01111110B
	DB	11111100B
	DB	11111101B
	DB	11111101B
	DB	11111101B
	DB	11111100B
	DB	11111110B

	DB	10000111B	; 
	DB	00110001B
	DB	11111100B
	DB	11111110B
	DB	11111110B
	DB	11111110B
	DB	11111100B
	DB	00110001B

	DB	11111000B	; 3C
	DB	11111000B
	DB	11111000B
	DB	11111000B
	DB	11111000B
	DB	11110001B
	DB	11110001B
	DB	11100001B

	DB	00000000B	; 
	DB	00000000B
	DB	01111111B
	DB	11111111B
	DB	11111111B
	DB	11111111B
	DB	11111111B
	DB	11111111B

	DB	00000000B	; 
	DB	00000000B
	DB	11100000B
	DB	11111100B
	DB	11111111B
	DB	11111111B
	DB	11111111B
	DB	11111111B

	DB	00000000B	; 
	DB	00000000B
	DB	00000001B
	DB	00000001B
	DB	00000001B
	DB	10000011B
	DB	11000011B
	DB	11100011B

	DB	11111111B	; 40
	DB	11111110B
	DB	11111100B
	DB	11111000B
	DB	11111000B
	DB	11111001B
	DB	11111111B
	DB	11111111B

	DB	11111111B	; 
	DB	00011110B
	DB	00000000B
	DB	00000000B
	DB	00111100B
	DB	11111110B
	DB	11111111B
	DB	11111111B

	DB	10001111B	; 
	DB	00001111B
	DB	00001111B
	DB	00001111B
	DB	00011111B
	DB	00011111B
	DB	00011111B
	DB	00011111B

	DB	11111100B	; 
	DB	11111110B
	DB	11111110B
	DB	11111110B
	DB	11111111B
	DB	11011111B
	DB	10011111B
	DB	10001111B

	DB	00111111B	; 44
	DB	00111111B
	DB	00111111B
	DB	00111111B
	DB	00111111B
	DB	00111111B
	DB	10111111B
	DB	10011111B

	DB	11000000B	; 
	DB	11000000B
	DB	11000000B
	DB	10000000B
	DB	10000000B
	DB	10000000B
	DB	10000000B
	DB	00000000B

	DB	00111111B	; 
	DB	00111111B
	DB	00111111B
	DB	00111111B
	DB	00111111B
	DB	00111111B
	DB	00111111B
	DB	00011111B

	DB	00000011B	; 
	DB	00000011B
	DB	00000011B
	DB	00000001B
	DB	10000000B
	DB	10000000B
	DB	11000000B
	DB	11110001B

	DB	11111111B	; 48
	DB	11111111B
	DB	11111111B
	DB	11111111B
	DB	00111111B
	DB	00111111B
	DB	01111111B
	DB	11111111B

	DB	11000011B	; 
	DB	11000011B
	DB	11100111B
	DB	11100111B
	DB	11100111B
	DB	11100111B
	DB	11101111B
	DB	11001111B

	DB	11111011B	; 
	DB	11110011B
	DB	11110111B
	DB	11110000B
	DB	11110111B
	DB	11111111B
	DB	11111111B
	DB	11111111B

	DB	11110111B	; 
	DB	11110011B
	DB	11111011B
	DB	00011011B
	DB	11000011B
	DB	11111011B
	DB	11111111B
	DB	11111111B

	DB	11100001B	; 4C
	DB	11110001B
	DB	11110001B
	DB	11110001B
	DB	11111001B
	DB	11111001B
	DB	11111001B
	DB	11111001B

	DB	11111111B	; 
	DB	11111111B
	DB	11111111B
	DB	11111111B
	DB	11111110B
	DB	11111110B
	DB	11111110B
	DB	11111110B

	DB	10000111B	; 
	DB	11111111B
	DB	11111111B
	DB	11111110B
	DB	01111111B
	DB	00111111B
	DB	00111111B
	DB	00011111B

	DB	11100001B	; 
	DB	11000001B
	DB	00000001B
	DB	00000001B
	DB	00000001B
	DB	11000001B
	DB	11100001B
	DB	11110001B

	DB	11111000B	; 50
	DB	11110011B
	DB	11110100B
	DB	11110101B
	DB	11110101B
	DB	11110101B
	DB	11110101B
	DB	11110101B

	DB	00011111B	; 
	DB	11001111B
	DB	00100111B
	DB	10010011B
	DB	01001011B
	DB	00101001B
	DB	00100101B
	DB	00010101B

	DB	11100011B	; 
	DB	11110011B
	DB	11110011B
	DB	11110011B
	DB	11111011B
	DB	11111011B
	DB	11111011B
	DB	11111001B

	DB	11111111B	; 
	DB	11111111B
	DB	11111111B
	DB	11111111B
	DB	11111000B
	DB	11110000B
	DB	11110000B
	DB	11111000B

	DB	11111111B	; 54
	DB	11111110B
	DB	11110000B
	DB	00000000B
	DB	00000000B
	DB	00000111B
	DB	00011111B
	DB	01111111B

	DB	00011111B	; 
	DB	00011111B
	DB	00011111B
	DB	00011111B
	DB	00011111B
	DB	00011111B
	DB	10011111B
	DB	11001111B

	DB	10001111B	; 
	DB	10001111B
	DB	10000111B
	DB	11000111B
	DB	11000011B
	DB	11100011B
	DB	11111001B
	DB	11111101B

	DB	11011111B	; 
	DB	11011111B
	DB	11101111B
	DB	11101111B
	DB	11111111B
	DB	11111111B
	DB	11111111B
	DB	11111111B

	DB	00000000B	; 58
	DB	10000000B
	DB	10000000B
	DB	10000000B
	DB	11000000B
	DB	11000000B
	DB	11000000B
	DB	11000000B

	DB	00011111B	; 
	DB	00001111B
	DB	00001111B
	DB	00000111B
	DB	00000011B
	DB	00000000B
	DB	00000000B
	DB	00000000B

	DB	11111111B	; 
	DB	11111111B
	DB	11111111B
	DB	11111111B
	DB	11111111B
	DB	01111111B
	DB	00000000B
	DB	00000000B

	DB	11111111B	; 
	DB	11111111B
	DB	11111111B
	DB	11101111B
	DB	11001111B
	DB	00000111B
	DB	00000000B
	DB	00000000B

	DB	11001111B	; 5C
	DB	11001111B
	DB	11001111B
	DB	10001111B
	DB	10001111B
	DB	00001111B
	DB	00001111B
	DB	00000111B

	DB	11111111B	; 
	DB	11110111B
	DB	11110000B
	DB	11110000B
	DB	11110000B
	DB	11110000B
	DB	11110000B
	DB	11100000B

	DB	11111111B	; 
	DB	11111111B
	DB	01111011B
	DB	00000011B
	DB	00000011B
	DB	00000011B
	DB	00000011B
	DB	00000001B

	DB	11111101B	; 
	DB	11111100B
	DB	11111100B
	DB	11111100B
	DB	11111100B
	DB	11111100B
	DB	11111100B
	DB	11111000B

	DB	11111110B	; 60
	DB	11111110B
	DB	11111110B
	DB	11111110B
	DB	11111100B
	DB	01111000B
	DB	00000000B
	DB	00000000B

	DB	00011111B	; 
	DB	00001111B
	DB	00001111B
	DB	00000111B
	DB	00000111B
	DB	00000001B
	DB	00000000B
	DB	00000000B

	DB	11111001B	; 
	DB	11111001B
	DB	11111001B
	DB	11111001B
	DB	11110001B
	DB	11100001B
	DB	00000001B
	DB	00000001B

	DB	11110101B	; 
	DB	11110101B
	DB	11110101B
	DB	11110101B
	DB	11110101B
	DB	11110100B
	DB	11110010B
	DB	11111001B

	DB	00010101B	; 64
	DB	00010101B
	DB	00010101B
	DB	00010101B
	DB	00101001B
	DB	11001011B
	DB	00110011B
	DB	11000111B

	DB	11111001B	; 
	DB	11111001B
	DB	11111000B
	DB	11111000B
	DB	11111000B
	DB	11111000B
	DB	11110000B
	DB	11110000B

	DB	11111111B	; 
	DB	11111111B
	DB	11111111B
	DB	11111111B
	DB	01111111B
	DB	00001111B
	DB	00000000B
	DB	00000000B

	DB	11111111B	; 
	DB	11111111B
	DB	11111111B
	DB	11111111B
	DB	11111110B
	DB	11110000B
	DB	00000000B
	DB	00000000B

	DB	11001111B	; 68
	DB	11001111B
	DB	10000111B
	DB	10000111B
	DB	00001111B
	DB	00011111B
	DB	00111111B
	DB	00111110B

	DB	11111100B	; 
	DB	11111100B
	DB	11111100B
	DB	11111100B
	DB	11111000B
	DB	11110000B
	DB	10000000B
	DB	00000000B

	DB	11111111B	; 
	DB	01111111B
	DB	00111111B
	DB	00011111B
	DB	00001111B
	DB	00000011B
	DB	00000000B
	DB	00000000B

	DB	11000000B	; 
	DB	11100000B
	DB	11100000B
	DB	11100000B
	DB	11100000B
	DB	11000000B
	DB	00000000B
	DB	00000000B

	DB	00000111B	; 6C
	DB	00000011B
	DB	00000000B
	DB	00000000B
	DB	00000000B
	DB	00000000B
	DB	00000000B
	DB	00000000B

	DB	11100000B	; 
	DB	11000000B
	DB	00000000B
	DB	00000000B
	DB	00000000B
	DB	00000000B
	DB	00000000B
	DB	00000000B

	DB	00000001B	; 
	DB	00000000B
	DB	00000000B
	DB	00000000B
	DB	00000000B
	DB	00000000B
	DB	00000000B
	DB	00000000B

	DB	11111000B	; 
	DB	11110000B
	DB	00000000B
	DB	00000000B
	DB	00000000B
	DB	00000000B
	DB	00000000B
	DB	00000000B

	DB	00000001B	; 70
	DB	00000001B
	DB	00000000B
	DB	00000000B
	DB	00000000B
	DB	00000000B
	DB	00000000B
	DB	00000000B

	DB	11111100B	; 
	DB	11111111B
	DB	11111111B
	DB	11111111B
	DB	01111111B
	DB	00011111B
	DB	00000000B
	DB	00000000B

	DB	00011111B	; 
	DB	11111111B
	DB	11111111B
	DB	11111111B
	DB	11111110B
	DB	11110000B
	DB	00000000B
	DB	00000000B

	DB	11100000B	; 
	DB	11100000B
	DB	11000000B
	DB	10000000B
	DB	00000000B
	DB	00000000B
	DB	00000000B
	DB	00000000B

	DB	00000000B	; 74
	DB	00000000B
	DB	00000000B
	DB	00000000B
	DB	00000000B
	DB	00000000B
	DB	00000011B
	DB	00001110B

	DB	00000000B	; 
	DB	00000000B
	DB	00000000B
	DB	00000001B
	DB	00000111B
	DB	00111111B
	DB	11111100B
	DB	00000000B

	DB	01111000B	; 
	DB	01111000B
	DB	01111100B
	DB	11111100B
	DB	11111000B
	DB	11100000B
	DB	00000000B
	DB	00000000B

	DB	00011000B	; 
	DB	00011000B
	DB	00001100B
	DB	00000110B
	DB	00000010B
	DB	00001100B
	DB	01110000B
	DB	10000000B

	DB	00000001B	; 78
	DB	00000010B
	DB	00000010B
	DB	00000000B
	DB	01111111B
	DB	01111111B
	DB	00111111B
	DB	00111111B

	DB	00000000B	; 
	DB	00000000B
	DB	00000000B
	DB	00000000B
	DB	10000000B
	DB	10000000B
	DB	00000000B
	DB	00000000B

	DB	00000000B	; 
	DB	00000000B
	DB	00000000B
	DB	00000000B
	DB	00000000B
	DB	00000000B
	DB	00000001B
	DB	00001111B

	DB	00000000B	; 
	DB	00000000B
	DB	00000000B
	DB	00000000B
	DB	00000111B
	DB	00111111B
	DB	11111111B
	DB	00000011B

	DB	00000000B	; 7C
	DB	00000011B
	DB	00011111B
	DB	11111111B
	DB	00000001B
	DB	00001111B
	DB	01111111B
	DB	11111111B

	DB	00111111B	; 
	DB	00111111B
	DB	00000111B
	DB	11111111B
	DB	10000000B
	DB	11110000B
	DB	11111110B
	DB	11111111B

	DB	00000000B	; 
	DB	00000000B
	DB	00000000B
	DB	00000000B
	DB	11100000B
	DB	11111100B
	DB	11111111B
	DB	11000000B

	DB	00000000B	; 
	DB	00000000B
	DB	00000000B
	DB	00000000B
	DB	00000000B
	DB	00000000B
	DB	10000000B
	DB	11110000B

	DB	01111111B	; 80
	DB	01111111B
	DB	01111000B
	DB	00000000B
	DB	00000000B
	DB	00000000B
	DB	00000000B
	DB	00000000B

	DB	00011111B	; 
	DB	01000000B
	DB	01011100B
	DB	01000000B
	DB	01011100B
	DB	01000000B
	DB	01011100B
	DB	01000000B

	DB	11111111B	; 
	DB	11111111B
	DB	11110111B
	DB	11110111B
	DB	11110111B
	DB	11111111B
	DB	11110111B
	DB	11110111B

	DB	11111111B	; 
	DB	00000001B
	DB	10011101B
	DB	10000001B
	DB	10011101B
	DB	00000001B
	DB	10011101B
	DB	10000001B

	DB	11111000B	; 84
	DB	11111110B
	DB	11111110B
	DB	11111110B
	DB	11111110B
	DB	11111110B
	DB	11111110B
	DB	11111110B

	DB	11111110B	; 
	DB	11111110B
	DB	00011110B
	DB	00000000B
	DB	00000000B
	DB	00000000B
	DB	00000000B
	DB	00000000B

	DB	01011100B	; 
	DB	01000000B
	DB	01011100B
	DB	01000000B
	DB	01011100B
	DB	01000000B
	DB	01111111B
	DB	01111111B

	DB	11110111B	; 
	DB	11111111B
	DB	11110111B
	DB	11110111B
	DB	11110111B
	DB	11111111B
	DB	11111111B
	DB	11111111B

	DB	10011101B	; 88
	DB	00000001B
	DB	10011101B
	DB	10000001B
	DB	10011101B
	DB	00000001B
	DB	11111111B
	DB	11111111B

	DB	11111110B	; 
	DB	11111111B
	DB	01111110B
	DB	01000010B
	DB	01000010B
	DB	01000010B
	DB	01111110B
	DB	01111110B

	DB	01111111B	; 
	DB	01111111B
	DB	01111111B
	DB	01111111B
	DB	11111111B
	DB	01111111B
	DB	01111111B
	DB	01010000B

	DB	11111111B	; 
	DB	11111111B
	DB	11111111B
	DB	11111111B
	DB	11111111B
	DB	11111111B
	DB	11111111B
	DB	10010000B

	DB	01111110B	; 8C
	DB	01011110B
	DB	01111110B
	DB	01111110B
	DB	01111110B
	DB	01111110B
	DB	01111110B
	DB	10100100B

	DB	00000000B	; 
	DB	00000000B
	DB	00111100B
	DB	01111110B
	DB	01111111B
	DB	11111111B
	DB	11111111B
	DB	01111110B

	DB	00000000B	; 
	DB	00000000B
	DB	00000000B
	DB	00000000B
	DB	00000001B
	DB	00000001B
	DB	00000011B
	DB	00000011B

	DB	00000000B	; 
	DB	00000000B
	DB	00000000B
	DB	11000000B
	DB	11100001B
	DB	11110001B
	DB	11110011B
	DB	11111011B

	DB	00000000B	; 90
	DB	00000000B
	DB	00000000B
	DB	11000000B
	DB	11100000B
	DB	11110000B
	DB	11110000B
	DB	11111000B

	DB	00000000B	; 
	DB	00000000B
	DB	00000000B
	DB	00000000B
	DB	00000001B
	DB	00000001B
	DB	00000011B
	DB	00000011B

	DB	00000000B	; 
	DB	00000000B
	DB	00000000B
	DB	11000000B
	DB	11100000B
	DB	11110000B
	DB	11110000B
	DB	11111000B

	DB	00000111B	; 
	DB	00000111B
	DB	00000111B
	DB	00000111B
	DB	00000011B
	DB	00000000B
	DB	00000000B
	DB	01010100B

	DB	11111111B	; 94
	DB	11111111B
	DB	11111111B
	DB	11111111B
	DB	11110011B
	DB	11000000B
	DB	11000000B
	DB	11000000B

	DB	11111000B	; 
	DB	11111000B
	DB	11111000B
	DB	11111000B
	DB	11110000B
	DB	11000000B
	DB	11000000B
	DB	11000000B

	DB	00000111B	; 
	DB	00000111B
	DB	00000111B
	DB	00000111B
	DB	00000011B
	DB	00000000B
	DB	00000000B
	DB	10011010B

	DB	11111000B	; 
	DB	11111000B
	DB	11111000B
	DB	11111000B
	DB	11110000B
	DB	11000000B
	DB	11000000B
	DB	11000000B

	DB	00000000B	; 98
	DB	00000000B
	DB	00111100B
	DB	01111110B
	DB	01111111B
	DB	11111111B
	DB	11111111B
	DB	01111110B

	DB	00000000B	; 
	DB	00000000B
	DB	00000000B
	DB	00000000B
	DB	00000011B
	DB	00000111B
	DB	00000111B
	DB	00001111B

	DB	00000000B	; 
	DB	00000000B
	DB	00000000B
	DB	11100000B
	DB	11111000B
	DB	11111000B
	DB	11111100B
	DB	11111100B

	DB	00001111B	; 
	DB	00011111B
	DB	00011111B
	DB	00111111B
	DB	00111111B
	DB	00111111B
	DB	00111111B
	DB	00111111B

	DB	11111110B	; 9C
	DB	11111110B
	DB	11111111B
	DB	11111111B
	DB	11111111B
	DB	11111111B
	DB	11111111B
	DB	11111111B

	DB	00011111B	; 
	DB	00011111B
	DB	00001111B
	DB	00000011B
	DB	00000001B
	DB	00000001B
	DB	00000001B
	DB	00000001B

	DB	11111110B	; 
	DB	11111110B
	DB	11111100B
	DB	11110000B
	DB	11100000B
	DB	11100000B
	DB	11100000B
	DB	11100000B

	DB	00000000B	; 
	DB	00000000B
	DB	00000000B
	DB	11100001B
	DB	11111100B
	DB	11111100B
	DB	11111100B
	DB	11111100B

	DB	00000000B	; A0
	DB	00000000B
	DB	00000000B
	DB	11100000B
	DB	11111000B
	DB	11111000B
	DB	11111100B
	DB	11111100B

	DB	11111110B	; 
	DB	11111110B
	DB	11111111B
	DB	11111111B
	DB	11111111B
	DB	11111111B
	DB	11111111B
	DB	11111111B

	DB	11111110B	; 
	DB	11111110B
	DB	11111111B
	DB	11111111B
	DB	11111111B
	DB	11111111B
	DB	11111111B
	DB	11111111B

	DB	11111110B	; 
	DB	11111110B
	DB	11111100B
	DB	11110000B
	DB	11100001B
	DB	11100001B
	DB	11100001B
	DB	11100001B

	DB	11111110B	; A4
	DB	11111110B
	DB	11111100B
	DB	11110000B
	DB	11100000B
	DB	11100000B
	DB	11100000B
	DB	11100000B

	DB	00000000B	; 
	DB	00000000B
	DB	00000000B
	DB	00000000B
	DB	00000001B
	DB	00000001B
	DB	00000011B
	DB	00000011B

	DB	00000000B	; 
	DB	00000000B
	DB	00000000B
	DB	11000000B
	DB	11100000B
	DB	11110000B
	DB	11110000B
	DB	11111000B

	DB	00000111B	; 
	DB	00000111B
	DB	00000111B
	DB	00000111B
	DB	00000011B
	DB	00000000B
	DB	00000000B
	DB	10010101B

	DB	11111000B	; A8
	DB	11111000B
	DB	11111000B
	DB	11111000B
	DB	11110000B
	DB	11000000B
	DB	11000000B
	DB	11000000B

	DB	00000000B	; 
	DB	00000000B
	DB	00000000B
	DB	00000000B
	DB	00000000B
	DB	00000000B
	DB	00000000B
	DB	10010000B

	DB	00000000B	; 
	DB	00000000B
	DB	00000000B
	DB	00000000B
	DB	00000000B
	DB	00000000B
	DB	00000000B
	DB	01010100B

	DB	00000000B	; 
	DB	00000000B
	DB	00000000B
	DB	00000000B
	DB	00000000B
	DB	00000000B
	DB	00000000B
	DB	01000110B

	DB	00000000B	; AC
	DB	00000000B
	DB	00000000B
	DB	00000000B
	DB	00000000B
	DB	00000000B
	DB	00000000B
	DB	01000100B

	DB	00000000B	; 
	DB	00000000B
	DB	00000000B
	DB	00000000B
	DB	00000000B
	DB	00000000B
	DB	00000000B
	DB	00101001B

	DB	00000000B	; 
	DB	00000000B
	DB	00000000B
	DB	00000000B
	DB	00000000B
	DB	00000000B
	DB	00000000B
	DB	10100001B

	DB	00000000B	; 
	DB	00000000B
	DB	00000000B
	DB	00000000B
	DB	00000000B
	DB	00000000B
	DB	00000000B
	DB	01011000B

	DB	00000000B	; B0
	DB	00000000B
	DB	00000000B
	DB	00000000B
	DB	00000000B
	DB	00000000B
	DB	00000000B
	DB	00100010B

	DB	00000000B	; 
	DB	00000000B
	DB	00000000B
	DB	00000000B
	DB	00000000B
	DB	00000000B
	DB	00000000B
	DB	00101000B

	DB	00000000B	; 
	DB	00000000B
	DB	00000000B
	DB	00000000B
	DB	00000000B
	DB	00000000B
	DB	00000000B
	DB	01000000B

	DB	11111111B	; 
	DB	11111111B
	DB	00000000B
	DB	00000000B
	DB	00000000B
	DB	00000000B
	DB	00000000B
	DB	00000000B

	DB	11111111B	; B4
	DB	11111111B
	DB	00110000B
	DB	00000101B
	DB	00000000B
	DB	00000000B
	DB	00000000B
	DB	00000000B

	DB	11111111B	; 
	DB	11111111B
	DB	11011101B
	DB	00010111B
	DB	00000000B
	DB	00000000B
	DB	00000000B
	DB	00000000B

	DB	11111111B	; 
	DB	11111111B
	DB	11101111B
	DB	00100000B
	DB	00000000B
	DB	00000000B
	DB	00000000B
	DB	00000000B

	DB	11111111B	; 
	DB	11111111B
	DB	00111010B
	DB	11001011B
	DB	00000101B
	DB	00000000B
	DB	00000000B
	DB	00000000B

	DB	11111111B	; B8
	DB	11111111B
	DB	01111111B
	DB	10010111B
	DB	01011001B
	DB	00000000B
	DB	00000000B
	DB	00000000B

	DB	11111111B	; 
	DB	11111111B
	DB	11111111B
	DB	11010010B
	DB	10100000B
	DB	00000000B
	DB	00000000B
	DB	00000000B

	DB	11111111B	; 
	DB	11111111B
	DB	10111011B
	DB	11100000B
	DB	00001110B
	DB	00000000B
	DB	00000000B
	DB	00000000B

	DB	11111111B	; 
	DB	11111111B
	DB	11101111B
	DB	11111111B
	DB	10111001B
	DB	00000000B
	DB	00000000B
	DB	00000000B

	DB	11111111B	; BC
	DB	11111111B
	DB	11111101B
	DB	00101110B
	DB	11010100B
	DB	00000001B
	DB	00000000B
	DB	00000000B

	DB	11111111B	; 
	DB	11111111B
	DB	10111110B
	DB	01000101B
	DB	00110110B
	DB	00000000B
	DB	00000000B
	DB	00000000B

	DB	11111111B	; 
	DB	11111111B
	DB	00110101B
	DB	11101101B
	DB	10011010B
	DB	00100100B
	DB	00000000B
	DB	00000000B

	DB	11111111B	; 
	DB	11111111B
	DB	11111111B
	DB	10111111B
	DB	11001011B
	DB	00110101B
	DB	00000000B
	DB	00000000B

	DB	11111111B	; C0
	DB	11111111B
	DB	11111111B
	DB	11110110B
	DB	11101111B
	DB	10110000B
	DB	00000000B
	DB	00000000B

	DB	11111111B	; 
	DB	11111111B
	DB	11111111B
	DB	11011000B
	DB	01100000B
	DB	00000000B
	DB	00000000B
	DB	00000000B

	DB	11111111B	; 
	DB	11111111B
	DB	11010011B
	DB	10011111B
	DB	01100100B
	DB	00000000B
	DB	00000000B
	DB	00000000B

	DB	11111111B	; 
	DB	11111111B
	DB	01110110B
	DB	10111100B
	DB	10000000B
	DB	00000000B
	DB	00000000B
	DB	00000000B

	DB	11111111B	; C4
	DB	11111111B
	DB	11111111B
	DB	01011011B
	DB	00000000B
	DB	00000000B
	DB	00000000B
	DB	00000000B

	DB	11111111B	; 
	DB	11111111B
	DB	01111001B
	DB	10101100B
	DB	00000000B
	DB	00000000B
	DB	00000000B
	DB	00000000B

	DB	11111111B	; 
	DB	11111111B
	DB	01001111B
	DB	11100000B
	DB	00000000B
	DB	00000000B
	DB	00000000B
	DB	00000000B

	DB	11111111B	; 
	DB	11111111B
	DB	01010010B
	DB	10111110B
	DB	00000000B
	DB	00000000B
	DB	00000000B
	DB	00000000B

	DB	11111111B	; C8
	DB	11111111B
	DB	01001100B
	DB	10110000B
	DB	00000000B
	DB	00000000B
	DB	00000000B
	DB	00000000B

	DB	11111111B	; C9
	DB	11111111B
	DB	01000000B
	DB	00000000B
	DB	00000000B
	DB	00000000B
	DB	00000000B
	DB	00000000B

D6D24	HEX	F4 F4 F4 44 A4 A4 B4 B4	; CA
	HEX	44 44 44 44 A4 A4 44 44	; CB
	HEX	44 44 44 44 44 44 94 94	; CC
	HEX	44 44 44 44 94 94 99 F9	; CD
	HEX	44 94 94 99 F9 F9 F9 FF	; CE
	HEX	B4 B9 B9 99 F9 F9 F9 FF	; CF
	HEX	44 44 44 44 94 94 99 F9	; D0
	HEX	44 44 44 44 44 44 94 94	; D1
N66D4	EQU	$-D66D4	; the game will probably still work with this smaller
	HEX	94 94 94 44 44 44 44 44
	HEX	F9 F1 F1 F1 F1 F1 F1 F1
	HEX	FF 11 71 71 F1 11 71 71
	HEX	FF F1 F1 F1 F1 F1 F1 F1
	HEX	F9 F1 F1 F1 F1 F1 F1 F1
	HEX	94 94 94 44 44 44 44 44
	HEX	F1 F1 F1 F1 F1 F1 F1 F1
	HEX	F1 11 71 71 F1 11 FF FF
	HEX	F1 F1 F1 F1 F1 F1 FF FF
	HEX	F1 11 51 51 51 51 51 51
	HEX	F1 F1 F1 F1 11 61 61 31
	HEX	FF FF FF FF 11 66 66 31
	HEX	51 51 51 51 51 51 51 31
	HEX	44 44 24 24 24 22 22 24
	HEX	44 44 44 44 C4 C4 C4 C4
	HEX	44 44 44 C4 C4 C4 C4 C4
	HEX	44 44 44 C4 C4 C4 C4 C4
	HEX	44 44 44 44 24 24 24 24
	HEX	44 44 44 24 24 24 24 24
	HEX	C4 C4 C4 C4 C4 44 44 34
	HEX	CC CC CC CC C4 C4 84 84
	HEX	C4 C4 C4 C4 C4 C4 84 84
	HEX	24 24 24 24 24 44 44 34
	HEX	24 24 24 24 24 24 84 84
	HEX	44 44 C4 C4 C4 CC CC C4
	HEX	44 44 44 44 C4 C4 C4 C4
	HEX	44 44 44 C4 C4 C4 C4 C4
	HEX	C4 C4 C4 C4 C4 C4 C4 C4
	HEX	C4 C4 CC CC CC CC CC CC
	HEX	C4 C4 C4 C4 84 84 84 84
	HEX	C4 C4 C4 C4 84 84 84 84
	HEX	44 44 44 24 C2 C2 C2 C2
	HEX	44 44 44 24 24 24 24 24
	HEX	C2 C2 CC CC CC CC CC CC
	HEX	24 24 22 22 22 22 22 22
	HEX	C2 C2 C2 C2 84 84 84 84
	HEX	24 24 24 24 84 84 84 84
	HEX	44 44 44 44 C4 C4 C4 C4
	HEX	44 44 44 C4 C4 C4 C4 C4
	HEX	C4 C4 C4 C4 C4 44 44 34
	HEX	C4 C4 C4 C4 C4 C4 84 84
	HEX	00 00

;-----------------------------------------------------------------------

    IF      OPT
    ELSE
L6EAE	JP	L6EB4	; (unreachable)

L6EB1	JP	L7312		; silence PSG (unreachable)
    ENDIF

;-----------------------------------------------------------------------

; update music (?)
L6EB4	CALL	L6ECE
	LD	IX,DC204	; sound channel 1
	LD	B,NSCHN
L6EBD	PUSH	BC
	BIT	7,(IX+00H)
	CALL	NZ,L7079
	LD	DE,SCHNSZ
	ADD	IX,DE
	POP	BC
	DJNZ	L6EBD
	RET

;-----------------------------------------------------------------------

; start a new song?
L6ECE	LD	A,(DC200)
	BIT	7,A		; if byte is 00..7F,
	JP	Z,L7305		; clear sound channel memory and silence PSG
    IF      OPT	; if bit 7 is zero, CP 00 is redundant
    ELSE
	CP	00H		; if byte is 00,
	JP	Z,L7305		; clear sound channel memory and silence PSG
    ENDIF
	CP	0FFH		; if byte is FF,
	JP	Z,L7305		; clear sound channel memory and silence PSG

	LD	HL,D6EF3+N6EF3-1
	LD	BC,N6EF3
	CPDR			; search list for song IDs?
	RET	NZ		; return if byte not found

	LD	HL,D6F07	; look up address in second table
	ADD	HL,BC
	ADD	HL,BC
	LD	A,(HL)
	INC	HL
	LD	H,(HL)
	LD	L,A
	JP	(HL)		; execute set-up for selected song

D6EF3	DB	81H,82H,83H,84H,85H,86H,87H,88H
	DB	89H,8AH,8BH,8CH,8DH,90H,91H,92H
	DB	93H,94H,95H,96H
N6EF3	EQU	$-D6EF3

D6F07	DW	L6F2F,L6F3B,L6F47,L6F53,L6F5F,L6F73,L6F7F,L6F8B
	DW	L6F9F,L6FB3,L6FBF,L6FCB,L6FD7,L6FEB,L6FF7,L700B
	DW	L701F,L702B,L7037,L7043

; 81
L6F2F	CALL	L7305		; clear sound channel memory and silence PSG
	LD	HL,D740A
	LD	DE,DC204	; sound channel 1
	JP	L7054

;     82	= END
; 82
L6F3B	CALL	L7305		; clear sound channel memory and silence PSG
	LD	HL,D76DD
	LD	DE,DC204	; sound channel 1
	JP	L7054

; 83
L6F47	CALL	L7305		; clear sound channel memory and silence PSG
	LD	HL,D7779
	LD	DE,DC204	; sound channel 1
	JP	L7054

; 84
L6F53	CALL	L7305		; clear sound channel memory and silence PSG
	LD	HL,D7830
	LD	DE,DC204	; sound channel 1
	JP	L7054

;     85 xx xx = JUMP xxxx
; 85
L6F5F	LD	HL,DC201
	LD	(HL),06H
	CALL	L73B9
	CALL	L7312		; silence PSG
	LD	HL,D78F8
	LD	DE,DC274	; sound channel 5
	JP	L7054

;     86 xx xx = CALL xxxx
; 86
L6F73	CALL	L7305		; clear sound channel memory and silence PSG
	LD	HL,D7933
	LD	DE,DC258	; sound channel 4
	JP	L7054

;     87       = RETURN
; 87
L6F7F	CALL	L7305		; clear sound channel memory and silence PSG
	LD	HL,D796C
	LD	DE,DC204	; sound channel 1
	JP	L7054

; 88
L6F8B	LD	HL,DC201
	LD	(HL),06H
	CALL	L73B9
	CALL	L7312		; silence PSG
	LD	HL,D79A6
	LD	DE,DC274	; sound channel 5
	JP	L7054

L6F9F	LD	HL,DC201
	LD	(HL),06H
	CALL	L73B9
	CALL	L7312		; silence PSG
	LD	HL,D79D7
	LD	DE,DC274	; sound channel 5
	JP	L7054

L6FB3	CALL	L7305		; clear sound channel memory and silence PSG
	LD	HL,D7A09
	LD	DE,DC204	; sound channel 1
	JP	L7054

L6FBF	CALL	L7305		; clear sound channel memory and silence PSG
	LD	HL,D7A25
	LD	DE,DC204	; sound channel 1
	JP	L7054

L6FCB	CALL	L7305		; clear sound channel memory and silence PSG
	LD	HL,D7AA3
	LD	DE,DC204	; sound channel 1
    IF    OPT
	JR	L7054
    ELSE
	JP	L7054
    ENDIF

L6FD7	LD	HL,DC201
	LD	(HL),06H
	CALL	L73B9
	CALL	L7312		; silence PSG
	LD	HL,D7AE3
	LD	DE,DC274	; sound channel 5
    IF    OPT
	JR	L7054
    ELSE
	JP	L7054
    ENDIF

L6FEB	CALL	L7305		; clear sound channel memory and silence PSG
	LD	HL,D7B0D
	LD	DE,DC204	; sound channel 1
    IF    OPT
	JR	L7054
    ELSE
	JP	L7054
    ENDIF

L6FF7	LD	HL,DC201
	LD	(HL),06H
	CALL	L73B9
	CALL	L7312		; silence PSG
	LD	HL,D7BA6
	LD	DE,DC274	; sound channel 5
    IF    OPT
	JR	L7054
    ELSE
	JP	L7054
    ENDIF

L700B	LD	HL,DC201
	LD	(HL),06H
	CALL	L73B9
	CALL	L7312		; silence PSG
	LD	HL,D7BD4
	LD	DE,DC274	; sound channel 5
    IF    OPT
	JR	L7054
    ELSE
	JP	L7054
    ENDIF

; 93
L701F	CALL	L7305		; clear sound channel memory and silence PSG
	LD	HL,D7C10
	LD	DE,DC204	; sound channel 1
    IF    OPT
	JR	L7054
    ELSE
	JP	L7054
    ENDIF

; 94
L702B	CALL	L7305		; clear sound channel memory and silence PSG
	LD	HL,D7C83
	LD	DE,DC204	; sound channel 1
    IF    OPT
	JR	L7054
    ELSE
	JP	L7054
    ENDIF

; 95
L7037	CALL	L7305		; clear sound channel memory and silence PSG
	LD	HL,D7CBC
	LD	DE,DC204	; sound channel 1
    IF    OPT
	JR	L7054
    ELSE
	JP	L7054
    ENDIF

; 96
L7043	LD	HL,DC201
	LD	(HL),06H
	CALL	L73B9
	CALL	L7312		; silence PSG
	LD	HL,D7E8E
	LD	DE,DC274	; sound channel 5
; common exit
L7054	LD	A,(HL)
	INC	HL
	LD	H,(HL)
	LD	L,A
	LD	B,(HL)
	INC	HL
.705A	PUSH	BC
	LD	A,(HL)
	INC	HL
	PUSH	HL
	LD	H,(HL)
	LD	L,A
	LD	BC,000EH
	LDIR
	XOR	A
	LD	(DE),A
	INC	DE
	LD	B,0DH
.706A	LD	(DE),A
	INC	DE
	DJNZ	.706A
	POP	HL
	INC	HL
	POP	BC
	DJNZ	.705A
	LD	A,80H
	LD	(DC200),A
	RET

;-----------------------------------------------------------------------

L7079	LD	E,(IX+03H)
	LD	D,(IX+04H)
	INC	DE
	LD	(IX+03H),E
	LD	(IX+04H),D
	LD	L,(IX+05H)
	LD	H,(IX+06H)
	OR	A
	SBC	HL,DE
	CALL	Z,L7194
	LD	E,(IX+11H)
	LD	D,(IX+12H)
	LD	A,E
	OR	D
	JR	NZ,.70A3
	LD	(IX+17H),0FH
	JP	.713F

.70A3	BIT	5,(IX+00H)
	JR	NZ,.70B1
	LD	(IX+13H),E
	LD	(IX+14H),D
	JR	.70E5

.70B1	PUSH	DE
	LD	L,(IX+15H)
	LD	H,(IX+16H)
	OR	A
	SBC	HL,DE
	PUSH	AF
	LD	A,L
	JP	P,.70C2
	NEG
.70C2	LD	H,A
	LD	E,(IX+03H)
	CALL	L739A
	LD	E,(IX+05H)
	CALL	L73A6
	LD	E,A
	LD	D,00H
	POP	AF
	LD	A,E
	JP	P,.70DD
	NEG
	JR	Z,.70DD
	DEC	D
	LD	E,A
.70DD	POP	HL
	ADD	HL,DE
	LD	(IX+13H),L
	LD	(IX+14H),H
.70E5	LD	A,(IX+0CH)
	OR	A
	JR	NZ,.70F6
	LD	A,(IX+0DH)
	CPL
	AND	0FH
	LD	(IX+17H),A
	JR	.7114

.70F6	DEC	A
	LD	HL,D73E1
	INC	HL
	LD	B,00H
	LD	C,(HL)
	INC	HL
	LD	H,(HL)
	LD	L,C
	LD	C,02H
	ADD	HL,BC
	LD	C,(HL)
	INC	HL
	LD	H,(HL)
	LD	L,C
	LD	C,A
	LD	B,00H
	ADD	HL,BC
	ADD	HL,BC
	LD	A,(HL)
	INC	HL
	LD	H,(HL)
	LD	L,A
	CALL	L715D
.7114	BIT	6,(IX+00H)
	JR	NZ,.713F
	LD	A,(IX+01H)
	AND	0FH
	LD	C,A
	LD	B,00H
	LD	HL,D7152
	ADD	HL,BC
	LD	C,(HL)
	LD	A,(IX+13H)
	AND	0FH
	OR	C
	CALL	L72FD
	LD	A,(IX+13H)
	AND	0F0H
	OR	(IX+14H)
	RRCA
	RRCA
	RRCA
	RRCA
	CALL	L72FD
.713F	LD	A,(IX+01H)
	AND	0FH
	LD	C,A
	LD	B,00H
	LD	HL,D7156
	ADD	HL,BC
	LD	A,(HL)
	OR	(IX+17H)
	JP	L72FD

D7152	DB	80H,0A0H,0C0H,0C0H

D7156	DB	90H,0B0H,0D0H,0F0H

L715A	LD	(IX+0FH),A
L715D	PUSH	HL
	LD	A,(IX+0FH)
	SRL	A
	PUSH	AF
	LD	C,A
	LD	B,00H
	ADD	HL,BC
	POP	AF
	LD	A,(HL)
	POP	HL
	JR	C,.7181
	RRCA
	RRCA
	RRCA
	RRCA
	OR	A
	JR	Z,L715A
	CP	10H
	JR	NZ,.717D
	DEC	(IX+0FH)
	JR	L715D

.717D	CP	20H
	JR	Z,.718C
.7181	INC	(IX+0FH)
	OR	0F0H
	ADD	A,(IX+0DH)
	INC	A
	JR	C,.718D
.718C	XOR	A
.718D	CPL
	AND	0FH
	LD	(IX+17H),A
	RET

;-----------------------------------------------------------------------

L7194	LD	E,(IX+07H)
	LD	D,(IX+08H)
L719A	LD	A,(DE)
	INC	DE
	OR	A
	JP	M,.7216
	BIT	3,(IX+00H)
	JR	NZ,.71FC
	OR	A
	JR	Z,.71AC
	ADD	A,(IX+09H)
.71AC	LD	HL,D7320
	LD	C,A
	LD	B,00H
	ADD	HL,BC
	ADD	HL,BC
	LD	A,(HL)
	LD	(IX+11H),A
	INC	HL
	LD	A,(HL)
	LD	(IX+12H),A
	BIT	5,(IX+00H)
	JR	Z,.71D9
	LD	A,(DE)
	INC	DE
	ADD	A,(IX+09H)
	LD	HL,D7320
	LD	C,A
	LD	B,00H
	ADD	HL,BC
	ADD	HL,BC
	LD	A,(HL)
	LD	(IX+15H),A
	INC	HL
	LD	A,(HL)
	LD	(IX+16H),A
.71D9	PUSH	DE
	LD	A,(DE)
	LD	H,A
	LD	E,(IX+02H)
	CALL	L739A
	POP	DE
	LD	(IX+05H),L
	LD	(IX+06H),H
	XOR	A
	LD	(IX+0FH),A
	INC	DE
	LD	(IX+07H),E
	LD	(IX+08H),D
	XOR	A
	LD	(IX+03H),A
	LD	(IX+04H),A
	RET

.71FC	LD	(IX+12H),A
	LD	A,(DE)
	INC	DE
	LD	(IX+11H),A
	BIT	5,(IX+00H)
	JR	Z,.71D9
	LD	A,(DE)
	INC	DE
	LD	(IX+16H),A
	LD	A,(DE)
	INC	DE
	LD	(IX+15H),A
	JR	.71D9

.7216	LD	HL,.7229
	PUSH	HL
	AND	3FH
	LD	HL,D722D
	LD	C,A
	LD	B,00H
	ADD	HL,BC
	ADD	HL,BC
	LD	A,(HL)
	INC	HL
	LD	H,(HL)
	LD	L,A
	JP	(HL)

.7229	INC	DE
	JP	L719A

D722D	DW	L7247,L724C,L72C9,L7261,L7278,L727D,L7283,L729E
	DW	L72B1,L72B7,L72BD,L72C3,L72D9

; 00
L7247	LD	A,(DE)
	LD	(IX+02H),A
	RET

; 01
L724C	LD	A,(DE)
	LD	(IX+0DH),A
	RET

D7251	DB	0FH,0EH,0DH,0CH,0BH,0AH,09H,07H,08H,06H,05H,04H,03H,02H,01H,00H

; 03
L7261	LD	A,(DE)
	OR	0E0H
	PUSH	AF
	CALL	L72FD
	POP	AF
	OR	0FCH
	INC	A
	JR	NZ,L7273
	RES	6,(IX+00H)
	RET

L7273	SET	6,(IX+00H)
	RET

; 04
L7278	LD	A,(DE)
	LD	(IX+0CH),A
	RET

; 05
L727D	EX	DE,HL
	LD	E,(HL)
	INC	HL
	LD	D,(HL)
	DEC	DE
	RET

; 06
L7283	LD	A,(DE)
	LD	C,A
	INC	DE
	LD	A,(DE)
	LD	B,A
	PUSH	BC
	PUSH	IX
	POP	HL
	DEC	(IX+0AH)
	LD	C,(IX+0AH)
	DEC	(IX+0AH)
	LD	B,00H
	ADD	HL,BC
	LD	(HL),D
	DEC	HL
	LD	(HL),E
	POP	DE
	DEC	DE
	RET

; 07
L729E	PUSH	IX
	POP	HL
	LD	C,(IX+0AH)
	LD	B,00H
	ADD	HL,BC
	LD	E,(HL)
	INC	HL
	LD	D,(HL)
	INC	(IX+0AH)
	INC	(IX+0AH)
	RET

; 08
L72B1	SET	5,(IX+00H)
	DEC	DE
	RET

; 09
L72B7	RES	5,(IX+00H)
	DEC	DE
	RET

; 0A
L72BD	SET	3,(IX+00H)
	DEC	DE
	RET

; 0B
L72C3	RES	3,(IX+00H)
	DEC	DE
	RET

; 02
L72C9	CALL	L72EE
	XOR	A
	LD	(IX+00H),A
	POP	HL
	POP	HL
	LD	(DC202),A
	CALL	L73CD
	RET

; 0C
L72D9	CALL	L72EE
	XOR	A
	LD	(IX+00H),A
	POP	HL
	POP	HL
	LD	(DC202),A
	CALL	L73CD
	LD	A,84H
	LD	(DC200),A
	RET

;-----------------------------------------------------------------------

L72EE	LD	A,(IX+01H)
	AND	0FH
	LD	C,A
	LD	B,00H
	LD	HL,D7156
	ADD	HL,BC
	LD	A,(HL)
	OR	0FH
L72FD	BIT	2,(IX+00H)
	RET	NZ
	OUT	(PSG),A
	RET

;-----------------------------------------------------------------------

; clear sound channel memory and silence PSG
L7305	LD	HL,DC204	; clear sound channel memory
	LD	DE,DC204+1
	LD	BC,NC204-1
	LD	(HL),00H
	LDIR

; silence PSG
L7312	LD	HL,D731C
	LD	C,PSG
	LD	B,N731C
	OTIR
	RET

; PSG silence commands
D731C	DB	9FH,0BFH,0DFH,0FFH
N731C	EQU	$-D731C

; note frequency table
D7320	DW	0000H,03FFH,03C7H,0390H,035DH,032DH,02FFH,02D4H
	DW	02ABH,0285H,0261H,023FH,021EH,0200H,01E3H,01C8H
	DW	01AFH,0196H,0180H,016AH,0156H,0143H,0130H,011FH
	DW	010FH,0100H,00F2H,00E4H,00D7H,00CBH,00C0H,00B5H
	DW	00ABH,00A1H,0098H,0090H,0088H,0080H,0079H,0072H
	DW	006CH,0066H,0060H,005BH,0055H,0051H,004CH,0048H
	DW	0044H,0040H,003CH,0039H,0036H,0033H,0030H,002DH
	DW	002BH,0028H,0026H,0024H,0022H

;-----------------------------------------------------------------------

L739A	LD	D,00H
	LD	L,D
	LD	B,08H
.739F	ADD	HL,HL
	JR	NC,.73A3
	ADD	HL,DE
.73A3	DJNZ	.739F
	RET

;-----------------------------------------------------------------------

L73A6	LD	B,08H
.73A8	ADC	HL,HL
	LD	A,H
	JR	C,.73B0
	CP	E
	JR	C,.73B3
.73B0	SUB	E
	LD	H,A
	OR	A
.73B3	DJNZ	.73A8
	LD	A,L
	RLA
	CPL
	RET

;-----------------------------------------------------------------------

L73B9	LD	B,NSCHN
	LD	DE,SCHNSZ
	LD	HL,DC204	; sound channel 1
	LD	A,(DC201)
.73C4	RRCA
	JR	NC,.73C9
	SET	2,(HL)
.73C9	ADD	HL,DE
	DJNZ	.73C4
	RET

;-----------------------------------------------------------------------

L73CD	LD	A,(DC201)
	LD	B,08H	; shouldn't this be 6?
	LD	HL,DC204	; sound channel 1
	LD	DE,SCHNSZ
.73D8	RRCA
	JR	NC,.73DD
	RES	2,(HL)
.73DD	ADD	HL,DE
	DJNZ	.73D8
	RET

;-----------------------------------------------------------------------
; Music data
;   possible byte values in note tables:
;     82       = END
;     85 xx xx = JUMP xxxx
;     86 xx xx = CALL xxxx
;     87       = RETURN

D73E1	DB	(E73E1-D73E1)/2	; 14H
	DW	D740A,D76DD,D7779,D7830,D78F8,D7933,D796C,D79A6
	DW	D79D7,D7A09,D7A25,D7AA3,D7AE3,D7B0D,D7BA6,D7BD4
	DW	D7C10,D7C83,D7CBC,D7E8E
E73E1

;-----------------------------------------------------------------------

D740A	DW	D740E,D7ED9

D740E	DB	03H
	DW	D7415,D7423,D7431

D7415	DB	80H,20H,04H,00H,00H,01H,00H
	DW	D743F
	DB	03H,1CH,00H,02H,0FH

D7423	DB	80H,21H,04H,00H,00H,01H,00H
	DW	D74FB
	DB	03H,1CH,00H,02H,0DH

D7431	DB	80H,22H,04H,00H,00H,01H,00H
	DW	D75FE
	DB	03H,1CH,00H,02H,0DH

D743F	DB	2EH,04H,22H,02H,2EH,02H,00H,02H
	DB	22H,02H,29H,02H,00H,02H,33H,02H
	DB	00H,02H,32H,02H,00H,02H,30H,02H
	DB	00H,02H,2EH,02H,00H,02H,2DH,04H
	DB	2DH,04H,2DH,02H,2EH,02H,30H,02H
	DB	2EH,0AH,88H,8AH,01H,00H,00H,0ABH
	DB	08H,8BH,89H
D7472	DB	81H,0EH,22H,08H,26H,08H,2DH,06H
	DB	26H,02H,29H,02H,00H,02H,2BH,02H
	DB	00H,02H,2DH,02H,00H,02H,21H,02H
	DB	00H,02H,21H,04H,29H,02H,26H,12H
	DB	27H,08H,26H,08H,24H,02H,00H,02H
	DB	27H,04H,2BH,02H,00H,02H,2EH,02H
	DB	00H,02H,2DH,08H,2EH,02H,30H,02H
	DB	00H,02H,32H,02H,00H,02H,30H,02H
	DB	00H,02H,29H,0AH,2BH,08H,2DH,08H
	DB	2EH,02H,00H,02H,2DH,04H,2EH,04H
	DB	30H,04H,32H,08H,33H,02H,35H,06H
	DB	37H,02H,00H,02H,35H,04H,33H,04H
	DB	32H,04H,33H,06H,33H,02H,33H,02H
	DB	2BH,06H,2DH,04H,2DH,04H,2EH,02H
	DB	00H,02H,30H,02H,00H,02H,2EH,02H
	DB	00H,02H,2BH,02H,00H,02H,26H,02H
	DB	29H,02H,00H,02H,22H,12H,85H
	DW	D7472

D74FB	DB	00H,10H,00H,10H,00H,10H,00H,10H
D7503	DB	81H,0CH,16H,02H,00H,02H,11H,02H
	DB	00H,02H,13H,02H,00H,02H,11H,02H
	DB	16H,02H,00H,02H,16H,02H,00H,02H
	DB	11H,02H,13H,02H,00H,02H,11H,02H
	DB	00H,02H,15H,02H,11H,02H,13H,02H
	DB	15H,02H,15H,02H,13H,02H,00H,02H
	DB	11H,02H,00H,02H,0DH,02H,0EH,02H
	DB	0FH,02H,11H,02H,0EH,02H,0FH,02H
	DB	11H,02H,0FH,02H,00H,02H,0CH,02H
	DB	00H,02H,0EH,02H,00H,02H,0CH,02H
	DB	0FH,02H,00H,02H,0FH,02H,00H,02H
	DB	0CH,02H,0EH,02H,00H,02H,13H,02H
	DB	00H,02H,0FH,02H,0AH,02H,07H,02H
	DB	0AH,02H,09H,02H,07H,02H,00H,02H
	DB	0AH,02H,00H,02H,09H,02H,0FH,02H
	DB	0EH,02H,0CH,02H,09H,02H,07H,02H
	DB	07H,02H,0EH,02H,00H,02H,13H,02H
	DB	00H,02H,0AH,02H,00H,02H,0EH,02H
	DB	15H,02H,00H,02H,15H,02H,00H,02H
	DB	0EH,02H,11H,02H,00H,02H,0EH,02H
	DB	00H,02H,0EH,02H,07H,02H,09H,02H
	DB	0AH,02H,0EH,02H,0CH,06H,0FH,02H
	DB	00H,02H,0EH,04H,0CH,02H,00H,02H
	DB	0AH,02H,00H,02H,07H,02H,0FH,02H
	DB	07H,02H,0FH,02H,0CH,02H,0FH,04H
	DB	1BH,02H,09H,02H,09H,02H,07H,02H
	DB	07H,02H,05H,02H,0CH,04H,00H,02H
	DB	0AH,02H,16H,02H,07H,02H,13H,02H
	DB	05H,02H,11H,02H,00H,02H,0AH,02H
	DB	0AH,02H,0AH,02H,07H,02H,07H,02H
	DB	05H,02H,05H,02H,0AH,02H,00H,02H
	DB	85H
	DW	D7503

D75FE	DB	86H
	DW	D76CC
	DB	86H
	DW	D76CC
	DB	15H,02H,0EH,02H,11H,02H,15H,02H
	DB	18H,02H,16H,02H,15H,02H,16H,0AH
	DB	88H,8AH,02H,00H,01H,56H,08H,8BH
	DB	89H
D761D	DB	81H,0CH,16H,08H,16H,08H,15H,06H
	DB	11H,02H,13H,02H,00H,02H,15H,02H
	DB	00H,02H,18H,02H,00H,02H,18H,02H
	DB	00H,02H,18H,04H,15H,02H,11H,0AH
	DB	13H,04H,15H,02H,00H,02H,18H,08H
	DB	18H,08H,18H,02H,00H,02H,1BH,04H
	DB	1AH,02H,00H,02H,1FH,02H,00H,02H
	DB	21H,06H,21H,02H,21H,02H,21H,02H
	DB	00H,02H,21H,02H,00H,02H,22H,02H
	DB	00H,02H,24H,0AH,1FH,04H,1AH,02H
	DB	00H,02H,1DH,08H,21H,02H,00H,02H
	DB	24H,04H,29H,04H,27H,04H,1DH,04H
	DB	1DH,04H,1DH,02H,1DH,02H,1DH,02H
	DB	1DH,02H,21H,02H,00H,02H,22H,04H
	DB	24H,04H,1DH,04H,1BH,02H,13H,02H
	DB	16H,02H,1AH,02H,1BH,02H,18H,06H
	DB	1DH,04H,1DH,04H,24H,02H,00H,02H
	DB	21H,02H,00H,02H,11H,02H,00H,02H
	DB	11H,02H,00H,02H,11H,02H,18H,02H
	DB	00H,02H,15H,02H,16H,02H,16H,02H
	DB	13H,02H,13H,02H,11H,02H,11H,02H
	DB	16H,02H,00H,02H,85H
	DW	D761D

D76CC	DB	16H,02H,16H,02H,0AH,02H,16H,02H
	DB	00H,02H,0AH,02H,16H,02H,0AH,02H
	DB	87H

;-----------------------------------------------------------------------

D76DD	DW	D76E1,D7ED9

D76E1	DB	03H
	DW	D76E8,D76F6,D7704

D76E8	DB	80H,20H,05H,00H,00H,01H,00H
	DW	D7712
	DB	03H,1CH,00H,02H,0FH

D76F6	DB	80H,21H,05H,00H,00H,01H,00H
	DW	D7745
	DB	03H,1CH,00H,02H,0CH

D7704	DB	80H,22H,01H,00H,00H,01H,00H
	DW	D7771
	DB	03H,1CH,00H,03H,0CH

D7712	DB	86H
	DW	D7716
	DB	82H

D7716	DB	23H,02H,1EH,02H,20H,02H,23H,04H
	DB	1EH,02H,20H,02H,23H,04H,1EH,02H
	DB	20H,02H,23H,02H,27H,04H,27H,04H
	DB	23H,02H,1EH,02H,20H,02H,23H,04H
	DB	1EH,02H,20H,02H,21H,02H,20H,02H
	DB	1EH,02H,1BH,04H,0BH,08H,87H

D7745	DB	86H
	DW	D7764
	DB	86H
	DW	D7764
	DB	15H,02H,06H,02H,08H,02H,14H,02H
	DB	09H,02H,15H,02H,0DH,02H,19H,02H
	DB	0BH,02H,17H,02H,00H,02H,0BH,0AH
	DB	82H

D7764	DB	0BH,04H,12H,02H,17H,04H,0BH,02H
	DB	12H,02H,17H,02H,87H

D7771	DB	00H,0BH,80H,05H,86H
	DW	D7716
	DB	82H

;-----------------------------------------------------------------------

D7779	DW	D777D,D7ED9

D777D	DB	03H
	DW	D7784,D7792,D77A0

D7784	DB	80H,20H,04H,00H,00H,01H,00H
	DW	D77AE
	DB	03H,1CH,00H,0AH,0FH

D7792	DB	80H,21H,04H,00H,00H,11H,00H
	DW	D77AE
	DB	03H,1CH,00H,0AH,0AH

D77A0	DB	80H,22H,04H,00H,00H,01H,00H
	DW	D77EF
	DB	03H,1CH,00H,0AH,0EH

D77AE	DB	19H,02H,19H,02H,19H,02H,19H,0CH
	DB	1DH,02H,1DH,02H,1DH,02H,1DH,0CH
	DB	20H,02H,20H,02H,20H,02H,20H,0EH
	DB	00H,01H,20H,03H,22H,03H,24H,03H
	DB	25H,0CH,24H,09H,1FH,03H,22H,06H
	DB	20H,06H,1EH,06H,1BH,06H,19H,06H
	DB	19H,02H,19H,02H,19H,02H,1DH,06H
	DB	1BH,04H,1DH,02H,1BH,0CH,19H,0CH
	DB	82H

D77EF	DB	14H,02H,14H,02H,14H,02H,14H,0CH
	DB	14H,02H,14H,02H,14H,02H,14H,0CH
	DB	19H,02H,19H,02H,19H,02H,19H,0EH
	DB	00H,01H,19H,03H,19H,03H,1BH,03H
	DB	20H,0CH,1BH,09H,16H,03H,1DH,06H
	DB	1DH,06H,1BH,06H,18H,06H,14H,06H
	DB	14H,02H,14H,02H,14H,02H,14H,06H
	DB	18H,04H,14H,02H,18H,0CH,14H,0CH
	DB	82H

;-----------------------------------------------------------------------

D7830	DW	D7834,D7ED9

D7834	DB	03H
	DW	D783B,D7849,D7857

D783B	DB	80H,20H,00H,00H,00H,01H,00H
	DW	D7865
	DB	03H,1CH,00H,00H,00H

D7849	DB	80H,21H,00H,00H,00H,01H,00H
	DW	D7898
	DB	03H,1CH,00H,00H,00H

D7857	DB	80H,22H,00H,00H,00H,01H,00H
	DW	D78CB
	DB	03H,1CH,00H,00H,00H

D7865	DB	80H,04H,81H,0EH,84H,06H,00H,02H
	DB	19H,02H,19H,02H,1DH,02H,1EH,02H
	DB	20H,02H,20H,02H,22H,02H,24H,02H
	DB	25H,03H,00H,01H,81H,0DH,84H,00H
	DB	88H,25H,20H,01H,89H,20H,03H,88H
	DB	20H,25H,01H,89H,84H,07H,25H,07H
	DB	00H,04H,82H

D7898	DB	80H,04H,81H,0DH,84H,07H,00H,02H
	DB	14H,02H,14H,02H,19H,02H,1BH,02H
	DB	1DH,02H,1DH,02H,1EH,02H,20H,02H
	DB	20H,03H,00H,01H,81H,0CH,84H,00H
	DB	88H,20H,1DH,01H,89H,1DH,03H,88H
	DB	1DH,20H,01H,89H,84H,07H,20H,07H
	DB	00H,04H,82H

D78CB	DB	80H,04H,81H,0EH,84H,07H,00H,02H
	DB	11H,02H,11H,02H,14H,04H,0DH,04H
	DB	0FH,04H,11H,03H,00H,01H,81H,0DH
	DB	84H,00H,88H,11H,0DH,01H,89H,0DH
	DB	03H,88H,0DH,11H,01H,89H,84H,07H
	DB	11H,07H,00H,04H,82H

;-----------------------------------------------------------------------

D78F8	DW	D78FC,D7ED9

D78FC	DB	02H
	DW	D7901,D790F

D7901	DB	80H,21H,02H,00H,00H,01H,00H
	DW	D791D
	DB	03H,1CH,00H,06H,0FH

D790F	DB	80H,22H,02H,00H,00H,01H,00H
	DW	D7928
	DB	03H,1CH,00H,06H,0FH

D791D	DB	30H,02H,2CH,02H,2EH,02H,84H,07H
	DB	33H,08H,82H

D7928	DB	2CH,02H,29H,02H,2AH,02H,84H,07H
	DB	30H,08H,82H

;-----------------------------------------------------------------------

D7933	DW	D7937,D7ED9

D7937	DB	01H
	DW	D793A

D793A	DB	88H,23H,01H,00H,00H,01H,00H
	DW	D7948
	DB	00H,1CH,00H,00H,0FH

D7948	DB	83H,07H,88H,00H,06H,00H,01H,03H
	DB	00H,0BH,00H,01H,02H,00H,01H,00H
	DB	04H,01H,00H,04H,00H,08H,01H,00H
	DB	08H,00H,0CH,01H,84H,07H,00H,0CH
	DB	00H,18H,20H,8CH

;-----------------------------------------------------------------------

D796C	DW	D7970,D7ED9

D7970	DB	02H
	DW	D7975,D7983

D7975	DB	80H,20H,01H,00H,00H,01H,00H
	DW	D7991
	DB	20H,1CH,00H,09H,0FH

D7983	DB	80H,21H,01H,00H,00H,01H,00H
	DW	D7991
	DB	2CH,1CH,00H,09H,0FH

D7991	DB	88H,01H,05H,02H,00H,00H,01H,07H
	DB	0BH,02H,08H,0CH,02H,0CH,10H,02H
	DB	0FH,16H,02H,89H,8CH

;-----------------------------------------------------------------------

D79A6	DW	D79AA,D7ED9

D79AA	DB	02H
	DW	D79AF,D79BD

D79AF	DB	0A8H,21H,02H,00H,00H,01H,00H
	DW	D79CB
	DB	08H,1CH,00H,08H,0FH

D79BD	DB	0A8H,22H,02H,00H,00H,03H,00H
	DW	D79D1
	DB	03H,1CH,00H,08H,0FH

D79CB	DB	01H,26H,01H,0F0H,12H,82H

D79D1	DB	01H,70H,02H,40H,12H,82H

;-----------------------------------------------------------------------

D79D7	DW	D79DB,D7ED9

D79DB	DB	02H
	DW	D79E0,D79EE

D79E0	DB	80H,21H,01H,00H,00H,03H,00H
	DW	D79FC
	DB	05H,1CH,00H,06H,0FH

D79EE	DB	80H,22H,01H,00H,00H,01H,00H
	DW	D79FC
	DB	03H,1CH,00H,06H,0FH

D79FC	DB	00H,02H,2EH,06H,2EH,06H,2EH,05H
	DB	2EH,0CH,00H,02H,82H

;-----------------------------------------------------------------------

D7A09	DW	D7A0D,D7ED9

D7A0D	DB	01H
	DW	D7A10

D7A10	DB	80H,20H,01H,00H,00H,01H,00H
	DW	D7A1E
	DB	03H,1CH,00H,00H,0FH

D7A1E	DB	2EH,03H,00H,02H,85H
	DW	D7A1E

;-----------------------------------------------------------------------

D7A25	DW	D7A29,D7ED9

D7A29	DB	03H
	DW	D7A30,D7A3E,D7A4C

D7A30	DB	80H,20H,01H,00H,00H,01H,00H
	DW	D7A5A
	DB	03H,1CH,00H,0BH,0EH

D7A3E	DB	80H,21H,01H,00H,00H,09H,00H
	DW	D7A5A
	DB	03H,1CH,00H,0BH,0BH

D7A4C	DB	80H,22H,01H,00H,00H,0DH,00H
	DW	D7A5A
	DB	03H,1CH,00H,0BH,08H

D7A5A	DB	31H,04H,30H,04H,2FH,04H,2EH,04H
	DB	2DH,04H,2CH,04H,2BH,03H,2AH,03H
	DB	29H,02H,28H,03H,27H,03H,26H,03H
	DB	25H,03H,24H,03H,23H,02H,22H,02H
	DB	21H,02H,20H,02H,1FH,02H,1EH,02H
	DB	1DH,02H,1CH,02H,1BH,02H,1AH,02H
	DB	19H,02H,18H,02H,17H,02H,16H,02H
	DB	15H,02H,14H,02H,13H,02H,12H,02H
	DB	11H,02H,10H,02H,0FH,02H,0EH,04H
	DB	82H

;-----------------------------------------------------------------------

D7AA3	DW	D7AA7,D7ED9

D7AA7	DB	03H
	DW	D7AAE,D7ABC,D7ACA

D7AAE	DB	80H,20H,01H,00H,00H,01H,00H
	DW	D7AD8
	DB	03H,1CH,00H,07H,0FH

D7ABC	DB	80H,21H,01H,00H,00H,09H,00H
	DW	D7AD8
	DB	03H,1CH,00H,07H,0CH

D7ACA	DB	80H,22H,01H,00H,00H,0DH,00H
	DW	D7AD8
	DB	03H,1CH,00H,07H,0AH

D7AD8	DB	00H,02H,19H,04H,88H,84H,08H,1EH
	DB	25H,28H,82H

;-----------------------------------------------------------------------

D7AE3	DW	D7AE7,D7ED9

D7AE7	DB	02H
	DW	D7AEC,D7AFA

D7AEC	DB	80H,21H,02H,00H,00H,01H,00H
	DW	D7B08
	DB	03H,1CH,00H,06H,0FH

D7AFA	DB	80H,22H,02H,00H,00H,01H,00H
	DW	D7B08
	DB	08H,1CH,00H,06H,0EH

D7B08	DB	1FH,02H,1BH,06H,82H

;-----------------------------------------------------------------------

D7B0D	DW	D7B11,D7ED9

D7B11	DB	03H
	DW	D7B18,D7B26,D7B34

D7B18	DB	80H,20H,04H,00H,00H,01H,00H
	DW	D7B42
	DB	03H,1CH,00H,02H,0FH

D7B26	DB	80H,21H,04H,00H,00H,0DH,00H
	DW	D7B42
	DB	03H,1CH,00H,02H,0BH

D7B34	DB	80H,22H,04H,00H,00H,01H,00H
	DW	D7B73
	DB	03H,1CH,00H,02H,0DH

D7B42	DB	20H,02H,20H,02H,1EH,02H,1DH,02H
	DB	1BH,06H,20H,04H,20H,02H,1EH,02H
	DB	1DH,02H,1BH,08H,1EH,02H,16H,02H
	DB	17H,02H,18H,02H,1BH,02H,1DH,02H
	DB	1EH,02H,22H,02H,27H,02H,25H,02H
	DB	24H,02H,20H,0AH,00H,10H,00H,10H
	DB	82H

D7B73	DB	08H,04H,08H,02H,05H,02H,01H,02H
	DB	03H,02H,03H,02H,03H,02H,08H,04H
	DB	08H,02H,05H,02H,01H,02H,03H,02H
	DB	0FH,02H,03H,02H,14H,04H,08H,02H
	DB	0CH,02H,0AH,02H,05H,02H,05H,02H
	DB	03H,02H,0FH,02H,05H,02H,0CH,02H
	DB	08H,0AH,82H

;-----------------------------------------------------------------------

D7BA6	DW	D7BAA,D7ED9

D7BAA	DB	02H
	DW	D7BAF,D7BBD

D7BAF	DB	00H,21H,04H,00H,00H,01H,00H
	DW	D7BCB
	DB	03H,1CH,00H,04H,00H

D7BBD	DB	80H,22H,04H,00H,00H,01H,00H
	DW	D7BCB
	DB	03H,1CH,00H,04H,0FH

D7BCB	DB	8AH,00H,87H,01H,00H,87H,01H,8BH
	DB	82H

;-----------------------------------------------------------------------

D7BD4	DW	D7BD8,D7ED9

D7BD8	DB	02H
	DW	D7BDD,D7BEB

D7BDD	DB	80H,21H,01H,00H,00H,01H,00H
	DW	D7BF9
	DB	03H,1CH,00H,02H,0FH

D7BEB	DB	80H,22H,01H,00H,00H,09H,00H
	DW	D7BF9
	DB	03H,1CH,00H,02H,0CH

D7BF9	DB	00H,02H,8AH,00H,40H,04H,00H,44H
	DB	04H,88H,00H,41H,00H,40H,01H,89H
	DB	00H,40H,0FH,8BH,00H,02H,82H

;-----------------------------------------------------------------------

D7C10	DW	D7C14,D7ED9

D7C14	DB	03H
	DW	D7C1B,D7C29,D7C37

D7C1B	DB	80H,20H,04H,00H,00H,01H,00H
	DW	D7C45
	DB	03H,1CH,00H,05H,0CH

D7C29	DB	80H,21H,04H,00H,00H,0DH,00H
	DW	D7C64
	DB	03H,1CH,00H,02H,0CH

D7C37	DB	80H,22H,04H,00H,00H,01H,00H
	DW	D7C64
	DB	03H,1CH,00H,02H,0FH

D7C45	DB	19H,06H,88H,19H,25H,02H,89H,25H
	DB	06H,88H,25H,19H,02H,89H,19H,06H
	DB	88H,19H,27H,02H,89H,27H,06H,88H
	DB	27H,19H,02H,89H,85H
	DW	D7C45

D7C64	DB	19H,02H,1DH,02H,20H,02H,24H,04H
	DB	25H,02H,24H,02H,20H,02H,1EH,02H
	DB	22H,02H,25H,02H,29H,04H,2AH,02H
	DB	29H,02H,25H,02H,85H
	DW	D7C64

;-----------------------------------------------------------------------

D7C83	DW	D7C87,D7ED9

D7C87	DB	02H
	DW	D7C8C,D7C9A

D7C8C	DB	80H,20H,02H,00H,00H,01H,00H
	DW	D7CA8
	DB	03H,1CH,00H,02H,0FH

D7C9A	DB	80H,21H,02H,00H,00H,17H,00H
	DW	D7CA8
	DB	03H,1CH,00H,01H,0CH

D7CA8	DB	8AH,00H,18H,02H,00H,1AH,02H,00H
	DB	17H,02H,00H,19H,02H,00H,16H,02H
	DB	00H,18H,0CH,82H

;-----------------------------------------------------------------------

D7CBC	DW	D7CC0,D7ED9

D7CC0	DB	03H
	DW	D7CC7,D7CD5,D7CE3

D7CC7	DB	80H,20H,04H,00H,00H,01H,00H
	DW	D7DE4
	DB	03H,1CH,00H,0CH,0CH

D7CD5	DB	80H,21H,04H,00H,00H,01H,00H
	DW	D7D6E
	DB	03H,1CH,00H,0DH,0FH

D7CE3	DB	80H,22H,04H,00H,00H,01H,00H
	DW	D7CF1
	DB	03H,1CH,00H,0DH,0FH

D7CF1	DB	86H
	DW	D7D51
	DB	1DH,04H,81H,09H
D7CF8	DB	86H
	DW	D7D51
	DB	1DH,04H,86H
	DW	D7D51
	DB	1DH,04H,1EH,04H,1EH,04H,1EH,02H
	DB	1EH,04H,20H,04H,20H,04H,20H,02H
	DB	1EH,04H,1EH,04H,20H,04H,20H,04H
	DB	20H,02H,20H,04H,20H,04H,20H,04H
	DB	20H,02H,20H,04H,20H,04H,1EH,04H
	DB	1EH,04H,1EH,02H,1EH,04H,20H,04H
	DB	20H,04H,20H,02H,1EH,04H,1EH,04H
	DB	1DH,04H,1DH,04H,1DH,02H,1DH,04H
	DB	1DH,02H,1DH,02H,1DH,02H,1DH,04H
	DB	1DH,02H,1DH,04H,1DH,02H,85H
	DW	D7CF8

D7D51	DB	00H,0EH,1DH,04H,1DH,04H,1DH,02H
	DB	1DH,04H,1DH,04H,1EH,04H,1EH,04H
	DB	1EH,02H,1EH,04H,1DH,04H,1DH,04H
	DB	1DH,02H,1DH,04H,87H

D7D6E	DB	86H
	DW	D7DCF
	DB	86H
	DW	D7DCF
D7D74	DB	86H
	DW	D7DCF
	DB	86H
	DW	D7DCF
	DB	86H
	DW	D7DCF
	DB	86H
	DW	D7DCF
	DB	19H,04H,19H,04H,19H,02H,19H,04H
	DB	19H,04H,19H,04H,19H,02H,19H,04H
	DB	19H,04H,1DH,04H,1DH,04H,1DH,02H
	DB	1DH,04H,25H,04H,25H,04H,25H,02H
	DB	1DH,04H,1DH,04H,1BH,04H,1BH,04H
	DB	1BH,02H,1BH,04H,1BH,04H,1BH,04H
	DB	1BH,02H,1BH,04H,1BH,04H,19H,04H
	DB	19H,04H,19H,02H,19H,04H,19H,02H
	DB	25H,02H,25H,02H,25H,04H,25H,02H
	DB	25H,04H,25H,02H,85H
	DW	D7D74

D7DCF	DB	19H,04H,19H,04H,19H,02H,19H,04H
	DB	19H,04H,19H,04H,19H,02H,19H,04H
	DB	19H,04H,81H,09H,87H

D7DE4	DB	00H,02H,86H
	DW	D7D51
	DB	1DH,02H,84H,0DH,81H,0FH
D7DEF	DB	19H,02H,00H,02H,1DH,02H,20H,04H
	DB	22H,02H,00H,02H,20H,02H,22H,06H
	DB	20H,04H,20H,04H,20H,02H,24H,02H
	DB	20H,02H,00H,02H,20H,02H,00H,02H
	DB	20H,02H,00H,02H,20H,02H,22H,02H
	DB	1DH,02H,00H,02H,1DH,02H,00H,02H
	DB	1DH,02H,00H,02H,1DH,02H,19H,04H
	DB	1DH,02H,00H,02H,25H,04H,24H,02H
	DB	20H,12H,22H,04H,22H,02H,00H,02H
	DB	20H,04H,1EH,02H,20H,12H,1EH,04H
	DB	22H,02H,25H,04H,29H,04H,27H,02H
	DB	29H,06H,27H,0AH,24H,04H,20H,02H
	DB	18H,04H,19H,02H,1BH,02H,1DH,02H
	DB	1DH,02H,24H,04H,22H,0AH,1BH,04H
	DB	1EH,02H,22H,04H,25H,06H,27H,04H
	DB	25H,04H,24H,02H,20H,06H,25H,02H
	DB	25H,02H,1DH,02H,1DH,02H,25H,02H
	DB	19H,02H,25H,02H,20H,02H,19H,02H
	DB	19H,02H,19H,02H,19H,04H,19H,02H
	DB	19H,02H,19H,02H,85H
	DW	D7DEF

;-----------------------------------------------------------------------

D7E8E	DW	D7E92,D7ED9

D7E92	DB	02H
	DW	D7E97,D7EA5

D7E97	DB	80H,21H,02H,00H,00H,01H,00H
	DW	D7EB3
	DB	03H,1CH,00H,00H,0FH

D7EA5	DB	80H,22H,02H,00H,00H,01H,00H
	DW	D7EB3
	DB	03H,1CH,00H,0CH,07H

D7EB3	DB	00H,02H,86H
	DW	D7EC3
	DB	00H,03H,82H,00H,02H
	DB	00H,03H,86H
	DW	D7EC3
	DB	82H

D7EC3	DB	88H,84H,0DH,29H,2CH,04H,2CH,29H
	DB	02H,29H,2CH,02H,84H,0CH,2CH,29H
	DB	02H,29H,35H,10H,89H,87H

;-----------------------------------------------------------------------

D7ED9	DW	D7EF3,D7EFA,D7F09,D7F29,D7F2C,D7F51,D7F59,D7F67
	DW	D7F7D,D7F80,D7F97,D7F9D,D7FAC

D7EF3	DB	0FFH,0EDH,0CBH,0A9H,87H,65H,01H

D7EFA	DB	0FFH,0EEH,0DDH,0CCH,0BBH,0AAH,99H,88H
	DB	77H,66H,66H,54H,32H,21H,02H

D7F09	DB	0FFH,0FFH,0FFH,0EEH,0EEH,0DDH,0DDH,0CCH
	DB	0CCH,0BBH,0BBH,0AAH,0AAH,99H,99H,88H
	DB	88H,77H,77H,77H,66H,66H,66H,55H
	DB	55H,55H,44H,43H,33H,32H,22H,02H

D7F29	DB	0FDH,96H,02H

D7F2C	DB	33H,33H,44H,45H,55H,66H,67H,77H
	DB	88H,89H,99H,0AAH,0ABH,0BBH,0CCH,0CDH
	DB	0DDH,0EEH,0EFH,0FFH,0EEH,0DDH,0DCH,0CCH
	DB	0BBH,0BAH,0AAH,99H,98H,88H,77H,76H
	DB	66H,55H,54H,44H,00H

D7F51	DB	0FFH,0ECH,0BAH,87H,65H,43H,21H,01H

D7F59	DB	0FFH,0FFH,0EDH,0CBH,0BAH,0A9H,98H,87H
	DB	77H,76H,65H,43H,21H,01H

D7F67	DB	0DEH,0FFH,0FFH,0EEH,0EDH,0DDH,0CCH,0BBH
	DB	0AAH,99H,88H,87H,77H,76H,66H,55H
	DB	54H,44H,33H,22H,11H,01H

D7F7D	DB	0FEH,0EFH,00H

D7F80	DB	0DEH,0FFH,0FEH,0DCH,0CCH,0CCH,0CCH,0BBH
	DB	0BBH,0BBH,0AAH,0AAH,0AAH,0A8H,77H,78H
	DB	89H,98H,87H,76H,67H,77H,01H

D7F97	DB	0FEH,0DBH,0A9H,76H,54H,02H

D7F9D	DB	0FFH,0EEH,0DDH,0CCH,0BBH,0AAH,99H,88H
	DB	77H,66H,66H,54H,32H,21H,02H

D7FAC	DB	0FFH,0EDH,0DCH,0BBH,0A9H,98H,77H,0BBH
	DB	0AAH,99H,88H,77H,66H,55H,77H,76H
	DB	66H,55H,54H,44H,33H,22H,11H,02H

;-----------------------------------------------------------------------

    IF      COLECO
	IF	($ & 0FFFFH) < 8000H
	ERROR	Code area overflow!
	ENDIF
    ELSE
	HEX	         FFFFFFFF FFFFFFFF FFFFFFFF
	HEX	FFFFFFFF FFFFFFFF FFFFFFFF FFFFFFFF
	HEX	FFFFFFFF FFFFFFFF FFFFFFFF FFFFFFFF
	HEX	FFFFFFFF FFFFFFFF FFFFFFFF FFFFFFFF
    ENDIF

	END	0000H
