; =============================================================================
; UTILS.asm - Common Utility Routines for ColecoVision
; =============================================================================

; --- NMI Handler
nmi_handler:
    push af
    ld a, 1
    ld (NMI_FLAG), a ; Set the flag to indicate an NMI occurred
    in a, ($BF)      ; Acknowledge VDP interrupt
    pop af
    ret

; --- Clear RAM ($7000 - $73B7)
clear_ram:
    ld hl, $7000
    ld de, $7001
    ld bc, $03B5
    ld (hl), 0
    ldir
    ret

; --- Turn off SN76489 sound chip
turn_sound_off:
    ld a, $9F ; Attenuation channel 0
    out ($FF), a
    ld a, $BF ; Attenuation channel 1
    out ($FF), a
    ld a, $DF ; Attenuation channel 2
    out ($FF), a
    ld a, $FF ; Attenuation channel 3
    out ($FF), a
    ret

; --- Setup Graphics Mode 2
setup_graphics_mode:
    ; Screen off, NMI off
    ld bc, $0182 ; vdp_out(1, $82)
    call $1FD9
    ; Set Graphic Mode II
    ld bc, $0002 ; vdp_out(0, 2)
    call $1FD9
    ; Set Name Table address
    ld a, 2
    ld hl, $1800
    call $1FB8
    ; Set Pattern Table address
    ld bc, $03FF ; vdp_out(3, $FF)
    call $1FD9
    ; Set Color Table address
    ld bc, $0403 ; vdp_out(4, $03)
    call $1FD9
    ; Fill name table with default pattern numbers
    ld de, $1800
    call fill_default_name_table
    ; Screen on, NMI on
    ld bc, $01E2 ; vdp_out(1, $E2)
    call $1FD9
    ret

; --- Fill Name Table with 0, 1, 2, ... 255 sequence
fill_default_name_table:
    call vdp_set_write_addr
    ld d, 3
fill_name_loop:
    xor a
fill_name_inner_loop:
    out ($BE), a
    nop
    inc a
    jr nz, fill_name_inner_loop
    dec d
    jr nz, fill_name_loop
    ret

; --- Clear VRAM (Pattern and Color tables)
clear_vram:
    xor a
    ld hl, VRAM_COLOR
    ld de, $1800 ; Size of color table
    call fill_vram
    ld hl, VRAM_PATTERN
    ld de, $1800 ; Size of pattern table
    jp fill_vram
fill_vram:
    jp $1F82 ; Use BIOS routine

; --- Set VDP Write Address
; IN: DE = VRAM address
vdp_set_write_addr:
    ld c, $BF
    out (c), e
    set 6, d
    out (c), d
    res 6, d
    ret

; --- Delay Loop
; IN: B = number of NMI cycles to wait
delay:
    xor a
    ld (NMI_FLAG), a
delay_wait_loop:
    ld a, (NMI_FLAG)
    or a
    jr z, delay_wait_loop
    djnz delay
    ret

nmioff:
	ld		bc, $01C2
	jp		$1FD9

nmion:
	ld		bc, $01E2
	jp		$1FD9