#pragma once

#include <stdbool.h>


#if 0
enum coleco_pins {
	// Port A:  Address bus low half
	CA0 = 0, CA1, CA2, CA3, CA4, CA5, CA6, CA7,

	// Port B:  Various control lines
	WAIT_EN = 0, SPI_SCK, SPI_MOSI, SPI_MISO, HALT, QUAD, AD2000, AD4000,

	// Port C:  Address bus high half
	CA8 = 0, CA9, CA10, CA11, CA12, CA13, CA14, CA15,

	// Port D:  Data bus
	CD0 = 0, CD1, CD2, CD3, CD4, CD5, CD6, CD7,

	// Port E:  Serial I/O, control lines, audio
	SERIALRX = 0, SERIALTX, INT, NMI, RFSH, EXAUD, BUSACK, PULLUPSENSE,

	// Port F:  Video DAC, external video gate
	DAC0 = 0, DAC1, DAC2, DAC3, _NC0, _NC1, EXVIDEN,

	// Port G:  control lines
	EXTRST = 0, PCLK, CLK, _NC2, _NC3, WAIT,

	// Port H: control lines
	WR = 0, RD, MREQ, BUSRQ, IORQ, _NC4, _NC5, _NC6,
	
	// Port J: control lines
	_NC7 = 0, M1, IOMAPOVR, MEMMAPOVR, RESET, CLK2, VDCRST, RESETNOT,
	
	// Port K: Voltage test
	PULLUPA0 = 0, PULLUPA1, PULLUPEN, _NC8, _NC9, M5V = A13, P5V = A14, P12V = A15,

	// Port L: No connections
};
#endif

// Tests
bool doVoltageTest( void );
bool doBusAck( void );
void doBasicTests( void );
void doMemTests( void );
bool vramTest( void );
bool checkInput( void );
bool doExtVideoTestNTSC( void );
bool doExtVideoTestPAL( void );
bool basicVDCTest( void );
bool graphicsVDCTest( void );
bool soundTest( void );
bool CPUTest();

// Colecovision utilities
void endIO( void );
void beginIO( void );
uint8_t readVDCStatus( void );
void writeVDCReg( uint8_t reg, uint8_t data );
void writeVRAMAddr( uint16_t addr );
void readVRAMAddr( uint16_t addr );
void writeVRAM( uint8_t data );
uint8_t readVRAM( void );
