--
-- cvkbdcpld.vhd - Colecovision keyboard CPLD
--
-- This CPLD is replacing various discrete ICs.
--   a GAL for IO address decode
--   2x 74HC4050 5V to 3.3V level shifters
--   74LS273 octal latch
--

library IEEE;
use IEEE.STD_LOGIC_1164.ALL;
use IEEE.STD_LOGIC_UNSIGNED.ALL;
use IEEE.NUMERIC_STD.ALL;

entity cvkbdcpld is
  port
    (
    -- Z80
    IORQ_n   : in    std_logic;
    M1_n     : in    std_logic;
    RD_n     : in    std_logic;
    WR_n     : in    std_logic;
    A        : in    std_logic_vector(7 downto 2);
    D        : inout std_logic_vector(7 downto 0);
    -- indicator of port write
    K_WR_n   : out   std_logic;
    -- latched keyboard command, for the LPC1114
    KC       : out   std_logic_vector(2 downto 0);
    -- keyboard data, from LPC1114
    KD       : in    std_logic_vector(7 downto 0);
    -- PS/2 keyboard related
    PS2_CLK5 : in    std_logic;
    PS2_CLK  : out   std_logic;
    PS2_DAT5 : in    std_logic;
    PS2_DAT  : out   std_logic
    );
end cvkbdcpld;

architecture behavior of cvkbdcpld is

  signal K_WR_n_int : std_logic;
  signal KC_int     : std_logic_vector(2 downto 0) := "000";

begin

  -- Z80 reading keyboard data from port 30-33
  D <= KD when ( IORQ_n = '0' and M1_n = '1' and RD_n = '0' and A = "001100" ) else "ZZZZZZZZ";

  -- Z80 writing keyboard command to port 30-33
  K_WR_n_int <= '0' when ( IORQ_n = '0' and WR_n = '0' and A = "001100" ) else '1';
  K_WR_n     <= K_WR_n_int;

  -- when Z80 outputs to keyboard port, rememember what it writes
  process ( K_WR_n_int )
  begin
    if rising_edge(K_WR_n_int) then
      KC_int <= D(2 downto 0);
    end if;
  end process;

  -- ensure LPC1114 can see last written value
  KC <= KC_int;

  -- pass on keyboard signals
  -- we only pass them through to lower 5V to 3.3V
  PS2_CLK <= PS2_CLK5;
  PS2_DAT <= PS2_DAT5;

end behavior;
