/**
 * @brief Initialize EOS sound system to use SmartKeys sounds and Custom Farkle Sounds.
 * @note this must be called before any smartkeys_sound_play() commands.
 */

#include "sound.h"

/* Sound data pulled from the SmartWriter ROM plus custom sounds  */

static unsigned char output1[10], output2[10], output3[10], output4[10], output5[10], output6[10];

static unsigned char sound0[] = {0x40,0x87,0x50,0x03,0x42,0x8F,0x30,0x0A,0x17,0x11,0x50};                                                    // 0E74 [0]
static unsigned char sound1[] = {0x80,0xD6,0x50,0x03,0x82,0xE2,0x30,0x0A,0x17,0x11,0x90};                                                    // 0E7F [1]
static unsigned char sound2[] = {0x02,0x63,0x0A,0x00,0x00,0x10};                                                                             // 0E8A [2]
static unsigned char sound3[] = {0xC0,0x4C,0xF0,0x0A,0xD0};                                                                                  // 0E90 [3]
static unsigned char sound4[] = {0x02,0x67,0x02,0x00,0x00,0x10};                                                                             // 0E95 [4]
static unsigned char sound5[] = {0xC0,0x0A,0xF0,0x02,0xD0};                                                                                  // 0E9B [5]
static unsigned char sound6[] = {0x41,0x40,0x60,0x02,0x55,0x15,0x40,0x80,0x60,0x05,0x50,0x81,0x57,0x63,0x02,0x44,0xa3,0x90};                 // 0EA0 [6]
static unsigned char sound7[] = {0x41,0x40,0x40,0x02,0x33,0xFC,0x41,0x40,0x40,0x02,0x33,0xfc,0x42,0x40,0x40,0x09,0x1d,0x11,0x50};            // 0EB2 [7]
static unsigned char sound8[] = {0x81,0x4C,0x20,0x02,0x33,0xFB,0x81,0x4C,0x81,0x4C,0x20,0x02,0x33,0xFB,0x82,0x4C,0x20,0x09,0x1D,0x11,0x90};  // 0EC5 [8]
static unsigned char sound9[] = {0xC1,0x60,0x20,0x02,0x33,0xFA,0xC1,0x60,0x20,0x02,0x33,0xFA,0xC2,0x60,0x20,0x09,0x1D,0x11,0xD0};            // 0ED8 [9]
static unsigned char sound10[] = {0x42,0x20,0x40,0x10,0x24,0x14,0x42,0x20,0x30,0x14,0x24,0x16,0x50};                                         // 0EEB [10]
static unsigned char sound11[] = {0x82,0x40,0x40,0x10,0x18,0x13,0x82,0x40,0x30,0x14,0x18,0x15,0x90};                                         // 0EF8 [11]
static unsigned char sound12[] = {0xC2,0x80,0x40,0x10,0x18,0x12,0xC2,0x80,0x30,0x14,0x18,0x11,0xD0};                                         // 0F05 [12]
static unsigned char sound13[] = {0x82,0x40,0x40,0x0F,0x18,0x15,0x90,0x42,0x20,0x30,0x14,0x26,0x1B,0x50,0x82,0x40,0x30,0x14,0x1B,0x19,0x90}; // 0F12 [13]
static unsigned char sound14[] = {0x82,0xD6,0x70,0x40,0x32,0x12,0x90};                                                                       // 0F2E [14]
static unsigned char sound15[] = {0x82,0xCA,0x70,0x04,0x32,0x12,0x90};                                                                       // 0F35 [15]
static unsigned char sound16[] = {0x00,0x00,0x33,120,0x10};                                                                                  // dice roll - p1
static unsigned char sound17[] = {                                                                                                           // dice roll - p2
                                    0xc0,0xff,0xf0,1,0xc0,0x1b,0xf1,1,0xc0,0x33,0xf1,1,0xc0,0xe5,0xf2,1,0xc0,0x0f,0xf3,1,0xc0,0x31,0xf3,1,0xc0,0x73,0xf3,1,0xc0,0x7d,0xf3,1,
                                    0xc0,0x5f,0xf2,1,0xc0,0xb1,0xf3,1,0xc0,0xd3,0xf3,1,0xc0,0xe7,0xf3,4,0xc0,0xff,0xf0,1,0xc0,0xa3,0xf1,1,0xc0,0xa9,0xf2,1,0xc0,0xd7,0xf3,2,
                                    0xc0,0xb7,0xf3,1,0xc0,0xeb,0xf3,1,0xc0,0xed,0xf3,1,0xc0,0x07,0xf1,1,0xc0,0x4d,0xf1,1,0xc0,0xcb,0xf1,1,0xc0,0xc3,0xf1,1,0xc0,0xf3,0xf3,1,
                                    0xc0,0xf7,0xf3,1,0xc0,0xf9,0xf3,1,0xc0,0xf7,0xf3,2,0xc0,0xf5,0xf3,2,0xc0,0xd9,0xf1,1,0xc0,0x2f,0xf1,1,0xc0,0x39,0xf2,1,0xc0,0x2f,0xf3,1,
                                    0xc0,0x9f,0xf3,1,0xc0,0xb5,0xf2,1,0xc0,0xd5,0xf3,1,0xc0,0xe3,0xf3,1,0xc0,0xf3,0xf3,1,0xc0,0xf1,0xf3,1,0xc0,0xf7,0xf3,11,0xc0,0x9d,0xf1,1,
                                    0xc0,0x43,0xf3,1,0xc0,0x5f,0xf3,1,0xc0,0x59,0xf3,1,0xc0,0x03,0xf3,1,0xc0,0x21,0xf3,1,0xc0,0xfb,0xf3,8,0xc0,0xfd,0xf3,1,0xc0,0x69,0xf3,1,
                                    0xc0,0x4d,0xf3,1,0xc0,0xab,0xf3,1,0xc0,0xff,0xf3,14,0xc0,0xfd,0xf3,1,0xc0,0xfb,0xf3,2,0xc0,0xf7,0xf3,1,0xc0,0xf3,0xf3,1,0xc0,0xef,0xf3,2,
                                    0xc0,0x27,0xf0,1,0xc0,0x71,0xf0,1,0xc0,0xeb,0xf3,1,0xc0,0xe7,0xf3,1,0xc0,0xe5,0xf3,1,0xc0,0x7d,0xf0,1,0xc0,0x7b,0xf0,1,0xc0,0xe1,0xf3,1,
                                    0xc0,0xd1,0xf3,1,0xc0,0xcd,0xf3,1,0xc0,0x81,0xf0,1,0xc0,0x79,0xf0,1,0xc0,0xd7,0xf3,1,0xc0,0xc1,0xf3,1,0xc0,0xb7,0xf3,1,0xc0,0x73,0xf0,1,
                                    0xc0,0x79,0xf0,1,0xc0,0x91,0xf3,1,0xc0,0xff,0xf0,1,0xc0,0x6d,0xf0,1,0xc0,0x6f,0xf0,1,0xc0,0xe3,0xf3,1,0xc0,0xeb,0xf3,1,0xc0,0xed,0xf3,1,
                                    0xc0,0x71,0xf0,1,0xc0,0x69,0xf0,1,0xd0
                                };
static unsigned char sound18[] = {
                                    0xc0,0xdd,0xb2,1,0xc0,0xdb,0xb2,1,0xc0,0xd7,0xb2,1,0xc0,0xd3,0xb2,1,0xc0,0xcf,0xb2,1,0xc0,0xc3,0xb2,1,0xc0,0xbb,0xb2,1,0xc0,0xad,0xa2,1,
                                    0xc0,0x99,0xa2,1,0xc0,0x85,0xa2,1,0xc0,0x6d,0x92,1,0xc0,0x4d,0x92,1,0xc0,0x2b,0x92,1,0xc0,0xfb,0x81,1,0xc0,0xd3,0x81,1,0xc0,0xaf,0x71,1,
                                    0xc0,0x91,0x71,1,0xc0,0x73,0x61,1,0xc0,0x59,0x51,1,0xc0,0x41,0x51,1,0xc0,0x29,0x51,1,0xc0,0x17,0x41,1,0xc0,0x07,0x41,1,0xc0,0xf7,0x40,1,
                                    0xc0,0xeb,0x40,1,0xc0,0xdd,0x40,1,0xc0,0xd3,0x50,1,0xc0,0xc9,0x60,1,0xc0,0xc1,0x70,1,0xc0,0xbb,0x80,1,0xd0
                                };

static unsigned char sound19[] = { // wellerman
0x42,0xC5,0x31,15,0x1c,0x11, //B-3
0x42,0xA7,0x32,15,0x1c,0x11, //E-3
0x42,0x5D,0x32,15,0x1c,0x11, //F#3
0x42,0x3B,0x32,15,0x1c,0x11, //G-3
0x42,0xFC,0x31,15,0x1c,0x11, //A-3
0x42,0xC5,0x31,15,0x1c,0x11, //B-3
0x42,0xC5,0x31,15,0x1c,0x11, //B-3
0x42,0xC5,0x31,15,0x1c,0x11, //B-3
0x42,0xC5,0x31,15,0x1c,0x11, //B-3
0x42,0x53,0x31,15,0x1c,0x11, //E-4
0x42,0x53,0x31,15,0x1c,0x11, //E-4
0x42,0x53,0x31,15,0x1c,0x11, //E-4
0x42,0x53,0x31,15,0x1c,0x11, //E-4
0x42,0xC5,0x31,15,0x1c,0x11, //B-3
0x42,0xC5,0x31,15,0x1c,0x11, //B-3
0x42,0x53,0x31,15,0x1c,0x11, //E-4
0x42,0x53,0x31,15,0x1c,0x11, //E-4
0x42,0x53,0x31,15,0x1c,0x11, //E-4
0x42,0x53,0x31,15,0x1c,0x11, //E-4
0x42,0xC5,0x31,15,0x1c,0x11, //B-3
0x42,0xA7,0x32,15,0x1c,0x11, //E-3
0x42,0x5D,0x32,15,0x1c,0x11, //F#3
0x42,0x3B,0x32,15,0x1c,0x11, //G-3
0x42,0xFC,0x31,15,0x1c,0x11, //A-3
0x42,0xC5,0x31,15,0x1c,0x11, //B-3
0x42,0xC5,0x31,15,0x1c,0x11, //B-3
0x42,0xC5,0x31,15,0x1c,0x11, //B-3
0x42,0xC5,0x31,15,0x1c,0x11, //B-3
0x42,0xC5,0x31,15,0x1c,0x11, //B-3
0x42,0xFC,0x31,15,0x1c,0x11, //A-3
0x42,0x3B,0x32,15,0x1c,0x11, //G-3
0x42,0x3B,0x32,15,0x1c,0x11, //G-3
0x42,0x5D,0x32,15,0x1c,0x11, //F#3
0x42,0xA7,0x32,15,0x1c,0x11, //E-3
0x90
};

static unsigned char sound20[] = { // Toxic Two's - Voice 2
    0x80,0xC4,0x31,1,0x80,0xCF,0x31,2,0x80,0x27,0x33,2,0x80,0x2E,0x31,1,0x80,0xC5,0x30,1,0x80,0xBE,0x30,1,
    0x80,0x27,0x33,1,0x80,0x1C,0x31,1,0x80,0x53,0x31,1,0x80,0x67,0x31,1,0x80,0x27,0x33,2,0x80,0x0C,0x31,2,
    0x80,0xC5,0x30,2,0x80,0x5C,0x32,2,0x80,0xC4,0x31,1,0x80,0x67,0x31,1,0x80,0x53,0x31,1,0x80,0x5C,0x32,1,
    0x80,0xFC,0x31,2,0x80,0x7C,0x31,1,0x80,0x80,0x32,3,0x80,0xAB,0x31,1,0x80,0xCF,0x31,1,0x80,0xA6,0x32,1,
    0x80,0xCE,0x32,2,0x80,0xCF,0x31,1,0x80,0x3A,0x32,1,0x80,0x80,0x32,1,0x80,0xF9,0x32,1,0x80,0x27,0x33,2,
    0x80,0x56,0x33,1,0x80,0xF9,0x32,1,0x80,0xF9,0x42,1,0x80,0x89,0x43,1,0x80,0xCE,0x42,1,0x80,0xA6,0x42,1,
    0x80,0x27,0x53,1,0x80,0x89,0x53,1,0x80,0xBF,0x53,1,0x80,0xF8,0x53,3,0x80,0x35,0x64,1,0x80,0x35,0x74,3,
    0x80,0x35,0x84,1,0x80,0xFF,0x83,3,0x80,0xFF,0x93,4,0x80,0xFF,0xA3,2,0x90
};

static unsigned char sound21[] = {
0x40,0x1D,0x31,12, //G-4
0x40,0x01,0x30,24, //BLANK Note
0x40,0xE2,0x30,12, //B-4
0x40,0x2E,0x31,12, //F#4
0x40,0x0D,0x31,12, //G#4
0x40,0xD6,0x30,12, //C-5
0x40,0x01,0x30,12, //BLANK Note
0x40,0x1D,0x31,12, //G-4
0x40,0x01,0x30,12, //BLANK Note
0x40,0x2E,0x31,12, //F#4
0x40,0xE2,0x30,12, //B-4
0x40,0x67,0x31,12, //D#4
0x40,0x01,0x30,12, //BLANK Note
0x40,0xD6,0x30,12, //C-5
0x40,0x01,0x30,12, //BLANK Note
0x40,0x1D,0x31,12, //G-4
0x40,0x01,0x30,12, //BLANK Note
0x40,0x67,0x31,12, //D#4
0x40,0xE2,0x30,12, //B-4
0x40,0x01,0x30,12, //BLANK Note
0x40,0x40,0x31,12, //F-4
0x40,0xD6,0x30,12, //C-5
0x40,0x01,0x30,12, //BLANK Note
0x40,0x1D,0x31,12, //G-4
0x40,0x01,0x30,24, //BLANK Note
0x40,0xE2,0x30,12, //B-4
0x40,0xCF,0x32,12, //D#3
0x40,0x01,0x30,12, //BLANK Note
0x40,0xD6,0x30,12, //C-5
0x40,0x01,0x30,12, //BLANK Note
0x40,0x1D,0x31,12, //G-4
0x40,0x67,0x31,12, //D#4
0x40,0x40,0x31,12, //F-4
0x40,0xE2,0x30,12, //B-4
0x40,0x01,0x30,12, //BLANK Note
0x40,0x40,0x31,12, //F-4
0x40,0xD6,0x30,12, //C-5
0x40,0x01,0x30,12, //BLANK Note
0x40,0x1D,0x31,12, //G-4
0x40,0x01,0x30,12, //BLANK Note
0x40,0x40,0x31,12, //F-4
0x40,0xE2,0x30,12, //B-4
0x40,0x01,0x30,24, //BLANK Note
0x40,0xD6,0x30,12, //C-5
0x40,0x01,0x30,12, //BLANK Note
0x40,0x1D,0x31,12, //G-4
0x40,0x01,0x30,24, //BLANK Note
0x40,0xE2,0x30,12, //B-4
0x40,0x1D,0x31,12, //G-4
0x40,0x40,0x31,12, //F-4
0x40,0xD6,0x30,12, //C-5
0x40,0x67,0x31,12, //D#4
0x40,0x1D,0x31,12, //G-4
0x40,0x01,0x30,24, //BLANK Note
0x40,0xE2,0x30,12, //B-4
0x40,0x01,0x30,24, //BLANK Note
0x40,0xD6,0x30,12, //C-5
0x90
};

static unsigned char sound22[] = {
    0xC0,0x5F,0x30,8, //D-6
    0xC0,0x01,0x30,3, //BLANK Note
    0xC0,0x47,0x30,8, //G-6
    0x90 
};


static unsigned short soundTable[48];

static void *table;
static void *nextnote;
static void *end;

void _play(unsigned char n)
{  
  eos_start_sound(n,end,nextnote,table);
}

static void farkle_nmi_play(void)
{
  M_PRESERVE_ALL;
  eos_play_sound();
  M_RESTORE_ALL;
}

void farkle_sound_init(void)
{
  Z80_registers r;
    
  r.Bytes.B = 6; // 6 output tables
  r.UWords.HL = &soundTable;

  // 18 sound fragments
  
  soundTable[0]=&sound10; soundTable[1]=&output1;
  soundTable[2]=&sound11; soundTable[3]=&output2;
  soundTable[4]=&sound12; soundTable[5]=&output3;
  soundTable[6]=&sound0; soundTable[7]=&output1;
  soundTable[8]=&sound1; soundTable[9]=&output2;
  soundTable[10]=&sound7; soundTable[11]=&output4;
  soundTable[12]=&sound8; soundTable[13]=&output5;
  soundTable[14]=&sound9; soundTable[15]=&output6;
  soundTable[16]=&sound2; soundTable[17]=&output4;
  soundTable[18]=&sound3; soundTable[19]=&output5;
  soundTable[20]=&sound4; soundTable[21]=&output1;
  soundTable[22]=&sound5; soundTable[23]=&output2;
  soundTable[24]=&sound6; soundTable[25]=&output2;
  soundTable[26]=&sound14; soundTable[27]=&output1;
  soundTable[28]=&sound15; soundTable[29]=&output1;
  soundTable[30]=&sound13; soundTable[31]=&output2;
  soundTable[32]=&sound16; soundTable[33]=&output4;  // Dice Roll - _play(17)
  soundTable[34]=&sound17; soundTable[35]=&output2;  // Dice Roll - _play(18)
  soundTable[36]=&sound18; soundTable[37]=&output2;  // Sproing - _play(19)
  soundTable[38]=&sound19; soundTable[39]=&output1;  // wellerman - _play(20)
  soundTable[40]=&sound20; soundTable[41]=&output2;  // ToxicTwos - _play(21)
  soundTable[42]=&sound21; soundTable[43]=&output1;  // Theme - _play(22)
  soundTable[44]=&sound22; soundTable[45]=&output3;  // Adam Comment - _play(23)

  AsmCall(0xFD50,&r,REGS_ALL,REGS_ALL);
  add_raster_int(farkle_nmi_play);
}

void farkle_sound_play(int sound) {
      switch(sound)
      {
      case SOUND_DICE_ROLL:
        _play(17);
        _play(18);
        break;
      case SOUND_SPROING:
        _play(19);
        break;
      case SOUND_THEME:
        _play(22);
        break;
      case SOUND_TOXIC_TWOS:
        _play(21);
        break;
      case SOUND_FARKLED:
        _play(7);
        break;
      case SOUND_COMMENT:
        _play(23);
        break;
      default:
        break;
      }

}
