#include <Arduino.h>
#include <pinmap.h>
#include <adamnet.h>
#include <globals.h>
#include <macros.h>
#include <queue>

byte b;
byte dev;
byte cmd;
byte transferCommand[9];
byte status[6] = {0x84, 0x00, 0x04, 0x01, 0x40, 0x45};
bool isIdle;

unsigned long longblock;
unsigned short block;
bool isIdle=false;

byte testBlock[1028] =
    {
        0xB4, 0x04, 0x00, // Header

        0x78, 0x32, 0x6f, 0xfd, 0xcd, 0x16, 0xc8, 0x21, 0x76, 0xc8, 0x11, 0x89,
        0x18, 0x01, 0x0e, 0x00, 0xcd, 0x1a, 0xfd, 0xc3, 0x13, 0xc8, 0x01, 0x00,
        0x00, 0xcd, 0x20, 0xfd, 0x01, 0xe0, 0x01, 0xcd, 0x20, 0xfd, 0x01, 0x05,
        0x07, 0xcd, 0x20, 0xfd, 0x3e, 0x00, 0x21, 0x00, 0x1b, 0xcd, 0x29, 0xfd,
        0x3e, 0x01, 0x21, 0x00, 0x38, 0xcd, 0x29, 0xfd, 0x3e, 0x02, 0x21, 0x00,
        0x18, 0xcd, 0x29, 0xfd, 0x3e, 0x03, 0x21, 0x00, 0x00, 0xcd, 0x29, 0xfd,
        0x3e, 0x04, 0x21, 0x00, 0x20, 0xcd, 0x29, 0xfd, 0xcd, 0x38, 0xfd, 0x21,
        0x00, 0x20, 0x3e, 0xf0, 0x11, 0x10, 0x00, 0xcd, 0x26, 0xfd, 0x21, 0x10,
        0x20, 0x3e, 0x7f, 0x11, 0x10, 0x00, 0xcd, 0x26, 0xfd, 0x01, 0x17, 0x1f,
        0x11, 0x00, 0x00, 0x21, 0x00, 0x38, 0xcd, 0x36, 0xfc, 0xc9, 0x42, 0x4c,
        0x4f, 0x43, 0x4b, 0x20, 0x30, 0x20, 0x4c, 0x6f, 0x61, 0x64, 0x65, 0x64,
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
        0x00, 0x00, 0x00, 0x00,

        0x04 // Checksum

};

/**
 * AdamNet RX ISR
 */
unsigned char adamnet_recv()
{
  byte incomingByte = 0;

  // Wait for Start bit transition
  while (digitalRead(PIN_ADAMNET_RX) == HIGH) { yield(); }

  // Delay for start-bit
  ets_delay_us(18);

  // Get Data Bits
  for (byte i = 8; i > 0; --i)
  {
    incomingByte >>= 1;
    if (digitalRead(PIN_ADAMNET_RX) == LOW) // low transition = 1 bit (inverted)
      incomingByte |= 0x80;
    else
      incomingByte |= 0x00;
    ets_delay_us(16); // Wait for next bit cell
  }
  
  // delay for stop bit
  ets_delay_us(16);
  Serial.printf("%02X ",incomingByte);
  return incomingByte;
}

/**
 * Send byte, then receive it, to get rid of the echo
 * @param b Byte to send
 */
void adamnet_send(byte b)
{
  SERIAL_ADAMNET.write(b);
  SERIAL_ADAMNET.read();
}

/**
 * Send string of bytes
 * @param buffer Buffer
 * @param len Length
 */
void adamnet_send_bytes(byte *b, int len)
{
  for (int i = 0; i < len; i++)
    adamnet_send(b[i]);
}

void adamnet_clear()
{
}

/**
 * Receive buffer of bytes.
 * @param buffer Buffer
 * @param len length
 */
void adamnet_recv_bytes(byte *b, int len)
{
  for (int i = 0; i < len; i++)
    b[i] = adamnet_recv();
}

/**
 * Is there anything available?
 * @return true if data availble
 */
bool adamnet_available()
{
  return (digitalRead(PIN_ADAMNET_RX) == LOW);
}

/**
 * Set up I/O Pins
 */
void setup_pins()
{
  pinMode(PIN_ADAMNET_RX, INPUT);
  pinMode(PIN_ADAMNET_TX, OUTPUT);
  pinMode(PIN_LED_BT, OUTPUT);
  pinMode(PIN_LED_SIO, OUTPUT);
  pinMode(PIN_LED_WIFI, OUTPUT);

  digitalWrite(PIN_ADAMNET_TX, HIGH); // So we don't contend the bus.
}

/**
 * Turn off all the LEDs
 */
void turn_off_all_leds()
{
  digitalWrite(PIN_LED_BT, HIGH);
  digitalWrite(PIN_LED_SIO, HIGH);
  digitalWrite(PIN_LED_WIFI, HIGH);
}

/**
 * Wait for AdamNet to be quiet
 * @return when AdamNet is idle
 */
void wait_for_idle()
{
  unsigned long start;
  unsigned long current;

  do
  {
    while (digitalRead(PIN_ADAMNET_RX) == HIGH)
    {
      yield();
    }

    start = micros();

    /* Wait for 900us for idle */
    while ((digitalRead(PIN_ADAMNET_RX) == LOW) && (isIdle == false))
    {
      current = micros();

      if (current - start > 2000)
      {
        isIdle = true;
        Serial.printf("Now Idle\n\n");
      }
    }
  } while (isIdle == false);
}

/**
 * Is this traffic for me?
 * @return true if incoming traffic is for me
 */
bool is_it_for_me()
{
  b = adamnet_recv();

  if (GET_DEVICE_ID(b) == MY_DEVICE)
  {
    SERIAL_DEBUG.printf("For me\n");
    dev = GET_DEVICE_ID(b);
    cmd = GET_COMMAND(b);
    return true;
  }

  return false;
}

/**
 * Process a STATUS command
 */
void command_status()
{
  SERIAL_DEBUG.printf("command_status()\n");
  ets_delay_us(150);
  adamnet_send_bytes(status, sizeof(status));
  b = adamnet_recv(); // Get the Ack
  SERIAL_DEBUG.printf("ACK! %02x", b);
}

/**
 * Process the CTS command, send the test block
 */
void command_cts()
{
  // We don't need to do a delay here, are we sure?
  adamnet_send_bytes(testBlock, sizeof(testBlock)); // send the test block
  b = adamnet_recv();

  switch (GET_COMMAND(b))
  {
  case COMMAND_CONTROL_ACK:
    // We are okay.
    break;
  case COMMAND_CONTROL_READY:
    // Really don't like how this control flow is happening.
    break;
  }
}

/**
 * Indicates the command is a read
 */
void command_data_send_control_receive()
{
  ets_delay_us(150);
  adamnet_send(BYTE_ACK);

  b = adamnet_recv();

  switch (GET_COMMAND(b))
  {
  case COMMAND_CONTROL_CTS:
    command_cts();
    break;
  }
}

/**
 * Process a COMMAND DATA SEND
 */
void command_data_send()
{
  // Acknowledge that we got the data send
  ets_delay_us(150);
  adamnet_send(BYTE_ACK);

  // Get control byte
  b = adamnet_recv();

  // grab wanted block, right now we are always in "compatibility mode"
  longblock = ((unsigned long)transferCommand[6] << 24) + ((unsigned long)transferCommand[5] << 16) + ((unsigned long)transferCommand[4] << 8) + transferCommand[3];
  block = longblock & 0xFFFF;

  switch (GET_COMMAND(b))
  {
  case COMMAND_CONTROL_RECEIVE:
    command_data_send_control_receive(); // Read
    break;
  }
}

/**
 * Process a READY command
 */
void command_ready()
{
  // Acknowledge that we got the Ready.
  ets_delay_us(150);
  adamnet_send(BYTE_ACK);

  // Get the data transfer command
  adamnet_recv_bytes(transferCommand, sizeof(transferCommand));

  switch (transferCommand[0] >> 4)
  {
  case COMMAND_DATA_SEND:
    command_data_send();
    break;
  }
}

/**
 * Command outer loop
 */
void command()
{
  digitalWrite(PIN_LED_SIO, LOW);
  SERIAL_DEBUG.printf("command(%02x)\n", cmd);
  switch (cmd)
  {
  case COMMAND_CONTROL_STATUS:
    command_status();
    break;
  case COMMAND_CONTROL_READY:
    command_ready();
    break;
  }
  digitalWrite(PIN_LED_SIO, HIGH);
}

/**
 * Set up serial ports
 */
void setup_serial_ports()
{
  // Set up debug UART
  SERIAL_DEBUG.begin(921600);
}

void setup()
{
  setup_pins();
  turn_off_all_leds();
  setup_serial_ports();
  SERIAL_DEBUG.printf("\n\n\n#FujiNet AdamNet Test #4\n\n Ready.\n");
}

void loop()
{
  if (adamnet_available() && is_it_for_me())
    command();
  else
    wait_for_idle();
}
