/* -*-  mode:c; tab-width:8; c-basic-offset:8; indent-tabs-mode:nil;  -*- */
/*
   Copyright (C) 2016 by Ronnie Sahlberg <ronniesahlberg@gmail.com>

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU Lesser General Public License as published by
   the Free Software Foundation; either version 2.1 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU Lesser General Public License for more details.

   You should have received a copy of the GNU Lesser General Public License
   along with this program; if not, see <http://www.gnu.org/licenses/>.
*/

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#include <errno.h>

#ifdef HAVE_STDINT_H
#include <stdint.h>
#endif

#if !defined(PS2_EE_PLATFORM) && !defined(PS2_IOP_PLATFORM)
#include <sys/socket.h>
#endif

#include "compat.h"

#include "smb2.h"

const char *nterror_to_str(uint32_t status) {
        switch (status) {
        case SMB2_STATUS_SUCCESS:
                return "STATUS_SUCCESS";
        case SMB2_STATUS_ABORTED:
                return "STATUS_ABORTED";
        case SMB2_STATUS_PENDING:
                return "STATUS_PENDING";
        case SMB2_STATUS_NO_MORE_FILES:
                return "STATUS_NO_MORE_FILES";
        case SMB2_STATUS_UNSUCCESSFUL:
                return "SMB2_STATUS_UNSUCCESSFUL";
        case SMB2_STATUS_NOT_IMPLEMENTED:
                return "STATUS_NOT_IMPLEMENTED";
        case SMB2_STATUS_INVALID_INFO_CLASS:
                return "SMB2_STATUS_INVALID_INFO_CLASS";
        case SMB2_STATUS_INFO_LENGTH_MISMATCH:
                return "SMB2_STATUS_INFO_LENGTH_MISMATCH";
        case SMB2_STATUS_ACCESS_VIOLATION:
                return "SMB2_STATUS_ACCESS_VIOLATION";
        case SMB2_STATUS_IN_PAGE_ERROR:
                return "SMB2_STATUS_IN_PAGE_ERROR";
        case SMB2_STATUS_PAGEFILE_QUOTA:
                return "SMB2_STATUS_PAGEFILE_QUOTA";
        case SMB2_STATUS_INVALID_HANDLE:
                return "STATUS_INVALID_HANDLE";
        case SMB2_STATUS_BAD_INITIAL_STACK:
                return "SMB2_STATUS_BAD_INITIAL_STACK";
        case SMB2_STATUS_BAD_INITIAL_PC:
                return "SMB2_STATUS_BAD_INITIAL_PC";
        case SMB2_STATUS_INVALID_CID:
                return "SMB2_STATUS_INVALID_CID";
        case SMB2_STATUS_TIMER_NOT_CANCELED:
                return "SMB2_STATUS_TIMER_NOT_CANCELED";
        case SMB2_STATUS_INVALID_PARAMETER:
                return "STATUS_INVALID_PARAMETER";
        case SMB2_STATUS_NO_SUCH_DEVICE:
                return "STATUS_NO_SUCH_DEVICE";
        case SMB2_STATUS_NO_SUCH_FILE:
                return "STATUS_NO_SUCH_FILE";
        case SMB2_STATUS_INVALID_DEVICE_REQUEST:
                return "STATUS_INVALID_DEVICE_REQUEST";
        case SMB2_STATUS_END_OF_FILE:
                return "STATUS_END_OF_FILE";
        case SMB2_STATUS_WRONG_VOLUME:
                return "SMB2_STATUS_WRONG_VOLUME";
        case SMB2_STATUS_NO_MEDIA_IN_DEVICE:
                return "STATUS_NO_MEDIA_IN_DEVICE";
        case SMB2_STATUS_UNRECOGNIZED_MEDIA:
                return "SMB2_STATUS_UNRECOGNIZED_MEDIA";
        case SMB2_STATUS_NONEXISTENT_SECTOR:
                return "SMB2_STATUS_NONEXISTENT_SECTOR";
        case SMB2_STATUS_MORE_PROCESSING_REQUIRED:
                return "STATUS_MORE_PROCESSING_REQUIRED";
        case SMB2_STATUS_NO_MEMORY:
                return "SMB2_STATUS_NO_MEMORY";
        case SMB2_STATUS_CONFLICTING_ADDRESSES:
                return "SMB2_STATUS_CONFLICTING_ADDRESSES";
        case SMB2_STATUS_NOT_MAPPED_VIEW:
                return "SMB2_STATUS_NOT_MAPPED_VIEW";
        case SMB2_STATUS_UNABLE_TO_FREE_VM:
                return "SMB2_STATUS_UNABLE_TO_FREE_VM";
        case SMB2_STATUS_UNABLE_TO_DELETE_SECTION:
                return "SMB2_STATUS_UNABLE_TO_DELETE_SECTION";
        case SMB2_STATUS_INVALID_SYSTEM_SERVICE:
                return "SMB2_STATUS_INVALID_SYSTEM_SERVICE";
        case SMB2_STATUS_ILLEGAL_INSTRUCTION:
                return "SMB2_STATUS_ILLEGAL_INSTRUCTION";
        case SMB2_STATUS_INVALID_LOCK_SEQUENCE:
                return "STATUS_INVALID_LOCK_SEQUENCE";
        case SMB2_STATUS_INVALID_VIEW_SIZE:
                return "STATUS_INVALID_VIEW_SIZE";
        case SMB2_STATUS_INVALID_FILE_FOR_SECTION:
                return "SMB2_STATUS_INVALID_FILE_FOR_SECTION";
        case SMB2_STATUS_ALREADY_COMMITTED:
                return "STATUS_ALREADY_COMMITTED";
        case SMB2_STATUS_ACCESS_DENIED:
                return "STATUS_ACCESS_DENIED";
        case SMB2_STATUS_BUFFER_TOO_SMALL:
                return "SMB2_STATUS_BUFFER_TOO_SMALL";
        case SMB2_STATUS_OBJECT_TYPE_MISMATCH:
                return "STATUS_OBJECT_TYPE_MISMATCH";
        case SMB2_STATUS_NONCONTINUABLE_EXCEPTION:
                return "SMB2_STATUS_NONCONTINUABLE_EXCEPTION";
        case SMB2_STATUS_INVALID_DISPOSITION:
                return "SMB2_STATUS_INVALID_DISPOSITION";
        case SMB2_STATUS_UNWIND:
                return "SMB2_STATUS_UNWIND";
        case SMB2_STATUS_BAD_STACK:
                return "SMB2_STATUS_BAD_STACK";
        case SMB2_STATUS_INVALID_UNWIND_TARGET:
                return "SMB2_STATUS_INVALID_UNWIND_TARGET";
        case SMB2_STATUS_NOT_LOCKED:
                return "SMB2_STATUS_NOT_LOCKED";
        case SMB2_STATUS_PARITY_ERROR:
                return "SMB2_STATUS_PARITY_ERROR";
        case SMB2_STATUS_UNABLE_TO_DECOMMIT_VM:
                return "SMB2_STATUS_UNABLE_TO_DECOMMIT_VM";
        case SMB2_STATUS_NOT_COMMITTED:
                return "SMB2_STATUS_NOT_COMMITTED";
        case SMB2_STATUS_INVALID_PORT_ATTRIBUTES:
                return "SMB2_STATUS_INVALID_PORT_ATTRIBUTES";
        case SMB2_STATUS_PORT_MESSAGE_TOO_LONG:
                return "SMB2_STATUS_PORT_MESSAGE_TOO_LONG";
        case SMB2_STATUS_INVALID_PARAMETER_MIX:
                return "SMB2_STATUS_INVALID_PARAMETER_MIX";
        case SMB2_STATUS_INVALID_QUOTA_LOWER:
                return "SMB2_STATUS_INVALID_QUOTA_LOWER";
        case SMB2_STATUS_DISK_CORRUPT_ERROR:
                return "SMB2_STATUS_DISK_CORRUPT_ERROR";
        case SMB2_STATUS_OBJECT_NAME_INVALID:
                return "STATUS_OBJECT_NAME_INVALID";
        case SMB2_STATUS_OBJECT_NAME_NOT_FOUND:
                return "STATUS_OBJECT_NAME_NOT_FOUND";
        case SMB2_STATUS_OBJECT_NAME_COLLISION:
                return "STATUS_OBJECT_NAME_COLLISION";
        case SMB2_STATUS_HANDLE_NOT_WAITABLE:
                return "SMB2_STATUS_HANDLE_NOT_WAITABLE";
        case SMB2_STATUS_PORT_DISCONNECTED:
                return "STATUS_PORT_DISCONNECTED";
        case SMB2_STATUS_DEVICE_ALREADY_ATTACHED:
                return "SMB2_STATUS_DEVICE_ALREADY_ATTACHED";
        case SMB2_STATUS_OBJECT_PATH_INVALID:
                return "STATUS_OBJECT_PATH_INVALID";
        case SMB2_STATUS_OBJECT_PATH_NOT_FOUND:
                return "STATUS_OBJECT_PATH_NOT_FOUND";
        case SMB2_STATUS_OBJECT_PATH_SYNTAX_BAD:
                return "STATUS_OBJECT_PATH_SYNTAX_BAD";
        case SMB2_STATUS_DATA_OVERRUN:
                return "SMB2_STATUS_DATA_OVERRUN";
        case SMB2_STATUS_DATA_LATE_ERROR:
                return "SMB2_STATUS_DATA_LATE_ERROR";
        case SMB2_STATUS_DATA_ERROR:
                return "STATUS_DATA_ERROR";
        case SMB2_STATUS_CRC_ERROR:
                return "STATUS_CRC_ERROR";
        case SMB2_STATUS_SECTION_TOO_BIG:
                return "STATUS_SECTION_TOO_BIG";
        case SMB2_STATUS_PORT_CONNECTION_REFUSED:
                return "STATUS_PORT_CONNECTION_REFUSED";
        case SMB2_STATUS_INVALID_PORT_HANDLE:
                return "STATUS_INVALID_PORT_HANDLE";
        case SMB2_STATUS_SHARING_VIOLATION:
                return "STATUS_SHARING_VIOLATION";
        case SMB2_STATUS_QUOTA_EXCEEDED:
                return "SMB2_STATUS_QUOTA_EXCEEDED";
        case SMB2_STATUS_INVALID_PAGE_PROTECTION:
                return "SMB2_STATUS_INVALID_PAGE_PROTECTION";
        case SMB2_STATUS_MUTANT_NOT_OWNED:
                return "SMB2_STATUS_MUTANT_NOT_OWNED";
        case SMB2_STATUS_SEMAPHORE_LIMIT_EXCEEDED:
                return "SMB2_STATUS_SEMAPHORE_LIMIT_EXCEEDED";
        case SMB2_STATUS_PORT_ALREADY_SET:
                return "SMB2_STATUS_PORT_ALREADY_SET";
        case SMB2_STATUS_SECTION_NOT_IMAGE:
                return "SMB2_STATUS_SECTION_NOT_IMAGE";
        case SMB2_STATUS_SUSPEND_COUNT_EXCEEDED:
                return "SMB2_STATUS_SUSPEND_COUNT_EXCEEDED";
        case SMB2_STATUS_THREAD_IS_TERMINATING:
                return "STATUS_THREAD_IS_TERMINATING";
        case SMB2_STATUS_BAD_WORKING_SET_LIMIT:
                return "SMB2_STATUS_BAD_WORKING_SET_LIMIT";
        case SMB2_STATUS_INCOMPATIBLE_FILE_MAP:
                return "SMB2_STATUS_INCOMPATIBLE_FILE_MAP";
        case SMB2_STATUS_SECTION_PROTECTION:
                return "SMB2_STATUS_SECTION_PROTECTION";
        case SMB2_STATUS_EAS_NOT_SUPPORTED:
                return "SMB2_STATUS_EAS_NOT_SUPPORTED";
        case SMB2_STATUS_EA_TOO_LARGE:
                return "SMB2_STATUS_EA_TOO_LARGE";
        case SMB2_STATUS_NONEXISTENT_EA_ENTRY:
                return "SMB2_STATUS_NONEXISTENT_EA_ENTRY";
        case SMB2_STATUS_NO_EAS_ON_FILE:
                return "SMB2_STATUS_NO_EAS_ON_FILE";
        case SMB2_STATUS_EA_CORRUPT_ERROR:
                return "SMB2_STATUS_EA_CORRUPT_ERROR";
        case SMB2_STATUS_FILE_LOCK_CONFLICT:
                return "STATUS_FILE_LOCK_CONFLICT";
        case SMB2_STATUS_LOCK_NOT_GRANTED:
                return "STATUS_LOCK_NOT_GRANTED";
        case SMB2_STATUS_DELETE_PENDING:
                return "STATUS_DELETE_PENDING";
        case SMB2_STATUS_CTL_FILE_NOT_SUPPORTED:
                return "SMB2_STATUS_CTL_FILE_NOT_SUPPORTED";
        case SMB2_STATUS_UNKNOWN_REVISION:
                return "SMB2_STATUS_UNKNOWN_REVISION";
        case SMB2_STATUS_REVISION_MISMATCH:
                return "SMB2_STATUS_REVISION_MISMATCH";
        case SMB2_STATUS_INVALID_OWNER:
                return "SMB2_STATUS_INVALID_OWNER";
        case SMB2_STATUS_INVALID_PRIMARY_GROUP:
                return "SMB2_STATUS_INVALID_PRIMARY_GROUP";
        case SMB2_STATUS_NO_IMPERSONATION_TOKEN:
                return "SMB2_STATUS_NO_IMPERSONATION_TOKEN";
        case SMB2_STATUS_CANT_DISABLE_MANDATORY:
                return "SMB2_STATUS_CANT_DISABLE_MANDATORY";
        case SMB2_STATUS_NO_LOGON_SERVERS:
                return "SMB2_STATUS_NO_LOGON_SERVERS";
        case SMB2_STATUS_NO_SUCH_LOGON_SESSION:
                return "SMB2_STATUS_NO_SUCH_LOGON_SESSION";
        case SMB2_STATUS_NO_SUCH_PRIVILEGE:
                return "SMB2_STATUS_NO_SUCH_PRIVILEGE";
        case SMB2_STATUS_PRIVILEGE_NOT_HELD:
                return "STATUS_PRIVILEGE_NOT_HELD";
        case SMB2_STATUS_INVALID_ACCOUNT_NAME:
                return "SMB2_STATUS_INVALID_ACCOUNT_NAME";
        case SMB2_STATUS_USER_EXISTS:
                return "SMB2_STATUS_USER_EXISTS";
        case SMB2_STATUS_NO_SUCH_USER:
                return "SMB2_STATUS_NO_SUCH_USER";
        case SMB2_STATUS_GROUP_EXISTS:
                return "SMB2_STATUS_GROUP_EXISTS";
        case SMB2_STATUS_NO_SUCH_GROUP:
                return "SMB2_STATUS_NO_SUCH_GROUP";
        case SMB2_STATUS_MEMBER_IN_GROUP:
                return "SMB2_STATUS_MEMBER_IN_GROUP";
        case SMB2_STATUS_MEMBER_NOT_IN_GROUP:
                return "SMB2_STATUS_MEMBER_NOT_IN_GROUP";
        case SMB2_STATUS_LAST_ADMIN:
                return "SMB2_STATUS_LAST_ADMIN";
        case SMB2_STATUS_WRONG_PASSWORD:
                return "SMB2_STATUS_WRONG_PASSWORD";
        case SMB2_STATUS_ILL_FORMED_PASSWORD:
                return "SMB2_STATUS_ILL_FORMED_PASSWORD";
        case SMB2_STATUS_PASSWORD_RESTRICTION:
                return "SMB2_STATUS_PASSWORD_RESTRICTION";
        case SMB2_STATUS_LOGON_FAILURE:
                return "STATUS_LOGON_FAILURE";
        case SMB2_STATUS_ACCOUNT_RESTRICTION:
                return "STATUS_ACCOUNT_RESTRICTION";
        case SMB2_STATUS_INVALID_LOGON_HOURS:
                return "STATUS_INVALID_LOGON_HOURS";
        case SMB2_STATUS_INVALID_WORKSTATION:
                return "SMB2_STATUS_INVALID_WORKSTATION";
        case SMB2_STATUS_PASSWORD_EXPIRED:
                return "STATUS_PASSWORD_EXPIRED";
        case SMB2_STATUS_ACCOUNT_DISABLED:
                return "STATUS_ACCOUNT_DISABLED";
        case SMB2_STATUS_NONE_MAPPED:
                return "SMB2_STATUS_NONE_MAPPED";
        case SMB2_STATUS_TOO_MANY_LUIDS_REQUESTED:
                return "SMB2_STATUS_TOO_MANY_LUIDS_REQUESTED";
        case SMB2_STATUS_LUIDS_EXHAUSTED:
                return "SMB2_STATUS_LUIDS_EXHAUSTED";
        case SMB2_STATUS_INVALID_SUB_AUTHORITY:
                return "SMB2_STATUS_INVALID_SUB_AUTHORITY";
        case SMB2_STATUS_INVALID_ACL:
                return "SMB2_STATUS_INVALID_ACL";
        case SMB2_STATUS_INVALID_SID:
                return "SMB2_STATUS_INVALID_SID";
        case SMB2_STATUS_INVALID_SECURITY_DESCR:
                return "SMB2_STATUS_INVALID_SECURITY_DESCR";
        case SMB2_STATUS_PROCEDURE_NOT_FOUND:
                return "SMB2_STATUS_PROCEDURE_NOT_FOUND";
        case SMB2_STATUS_INVALID_IMAGE_FORMAT:
                return "SMB2_STATUS_INVALID_IMAGE_FORMAT";
        case SMB2_STATUS_NO_TOKEN:
                return "SMB2_STATUS_NO_TOKEN";
        case SMB2_STATUS_BAD_INHERITANCE_ACL:
                return "SMB2_STATUS_BAD_INHERITANCE_ACL";
        case SMB2_STATUS_RANGE_NOT_LOCKED:
                return "SMB2_STATUS_RANGE_NOT_LOCKED";
        case SMB2_STATUS_DISK_FULL:
                return "STATUS_DISK_FULL";
        case SMB2_STATUS_SERVER_DISABLED:
                return "SMB2_STATUS_SERVER_DISABLED";
        case SMB2_STATUS_SERVER_NOT_DISABLED:
                return "SMB2_STATUS_SERVER_NOT_DISABLED";
        case SMB2_STATUS_TOO_MANY_GUIDS_REQUESTED:
                return "SMB2_STATUS_TOO_MANY_GUIDS_REQUESTED";
        case SMB2_STATUS_GUIDS_EXHAUSTED:
                return "SMB2_STATUS_GUIDS_EXHAUSTED";
        case SMB2_STATUS_INVALID_ID_AUTHORITY:
                return "SMB2_STATUS_INVALID_ID_AUTHORITY";
        case SMB2_STATUS_AGENTS_EXHAUSTED:
                return "SMB2_STATUS_AGENTS_EXHAUSTED";
        case SMB2_STATUS_INVALID_VOLUME_LABEL:
                return "SMB2_STATUS_INVALID_VOLUME_LABEL";
        case SMB2_STATUS_SECTION_NOT_EXTENDED:
                return "SMB2_STATUS_SECTION_NOT_EXTENDED";
        case SMB2_STATUS_NOT_MAPPED_DATA:
                return "SMB2_STATUS_NOT_MAPPED_DATA";
        case SMB2_STATUS_RESOURCE_DATA_NOT_FOUND:
                return "SMB2_STATUS_RESOURCE_DATA_NOT_FOUND";
        case SMB2_STATUS_RESOURCE_TYPE_NOT_FOUND:
                return "SMB2_STATUS_RESOURCE_TYPE_NOT_FOUND";
        case SMB2_STATUS_RESOURCE_NAME_NOT_FOUND:
                return "SMB2_STATUS_RESOURCE_NAME_NOT_FOUND";
        case SMB2_STATUS_ARRAY_BOUNDS_EXCEEDED:
                return "SMB2_STATUS_ARRAY_BOUNDS_EXCEEDED";
        case SMB2_STATUS_FLOAT_DENORMAL_OPERAND:
                return "SMB2_STATUS_FLOAT_DENORMAL_OPERAND";
        case SMB2_STATUS_FLOAT_DIVIDE_BY_ZERO:
                return "SMB2_STATUS_FLOAT_DIVIDE_BY_ZERO";
        case SMB2_STATUS_FLOAT_INEXACT_RESULT:
                return "SMB2_STATUS_FLOAT_INEXACT_RESULT";
        case SMB2_STATUS_FLOAT_INVALID_OPERATION:
                return "SMB2_STATUS_FLOAT_INVALID_OPERATION";
        case SMB2_STATUS_FLOAT_OVERFLOW:
                return "SMB2_STATUS_FLOAT_OVERFLOW";
        case SMB2_STATUS_FLOAT_STACK_CHECK:
                return "SMB2_STATUS_FLOAT_STACK_CHECK";
        case SMB2_STATUS_FLOAT_UNDERFLOW:
                return "SMB2_STATUS_FLOAT_UNDERFLOW";
        case SMB2_STATUS_INTEGER_DIVIDE_BY_ZERO:
                return "SMB2_STATUS_INTEGER_DIVIDE_BY_ZERO";
        case SMB2_STATUS_INTEGER_OVERFLOW:
                return "SMB2_STATUS_INTEGER_OVERFLOW";
        case SMB2_STATUS_PRIVILEGED_INSTRUCTION:
                return "SMB2_STATUS_PRIVILEGED_INSTRUCTION";
        case SMB2_STATUS_TOO_MANY_PAGING_FILES:
                return "STATUS_TOO_MANY_PAGING_FILES";
        case SMB2_STATUS_FILE_INVALID:
                return "SMB2_STATUS_FILE_INVALID";
        case SMB2_STATUS_ALLOTTED_SPACE_EXCEEDED:
                return "SMB2_STATUS_ALLOTTED_SPACE_EXCEEDED";
        case SMB2_STATUS_INSUFFICIENT_RESOURCES:
                return "SMB2_STATUS_INSUFFICIENT_RESOURCES";
        case SMB2_STATUS_DFS_EXIT_PATH_FOUND:
                return "STATUS_DFS_EXIT_PATH_FOUND";
        case SMB2_STATUS_DEVICE_DATA_ERROR:
                return "STATUS_DEVICE_DATA_ERROR";
        case SMB2_STATUS_DEVICE_NOT_CONNECTED:
                return "SMB2_STATUS_DEVICE_NOT_CONNECTED";
        case SMB2_STATUS_DEVICE_POWER_FAILURE:
                return "SMB2_STATUS_DEVICE_POWER_FAILURE";
        case SMB2_STATUS_FREE_VM_NOT_AT_BASE:
                return "SMB2_STATUS_FREE_VM_NOT_AT_BASE";
        case SMB2_STATUS_MEMORY_NOT_ALLOCATED:
                return "SMB2_STATUS_MEMORY_NOT_ALLOCATED";
        case SMB2_STATUS_WORKING_SET_QUOTA:
                return "SMB2_STATUS_WORKING_SET_QUOTA";
        case SMB2_STATUS_MEDIA_WRITE_PROTECTED:
                return "STATUS_MEDIA_WRITE_PROTECTED";
        case SMB2_STATUS_DEVICE_NOT_READY:
                return "SMB2_STATUS_DEVICE_NOT_READY";
        case SMB2_STATUS_INVALID_GROUP_ATTRIBUTES:
                return "SMB2_STATUS_INVALID_GROUP_ATTRIBUTES";
        case SMB2_STATUS_BAD_IMPERSONATION_LEVEL:
                return "SMB2_STATUS_BAD_IMPERSONATION_LEVEL";
        case SMB2_STATUS_CANT_OPEN_ANONYMOUS:
                return "SMB2_STATUS_CANT_OPEN_ANONYMOUS";
        case SMB2_STATUS_BAD_VALIDATION_CLASS:
                return "SMB2_STATUS_BAD_VALIDATION_CLASS";
        case SMB2_STATUS_BAD_TOKEN_TYPE:
                return "SMB2_STATUS_BAD_TOKEN_TYPE";
        case SMB2_STATUS_BAD_MASTER_BOOT_RECORD:
                return "SMB2_STATUS_BAD_MASTER_BOOT_RECORD";
        case SMB2_STATUS_INSTRUCTION_MISALIGNMENT:
                return "SMB2_STATUS_INSTRUCTION_MISALIGNMENT";
        case SMB2_STATUS_INSTANCE_NOT_AVAILABLE:
                return "SMB2_STATUS_INSTANCE_NOT_AVAILABLE";
        case SMB2_STATUS_PIPE_NOT_AVAILABLE:
                return "SMB2_STATUS_PIPE_NOT_AVAILABLE";
        case SMB2_STATUS_INVALID_PIPE_STATE:
                return "SMB2_STATUS_INVALID_PIPE_STATE";
        case SMB2_STATUS_PIPE_BUSY:
                return "SMB2_STATUS_PIPE_BUSY";
        case SMB2_STATUS_ILLEGAL_FUNCTION:
                return "STATUS_ILLEGAL_FUNCTION";
        case SMB2_STATUS_PIPE_DISCONNECTED:
                return "STATUS_PIPE_DISCONNECTED";
        case SMB2_STATUS_PIPE_CLOSING:
                return "SMB2_STATUS_PIPE_CLOSING";
        case SMB2_STATUS_PIPE_CONNECTED:
                return "SMB2_STATUS_PIPE_CONNECTED";
        case SMB2_STATUS_PIPE_LISTENING:
                return "SMB2_STATUS_PIPE_LISTENING";
        case SMB2_STATUS_INVALID_READ_MODE:
                return "SMB2_STATUS_INVALID_READ_MODE";
        case SMB2_STATUS_IO_TIMEOUT:
                return "SMB2_STATUS_IO_TIMEOUT";
        case SMB2_STATUS_FILE_FORCED_CLOSED:
                return "SMB2_STATUS_FILE_FORCED_CLOSED";
        case SMB2_STATUS_PROFILING_NOT_STARTED:
                return "SMB2_STATUS_PROFILING_NOT_STARTED";
        case SMB2_STATUS_PROFILING_NOT_STOPPED:
                return "SMB2_STATUS_PROFILING_NOT_STOPPED";
        case SMB2_STATUS_COULD_NOT_INTERPRET:
                return "SMB2_STATUS_COULD_NOT_INTERPRET";
        case SMB2_STATUS_FILE_IS_A_DIRECTORY:
                return "STATUS_FILE_IS_A_DIRECTORY";
        case SMB2_STATUS_NOT_SUPPORTED:
                return "SMB2_STATUS_NOT_SUPPORTED";
        case SMB2_STATUS_REMOTE_NOT_LISTENING:
                return "SMB2_STATUS_REMOTE_NOT_LISTENING";
        case SMB2_STATUS_DUPLICATE_NAME:
                return "SMB2_STATUS_DUPLICATE_NAME";
        case SMB2_STATUS_BAD_NETWORK_PATH:
                return "SMB2_STATUS_BAD_NETWORK_PATH";
        case SMB2_STATUS_NETWORK_BUSY:
                return "SMB2_STATUS_NETWORK_BUSY";
        case SMB2_STATUS_DEVICE_DOES_NOT_EXIST:
                return "SMB2_STATUS_DEVICE_DOES_NOT_EXIST";
        case SMB2_STATUS_TOO_MANY_COMMANDS:
                return "SMB2_STATUS_TOO_MANY_COMMANDS";
        case SMB2_STATUS_ADAPTER_HARDWARE_ERROR:
                return "SMB2_STATUS_ADAPTER_HARDWARE_ERROR";
        case SMB2_STATUS_INVALID_NETWORK_RESPONSE:
                return "SMB2_STATUS_INVALID_NETWORK_RESPONSE";
        case SMB2_STATUS_UNEXPECTED_NETWORK_ERROR:
                return "SMB2_STATUS_UNEXPECTED_NETWORK_ERROR";
        case SMB2_STATUS_BAD_REMOTE_ADAPTER:
                return "SMB2_STATUS_BAD_REMOTE_ADAPTER";
        case SMB2_STATUS_PRINT_QUEUE_FULL:
                return "SMB2_STATUS_PRINT_QUEUE_FULL";
        case SMB2_STATUS_NO_SPOOL_SPACE:
                return "SMB2_STATUS_NO_SPOOL_SPACE";
        case SMB2_STATUS_PRINT_CANCELLED:
                return "SMB2_STATUS_PRINT_CANCELLED";
        case SMB2_STATUS_NETWORK_NAME_DELETED:
                return "SMB2_STATUS_NETWORK_NAME_DELETED";
        case SMB2_STATUS_NETWORK_ACCESS_DENIED:
                return "STATUS_NETWORK_ACCESS_DENIED";
        case SMB2_STATUS_BAD_DEVICE_TYPE:
                return "SMB2_STATUS_BAD_DEVICE_TYPE";
        case SMB2_STATUS_BAD_NETWORK_NAME:
                return "STATUS_BAD_NETWORK_NAME";
        case SMB2_STATUS_TOO_MANY_NAMES:
                return "SMB2_STATUS_TOO_MANY_NAMES";
        case SMB2_STATUS_TOO_MANY_SESSIONS:
                return "SMB2_STATUS_TOO_MANY_SESSIONS";
        case SMB2_STATUS_SHARING_PAUSED:
                return "SMB2_STATUS_SHARING_PAUSED";
        case SMB2_STATUS_REQUEST_NOT_ACCEPTED:
                return "SMB2_STATUS_REQUEST_NOT_ACCEPTED";
        case SMB2_STATUS_REDIRECTOR_PAUSED:
                return "SMB2_STATUS_REDIRECTOR_PAUSED";
        case SMB2_STATUS_NET_WRITE_FAULT:
                return "SMB2_STATUS_NET_WRITE_FAULT";
        case SMB2_STATUS_PROFILING_AT_LIMIT:
                return "SMB2_STATUS_PROFILING_AT_LIMIT";
        case SMB2_STATUS_NOT_SAME_DEVICE:
                return "STATUS_NOT_SAME_DEVICE";
        case SMB2_STATUS_FILE_RENAMED:
                return "STATUS_FILE_RENAMED";
        case SMB2_STATUS_VIRTUAL_CIRCUIT_CLOSED:
                return "SMB2_STATUS_VIRTUAL_CIRCUIT_CLOSED";
        case SMB2_STATUS_NO_SECURITY_ON_OBJECT:
                return "SMB2_STATUS_NO_SECURITY_ON_OBJECT";
        case SMB2_STATUS_CANT_WAIT:
                return "SMB2_STATUS_CANT_WAIT";
        case SMB2_STATUS_PIPE_EMPTY:
                return "SMB2_STATUS_PIPE_EMPTY";
        case SMB2_STATUS_CANT_ACCESS_DOMAIN_INFO:
                return "SMB2_STATUS_CANT_ACCESS_DOMAIN_INFO";
        case SMB2_STATUS_CANT_TERMINATE_SELF:
                return "SMB2_STATUS_CANT_TERMINATE_SELF";
        case SMB2_STATUS_INVALID_SERVER_STATE:
                return "SMB2_STATUS_INVALID_SERVER_STATE";
        case SMB2_STATUS_INVALID_DOMAIN_STATE:
                return "SMB2_STATUS_INVALID_DOMAIN_STATE";
        case SMB2_STATUS_INVALID_DOMAIN_ROLE:
                return "SMB2_STATUS_INVALID_DOMAIN_ROLE";
        case SMB2_STATUS_NO_SUCH_DOMAIN:
                return "SMB2_STATUS_NO_SUCH_DOMAIN";
        case SMB2_STATUS_DOMAIN_EXISTS:
                return "SMB2_STATUS_DOMAIN_EXISTS";
        case SMB2_STATUS_DOMAIN_LIMIT_EXCEEDED:
                return "SMB2_STATUS_DOMAIN_LIMIT_EXCEEDED";
        case SMB2_STATUS_OPLOCK_NOT_GRANTED:
                return "SMB2_STATUS_OPLOCK_NOT_GRANTED";
        case SMB2_STATUS_INVALID_OPLOCK_PROTOCOL:
                return "SMB2_STATUS_INVALID_OPLOCK_PROTOCOL";
        case SMB2_STATUS_INTERNAL_DB_CORRUPTION:
                return "SMB2_STATUS_INTERNAL_DB_CORRUPTION";
        case SMB2_STATUS_INTERNAL_ERROR:
                return "SMB2_STATUS_INTERNAL_ERROR";
        case SMB2_STATUS_GENERIC_NOT_MAPPED:
                return "SMB2_STATUS_GENERIC_NOT_MAPPED";
        case SMB2_STATUS_BAD_DESCRIPTOR_FORMAT:
                return "SMB2_STATUS_BAD_DESCRIPTOR_FORMAT";
        case SMB2_STATUS_INVALID_USER_BUFFER:
                return "SMB2_STATUS_INVALID_USER_BUFFER";
        case SMB2_STATUS_UNEXPECTED_IO_ERROR:
                return "SMB2_STATUS_UNEXPECTED_IO_ERROR";
        case SMB2_STATUS_UNEXPECTED_MM_CREATE_ERR:
                return "SMB2_STATUS_UNEXPECTED_MM_CREATE_ERR";
        case SMB2_STATUS_UNEXPECTED_MM_MAP_ERROR:
                return "SMB2_STATUS_UNEXPECTED_MM_MAP_ERROR";
        case SMB2_STATUS_UNEXPECTED_MM_EXTEND_ERR:
                return "SMB2_STATUS_UNEXPECTED_MM_EXTEND_ERR";
        case SMB2_STATUS_NOT_LOGON_PROCESS:
                return "SMB2_STATUS_NOT_LOGON_PROCESS";
        case SMB2_STATUS_LOGON_SESSION_EXISTS:
                return "SMB2_STATUS_LOGON_SESSION_EXISTS";
        case SMB2_STATUS_INVALID_PARAMETER_1:
                return "SMB2_STATUS_INVALID_PARAMETER_1";
        case SMB2_STATUS_INVALID_PARAMETER_2:
                return "SMB2_STATUS_INVALID_PARAMETER_2";
        case SMB2_STATUS_INVALID_PARAMETER_3:
                return "SMB2_STATUS_INVALID_PARAMETER_3";
        case SMB2_STATUS_INVALID_PARAMETER_4:
                return "SMB2_STATUS_INVALID_PARAMETER_4";
        case SMB2_STATUS_INVALID_PARAMETER_5:
                return "SMB2_STATUS_INVALID_PARAMETER_5";
        case SMB2_STATUS_INVALID_PARAMETER_6:
                return "SMB2_STATUS_INVALID_PARAMETER_6";
        case SMB2_STATUS_INVALID_PARAMETER_7:
                return "SMB2_STATUS_INVALID_PARAMETER_7";
        case SMB2_STATUS_INVALID_PARAMETER_8:
                return "SMB2_STATUS_INVALID_PARAMETER_8";
        case SMB2_STATUS_INVALID_PARAMETER_9:
                return "SMB2_STATUS_INVALID_PARAMETER_9";
        case SMB2_STATUS_INVALID_PARAMETER_10:
                return "SMB2_STATUS_INVALID_PARAMETER_10";
        case SMB2_STATUS_INVALID_PARAMETER_11:
                return "SMB2_STATUS_INVALID_PARAMETER_11";
        case SMB2_STATUS_INVALID_PARAMETER_12:
                return "SMB2_STATUS_INVALID_PARAMETER_12";
        case SMB2_STATUS_REDIRECTOR_NOT_STARTED:
                return "STATUS_REDIRECTOR_NOT_STARTED";
        case SMB2_STATUS_REDIRECTOR_STARTED:
                return "SMB2_STATUS_REDIRECTOR_STARTED";
        case SMB2_STATUS_STACK_OVERFLOW:
                return "SMB2_STATUS_STACK_OVERFLOW";
        case SMB2_STATUS_NO_SUCH_PACKAGE:
                return "SMB2_STATUS_NO_SUCH_PACKAGE";
        case SMB2_STATUS_BAD_FUNCTION_TABLE:
                return "SMB2_STATUS_BAD_FUNCTION_TABLE";
        case SMB2_STATUS_DIRECTORY_NOT_EMPTY:
                return "STATUS_DIRECTORY_NOT_EMPTY";
        case SMB2_STATUS_FILE_CORRUPT_ERROR:
                return "SMB2_STATUS_FILE_CORRUPT_ERROR";
        case SMB2_STATUS_NOT_A_DIRECTORY:
                return "STATUS_NOT_A_DIRECTORY";
        case SMB2_STATUS_BAD_LOGON_SESSION_STATE:
                return "SMB2_STATUS_BAD_LOGON_SESSION_STATE";
        case SMB2_STATUS_LOGON_SESSION_COLLISION:
                return "SMB2_STATUS_LOGON_SESSION_COLLISION";
        case SMB2_STATUS_NAME_TOO_LONG:
                return "SMB2_STATUS_NAME_TOO_LONG";
        case SMB2_STATUS_FILES_OPEN:
                return "SMB2_STATUS_FILES_OPEN";
        case SMB2_STATUS_CONNECTION_IN_USE:
                return "SMB2_STATUS_CONNECTION_IN_USE";
        case SMB2_STATUS_MESSAGE_NOT_FOUND:
                return "SMB2_STATUS_MESSAGE_NOT_FOUND";
        case SMB2_STATUS_PROCESS_IS_TERMINATING:
                return "STATUS_PROCESS_IS_TERMINATING";
        case SMB2_STATUS_INVALID_LOGON_TYPE:
                return "SMB2_STATUS_INVALID_LOGON_TYPE";
        case SMB2_STATUS_NO_GUID_TRANSLATION:
                return "SMB2_STATUS_NO_GUID_TRANSLATION";
        case SMB2_STATUS_CANNOT_IMPERSONATE:
                return "SMB2_STATUS_CANNOT_IMPERSONATE";
        case SMB2_STATUS_IMAGE_ALREADY_LOADED:
                return "SMB2_STATUS_IMAGE_ALREADY_LOADED";
        case SMB2_STATUS_ABIOS_NOT_PRESENT:
                return "SMB2_STATUS_ABIOS_NOT_PRESENT";
        case SMB2_STATUS_ABIOS_LID_NOT_EXIST:
                return "SMB2_STATUS_ABIOS_LID_NOT_EXIST";
        case SMB2_STATUS_ABIOS_LID_ALREADY_OWNED:
                return "SMB2_STATUS_ABIOS_LID_ALREADY_OWNED";
        case SMB2_STATUS_ABIOS_NOT_LID_OWNER:
                return "SMB2_STATUS_ABIOS_NOT_LID_OWNER";
        case SMB2_STATUS_ABIOS_INVALID_COMMAND:
                return "SMB2_STATUS_ABIOS_INVALID_COMMAND";
        case SMB2_STATUS_ABIOS_INVALID_LID:
                return "SMB2_STATUS_ABIOS_INVALID_LID";
        case SMB2_STATUS_ABIOS_SELECTOR_NOT_AVAILABLE:
                return "SMB2_STATUS_ABIOS_SELECTOR_NOT_AVAILABLE";
        case SMB2_STATUS_ABIOS_INVALID_SELECTOR:
                return "SMB2_STATUS_ABIOS_INVALID_SELECTOR";
        case SMB2_STATUS_NO_LDT:
                return "SMB2_STATUS_NO_LDT";
        case SMB2_STATUS_INVALID_LDT_SIZE:
                return "SMB2_STATUS_INVALID_LDT_SIZE";
        case SMB2_STATUS_INVALID_LDT_OFFSET:
                return "SMB2_STATUS_INVALID_LDT_OFFSET";
        case SMB2_STATUS_INVALID_LDT_DESCRIPTOR:
                return "SMB2_STATUS_INVALID_LDT_DESCRIPTOR";
        case SMB2_STATUS_INVALID_IMAGE_NE_FORMAT:
                return "SMB2_STATUS_INVALID_IMAGE_NE_FORMAT";
        case SMB2_STATUS_RXACT_INVALID_STATE:
                return "SMB2_STATUS_RXACT_INVALID_STATE";
        case SMB2_STATUS_RXACT_COMMIT_FAILURE:
                return "SMB2_STATUS_RXACT_COMMIT_FAILURE";
        case SMB2_STATUS_MAPPED_FILE_SIZE_ZERO:
                return "SMB2_STATUS_MAPPED_FILE_SIZE_ZERO";
        case SMB2_STATUS_TOO_MANY_OPENED_FILES:
                return "STATUS_TOO_MANY_OPENED_FILES";
        case SMB2_STATUS_CANCELLED:
                return "STATUS_CANCELLED";
        case SMB2_STATUS_CANNOT_DELETE:
                return "STATUS_CANNOT_DELETE";
        case SMB2_STATUS_INVALID_COMPUTER_NAME:
                return "SMB2_STATUS_INVALID_COMPUTER_NAME";
        case SMB2_STATUS_FILE_DELETED:
                return "STATUS_FILE_DELETED";
        case SMB2_STATUS_SPECIAL_ACCOUNT:
                return "SMB2_STATUS_SPECIAL_ACCOUNT";
        case SMB2_STATUS_SPECIAL_GROUP:
                return "SMB2_STATUS_SPECIAL_GROUP";
        case SMB2_STATUS_SPECIAL_USER:
                return "SMB2_STATUS_SPECIAL_USER";
        case SMB2_STATUS_MEMBERS_PRIMARY_GROUP:
                return "SMB2_STATUS_MEMBERS_PRIMARY_GROUP";
        case SMB2_STATUS_FILE_CLOSED:
                return "STATUS_FILE_CLOSED";
        case SMB2_STATUS_TOO_MANY_THREADS:
                return "SMB2_STATUS_TOO_MANY_THREADS";
        case SMB2_STATUS_THREAD_NOT_IN_PROCESS:
                return "SMB2_STATUS_THREAD_NOT_IN_PROCESS";
        case SMB2_STATUS_TOKEN_ALREADY_IN_USE:
                return "SMB2_STATUS_TOKEN_ALREADY_IN_USE";
        case SMB2_STATUS_PAGEFILE_QUOTA_EXCEEDED:
                return "SMB2_STATUS_PAGEFILE_QUOTA_EXCEEDED";
        case SMB2_STATUS_COMMITMENT_LIMIT:
                return "SMB2_STATUS_COMMITMENT_LIMIT";
        case SMB2_STATUS_INVALID_IMAGE_LE_FORMAT:
                return "SMB2_STATUS_INVALID_IMAGE_LE_FORMAT";
        case SMB2_STATUS_INVALID_IMAGE_NOT_MZ:
                return "SMB2_STATUS_INVALID_IMAGE_NOT_MZ";
        case SMB2_STATUS_INVALID_IMAGE_PROTECT:
                return "SMB2_STATUS_INVALID_IMAGE_PROTECT";
        case SMB2_STATUS_INVALID_IMAGE_WIN_16:
                return "SMB2_STATUS_INVALID_IMAGE_WIN_16";
        case SMB2_STATUS_LOGON_SERVER_CONFLICT:
                return "SMB2_STATUS_LOGON_SERVER_CONFLICT";
        case SMB2_STATUS_TIME_DIFFERENCE_AT_DC:
                return "SMB2_STATUS_TIME_DIFFERENCE_AT_DC";
        case SMB2_STATUS_SYNCHRONIZATION_REQUIRED:
                return "SMB2_STATUS_SYNCHRONIZATION_REQUIRED";
        case SMB2_STATUS_DLL_NOT_FOUND:
                return "SMB2_STATUS_DLL_NOT_FOUND";
        case SMB2_STATUS_OPEN_FAILED:
                return "SMB2_STATUS_OPEN_FAILED";
        case SMB2_STATUS_IO_PRIVILEGE_FAILED:
                return "SMB2_STATUS_IO_PRIVILEGE_FAILED";
        case SMB2_STATUS_ORDINAL_NOT_FOUND:
                return "SMB2_STATUS_ORDINAL_NOT_FOUND";
        case SMB2_STATUS_ENTRYPOINT_NOT_FOUND:
                return "SMB2_STATUS_ENTRYPOINT_NOT_FOUND";
        case SMB2_STATUS_CONTROL_C_EXIT:
                return "SMB2_STATUS_CONTROL_C_EXIT";
        case SMB2_STATUS_LOCAL_DISCONNECT:
                return "SMB2_STATUS_LOCAL_DISCONNECT";
        case SMB2_STATUS_REMOTE_DISCONNECT:
                return "SMB2_STATUS_REMOTE_DISCONNECT";
        case SMB2_STATUS_REMOTE_RESOURCES:
                return "SMB2_STATUS_REMOTE_RESOURCES";
        case SMB2_STATUS_LINK_FAILED:
                return "SMB2_STATUS_LINK_FAILED";
        case SMB2_STATUS_LINK_TIMEOUT:
                return "SMB2_STATUS_LINK_TIMEOUT";
        case SMB2_STATUS_INVALID_CONNECTION:
                return "SMB2_STATUS_INVALID_CONNECTION";
        case SMB2_STATUS_INVALID_ADDRESS:
                return "SMB2_STATUS_INVALID_ADDRESS";
        case SMB2_STATUS_DLL_INIT_FAILED:
                return "SMB2_STATUS_DLL_INIT_FAILED";
        case SMB2_STATUS_MISSING_SYSTEMFILE:
                return "SMB2_STATUS_MISSING_SYSTEMFILE";
        case SMB2_STATUS_UNHANDLED_EXCEPTION:
                return "SMB2_STATUS_UNHANDLED_EXCEPTION";
        case SMB2_STATUS_APP_INIT_FAILURE:
                return "SMB2_STATUS_APP_INIT_FAILURE";
        case SMB2_STATUS_PAGEFILE_CREATE_FAILED:
                return "SMB2_STATUS_PAGEFILE_CREATE_FAILED";
        case SMB2_STATUS_NO_PAGEFILE:
                return "SMB2_STATUS_NO_PAGEFILE";
        case SMB2_STATUS_INVALID_LEVEL:
                return "SMB2_STATUS_INVALID_LEVEL";
        case SMB2_STATUS_WRONG_PASSWORD_CORE:
                return "SMB2_STATUS_WRONG_PASSWORD_CORE";
        case SMB2_STATUS_ILLEGAL_FLOAT_CONTEXT:
                return "SMB2_STATUS_ILLEGAL_FLOAT_CONTEXT";
        case SMB2_STATUS_PIPE_BROKEN:
                return "SMB2_STATUS_PIPE_BROKEN";
        case SMB2_STATUS_REGISTRY_CORRUPT:
                return "SMB2_STATUS_REGISTRY_CORRUPT";
        case SMB2_STATUS_REGISTRY_IO_FAILED:
                return "SMB2_STATUS_REGISTRY_IO_FAILED";
        case SMB2_STATUS_NO_EVENT_PAIR:
                return "SMB2_STATUS_NO_EVENT_PAIR";
        case SMB2_STATUS_UNRECOGNIZED_VOLUME:
                return "SMB2_STATUS_UNRECOGNIZED_VOLUME";
        case SMB2_STATUS_SERIAL_NO_DEVICE_INITED:
                return "SMB2_STATUS_SERIAL_NO_DEVICE_INITED";
        case SMB2_STATUS_NO_SUCH_ALIAS:
                return "SMB2_STATUS_NO_SUCH_ALIAS";
        case SMB2_STATUS_MEMBER_NOT_IN_ALIAS:
                return "SMB2_STATUS_MEMBER_NOT_IN_ALIAS";
        case SMB2_STATUS_MEMBER_IN_ALIAS:
                return "SMB2_STATUS_MEMBER_IN_ALIAS";
        case SMB2_STATUS_ALIAS_EXISTS:
                return "SMB2_STATUS_ALIAS_EXISTS";
        case SMB2_STATUS_LOGON_NOT_GRANTED:
                return "SMB2_STATUS_LOGON_NOT_GRANTED";
        case SMB2_STATUS_TOO_MANY_SECRETS:
                return "SMB2_STATUS_TOO_MANY_SECRETS";
        case SMB2_STATUS_SECRET_TOO_LONG:
                return "SMB2_STATUS_SECRET_TOO_LONG";
        case SMB2_STATUS_INTERNAL_DB_ERROR:
                return "SMB2_STATUS_INTERNAL_DB_ERROR";
        case SMB2_STATUS_FULLSCREEN_MODE:
                return "SMB2_STATUS_FULLSCREEN_MODE";
        case SMB2_STATUS_TOO_MANY_CONTEXT_IDS:
                return "SMB2_STATUS_TOO_MANY_CONTEXT_IDS";
        case SMB2_STATUS_LOGON_TYPE_NOT_GRANTED:
                return "SMB2_STATUS_LOGON_TYPE_NOT_GRANTED";
        case SMB2_STATUS_NOT_REGISTRY_FILE:
                return "SMB2_STATUS_NOT_REGISTRY_FILE";
        case SMB2_STATUS_NT_CROSS_ENCRYPTION_REQUIRED:
                return "SMB2_STATUS_NT_CROSS_ENCRYPTION_REQUIRED";
        case SMB2_STATUS_DOMAIN_CTRLR_CONFIG_ERROR:
                return "SMB2_STATUS_DOMAIN_CTRLR_CONFIG_ERROR";
        case SMB2_STATUS_FT_MISSING_MEMBER:
                return "SMB2_STATUS_FT_MISSING_MEMBER";
        case SMB2_STATUS_ILL_FORMED_SERVICE_ENTRY:
                return "SMB2_STATUS_ILL_FORMED_SERVICE_ENTRY";
        case SMB2_STATUS_ILLEGAL_CHARACTER:
                return "SMB2_STATUS_ILLEGAL_CHARACTER";
        case SMB2_STATUS_UNMAPPABLE_CHARACTER:
                return "SMB2_STATUS_UNMAPPABLE_CHARACTER";
        case SMB2_STATUS_UNDEFINED_CHARACTER:
                return "SMB2_STATUS_UNDEFINED_CHARACTER";
        case SMB2_STATUS_FLOPPY_VOLUME:
                return "SMB2_STATUS_FLOPPY_VOLUME";
        case SMB2_STATUS_FLOPPY_ID_MARK_NOT_FOUND:
                return "SMB2_STATUS_FLOPPY_ID_MARK_NOT_FOUND";
        case SMB2_STATUS_FLOPPY_WRONG_CYLINDER:
                return "SMB2_STATUS_FLOPPY_WRONG_CYLINDER";
        case SMB2_STATUS_FLOPPY_UNKNOWN_ERROR:
                return "SMB2_STATUS_FLOPPY_UNKNOWN_ERROR";
        case SMB2_STATUS_FLOPPY_BAD_REGISTERS:
                return "SMB2_STATUS_FLOPPY_BAD_REGISTERS";
        case SMB2_STATUS_DISK_RECALIBRATE_FAILED:
                return "SMB2_STATUS_DISK_RECALIBRATE_FAILED";
        case SMB2_STATUS_DISK_OPERATION_FAILED:
                return "SMB2_STATUS_DISK_OPERATION_FAILED";
        case SMB2_STATUS_DISK_RESET_FAILED:
                return "SMB2_STATUS_DISK_RESET_FAILED";
        case SMB2_STATUS_SHARED_IRQ_BUSY:
                return "SMB2_STATUS_SHARED_IRQ_BUSY";
        case SMB2_STATUS_FT_ORPHANING:
                return "SMB2_STATUS_FT_ORPHANING";
        case SMB2_STATUS_PARTITION_FAILURE:
                return "SMB2_STATUS_PARTITION_FAILURE";
        case SMB2_STATUS_INVALID_BLOCK_LENGTH:
                return "SMB2_STATUS_INVALID_BLOCK_LENGTH";
        case SMB2_STATUS_DEVICE_NOT_PARTITIONED:
                return "SMB2_STATUS_DEVICE_NOT_PARTITIONED";
        case SMB2_STATUS_UNABLE_TO_LOCK_MEDIA:
                return "SMB2_STATUS_UNABLE_TO_LOCK_MEDIA";
        case SMB2_STATUS_UNABLE_TO_UNLOAD_MEDIA:
                return "SMB2_STATUS_UNABLE_TO_UNLOAD_MEDIA";
        case SMB2_STATUS_EOM_OVERFLOW:
                return "SMB2_STATUS_EOM_OVERFLOW";
        case SMB2_STATUS_NO_MEDIA:
                return "SMB2_STATUS_NO_MEDIA";
        case SMB2_STATUS_NO_SUCH_MEMBER:
                return "SMB2_STATUS_NO_SUCH_MEMBER";
        case SMB2_STATUS_INVALID_MEMBER:
                return "SMB2_STATUS_INVALID_MEMBER";
        case SMB2_STATUS_KEY_DELETED:
                return "SMB2_STATUS_KEY_DELETED";
        case SMB2_STATUS_NO_LOG_SPACE:
                return "SMB2_STATUS_NO_LOG_SPACE";
        case SMB2_STATUS_TOO_MANY_SIDS:
                return "SMB2_STATUS_TOO_MANY_SIDS";
        case SMB2_STATUS_LM_CROSS_ENCRYPTION_REQUIRED:
                return "SMB2_STATUS_LM_CROSS_ENCRYPTION_REQUIRED";
        case SMB2_STATUS_KEY_HAS_CHILDREN:
                return "SMB2_STATUS_KEY_HAS_CHILDREN";
        case SMB2_STATUS_CHILD_MUST_BE_VOLATILE:
                return "SMB2_STATUS_CHILD_MUST_BE_VOLATILE";
        case SMB2_STATUS_DEVICE_CONFIGURATION_ERROR:
                return "SMB2_STATUS_DEVICE_CONFIGURATION_ERROR";
        case SMB2_STATUS_DRIVER_INTERNAL_ERROR:
                return "SMB2_STATUS_DRIVER_INTERNAL_ERROR";
        case SMB2_STATUS_INVALID_DEVICE_STATE:
                return "SMB2_STATUS_INVALID_DEVICE_STATE";
        case SMB2_STATUS_IO_DEVICE_ERROR:
                return "SMB2_STATUS_IO_DEVICE_ERROR";
        case SMB2_STATUS_DEVICE_PROTOCOL_ERROR:
                return "SMB2_STATUS_DEVICE_PROTOCOL_ERROR";
        case SMB2_STATUS_BACKUP_CONTROLLER:
                return "SMB2_STATUS_BACKUP_CONTROLLER";
        case SMB2_STATUS_LOG_FILE_FULL:
                return "SMB2_STATUS_LOG_FILE_FULL";
        case SMB2_STATUS_TOO_LATE:
                return "SMB2_STATUS_TOO_LATE";
        case SMB2_STATUS_NO_TRUST_LSA_SECRET:
                return "SMB2_STATUS_NO_TRUST_LSA_SECRET";
        case SMB2_STATUS_NO_TRUST_SAM_ACCOUNT:
                return "SMB2_STATUS_NO_TRUST_SAM_ACCOUNT";
        case SMB2_STATUS_TRUSTED_DOMAIN_FAILURE:
                return "SMB2_STATUS_TRUSTED_DOMAIN_FAILURE";
        case SMB2_STATUS_TRUSTED_RELATIONSHIP_FAILURE:
                return "SMB2_STATUS_TRUSTED_RELATIONSHIP_FAILURE";
        case SMB2_STATUS_EVENTLOG_FILE_CORRUPT:
                return "SMB2_STATUS_EVENTLOG_FILE_CORRUPT";
        case SMB2_STATUS_EVENTLOG_CANT_START:
                return "SMB2_STATUS_EVENTLOG_CANT_START";
        case SMB2_STATUS_TRUST_FAILURE:
                return "SMB2_STATUS_TRUST_FAILURE";
        case SMB2_STATUS_MUTANT_LIMIT_EXCEEDED:
                return "SMB2_STATUS_MUTANT_LIMIT_EXCEEDED";
        case SMB2_STATUS_NETLOGON_NOT_STARTED:
                return "SMB2_STATUS_NETLOGON_NOT_STARTED";
        case SMB2_STATUS_ACCOUNT_EXPIRED:
                return "SMB2_STATUS_ACCOUNT_EXPIRED";
        case SMB2_STATUS_POSSIBLE_DEADLOCK:
                return "SMB2_STATUS_POSSIBLE_DEADLOCK";
        case SMB2_STATUS_NETWORK_CREDENTIAL_CONFLICT:
                return "SMB2_STATUS_NETWORK_CREDENTIAL_CONFLICT";
        case SMB2_STATUS_REMOTE_SESSION_LIMIT:
                return "SMB2_STATUS_REMOTE_SESSION_LIMIT";
        case SMB2_STATUS_EVENTLOG_FILE_CHANGED:
                return "SMB2_STATUS_EVENTLOG_FILE_CHANGED";
        case SMB2_STATUS_NOLOGON_INTERDOMAIN_TRUST_ACCOUNT:
                return "SMB2_STATUS_NOLOGON_INTERDOMAIN_TRUST_ACCOUNT";
        case SMB2_STATUS_NOLOGON_WORKSTATION_TRUST_ACCOUNT:
                return "SMB2_STATUS_NOLOGON_WORKSTATION_TRUST_ACCOUNT";
        case SMB2_STATUS_NOLOGON_SERVER_TRUST_ACCOUNT:
                return "SMB2_STATUS_NOLOGON_SERVER_TRUST_ACCOUNT";
        case SMB2_STATUS_DOMAIN_TRUST_INCONSISTENT:
                return "SMB2_STATUS_DOMAIN_TRUST_INCONSISTENT";
        case SMB2_STATUS_FS_DRIVER_REQUIRED:
                return "SMB2_STATUS_FS_DRIVER_REQUIRED";
        case SMB2_STATUS_NO_USER_SESSION_KEY:
                return "SMB2_STATUS_NO_USER_SESSION_KEY";
        case SMB2_STATUS_USER_SESSION_DELETED:
                return "SMB2_STATUS_USER_SESSION_DELETED";
        case SMB2_STATUS_RESOURCE_LANG_NOT_FOUND:
                return "SMB2_STATUS_RESOURCE_LANG_NOT_FOUND";
        case SMB2_STATUS_INSUFF_SERVER_RESOURCES:
                return "STATUS_INSUFF_SERVER_RESOURCES";
        case SMB2_STATUS_INVALID_BUFFER_SIZE:
                return "SMB2_STATUS_INVALID_BUFFER_SIZE";
        case SMB2_STATUS_INVALID_ADDRESS_COMPONENT:
                return "SMB2_STATUS_INVALID_ADDRESS_COMPONENT";
        case SMB2_STATUS_INVALID_ADDRESS_WILDCARD:
                return "SMB2_STATUS_INVALID_ADDRESS_WILDCARD";
        case SMB2_STATUS_TOO_MANY_ADDRESSES:
                return "SMB2_STATUS_TOO_MANY_ADDRESSES";
        case SMB2_STATUS_ADDRESS_ALREADY_EXISTS:
                return "SMB2_STATUS_ADDRESS_ALREADY_EXISTS";
        case SMB2_STATUS_ADDRESS_CLOSED:
                return "SMB2_STATUS_ADDRESS_CLOSED";
        case SMB2_STATUS_CONNECTION_DISCONNECTED:
                return "SMB2_STATUS_CONNECTION_DISCONNECTED";
        case SMB2_STATUS_CONNECTION_RESET:
                return "SMB2_STATUS_CONNECTION_RESET";
        case SMB2_STATUS_TOO_MANY_NODES:
                return "SMB2_STATUS_TOO_MANY_NODES";
        case SMB2_STATUS_TRANSACTION_ABORTED:
                return "SMB2_STATUS_TRANSACTION_ABORTED";
        case SMB2_STATUS_TRANSACTION_TIMED_OUT:
                return "SMB2_STATUS_TRANSACTION_TIMED_OUT";
        case SMB2_STATUS_TRANSACTION_NO_RELEASE:
                return "SMB2_STATUS_TRANSACTION_NO_RELEASE";
        case SMB2_STATUS_TRANSACTION_NO_MATCH:
                return "SMB2_STATUS_TRANSACTION_NO_MATCH";
        case SMB2_STATUS_TRANSACTION_RESPONDED:
                return "SMB2_STATUS_TRANSACTION_RESPONDED";
        case SMB2_STATUS_TRANSACTION_INVALID_ID:
                return "SMB2_STATUS_TRANSACTION_INVALID_ID";
        case SMB2_STATUS_TRANSACTION_INVALID_TYPE:
                return "SMB2_STATUS_TRANSACTION_INVALID_TYPE";
        case SMB2_STATUS_NOT_SERVER_SESSION:
                return "SMB2_STATUS_NOT_SERVER_SESSION";
        case SMB2_STATUS_NOT_CLIENT_SESSION:
                return "SMB2_STATUS_NOT_CLIENT_SESSION";
        case SMB2_STATUS_CANNOT_LOAD_REGISTRY_FILE:
                return "SMB2_STATUS_CANNOT_LOAD_REGISTRY_FILE";
        case SMB2_STATUS_DEBUG_ATTACH_FAILED:
                return "SMB2_STATUS_DEBUG_ATTACH_FAILED";
        case SMB2_STATUS_SYSTEM_PROCESS_TERMINATED:
                return "SMB2_STATUS_SYSTEM_PROCESS_TERMINATED";
        case SMB2_STATUS_DATA_NOT_ACCEPTED:
                return "SMB2_STATUS_DATA_NOT_ACCEPTED";
        case SMB2_STATUS_NO_BROWSER_SERVERS_FOUND:
                return "SMB2_STATUS_NO_BROWSER_SERVERS_FOUND";
        case SMB2_STATUS_VDM_HARD_ERROR:
                return "SMB2_STATUS_VDM_HARD_ERROR";
        case SMB2_STATUS_DRIVER_CANCEL_TIMEOUT:
                return "SMB2_STATUS_DRIVER_CANCEL_TIMEOUT";
        case SMB2_STATUS_REPLY_MESSAGE_MISMATCH:
                return "SMB2_STATUS_REPLY_MESSAGE_MISMATCH";
        case SMB2_STATUS_MAPPED_ALIGNMENT:
                return "SMB2_STATUS_MAPPED_ALIGNMENT";
        case SMB2_STATUS_IMAGE_CHECKSUM_MISMATCH:
                return "SMB2_STATUS_IMAGE_CHECKSUM_MISMATCH";
        case SMB2_STATUS_LOST_WRITEBEHIND_DATA:
                return "SMB2_STATUS_LOST_WRITEBEHIND_DATA";
        case SMB2_STATUS_CLIENT_SERVER_PARAMETERS_INVALID:
                return "SMB2_STATUS_CLIENT_SERVER_PARAMETERS_INVALID";
        case SMB2_STATUS_PASSWORD_MUST_CHANGE:
                return "SMB2_STATUS_PASSWORD_MUST_CHANGE";
        case SMB2_STATUS_NOT_FOUND:
                return "SMB2_STATUS_NOT_FOUND";
        case SMB2_STATUS_NOT_TINY_STREAM:
                return "SMB2_STATUS_NOT_TINY_STREAM";
        case SMB2_STATUS_RECOVERY_FAILURE:
                return "SMB2_STATUS_RECOVERY_FAILURE";
        case SMB2_STATUS_STACK_OVERFLOW_READ:
                return "SMB2_STATUS_STACK_OVERFLOW_READ";
        case SMB2_STATUS_FAIL_CHECK:
                return "SMB2_STATUS_FAIL_CHECK";
        case SMB2_STATUS_DUPLICATE_OBJECTID:
                return "SMB2_STATUS_DUPLICATE_OBJECTID";
        case SMB2_STATUS_OBJECTID_EXISTS:
                return "SMB2_STATUS_OBJECTID_EXISTS";
        case SMB2_STATUS_CONVERT_TO_LARGE:
                return "SMB2_STATUS_CONVERT_TO_LARGE";
        case SMB2_STATUS_RETRY:
                return "SMB2_STATUS_RETRY";
        case SMB2_STATUS_FOUND_OUT_OF_SCOPE:
                return "SMB2_STATUS_FOUND_OUT_OF_SCOPE";
        case SMB2_STATUS_ALLOCATE_BUCKET:
                return "SMB2_STATUS_ALLOCATE_BUCKET";
        case SMB2_STATUS_PROPSET_NOT_FOUND:
                return "SMB2_STATUS_PROPSET_NOT_FOUND";
        case SMB2_STATUS_MARSHALL_OVERFLOW:
                return "SMB2_STATUS_MARSHALL_OVERFLOW";
        case SMB2_STATUS_INVALID_VARIANT:
                return "SMB2_STATUS_INVALID_VARIANT";
        case SMB2_STATUS_DOMAIN_CONTROLLER_NOT_FOUND:
                return "SMB2_STATUS_DOMAIN_CONTROLLER_NOT_FOUND";
        case SMB2_STATUS_ACCOUNT_LOCKED_OUT:
                return "SMB2_STATUS_ACCOUNT_LOCKED_OUT";
        case SMB2_STATUS_HANDLE_NOT_CLOSABLE:
                return "STATUS_HANDLE_NOT_CLOSABLE";
        case SMB2_STATUS_CONNECTION_REFUSED:
                return "SMB2_STATUS_CONNECTION_REFUSED";
        case SMB2_STATUS_GRACEFUL_DISCONNECT:
                return "SMB2_STATUS_GRACEFUL_DISCONNECT";
        case SMB2_STATUS_ADDRESS_ALREADY_ASSOCIATED:
                return "SMB2_STATUS_ADDRESS_ALREADY_ASSOCIATED";
        case SMB2_STATUS_ADDRESS_NOT_ASSOCIATED:
                return "SMB2_STATUS_ADDRESS_NOT_ASSOCIATED";
        case SMB2_STATUS_CONNECTION_INVALID:
                return "SMB2_STATUS_CONNECTION_INVALID";
        case SMB2_STATUS_CONNECTION_ACTIVE:
                return "SMB2_STATUS_CONNECTION_ACTIVE";
        case SMB2_STATUS_NETWORK_UNREACHABLE:
                return "SMB2_STATUS_NETWORK_UNREACHABLE";
        case SMB2_STATUS_HOST_UNREACHABLE:
                return "SMB2_STATUS_HOST_UNREACHABLE";
        case SMB2_STATUS_PROTOCOL_UNREACHABLE:
                return "SMB2_STATUS_PROTOCOL_UNREACHABLE";
        case SMB2_STATUS_PORT_UNREACHABLE:
                return "SMB2_STATUS_PORT_UNREACHABLE";
        case SMB2_STATUS_REQUEST_ABORTED:
                return "SMB2_STATUS_REQUEST_ABORTED";
        case SMB2_STATUS_CONNECTION_ABORTED:
                return "SMB2_STATUS_CONNECTION_ABORTED";
        case SMB2_STATUS_BAD_COMPRESSION_BUFFER:
                return "SMB2_STATUS_BAD_COMPRESSION_BUFFER";
        case SMB2_STATUS_USER_MAPPED_FILE:
                return "SMB2_STATUS_USER_MAPPED_FILE";
        case SMB2_STATUS_AUDIT_FAILED:
                return "SMB2_STATUS_AUDIT_FAILED";
        case SMB2_STATUS_TIMER_RESOLUTION_NOT_SET:
                return "SMB2_STATUS_TIMER_RESOLUTION_NOT_SET";
        case SMB2_STATUS_CONNECTION_COUNT_LIMIT:
                return "SMB2_STATUS_CONNECTION_COUNT_LIMIT";
        case SMB2_STATUS_LOGIN_TIME_RESTRICTION:
                return "SMB2_STATUS_LOGIN_TIME_RESTRICTION";
        case SMB2_STATUS_LOGIN_WKSTA_RESTRICTION:
                return "SMB2_STATUS_LOGIN_WKSTA_RESTRICTION";
        case SMB2_STATUS_IMAGE_MP_UP_MISMATCH:
                return "SMB2_STATUS_IMAGE_MP_UP_MISMATCH";
        case SMB2_STATUS_INSUFFICIENT_LOGON_INFO:
                return "SMB2_STATUS_INSUFFICIENT_LOGON_INFO";
        case SMB2_STATUS_BAD_DLL_ENTRYPOINT:
                return "SMB2_STATUS_BAD_DLL_ENTRYPOINT";
        case SMB2_STATUS_BAD_SERVICE_ENTRYPOINT:
                return "SMB2_STATUS_BAD_SERVICE_ENTRYPOINT";
        case SMB2_STATUS_LPC_REPLY_LOST:
                return "SMB2_STATUS_LPC_REPLY_LOST";
        case SMB2_STATUS_IP_ADDRESS_CONFLICT1:
                return "SMB2_STATUS_IP_ADDRESS_CONFLICT1";
        case SMB2_STATUS_IP_ADDRESS_CONFLICT2:
                return "SMB2_STATUS_IP_ADDRESS_CONFLICT2";
        case SMB2_STATUS_REGISTRY_QUOTA_LIMIT:
                return "SMB2_STATUS_REGISTRY_QUOTA_LIMIT";
        case SMB2_STATUS_PATH_NOT_COVERED:
                return "SMB2_STATUS_PATH_NOT_COVERED";
        case SMB2_STATUS_NO_CALLBACK_ACTIVE:
                return "SMB2_STATUS_NO_CALLBACK_ACTIVE";
        case SMB2_STATUS_LICENSE_QUOTA_EXCEEDED:
                return "SMB2_STATUS_LICENSE_QUOTA_EXCEEDED";
        case SMB2_STATUS_PWD_TOO_SHORT:
                return "SMB2_STATUS_PWD_TOO_SHORT";
        case SMB2_STATUS_PWD_TOO_RECENT:
                return "SMB2_STATUS_PWD_TOO_RECENT";
        case SMB2_STATUS_PWD_HISTORY_CONFLICT:
                return "SMB2_STATUS_PWD_HISTORY_CONFLICT";
        case SMB2_STATUS_PLUGPLAY_NO_DEVICE:
                return "SMB2_STATUS_PLUGPLAY_NO_DEVICE";
        case SMB2_STATUS_UNSUPPORTED_COMPRESSION:
                return "SMB2_STATUS_UNSUPPORTED_COMPRESSION";
        case SMB2_STATUS_INVALID_HW_PROFILE:
                return "SMB2_STATUS_INVALID_HW_PROFILE";
        case SMB2_STATUS_INVALID_PLUGPLAY_DEVICE_PATH:
                return "SMB2_STATUS_INVALID_PLUGPLAY_DEVICE_PATH";
        case SMB2_STATUS_DRIVER_ORDINAL_NOT_FOUND:
                return "SMB2_STATUS_DRIVER_ORDINAL_NOT_FOUND";
        case SMB2_STATUS_DRIVER_ENTRYPOINT_NOT_FOUND:
                return "SMB2_STATUS_DRIVER_ENTRYPOINT_NOT_FOUND";
        case SMB2_STATUS_RESOURCE_NOT_OWNED:
                return "SMB2_STATUS_RESOURCE_NOT_OWNED";
        case SMB2_STATUS_TOO_MANY_LINKS:
                return "SMB2_STATUS_TOO_MANY_LINKS";
        case SMB2_STATUS_QUOTA_LIST_INCONSISTENT:
                return "SMB2_STATUS_QUOTA_LIST_INCONSISTENT";
        case SMB2_STATUS_FILE_IS_OFFLINE:
                return "SMB2_STATUS_FILE_IS_OFFLINE";
        case SMB2_STATUS_VOLUME_DISMOUNTED:
                return "SMB2_STATUS_VOLUME_DISMOUNTED";
        case SMB2_STATUS_NOT_A_REPARSE_POINT:
                return "STATUS_NOT_A_REPARSE_POINT";
        case SMB2_STATUS_STOPPED_ON_SYMLINK:
                return "SMB2_STATUS_STOPPED_ON_SYMLINK";
        default:
                 return "Unknown";
        }
}

int nterror_to_errno(uint32_t status) {
        switch (status) {
        case SMB2_STATUS_SUCCESS:
        case SMB2_STATUS_END_OF_FILE:
                return 0;
        case SMB2_STATUS_PENDING:
                return EAGAIN;
        case SMB2_STATUS_ABORTED:
                return ECONNRESET;
        case SMB2_STATUS_NO_SUCH_FILE:
        case SMB2_STATUS_NO_SUCH_DEVICE:
        case SMB2_STATUS_BAD_NETWORK_NAME:
        case SMB2_STATUS_OBJECT_NAME_NOT_FOUND:
        case SMB2_STATUS_OBJECT_PATH_INVALID:
        case SMB2_STATUS_OBJECT_PATH_NOT_FOUND:
        case SMB2_STATUS_OBJECT_PATH_SYNTAX_BAD:
        case SMB2_STATUS_DFS_EXIT_PATH_FOUND:
        case SMB2_STATUS_DELETE_PENDING:
        case SMB2_STATUS_REDIRECTOR_NOT_STARTED:
        case SMB2_STATUS_NOT_FOUND:
                return ENOENT;
        case SMB2_STATUS_SMB_BAD_FID:
        case SMB2_STATUS_INVALID_HANDLE:
        case SMB2_STATUS_OBJECT_TYPE_MISMATCH:
        case SMB2_STATUS_PORT_DISCONNECTED:
        case SMB2_STATUS_INVALID_PORT_HANDLE:
        case SMB2_STATUS_HANDLE_NOT_CLOSABLE:
                return EBADF;
        case SMB2_STATUS_MORE_PROCESSING_REQUIRED:
                return EAGAIN;
        case SMB2_STATUS_ACCESS_DENIED:
        case SMB2_STATUS_NETWORK_ACCESS_DENIED:
        case SMB2_STATUS_ACCOUNT_RESTRICTION:
        case SMB2_STATUS_INVALID_LOGON_HOURS:
        case SMB2_STATUS_PASSWORD_EXPIRED:
        case SMB2_STATUS_ACCOUNT_DISABLED:
                return EACCES;
        case SMB2_STATUS_INVALID_LOCK_SEQUENCE:
        case SMB2_STATUS_INVALID_VIEW_SIZE:
        case SMB2_STATUS_ALREADY_COMMITTED:
        case SMB2_STATUS_PORT_CONNECTION_REFUSED:
        case SMB2_STATUS_THREAD_IS_TERMINATING:
        case SMB2_STATUS_PRIVILEGE_NOT_HELD:
        case SMB2_STATUS_FILE_IS_A_DIRECTORY:
        case SMB2_STATUS_FILE_RENAMED:
        case SMB2_STATUS_PROCESS_IS_TERMINATING:
        case SMB2_STATUS_DIRECTORY_NOT_EMPTY:
        case SMB2_STATUS_CANNOT_DELETE:
        case SMB2_STATUS_FILE_DELETED:
                return EPERM;
        case SMB2_STATUS_NO_MORE_FILES:
                return ENODATA;
        case SMB2_STATUS_LOGON_FAILURE:
                return ECONNREFUSED;
        case SMB2_STATUS_NOT_A_DIRECTORY:
                return ENOTDIR;
        case SMB2_STATUS_NOT_IMPLEMENTED:
        case SMB2_STATUS_INVALID_DEVICE_REQUEST:
        case SMB2_STATUS_ILLEGAL_FUNCTION:
        case SMB2_STATUS_INVALID_PARAMETER:
        case SMB2_STATUS_NOT_SUPPORTED:
        case SMB2_STATUS_NOT_A_REPARSE_POINT:
        case SMB2_STATUS_STOPPED_ON_SYMLINK:
                return EINVAL;
        case SMB2_STATUS_TOO_MANY_OPENED_FILES:
                return EMFILE;
        case SMB2_STATUS_SECTION_TOO_BIG:
        case SMB2_STATUS_TOO_MANY_PAGING_FILES:
        case SMB2_STATUS_INSUFF_SERVER_RESOURCES:
                return ENOMEM;
        case SMB2_STATUS_NOT_SAME_DEVICE:
                return EXDEV;
        case SMB2_STATUS_SHARING_VIOLATION:
                return ETXTBSY;
        case SMB2_STATUS_FILE_LOCK_CONFLICT:
        case SMB2_STATUS_LOCK_NOT_GRANTED:
                return EDEADLK;
        case SMB2_STATUS_OBJECT_NAME_COLLISION:
                return EEXIST;
        case SMB2_STATUS_PIPE_DISCONNECTED:
                return EPIPE;
        case SMB2_STATUS_MEDIA_WRITE_PROTECTED:
                return EROFS;
        case SMB2_STATUS_NO_MEDIA_IN_DEVICE:
                return ENODEV;
        case SMB2_STATUS_DATA_ERROR:
        case SMB2_STATUS_CRC_ERROR:
        case SMB2_STATUS_DEVICE_DATA_ERROR:
        case SMB2_STATUS_IO_DEVICE_ERROR:
                return EIO;
        case SMB2_STATUS_DISK_FULL:
                return ENOSPC;
        case SMB2_STATUS_CANCELLED:
        case SMB2_STATUS_FILE_CLOSED:
        case SMB2_STATUS_VOLUME_DISMOUNTED:
        case SMB2_STATUS_CONNECTION_DISCONNECTED:
        case SMB2_STATUS_CONNECTION_RESET:
        case SMB2_STATUS_CONNECTION_INVALID:
        case SMB2_STATUS_CONNECTION_ABORTED:
        case SMB2_STATUS_NETWORK_NAME_DELETED:
        case SMB2_STATUS_INVALID_NETWORK_RESPONSE:
                // We return this errno with the intention that caller can
                // retry when any of these are received.
                return ENETRESET;
        case SMB2_STATUS_PATH_NOT_COVERED:
                // We do not have an errno which can be an equivalent of this
                // NT_STATUS code. To handle this, return a code which will not
                // be used as we are operating over a network.
                return ENOEXEC;
        case SMB2_STATUS_IO_TIMEOUT:
                return ETIMEDOUT;
        case SMB2_STATUS_INSUFFICIENT_RESOURCES:
                return EBUSY;
        case SMB2_STATUS_INTERNAL_ERROR:
                // Fall through.
        default:
                return EIO;
        }
}
