/*
 * Decompiled with CFR 0.152.
 */
package com.webcodepro.applecommander.util;

import com.webcodepro.applecommander.storage.FormattedDisk;
import com.webcodepro.applecommander.storage.physical.ImageOrder;
import com.webcodepro.applecommander.util.TextBundle;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Arrays;
import java.util.Date;
import java.util.GregorianCalendar;

public class AppleUtil {
    private static TextBundle textBundle = TextBundle.getInstance();
    private static final int BYTES_PER_LINE = 16;
    private static final int APPLE_SPACE = 32;
    private static byte[] masks = new byte[]{1, 2, 4, 8, 16, 32, 64, -128};
    private static char[] hexDigits = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};

    public static int getWordValue(byte[] buffer, int offset) {
        if (offset + 1 > buffer.length) {
            return 0;
        }
        return AppleUtil.getWordValue(buffer[offset], buffer[offset + 1]);
    }

    public static int getWordValue(byte low, byte high) {
        return AppleUtil.getUnsignedByte(low) + AppleUtil.getUnsignedByte(high) * 256;
    }

    public static int getSignedWordValue(byte[] buffer, int offset) {
        int value = buffer[offset + 1] * 256;
        return value + AppleUtil.getUnsignedByte(buffer[offset]);
    }

    public static void setWordValue(byte[] buffer, int offset, int value) {
        buffer[offset] = (byte)(value % 256);
        buffer[offset + 1] = (byte)(value / 256);
    }

    public static int get3ByteValue(byte[] buffer, int offset) {
        if (offset + 2 > buffer.length) {
            return 0;
        }
        return AppleUtil.getUnsignedByte(buffer[offset]) + AppleUtil.getUnsignedByte(buffer[offset + 1]) * 256 + AppleUtil.getUnsignedByte(buffer[offset + 2]) * 65536;
    }

    public static long getLongValue(byte[] buffer, int offset) {
        if (offset + 3 > buffer.length) {
            return 0L;
        }
        return AppleUtil.getUnsignedByte(buffer[offset + 3]) + AppleUtil.getUnsignedByte(buffer[offset + 2]) * 256 + AppleUtil.getUnsignedByte(buffer[offset + 1]) * 65536 + AppleUtil.getUnsignedByte(buffer[offset]) * 0x1000000;
    }

    public static void set3ByteValue(byte[] buffer, int offset, int value) {
        buffer[offset] = (byte)(value & 0xFF);
        buffer[offset + 1] = (byte)((value & 0xFF00) >> 8);
        buffer[offset + 2] = (byte)((value & 0xFF0000) >> 16);
    }

    public static int getUnsignedByte(byte value) {
        return value & 0xFF;
    }

    public static int getUnsignedByte(byte[] buffer, int offset) {
        if (offset + 1 > buffer.length) {
            return 0;
        }
        return AppleUtil.getUnsignedByte(buffer[offset]);
    }

    public static int getBitCount(byte byt) {
        int count = 0;
        for (int ix = 0; ix < 8; ++ix) {
            if (!AppleUtil.isBitSet(byt, ix)) continue;
            ++count;
        }
        return count;
    }

    public static boolean isBitSet(byte byt, int bit) {
        return (byt & masks[bit]) != 0;
    }

    public static byte setBit(byte byt, int bit) {
        return (byte)((byt | masks[bit]) & 0xFF);
    }

    public static byte clearBit(byte byt, int bit) {
        return (byte)(byt & ~masks[bit] & 0xFF);
    }

    public static String getString(byte[] buffer, int offset, int length) {
        byte[] value = new byte[length];
        for (int i = 0; i < length; ++i) {
            byte ch = buffer[offset + i];
            value[i] = ch = (byte)(ch & 0x7F);
        }
        return new String(value);
    }

    public static void setString(byte[] buffer, int offset, String string, int length) {
        AppleUtil.setString(buffer, offset, string, length, true);
    }

    public static void setString(byte[] buffer, int offset, String string, int length, boolean highBitOn) {
        for (int i = 0; i < length; ++i) {
            int ch = 32;
            if (i < string.length()) {
                ch = string.charAt(i);
            }
            buffer[offset + i] = (byte)(ch | (highBitOn ? 128 : 0));
        }
    }

    public static void setString(byte[] buffer, int offset, String string) {
        AppleUtil.setString(buffer, offset, string, string.length());
    }

    public static String getPascalString(byte[] buffer, int offset) {
        int length = AppleUtil.getUnsignedByte(buffer[offset]);
        return AppleUtil.getString(buffer, offset + 1, length);
    }

    public static void setPascalString(byte[] buffer, int offset, String string, int maxLength) {
        int len = Math.min(string.length(), maxLength);
        buffer[offset] = (byte)(len & 0xFF);
        AppleUtil.setString(buffer, offset + 1, string, len, false);
    }

    public static Date getPascalDate(byte[] buffer, int offset) {
        int pascalDate = AppleUtil.getWordValue(buffer, offset);
        int month = pascalDate & 0xE;
        int day = (pascalDate & 0x1F0) >> 4;
        int year = (pascalDate & 0xFE00) >> 9;
        if (year < 50) {
            year += 2000;
        }
        if (year < 100) {
            year += 1900;
        }
        GregorianCalendar gc = new GregorianCalendar(year, month, day);
        return gc.getTime();
    }

    public static void setPascalDate(byte[] buffer, int offset, Date date) {
        GregorianCalendar gc = new GregorianCalendar();
        gc.setTime(date);
        int month = gc.get(2) + 1;
        int day = gc.get(5);
        int year = gc.get(1) % 100;
        int pascalDate = month & 0xF | day << 4 & 0x1F0 | year << 9 & 0xFE00;
        AppleUtil.setWordValue(buffer, offset, pascalDate);
    }

    public static String getProdosString(byte[] buffer, int offset) {
        int length = AppleUtil.getUnsignedByte(buffer[offset]) & 0xF;
        return AppleUtil.getString(buffer, offset + 1, length);
    }

    public static void setProdosString(byte[] buffer, int offset, String string, int maxLength) {
        int len = Math.min(string.length(), maxLength);
        buffer[offset] = (byte)(buffer[offset] & 0xF0 | len & 0xF);
        AppleUtil.setString(buffer, offset + 1, string, len, false);
    }

    public static String getFormattedByte(int byt) {
        int byt1 = byt & 0xF;
        int byt2 = (byt & 0xF0) >> 4;
        StringBuffer buf = new StringBuffer(2);
        buf.append(hexDigits[byt2]);
        buf.append(hexDigits[byt1]);
        return buf.toString();
    }

    public static String getFormattedWord(int word) {
        return AppleUtil.getFormattedByte((word & 0xFF00) >> 8) + AppleUtil.getFormattedByte(word & 0xFF);
    }

    public static String getFormatted3ByteAddress(int addr) {
        return AppleUtil.getFormattedByte((addr & 0xFF0000) >> 16) + AppleUtil.getFormattedWord(addr & 0xFFFF);
    }

    public static int convertFormattedWord(String word) {
        if (word == null) {
            return 0;
        }
        int value = 0;
        word = word.toUpperCase();
        block0: for (int i = 0; i < word.length(); ++i) {
            char ch = word.charAt(i);
            for (int nybble = 0; nybble < hexDigits.length; ++nybble) {
                if (ch != hexDigits[nybble]) continue;
                value <<= 4;
                value += nybble;
                continue block0;
            }
        }
        return value;
    }

    public static Date getProdosDate(byte[] buffer, int offset) {
        int ymd = AppleUtil.getWordValue(buffer, offset);
        if (ymd == 0) {
            return null;
        }
        int hm = AppleUtil.getWordValue(buffer, offset + 2);
        int day = ymd & 0x1F;
        int month = ((ymd & 0x1E0) >> 5) - 1;
        int year = (ymd & 0xFE00) >> 9;
        int minute = hm & 0x3F;
        int hour = (hm & 0x1F00) >> 8;
        if (year < 50) {
            year += 2000;
        }
        if (year < 100) {
            year += 1900;
        }
        GregorianCalendar gc = new GregorianCalendar(year, month, day, hour, minute);
        return gc.getTime();
    }

    public static void setProdosDate(byte[] buffer, int offset, Date date) {
        int day = 0;
        int month = 0;
        int year = 0;
        int minute = 0;
        int hour = 0;
        if (date != null) {
            GregorianCalendar gc = new GregorianCalendar();
            gc.setTime(date);
            day = gc.get(5);
            month = gc.get(2) + 1;
            year = gc.get(1);
            minute = gc.get(12);
            hour = gc.get(11);
            year = year >= 2000 ? (year -= 2000) : (year -= 1900);
        }
        int ymd = (year & 0x7F) << 9 | (month & 0xF) << 5 | day & 0x1F;
        int hm = (hour & 0x1F) << 8 | minute & 0x3F;
        AppleUtil.setWordValue(buffer, offset, ymd);
        AppleUtil.setWordValue(buffer, offset + 2, hm);
    }

    public static String getNiceFilename(String filename) {
        StringBuffer buf = new StringBuffer();
        for (int i = 0; i < filename.length(); ++i) {
            char ch = filename.charAt(i);
            if (ch == '\\' || ch == '/' || ch == '?' || ch == '*' || ch == ':' || ch == '\"' || ch == '<' || ch == '>' || ch == '|') continue;
            buf.append(ch);
        }
        return buf.toString();
    }

    public static byte[] unpackBytes(byte[] compressedData) {
        ByteArrayOutputStream decompressedStream = new ByteArrayOutputStream(compressedData.length * 2);
        int offset = 0;
        byte[] dataArray = new byte[4];
        block10: while (offset < compressedData.length) {
            byte header = compressedData[offset++];
            int length = (header & 0x3F) + 1;
            switch (header & 0xC0) {
                case 0: {
                    int i;
                    for (i = 0; i < length; ++i) {
                        decompressedStream.write(compressedData[offset++]);
                    }
                    continue block10;
                }
                case 64: {
                    int i;
                    byte data = compressedData[offset++];
                    for (i = 0; i < length; ++i) {
                        decompressedStream.write(data);
                    }
                    continue block10;
                }
                case 128: {
                    int i;
                    for (i = 0; i < 4; ++i) {
                        dataArray[i] = compressedData[offset++];
                    }
                    for (i = 0; i < length; ++i) {
                        try {
                            decompressedStream.write(dataArray);
                            continue;
                        }
                        catch (IOException iOException) {
                            // empty catch block
                        }
                    }
                    continue block10;
                }
                case 192: {
                    int i;
                    byte data = compressedData[offset++];
                    for (i = 0; i < 4; ++i) {
                        dataArray[i] = data;
                    }
                    for (i = 0; i < length; ++i) {
                        try {
                            decompressedStream.write(dataArray);
                            continue;
                        }
                        catch (IOException iOException) {
                            // empty catch block
                        }
                    }
                    break;
                }
            }
        }
        return decompressedStream.toByteArray();
    }

    public static double getSaneNumber(byte[] buffer, int offset) {
        long doubleBits = 0L;
        for (int i = 8; i > 0; --i) {
            doubleBits <<= 8;
            doubleBits += (long)AppleUtil.getUnsignedByte(buffer[offset + i - 1]);
        }
        return Double.longBitsToDouble(doubleBits);
    }

    public static byte[] getApplesoftFloat(double number) {
        long value = Double.doubleToRawLongBits(Math.abs(number));
        long exponentMask = 0xFF0000000000000L;
        long exponentAdj = 0x820000000000000L;
        long signAdj = 0L;
        if (number < 0.0) {
            signAdj = 0x80000000000000L;
        }
        long fractionMask = 0xFFFFFFFF00000L;
        long result = (value & exponentMask) + exponentAdj << 4 | signAdj | (value & fractionMask) << 3;
        long byte1Mask = -72057594037927936L;
        long byte2Mask = 0xFF000000000000L;
        long byte3Mask = 0xFF0000000000L;
        long byte4Mask = 0xFF00000000L;
        long byte5Mask = 0xFF000000L;
        return new byte[]{(byte)((result & byte1Mask) >> 56 & 0xFFL), (byte)((result & byte2Mask) >> 48 & 0xFFL), (byte)((result & byte3Mask) >> 40 & 0xFFL), (byte)((result & byte4Mask) >> 32 & 0xFFL), (byte)((result & byte5Mask) >> 24 & 0xFFL)};
    }

    public static String getHexDump(byte[] bytes) {
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        PrintWriter printer = new PrintWriter(output);
        printer.println(textBundle.get("AppleUtil.HexDumpLine1"));
        printer.println(textBundle.get("AppleUtil.HexDumpLine2"));
        for (int offset = 0; offset < bytes.length; offset += 16) {
            int index;
            printer.print("$");
            printer.print(AppleUtil.getFormatted3ByteAddress(offset));
            printer.print("  ");
            for (int b = 0; b < 16; ++b) {
                if (b == 8) {
                    printer.print(' ');
                }
                printer.print((index = offset + b) < bytes.length ? AppleUtil.getFormattedByte(bytes[index]) : "..");
                printer.print(' ');
            }
            printer.print(' ');
            for (int a = 0; a < 16; ++a) {
                if (a == 8) {
                    printer.print(' ');
                }
                if ((index = offset + a) < bytes.length) {
                    char ch = (char)(bytes[index] & 0x7F);
                    if ((byte)ch >= 32) {
                        printer.print(ch);
                        continue;
                    }
                    printer.print('.');
                    continue;
                }
                printer.print(' ');
            }
            printer.println();
        }
        printer.println(textBundle.get("AppleUtil.HexDumpEndMessage"));
        printer.flush();
        printer.close();
        return output.toString();
    }

    public static void changeImageOrderByTrackAndSector(ImageOrder sourceOrder, ImageOrder targetOrder) {
        if (!AppleUtil.sameSectorsPerDisk(sourceOrder, targetOrder)) {
            throw new IllegalArgumentException(textBundle.get("AppleUtil.CannotChangeImageOrder"));
        }
        for (int track = 0; track < sourceOrder.getTracksPerDisk(); ++track) {
            for (int sector = 0; sector < sourceOrder.getSectorsPerTrack(); ++sector) {
                byte[] data = sourceOrder.readSector(track, sector);
                targetOrder.writeSector(track, sector, data);
            }
        }
    }

    protected static boolean sameSectorsPerDisk(ImageOrder sourceOrder, ImageOrder targetOrder) {
        return sourceOrder.getSectorsPerDisk() == targetOrder.getSectorsPerDisk();
    }

    public static boolean disksEqualByTrackAndSector(FormattedDisk sourceDisk, FormattedDisk targetDisk) {
        ImageOrder targetOrder;
        ImageOrder sourceOrder = sourceDisk.getImageOrder();
        if (!AppleUtil.sameSectorsPerDisk(sourceOrder, targetOrder = targetDisk.getImageOrder())) {
            throw new IllegalArgumentException(textBundle.get("AppleUtil.CannotCompareDisks"));
        }
        for (int track = 0; track < sourceOrder.getTracksPerDisk(); ++track) {
            for (int sector = 0; sector < sourceOrder.getSectorsPerTrack(); ++sector) {
                byte[] targetData;
                byte[] sourceData = sourceOrder.readSector(track, sector);
                if (Arrays.equals(sourceData, targetData = targetOrder.readSector(track, sector))) continue;
                return false;
            }
        }
        return true;
    }

    public static void changeImageOrderByBlock(ImageOrder sourceOrder, ImageOrder targetOrder) {
        if (!AppleUtil.sameBlocksPerDisk(sourceOrder, targetOrder)) {
            throw new IllegalArgumentException(textBundle.get("AppleUtil.CannotChangeImageOrder"));
        }
        for (int block = 0; block < sourceOrder.getBlocksOnDevice(); ++block) {
            byte[] blockData = sourceOrder.readBlock(block);
            targetOrder.writeBlock(block, blockData);
        }
    }

    protected static boolean sameBlocksPerDisk(ImageOrder sourceOrder, ImageOrder targetOrder) {
        return sourceOrder.getBlocksOnDevice() == targetOrder.getBlocksOnDevice();
    }

    public static boolean disksEqualByBlock(FormattedDisk sourceDisk, FormattedDisk targetDisk) {
        ImageOrder targetOrder;
        ImageOrder sourceOrder = sourceDisk.getImageOrder();
        if (!AppleUtil.sameBlocksPerDisk(sourceOrder, targetOrder = targetDisk.getImageOrder())) {
            throw new IllegalArgumentException(textBundle.get("AppleUtil.CannotCompareDisks"));
        }
        for (int block = 0; block < sourceOrder.getBlocksOnDevice(); ++block) {
            byte[] targetData;
            byte[] sourceData = sourceOrder.readBlock(block);
            if (Arrays.equals(sourceData, targetData = targetOrder.readBlock(block))) continue;
            return false;
        }
        return true;
    }
}

