/*
 * Decompiled with CFR 0.152.
 */
package com.webcodepro.applecommander.ui.swt.wizard.importfile;

import com.webcodepro.applecommander.ui.ImportSpecification;
import com.webcodepro.applecommander.ui.UiBundle;
import com.webcodepro.applecommander.ui.UserPreferences;
import com.webcodepro.applecommander.ui.swt.util.SwtUtil;
import com.webcodepro.applecommander.ui.swt.wizard.WizardPane;
import com.webcodepro.applecommander.ui.swt.wizard.importfile.ImportWizard;
import com.webcodepro.applecommander.util.AppleUtil;
import com.webcodepro.applecommander.util.TextBundle;
import java.io.File;
import java.util.Iterator;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowData;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;

public class ImportSelectFilesWizardPane
extends WizardPane {
    private TextBundle textBundle = UiBundle.getInstance();
    private ImportWizard wizard;
    private Composite control;
    private Composite parent;
    private Button removeButton;
    private Button editButton;
    private Table fileTable;
    private Text addressText;
    private Button rawCheckbox;

    public ImportSelectFilesWizardPane(Composite parent, ImportWizard wizard) {
        this.parent = parent;
        this.wizard = wizard;
    }

    @Override
    public WizardPane getNextPane() {
        return null;
    }

    @Override
    public void open() {
        this.control = new Composite(this.parent, 0);
        this.wizard.enableNextButton(false);
        this.wizard.enableFinishButton(false);
        RowLayout layout = new RowLayout(512);
        layout.justify = true;
        layout.marginBottom = 5;
        layout.marginLeft = 5;
        layout.marginRight = 5;
        layout.marginTop = 5;
        layout.spacing = 3;
        this.control.setLayout(layout);
        Label label = new Label(this.control, 64);
        label.setText(this.textBundle.get("ImportWizardPrompt"));
        this.fileTable = new Table(this.control, 68356);
        this.fileTable.setLayoutData(new RowData(330, 100));
        this.fileTable.setHeaderVisible(true);
        this.fileTable.addSelectionListener(new SelectionAdapter(){

            @Override
            public void widgetSelected(SelectionEvent event) {
                ImportSelectFilesWizardPane.this.getRemoveButton().setEnabled(true);
                ImportSelectFilesWizardPane.this.getEditButton().setEnabled(true);
            }

            @Override
            public void widgetDefaultSelected(SelectionEvent event) {
                ImportSelectFilesWizardPane.this.editSelection();
            }
        });
        TableColumn column = new TableColumn(this.fileTable, 16384);
        column.setText(this.textBundle.get("SourceColumnHeader"));
        column.setWidth(130);
        column = new TableColumn(this.fileTable, 16384);
        column.setText(this.textBundle.get("TargetColumnHeader"));
        column.setWidth(130);
        column = new TableColumn(this.fileTable, 16384);
        column.setText(this.textBundle.get("TypeColumnHeader"));
        column.setWidth(70);
        Composite buttonPanel = new Composite(this.control, 0);
        buttonPanel.setLayout(new FillLayout());
        Button chooseButton = new Button(buttonPanel, 8);
        chooseButton.setText(this.textBundle.get("ChooseButton"));
        chooseButton.setFocus();
        chooseButton.addSelectionListener(new SelectionAdapter(){

            @Override
            public void widgetSelected(SelectionEvent event) {
                FileDialog dialog = new FileDialog(ImportSelectFilesWizardPane.this.getParent().getShell(), 4098);
                dialog.setFilterPath(UserPreferences.getInstance().getImportDirectory());
                String filename = dialog.open();
                if (filename != null) {
                    ImportSelectFilesWizardPane.this.setFilenames(dialog.getFilterPath(), dialog.getFileNames());
                    UserPreferences.getInstance().setImportDirectory(dialog.getFilterPath());
                }
            }
        });
        this.removeButton = new Button(buttonPanel, 8);
        this.removeButton.setText(this.textBundle.get("RemoveButton"));
        this.removeButton.setEnabled(false);
        this.removeButton.addSelectionListener(new SelectionAdapter(){

            @Override
            public void widgetSelected(SelectionEvent event) {
                TableItem[] items = ImportSelectFilesWizardPane.this.getFileTable().getSelection();
                for (int i = 0; i < items.length; ++i) {
                    ImportSpecification spec = (ImportSpecification)items[i].getData();
                    ImportSelectFilesWizardPane.this.getWizard().removeImportSpecification(spec);
                }
                ImportSelectFilesWizardPane.this.getRemoveButton().setEnabled(false);
                ImportSelectFilesWizardPane.this.refreshTable();
            }
        });
        this.editButton = new Button(buttonPanel, 8);
        this.editButton.setText(this.textBundle.get("EditButton"));
        this.editButton.setEnabled(false);
        this.editButton.addSelectionListener(new SelectionAdapter(){

            @Override
            public void widgetSelected(SelectionEvent event) {
                ImportSelectFilesWizardPane.this.editSelection();
            }
        });
    }

    protected void setFilenames(String path, String[] filenames) {
        for (int i = 0; i < filenames.length; ++i) {
            ImportSpecification spec = new ImportSpecification(path + File.separatorChar + filenames[i], this.wizard.getDisk().getSuggestedFilename(filenames[i]), this.wizard.getDisk().getSuggestedFiletype(filenames[i]));
            this.wizard.addImportSpecification(spec);
        }
        this.refreshTable();
    }

    protected void refreshTable() {
        this.fileTable.removeAll();
        Iterator<ImportSpecification> specs = this.wizard.getImportSpecifications().iterator();
        boolean canFinish = specs.hasNext();
        while (specs.hasNext()) {
            ImportSpecification spec = specs.next();
            File file = new File(spec.getSourceFilename());
            TableItem item = new TableItem(this.fileTable, 0);
            item.setText(new String[]{file.getName(), spec.getTargetFilename(), spec.getFiletype()});
            item.setData(spec);
            canFinish &= spec.hasFiletype();
        }
        this.fileTable.redraw();
        this.wizard.enableFinishButton(canFinish);
    }

    @Override
    public void dispose() {
        this.fileTable.dispose();
        this.control.dispose();
    }

    public void editSelection() {
        final ImportSpecification spec = (ImportSpecification)this.fileTable.getSelection()[0].getData();
        final Shell dialog = new Shell(this.wizard.getDialog(), 67680);
        dialog.setText(this.textBundle.get("FileImportSettingsTitle"));
        GridLayout layout = new GridLayout();
        layout.horizontalSpacing = 5;
        layout.makeColumnsEqualWidth = false;
        layout.marginHeight = 5;
        layout.marginWidth = 5;
        layout.numColumns = 2;
        layout.verticalSpacing = 5;
        dialog.setLayout(layout);
        Label label = new Label(dialog, 0);
        label.setText(this.textBundle.get("FilenameLabel"));
        final Text filenameText = new Text(dialog, 2048);
        filenameText.setText(spec.getTargetFilename());
        filenameText.setTextLimit(30);
        GridData layoutData = new GridData();
        layoutData.widthHint = 150;
        filenameText.setLayoutData(layoutData);
        label = new Label(dialog, 0);
        label.setText(this.textBundle.get("FiletypeLabel"));
        final Combo filetypes = new Combo(dialog, 2056);
        filetypes.setItems(this.wizard.getDisk().getFiletypes());
        if (spec.hasFiletype()) {
            filetypes.select(filetypes.indexOf(spec.getFiletype()));
        }
        label = new Label(dialog, 0);
        label.setText(this.textBundle.get("AddressLabel"));
        this.addressText = new Text(dialog, 2048);
        this.addressText.setTextLimit(5);
        this.addressText.setText(AppleUtil.getFormattedWord(spec.getAddress()));
        layoutData = new GridData();
        layoutData.widthHint = 75;
        this.addressText.setLayoutData(layoutData);
        if (spec.hasFiletype()) {
            this.addressText.setEnabled(this.wizard.getDisk().needsAddress(spec.getFiletype()));
        }
        label = new Label(dialog, 0);
        label.setText(this.textBundle.get("RawBinaryCheckbox"));
        this.rawCheckbox = new Button(dialog, 32);
        this.rawCheckbox.setSelection(spec.isRawFileImport());
        filetypes.addSelectionListener(new SelectionAdapter(){

            @Override
            public void widgetSelected(SelectionEvent event) {
                String filetype = filetypes.getItem(filetypes.getSelectionIndex());
                ImportSelectFilesWizardPane.this.getAddressText().setEnabled(ImportSelectFilesWizardPane.this.getWizard().getDisk().needsAddress(filetype));
            }
        });
        layoutData = new GridData();
        layoutData.horizontalSpan = 2;
        layoutData.grabExcessHorizontalSpace = true;
        layoutData.horizontalAlignment = 2;
        Composite composite = new Composite(dialog, 0);
        composite.setLayoutData(layoutData);
        composite.setLayout(new FillLayout(256));
        Button button = new Button(composite, 8);
        button.setText(this.textBundle.get("CancelButton"));
        button.addSelectionListener(new SelectionAdapter(){

            @Override
            public void widgetSelected(SelectionEvent e) {
                filenameText.dispose();
                filetypes.dispose();
                ImportSelectFilesWizardPane.this.getAddressText().dispose();
                ImportSelectFilesWizardPane.this.getRawCheckBox().dispose();
                dialog.close();
            }
        });
        button = new Button(composite, 8);
        button.setText(this.textBundle.get("OkButton"));
        dialog.setDefaultButton(button);
        button.addSelectionListener(new SelectionAdapter(){

            @Override
            public void widgetSelected(SelectionEvent e) {
                spec.setTargetFilename(ImportSelectFilesWizardPane.this.getWizard().getDisk().getSuggestedFilename(filenameText.getText()));
                spec.setFiletype(filetypes.getItem(filetypes.getSelectionIndex()));
                spec.setAddress(AppleUtil.convertFormattedWord(ImportSelectFilesWizardPane.this.getAddressText().getText()));
                spec.setRawFileImport(ImportSelectFilesWizardPane.this.getRawCheckBox().getSelection());
                filenameText.dispose();
                filetypes.dispose();
                ImportSelectFilesWizardPane.this.getAddressText().dispose();
                ImportSelectFilesWizardPane.this.getRawCheckBox().dispose();
                dialog.close();
                ImportSelectFilesWizardPane.this.refreshTable();
            }
        });
        dialog.pack();
        SwtUtil.center(this.wizard.getDialog(), dialog);
        dialog.open();
    }

    protected Button getRemoveButton() {
        return this.removeButton;
    }

    protected Button getEditButton() {
        return this.editButton;
    }

    protected Composite getParent() {
        return this.parent;
    }

    protected Table getFileTable() {
        return this.fileTable;
    }

    protected ImportWizard getWizard() {
        return this.wizard;
    }

    protected Text getAddressText() {
        return this.addressText;
    }

    protected Button getRawCheckBox() {
        return this.rawCheckbox;
    }
}

