/*
 * Decompiled with CFR 0.152.
 */
package com.webcodepro.applecommander.ui.swt.wizard.exportfile;

import com.webcodepro.applecommander.storage.filters.AppleWorksDataBaseFileFilter;
import com.webcodepro.applecommander.storage.filters.AppleWorksSpreadSheetFileFilter;
import com.webcodepro.applecommander.storage.filters.AppleWorksWordProcessorFileFilter;
import com.webcodepro.applecommander.storage.filters.ApplesoftFileFilter;
import com.webcodepro.applecommander.storage.filters.AssemblySourceFileFilter;
import com.webcodepro.applecommander.storage.filters.BinaryFileFilter;
import com.webcodepro.applecommander.storage.filters.BusinessBASICFileFilter;
import com.webcodepro.applecommander.storage.filters.GraphicsFileFilter;
import com.webcodepro.applecommander.storage.filters.HexDumpFileFilter;
import com.webcodepro.applecommander.storage.filters.IntegerBasicFileFilter;
import com.webcodepro.applecommander.storage.filters.PascalTextFileFilter;
import com.webcodepro.applecommander.storage.filters.TextFileFilter;
import com.webcodepro.applecommander.ui.UiBundle;
import com.webcodepro.applecommander.ui.swt.wizard.WizardPane;
import com.webcodepro.applecommander.ui.swt.wizard.exportfile.AppleWorksWordProcessorPane;
import com.webcodepro.applecommander.ui.swt.wizard.exportfile.ExportFileDestinationPane;
import com.webcodepro.applecommander.ui.swt.wizard.exportfile.ExportGraphicsTypePane;
import com.webcodepro.applecommander.ui.swt.wizard.exportfile.ExportWizard;
import com.webcodepro.applecommander.util.TextBundle;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;

public class ExportFileStartPane
extends WizardPane {
    private TextBundle textBundle = UiBundle.getInstance();
    private Composite parent;
    private Object layoutData;
    private Composite control;
    private ExportWizard wizard;

    public ExportFileStartPane(Composite parent, ExportWizard exportWizard, Object layoutData) {
        this.parent = parent;
        this.wizard = exportWizard;
        this.layoutData = layoutData;
    }

    @Override
    public void open() {
        this.control = new Composite(this.parent, 0);
        this.control.setLayoutData(this.layoutData);
        this.wizard.enableNextButton(true);
        this.wizard.enableFinishButton(false);
        RowLayout layout = new RowLayout(512);
        layout.justify = true;
        layout.marginBottom = 5;
        layout.marginLeft = 5;
        layout.marginRight = 5;
        layout.marginTop = 5;
        layout.spacing = 3;
        this.control.setLayout(layout);
        Label label = new Label(this.control, 64);
        label.setText(this.textBundle.get("ExportFileTypePrompt"));
        RowLayout subpanelLayout = new RowLayout(512);
        subpanelLayout.justify = true;
        subpanelLayout.spacing = 3;
        Composite buttonSubpanel = new Composite(this.control, 0);
        buttonSubpanel.setLayout(subpanelLayout);
        Button button = new Button(buttonSubpanel, 16);
        button.setText(this.textBundle.get("ExportFileAsRawDiskData"));
        button.setSelection(this.wizard.getFileFilter() == null);
        button.addSelectionListener(new SelectionAdapter(){

            @Override
            public void widgetSelected(SelectionEvent e) {
                ExportFileStartPane.this.getWizard().setFileFilter(null);
            }
        });
        button = new Button(buttonSubpanel, 16);
        button.setText(this.textBundle.get("ExportFileAsBinaryFile"));
        button.setSelection(this.wizard.getFileFilter() instanceof BinaryFileFilter);
        button.addSelectionListener(new SelectionAdapter(){

            @Override
            public void widgetSelected(SelectionEvent e) {
                ExportFileStartPane.this.getWizard().setFileFilter(new BinaryFileFilter());
            }
        });
        button = new Button(buttonSubpanel, 16);
        button.setText(this.textBundle.get("ExportFileAsHexDump"));
        button.setSelection(this.wizard.getFileFilter() instanceof HexDumpFileFilter);
        button.addSelectionListener(new SelectionAdapter(){

            @Override
            public void widgetSelected(SelectionEvent e) {
                ExportFileStartPane.this.getWizard().setFileFilter(new HexDumpFileFilter());
            }
        });
        button = new Button(buttonSubpanel, 16);
        button.setText(this.textBundle.get("ExportFileAsAsciiTextFile"));
        button.setSelection(this.wizard.getFileFilter() instanceof TextFileFilter);
        button.addSelectionListener(new SelectionAdapter(){

            @Override
            public void widgetSelected(SelectionEvent e) {
                ExportFileStartPane.this.getWizard().setFileFilter(new TextFileFilter());
            }
        });
        button = new Button(buttonSubpanel, 16);
        button.setText(this.textBundle.get("ExportFileAsFormattedAssemblyTextFile"));
        button.setSelection(this.wizard.getFileFilter() instanceof AssemblySourceFileFilter);
        button.addSelectionListener(new SelectionAdapter(){

            @Override
            public void widgetSelected(SelectionEvent e) {
                ExportFileStartPane.this.getWizard().setFileFilter(new AssemblySourceFileFilter());
            }
        });
        button = new Button(buttonSubpanel, 16);
        button.setText(this.textBundle.get("ExportFileAsPascalTextFile"));
        button.setSelection(this.wizard.getFileFilter() instanceof PascalTextFileFilter);
        button.addSelectionListener(new SelectionAdapter(){

            @Override
            public void widgetSelected(SelectionEvent e) {
                ExportFileStartPane.this.getWizard().setFileFilter(new PascalTextFileFilter());
            }
        });
        button = new Button(buttonSubpanel, 16);
        button.setText(this.textBundle.get("ExportFileAsApplesoftBasicFile"));
        button.setSelection(this.wizard.getFileFilter() instanceof ApplesoftFileFilter);
        button.addSelectionListener(new SelectionAdapter(){

            @Override
            public void widgetSelected(SelectionEvent e) {
                ExportFileStartPane.this.getWizard().setFileFilter(new ApplesoftFileFilter());
            }
        });
        button = new Button(buttonSubpanel, 16);
        button.setText(this.textBundle.get("ExportFileAsIntegerBasicFile"));
        button.setSelection(this.wizard.getFileFilter() instanceof IntegerBasicFileFilter);
        button.addSelectionListener(new SelectionAdapter(){

            @Override
            public void widgetSelected(SelectionEvent e) {
                ExportFileStartPane.this.getWizard().setFileFilter(new IntegerBasicFileFilter());
            }
        });
        button = new Button(buttonSubpanel, 16);
        button.setText(this.textBundle.get("ExportFileAsBusinessBASICFile"));
        button.setSelection(this.wizard.getFileFilter() instanceof BusinessBASICFileFilter);
        button.addSelectionListener(new SelectionAdapter(){

            @Override
            public void widgetSelected(SelectionEvent e) {
                ExportFileStartPane.this.getWizard().setFileFilter(new BusinessBASICFileFilter());
            }
        });
        button = new Button(buttonSubpanel, 16);
        button.setText(this.textBundle.get("ExportFileAsAppleworksWordProcessorFile"));
        button.setSelection(this.wizard.getFileFilter() instanceof AppleWorksWordProcessorFileFilter);
        button.addSelectionListener(new SelectionAdapter(){

            @Override
            public void widgetSelected(SelectionEvent e) {
                ExportFileStartPane.this.getWizard().setFileFilter(new AppleWorksWordProcessorFileFilter());
            }
        });
        button = new Button(buttonSubpanel, 16);
        button.setText(this.textBundle.get("ExportFileAsAppleworksDatabaseFile"));
        button.setSelection(this.wizard.getFileFilter() instanceof AppleWorksDataBaseFileFilter);
        button.addSelectionListener(new SelectionAdapter(){

            @Override
            public void widgetSelected(SelectionEvent e) {
                ExportFileStartPane.this.getWizard().setFileFilter(new AppleWorksDataBaseFileFilter());
            }
        });
        button = new Button(buttonSubpanel, 16);
        button.setText(this.textBundle.get("ExportFileAsAppleworksSpreadsheetFile"));
        button.setSelection(this.wizard.getFileFilter() instanceof AppleWorksSpreadSheetFileFilter);
        button.addSelectionListener(new SelectionAdapter(){

            @Override
            public void widgetSelected(SelectionEvent e) {
                ExportFileStartPane.this.getWizard().setFileFilter(new AppleWorksSpreadSheetFileFilter());
            }
        });
        button = new Button(buttonSubpanel, 16);
        button.setText(this.textBundle.get("ExportFileAsGraphicsFile"));
        button.setEnabled(GraphicsFileFilter.isCodecAvailable());
        button.setSelection(this.wizard.getFileFilter() instanceof GraphicsFileFilter);
        button.addSelectionListener(new SelectionAdapter(){

            @Override
            public void widgetSelected(SelectionEvent e) {
                ExportFileStartPane.this.getWizard().setFileFilter(new GraphicsFileFilter());
            }
        });
    }

    @Override
    public WizardPane getNextPane() {
        if (this.wizard.getFileFilter() instanceof GraphicsFileFilter) {
            return new ExportGraphicsTypePane(this.parent, this.wizard, this.layoutData);
        }
        if (this.wizard.getFileFilter() instanceof AppleWorksWordProcessorFileFilter) {
            return new AppleWorksWordProcessorPane(this.parent, this.wizard, this.layoutData);
        }
        return new ExportFileDestinationPane(this.parent, this.wizard, this.layoutData);
    }

    @Override
    public void dispose() {
        this.control.dispose();
        this.control = null;
    }

    protected ExportWizard getWizard() {
        return this.wizard;
    }
}

