/*
 * Decompiled with CFR 0.152.
 */
package com.webcodepro.applecommander.ui.swt.wizard.diskimage;

import com.webcodepro.applecommander.ui.UiBundle;
import com.webcodepro.applecommander.ui.swt.wizard.WizardPane;
import com.webcodepro.applecommander.ui.swt.wizard.diskimage.DiskImageWizard;
import com.webcodepro.applecommander.util.TextBundle;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;

public class DiskImageOrderPane
extends WizardPane {
    private TextBundle textBundle = UiBundle.getInstance();
    private DiskImageWizard wizard;
    private Composite control;
    private Composite parent;

    public DiskImageOrderPane(Composite parent, DiskImageWizard wizard) {
        this.parent = parent;
        this.wizard = wizard;
    }

    @Override
    public WizardPane getNextPane() {
        return null;
    }

    @Override
    public void open() {
        this.control = new Composite(this.parent, 0);
        this.wizard.enableNextButton(false);
        this.wizard.enableFinishButton(true);
        RowLayout layout = new RowLayout(512);
        layout.justify = true;
        layout.marginBottom = 5;
        layout.marginLeft = 5;
        layout.marginRight = 5;
        layout.marginTop = 5;
        layout.spacing = 3;
        this.control.setLayout(layout);
        Label label = new Label(this.control, 64);
        if (this.wizard.isHardDisk()) {
            label.setText(this.textBundle.get("DiskImageOrderProdosOnly"));
        } else {
            label.setText(this.textBundle.get("DiskImageOrderPrompt"));
        }
        RowLayout subpanelLayout = new RowLayout(512);
        subpanelLayout.justify = true;
        subpanelLayout.spacing = 3;
        Composite buttonSubpanel = new Composite(this.control, 0);
        buttonSubpanel.setLayout(subpanelLayout);
        this.createRadioButton(buttonSubpanel, this.textBundle.get("DiskImageOrderDosLabel"), 1, this.textBundle.get("DiskImageOrderDosText"));
        this.createRadioButton(buttonSubpanel, this.textBundle.get("DiskImageOrderProdosLabel"), 2, this.textBundle.get("DiskImageOrderProdosText"));
        if (this.wizard.getSize() == 143360) {
            this.createRadioButton(buttonSubpanel, this.textBundle.get("DiskImageOrderNibbleLabel"), 3, this.textBundle.get("DiskImageOrderNibbleText"));
        }
        label = new Label(this.control, 64);
        if (this.wizard.isHardDisk()) {
            label.setText(this.textBundle.get("DiskImageOrderNoCompression"));
        } else {
            label.setText(this.textBundle.get("DiskImageOrderCompressionPrompt"));
        }
        Button button = new Button(this.control, 32);
        button.setText(this.textBundle.get("DiskImageOrderGzipCheckbox"));
        button.setToolTipText(this.textBundle.get("DiskImageOrderGzipTooltip"));
        button.setSelection(this.wizard.isCompressed());
        button.setEnabled(!this.wizard.isHardDisk());
        button.addSelectionListener(new SelectionAdapter(){

            @Override
            public void widgetSelected(SelectionEvent e) {
                DiskImageOrderPane.this.getWizard().setCompressed(!DiskImageOrderPane.this.getWizard().isCompressed());
            }
        });
    }

    protected void createRadioButton(Composite composite, String label, final int order, String helpText) {
        Button button = new Button(composite, 16);
        button.setText(label);
        button.setToolTipText(helpText);
        button.setSelection(this.wizard.getOrder() == order);
        button.setEnabled(!this.wizard.isHardDisk());
        button.addSelectionListener(new SelectionAdapter(){

            @Override
            public void widgetSelected(SelectionEvent e) {
                DiskImageOrderPane.this.getWizard().setOrder(order);
            }
        });
    }

    @Override
    public void dispose() {
        this.control.dispose();
    }

    protected DiskImageWizard getWizard() {
        return this.wizard;
    }
}

