/*
 * Decompiled with CFR 0.152.
 */
package com.webcodepro.applecommander.ui.swt.util;

import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;

public class DropDownSelectionListener
extends SelectionAdapter {
    private Menu menu = null;
    private boolean visible = false;

    public DropDownSelectionListener(Menu menu) {
        this.menu = menu;
        MenuItem[] menuItems = menu.getItems();
        for (int i = 0; i < menuItems.length; ++i) {
            menuItems[i].addSelectionListener(new SelectionAdapter(){

                @Override
                public void widgetSelected(SelectionEvent e) {
                    DropDownSelectionListener.this.setMenuVisible(false);
                }
            });
        }
    }

    @Override
    public void widgetSelected(SelectionEvent event) {
        if (event.detail == 4) {
            if (this.visible) {
                this.setMenuVisible(false);
            } else {
                ToolItem toolItem = (ToolItem)event.widget;
                ToolBar toolBar = toolItem.getParent();
                Rectangle toolItemBounds = toolItem.getBounds();
                Point point = toolBar.toDisplay(new Point(toolItemBounds.x, toolItemBounds.y));
                this.menu.setLocation(point.x, point.y + toolItemBounds.height);
                this.setMenuVisible(true);
            }
        }
    }

    protected void setMenuVisible(boolean visible) {
        this.menu.setVisible(visible);
        this.visible = visible;
    }
}

