/*
 * Decompiled with CFR 0.152.
 */
package com.webcodepro.applecommander.ui.swt.filteradapter;

import com.webcodepro.applecommander.storage.FileEntry;
import com.webcodepro.applecommander.storage.FileFilter;
import com.webcodepro.applecommander.ui.swt.FileViewerWindow;
import com.webcodepro.applecommander.ui.swt.util.contentadapter.ContentTypeAdapter;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;

public abstract class FilterAdapter {
    private final FileViewerWindow window;
    private Image image;
    private String text;
    private String toolTipText;
    private ToolItem toolItem;
    private boolean nativeSelected = true;
    private boolean hexSelected = false;
    private boolean dumpSelected = false;

    public FilterAdapter(FileViewerWindow window, String text, String toolTipText, Image image) {
        this.text = text;
        this.window = window;
        this.toolTipText = toolTipText;
        this.image = image;
        this.setNativeSelected();
    }

    public abstract void display();

    public void dispose() {
    }

    public ToolItem create(ToolBar toolBar) {
        if (this.toolItem == null) {
            this.toolItem = new ToolItem(toolBar, 16);
            this.toolItem.setImage(this.getImage());
            this.toolItem.setText(this.getText());
            this.toolItem.setToolTipText(this.getToolTipText());
            this.toolItem.setSelection(false);
            this.toolItem.addSelectionListener(new SelectionAdapter(){

                @Override
                public void widgetSelected(SelectionEvent e) {
                    FilterAdapter.this.display();
                    FilterAdapter.this.getWindow().setFilterToolItemSelection(FilterAdapter.this.isNativeSelected(), FilterAdapter.this.isHexSelected(), FilterAdapter.this.isDumpSelected());
                }
            });
        }
        return this.toolItem;
    }

    protected Image getImage() {
        return this.image;
    }

    protected String getText() {
        return this.text;
    }

    protected String getToolTipText() {
        return this.toolTipText;
    }

    protected FileFilter getFileFilter() {
        return this.window.getFileFilter();
    }

    protected FileEntry getFileEntry() {
        return this.window.getFileEntry();
    }

    protected ToolItem getCopyToolItem() {
        return this.window.getCopyToolItem();
    }

    protected ScrolledComposite getComposite() {
        return this.window.getComposite();
    }

    protected void setContentTypeAdapter(ContentTypeAdapter adapter) {
        this.window.setContentTypeAdapter(adapter);
    }

    protected Font getCourierFont() {
        return this.window.getCourierFont();
    }

    protected Listener getToolbarCommandHandler() {
        return this.window.createToolbarCommandHandler();
    }

    protected ToolItem getToolItem() {
        return this.toolItem;
    }

    protected Color getBlackColor() {
        return this.window.getBlackColor();
    }

    protected Color getGreenColor() {
        return this.window.getGreenColor();
    }

    protected Color getBlueColor() {
        return this.window.getBlueColor();
    }

    public void setDumpSelected() {
        this.nativeSelected = false;
        this.hexSelected = false;
        this.dumpSelected = true;
    }

    public void setHexSelected() {
        this.nativeSelected = false;
        this.hexSelected = true;
        this.dumpSelected = false;
    }

    public void setNativeSelected() {
        this.nativeSelected = true;
        this.hexSelected = false;
        this.dumpSelected = false;
    }

    protected boolean isDumpSelected() {
        return this.dumpSelected;
    }

    protected boolean isHexSelected() {
        return this.hexSelected;
    }

    protected boolean isNativeSelected() {
        return this.nativeSelected;
    }

    protected FileViewerWindow getWindow() {
        return this.window;
    }
}

