/*
 * Decompiled with CFR 0.152.
 */
package com.webcodepro.applecommander.storage.os.rdos;

import com.webcodepro.applecommander.storage.DirectoryEntry;
import com.webcodepro.applecommander.storage.DiskFullException;
import com.webcodepro.applecommander.storage.FileEntry;
import com.webcodepro.applecommander.storage.FormattedDisk;
import com.webcodepro.applecommander.storage.StorageBundle;
import com.webcodepro.applecommander.storage.os.rdos.RdosFileEntry;
import com.webcodepro.applecommander.storage.physical.ImageOrder;
import com.webcodepro.applecommander.util.AppleUtil;
import com.webcodepro.applecommander.util.TextBundle;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.List;

public class RdosFormatDisk
extends FormattedDisk {
    private TextBundle textBundle = StorageBundle.getInstance();
    private static final int[] sectorSkew = new int[]{0, 7, 14, 6, 13, 5, 12, 4, 11, 3, 10, 2, 9, 1, 8, 15};
    public static final int ENTRY_LENGTH = 32;
    public static final int BLOCKS_ON_DISK = 455;
    public static final String[] filetypes = new String[]{"B", "A", "T"};

    public RdosFormatDisk(String filename, ImageOrder imageOrder) {
        super(filename, imageOrder);
    }

    public static RdosFormatDisk[] create(String filename, ImageOrder imageOrder) {
        RdosFormatDisk disk = new RdosFormatDisk(filename, imageOrder);
        disk.format();
        return new RdosFormatDisk[]{disk};
    }

    public byte[] readRdosBlock(int block) {
        int track = block / 13;
        int sector = sectorSkew[block % 13];
        return this.readSector(track, sector);
    }

    public void writeRdosBlock(int block, byte[] data) {
        int track = block / 13;
        int sector = sectorSkew[block % 13];
        this.writeSector(track, sector, data);
    }

    @Override
    public String getDiskName() {
        byte[] block = this.readRdosBlock(4);
        return AppleUtil.getString(block, 224, 32);
    }

    @Override
    public List<FileEntry> getFiles() {
        ArrayList<FileEntry> files = new ArrayList<FileEntry>();
        for (int b = 13; b < 23; ++b) {
            byte[] data = this.readRdosBlock(b);
            for (int i = 0; i < data.length; i += 32) {
                byte[] entry = new byte[32];
                System.arraycopy(data, i, entry, 0, entry.length);
                if (AppleUtil.getUnsignedByte(entry[0]) == 0) continue;
                RdosFileEntry fileEntry = new RdosFileEntry(entry, this);
                files.add(fileEntry);
            }
        }
        return files;
    }

    @Override
    public FileEntry createFile() throws DiskFullException {
        throw new DiskFullException(this.textBundle.get("FileCreationNotSupported"), this.getFilename());
    }

    @Override
    public boolean canCreateDirectories() {
        return false;
    }

    @Override
    public boolean canCreateFile() {
        return false;
    }

    @Override
    public String getFormat() {
        return this.textBundle.get("RdosFormatDisk.Rdos21");
    }

    public int getFreeBlocks() {
        return 455 - this.getUsedBlocks();
    }

    public int getUsedBlocks() {
        int used = 0;
        for (RdosFileEntry rdosFileEntry : this.getFiles()) {
            if (rdosFileEntry.isDeleted()) continue;
            used += rdosFileEntry.getSizeInBlocks();
        }
        return used;
    }

    @Override
    public int getFreeSpace() {
        return this.getFreeBlocks() * 256;
    }

    @Override
    public int getUsedSpace() {
        return this.getUsedBlocks() * 256;
    }

    @Override
    public int[] getBitmapDimensions() {
        return null;
    }

    @Override
    public int getBitmapLength() {
        return 455;
    }

    @Override
    public FormattedDisk.DiskUsage getDiskUsage() {
        return new RdosDiskUsage();
    }

    @Override
    public String[] getBitmapLabels() {
        return new String[]{this.textBundle.get("Block")};
    }

    @Override
    public List<FormattedDisk.DiskInformation> getDiskInformation() {
        List<FormattedDisk.DiskInformation> list = super.getDiskInformation();
        list.add((FormattedDisk)this.new FormattedDisk.DiskInformation(this.textBundle.get("TotalBlocks"), 455));
        list.add((FormattedDisk)this.new FormattedDisk.DiskInformation(this.textBundle.get("FreeBlocks"), this.getFreeBlocks()));
        list.add((FormattedDisk)this.new FormattedDisk.DiskInformation(this.textBundle.get("UsedBlocks"), this.getUsedBlocks()));
        return list;
    }

    @Override
    public List<FormattedDisk.FileColumnHeader> getFileColumnHeaders(int displayMode) {
        ArrayList<FormattedDisk.FileColumnHeader> list = new ArrayList<FormattedDisk.FileColumnHeader>();
        switch (displayMode) {
            case 2: {
                list.add(new FormattedDisk.FileColumnHeader(this.textBundle.get("Type"), 1, 2));
                list.add(new FormattedDisk.FileColumnHeader(this.textBundle.get("Blocks"), 3, 3));
                list.add(new FormattedDisk.FileColumnHeader(this.textBundle.get("Name"), 24, 1));
                list.add(new FormattedDisk.FileColumnHeader(this.textBundle.get("RdosFormatDisk.Size"), 6, 3));
                list.add(new FormattedDisk.FileColumnHeader(this.textBundle.get("RdosFormatDisk.StartingBlock"), 3, 3));
                break;
            }
            case 3: {
                list.add(new FormattedDisk.FileColumnHeader(this.textBundle.get("Type"), 1, 2));
                list.add(new FormattedDisk.FileColumnHeader(this.textBundle.get("Blocks"), 3, 3));
                list.add(new FormattedDisk.FileColumnHeader(this.textBundle.get("Name"), 24, 1));
                list.add(new FormattedDisk.FileColumnHeader(this.textBundle.get("RdosFormatDisk.Size"), 6, 3));
                list.add(new FormattedDisk.FileColumnHeader(this.textBundle.get("RdosFormatDisk.StartingBlock"), 3, 3));
                list.add(new FormattedDisk.FileColumnHeader(this.textBundle.get("RdosFormatDisk.Address"), 5, 3));
                list.add(new FormattedDisk.FileColumnHeader(this.textBundle.get("DeletedQ"), 7, 2));
                break;
            }
            default: {
                list.addAll(super.getFileColumnHeaders(displayMode));
            }
        }
        return list;
    }

    @Override
    public boolean supportsDeletedFiles() {
        return true;
    }

    @Override
    public boolean canReadFileData() {
        return true;
    }

    @Override
    public boolean canWriteFileData() {
        return false;
    }

    @Override
    public boolean canHaveDirectories() {
        return false;
    }

    @Override
    public boolean canDeleteFile() {
        return false;
    }

    @Override
    public byte[] getFileData(FileEntry fileEntry) {
        if (!(fileEntry instanceof RdosFileEntry)) {
            throw new IllegalArgumentException(this.textBundle.get("RdosFormatDisk.IncorrectFileEntryError"));
        }
        RdosFileEntry rdosEntry = (RdosFileEntry)fileEntry;
        int startingBlock = rdosEntry.getStartingBlock();
        byte[] fileData = new byte[rdosEntry.getSizeInBlocks() * 256];
        int offset = 0;
        for (int blockOffset = 0; blockOffset < rdosEntry.getSizeInBlocks(); ++blockOffset) {
            byte[] blockData = this.readRdosBlock(startingBlock + blockOffset);
            System.arraycopy(blockData, 0, fileData, offset, blockData.length);
            offset += blockData.length;
        }
        return fileData;
    }

    @Override
    public void format() {
        this.getImageOrder().format();
        this.writeBootCode();
        byte[] block = this.readSector(0, 13);
        AppleUtil.setString(block, 224, this.textBundle.get("RdosFormatDisk.IdentifierText"), 32);
        this.writeSector(0, 13, block);
        block = new byte[256];
        block[0] = 96;
        this.writeSector(1, 9, block);
        byte[] data = this.readRdosBlock(13);
        AppleUtil.setString(data, 0, this.textBundle.get("RdosFormatDisk.InitialSystemFile"), 24);
        AppleUtil.setString(data, 24, "B", 1);
        data[25] = 26;
        AppleUtil.setWordValue(data, 26, 4096);
        AppleUtil.setWordValue(data, 28, 6656);
        AppleUtil.setWordValue(data, 30, 0);
        this.writeRdosBlock(13, data);
    }

    @Override
    public int getLogicalDiskNumber() {
        return 0;
    }

    @Override
    public String getSuggestedFilename(String filename) {
        int len = Math.min(filename.length(), 24);
        return filename.toUpperCase().substring(0, len).trim();
    }

    @Override
    public String getSuggestedFiletype(String filename) {
        String what;
        String filetype = "B";
        int pos = filename.lastIndexOf(".");
        if (pos > 0 && "txt".equalsIgnoreCase(what = filename.substring(pos + 1))) {
            filetype = "T";
        }
        return filetype;
    }

    @Override
    public String[] getFiletypes() {
        return filetypes;
    }

    @Override
    public boolean needsAddress(String filetype) {
        return "B".equals(filetype);
    }

    @Override
    public boolean supportsDiskMap() {
        return true;
    }

    @Override
    public void changeImageOrder(ImageOrder imageOrder) {
        AppleUtil.changeImageOrderByTrackAndSector(this.getImageOrder(), imageOrder);
        this.setImageOrder(imageOrder);
    }

    @Override
    public void setFileData(FileEntry fileEntry, byte[] fileData) throws DiskFullException {
    }

    @Override
    public DirectoryEntry createDirectory(String name) throws DiskFullException {
        throw new UnsupportedOperationException(this.textBundle.get("DirectoryCreationNotSupported"));
    }

    private class RdosDiskUsage
    implements FormattedDisk.DiskUsage {
        private int location = -1;
        private BitSet bitmap = null;

        private RdosDiskUsage() {
        }

        @Override
        public boolean hasNext() {
            return this.location == -1 || this.location < 454;
        }

        @Override
        public void next() {
            if (this.bitmap == null) {
                this.bitmap = new BitSet(455);
                for (int b = 0; b < 455; ++b) {
                    this.bitmap.set(b);
                }
                for (RdosFileEntry rdosFileEntry : RdosFormatDisk.this.getFiles()) {
                    if (rdosFileEntry.isDeleted()) continue;
                    for (int b = 0; b < rdosFileEntry.getSizeInBlocks(); ++b) {
                        this.bitmap.clear(rdosFileEntry.getStartingBlock() + b);
                    }
                }
                this.location = 0;
            } else {
                ++this.location;
            }
        }

        @Override
        public boolean isFree() {
            return this.bitmap.get(this.location);
        }

        @Override
        public boolean isUsed() {
            return !this.bitmap.get(this.location);
        }
    }
}

