/*
 * Decompiled with CFR 0.152.
 */
package com.webcodepro.applecommander.ui.swt.wizard.exportfile;

import com.webcodepro.applecommander.storage.filters.GraphicsFileFilter;
import com.webcodepro.applecommander.ui.UiBundle;
import com.webcodepro.applecommander.ui.swt.wizard.WizardPane;
import com.webcodepro.applecommander.ui.swt.wizard.exportfile.ExportFileDestinationPane;
import com.webcodepro.applecommander.ui.swt.wizard.exportfile.ExportWizard;
import com.webcodepro.applecommander.util.TextBundle;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;

public class ExportGraphicsTypePane
extends WizardPane {
    private TextBundle textBundle = UiBundle.getInstance();
    private Composite parent;
    private Object layoutData;
    private Composite control;
    private ExportWizard wizard;

    public ExportGraphicsTypePane(Composite parent, ExportWizard exportWizard, Object layoutData) {
        this.parent = parent;
        this.wizard = exportWizard;
        this.layoutData = layoutData;
    }

    @Override
    public WizardPane getNextPane() {
        return new ExportFileDestinationPane(this.parent, this.wizard, this.layoutData);
    }

    @Override
    public void open() {
        this.wizard.enableFinishButton(false);
        this.wizard.enableNextButton(true);
        this.control = new Composite(this.parent, 0);
        this.control.setLayoutData(this.layoutData);
        RowLayout layout = new RowLayout(512);
        layout.justify = true;
        layout.marginBottom = 5;
        layout.marginLeft = 5;
        layout.marginRight = 5;
        layout.marginTop = 5;
        layout.spacing = 3;
        this.control.setLayout(layout);
        Label label = new Label(this.control, 64);
        label.setText(this.textBundle.get("ExportGraphicsTypePrompt"));
        RowLayout subpanelLayout = new RowLayout(512);
        subpanelLayout.justify = true;
        subpanelLayout.spacing = 3;
        Composite graphicsModeGroup = new Composite(this.control, 0);
        graphicsModeGroup.setLayout(subpanelLayout);
        Button button = new Button(graphicsModeGroup, 16);
        button.setText(this.textBundle.get("ExportGraphicsTypeHiresBlackAndWhite"));
        button.setSelection(this.getGraphicsFilter().isHiresBlackAndWhiteMode());
        button.addSelectionListener(new SelectionAdapter(){

            @Override
            public void widgetSelected(SelectionEvent e) {
                ExportGraphicsTypePane.this.getGraphicsFilter().setMode(1);
            }
        });
        button = new Button(graphicsModeGroup, 16);
        button.setText(this.textBundle.get("ExportGraphicsTypeHiresColor"));
        button.setSelection(this.getGraphicsFilter().isHiresColorMode());
        button.addSelectionListener(new SelectionAdapter(){

            @Override
            public void widgetSelected(SelectionEvent e) {
                ExportGraphicsTypePane.this.getGraphicsFilter().setMode(2);
            }
        });
        button = new Button(graphicsModeGroup, 16);
        button.setText(this.textBundle.get("ExportGraphicsTypeDoubleHiresBlackAndWhite"));
        button.setSelection(this.getGraphicsFilter().isDoubleHiresBlackAndWhiteMode());
        button.addSelectionListener(new SelectionAdapter(){

            @Override
            public void widgetSelected(SelectionEvent e) {
                ExportGraphicsTypePane.this.getGraphicsFilter().setMode(3);
            }
        });
        button = new Button(graphicsModeGroup, 16);
        button.setText(this.textBundle.get("ExportGraphicsTypeDoubleHiresColor"));
        button.setSelection(this.getGraphicsFilter().isDoubleHiresColorMode());
        button.addSelectionListener(new SelectionAdapter(){

            @Override
            public void widgetSelected(SelectionEvent e) {
                ExportGraphicsTypePane.this.getGraphicsFilter().setMode(4);
            }
        });
        button = new Button(graphicsModeGroup, 16);
        button.setText(this.textBundle.get("ExportGraphicsTypeSuperHiresColor"));
        button.setSelection(this.getGraphicsFilter().isSuperHires16Mode());
        button.addSelectionListener(new SelectionAdapter(){

            @Override
            public void widgetSelected(SelectionEvent e) {
                ExportGraphicsTypePane.this.getGraphicsFilter().setMode(5);
            }
        });
        button = new Button(graphicsModeGroup, 16);
        button.setText(this.textBundle.get("ExportGraphicsTypeSuperHires3200Color"));
        button.setSelection(this.getGraphicsFilter().isSuperHires3200Mode());
        button.addSelectionListener(new SelectionAdapter(){

            @Override
            public void widgetSelected(SelectionEvent e) {
                ExportGraphicsTypePane.this.getGraphicsFilter().setMode(6);
            }
        });
        button = new Button(graphicsModeGroup, 16);
        button.setText(this.textBundle.get("ExportGraphicsTypeQuickDraw2Icon"));
        button.setSelection(this.getGraphicsFilter().isQuickDraw2Icon());
        button.addSelectionListener(new SelectionAdapter(){

            @Override
            public void widgetSelected(SelectionEvent e) {
                ExportGraphicsTypePane.this.getGraphicsFilter().setMode(7);
            }
        });
        label = new Label(this.control, 64);
        label.setText(this.textBundle.get("ExportGraphicsFileFormatPrompt"));
        Composite graphicsFormatGroup = new Composite(this.control, 0);
        graphicsFormatGroup.setLayout(subpanelLayout);
        String[] formats = GraphicsFileFilter.getFileExtensions();
        for (int i = 0; i < formats.length; ++i) {
            button = new Button(graphicsFormatGroup, 16);
            button.setText(formats[i]);
            button.setSelection(formats[i].equals(this.getGraphicsFilter().getExtension()));
            button.addSelectionListener(new SelectionAdapter(){

                @Override
                public void widgetSelected(SelectionEvent e) {
                    Button source = (Button)e.getSource();
                    ExportGraphicsTypePane.this.getGraphicsFilter().setExtension(source.getText());
                }
            });
        }
    }

    @Override
    public void dispose() {
        this.control.dispose();
        this.control = null;
    }

    protected GraphicsFileFilter getGraphicsFilter() {
        return (GraphicsFileFilter)this.wizard.getFileFilter();
    }
}

