/*
 * Decompiled with CFR 0.152.
 */
package com.webcodepro.applecommander.storage.os.prodos;

import com.webcodepro.applecommander.storage.os.prodos.ProdosCommonEntry;
import com.webcodepro.applecommander.storage.os.prodos.ProdosFormatDisk;
import com.webcodepro.applecommander.util.AppleUtil;

public class ProdosCommonDirectoryHeader
extends ProdosCommonEntry {
    public ProdosCommonDirectoryHeader(ProdosFormatDisk disk, int block) {
        super(disk, block, 4);
    }

    public int getEntryLength() {
        return AppleUtil.getUnsignedByte(this.readFileEntry()[31]);
    }

    public void setEntryLength() {
        byte[] data = this.readFileEntry();
        data[31] = 39;
        this.writeFileEntry(data);
    }

    public int getEntriesPerBlock() {
        return AppleUtil.getUnsignedByte(this.readFileEntry()[32]);
    }

    public void setEntriesPerBlock() {
        byte[] data = this.readFileEntry();
        data[32] = 13;
        this.writeFileEntry(data);
    }

    public int getFileCount() {
        return AppleUtil.getWordValue(this.readFileEntry(), 33);
    }

    public void setFileCount(int fileCount) {
        byte[] data = this.readFileEntry();
        AppleUtil.setWordValue(data, 33, fileCount);
        this.writeFileEntry(data);
    }

    public void incrementFileCount() {
        byte[] data = this.readFileEntry();
        data[33] = (byte)(data[33] + 1);
        this.writeFileEntry(data);
    }

    public void decrementFileCount() {
        byte[] data = this.readFileEntry();
        if (data[33] != 0) {
            data[33] = (byte)(data[33] - 1);
        }
        this.writeFileEntry(data);
    }

    public int getBitMapPointer() {
        return AppleUtil.getWordValue(this.readFileEntry(), 35);
    }

    public void setBitMapPointer(int blockNumber) {
        byte[] data = this.readFileEntry();
        AppleUtil.setWordValue(data, 35, blockNumber);
        this.writeFileEntry(data);
    }

    public int getTotalBlocks() {
        return AppleUtil.getWordValue(this.readFileEntry(), 37);
    }

    public void setTotalBlocks(int totalBlocks) {
        byte[] data = this.readFileEntry();
        AppleUtil.setWordValue(data, 37, totalBlocks);
        this.writeFileEntry(data);
    }
}

