/*
 * Decompiled with CFR 0.152.
 */
package com.webcodepro.applecommander.ui.swt.wizard.diskimage;

import com.webcodepro.applecommander.storage.FormattedDisk;
import com.webcodepro.applecommander.storage.os.cpm.CpmFormatDisk;
import com.webcodepro.applecommander.storage.os.dos33.DosFormatDisk;
import com.webcodepro.applecommander.storage.os.dos33.OzDosFormatDisk;
import com.webcodepro.applecommander.storage.os.dos33.UniDosFormatDisk;
import com.webcodepro.applecommander.storage.os.pascal.PascalFormatDisk;
import com.webcodepro.applecommander.storage.os.prodos.ProdosFormatDisk;
import com.webcodepro.applecommander.storage.os.rdos.RdosFormatDisk;
import com.webcodepro.applecommander.storage.physical.ByteArrayImageLayout;
import com.webcodepro.applecommander.storage.physical.DosOrder;
import com.webcodepro.applecommander.storage.physical.ImageOrder;
import com.webcodepro.applecommander.storage.physical.NibbleOrder;
import com.webcodepro.applecommander.storage.physical.ProdosOrder;
import com.webcodepro.applecommander.ui.UiBundle;
import com.webcodepro.applecommander.ui.swt.util.ImageManager;
import com.webcodepro.applecommander.ui.swt.wizard.Wizard;
import com.webcodepro.applecommander.ui.swt.wizard.WizardPane;
import com.webcodepro.applecommander.ui.swt.wizard.diskimage.DiskImageFormatPane;
import org.eclipse.swt.widgets.Shell;

public class DiskImageWizard
extends Wizard {
    public static final int FORMAT_DOS33 = 1;
    public static final int FORMAT_UNIDOS = 2;
    public static final int FORMAT_PRODOS = 3;
    public static final int FORMAT_PASCAL = 4;
    public static final int FORMAT_RDOS = 5;
    public static final int FORMAT_OZDOS = 6;
    public static final int FORMAT_CPM = 7;
    public static final int ORDER_DOS = 1;
    public static final int ORDER_PRODOS = 2;
    public static final int ORDER_NIBBLE = 3;
    private int format = 1;
    private int size = 143360;
    private String fileName = new String();
    private String volumeName = new String();
    private int order = 2;
    private boolean compressed = false;

    public DiskImageWizard(Shell parent, ImageManager imageManager) {
        super(parent, imageManager.get("DiskImageWizardLogo.gif"), UiBundle.getInstance().get("DiskImageWizardTitle"));
    }

    @Override
    public WizardPane createInitialWizardPane() {
        return new DiskImageFormatPane(this.getContentPane(), this);
    }

    public FormattedDisk[] getFormattedDisks() {
        StringBuffer name = new StringBuffer(this.fileName);
        if (this.isHardDisk()) {
            name.append(".hdv");
        } else if (this.order == 1) {
            name.append(".dsk");
        } else {
            name.append(".po");
        }
        if (this.isCompressed()) {
            name.append(".gz");
        }
        ByteArrayImageLayout imageLayout = new ByteArrayImageLayout(this.getSize());
        ImageOrder imageOrder = null;
        switch (this.getOrder()) {
            case 1: {
                imageOrder = new DosOrder(imageLayout);
                break;
            }
            case 3: {
                imageOrder = new NibbleOrder(imageLayout);
                break;
            }
            case 2: {
                imageOrder = new ProdosOrder(imageLayout);
            }
        }
        switch (this.format) {
            case 1: {
                return DosFormatDisk.create(name.toString(), imageOrder);
            }
            case 6: {
                return OzDosFormatDisk.create(name.toString(), imageOrder);
            }
            case 4: {
                return PascalFormatDisk.create(name.toString(), this.volumeName, imageOrder);
            }
            case 3: {
                return ProdosFormatDisk.create(name.toString(), this.volumeName, imageOrder);
            }
            case 5: {
                return RdosFormatDisk.create(name.toString(), imageOrder);
            }
            case 2: {
                return UniDosFormatDisk.create(name.toString(), imageOrder);
            }
            case 7: {
                return CpmFormatDisk.create(name.toString(), imageOrder);
            }
        }
        return null;
    }

    public int getFormat() {
        return this.format;
    }

    public void setFormat(int format) {
        this.format = format;
    }

    public int getSize() {
        return this.size;
    }

    public void setSize(int size) {
        this.size = size;
    }

    public String getFileName() {
        return this.fileName;
    }

    public String getVolumeName() {
        return this.volumeName;
    }

    public void setFileName(String fileName) {
        this.fileName = fileName;
    }

    public void setVolumeName(String volumeName) {
        this.volumeName = volumeName;
    }

    public boolean isFormatProdos() {
        return this.format == 3;
    }

    public boolean isFormatPascal() {
        return this.format == 4;
    }

    public int getOrder() {
        return this.order;
    }

    public void setOrder(int order) {
        this.order = order;
    }

    public boolean isCompressed() {
        return this.compressed;
    }

    public void setCompressed(boolean compressed) {
        this.compressed = compressed;
    }

    public boolean isHardDisk() {
        return this.size > 819264;
    }
}

