/*
 * Decompiled with CFR 0.152.
 */
package com.webcodepro.applecommander.ui.swt.util;

import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;

public class ImageCanvas
extends Canvas
implements PaintListener {
    private Image image;

    public ImageCanvas(Composite parent, int style, Image image, Object layoutData) {
        super(parent, style | 0x4F0 | 0x40000 | 0x100000);
        this.image = image;
        this.setLayoutData(layoutData);
        this.setSize(image.getImageData().width, image.getImageData().height);
        this.addPaintListener(this);
    }

    @Override
    public void paintControl(PaintEvent event) {
        int marginHeight;
        GC gc = event.gc;
        gc.drawImage(this.image, 0, 0);
        Rectangle rect = this.image.getBounds();
        Rectangle client = this.getClientArea();
        int marginWidth = client.width - rect.width;
        if (marginWidth > 0) {
            gc.fillRectangle(rect.width, 0, marginWidth, client.height);
        }
        if ((marginHeight = client.height - rect.height) > 0) {
            gc.fillRectangle(0, rect.height, client.width, marginHeight);
        }
    }

    public Image getImage() {
        return this.image;
    }
}

