/*
 * Decompiled with CFR 0.152.
 */
package com.webcodepro.applecommander.ui.swt;

import com.webcodepro.applecommander.storage.DiskCorruptException;
import com.webcodepro.applecommander.storage.DiskException;
import com.webcodepro.applecommander.storage.FormattedDisk;
import com.webcodepro.applecommander.ui.UiBundle;
import com.webcodepro.applecommander.ui.swt.DiskExplorerTab;
import com.webcodepro.applecommander.ui.swt.DiskInfoTab;
import com.webcodepro.applecommander.ui.swt.DiskMapTab;
import com.webcodepro.applecommander.ui.swt.util.ImageManager;
import com.webcodepro.applecommander.util.TextBundle;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;

public class DiskWindow {
    private Shell parentShell;
    private ImageManager imageManager;
    private Shell shell;
    private FormattedDisk[] disks;
    private DiskInfoTab diskInfoTab;
    private DiskMapTab[] diskMapTabs;
    private TextBundle textBundle = UiBundle.getInstance();

    public DiskWindow(Shell parentShell, FormattedDisk[] disks, ImageManager imageManager) {
        this.parentShell = this.shell;
        this.disks = disks;
        this.imageManager = imageManager;
    }

    public void open() {
        this.shell = new Shell(this.parentShell, 1264);
        this.shell.setLayout(new FillLayout());
        this.shell.setImage(this.imageManager.get("diskicon.gif"));
        this.setStandardWindowTitle();
        this.shell.addDisposeListener(new DisposeListener(){

            @Override
            public void widgetDisposed(DisposeEvent event) {
                DiskWindow.this.dispose(event);
            }
        });
        CTabFolder tabFolder = new CTabFolder(this.shell, 1024);
        new DiskExplorerTab(tabFolder, this.disks, this.imageManager, this);
        this.diskMapTabs = new DiskMapTab[this.disks.length];
        for (int i = 0; i < this.disks.length; ++i) {
            if (!this.disks[i].supportsDiskMap()) continue;
            this.diskMapTabs[i] = new DiskMapTab(tabFolder, this.disks[i]);
        }
        this.diskInfoTab = new DiskInfoTab(tabFolder, this.disks);
        tabFolder.setSelection(tabFolder.getItems()[0]);
        this.shell.open();
    }

    protected void handle(DiskCorruptException e) {
        Shell finalShell = this.shell;
        MessageBox box = new MessageBox(finalShell, 33);
        box.setText(this.textBundle.get("SwtAppleCommander." + (Object)((Object)e.kind) + ".Title"));
        box.setMessage(this.textBundle.format("SwtAppleCommander.DiskCorruptException.Message", e.imagepath));
        box.open();
    }

    protected void handle(DiskException e) {
        if (e instanceof DiskCorruptException) {
            this.handle((DiskCorruptException)e);
            return;
        }
        MessageBox box = new MessageBox(this.shell, 33);
        box.setText(this.textBundle.get("SwtAppleCommander.DiskException.Title"));
        box.setMessage(this.textBundle.format("SwtAppleCommander.DiskException.Message", new Object[]{e.imagepath, e.toString()}));
        box.open();
    }

    public void handle(Exception e) {
        TextBundle textBundle = UiBundle.getInstance();
        Shell finalShell = this.shell;
        MessageBox box = new MessageBox(finalShell, 33);
        box.setText(textBundle.get("SwtAppleCommander.UnexpectedErrorTitle"));
        box.setMessage(textBundle.get("SwtAppleCommander.UnexpectedErrorMessage"));
        box.open();
        e.printStackTrace();
    }

    public void setStandardWindowTitle() {
        this.shell.setText(UiBundle.getInstance().format("DiskWindow.Title", this.disks[0].getFilename()));
    }

    protected void dispose(DisposeEvent event) {
        for (int i = 0; i < this.diskMapTabs.length; ++i) {
            if (this.diskMapTabs[i] == null) continue;
            this.diskMapTabs[i].dispose();
        }
        this.diskInfoTab.dispose();
        this.disks = null;
        this.diskMapTabs = null;
        this.diskInfoTab = null;
        System.gc();
    }
}

