/*
 * Decompiled with CFR 0.152.
 */
package com.webcodepro.applecommander.ui.swt;

import com.webcodepro.applecommander.storage.FormattedDisk;
import com.webcodepro.applecommander.ui.UiBundle;
import com.webcodepro.applecommander.util.TextBundle;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;

public class DiskMapTab {
    private FormattedDisk disk;
    private TextBundle textBundle = UiBundle.getInstance();
    private Color freeFill;
    private Color usedFill;
    private Color black;
    private Color gray;

    public DiskMapTab(CTabFolder tabFolder, FormattedDisk disk) {
        this.disk = disk;
        this.freeFill = new Color(tabFolder.getDisplay(), 100, 200, 100);
        this.usedFill = new Color(tabFolder.getDisplay(), 200, 100, 100);
        this.black = new Color(tabFolder.getDisplay(), 0, 0, 0);
        this.gray = new Color(tabFolder.getDisplay(), 50, 50, 50);
        this.createDiskMapTab(tabFolder);
    }

    protected void createDiskMapTab(CTabFolder tabFolder) {
        CTabItem item = new CTabItem(tabFolder, 0);
        if (this.disk.getLogicalDiskNumber() > 0) {
            item.setText(this.textBundle.get("DiskMapTab.MultipleTabsTitle") + this.disk.getLogicalDiskNumber());
        } else {
            item.setText(this.textBundle.get("DiskMapTab.SingleTabTitle"));
        }
        Canvas canvas = new Canvas(tabFolder, 0);
        GridLayout grid = new GridLayout(2, false);
        canvas.setLayout(grid);
        item.setControl(canvas);
        String[] labels = this.disk.getBitmapLabels();
        GridData data = new GridData(768);
        data.horizontalSpan = 2;
        data.heightHint = 20;
        Label title = new Label(canvas, 16384);
        StringBuffer buf = new StringBuffer();
        if (labels.length == 1) {
            buf.append(this.textBundle.format("DiskMapTab.BlockDecriptiveLabel", labels[0].toLowerCase()));
        } else {
            buf.append(this.textBundle.format("DiskMapTab.TrackAndSectorDecriptiveLabel", new Object[]{labels[0].toLowerCase(), labels[1].toLowerCase()}));
        }
        title.setText(buf.toString());
        title.setLayoutData(data);
        data = new GridData();
        data.heightHint = 20;
        data.widthHint = 20;
        Composite blank = new Composite(canvas, 0);
        blank.setLayoutData(data);
        data = new GridData(256);
        data.heightHint = 20;
        Canvas ruler = new Canvas(canvas, 0);
        ruler.addPaintListener(new PaintListener(){

            @Override
            public void paintControl(PaintEvent event) {
                DiskMapTab.this.paintHorizontalRuler(event);
            }
        });
        ruler.setLayoutData(data);
        data = new GridData(16);
        data.widthHint = 20;
        ruler = new Canvas(canvas, 0);
        ruler.addPaintListener(new PaintListener(){

            @Override
            public void paintControl(PaintEvent event) {
                DiskMapTab.this.paintVerticalRuler(event);
            }
        });
        ruler.setLayoutData(data);
        data = new GridData(1808);
        data.grabExcessHorizontalSpace = true;
        data.grabExcessVerticalSpace = true;
        Canvas map = new Canvas(canvas, 2048);
        map.addPaintListener(new PaintListener(){

            @Override
            public void paintControl(PaintEvent event) {
                DiskMapTab.this.paintMap(event);
            }
        });
        map.setLayoutData(data);
        data = new GridData(768);
        data.heightHint = 20;
        data.horizontalSpan = 2;
        Canvas legend = new Canvas(canvas, 0);
        legend.addPaintListener(new PaintListener(){

            @Override
            public void paintControl(PaintEvent event) {
                DiskMapTab.this.paintLegend(event);
            }
        });
        legend.setLayoutData(data);
    }

    public void dispose() {
        this.freeFill.dispose();
        this.usedFill.dispose();
        this.black.dispose();
        this.gray.dispose();
    }

    protected void paintHorizontalRuler(PaintEvent event) {
        String label = (this.disk.getBitmapLabels()[0] + "s").toUpperCase();
        Canvas canvas = (Canvas)event.widget;
        Rectangle area = canvas.getClientArea();
        event.gc.drawLine(area.x, area.y + area.height / 2, area.x + area.width, area.y + area.height / 2);
        Point size = event.gc.textExtent(label);
        event.gc.drawString(label, area.x + area.width / 2 - size.x, area.y + area.height / 2 - size.y / 2);
    }

    protected void paintVerticalRuler(PaintEvent event) {
        String label = (this.disk.getBitmapLabels()[0] + "s").toUpperCase();
        if (this.disk.getBitmapLabels().length == 2) {
            label = (this.disk.getBitmapLabels()[1] + "s").toUpperCase();
        }
        StringBuffer buf = new StringBuffer();
        for (int i = 0; i < label.length(); ++i) {
            if (i > 0) {
                buf.append("\n");
            }
            buf.append(label.charAt(i));
        }
        label = buf.toString();
        Canvas canvas = (Canvas)event.widget;
        Rectangle area = canvas.getClientArea();
        event.gc.drawLine(area.x + area.width / 2, area.y, area.x + area.width / 2, area.y + area.height);
        Point size = event.gc.textExtent(label);
        event.gc.drawText(label, area.x + area.width / 2 - size.x / 2, area.y + area.height / 2 - size.y / 2);
    }

    protected void paintMap(PaintEvent event) {
        if (this.disk.getDiskUsage() == null) {
            this.paintNoMap(event);
        } else if (this.disk.getBitmapDimensions() == null) {
            this.paintBlockMap(event);
        } else {
            this.paintSectorMap(event);
        }
    }

    protected void paintLegend(PaintEvent event) {
        Color background = event.gc.getBackground();
        Canvas canvas = (Canvas)event.widget;
        int height = event.gc.getFontMetrics().getHeight();
        String freeText = this.textBundle.get("DiskMapTab.FreeLegend");
        String usedText = this.textBundle.get("DiskMapTab.UsedLegend");
        int padding = 50;
        int totalWidth = (height + 5) * 2 + event.gc.textExtent((String)freeText).x + event.gc.textExtent((String)usedText).x;
        int offset = canvas.getClientArea().width / 2 - totalWidth;
        Rectangle box = new Rectangle(offset, 0, height, height);
        this.drawBox(box, event.gc, this.freeFill, this.black, this.gray);
        event.gc.setBackground(background);
        event.gc.drawText(freeText, offset += height, 0);
        offset += event.gc.textExtent((String)freeText).x;
        box = new Rectangle(offset += padding, 0, height, height);
        this.drawBox(box, event.gc, this.usedFill, this.black, this.gray);
        event.gc.setBackground(background);
        event.gc.drawText(usedText, offset += height, 0);
    }

    private void paintNoMap(PaintEvent event) {
        event.gc.drawString(this.textBundle.get("DiskMapTab.DiskMapUnavailableMessage"), 0, 0);
    }

    private void paintSectorMap(PaintEvent event) {
        int[] dimensions = this.disk.getBitmapDimensions();
        int ydim = dimensions[1];
        int xdim = dimensions[0];
        this.paintDiskMap(xdim, ydim, event);
    }

    private void paintBlockMap(PaintEvent event) {
        int ydim;
        double height;
        Canvas canvas = (Canvas)event.widget;
        Rectangle area = canvas.getClientArea();
        double width = area.width;
        double blocks = this.disk.getBitmapLength();
        double factor = Math.sqrt(blocks / (width * (height = (double)area.height)));
        int xdim = (int)(width * factor + 0.5);
        if ((double)(xdim * (ydim = (int)(height * factor + 0.5))) < blocks) {
            ++xdim;
        }
        if ((double)(xdim * ydim) < blocks) {
            ++ydim;
        }
        this.paintDiskMap(xdim, ydim, event);
    }

    private void paintDiskMap(int xdim, int ydim, PaintEvent event) {
        Canvas canvas = (Canvas)event.widget;
        Rectangle area = canvas.getClientArea();
        area.width -= 2;
        area.height -= 2;
        int[] ypos = new int[ydim + 1];
        for (int i = 0; i < ydim; ++i) {
            ypos[i] = i * area.height / ydim + 1;
        }
        ypos[ydim] = area.height;
        int[] xpos = new int[xdim + 1];
        for (int i = 0; i < xdim; ++i) {
            xpos[i] = i * area.width / xdim + 1;
        }
        xpos[xdim] = area.width;
        Image image = new Image((Device)canvas.getDisplay(), area);
        GC gc = new GC(image);
        int x = 0;
        int y = 0;
        FormattedDisk.DiskUsage usage = this.disk.getDiskUsage();
        for (x = 0; x < xdim && usage.hasNext(); ++x) {
            for (y = 0; y < ydim && usage.hasNext(); ++y) {
                usage.next();
                boolean free = usage.isFree();
                Rectangle box = new Rectangle(xpos[x], ypos[y], xpos[x + 1] - xpos[x], ypos[y + 1] - ypos[y]);
                this.drawBox(box, gc, free ? this.freeFill : this.usedFill, this.black, this.gray);
            }
        }
        event.gc.drawImage(image, 0, 0);
        gc.dispose();
        image.dispose();
    }

    protected void drawBox(Rectangle box, GC gc, Color fill, Color outline, Color shadow) {
        if (box.width >= 10 && box.height >= 10) {
            int size = Math.min(box.height, box.width);
            box.height = size + (box.height - size) / 2;
            box.width = size + (box.width - size) / 2;
            box.x += 2;
            box.y += 2;
            box.width -= 5;
            box.height -= 5;
            gc.setBackground(shadow);
            gc.fillRectangle(box);
            box.x -= 2;
            box.y -= 2;
            gc.setBackground(fill);
            gc.fillRectangle(box);
            gc.setForeground(outline);
            gc.drawRectangle(box);
        } else {
            gc.setBackground(fill);
            gc.fillRectangle(box);
        }
    }
}

